{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetActiveLayer: Integer;
    procedure SetActiveLayer(const Value: Integer);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdActiveLayer: TSFInt32;
    { Internal wrapper for property @code(ActiveLayer). This wrapper API may change, we advise to access simpler @code(ActiveLayer) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdActiveLayer: TSFInt32 read FFdActiveLayer;
    {  }
    property ActiveLayer: Integer read GetActiveLayer write SetActiveLayer;

    strict private FFdLayers: TMFNode;
    { Internal wrapper for property @code(Layers). This wrapper API may change, we advise to access simpler @code(Layers) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLayers: TMFNode read FFdLayers;
    {  }
    procedure SetLayers(const Value: array of TAbstractLayerNode);

    strict private FFdOrder: TMFInt32;
    { Internal wrapper for property @code(Order). This wrapper API may change, we advise to access simpler @code(Order) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOrder: TMFInt32 read FFdOrder;
    {  }
    procedure SetOrder(const Value: array of Int32); overload;
    {  }
    procedure SetOrder(const Value: TInt32List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TLayerSetNode ----------------------------------------------- }

function TLayerSetNode.GetActiveLayer: Integer;
begin
  Result := FdActiveLayer.Value;
end;

procedure TLayerSetNode.SetActiveLayer(const Value: Integer);
begin
  FdActiveLayer.Send(Value);
end;

procedure TLayerSetNode.SetLayers(const Value: array of TAbstractLayerNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractLayerNode));
  FdLayers.Send(A);
end;

procedure TLayerSetNode.SetOrder(const Value: array of Int32);
begin
  FdOrder.Send(Value);
end;

procedure TLayerSetNode.SetOrder(const Value: TInt32List);
begin
  FdOrder.Send(Value);
end;

class function TLayerSetNode.ClassX3DType: String;
begin
  Result := 'LayerSet';
end;

procedure TLayerSetNode.CreateNode;
begin
  inherited;

  FFdActiveLayer := TSFInt32.Create(Self, True, 'activeLayer', 0);
   FdActiveLayer.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdActiveLayer);

  FFdLayers := TMFNode.Create(Self, True, 'layers', [TAbstractLayerNode]);
   FdLayers.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLayers);

  FFdOrder := TMFInt32.Create(Self, True, 'order', [0]);
   FdOrder.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOrder);

  DefaultContainerField := 'children';
end;

{$endif read_implementation}
