# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Apply some recent ``task_data`` migrations to ``configured_task_data``."""

from django.db import migrations

from debusine.artifacts.models import TaskTypes
from debusine.db.migrations._utils import make_data_field_renamer

# Same as in 0028_rename_arch_all_build_architecture.
affected_workflows = {
    "autopkgtest",
    "blhc",
    "debdiff",
    "debian_pipeline",
    "lintian",
    "package_upload",
    "piuparts",
    "qa",
    "reverse_dependencies_autopkgtest",
    "sbuild",
}


class Migration(migrations.Migration):

    dependencies = [
        ("db", "0030_rename_more_build_architecture"),
    ]

    operations = [
        make_data_field_renamer(
            "WorkRequest",
            "configured_task_data",
            {"task_type": TaskTypes.WORKFLOW, "task_name": "debian_pipeline"},
            [("publish_target", "suite")],
        ),
        make_data_field_renamer(
            "WorkRequest",
            "configured_task_data",
            {
                "task_type": TaskTypes.WORKFLOW,
                "task_name__in": affected_workflows,
            },
            [("arch_all_host_architecture", "arch_all_build_architecture")],
        ),
    ]
