/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import java.util.Hashtable;
import java.util.Vector;

public class HiddenSequences {
    public SequenceI[] hiddenSequences;
    AlignmentI alignment;

    public HiddenSequences(AlignmentI al) {
        this.alignment = al;
    }

    public int getSize() {
        if (this.hiddenSequences == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.hiddenSequences.length; ++i) {
            if (this.hiddenSequences[i] == null) continue;
            ++count;
        }
        return count;
    }

    public int getWidth() {
        int width = 0;
        for (int i = 0; i < this.hiddenSequences.length; ++i) {
            if (this.hiddenSequences[i] == null || this.hiddenSequences[i].getLength() <= width) continue;
            width = this.hiddenSequences[i].getLength();
        }
        return width;
    }

    public void adjustHeightSequenceDeleted(int seqIndex) {
        if (this.hiddenSequences == null) {
            return;
        }
        int alHeight = this.alignment.getHeight();
        SequenceI[] tmp = new SequenceI[alHeight + this.getSize()];
        int deletionIndex = this.adjustForHiddenSeqs(seqIndex);
        for (int i = 0; i < this.hiddenSequences.length; ++i) {
            if (this.hiddenSequences[i] == null) continue;
            if (i > deletionIndex) {
                tmp[i - 1] = this.hiddenSequences[i];
                continue;
            }
            tmp[i] = this.hiddenSequences[i];
        }
        this.hiddenSequences = tmp;
    }

    public void adjustHeightSequenceAdded() {
        if (this.hiddenSequences == null) {
            return;
        }
        int alHeight = this.alignment.getHeight();
        SequenceI[] tmp = new SequenceI[alHeight + this.getSize()];
        System.arraycopy(this.hiddenSequences, 0, tmp, 0, this.hiddenSequences.length);
        this.hiddenSequences = tmp;
    }

    public void hideSequence(SequenceI sequence) {
        if (this.hiddenSequences == null) {
            this.hiddenSequences = new SequenceI[this.alignment.getHeight()];
        }
        int alignmentIndex = this.alignment.findIndex(sequence);
        if (this.hiddenSequences[alignmentIndex = this.adjustForHiddenSeqs(alignmentIndex)] != null) {
            System.out.println("ERROR!!!!!!!!!!!");
        }
        this.hiddenSequences[alignmentIndex] = sequence;
        this.alignment.deleteSequence(sequence);
    }

    public Vector showAll(Hashtable hiddenReps) {
        Vector revealedSeqs = new Vector();
        for (int i = 0; i < this.hiddenSequences.length; ++i) {
            if (this.hiddenSequences[i] == null) continue;
            Vector tmp = this.showSequence(i, hiddenReps);
            for (int t = 0; t < tmp.size(); ++t) {
                revealedSeqs.addElement(tmp.elementAt(t));
            }
        }
        return revealedSeqs;
    }

    public Vector showSequence(int alignmentIndex, Hashtable hiddenReps) {
        Vector<SequenceI> revealedSeqs = new Vector<SequenceI>();
        SequenceI repSequence = this.alignment.getSequenceAt(alignmentIndex);
        if (repSequence != null && hiddenReps != null && hiddenReps.containsKey(repSequence)) {
            hiddenReps.remove(repSequence);
            revealedSeqs.addElement(repSequence);
        }
        int start = this.adjustForHiddenSeqs(alignmentIndex - 1);
        int end = this.adjustForHiddenSeqs(alignmentIndex);
        if (end >= this.hiddenSequences.length) {
            end = this.hiddenSequences.length - 1;
        }
        for (int index = end; index > start; --index) {
            SequenceI seq = this.hiddenSequences[index];
            this.hiddenSequences[index] = null;
            if (seq == null) continue;
            if (seq.getLength() > 0) {
                revealedSeqs.addElement(seq);
                this.alignment.getSequences().insertElementAt(seq, alignmentIndex);
                continue;
            }
            System.out.println(seq.getName() + " has been deleted whilst hidden");
        }
        return revealedSeqs;
    }

    public SequenceI getHiddenSequence(int alignmentIndex) {
        return this.hiddenSequences[alignmentIndex];
    }

    public int findIndexWithoutHiddenSeqs(int alignmentIndex) {
        int index = 0;
        int hiddenSeqs = 0;
        if (this.hiddenSequences.length <= alignmentIndex) {
            alignmentIndex = this.hiddenSequences.length - 1;
        }
        while (index <= alignmentIndex) {
            if (this.hiddenSequences[index] != null) {
                ++hiddenSeqs;
            }
            ++index;
        }
        return alignmentIndex - hiddenSeqs;
    }

    public int adjustForHiddenSeqs(int alignmentIndex) {
        int hSize = this.hiddenSequences.length;
        for (int index = 0; index <= alignmentIndex && index < hSize; ++index) {
            if (this.hiddenSequences[index] == null) continue;
            ++alignmentIndex;
        }
        return alignmentIndex;
    }

    public AlignmentI getFullAlignment() {
        int isize = this.hiddenSequences.length;
        SequenceI[] seq = new Sequence[isize];
        int index = 0;
        for (int i = 0; i < this.hiddenSequences.length; ++i) {
            if (this.hiddenSequences[i] != null) {
                seq[i] = this.hiddenSequences[i];
                continue;
            }
            seq[i] = this.alignment.getSequenceAt(index);
            ++index;
        }
        return new Alignment(seq);
    }

    public boolean isHidden(SequenceI seq) {
        for (int i = 0; i < this.hiddenSequences.length; ++i) {
            if (this.hiddenSequences[i] == null || this.hiddenSequences[i] != seq) continue;
            return true;
        }
        return false;
    }
}

