package batchai

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/batchai/mgmt/2018-05-01/batchai"

// AppInsightsReference azure Application Insights information for performance counters reporting.
type AppInsightsReference struct {
	// Component - Azure Application Insights component resource ID.
	Component *ResourceID `json:"component,omitempty"`
	// InstrumentationKey - Value of the Azure Application Insights instrumentation key.
	InstrumentationKey *string `json:"instrumentationKey,omitempty"`
	// InstrumentationKeySecretReference - KeyVault Store and Secret which contains Azure Application Insights instrumentation key. One of instrumentationKey or instrumentationKeySecretReference must be specified.
	InstrumentationKeySecretReference *KeyVaultSecretReference `json:"instrumentationKeySecretReference,omitempty"`
}

// AutoScaleSettings auto-scale settings for the cluster. The system automatically scales the cluster up
// and down (within minimumNodeCount and maximumNodeCount) based on the number of queued and running jobs
// assigned to the cluster.
type AutoScaleSettings struct {
	// MinimumNodeCount - The minimum number of compute nodes the Batch AI service will try to allocate for the cluster. Note, the actual number of nodes can be less than the specified value if the subscription has not enough quota to fulfill the request.
	MinimumNodeCount *int32 `json:"minimumNodeCount,omitempty"`
	// MaximumNodeCount - The maximum number of compute nodes the cluster can have.
	MaximumNodeCount *int32 `json:"maximumNodeCount,omitempty"`
	// InitialNodeCount - The number of compute nodes to allocate on cluster creation. Note that this value is used only during cluster creation. Default: 0.
	InitialNodeCount *int32 `json:"initialNodeCount,omitempty"`
}

// AzureBlobFileSystemReference azure Blob Storage Container mounting configuration.
type AzureBlobFileSystemReference struct {
	// AccountName - Name of the Azure storage account.
	AccountName *string `json:"accountName,omitempty"`
	// ContainerName - Name of the Azure Blob Storage container to mount on the cluster.
	ContainerName *string `json:"containerName,omitempty"`
	// Credentials - Information about the Azure storage credentials.
	Credentials *AzureStorageCredentialsInfo `json:"credentials,omitempty"`
	// RelativeMountPath - The relative path on the compute node where the Azure File container will be mounted. Note that all cluster level containers will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level containers will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// MountOptions - Mount options for mounting blobfuse file system.
	MountOptions *string `json:"mountOptions,omitempty"`
}

// AzureFileShareReference azure File Share mounting configuration.
type AzureFileShareReference struct {
	// AccountName - Name of the Azure storage account.
	AccountName *string `json:"accountName,omitempty"`
	// AzureFileURL - URL to access the Azure File.
	AzureFileURL *string `json:"azureFileUrl,omitempty"`
	// Credentials - Information about the Azure storage credentials.
	Credentials *AzureStorageCredentialsInfo `json:"credentials,omitempty"`
	// RelativeMountPath - The relative path on the compute node where the Azure File share will be mounted. Note that all cluster level file shares will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level file shares will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// FileMode - File mode for files on the mounted file share. Default value: 0777.
	FileMode *string `json:"fileMode,omitempty"`
	// DirectoryMode - File mode for directories on the mounted file share. Default value: 0777.
	DirectoryMode *string `json:"directoryMode,omitempty"`
}

// AzureStorageCredentialsInfo azure storage account credentials.
type AzureStorageCredentialsInfo struct {
	// AccountKey - Storage account key. One of accountKey or accountKeySecretReference must be specified.
	AccountKey *string `json:"accountKey,omitempty"`
	// AccountKeySecretReference - Information about KeyVault secret storing the storage account key. One of accountKey or accountKeySecretReference must be specified.
	AccountKeySecretReference *KeyVaultSecretReference `json:"accountKeySecretReference,omitempty"`
}

// Caffe2Settings caffe2 job settings.
type Caffe2Settings struct {
	// PythonScriptFilePath - The python script to execute.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - The path to the Python interpreter.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	// CommandLineArgs - Command line arguments that need to be passed to the python script.
	CommandLineArgs *string `json:"commandLineArgs,omitempty"`
}

// CaffeSettings caffe job settings.
type CaffeSettings struct {
	// ConfigFilePath - Path of the config file for the job. This property cannot be specified if pythonScriptFilePath is specified.
	ConfigFilePath *string `json:"configFilePath,omitempty"`
	// PythonScriptFilePath - Python script to execute. This property cannot be specified if configFilePath is specified.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - The path to the Python interpreter. The property can be specified only if the pythonScriptFilePath is specified.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	// CommandLineArgs - Command line arguments that need to be passed to the Caffe job.
	CommandLineArgs *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - Number of processes to launch for the job execution. The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// ChainerSettings chainer job settings.
type ChainerSettings struct {
	// PythonScriptFilePath - The python script to execute.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - The path to the Python interpreter.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	// CommandLineArgs - Command line arguments that need to be passed to the python script.
	CommandLineArgs *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - Number of processes to launch for the job execution. The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// CloudError an error response from the Batch AI service.
type CloudError struct {
	// Error - READ-ONLY; An error response from the Batch AI service.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudErrorBody an error response from the Batch AI service.
type CloudErrorBody struct {
	// Code - READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudErrorBody.
func (ceb CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Cluster information about a Cluster.
type Cluster struct {
	autorest.Response `json:"-"`
	// ClusterProperties - The properties associated with the Cluster.
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterBaseProperties the properties of a Cluster.
type ClusterBaseProperties struct {
	// VMSize - The size of the virtual machines in the cluster. All nodes in a cluster have the same VM size. For information about available VM sizes for clusters using images from the Virtual Machines Marketplace see Sizes for Virtual Machines (Linux). Batch AI service supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// VMPriority - VM priority. Allowed values are: dedicated (default) and lowpriority. Possible values include: 'Dedicated', 'Lowpriority'
	VMPriority VMPriority `json:"vmPriority,omitempty"`
	// ScaleSettings - Scale settings for the cluster. Batch AI service supports manual and auto scale clusters.
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
	// VirtualMachineConfiguration - OS image configuration for cluster nodes. All nodes in a cluster have the same OS image.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// NodeSetup - Setup to be performed on each compute node in the cluster.
	NodeSetup *NodeSetup `json:"nodeSetup,omitempty"`
	// UserAccountSettings - Settings for an administrator user account that will be created on each compute node in the cluster.
	UserAccountSettings *UserAccountSettings `json:"userAccountSettings,omitempty"`
	// Subnet - Existing virtual network subnet to put the cluster nodes in. Note, if a File Server mount configured in node setup, the File Server's subnet will be used automatically.
	Subnet *ResourceID `json:"subnet,omitempty"`
}

// ClusterCreateParameters cluster creation operation.
type ClusterCreateParameters struct {
	// ClusterBaseProperties - The properties of the Cluster.
	*ClusterBaseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterCreateParameters.
func (ccp ClusterCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.ClusterBaseProperties != nil {
		objectMap["properties"] = ccp.ClusterBaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterCreateParameters struct.
func (ccp *ClusterCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterBaseProperties ClusterBaseProperties
				err = json.Unmarshal(*v, &clusterBaseProperties)
				if err != nil {
					return err
				}
				ccp.ClusterBaseProperties = &clusterBaseProperties
			}
		}
	}

	return nil
}

// ClusterListResult values returned by the List Clusters operation.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The collection of returned Clusters.
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterListResult.
func (clr ClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListResultIterator type.
func NewClusterListResultIterator(page ClusterListResultPage) ClusterListResultIterator {
	return ClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr ClusterListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(context.Context, ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the ClusterListResultPage type.
func NewClusterListResultPage(cur ClusterListResult, getNextPage func(context.Context, ClusterListResult) (ClusterListResult, error)) ClusterListResultPage {
	return ClusterListResultPage{
		fn:  getNextPage,
		clr: cur,
	}
}

// ClusterProperties cluster properties.
type ClusterProperties struct {
	// VMSize - The size of the virtual machines in the cluster. All nodes in a cluster have the same VM size.
	VMSize *string `json:"vmSize,omitempty"`
	// VMPriority - VM priority of cluster nodes. Possible values include: 'Dedicated', 'Lowpriority'
	VMPriority VMPriority `json:"vmPriority,omitempty"`
	// ScaleSettings - Scale settings of the cluster.
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
	// VirtualMachineConfiguration - Virtual machine configuration (OS image) of the compute nodes. All nodes in a cluster have the same OS image configuration.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// NodeSetup - Setup (mount file systems, performance counters settings and custom setup task) to be performed on each compute node in the cluster.
	NodeSetup *NodeSetup `json:"nodeSetup,omitempty"`
	// UserAccountSettings - Administrator user account settings which can be used to SSH to compute nodes.
	UserAccountSettings *UserAccountSettings `json:"userAccountSettings,omitempty"`
	// Subnet - Virtual network subnet resource ID the cluster nodes belong to.
	Subnet *ResourceID `json:"subnet,omitempty"`
	// CreationTime - READ-ONLY; The time when the cluster was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the cluster. Possible value are: creating - Specifies that the cluster is being created. succeeded - Specifies that the cluster has been created successfully. failed - Specifies that the cluster creation has failed. deleting - Specifies that the cluster is being deleted. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY; Time when the provisioning state was changed.
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
	// AllocationState - READ-ONLY; Allocation state of the cluster. Possible values are: steady - Indicates that the cluster is not resizing. There are no changes to the number of compute nodes in the cluster in progress. A cluster enters this state when it is created and when no operations are being performed on the cluster to change the number of compute nodes. resizing - Indicates that the cluster is resizing; that is, compute nodes are being added to or removed from the cluster. Possible values include: 'Steady', 'Resizing'
	AllocationState AllocationState `json:"allocationState,omitempty"`
	// AllocationStateTransitionTime - READ-ONLY; The time at which the cluster entered its current allocation state.
	AllocationStateTransitionTime *date.Time `json:"allocationStateTransitionTime,omitempty"`
	// Errors - READ-ONLY; Collection of errors encountered by various compute nodes during node setup.
	Errors *[]Error `json:"errors,omitempty"`
	// CurrentNodeCount - READ-ONLY; The number of compute nodes currently assigned to the cluster.
	CurrentNodeCount *int32 `json:"currentNodeCount,omitempty"`
	// NodeStateCounts - READ-ONLY; Counts of various node states on the cluster.
	NodeStateCounts *NodeStateCounts `json:"nodeStateCounts,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.VMSize != nil {
		objectMap["vmSize"] = cp.VMSize
	}
	if cp.VMPriority != "" {
		objectMap["vmPriority"] = cp.VMPriority
	}
	if cp.ScaleSettings != nil {
		objectMap["scaleSettings"] = cp.ScaleSettings
	}
	if cp.VirtualMachineConfiguration != nil {
		objectMap["virtualMachineConfiguration"] = cp.VirtualMachineConfiguration
	}
	if cp.NodeSetup != nil {
		objectMap["nodeSetup"] = cp.NodeSetup
	}
	if cp.UserAccountSettings != nil {
		objectMap["userAccountSettings"] = cp.UserAccountSettings
	}
	if cp.Subnet != nil {
		objectMap["subnet"] = cp.Subnet
	}
	return json.Marshal(objectMap)
}

// ClustersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (Cluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateFuture.Result.
func (future *ClustersCreateFuture) result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.ClustersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		c.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.ClustersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.ClustersCreateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClusterUpdateParameters cluster update parameters.
type ClusterUpdateParameters struct {
	// ClusterUpdateProperties - The properties of the Cluster.
	*ClusterUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpdateParameters.
func (cup ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.ClusterUpdateProperties != nil {
		objectMap["properties"] = cup.ClusterUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdateParameters struct.
func (cup *ClusterUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterUpdateProperties ClusterUpdateProperties
				err = json.Unmarshal(*v, &clusterUpdateProperties)
				if err != nil {
					return err
				}
				cup.ClusterUpdateProperties = &clusterUpdateProperties
			}
		}
	}

	return nil
}

// ClusterUpdateProperties the properties of a Cluster that need to be updated.
type ClusterUpdateProperties struct {
	// ScaleSettings - Desired scale settings for the cluster. Batch AI service supports manual and auto scale clusters.
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
}

// CNTKsettings CNTK (aka Microsoft Cognitive Toolkit) job settings.
type CNTKsettings struct {
	// LanguageType - The language to use for launching CNTK (aka Microsoft Cognitive Toolkit) job. Valid values are 'BrainScript' or 'Python'.
	LanguageType *string `json:"languageType,omitempty"`
	// ConfigFilePath - Specifies the path of the BrainScript config file. This property can be specified only if the languageType is 'BrainScript'.
	ConfigFilePath *string `json:"configFilePath,omitempty"`
	// PythonScriptFilePath - Python script to execute. This property can be specified only if the languageType is 'Python'.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - The path to the Python interpreter. This property can be specified only if the languageType is 'Python'.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	// CommandLineArgs - Command line arguments that need to be passed to the python script or cntk executable.
	CommandLineArgs *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - Number of processes to launch for the job execution. The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// ContainerSettings docker container settings.
type ContainerSettings struct {
	// ImageSourceRegistry - Information about docker image and docker registry to download the container from.
	ImageSourceRegistry *ImageSourceRegistry `json:"imageSourceRegistry,omitempty"`
	// ShmSize - Size of /dev/shm. Please refer to docker documentation for supported argument formats.
	ShmSize *string `json:"shmSize,omitempty"`
}

// CustomMpiSettings custom MPI job settings.
type CustomMpiSettings struct {
	// CommandLine - The command line to be executed by mpi runtime on each compute node.
	CommandLine *string `json:"commandLine,omitempty"`
	// ProcessCount - Number of processes to launch for the job execution. The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// CustomToolkitSettings custom tool kit job settings.
type CustomToolkitSettings struct {
	// CommandLine - The command line to execute on the master node.
	CommandLine *string `json:"commandLine,omitempty"`
}

// DataDisks data disks settings.
type DataDisks struct {
	// DiskSizeInGB - Disk size in GB for the blank data disks.
	DiskSizeInGB *int32 `json:"diskSizeInGB,omitempty"`
	// CachingType - Caching type for the disks. Available values are none (default), readonly, readwrite. Caching type can be set only for VM sizes supporting premium storage. Possible values include: 'None', 'Readonly', 'Readwrite'
	CachingType CachingType `json:"cachingType,omitempty"`
	// DiskCount - Number of data disks attached to the File Server. If multiple disks attached, they will be configured in RAID level 0.
	DiskCount *int32 `json:"diskCount,omitempty"`
	// StorageAccountType - Type of storage account to be used on the disk. Possible values are: Standard_LRS or Premium_LRS. Premium storage account type can only be used with VM sizes supporting premium storage. Possible values include: 'StandardLRS', 'PremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
}

// EnvironmentVariable an environment variable definition.
type EnvironmentVariable struct {
	// Name - The name of the environment variable.
	Name *string `json:"name,omitempty"`
	// Value - The value of the environment variable.
	Value *string `json:"value,omitempty"`
}

// EnvironmentVariableWithSecretValue an environment variable with secret value definition.
type EnvironmentVariableWithSecretValue struct {
	// Name - The name of the environment variable to store the secret value.
	Name *string `json:"name,omitempty"`
	// Value - The value of the environment variable. This value will never be reported back by Batch AI.
	Value *string `json:"value,omitempty"`
	// ValueSecretReference - KeyVault store and secret which contains the value for the environment variable. One of value or valueSecretReference must be provided.
	ValueSecretReference *KeyVaultSecretReference `json:"valueSecretReference,omitempty"`
}

// Error an error response from the Batch AI service.
type Error struct {
	// Code - READ-ONLY; An identifier of the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; A list of additional details about the error.
	Details *[]NameValuePair `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Experiment experiment information.
type Experiment struct {
	autorest.Response `json:"-"`
	// ExperimentProperties - The properties associated with the experiment.
	*ExperimentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Experiment.
func (e Experiment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.ExperimentProperties != nil {
		objectMap["properties"] = e.ExperimentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Experiment struct.
func (e *Experiment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var experimentProperties ExperimentProperties
				err = json.Unmarshal(*v, &experimentProperties)
				if err != nil {
					return err
				}
				e.ExperimentProperties = &experimentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		}
	}

	return nil
}

// ExperimentListResult values returned by the List operation.
type ExperimentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The collection of experiments.
	Value *[]Experiment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExperimentListResult.
func (elr ExperimentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExperimentListResultIterator provides access to a complete listing of Experiment values.
type ExperimentListResultIterator struct {
	i    int
	page ExperimentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExperimentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExperimentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExperimentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExperimentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExperimentListResultIterator) Response() ExperimentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExperimentListResultIterator) Value() Experiment {
	if !iter.page.NotDone() {
		return Experiment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExperimentListResultIterator type.
func NewExperimentListResultIterator(page ExperimentListResultPage) ExperimentListResultIterator {
	return ExperimentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr ExperimentListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (elr ExperimentListResult) hasNextLink() bool {
	return elr.NextLink != nil && len(*elr.NextLink) != 0
}

// experimentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr ExperimentListResult) experimentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !elr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// ExperimentListResultPage contains a page of Experiment values.
type ExperimentListResultPage struct {
	fn  func(context.Context, ExperimentListResult) (ExperimentListResult, error)
	elr ExperimentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExperimentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExperimentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.elr)
		if err != nil {
			return err
		}
		page.elr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExperimentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExperimentListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExperimentListResultPage) Response() ExperimentListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExperimentListResultPage) Values() []Experiment {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the ExperimentListResultPage type.
func NewExperimentListResultPage(cur ExperimentListResult, getNextPage func(context.Context, ExperimentListResult) (ExperimentListResult, error)) ExperimentListResultPage {
	return ExperimentListResultPage{
		fn:  getNextPage,
		elr: cur,
	}
}

// ExperimentProperties experiment properties.
type ExperimentProperties struct {
	// CreationTime - READ-ONLY; Time when the Experiment was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioned state of the experiment. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY; The time at which the experiment entered its current provisioning state.
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
}

// MarshalJSON is the custom marshaler for ExperimentProperties.
func (ep ExperimentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExperimentsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExperimentsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExperimentsClient) (Experiment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExperimentsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExperimentsCreateFuture.Result.
func (future *ExperimentsCreateFuture) result(client ExperimentsClient) (e Experiment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.ExperimentsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.ExperimentsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.ExperimentsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExperimentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExperimentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExperimentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExperimentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExperimentsDeleteFuture.Result.
func (future *ExperimentsDeleteFuture) result(client ExperimentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.ExperimentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.ExperimentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// File properties of the file or directory.
type File struct {
	// Name - READ-ONLY; Name of the file.
	Name *string `json:"name,omitempty"`
	// FileType - READ-ONLY; Type of the file. Possible values are file and directory. Possible values include: 'FileTypeFile', 'FileTypeDirectory'
	FileType FileType `json:"fileType,omitempty"`
	// DownloadURL - READ-ONLY; URL to download the corresponding file. The downloadUrl is not returned for directories.
	DownloadURL *string `json:"downloadUrl,omitempty"`
	// FileProperties - The properties associated with the file. The properties are not returned for directories.
	*FileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for File.
func (f File) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.FileProperties != nil {
		objectMap["properties"] = f.FileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for File struct.
func (f *File) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "fileType":
			if v != nil {
				var fileType FileType
				err = json.Unmarshal(*v, &fileType)
				if err != nil {
					return err
				}
				f.FileType = fileType
			}
		case "downloadUrl":
			if v != nil {
				var downloadURL string
				err = json.Unmarshal(*v, &downloadURL)
				if err != nil {
					return err
				}
				f.DownloadURL = &downloadURL
			}
		case "properties":
			if v != nil {
				var fileProperties FileProperties
				err = json.Unmarshal(*v, &fileProperties)
				if err != nil {
					return err
				}
				f.FileProperties = &fileProperties
			}
		}
	}

	return nil
}

// FileListResult values returned by the List operation.
type FileListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The collection of returned job directories and files.
	Value *[]File `json:"value,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FileListResult.
func (flr FileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FileListResultIterator provides access to a complete listing of File values.
type FileListResultIterator struct {
	i    int
	page FileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FileListResultIterator) Response() FileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FileListResultIterator) Value() File {
	if !iter.page.NotDone() {
		return File{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FileListResultIterator type.
func NewFileListResultIterator(page FileListResultPage) FileListResultIterator {
	return FileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (flr FileListResult) IsEmpty() bool {
	return flr.Value == nil || len(*flr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (flr FileListResult) hasNextLink() bool {
	return flr.NextLink != nil && len(*flr.NextLink) != 0
}

// fileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (flr FileListResult) fileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !flr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(flr.NextLink)))
}

// FileListResultPage contains a page of File values.
type FileListResultPage struct {
	fn  func(context.Context, FileListResult) (FileListResult, error)
	flr FileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.flr)
		if err != nil {
			return err
		}
		page.flr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FileListResultPage) NotDone() bool {
	return !page.flr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FileListResultPage) Response() FileListResult {
	return page.flr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FileListResultPage) Values() []File {
	if page.flr.IsEmpty() {
		return nil
	}
	return *page.flr.Value
}

// Creates a new instance of the FileListResultPage type.
func NewFileListResultPage(cur FileListResult, getNextPage func(context.Context, FileListResult) (FileListResult, error)) FileListResultPage {
	return FileListResultPage{
		fn:  getNextPage,
		flr: cur,
	}
}

// FileProperties file properties.
type FileProperties struct {
	// LastModified - READ-ONLY; The time at which the file was last modified.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// ContentLength - READ-ONLY; The file of the size.
	ContentLength *int64 `json:"contentLength,omitempty"`
}

// MarshalJSON is the custom marshaler for FileProperties.
func (fp FileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FileServer file Server information.
type FileServer struct {
	autorest.Response `json:"-"`
	// FileServerProperties - File Server properties.
	*FileServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServer.
func (fs FileServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.FileServerProperties != nil {
		objectMap["properties"] = fs.FileServerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileServer struct.
func (fs *FileServer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileServerProperties FileServerProperties
				err = json.Unmarshal(*v, &fileServerProperties)
				if err != nil {
					return err
				}
				fs.FileServerProperties = &fileServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fs.Type = &typeVar
			}
		}
	}

	return nil
}

// FileServerBaseProperties the properties of a file server.
type FileServerBaseProperties struct {
	// VMSize - The size of the virtual machine for the File Server. For information about available VM sizes from the Virtual Machines Marketplace, see Sizes for Virtual Machines (Linux).
	VMSize *string `json:"vmSize,omitempty"`
	// SSHConfiguration - SSH configuration for the File Server node.
	SSHConfiguration *SSHConfiguration `json:"sshConfiguration,omitempty"`
	// DataDisks - Settings for the data disks which will be created for the File Server.
	DataDisks *DataDisks `json:"dataDisks,omitempty"`
	// Subnet - Identifier of an existing virtual network subnet to put the File Server in. If not provided, a new virtual network and subnet will be created.
	Subnet *ResourceID `json:"subnet,omitempty"`
}

// FileServerCreateParameters file Server creation parameters.
type FileServerCreateParameters struct {
	// FileServerBaseProperties - The properties of the File Server.
	*FileServerBaseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServerCreateParameters.
func (fscp FileServerCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fscp.FileServerBaseProperties != nil {
		objectMap["properties"] = fscp.FileServerBaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileServerCreateParameters struct.
func (fscp *FileServerCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileServerBaseProperties FileServerBaseProperties
				err = json.Unmarshal(*v, &fileServerBaseProperties)
				if err != nil {
					return err
				}
				fscp.FileServerBaseProperties = &fileServerBaseProperties
			}
		}
	}

	return nil
}

// FileServerListResult values returned by the File Server List operation.
type FileServerListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of File Servers.
	Value *[]FileServer `json:"value,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServerListResult.
func (fslr FileServerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fslr.Value != nil {
		objectMap["value"] = fslr.Value
	}
	return json.Marshal(objectMap)
}

// FileServerListResultIterator provides access to a complete listing of FileServer values.
type FileServerListResultIterator struct {
	i    int
	page FileServerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FileServerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileServerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FileServerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FileServerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FileServerListResultIterator) Response() FileServerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FileServerListResultIterator) Value() FileServer {
	if !iter.page.NotDone() {
		return FileServer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FileServerListResultIterator type.
func NewFileServerListResultIterator(page FileServerListResultPage) FileServerListResultIterator {
	return FileServerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fslr FileServerListResult) IsEmpty() bool {
	return fslr.Value == nil || len(*fslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fslr FileServerListResult) hasNextLink() bool {
	return fslr.NextLink != nil && len(*fslr.NextLink) != 0
}

// fileServerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fslr FileServerListResult) fileServerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fslr.NextLink)))
}

// FileServerListResultPage contains a page of FileServer values.
type FileServerListResultPage struct {
	fn   func(context.Context, FileServerListResult) (FileServerListResult, error)
	fslr FileServerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FileServerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileServerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fslr)
		if err != nil {
			return err
		}
		page.fslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FileServerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FileServerListResultPage) NotDone() bool {
	return !page.fslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FileServerListResultPage) Response() FileServerListResult {
	return page.fslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FileServerListResultPage) Values() []FileServer {
	if page.fslr.IsEmpty() {
		return nil
	}
	return *page.fslr.Value
}

// Creates a new instance of the FileServerListResultPage type.
func NewFileServerListResultPage(cur FileServerListResult, getNextPage func(context.Context, FileServerListResult) (FileServerListResult, error)) FileServerListResultPage {
	return FileServerListResultPage{
		fn:   getNextPage,
		fslr: cur,
	}
}

// FileServerProperties file Server properties.
type FileServerProperties struct {
	// VMSize - VM size of the File Server.
	VMSize *string `json:"vmSize,omitempty"`
	// SSHConfiguration - SSH configuration for accessing the File Server node.
	SSHConfiguration *SSHConfiguration `json:"sshConfiguration,omitempty"`
	// DataDisks - Information about disks attached to File Server VM.
	DataDisks *DataDisks `json:"dataDisks,omitempty"`
	// Subnet - File Server virtual network subnet resource ID.
	Subnet *ResourceID `json:"subnet,omitempty"`
	// MountSettings - READ-ONLY; File Server mount settings.
	MountSettings *MountSettings `json:"mountSettings,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY; Time when the provisioning state was changed.
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
	// CreationTime - READ-ONLY; Time when the FileServer was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the File Server. Possible values: creating - The File Server is getting created; updating - The File Server creation has been accepted and it is getting updated; deleting - The user has requested that the File Server be deleted, and it is in the process of being deleted; failed - The File Server creation has failed with the specified error code. Details about the error code are specified in the message field; succeeded - The File Server creation has succeeded. Possible values include: 'FileServerProvisioningStateCreating', 'FileServerProvisioningStateUpdating', 'FileServerProvisioningStateDeleting', 'FileServerProvisioningStateSucceeded', 'FileServerProvisioningStateFailed'
	ProvisioningState FileServerProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for FileServerProperties.
func (fsp FileServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsp.VMSize != nil {
		objectMap["vmSize"] = fsp.VMSize
	}
	if fsp.SSHConfiguration != nil {
		objectMap["sshConfiguration"] = fsp.SSHConfiguration
	}
	if fsp.DataDisks != nil {
		objectMap["dataDisks"] = fsp.DataDisks
	}
	if fsp.Subnet != nil {
		objectMap["subnet"] = fsp.Subnet
	}
	return json.Marshal(objectMap)
}

// FileServerReference file Server mounting configuration.
type FileServerReference struct {
	// FileServer - Resource ID of the existing File Server to be mounted.
	FileServer *ResourceID `json:"fileServer,omitempty"`
	// SourceDirectory - File Server directory that needs to be mounted. If this property is not specified, the entire File Server will be mounted.
	SourceDirectory *string `json:"sourceDirectory,omitempty"`
	// RelativeMountPath - The relative path on the compute node where the File Server will be mounted. Note that all cluster level file servers will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level file servers will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// MountOptions - Mount options to be passed to mount command.
	MountOptions *string `json:"mountOptions,omitempty"`
}

// FileServersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FileServersCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FileServersClient) (FileServer, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FileServersCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FileServersCreateFuture.Result.
func (future *FileServersCreateFuture) result(client FileServersClient) (fs FileServer, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.FileServersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.FileServersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fs.Response.Response, err = future.GetResult(sender); err == nil && fs.Response.Response.StatusCode != http.StatusNoContent {
		fs, err = client.CreateResponder(fs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.FileServersCreateFuture", "Result", fs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FileServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FileServersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FileServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FileServersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FileServersDeleteFuture.Result.
func (future *FileServersDeleteFuture) result(client FileServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.FileServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.FileServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HorovodSettings specifies the settings for Horovod job.
type HorovodSettings struct {
	// PythonScriptFilePath - The python script to execute.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - The path to the Python interpreter.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	// CommandLineArgs - Command line arguments that need to be passed to the python script.
	CommandLineArgs *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - Number of processes to launch for the job execution. The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
}

// ImageReference the OS image reference.
type ImageReference struct {
	// Publisher - Publisher of the image.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - Offer of the image.
	Offer *string `json:"offer,omitempty"`
	// Sku - SKU of the image.
	Sku *string `json:"sku,omitempty"`
	// Version - Version of the image.
	Version *string `json:"version,omitempty"`
	// VirtualMachineImageID - The ARM resource identifier of the virtual machine image for the compute nodes. This is of the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}. The virtual machine image must be in the same region and subscription as the cluster. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration. Note, you need to provide publisher, offer and sku of the base OS image of which the custom image has been derived from.
	VirtualMachineImageID *string `json:"virtualMachineImageId,omitempty"`
}

// ImageSourceRegistry information about docker image for the job.
type ImageSourceRegistry struct {
	// ServerURL - URL for image repository.
	ServerURL *string `json:"serverUrl,omitempty"`
	// Image - The name of the image in the image repository.
	Image *string `json:"image,omitempty"`
	// Credentials - Credentials to access the private docker repository.
	Credentials *PrivateRegistryCredentials `json:"credentials,omitempty"`
}

// InputDirectory input directory for the job.
type InputDirectory struct {
	// ID - The ID for the input directory. The job can use AZ_BATCHAI_INPUT_<id> environment variable to find the directory path, where <id> is the value of id attribute.
	ID *string `json:"id,omitempty"`
	// Path - The path to the input directory.
	Path *string `json:"path,omitempty"`
}

// Job information about a Job.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - The properties associated with the Job.
	*JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobBaseProperties the properties of a Batch AI Job.
type JobBaseProperties struct {
	// SchedulingPriority - Scheduling priority associated with the job. Possible values: low, normal, high. Possible values include: 'Low', 'Normal', 'High'
	SchedulingPriority JobPriority `json:"schedulingPriority,omitempty"`
	// Cluster - Resource ID of the cluster on which this job will run.
	Cluster *ResourceID `json:"cluster,omitempty"`
	// MountVolumes - Information on mount volumes to be used by the job. These volumes will be mounted before the job execution and will be unmounted after the job completion. The volumes will be mounted at location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
	MountVolumes *MountVolumes `json:"mountVolumes,omitempty"`
	// NodeCount - Number of compute nodes to run the job on. The job will be gang scheduled on that many compute nodes.
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// ContainerSettings - Docker container settings for the job. If not provided, the job will run directly on the node.
	ContainerSettings *ContainerSettings `json:"containerSettings,omitempty"`
	// CntkSettings - Settings for CNTK (aka Microsoft Cognitive Toolkit) job.
	CntkSettings *CNTKsettings `json:"cntkSettings,omitempty"`
	// PyTorchSettings - Settings for pyTorch job.
	PyTorchSettings *PyTorchSettings `json:"pyTorchSettings,omitempty"`
	// TensorFlowSettings - Settings for Tensor Flow job.
	TensorFlowSettings *TensorFlowSettings `json:"tensorFlowSettings,omitempty"`
	// CaffeSettings - Settings for Caffe job.
	CaffeSettings *CaffeSettings `json:"caffeSettings,omitempty"`
	// Caffe2Settings - Settings for Caffe2 job.
	Caffe2Settings *Caffe2Settings `json:"caffe2Settings,omitempty"`
	// ChainerSettings - Settings for Chainer job.
	ChainerSettings *ChainerSettings `json:"chainerSettings,omitempty"`
	// CustomToolkitSettings - Settings for custom tool kit job.
	CustomToolkitSettings *CustomToolkitSettings `json:"customToolkitSettings,omitempty"`
	// CustomMpiSettings - Settings for custom MPI job.
	CustomMpiSettings *CustomMpiSettings `json:"customMpiSettings,omitempty"`
	// HorovodSettings - Settings for Horovod job.
	HorovodSettings *HorovodSettings `json:"horovodSettings,omitempty"`
	// JobPreparation - A command line to be executed on each node allocated for the job before tool kit is launched.
	JobPreparation *JobPreparation `json:"jobPreparation,omitempty"`
	// StdOutErrPathPrefix - The path where the Batch AI service will store stdout, stderror and execution log of the job.
	StdOutErrPathPrefix *string `json:"stdOutErrPathPrefix,omitempty"`
	// InputDirectories - A list of input directories for the job.
	InputDirectories *[]InputDirectory `json:"inputDirectories,omitempty"`
	// OutputDirectories - A list of output directories for the job.
	OutputDirectories *[]OutputDirectory `json:"outputDirectories,omitempty"`
	// EnvironmentVariables - A list of user defined environment variables which will be setup for the job.
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// Secrets - A list of user defined environment variables with secret values which will be setup for the job. Server will never report values of these variables back.
	Secrets *[]EnvironmentVariableWithSecretValue `json:"secrets,omitempty"`
	// Constraints - Constraints associated with the Job.
	Constraints *JobBasePropertiesConstraints `json:"constraints,omitempty"`
}

// JobBasePropertiesConstraints constraints associated with the Job.
type JobBasePropertiesConstraints struct {
	// MaxWallClockTime - Max time the job can run. Default value: 1 week.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
}

// JobCreateParameters job creation parameters.
type JobCreateParameters struct {
	// JobBaseProperties - The properties of the Job.
	*JobBaseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCreateParameters.
func (jcp JobCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcp.JobBaseProperties != nil {
		objectMap["properties"] = jcp.JobBaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCreateParameters struct.
func (jcp *JobCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobBaseProperties JobBaseProperties
				err = json.Unmarshal(*v, &jobBaseProperties)
				if err != nil {
					return err
				}
				jcp.JobBaseProperties = &jobBaseProperties
			}
		}
	}

	return nil
}

// JobListResult values returned by the List operation.
type JobListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The collection of jobs.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobListResult.
func (jlr JobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobListResultIterator provides access to a complete listing of Job values.
type JobListResultIterator struct {
	i    int
	page JobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListResultIterator) Response() JobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListResultIterator type.
func NewJobListResultIterator(page JobListResultPage) JobListResultIterator {
	return JobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jlr JobListResult) IsEmpty() bool {
	return jlr.Value == nil || len(*jlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jlr JobListResult) hasNextLink() bool {
	return jlr.NextLink != nil && len(*jlr.NextLink) != 0
}

// jobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlr JobListResult) jobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlr.NextLink)))
}

// JobListResultPage contains a page of Job values.
type JobListResultPage struct {
	fn  func(context.Context, JobListResult) (JobListResult, error)
	jlr JobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jlr)
		if err != nil {
			return err
		}
		page.jlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultPage) NotDone() bool {
	return !page.jlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListResultPage) Response() JobListResult {
	return page.jlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultPage) Values() []Job {
	if page.jlr.IsEmpty() {
		return nil
	}
	return *page.jlr.Value
}

// Creates a new instance of the JobListResultPage type.
func NewJobListResultPage(cur JobListResult, getNextPage func(context.Context, JobListResult) (JobListResult, error)) JobListResultPage {
	return JobListResultPage{
		fn:  getNextPage,
		jlr: cur,
	}
}

// JobPreparation job preparation settings.
type JobPreparation struct {
	// CommandLine - The command line to execute. If containerSettings is specified on the job, this commandLine will be executed in the same container as job. Otherwise it will be executed on the node.
	CommandLine *string `json:"commandLine,omitempty"`
}

// JobProperties job properties.
type JobProperties struct {
	// SchedulingPriority - Scheduling priority associated with the job. Possible values include: 'Low', 'Normal', 'High'
	SchedulingPriority JobPriority `json:"schedulingPriority,omitempty"`
	// Cluster - Resource ID of the cluster associated with the job.
	Cluster *ResourceID `json:"cluster,omitempty"`
	// MountVolumes - Collection of mount volumes available to the job during execution. These volumes are mounted before the job execution and unmounted after the job completion. The volumes are mounted at location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
	MountVolumes *MountVolumes `json:"mountVolumes,omitempty"`
	// NodeCount - The job will be gang scheduled on that many compute nodes
	NodeCount *int32 `json:"nodeCount,omitempty"`
	// ContainerSettings - If the container was downloaded as part of cluster setup then the same container image will be used. If not provided, the job will run on the VM.
	ContainerSettings *ContainerSettings `json:"containerSettings,omitempty"`
	// ToolType - Possible values are: cntk, tensorflow, caffe, caffe2, chainer, pytorch, custom, custommpi, horovod. Possible values include: 'Cntk', 'Tensorflow', 'Caffe', 'Caffe2', 'Chainer', 'Horovod', 'Custommpi', 'Custom'
	ToolType              ToolType               `json:"toolType,omitempty"`
	CntkSettings          *CNTKsettings          `json:"cntkSettings,omitempty"`
	PyTorchSettings       *PyTorchSettings       `json:"pyTorchSettings,omitempty"`
	TensorFlowSettings    *TensorFlowSettings    `json:"tensorFlowSettings,omitempty"`
	CaffeSettings         *CaffeSettings         `json:"caffeSettings,omitempty"`
	Caffe2Settings        *Caffe2Settings        `json:"caffe2Settings,omitempty"`
	ChainerSettings       *ChainerSettings       `json:"chainerSettings,omitempty"`
	CustomToolkitSettings *CustomToolkitSettings `json:"customToolkitSettings,omitempty"`
	CustomMpiSettings     *CustomMpiSettings     `json:"customMpiSettings,omitempty"`
	HorovodSettings       *HorovodSettings       `json:"horovodSettings,omitempty"`
	// JobPreparation - The specified actions will run on all the nodes that are part of the job
	JobPreparation *JobPreparation `json:"jobPreparation,omitempty"`
	// JobOutputDirectoryPathSegment - READ-ONLY; A segment of job's output directories path created by Batch AI. Batch AI creates job's output directories under an unique path to avoid conflicts between jobs. This value contains a path segment generated by Batch AI to make the path unique and can be used to find the output directory on the node or mounted filesystem.
	JobOutputDirectoryPathSegment *string `json:"jobOutputDirectoryPathSegment,omitempty"`
	// StdOutErrPathPrefix - The path where the Batch AI service stores stdout, stderror and execution log of the job.
	StdOutErrPathPrefix *string `json:"stdOutErrPathPrefix,omitempty"`
	// InputDirectories - A list of input directories for the job.
	InputDirectories *[]InputDirectory `json:"inputDirectories,omitempty"`
	// OutputDirectories - A list of output directories for the job.
	OutputDirectories *[]OutputDirectory `json:"outputDirectories,omitempty"`
	// EnvironmentVariables - A collection of user defined environment variables to be setup for the job.
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// Secrets - A collection of user defined environment variables with secret values to be setup for the job. Server will never report values of these variables back.
	Secrets *[]EnvironmentVariableWithSecretValue `json:"secrets,omitempty"`
	// Constraints - Constraints associated with the Job.
	Constraints *JobPropertiesConstraints `json:"constraints,omitempty"`
	// CreationTime - READ-ONLY; The creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioned state of the Batch AI job. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY; The time at which the job entered its current provisioning state.
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
	// ExecutionState - READ-ONLY; The current state of the job. Possible values are: queued - The job is queued and able to run. A job enters this state when it is created, or when it is awaiting a retry after a failed run. running - The job is running on a compute cluster. This includes job-level preparation such as downloading resource files or set up container specified on the job - it does not necessarily mean that the job command line has started executing. terminating - The job is terminated by the user, the terminate operation is in progress. succeeded - The job has completed running successfully and exited with exit code 0. failed - The job has finished unsuccessfully (failed with a non-zero exit code) and has exhausted its retry limit. A job is also marked as failed if an error occurred launching the job. Possible values include: 'Queued', 'Running', 'Terminating', 'Succeeded', 'Failed'
	ExecutionState ExecutionState `json:"executionState,omitempty"`
	// ExecutionStateTransitionTime - READ-ONLY; The time at which the job entered its current execution state.
	ExecutionStateTransitionTime *date.Time `json:"executionStateTransitionTime,omitempty"`
	// ExecutionInfo - Information about the execution of a job.
	ExecutionInfo *JobPropertiesExecutionInfo `json:"executionInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.SchedulingPriority != "" {
		objectMap["schedulingPriority"] = jp.SchedulingPriority
	}
	if jp.Cluster != nil {
		objectMap["cluster"] = jp.Cluster
	}
	if jp.MountVolumes != nil {
		objectMap["mountVolumes"] = jp.MountVolumes
	}
	if jp.NodeCount != nil {
		objectMap["nodeCount"] = jp.NodeCount
	}
	if jp.ContainerSettings != nil {
		objectMap["containerSettings"] = jp.ContainerSettings
	}
	if jp.ToolType != "" {
		objectMap["toolType"] = jp.ToolType
	}
	if jp.CntkSettings != nil {
		objectMap["cntkSettings"] = jp.CntkSettings
	}
	if jp.PyTorchSettings != nil {
		objectMap["pyTorchSettings"] = jp.PyTorchSettings
	}
	if jp.TensorFlowSettings != nil {
		objectMap["tensorFlowSettings"] = jp.TensorFlowSettings
	}
	if jp.CaffeSettings != nil {
		objectMap["caffeSettings"] = jp.CaffeSettings
	}
	if jp.Caffe2Settings != nil {
		objectMap["caffe2Settings"] = jp.Caffe2Settings
	}
	if jp.ChainerSettings != nil {
		objectMap["chainerSettings"] = jp.ChainerSettings
	}
	if jp.CustomToolkitSettings != nil {
		objectMap["customToolkitSettings"] = jp.CustomToolkitSettings
	}
	if jp.CustomMpiSettings != nil {
		objectMap["customMpiSettings"] = jp.CustomMpiSettings
	}
	if jp.HorovodSettings != nil {
		objectMap["horovodSettings"] = jp.HorovodSettings
	}
	if jp.JobPreparation != nil {
		objectMap["jobPreparation"] = jp.JobPreparation
	}
	if jp.StdOutErrPathPrefix != nil {
		objectMap["stdOutErrPathPrefix"] = jp.StdOutErrPathPrefix
	}
	if jp.InputDirectories != nil {
		objectMap["inputDirectories"] = jp.InputDirectories
	}
	if jp.OutputDirectories != nil {
		objectMap["outputDirectories"] = jp.OutputDirectories
	}
	if jp.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = jp.EnvironmentVariables
	}
	if jp.Secrets != nil {
		objectMap["secrets"] = jp.Secrets
	}
	if jp.Constraints != nil {
		objectMap["constraints"] = jp.Constraints
	}
	if jp.ExecutionInfo != nil {
		objectMap["executionInfo"] = jp.ExecutionInfo
	}
	return json.Marshal(objectMap)
}

// JobPropertiesConstraints constraints associated with the Job.
type JobPropertiesConstraints struct {
	// MaxWallClockTime - Max time the job can run. Default value: 1 week.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
}

// JobPropertiesExecutionInfo information about the execution of a job.
type JobPropertiesExecutionInfo struct {
	// StartTime - READ-ONLY; The time at which the job started running. 'Running' corresponds to the running state. If the job has been restarted or retried, this is the most recent time at which the job started running. This property is present only for job that are in the running or completed state.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The time at which the job completed. This property is only returned if the job is in completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - READ-ONLY; The exit code of the job. This property is only returned if the job is in completed state.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// Errors - READ-ONLY; A collection of errors encountered by the service during job execution.
	Errors *[]Error `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for JobPropertiesExecutionInfo.
func (jpI JobPropertiesExecutionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobsClient) (Job, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobsCreateFuture.Result.
func (future *JobsCreateFuture) result(client JobsClient) (j Job, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		j.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.JobsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.CreateResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.JobsCreateFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobsDeleteFuture.Result.
func (future *JobsDeleteFuture) result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.JobsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobsTerminateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobsTerminateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobsTerminateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobsTerminateFuture.Result.
func (future *JobsTerminateFuture) result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsTerminateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.JobsTerminateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// KeyVaultSecretReference key Vault Secret reference.
type KeyVaultSecretReference struct {
	// SourceVault - Fully qualified resource identifier of the Key Vault.
	SourceVault *ResourceID `json:"sourceVault,omitempty"`
	// SecretURL - The URL referencing a secret in the Key Vault.
	SecretURL *string `json:"secretUrl,omitempty"`
}

// ListUsagesResult the List Usages operation response.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of compute resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page of compute resource usage information. Call ListNext() with this to fetch the next page of compute resource usage information.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListUsagesResult.
func (lur ListUsagesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListUsagesResultIterator provides access to a complete listing of Usage values.
type ListUsagesResultIterator struct {
	i    int
	page ListUsagesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListUsagesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListUsagesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListUsagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListUsagesResultIterator) Response() ListUsagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListUsagesResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListUsagesResultIterator type.
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return ListUsagesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lur ListUsagesResult) IsEmpty() bool {
	return lur.Value == nil || len(*lur.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lur ListUsagesResult) hasNextLink() bool {
	return lur.NextLink != nil && len(*lur.NextLink) != 0
}

// listUsagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lur ListUsagesResult) listUsagesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lur.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lur.NextLink)))
}

// ListUsagesResultPage contains a page of Usage values.
type ListUsagesResultPage struct {
	fn  func(context.Context, ListUsagesResult) (ListUsagesResult, error)
	lur ListUsagesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListUsagesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListUsagesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lur)
		if err != nil {
			return err
		}
		page.lur = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListUsagesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListUsagesResultPage) NotDone() bool {
	return !page.lur.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListUsagesResultPage) Response() ListUsagesResult {
	return page.lur
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListUsagesResultPage) Values() []Usage {
	if page.lur.IsEmpty() {
		return nil
	}
	return *page.lur.Value
}

// Creates a new instance of the ListUsagesResultPage type.
func NewListUsagesResultPage(cur ListUsagesResult, getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return ListUsagesResultPage{
		fn:  getNextPage,
		lur: cur,
	}
}

// ManualScaleSettings manual scale settings for the cluster.
type ManualScaleSettings struct {
	// TargetNodeCount - The desired number of compute nodes in the Cluster. Default is 0.
	TargetNodeCount *int32 `json:"targetNodeCount,omitempty"`
	// NodeDeallocationOption - An action to be performed when the cluster size is decreasing. The default value is requeue. Possible values include: 'Requeue', 'Terminate', 'Waitforjobcompletion'
	NodeDeallocationOption DeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// MountSettings file Server mount Information.
type MountSettings struct {
	// MountPoint - Path where the data disks are mounted on the File Server.
	MountPoint *string `json:"mountPoint,omitempty"`
	// FileServerPublicIP - Public IP address of the File Server which can be used to SSH to the node from outside of the subnet.
	FileServerPublicIP *string `json:"fileServerPublicIP,omitempty"`
	// FileServerInternalIP - Internal IP address of the File Server which can be used to access the File Server from within the subnet.
	FileServerInternalIP *string `json:"fileServerInternalIP,omitempty"`
}

// MountVolumes details of volumes to mount on the cluster.
type MountVolumes struct {
	// AzureFileShares - A collection of Azure File Shares that are to be mounted to the cluster nodes.
	AzureFileShares *[]AzureFileShareReference `json:"azureFileShares,omitempty"`
	// AzureBlobFileSystems - A collection of Azure Blob Containers that are to be mounted to the cluster nodes.
	AzureBlobFileSystems *[]AzureBlobFileSystemReference `json:"azureBlobFileSystems,omitempty"`
	// FileServers - A collection of Batch AI File Servers that are to be mounted to the cluster nodes.
	FileServers *[]FileServerReference `json:"fileServers,omitempty"`
	// UnmanagedFileSystems - A collection of unmanaged file systems that are to be mounted to the cluster nodes.
	UnmanagedFileSystems *[]UnmanagedFileSystemReference `json:"unmanagedFileSystems,omitempty"`
}

// NameValuePair name-value pair.
type NameValuePair struct {
	// Name - The name in the name-value pair.
	Name *string `json:"name,omitempty"`
	// Value - The value in the name-value pair.
	Value *string `json:"value,omitempty"`
}

// NodeSetup node setup settings.
type NodeSetup struct {
	// SetupTask - Setup task to run on cluster nodes when nodes got created or rebooted. The setup task code needs to be idempotent. Generally the setup task is used to download static data that is required for all jobs that run on the cluster VMs and/or to download/install software.
	SetupTask *SetupTask `json:"setupTask,omitempty"`
	// MountVolumes - Mount volumes to be available to setup task and all jobs executing on the cluster. The volumes will be mounted at location specified by $AZ_BATCHAI_MOUNT_ROOT environment variable.
	MountVolumes *MountVolumes `json:"mountVolumes,omitempty"`
	// PerformanceCountersSettings - Settings for performance counters collecting and uploading.
	PerformanceCountersSettings *PerformanceCountersSettings `json:"performanceCountersSettings,omitempty"`
}

// NodeStateCounts counts of various compute node states on the cluster.
type NodeStateCounts struct {
	// IdleNodeCount - READ-ONLY; Number of compute nodes in idle state.
	IdleNodeCount *int32 `json:"idleNodeCount,omitempty"`
	// RunningNodeCount - READ-ONLY; Number of compute nodes which are running jobs.
	RunningNodeCount *int32 `json:"runningNodeCount,omitempty"`
	// PreparingNodeCount - READ-ONLY; Number of compute nodes which are being prepared.
	PreparingNodeCount *int32 `json:"preparingNodeCount,omitempty"`
	// UnusableNodeCount - READ-ONLY; Number of compute nodes which are in unusable state.
	UnusableNodeCount *int32 `json:"unusableNodeCount,omitempty"`
	// LeavingNodeCount - READ-ONLY; Number of compute nodes which are leaving the cluster.
	LeavingNodeCount *int32 `json:"leavingNodeCount,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeStateCounts.
func (nsc NodeStateCounts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Operation details of a REST API operation
type Operation struct {
	// Name - READ-ONLY; This is of the format {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY
	Origin     *string     `json:"origin,omitempty"`
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Properties != nil {
		objectMap["properties"] = o.Properties
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that describes the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY
	Provider *string `json:"provider,omitempty"`
	// Operation - READ-ONLY; For example: read, write, delete, or listKeys/action
	Operation *string `json:"operation,omitempty"`
	// Resource - READ-ONLY
	Resource *string `json:"resource,omitempty"`
	// Description - READ-ONLY
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult contains the list of all operations supported by BatchAI resource provider
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OutputDirectory output directory for the job.
type OutputDirectory struct {
	// ID - The ID of the output directory. The job can use AZ_BATCHAI_OUTPUT_<id> environment variable to find the directory path, where <id> is the value of id attribute.
	ID *string `json:"id,omitempty"`
	// PathPrefix - The prefix path where the output directory will be created. Note, this is an absolute path to prefix. E.g. $AZ_BATCHAI_MOUNT_ROOT/MyNFS/MyLogs. The full path to the output directory by combining pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
	PathPrefix *string `json:"pathPrefix,omitempty"`
	// PathSuffix - The suffix path where the output directory will be created. E.g. models. You can find the full path to the output directory by combining pathPrefix, jobOutputDirectoryPathSegment (reported by get job) and pathSuffix.
	PathSuffix *string `json:"pathSuffix,omitempty"`
}

// PerformanceCountersSettings performance counters reporting settings.
type PerformanceCountersSettings struct {
	// AppInsightsReference - Azure Application Insights information for performance counters reporting. If provided, Batch AI will upload node performance counters to the corresponding Azure Application Insights account.
	AppInsightsReference *AppInsightsReference `json:"appInsightsReference,omitempty"`
}

// PrivateRegistryCredentials credentials to access a container image in a private repository.
type PrivateRegistryCredentials struct {
	// Username - User name to login to the repository.
	Username *string `json:"username,omitempty"`
	// Password - User password to login to the docker repository. One of password or passwordSecretReference must be specified.
	Password *string `json:"password,omitempty"`
	// PasswordSecretReference - KeyVault Secret storing the password. Users can store their secrets in Azure KeyVault and pass it to the Batch AI service to integrate with KeyVault. One of password or passwordSecretReference must be specified.
	PasswordSecretReference *KeyVaultSecretReference `json:"passwordSecretReference,omitempty"`
}

// ProxyResource a definition of an Azure proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PyTorchSettings pyTorch job settings.
type PyTorchSettings struct {
	// PythonScriptFilePath - The python script to execute.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - The path to the Python interpreter.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	// CommandLineArgs - Command line arguments that need to be passed to the python script.
	CommandLineArgs *string `json:"commandLineArgs,omitempty"`
	// ProcessCount - Number of processes to launch for the job execution. The default value for this property is equal to nodeCount property
	ProcessCount *int32 `json:"processCount,omitempty"`
	// CommunicationBackend - Type of the communication backend for distributed jobs. Valid values are 'TCP', 'Gloo' or 'MPI'. Not required for non-distributed jobs.
	CommunicationBackend *string `json:"communicationBackend,omitempty"`
}

// RemoteLoginInformation login details to SSH to a compute node in cluster.
type RemoteLoginInformation struct {
	// NodeID - READ-ONLY; ID of the compute node.
	NodeID *string `json:"nodeId,omitempty"`
	// IPAddress - READ-ONLY; Public IP address of the compute node.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Port - READ-ONLY; SSH port number of the node.
	Port *float64 `json:"port,omitempty"`
}

// MarshalJSON is the custom marshaler for RemoteLoginInformation.
func (rli RemoteLoginInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RemoteLoginInformationListResult values returned by the List operation.
type RemoteLoginInformationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The collection of returned remote login details.
	Value *[]RemoteLoginInformation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RemoteLoginInformationListResult.
func (rlilr RemoteLoginInformationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RemoteLoginInformationListResultIterator provides access to a complete listing of RemoteLoginInformation
// values.
type RemoteLoginInformationListResultIterator struct {
	i    int
	page RemoteLoginInformationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RemoteLoginInformationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemoteLoginInformationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RemoteLoginInformationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RemoteLoginInformationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RemoteLoginInformationListResultIterator) Response() RemoteLoginInformationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RemoteLoginInformationListResultIterator) Value() RemoteLoginInformation {
	if !iter.page.NotDone() {
		return RemoteLoginInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RemoteLoginInformationListResultIterator type.
func NewRemoteLoginInformationListResultIterator(page RemoteLoginInformationListResultPage) RemoteLoginInformationListResultIterator {
	return RemoteLoginInformationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlilr RemoteLoginInformationListResult) IsEmpty() bool {
	return rlilr.Value == nil || len(*rlilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlilr RemoteLoginInformationListResult) hasNextLink() bool {
	return rlilr.NextLink != nil && len(*rlilr.NextLink) != 0
}

// remoteLoginInformationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlilr RemoteLoginInformationListResult) remoteLoginInformationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlilr.NextLink)))
}

// RemoteLoginInformationListResultPage contains a page of RemoteLoginInformation values.
type RemoteLoginInformationListResultPage struct {
	fn    func(context.Context, RemoteLoginInformationListResult) (RemoteLoginInformationListResult, error)
	rlilr RemoteLoginInformationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RemoteLoginInformationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemoteLoginInformationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlilr)
		if err != nil {
			return err
		}
		page.rlilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RemoteLoginInformationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RemoteLoginInformationListResultPage) NotDone() bool {
	return !page.rlilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RemoteLoginInformationListResultPage) Response() RemoteLoginInformationListResult {
	return page.rlilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RemoteLoginInformationListResultPage) Values() []RemoteLoginInformation {
	if page.rlilr.IsEmpty() {
		return nil
	}
	return *page.rlilr.Value
}

// Creates a new instance of the RemoteLoginInformationListResultPage type.
func NewRemoteLoginInformationListResultPage(cur RemoteLoginInformationListResult, getNextPage func(context.Context, RemoteLoginInformationListResult) (RemoteLoginInformationListResult, error)) RemoteLoginInformationListResultPage {
	return RemoteLoginInformationListResultPage{
		fn:    getNextPage,
		rlilr: cur,
	}
}

// Resource a definition of an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The ID of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The tags of the resource
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceID represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
type ResourceID struct {
	// ID - The ID of the resource
	ID *string `json:"id,omitempty"`
}

// ScaleSettings at least one of manual or autoScale settings must be specified. Only one of manual or
// autoScale settings can be specified. If autoScale settings are specified, the system automatically
// scales the cluster up and down (within the supplied limits) based on the pending jobs on the cluster.
type ScaleSettings struct {
	// Manual - Manual scale settings for the cluster.
	Manual *ManualScaleSettings `json:"manual,omitempty"`
	// AutoScale - Auto-scale settings for the cluster.
	AutoScale *AutoScaleSettings `json:"autoScale,omitempty"`
}

// SetupTask specifies a setup task which can be used to customize the compute nodes of the cluster.
type SetupTask struct {
	// CommandLine - The command line to be executed on each cluster's node after it being allocated or rebooted. The command is executed in a bash subshell as a root.
	CommandLine *string `json:"commandLine,omitempty"`
	// EnvironmentVariables - A collection of user defined environment variables to be set for setup task.
	EnvironmentVariables *[]EnvironmentVariable `json:"environmentVariables,omitempty"`
	// Secrets - A collection of user defined environment variables with secret values to be set for the setup task. Server will never report values of these variables back.
	Secrets *[]EnvironmentVariableWithSecretValue `json:"secrets,omitempty"`
	// StdOutErrPathPrefix - The prefix of a path where the Batch AI service will upload the stdout, stderr and execution log of the setup task.
	StdOutErrPathPrefix *string `json:"stdOutErrPathPrefix,omitempty"`
	// StdOutErrPathSuffix - READ-ONLY; A path segment appended by Batch AI to stdOutErrPathPrefix to form a path where stdout, stderr and execution log of the setup task will be uploaded. Batch AI creates the setup task output directories under an unique path to avoid conflicts between different clusters. The full path can be obtained by concatenation of stdOutErrPathPrefix and stdOutErrPathSuffix.
	StdOutErrPathSuffix *string `json:"stdOutErrPathSuffix,omitempty"`
}

// MarshalJSON is the custom marshaler for SetupTask.
func (st SetupTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if st.CommandLine != nil {
		objectMap["commandLine"] = st.CommandLine
	}
	if st.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = st.EnvironmentVariables
	}
	if st.Secrets != nil {
		objectMap["secrets"] = st.Secrets
	}
	if st.StdOutErrPathPrefix != nil {
		objectMap["stdOutErrPathPrefix"] = st.StdOutErrPathPrefix
	}
	return json.Marshal(objectMap)
}

// SSHConfiguration SSH configuration.
type SSHConfiguration struct {
	// PublicIPsToAllow - List of source IP ranges to allow SSH connection from. The default value is '*' (all source IPs are allowed). Maximum number of IP ranges that can be specified is 400.
	PublicIPsToAllow *[]string `json:"publicIPsToAllow,omitempty"`
	// UserAccountSettings - Settings for administrator user account to be created on a node. The account can be used to establish SSH connection to the node.
	UserAccountSettings *UserAccountSettings `json:"userAccountSettings,omitempty"`
}

// TensorFlowSettings tensorFlow job settings.
type TensorFlowSettings struct {
	// PythonScriptFilePath - The python script to execute.
	PythonScriptFilePath *string `json:"pythonScriptFilePath,omitempty"`
	// PythonInterpreterPath - The path to the Python interpreter.
	PythonInterpreterPath *string `json:"pythonInterpreterPath,omitempty"`
	// MasterCommandLineArgs - Command line arguments that need to be passed to the python script for the master task.
	MasterCommandLineArgs *string `json:"masterCommandLineArgs,omitempty"`
	// WorkerCommandLineArgs - Command line arguments that need to be passed to the python script for the worker task. Optional for single process jobs.
	WorkerCommandLineArgs *string `json:"workerCommandLineArgs,omitempty"`
	// ParameterServerCommandLineArgs - Command line arguments that need to be passed to the python script for the parameter server. Optional for single process jobs.
	ParameterServerCommandLineArgs *string `json:"parameterServerCommandLineArgs,omitempty"`
	// WorkerCount - The number of worker tasks. If specified, the value must be less than or equal to (nodeCount * numberOfGPUs per VM). If not specified, the default value is equal to nodeCount. This property can be specified only for distributed TensorFlow training.
	WorkerCount *int32 `json:"workerCount,omitempty"`
	// ParameterServerCount - The number of parameter server tasks. If specified, the value must be less than or equal to nodeCount. If not specified, the default value is equal to 1 for distributed TensorFlow training. This property can be specified only for distributed TensorFlow training.
	ParameterServerCount *int32 `json:"parameterServerCount,omitempty"`
}

// UnmanagedFileSystemReference unmanaged file system mounting configuration.
type UnmanagedFileSystemReference struct {
	// MountCommand - Mount command line. Note, Batch AI will append mount path to the command on its own.
	MountCommand *string `json:"mountCommand,omitempty"`
	// RelativeMountPath - The relative path on the compute node where the unmanaged file system will be mounted. Note that all cluster level unmanaged file systems will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level unmanaged file systems will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
}

// Usage describes Batch AI Resource Usage.
type Usage struct {
	// Unit - READ-ONLY; An enum describing the unit of usage measurement. Possible values include: 'Count'
	Unit UsageUnit `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; The current usage of the resource.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The maximum permitted usage of the resource.
	Limit *int64 `json:"limit,omitempty"`
	// Name - READ-ONLY; The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UsageName the Usage Names.
type UsageName struct {
	// Value - READ-ONLY; The name of the resource.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The localized name of the resource.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageName.
func (un UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UserAccountSettings settings for user account that gets created on each on the nodes of a cluster.
type UserAccountSettings struct {
	// AdminUserName - Name of the administrator user account which can be used to SSH to nodes.
	AdminUserName *string `json:"adminUserName,omitempty"`
	// AdminUserSSHPublicKey - SSH public key of the administrator user account.
	AdminUserSSHPublicKey *string `json:"adminUserSshPublicKey,omitempty"`
	// AdminUserPassword - Password of the administrator user account.
	AdminUserPassword *string `json:"adminUserPassword,omitempty"`
}

// VirtualMachineConfiguration VM configuration.
type VirtualMachineConfiguration struct {
	// ImageReference - OS image reference for cluster nodes.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
}

// Workspace batch AI Workspace information.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - The properties associated with the workspace.
	*WorkspaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The tags of the resource
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WorkspaceCreateParameters workspace creation parameters.
type WorkspaceCreateParameters struct {
	// Location - The region in which to create the Workspace.
	Location *string `json:"location,omitempty"`
	// Tags - The user specified tags associated with the Workspace.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkspaceCreateParameters.
func (wcp WorkspaceCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcp.Location != nil {
		objectMap["location"] = wcp.Location
	}
	if wcp.Tags != nil {
		objectMap["tags"] = wcp.Tags
	}
	return json.Marshal(objectMap)
}

// WorkspaceListResult values returned by the List operation.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The collection of workspaces.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - READ-ONLY; The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceListResult.
func (wlr WorkspaceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkspaceListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceListResultIterator struct {
	i    int
	page WorkspaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListResultIterator) Response() WorkspaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListResultIterator type.
func NewWorkspaceListResultIterator(page WorkspaceListResultPage) WorkspaceListResultIterator {
	return WorkspaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkspaceListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WorkspaceListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// workspaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkspaceListResult) workspaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkspaceListResultPage contains a page of Workspace values.
type WorkspaceListResultPage struct {
	fn  func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)
	wlr WorkspaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListResultPage) Response() WorkspaceListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListResultPage) Values() []Workspace {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WorkspaceListResultPage type.
func NewWorkspaceListResultPage(cur WorkspaceListResult, getNextPage func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)) WorkspaceListResultPage {
	return WorkspaceListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WorkspaceProperties workspace specific properties.
type WorkspaceProperties struct {
	// CreationTime - READ-ONLY; Time when the Workspace was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioned state of the Workspace. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY; The time at which the workspace entered its current provisioning state.
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceProperties.
func (wp WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WorkspacesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesCreateFuture.Result.
func (future *WorkspacesCreateFuture) result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.WorkspacesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.WorkspacesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batchai.WorkspacesCreateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesDeleteFuture.Result.
func (future *WorkspacesDeleteFuture) result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batchai.WorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspaceUpdateParameters workspace update parameters.
type WorkspaceUpdateParameters struct {
	// Tags - The user specified tags associated with the Workspace.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WorkspaceUpdateParameters.
func (wup WorkspaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	return json.Marshal(objectMap)
}
