; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs \
; RUN:   < %s | FileCheck %s

define <vscale x 1 x i8> @test_vssra_vv_i8mf8(<vscale x 1 x i8> %op1, <vscale x 1 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i8> @llvm.riscv.vssra.nxv1i8.nxv1i8.i32(<vscale x 1 x i8> poison, <vscale x 1 x i8> %op1, <vscale x 1 x i8> %shift, i32 0, i32 %vl)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.vssra.nxv1i8.nxv1i8.i32(<vscale x 1 x i8>, <vscale x 1 x i8>, <vscale x 1 x i8>, i32 immarg, i32)

define <vscale x 1 x i8> @test_vssra_vx_i8mf8(<vscale x 1 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i8> @llvm.riscv.vssra.nxv1i8.i32.i32(<vscale x 1 x i8> poison, <vscale x 1 x i8> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.vssra.nxv1i8.i32.i32(<vscale x 1 x i8>, <vscale x 1 x i8>, i32, i32 immarg, i32)

define <vscale x 2 x i8> @test_vssra_vv_i8mf4(<vscale x 2 x i8> %op1, <vscale x 2 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i8> @llvm.riscv.vssra.nxv2i8.nxv2i8.i32(<vscale x 2 x i8> poison, <vscale x 2 x i8> %op1, <vscale x 2 x i8> %shift, i32 0, i32 %vl)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.vssra.nxv2i8.nxv2i8.i32(<vscale x 2 x i8>, <vscale x 2 x i8>, <vscale x 2 x i8>, i32 immarg, i32)

define <vscale x 2 x i8> @test_vssra_vx_i8mf4(<vscale x 2 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i8> @llvm.riscv.vssra.nxv2i8.i32.i32(<vscale x 2 x i8> poison, <vscale x 2 x i8> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.vssra.nxv2i8.i32.i32(<vscale x 2 x i8>, <vscale x 2 x i8>, i32, i32 immarg, i32)

define <vscale x 4 x i8> @test_vssra_vv_i8mf2(<vscale x 4 x i8> %op1, <vscale x 4 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i8> @llvm.riscv.vssra.nxv4i8.nxv4i8.i32(<vscale x 4 x i8> poison, <vscale x 4 x i8> %op1, <vscale x 4 x i8> %shift, i32 0, i32 %vl)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.vssra.nxv4i8.nxv4i8.i32(<vscale x 4 x i8>, <vscale x 4 x i8>, <vscale x 4 x i8>, i32 immarg, i32)

define <vscale x 4 x i8> @test_vssra_vx_i8mf2(<vscale x 4 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i8> @llvm.riscv.vssra.nxv4i8.i32.i32(<vscale x 4 x i8> poison, <vscale x 4 x i8> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.vssra.nxv4i8.i32.i32(<vscale x 4 x i8>, <vscale x 4 x i8>, i32, i32 immarg, i32)

define <vscale x 8 x i8> @test_vssra_vv_i8m1(<vscale x 8 x i8> %op1, <vscale x 8 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i8> @llvm.riscv.vssra.nxv8i8.nxv8i8.i32(<vscale x 8 x i8> poison, <vscale x 8 x i8> %op1, <vscale x 8 x i8> %shift, i32 0, i32 %vl)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.vssra.nxv8i8.nxv8i8.i32(<vscale x 8 x i8>, <vscale x 8 x i8>, <vscale x 8 x i8>, i32 immarg, i32)

define <vscale x 8 x i8> @test_vssra_vx_i8m1(<vscale x 8 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i8> @llvm.riscv.vssra.nxv8i8.i32.i32(<vscale x 8 x i8> poison, <vscale x 8 x i8> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.vssra.nxv8i8.i32.i32(<vscale x 8 x i8>, <vscale x 8 x i8>, i32, i32 immarg, i32)

define <vscale x 16 x i8> @test_vssra_vv_i8m2(<vscale x 16 x i8> %op1, <vscale x 16 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i8> @llvm.riscv.vssra.nxv16i8.nxv16i8.i32(<vscale x 16 x i8> poison, <vscale x 16 x i8> %op1, <vscale x 16 x i8> %shift, i32 0, i32 %vl)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.vssra.nxv16i8.nxv16i8.i32(<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, i32 immarg, i32)

define <vscale x 16 x i8> @test_vssra_vx_i8m2(<vscale x 16 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i8> @llvm.riscv.vssra.nxv16i8.i32.i32(<vscale x 16 x i8> poison, <vscale x 16 x i8> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.vssra.nxv16i8.i32.i32(<vscale x 16 x i8>, <vscale x 16 x i8>, i32, i32 immarg, i32)

define <vscale x 32 x i8> @test_vssra_vv_i8m4(<vscale x 32 x i8> %op1, <vscale x 32 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 32 x i8> @llvm.riscv.vssra.nxv32i8.nxv32i8.i32(<vscale x 32 x i8> poison, <vscale x 32 x i8> %op1, <vscale x 32 x i8> %shift, i32 0, i32 %vl)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.vssra.nxv32i8.nxv32i8.i32(<vscale x 32 x i8>, <vscale x 32 x i8>, <vscale x 32 x i8>, i32 immarg, i32)

define <vscale x 32 x i8> @test_vssra_vx_i8m4(<vscale x 32 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 32 x i8> @llvm.riscv.vssra.nxv32i8.i32.i32(<vscale x 32 x i8> poison, <vscale x 32 x i8> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.vssra.nxv32i8.i32.i32(<vscale x 32 x i8>, <vscale x 32 x i8>, i32, i32 immarg, i32)

define <vscale x 64 x i8> @test_vssra_vv_i8m8(<vscale x 64 x i8> %op1, <vscale x 64 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 64 x i8> @llvm.riscv.vssra.nxv64i8.nxv64i8.i32(<vscale x 64 x i8> poison, <vscale x 64 x i8> %op1, <vscale x 64 x i8> %shift, i32 0, i32 %vl)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.vssra.nxv64i8.nxv64i8.i32(<vscale x 64 x i8>, <vscale x 64 x i8>, <vscale x 64 x i8>, i32 immarg, i32)

define <vscale x 64 x i8> @test_vssra_vx_i8m8(<vscale x 64 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 64 x i8> @llvm.riscv.vssra.nxv64i8.i32.i32(<vscale x 64 x i8> poison, <vscale x 64 x i8> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.vssra.nxv64i8.i32.i32(<vscale x 64 x i8>, <vscale x 64 x i8>, i32, i32 immarg, i32)

define <vscale x 1 x i16> @test_vssra_vv_i16mf4(<vscale x 1 x i16> %op1, <vscale x 1 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i16> @llvm.riscv.vssra.nxv1i16.nxv1i16.i32(<vscale x 1 x i16> poison, <vscale x 1 x i16> %op1, <vscale x 1 x i16> %shift, i32 0, i32 %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.vssra.nxv1i16.nxv1i16.i32(<vscale x 1 x i16>, <vscale x 1 x i16>, <vscale x 1 x i16>, i32 immarg, i32)

define <vscale x 1 x i16> @test_vssra_vx_i16mf4(<vscale x 1 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i16> @llvm.riscv.vssra.nxv1i16.i32.i32(<vscale x 1 x i16> poison, <vscale x 1 x i16> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.vssra.nxv1i16.i32.i32(<vscale x 1 x i16>, <vscale x 1 x i16>, i32, i32 immarg, i32)

define <vscale x 2 x i16> @test_vssra_vv_i16mf2(<vscale x 2 x i16> %op1, <vscale x 2 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i16> @llvm.riscv.vssra.nxv2i16.nxv2i16.i32(<vscale x 2 x i16> poison, <vscale x 2 x i16> %op1, <vscale x 2 x i16> %shift, i32 0, i32 %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.vssra.nxv2i16.nxv2i16.i32(<vscale x 2 x i16>, <vscale x 2 x i16>, <vscale x 2 x i16>, i32 immarg, i32)

define <vscale x 2 x i16> @test_vssra_vx_i16mf2(<vscale x 2 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i16> @llvm.riscv.vssra.nxv2i16.i32.i32(<vscale x 2 x i16> poison, <vscale x 2 x i16> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.vssra.nxv2i16.i32.i32(<vscale x 2 x i16>, <vscale x 2 x i16>, i32, i32 immarg, i32)

define <vscale x 4 x i16> @test_vssra_vv_i16m1(<vscale x 4 x i16> %op1, <vscale x 4 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i16> @llvm.riscv.vssra.nxv4i16.nxv4i16.i32(<vscale x 4 x i16> poison, <vscale x 4 x i16> %op1, <vscale x 4 x i16> %shift, i32 0, i32 %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.vssra.nxv4i16.nxv4i16.i32(<vscale x 4 x i16>, <vscale x 4 x i16>, <vscale x 4 x i16>, i32 immarg, i32)

define <vscale x 4 x i16> @test_vssra_vx_i16m1(<vscale x 4 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i16> @llvm.riscv.vssra.nxv4i16.i32.i32(<vscale x 4 x i16> poison, <vscale x 4 x i16> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.vssra.nxv4i16.i32.i32(<vscale x 4 x i16>, <vscale x 4 x i16>, i32, i32 immarg, i32)

define <vscale x 8 x i16> @test_vssra_vv_i16m2(<vscale x 8 x i16> %op1, <vscale x 8 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i16> @llvm.riscv.vssra.nxv8i16.nxv8i16.i32(<vscale x 8 x i16> poison, <vscale x 8 x i16> %op1, <vscale x 8 x i16> %shift, i32 0, i32 %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.vssra.nxv8i16.nxv8i16.i32(<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, i32 immarg, i32)

define <vscale x 8 x i16> @test_vssra_vx_i16m2(<vscale x 8 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i16> @llvm.riscv.vssra.nxv8i16.i32.i32(<vscale x 8 x i16> poison, <vscale x 8 x i16> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.vssra.nxv8i16.i32.i32(<vscale x 8 x i16>, <vscale x 8 x i16>, i32, i32 immarg, i32)

define <vscale x 16 x i16> @test_vssra_vv_i16m4(<vscale x 16 x i16> %op1, <vscale x 16 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i16> @llvm.riscv.vssra.nxv16i16.nxv16i16.i32(<vscale x 16 x i16> poison, <vscale x 16 x i16> %op1, <vscale x 16 x i16> %shift, i32 0, i32 %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.vssra.nxv16i16.nxv16i16.i32(<vscale x 16 x i16>, <vscale x 16 x i16>, <vscale x 16 x i16>, i32 immarg, i32)

define <vscale x 16 x i16> @test_vssra_vx_i16m4(<vscale x 16 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i16> @llvm.riscv.vssra.nxv16i16.i32.i32(<vscale x 16 x i16> poison, <vscale x 16 x i16> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.vssra.nxv16i16.i32.i32(<vscale x 16 x i16>, <vscale x 16 x i16>, i32, i32 immarg, i32)

define <vscale x 32 x i16> @test_vssra_vv_i16m8(<vscale x 32 x i16> %op1, <vscale x 32 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 32 x i16> @llvm.riscv.vssra.nxv32i16.nxv32i16.i32(<vscale x 32 x i16> poison, <vscale x 32 x i16> %op1, <vscale x 32 x i16> %shift, i32 0, i32 %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.vssra.nxv32i16.nxv32i16.i32(<vscale x 32 x i16>, <vscale x 32 x i16>, <vscale x 32 x i16>, i32 immarg, i32)

define <vscale x 32 x i16> @test_vssra_vx_i16m8(<vscale x 32 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 32 x i16> @llvm.riscv.vssra.nxv32i16.i32.i32(<vscale x 32 x i16> poison, <vscale x 32 x i16> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.vssra.nxv32i16.i32.i32(<vscale x 32 x i16>, <vscale x 32 x i16>, i32, i32 immarg, i32)

define <vscale x 1 x i32> @test_vssra_vv_i32mf2(<vscale x 1 x i32> %op1, <vscale x 1 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i32> @llvm.riscv.vssra.nxv1i32.nxv1i32.i32(<vscale x 1 x i32> poison, <vscale x 1 x i32> %op1, <vscale x 1 x i32> %shift, i32 0, i32 %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.vssra.nxv1i32.nxv1i32.i32(<vscale x 1 x i32>, <vscale x 1 x i32>, <vscale x 1 x i32>, i32 immarg, i32)

define <vscale x 1 x i32> @test_vssra_vx_i32mf2(<vscale x 1 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i32> @llvm.riscv.vssra.nxv1i32.i32.i32(<vscale x 1 x i32> poison, <vscale x 1 x i32> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.vssra.nxv1i32.i32.i32(<vscale x 1 x i32>, <vscale x 1 x i32>, i32, i32 immarg, i32)

define <vscale x 2 x i32> @test_vssra_vv_i32m1(<vscale x 2 x i32> %op1, <vscale x 2 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i32> @llvm.riscv.vssra.nxv2i32.nxv2i32.i32(<vscale x 2 x i32> poison, <vscale x 2 x i32> %op1, <vscale x 2 x i32> %shift, i32 0, i32 %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.vssra.nxv2i32.nxv2i32.i32(<vscale x 2 x i32>, <vscale x 2 x i32>, <vscale x 2 x i32>, i32 immarg, i32)

define <vscale x 2 x i32> @test_vssra_vx_i32m1(<vscale x 2 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i32> @llvm.riscv.vssra.nxv2i32.i32.i32(<vscale x 2 x i32> poison, <vscale x 2 x i32> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.vssra.nxv2i32.i32.i32(<vscale x 2 x i32>, <vscale x 2 x i32>, i32, i32 immarg, i32)

define <vscale x 4 x i32> @test_vssra_vv_i32m2(<vscale x 4 x i32> %op1, <vscale x 4 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i32> @llvm.riscv.vssra.nxv4i32.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %op1, <vscale x 4 x i32> %shift, i32 0, i32 %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.vssra.nxv4i32.nxv4i32.i32(<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, i32 immarg, i32)

define <vscale x 4 x i32> @test_vssra_vx_i32m2(<vscale x 4 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i32> @llvm.riscv.vssra.nxv4i32.i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.vssra.nxv4i32.i32.i32(<vscale x 4 x i32>, <vscale x 4 x i32>, i32, i32 immarg, i32)

define <vscale x 8 x i32> @test_vssra_vv_i32m4(<vscale x 8 x i32> %op1, <vscale x 8 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i32> @llvm.riscv.vssra.nxv8i32.nxv8i32.i32(<vscale x 8 x i32> poison, <vscale x 8 x i32> %op1, <vscale x 8 x i32> %shift, i32 0, i32 %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.vssra.nxv8i32.nxv8i32.i32(<vscale x 8 x i32>, <vscale x 8 x i32>, <vscale x 8 x i32>, i32 immarg, i32)

define <vscale x 8 x i32> @test_vssra_vx_i32m4(<vscale x 8 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i32> @llvm.riscv.vssra.nxv8i32.i32.i32(<vscale x 8 x i32> poison, <vscale x 8 x i32> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.vssra.nxv8i32.i32.i32(<vscale x 8 x i32>, <vscale x 8 x i32>, i32, i32 immarg, i32)

define <vscale x 16 x i32> @test_vssra_vv_i32m8(<vscale x 16 x i32> %op1, <vscale x 16 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i32> @llvm.riscv.vssra.nxv16i32.nxv16i32.i32(<vscale x 16 x i32> poison, <vscale x 16 x i32> %op1, <vscale x 16 x i32> %shift, i32 0, i32 %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.vssra.nxv16i32.nxv16i32.i32(<vscale x 16 x i32>, <vscale x 16 x i32>, <vscale x 16 x i32>, i32 immarg, i32)

define <vscale x 16 x i32> @test_vssra_vx_i32m8(<vscale x 16 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i32> @llvm.riscv.vssra.nxv16i32.i32.i32(<vscale x 16 x i32> poison, <vscale x 16 x i32> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.vssra.nxv16i32.i32.i32(<vscale x 16 x i32>, <vscale x 16 x i32>, i32, i32 immarg, i32)

define <vscale x 1 x i64> @test_vssra_vv_i64m1(<vscale x 1 x i64> %op1, <vscale x 1 x i64> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i64> @llvm.riscv.vssra.nxv1i64.nxv1i64.i32(<vscale x 1 x i64> poison, <vscale x 1 x i64> %op1, <vscale x 1 x i64> %shift, i32 0, i32 %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.vssra.nxv1i64.nxv1i64.i32(<vscale x 1 x i64>, <vscale x 1 x i64>, <vscale x 1 x i64>, i32 immarg, i32)

define <vscale x 1 x i64> @test_vssra_vx_i64m1(<vscale x 1 x i64> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i64> @llvm.riscv.vssra.nxv1i64.i32.i32(<vscale x 1 x i64> poison, <vscale x 1 x i64> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.vssra.nxv1i64.i32.i32(<vscale x 1 x i64>, <vscale x 1 x i64>, i32, i32 immarg, i32)

define <vscale x 2 x i64> @test_vssra_vv_i64m2(<vscale x 2 x i64> %op1, <vscale x 2 x i64> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i64> @llvm.riscv.vssra.nxv2i64.nxv2i64.i32(<vscale x 2 x i64> poison, <vscale x 2 x i64> %op1, <vscale x 2 x i64> %shift, i32 0, i32 %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.vssra.nxv2i64.nxv2i64.i32(<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, i32 immarg, i32)

define <vscale x 2 x i64> @test_vssra_vx_i64m2(<vscale x 2 x i64> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i64> @llvm.riscv.vssra.nxv2i64.i32.i32(<vscale x 2 x i64> poison, <vscale x 2 x i64> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.vssra.nxv2i64.i32.i32(<vscale x 2 x i64>, <vscale x 2 x i64>, i32, i32 immarg, i32)

define <vscale x 4 x i64> @test_vssra_vv_i64m4(<vscale x 4 x i64> %op1, <vscale x 4 x i64> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i64> @llvm.riscv.vssra.nxv4i64.nxv4i64.i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %op1, <vscale x 4 x i64> %shift, i32 0, i32 %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.vssra.nxv4i64.nxv4i64.i32(<vscale x 4 x i64>, <vscale x 4 x i64>, <vscale x 4 x i64>, i32 immarg, i32)

define <vscale x 4 x i64> @test_vssra_vx_i64m4(<vscale x 4 x i64> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i64> @llvm.riscv.vssra.nxv4i64.i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.vssra.nxv4i64.i32.i32(<vscale x 4 x i64>, <vscale x 4 x i64>, i32, i32 immarg, i32)

define <vscale x 8 x i64> @test_vssra_vv_i64m8(<vscale x 8 x i64> %op1, <vscale x 8 x i64> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i64> @llvm.riscv.vssra.nxv8i64.nxv8i64.i32(<vscale x 8 x i64> poison, <vscale x 8 x i64> %op1, <vscale x 8 x i64> %shift, i32 0, i32 %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.vssra.nxv8i64.nxv8i64.i32(<vscale x 8 x i64>, <vscale x 8 x i64>, <vscale x 8 x i64>, i32 immarg, i32)

define <vscale x 8 x i64> @test_vssra_vx_i64m8(<vscale x 8 x i64> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i64> @llvm.riscv.vssra.nxv8i64.i32.i32(<vscale x 8 x i64> poison, <vscale x 8 x i64> %op1, i32 %shift, i32 0, i32 %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.vssra.nxv8i64.i32.i32(<vscale x 8 x i64>, <vscale x 8 x i64>, i32, i32 immarg, i32)

define <vscale x 1 x i8> @test_vssra_vv_i8mf8_m(<vscale x 1 x i1> %mask, <vscale x 1 x i8> %op1, <vscale x 1 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8mf8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i8> @llvm.riscv.vssra.mask.nxv1i8.nxv1i8.i32(<vscale x 1 x i8> poison, <vscale x 1 x i8> %op1, <vscale x 1 x i8> %shift, <vscale x 1 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.vssra.mask.nxv1i8.nxv1i8.i32(<vscale x 1 x i8>, <vscale x 1 x i8>, <vscale x 1 x i8>, <vscale x 1 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 1 x i8> @test_vssra_vx_i8mf8_m(<vscale x 1 x i1> %mask, <vscale x 1 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8mf8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i8> @llvm.riscv.vssra.mask.nxv1i8.i32.i32(<vscale x 1 x i8> poison, <vscale x 1 x i8> %op1, i32 %shift, <vscale x 1 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 1 x i8> %0
}

declare <vscale x 1 x i8> @llvm.riscv.vssra.mask.nxv1i8.i32.i32(<vscale x 1 x i8>, <vscale x 1 x i8>, i32, <vscale x 1 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 2 x i8> @test_vssra_vv_i8mf4_m(<vscale x 2 x i1> %mask, <vscale x 2 x i8> %op1, <vscale x 2 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8mf4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i8> @llvm.riscv.vssra.mask.nxv2i8.nxv2i8.i32(<vscale x 2 x i8> poison, <vscale x 2 x i8> %op1, <vscale x 2 x i8> %shift, <vscale x 2 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.vssra.mask.nxv2i8.nxv2i8.i32(<vscale x 2 x i8>, <vscale x 2 x i8>, <vscale x 2 x i8>, <vscale x 2 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 2 x i8> @test_vssra_vx_i8mf4_m(<vscale x 2 x i1> %mask, <vscale x 2 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8mf4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i8> @llvm.riscv.vssra.mask.nxv2i8.i32.i32(<vscale x 2 x i8> poison, <vscale x 2 x i8> %op1, i32 %shift, <vscale x 2 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 2 x i8> %0
}

declare <vscale x 2 x i8> @llvm.riscv.vssra.mask.nxv2i8.i32.i32(<vscale x 2 x i8>, <vscale x 2 x i8>, i32, <vscale x 2 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 4 x i8> @test_vssra_vv_i8mf2_m(<vscale x 4 x i1> %mask, <vscale x 4 x i8> %op1, <vscale x 4 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8mf2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i8> @llvm.riscv.vssra.mask.nxv4i8.nxv4i8.i32(<vscale x 4 x i8> poison, <vscale x 4 x i8> %op1, <vscale x 4 x i8> %shift, <vscale x 4 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.vssra.mask.nxv4i8.nxv4i8.i32(<vscale x 4 x i8>, <vscale x 4 x i8>, <vscale x 4 x i8>, <vscale x 4 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 4 x i8> @test_vssra_vx_i8mf2_m(<vscale x 4 x i1> %mask, <vscale x 4 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8mf2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i8> @llvm.riscv.vssra.mask.nxv4i8.i32.i32(<vscale x 4 x i8> poison, <vscale x 4 x i8> %op1, i32 %shift, <vscale x 4 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 4 x i8> %0
}

declare <vscale x 4 x i8> @llvm.riscv.vssra.mask.nxv4i8.i32.i32(<vscale x 4 x i8>, <vscale x 4 x i8>, i32, <vscale x 4 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 8 x i8> @test_vssra_vv_i8m1_m(<vscale x 8 x i1> %mask, <vscale x 8 x i8> %op1, <vscale x 8 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8m1_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i8> @llvm.riscv.vssra.mask.nxv8i8.nxv8i8.i32(<vscale x 8 x i8> poison, <vscale x 8 x i8> %op1, <vscale x 8 x i8> %shift, <vscale x 8 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.vssra.mask.nxv8i8.nxv8i8.i32(<vscale x 8 x i8>, <vscale x 8 x i8>, <vscale x 8 x i8>, <vscale x 8 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 8 x i8> @test_vssra_vx_i8m1_m(<vscale x 8 x i1> %mask, <vscale x 8 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8m1_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i8> @llvm.riscv.vssra.mask.nxv8i8.i32.i32(<vscale x 8 x i8> poison, <vscale x 8 x i8> %op1, i32 %shift, <vscale x 8 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 8 x i8> %0
}

declare <vscale x 8 x i8> @llvm.riscv.vssra.mask.nxv8i8.i32.i32(<vscale x 8 x i8>, <vscale x 8 x i8>, i32, <vscale x 8 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 16 x i8> @test_vssra_vv_i8m2_m(<vscale x 16 x i1> %mask, <vscale x 16 x i8> %op1, <vscale x 16 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8m2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i8> @llvm.riscv.vssra.mask.nxv16i8.nxv16i8.i32(<vscale x 16 x i8> poison, <vscale x 16 x i8> %op1, <vscale x 16 x i8> %shift, <vscale x 16 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.vssra.mask.nxv16i8.nxv16i8.i32(<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 16 x i8> @test_vssra_vx_i8m2_m(<vscale x 16 x i1> %mask, <vscale x 16 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8m2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i8> @llvm.riscv.vssra.mask.nxv16i8.i32.i32(<vscale x 16 x i8> poison, <vscale x 16 x i8> %op1, i32 %shift, <vscale x 16 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 16 x i8> %0
}

declare <vscale x 16 x i8> @llvm.riscv.vssra.mask.nxv16i8.i32.i32(<vscale x 16 x i8>, <vscale x 16 x i8>, i32, <vscale x 16 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 32 x i8> @test_vssra_vv_i8m4_m(<vscale x 32 x i1> %mask, <vscale x 32 x i8> %op1, <vscale x 32 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8m4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 32 x i8> @llvm.riscv.vssra.mask.nxv32i8.nxv32i8.i32(<vscale x 32 x i8> poison, <vscale x 32 x i8> %op1, <vscale x 32 x i8> %shift, <vscale x 32 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.vssra.mask.nxv32i8.nxv32i8.i32(<vscale x 32 x i8>, <vscale x 32 x i8>, <vscale x 32 x i8>, <vscale x 32 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 32 x i8> @test_vssra_vx_i8m4_m(<vscale x 32 x i1> %mask, <vscale x 32 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8m4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 32 x i8> @llvm.riscv.vssra.mask.nxv32i8.i32.i32(<vscale x 32 x i8> poison, <vscale x 32 x i8> %op1, i32 %shift, <vscale x 32 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 32 x i8> %0
}

declare <vscale x 32 x i8> @llvm.riscv.vssra.mask.nxv32i8.i32.i32(<vscale x 32 x i8>, <vscale x 32 x i8>, i32, <vscale x 32 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 64 x i8> @test_vssra_vv_i8m8_m(<vscale x 64 x i1> %mask, <vscale x 64 x i8> %op1, <vscale x 64 x i8> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i8m8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 64 x i8> @llvm.riscv.vssra.mask.nxv64i8.nxv64i8.i32(<vscale x 64 x i8> poison, <vscale x 64 x i8> %op1, <vscale x 64 x i8> %shift, <vscale x 64 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.vssra.mask.nxv64i8.nxv64i8.i32(<vscale x 64 x i8>, <vscale x 64 x i8>, <vscale x 64 x i8>, <vscale x 64 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 64 x i8> @test_vssra_vx_i8m8_m(<vscale x 64 x i1> %mask, <vscale x 64 x i8> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i8m8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 64 x i8> @llvm.riscv.vssra.mask.nxv64i8.i32.i32(<vscale x 64 x i8> poison, <vscale x 64 x i8> %op1, i32 %shift, <vscale x 64 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 64 x i8> %0
}

declare <vscale x 64 x i8> @llvm.riscv.vssra.mask.nxv64i8.i32.i32(<vscale x 64 x i8>, <vscale x 64 x i8>, i32, <vscale x 64 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 1 x i16> @test_vssra_vv_i16mf4_m(<vscale x 1 x i1> %mask, <vscale x 1 x i16> %op1, <vscale x 1 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16mf4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i16> @llvm.riscv.vssra.mask.nxv1i16.nxv1i16.i32(<vscale x 1 x i16> poison, <vscale x 1 x i16> %op1, <vscale x 1 x i16> %shift, <vscale x 1 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.vssra.mask.nxv1i16.nxv1i16.i32(<vscale x 1 x i16>, <vscale x 1 x i16>, <vscale x 1 x i16>, <vscale x 1 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 1 x i16> @test_vssra_vx_i16mf4_m(<vscale x 1 x i1> %mask, <vscale x 1 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16mf4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i16> @llvm.riscv.vssra.mask.nxv1i16.i32.i32(<vscale x 1 x i16> poison, <vscale x 1 x i16> %op1, i32 %shift, <vscale x 1 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.vssra.mask.nxv1i16.i32.i32(<vscale x 1 x i16>, <vscale x 1 x i16>, i32, <vscale x 1 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 2 x i16> @test_vssra_vv_i16mf2_m(<vscale x 2 x i1> %mask, <vscale x 2 x i16> %op1, <vscale x 2 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16mf2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i16> @llvm.riscv.vssra.mask.nxv2i16.nxv2i16.i32(<vscale x 2 x i16> poison, <vscale x 2 x i16> %op1, <vscale x 2 x i16> %shift, <vscale x 2 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.vssra.mask.nxv2i16.nxv2i16.i32(<vscale x 2 x i16>, <vscale x 2 x i16>, <vscale x 2 x i16>, <vscale x 2 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 2 x i16> @test_vssra_vx_i16mf2_m(<vscale x 2 x i1> %mask, <vscale x 2 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16mf2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i16> @llvm.riscv.vssra.mask.nxv2i16.i32.i32(<vscale x 2 x i16> poison, <vscale x 2 x i16> %op1, i32 %shift, <vscale x 2 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.vssra.mask.nxv2i16.i32.i32(<vscale x 2 x i16>, <vscale x 2 x i16>, i32, <vscale x 2 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 4 x i16> @test_vssra_vv_i16m1_m(<vscale x 4 x i1> %mask, <vscale x 4 x i16> %op1, <vscale x 4 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16m1_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i16> @llvm.riscv.vssra.mask.nxv4i16.nxv4i16.i32(<vscale x 4 x i16> poison, <vscale x 4 x i16> %op1, <vscale x 4 x i16> %shift, <vscale x 4 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.vssra.mask.nxv4i16.nxv4i16.i32(<vscale x 4 x i16>, <vscale x 4 x i16>, <vscale x 4 x i16>, <vscale x 4 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 4 x i16> @test_vssra_vx_i16m1_m(<vscale x 4 x i1> %mask, <vscale x 4 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16m1_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i16> @llvm.riscv.vssra.mask.nxv4i16.i32.i32(<vscale x 4 x i16> poison, <vscale x 4 x i16> %op1, i32 %shift, <vscale x 4 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.vssra.mask.nxv4i16.i32.i32(<vscale x 4 x i16>, <vscale x 4 x i16>, i32, <vscale x 4 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 8 x i16> @test_vssra_vv_i16m2_m(<vscale x 8 x i1> %mask, <vscale x 8 x i16> %op1, <vscale x 8 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16m2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i16> @llvm.riscv.vssra.mask.nxv8i16.nxv8i16.i32(<vscale x 8 x i16> poison, <vscale x 8 x i16> %op1, <vscale x 8 x i16> %shift, <vscale x 8 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.vssra.mask.nxv8i16.nxv8i16.i32(<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 8 x i16> @test_vssra_vx_i16m2_m(<vscale x 8 x i1> %mask, <vscale x 8 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16m2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i16> @llvm.riscv.vssra.mask.nxv8i16.i32.i32(<vscale x 8 x i16> poison, <vscale x 8 x i16> %op1, i32 %shift, <vscale x 8 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.vssra.mask.nxv8i16.i32.i32(<vscale x 8 x i16>, <vscale x 8 x i16>, i32, <vscale x 8 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 16 x i16> @test_vssra_vv_i16m4_m(<vscale x 16 x i1> %mask, <vscale x 16 x i16> %op1, <vscale x 16 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16m4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i16> @llvm.riscv.vssra.mask.nxv16i16.nxv16i16.i32(<vscale x 16 x i16> poison, <vscale x 16 x i16> %op1, <vscale x 16 x i16> %shift, <vscale x 16 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.vssra.mask.nxv16i16.nxv16i16.i32(<vscale x 16 x i16>, <vscale x 16 x i16>, <vscale x 16 x i16>, <vscale x 16 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 16 x i16> @test_vssra_vx_i16m4_m(<vscale x 16 x i1> %mask, <vscale x 16 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16m4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i16> @llvm.riscv.vssra.mask.nxv16i16.i32.i32(<vscale x 16 x i16> poison, <vscale x 16 x i16> %op1, i32 %shift, <vscale x 16 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.vssra.mask.nxv16i16.i32.i32(<vscale x 16 x i16>, <vscale x 16 x i16>, i32, <vscale x 16 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 32 x i16> @test_vssra_vv_i16m8_m(<vscale x 32 x i1> %mask, <vscale x 32 x i16> %op1, <vscale x 32 x i16> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i16m8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 32 x i16> @llvm.riscv.vssra.mask.nxv32i16.nxv32i16.i32(<vscale x 32 x i16> poison, <vscale x 32 x i16> %op1, <vscale x 32 x i16> %shift, <vscale x 32 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.vssra.mask.nxv32i16.nxv32i16.i32(<vscale x 32 x i16>, <vscale x 32 x i16>, <vscale x 32 x i16>, <vscale x 32 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 32 x i16> @test_vssra_vx_i16m8_m(<vscale x 32 x i1> %mask, <vscale x 32 x i16> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i16m8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 32 x i16> @llvm.riscv.vssra.mask.nxv32i16.i32.i32(<vscale x 32 x i16> poison, <vscale x 32 x i16> %op1, i32 %shift, <vscale x 32 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.vssra.mask.nxv32i16.i32.i32(<vscale x 32 x i16>, <vscale x 32 x i16>, i32, <vscale x 32 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 1 x i32> @test_vssra_vv_i32mf2_m(<vscale x 1 x i1> %mask, <vscale x 1 x i32> %op1, <vscale x 1 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32mf2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i32> @llvm.riscv.vssra.mask.nxv1i32.nxv1i32.i32(<vscale x 1 x i32> poison, <vscale x 1 x i32> %op1, <vscale x 1 x i32> %shift, <vscale x 1 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.vssra.mask.nxv1i32.nxv1i32.i32(<vscale x 1 x i32>, <vscale x 1 x i32>, <vscale x 1 x i32>, <vscale x 1 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 1 x i32> @test_vssra_vx_i32mf2_m(<vscale x 1 x i1> %mask, <vscale x 1 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32mf2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i32> @llvm.riscv.vssra.mask.nxv1i32.i32.i32(<vscale x 1 x i32> poison, <vscale x 1 x i32> %op1, i32 %shift, <vscale x 1 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.vssra.mask.nxv1i32.i32.i32(<vscale x 1 x i32>, <vscale x 1 x i32>, i32, <vscale x 1 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 2 x i32> @test_vssra_vv_i32m1_m(<vscale x 2 x i1> %mask, <vscale x 2 x i32> %op1, <vscale x 2 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32m1_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i32> @llvm.riscv.vssra.mask.nxv2i32.nxv2i32.i32(<vscale x 2 x i32> poison, <vscale x 2 x i32> %op1, <vscale x 2 x i32> %shift, <vscale x 2 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.vssra.mask.nxv2i32.nxv2i32.i32(<vscale x 2 x i32>, <vscale x 2 x i32>, <vscale x 2 x i32>, <vscale x 2 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 2 x i32> @test_vssra_vx_i32m1_m(<vscale x 2 x i1> %mask, <vscale x 2 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32m1_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i32> @llvm.riscv.vssra.mask.nxv2i32.i32.i32(<vscale x 2 x i32> poison, <vscale x 2 x i32> %op1, i32 %shift, <vscale x 2 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.vssra.mask.nxv2i32.i32.i32(<vscale x 2 x i32>, <vscale x 2 x i32>, i32, <vscale x 2 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 4 x i32> @test_vssra_vv_i32m2_m(<vscale x 4 x i1> %mask, <vscale x 4 x i32> %op1, <vscale x 4 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32m2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i32> @llvm.riscv.vssra.mask.nxv4i32.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %op1, <vscale x 4 x i32> %shift, <vscale x 4 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.vssra.mask.nxv4i32.nxv4i32.i32(<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 4 x i32> @test_vssra_vx_i32m2_m(<vscale x 4 x i1> %mask, <vscale x 4 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32m2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i32> @llvm.riscv.vssra.mask.nxv4i32.i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %op1, i32 %shift, <vscale x 4 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.vssra.mask.nxv4i32.i32.i32(<vscale x 4 x i32>, <vscale x 4 x i32>, i32, <vscale x 4 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 8 x i32> @test_vssra_vv_i32m4_m(<vscale x 8 x i1> %mask, <vscale x 8 x i32> %op1, <vscale x 8 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32m4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i32> @llvm.riscv.vssra.mask.nxv8i32.nxv8i32.i32(<vscale x 8 x i32> poison, <vscale x 8 x i32> %op1, <vscale x 8 x i32> %shift, <vscale x 8 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.vssra.mask.nxv8i32.nxv8i32.i32(<vscale x 8 x i32>, <vscale x 8 x i32>, <vscale x 8 x i32>, <vscale x 8 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 8 x i32> @test_vssra_vx_i32m4_m(<vscale x 8 x i1> %mask, <vscale x 8 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32m4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i32> @llvm.riscv.vssra.mask.nxv8i32.i32.i32(<vscale x 8 x i32> poison, <vscale x 8 x i32> %op1, i32 %shift, <vscale x 8 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.vssra.mask.nxv8i32.i32.i32(<vscale x 8 x i32>, <vscale x 8 x i32>, i32, <vscale x 8 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 16 x i32> @test_vssra_vv_i32m8_m(<vscale x 16 x i1> %mask, <vscale x 16 x i32> %op1, <vscale x 16 x i32> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i32m8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i32> @llvm.riscv.vssra.mask.nxv16i32.nxv16i32.i32(<vscale x 16 x i32> poison, <vscale x 16 x i32> %op1, <vscale x 16 x i32> %shift, <vscale x 16 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.vssra.mask.nxv16i32.nxv16i32.i32(<vscale x 16 x i32>, <vscale x 16 x i32>, <vscale x 16 x i32>, <vscale x 16 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 16 x i32> @test_vssra_vx_i32m8_m(<vscale x 16 x i1> %mask, <vscale x 16 x i32> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i32m8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 16 x i32> @llvm.riscv.vssra.mask.nxv16i32.i32.i32(<vscale x 16 x i32> poison, <vscale x 16 x i32> %op1, i32 %shift, <vscale x 16 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.vssra.mask.nxv16i32.i32.i32(<vscale x 16 x i32>, <vscale x 16 x i32>, i32, <vscale x 16 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 1 x i64> @test_vssra_vv_i64m1_m(<vscale x 1 x i1> %mask, <vscale x 1 x i64> %op1, <vscale x 1 x i64> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i64m1_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i64> @llvm.riscv.vssra.mask.nxv1i64.nxv1i64.i32(<vscale x 1 x i64> poison, <vscale x 1 x i64> %op1, <vscale x 1 x i64> %shift, <vscale x 1 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.vssra.mask.nxv1i64.nxv1i64.i32(<vscale x 1 x i64>, <vscale x 1 x i64>, <vscale x 1 x i64>, <vscale x 1 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 1 x i64> @test_vssra_vx_i64m1_m(<vscale x 1 x i1> %mask, <vscale x 1 x i64> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i64m1_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 1 x i64> @llvm.riscv.vssra.mask.nxv1i64.i32.i32(<vscale x 1 x i64> poison, <vscale x 1 x i64> %op1, i32 %shift, <vscale x 1 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.vssra.mask.nxv1i64.i32.i32(<vscale x 1 x i64>, <vscale x 1 x i64>, i32, <vscale x 1 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 2 x i64> @test_vssra_vv_i64m2_m(<vscale x 2 x i1> %mask, <vscale x 2 x i64> %op1, <vscale x 2 x i64> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i64m2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i64> @llvm.riscv.vssra.mask.nxv2i64.nxv2i64.i32(<vscale x 2 x i64> poison, <vscale x 2 x i64> %op1, <vscale x 2 x i64> %shift, <vscale x 2 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.vssra.mask.nxv2i64.nxv2i64.i32(<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 2 x i64> @test_vssra_vx_i64m2_m(<vscale x 2 x i1> %mask, <vscale x 2 x i64> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i64m2_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 2 x i64> @llvm.riscv.vssra.mask.nxv2i64.i32.i32(<vscale x 2 x i64> poison, <vscale x 2 x i64> %op1, i32 %shift, <vscale x 2 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.vssra.mask.nxv2i64.i32.i32(<vscale x 2 x i64>, <vscale x 2 x i64>, i32, <vscale x 2 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 4 x i64> @test_vssra_vv_i64m4_m(<vscale x 4 x i1> %mask, <vscale x 4 x i64> %op1, <vscale x 4 x i64> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i64m4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i64> @llvm.riscv.vssra.mask.nxv4i64.nxv4i64.i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %op1, <vscale x 4 x i64> %shift, <vscale x 4 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.vssra.mask.nxv4i64.nxv4i64.i32(<vscale x 4 x i64>, <vscale x 4 x i64>, <vscale x 4 x i64>, <vscale x 4 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 4 x i64> @test_vssra_vx_i64m4_m(<vscale x 4 x i1> %mask, <vscale x 4 x i64> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i64m4_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 4 x i64> @llvm.riscv.vssra.mask.nxv4i64.i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %op1, i32 %shift, <vscale x 4 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.vssra.mask.nxv4i64.i32.i32(<vscale x 4 x i64>, <vscale x 4 x i64>, i32, <vscale x 4 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 8 x i64> @test_vssra_vv_i64m8_m(<vscale x 8 x i1> %mask, <vscale x 8 x i64> %op1, <vscale x 8 x i64> %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vv_i64m8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i64> @llvm.riscv.vssra.mask.nxv8i64.nxv8i64.i32(<vscale x 8 x i64> poison, <vscale x 8 x i64> %op1, <vscale x 8 x i64> %shift, <vscale x 8 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.vssra.mask.nxv8i64.nxv8i64.i32(<vscale x 8 x i64>, <vscale x 8 x i64>, <vscale x 8 x i64>, <vscale x 8 x i1>, i32 immarg, i32, i32 immarg)

define <vscale x 8 x i64> @test_vssra_vx_i64m8_m(<vscale x 8 x i1> %mask, <vscale x 8 x i64> %op1, i32 %shift, i32 %vl) {
; CHECK-LABEL: test_vssra_vx_i64m8_m:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-NEXT:    csrwi vxrm, 0
; CHECK-NEXT:    vssra.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
entry:
  %0 = call <vscale x 8 x i64> @llvm.riscv.vssra.mask.nxv8i64.i32.i32(<vscale x 8 x i64> poison, <vscale x 8 x i64> %op1, i32 %shift, <vscale x 8 x i1> %mask, i32 0, i32 %vl, i32 3)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.vssra.mask.nxv8i64.i32.i32(<vscale x 8 x i64>, <vscale x 8 x i64>, i32, <vscale x 8 x i1>, i32 immarg, i32, i32 immarg)
