#include <catch2/catch_test_macros.hpp>

#include <QDebug>
#include <QString>
#include <iostream>
#include <pappsomspp/core/vendors/tims/timsframebase.h>
#include <pappsomspp/core/mzrange.h>
#include <pappsomspp/core/msfile/msfileaccessor.h>
#include <pappsomspp/core/msrun/private/timsmsrunreaderms2.h>
#include <pappsomspp/core/msrun/private/timsmsrunreader.h>
#include <pappsomspp/core/pappsoexception.h>
#include <pappsomspp/core/exception/exceptionnotfound.h>
#include <pappsomspp/core/processing/filters/filtersuitestring.h>
#include <QCoreApplication>
//#include "config.h"

using namespace pappso;
using namespace std;

// ./tests/pappsotree/catch2-only-pappsotree [timsXicDataSqliteDb] -s


TEST_CASE("Test tims XIC data extraction right form the SQLite db",
          "[timsXicDataSqliteDb]")
{

  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));
  

  QString file_path_name = "";

  // file_path_name =
  //"/gorgone/pappso/jouy/raw/2021_Tims_TOF/20211124_HeLa/"
  //"11-25-2021_1_HeLa200ng_2321.d/analysis.tdf";

  file_path_name =
    "/gorgone/pappso/versions_logiciels_pappso/bruker/"
    "200ngHeLaPASEF_2min_compressed.d";

  // file_path_name =
  //"/home/rusconi/devel/dataForMzml/bruker/20210126_HeLa.d/"
  //"1-26-2021_1_QC_HeLa10ng_826.d/analysis.tdf";

  // file_path_name =
  //"/home/rusconi/devel/dataForMzml/bruker/2021_Tims_TOF/20211124_HeLa/"
  //"11-25-2021_1_HeLa200ng_2321.d/analysis.tdf";

  qDebug() << "The file to use as a test base is: " << file_path_name;
  // When not in debug mode.
  std::cout << __FILE__ << ":" << __LINE__
            << " The file to use as a test base is: "
            << file_path_name.toStdString();

  SECTION("Test TIMS TIC chromatogram extractor")
  {
    INFO("Test the extraction from the SQLite database's Frames table");

    pappso::MsFileAccessor accessor(file_path_name, "a1");

    accessor.setPreferredFileReaderType(Enums::MsDataFormat::brukerTims,
                                        Enums::FileReaderType::tims);

    pappso::MsRunReaderSPtr p_msreader =
      accessor.msRunReaderSPtr(accessor.getMsRunIds().front());

    REQUIRE(p_msreader != nullptr);

    REQUIRE(accessor.getFileReaderType() == Enums::FileReaderType::tims);

    pappso::TimsMsRunReader *tims_reader =
      dynamic_cast<pappso::TimsMsRunReader *>(p_msreader.get());

    REQUIRE(tims_reader != nullptr);

    if(tims_reader != nullptr)
      {
        Trace tic_chromatogram = tims_reader->getTicChromatogram();

        REQUIRE(tic_chromatogram.size() != 0);

        qDebug().noquote() << "The TIC chromatogram has "
                           << tic_chromatogram.size() << " points "
                           << "and has the following points:\n"
                           << tic_chromatogram.toString();
        // When not in debug mode.
        std::cout << __FILE__ << ":" << __LINE__ << "The TIC chromatogram has "
                  << tic_chromatogram.size()
                  << " points and has the following points:\n"
                  << tic_chromatogram.toString().toStdString();
      }
  }

  SECTION("Test TIMS MS2 TIC chromatogram extractor")
  {
    INFO("Test the extraction from the SQLite database's Frames table");

    pappso::MsFileAccessor accessor(file_path_name, "a1");

    accessor.setPreferredFileReaderType(Enums::MsDataFormat::brukerTims,
                                        Enums::FileReaderType::tims_ms2);

    pappso::MsRunReaderSPtr p_msreader =
      accessor.msRunReaderSPtr(accessor.getMsRunIds().front());

    REQUIRE(p_msreader != nullptr);

    REQUIRE(accessor.getFileReaderType() == Enums::FileReaderType::tims_ms2);

    pappso::TimsMsRunReaderMs2 *tims_reader =
      dynamic_cast<pappso::TimsMsRunReaderMs2 *>(p_msreader.get());

    REQUIRE(tims_reader != nullptr);

    if(tims_reader != nullptr)
      {
        Trace tic_chromatogram = tims_reader->getTicChromatogram();

        REQUIRE(tic_chromatogram.size() != 0);

        qDebug().noquote() << "The TIC chromatogram has "
                           << tic_chromatogram.size() << " points "
                           << "and has the following points:\n"
                           << tic_chromatogram.toString();
        // When not in debug mode.
        std::cout << __FILE__ << ":" << __LINE__ << "The TIC chromatogram has "
                  << tic_chromatogram.size()
                  << " points and has the following points:\n"
                  << tic_chromatogram.toString().toStdString();
      }
  }
}
