/*******************************************************************************
 * Copyright (c) 2015, 2020 Dirk Fauth.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Dirk Fauth <dirk.fauth@googlemail.com> - initial API and implementation
 ******************************************************************************/
package org.eclipse.nebula.widgets.nattable.edit;

/**
 * Definition of editing related constants.
 *
 * @since 1.4
 */
public final class EditConstants {

    private EditConstants() {
        // private default constructor for constants class
    }

    /**
     * Value constant that is used in conjunction with multi select combo boxes
     * with checkboxes. Indicates that all values in the combo box are selected.
     */
    public static final String SELECT_ALL_ITEMS_VALUE = "SELECT_ALL"; //$NON-NLS-1$

}
