# Why use Enquirer?

Created by [jonschlinkert][jon] and [doowb][brian], Enquirer is fast, easy to use, and lightweight enough for small projects, while also being powerful and customizable enough for the most advanced use cases.

- **Fast** - [Loads in ~4ms](#-performance) (that's about _3-4 times faster than a [single frame of a HD movie](http://www.endmemo.com/sconvert/framespersecondframespermillisecond.php) at 60fps_)
- **Lightweight** - Only one dependency, the excellent [ansi-colors](https://github.com/doowb/ansi-colors) by [Brian Woodward](https://github.com/doowb).
- **Easy to implement** - Uses promises and async/await and sensible defaults to make prompts easy to create and implement.
- **Easy to use** - Thrill your users with a better experience! Navigating around input and choices is a breeze. You can even create [quizzes](examples/fun/countdown.js), or [record](examples/fun/record.js) and [playback](examples/fun/play.js) key bindings to aid with tutorials and videos.
- **Intuitive** - Keypress combos are available to simplify usage.
- **Flexible** - All prompts can be used standalone or chained together.
- **Stylish** - Easily override semantic styles and symbols for any part of the prompt.
- **Extensible** - Easily create and use custom prompts by extending Enquirer's built-in [prompts](#-prompts).
- **Pluggable** - Add advanced features to Enquirer using plugins.
- **Validation** - Optionally validate user input with any prompt.
- **Well tested** - All prompts are well-tested, and tests are easy to create without having to use brittle, hacky solutions to spy on prompts or "inject" values.
- **Examples** - There are numerous [examples](examples) available to help you get started.

If you like Enquirer, please consider starring or tweeting about this project to show your support. Thanks!

[issue]: https://github.com/enquirer/enquirer/issues/new
[pulls]: https://github.com/enquirer/enquirer/pulls
[jon]: https://github.com/jonschlinkert
[brian]: https://github.com/doowb
