/* Copyright 2017-2021 PaGMO development team

This file is part of the PaGMO library.

The PaGMO library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 3 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The PaGMO library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the PaGMO library.  If not,
see https://www.gnu.org/licenses/. */

#include <initializer_list>
#include <iterator>
#include <unordered_map>
#include <vector>

#include "cec2013_data.hpp"

namespace pagmo
{

namespace detail
{

namespace cec2013_data
{

namespace
{

const double dim_100[100000]
    = {-0.12473447677044233,    -0.0052606554355491926,  0.03844669640679442,     -0.1319933234316974,
       -0.15888867337141252,    -0.22170674939229754,    -0.059052618753754109,   -0.0083138102067401264,
       0.019361970055416178,    0.0048590050879654626,   0.13053325458671608,     -0.1503149692115871,
       -0.22616141498075959,    -0.072440011479738164,   0.072127605457560764,    0.091348688379671472,
       -0.012639806263228488,   -0.10769905068175539,    0.063285245693576339,    0.036287718584975794,
       -0.047786418925831797,   -0.067171263138153012,   -0.0019235150285988947,  -0.010567535506688045,
       -0.084902102438849436,   0.091454359927073223,    0.014507898926451442,    0.056616118663651592,
       -0.1921506921051194,     0.031058515657606617,    0.16506016795161002,     -0.014182607215590564,
       -0.0230876823345708,     -0.17725179264295138,    -0.099359144766552998,   -0.19821245246467792,
       0.037137864562370192,    -0.076725892332668258,   0.0019631814409043326,   -0.02615272207664851,
       -0.021030964449765651,   0.033537371462012085,    0.029028452024786343,    0.007948963509327174,
       -0.049209779623661465,   -0.14190016495849217,    -0.0032812180529596616,  0.043604809154389731,
       0.12651625269946787,     0.16279043047313072,     -0.075713626115242308,   -0.05206606920592368,
       -0.1140710503469443,     -0.1051456547425534,     -0.027303701045594767,   0.1329659617788386,
       -0.082017102919431539,   -0.03203131010650867,    -0.28155437464087607,    0.046938874236661418,
       -0.04767787360957277,    0.068270291603830621,    -0.086846085241722853,   -0.19852237605591921,
       0.046621650353391657,    -0.079171273795453134,   -0.016642157033912836,   -0.13211195786025229,
       -0.11298092982060484,    0.052414417681623734,    -0.081751237898870746,   0.098633522006815633,
       -0.002742267433601191,   -0.10024476009714157,    0.06475252779065746,     -0.0078548967082751088,
       0.026789355261797192,    -0.093304834956507779,   0.034251890631658052,    -0.085294775637591164,
       -0.080231290629640531,   0.029250627772234604,    -0.040851986894921373,   0.069606616359852228,
       0.14295087844163412,     0.13196026111963186,     -0.024324324777319446,   0.052339102118248812,
       0.00026874191564204425,  -0.17754919455829304,    -0.046895947323000065,   -0.10302650052046099,
       -0.20598913222402204,    -0.061485531575273714,   0.082811158441837784,    0.06093363702287434,
       -0.104643910101429,      -0.017739267826825483,   -0.17915044806165029,    0.16418474828245014,
       -0.036131749566672831,   -0.11276928261814835,    -0.0009949170905895156,  0.082041748194767006,
       0.011321957590045976,    -0.14198219230955014,    0.18238801810777525,     -0.095939950707431929,
       0.030026784461895824,    0.1340707690043613,      -0.13659315729846649,    0.10668995820237397,
       -0.00076299877402071382, -0.056916138418609721,   -0.014321456440325404,   0.087755571717715655,
       -0.048194302823961824,   0.068325588471910337,    0.10229439623974394,     -0.18204681923170643,
       0.015609855170406053,    0.040320218577549208,    -0.019243496676075826,   0.22147367010894475,
       0.061424009996562841,    0.0047108427123046664,   -0.11210197358093912,    0.022310045705429746,
       -0.033763673167374185,   -0.026548821261832747,   0.040403672223394464,    -0.20641403611688691,
       0.10140486085921331,     -0.16468752595747616,    -0.079300714076163681,   0.0118056805246944,
       0.061748803498079832,    -0.10811460899695283,    0.035916600140428384,    0.013612172668818515,
       0.015985143577890094,    0.20489663736490457,     0.12450757415339042,     0.043809279406710283,
       0.12725197365233895,     0.030251019835183076,    -0.023018814778834436,   -0.2419941804395217,
       0.089754069732390307,    -0.056785800197692658,   -0.11134058778824421,    -0.0067973354949458272,
       -0.10807925355128192,    -0.18542258854596486,    0.022729190684940496,    -0.0027453431529097924,
       -0.014052634636738904,   -0.076566197390231225,   0.054866341657251218,    -0.0047406811237165978,
       -0.10745891279370337,    -0.010939425909908245,   0.22649864058696481,     -0.05281057538710808,
       -0.071888572121436511,   0.15523822745070515,     0.14373704175727423,     -0.03569252479974188,
       0.022704534243792381,    -0.1618699254626193,     0.036649818929256624,    -0.0025365581574672037,
       0.20979627277008056,     0.018470974798828334,    0.02747979612465944,     -0.014481428010736982,
       -0.051045167975189772,   -0.013341357830873573,   -0.0798690695306494,     0.020350826650940502,
       0.142472757726854,       0.016858167460654491,    -0.035862587778003462,   -0.060258777455750416,
       0.105879784125779,       -0.030337121120672456,   -0.044871372289734868,   0.21066391154919217,
       -0.041733020904957431,   0.10401660704344659,     0.001797753054093772,    0.14721685970947804,
       0.076665854760327057,    -0.23771020303631568,    -0.080822639223934317,   0.069235303212534696,
       0.043118734399590193,    -0.072259739523426708,   0.022829415203182876,    0.12660355926083972,
       0.10007160485233871,     0.098644166183164336,    0.067014277634337913,    0.01226240462205434,
       -0.25548492292768321,    0.1650024241295916,      0.22289957285993175,     0.029539701747411232,
       -0.20608169685517724,    -0.060795209192646374,   0.049079960958357843,    -0.093415302652087362,
       0.028124110385388389,    -0.22779650716617858,    -0.015312361959509571,   0.0047990434079025635,
       -0.084013266913292819,   -0.13346090067312261,    0.032918774055031984,    -0.074402371615173282,
       0.035260807508172169,    -0.042211713266114705,   -0.03842505138160613,    0.08361570765396302,
       0.0016728800535270854,   0.14023407849394118,     -0.028945981710646183,   -0.05060811232483816,
       0.017177872668475015,    0.026908116519627198,    0.080945517817005666,    0.13608780873454718,
       0.040115185442975862,    -0.0054526744540988447,  0.064594387975773021,    0.13134769024950405,
       0.19004830909761219,     -0.05845842890781465,    -0.013624019937420677,   0.06911672203619712,
       -0.0086304897412331234,  -0.0018513081697666446,  0.14268231988259375,     0.04599487123869167,
       0.11866749056164395,     -0.066687579326453666,   -0.15909428387062471,    -0.00021058360849983068,
       0.0058657560139718287,   0.028609989034595058,    0.045568417926796723,    0.043470321832207295,
       -0.13399109866709713,    0.098120460279797081,    0.021266088588731382,    -0.037419254465771858,
       -0.046823093985616515,   -0.064657464124935046,   0.16060035363829567,     -0.091841300223090006,
       -0.13682295318807147,    -0.10829561606612474,    -0.086592441430340533,   0.016020550429034365,
       0.29243477450482458,     0.065295320886836108,    -0.10136935481871966,    -0.088925734767557829,
       -0.0010372866671691759,  -0.10778598836552598,    -0.039545065098737064,   0.0089359664927914674,
       0.086623124739258803,    0.025256308142180186,    -0.047661613905614936,   -0.18250015199655997,
       0.14908401764718054,     0.03088648643149032,     -0.17042054760031777,    -0.065505985613672532,
       -0.0086986393072497649,  -0.057079592651674185,   -0.019507001193695191,   -0.12511760515392226,
       -0.09286044829518629,    0.1001556735299806,      -0.075039886081099016,   -0.043289085283341945,
       -0.0010258331893528289,  -0.01729496461021179,    -0.086087499980137497,   -0.17536188888963306,
       -0.047945361362506031,   0.067808056179065601,    0.10647688223768705,     0.069370087775879483,
       -0.067520868575997192,   -0.021889243746427339,   0.22251115576254815,     -0.010880301306703713,
       -0.10019954012879645,    0.042395363846573941,    0.1045722695037762,      -0.065865226259510357,
       -0.064905339675409554,   0.12816762225736264,     -0.074956255401817093,   -0.12880627680157994,
       -0.054191900010031491,   0.031084930101647097,    0.13498607485698624,     -0.017312814165950926,
       0.066838378373857199,    0.048724359699218844,    -0.0062565684600461614,  -0.013159092276660201,
       -0.057824658551346719,   -0.18561215041643417,    0.1207872501543464,      -0.0175614667512696,
       -0.037027889569725532,   0.11223277647426474,     -0.043138817874306963,   0.069660003568654705,
       -0.040975018596645742,   0.047932841568231105,    -0.040349009810503642,   -0.029600210763049247,
       -0.079388903790402018,   0.20739431473728245,     -0.053614379676302386,   -0.011065239004231313,
       -0.12142346516463023,    -0.04198528542563694,    0.019906958176754017,    0.19235136620835533,
       0.055272088307136522,    0.064156116153790674,    0.17633287005826448,     -0.0096559710977096192,
       0.13942080571310272,     0.077728660548330525,    0.097490671990077368,    -0.13142914891470103,
       -0.0096060424328845307,  -0.15843655361072953,    0.067357028964978416,    -0.1836777973063338,
       0.11275649118313828,     0.12086056996389008,     0.0024831633214195438,   0.058474027478202267,
       -0.062441658942559305,   0.1589029529070734,      0.055339611717268353,    0.0026740774132394292,
       -0.061003456081500318,   0.14161924999590489,     0.016300967763144041,    -0.090858034165695281,
       -0.049476127355616031,   -0.19098658047633207,    0.044672598240449737,    -0.06123475955294283,
       -0.16937141751947082,    -0.15753609705725635,    0.1019095514142716,      -0.051027836057709886,
       0.10080639316136253,     0.11903849971457564,     0.1085564779897903,      0.014953543578160998,
       0.097704519288347322,    -0.087158306029918309,   0.067498205046707546,    0.1894350420747391,
       0.043444272767222555,    0.083896625895212421,    0.16450439737281142,     -0.16858563050441014,
       0.10764471763638678,     0.11086868706513221,     -0.052253981693405852,   0.020486119919845967,
       0.036534149663724508,    0.030430344221531177,    0.085419658270324272,    -0.18412437249222202,
       -0.081043743742824526,   0.070754551516713129,    0.062409542697025103,    0.10402976632580019,
       -0.07076967976217674,    0.14743861574391942,     -0.18005591443085506,    -0.067923733627343871,
       0.091349974143612275,    -0.1495553273408062,     0.033188791115657874,    -0.057235012939339067,
       0.016024917374540322,    -0.010436945947746299,   0.063277971778840272,    -0.028042857584533565,
       0.09421775158037636,     0.13536898864838512,     -0.052317994543857813,   0.0068917402366689834,
       -0.071790211005464802,   0.1353136173161405,      -0.0011391424904186372,  0.045608403494325808,
       0.048164438902848057,    0.020895002421615783,    0.15162225016689995,     -0.048641461838381361,
       -0.10251792100058625,    -0.1070854995368809,     -0.026100676184277281,   0.068025864264615238,
       0.111953482656882,       -0.055265689963787543,   -0.01166033225499704,    -0.072843720433666659,
       -0.15358979771360917,    0.19091572304866844,     0.006047043887328094,    0.14598869488991806,
       0.012239501990040027,    -0.24995689177066999,    -0.16920425516374332,    0.045274614062413752,
       0.13725998141150858,     -0.21247589009922047,    -0.18728391600198999,    -0.038527654713044875,
       -0.052800293150111657,   -0.062686596509355041,   -0.054496759166723328,   0.040220694470827045,
       0.00045947183903893998,  0.029186072244007426,    0.15837041844837432,     0.072987552221001367,
       -0.13919281603574782,    0.046711985570000711,    0.012722136609091682,    -0.067076635435854806,
       -0.048917420609518258,   0.27819128543511501,     -0.0061792410073414203,  -0.020449343416592658,
       0.055392951293840455,    -0.031425173217566021,   0.023587603848380122,    -0.074142852304259071,
       -0.042382565236283649,   -0.027643913904219157,   0.0047606332779731933,   0.042137365439378523,
       -0.1475210846901675,     -0.062416295666557292,   -0.14192704706804177,    0.070991355749141394,
       0.064303470855100103,    0.14498697818247167,     -0.16151651450724266,    -0.034970375594279395,
       -0.030057785376439852,   0.12190494697005577,     0.21972328057098942,     -0.12235362413391444,
       0.015469176121537621,    0.13056310599953461,     -0.070699978044908948,   0.053286464983229642,
       -0.089905256043129683,   -0.17726808037842254,    0.080123462946372709,    0.12164684736027546,
       0.040108319753181451,    -0.10630136841481089,    -0.071996357362675262,   0.083183326251164952,
       -0.13793220226781594,    0.021485596097696798,    -0.047591127940598034,   -0.096849779365297053,
       -0.1755417378842708,     0.052124460339806292,    -0.025511931524686251,   -0.024666672685589225,
       0.12663404833386746,     -0.051254314097155251,   -0.097749940855956244,   0.0085793205519928591,
       0.0330923418705543,      -0.12927047704699418,    -0.13561862070419897,    0.023604892901088203,
       0.077769014453026516,    -0.092911978290916311,   -0.018519640573238662,   -0.023273024512050492,
       -0.14212970114873155,    0.034429760846380199,    -0.05954974352525752,    0.031058160849300232,
       -0.13530869166046153,    -0.050882449374502051,   -0.035032090916957886,   0.042079249834352808,
       -0.0384863635105945,     -0.079141378971386248,   -0.097087339339184939,   0.10838769253198351,
       0.20780515244643363,     -0.048342418588870228,   -0.033222533248698088,   -0.10759098897974959,
       0.089086831136309719,    -0.019486664754092563,   0.072616403671401403,    -0.17088516021431702,
       0.013778783245864127,    -0.055535703881616952,   -0.038298271152342134,   0.033075104953329673,
       -0.026037670159251156,   -0.13527150007957014,    -0.099550056341661766,   0.039015634067936282,
       0.18726566889568952,     0.12290172280535376,     -0.047791140988246633,   -0.065789669651679289,
       -0.017744435391381666,   0.33855646067756684,     -0.25556113203792308,    0.08482988920614308,
       0.12052862945500285,     -0.065099157758709503,   0.13836708326456054,     -0.074667673112515973,
       -0.070321793963176241,   -0.046920509525043549,   -0.1050843736471098,     -0.068417380606655073,
       0.048058837270875329,    -0.12310104678847705,    -0.044599220918358995,   -0.0049105716362326871,
       -0.017142965118967846,   0.05383064749429109,     -0.13298783793455382,    0.11839882694460369,
       0.12895201465241016,     0.0079566439020546387,   0.00047100626579685365,  -0.16093554081611805,
       -0.032494557879163492,   -0.017912312110279709,   0.06544490272655018,     -0.046617622141616938,
       -0.035334039515443623,   0.021183913309318285,    0.14784024828634798,     -0.085981795632918689,
       -0.07166221893900418,    0.14775582456762723,     -0.14289661922227373,    -0.088427979778783555,
       -0.039151220306690493,   -0.10491710559550241,    0.017849580054791783,    0.14787480215985577,
       -0.01171549926643151,    -0.039917645915020734,   -0.16021002562384321,    -0.2150523553880391,
       0.044656640387344917,    0.017670271213731752,    -0.0032940982919369179,  0.063353423832540001,
       0.040889621467549556,    0.0074997703832073472,   0.073511700290670723,    -0.00085239923677350574,
       -0.096624219495239333,   0.013655617038007776,    0.061522315087063933,    -0.13659932627047455,
       0.13296053258391435,     -0.20253361785558938,    0.038682896756289102,    0.010801042741619873,
       0.05229767209263575,     -0.19824882996271073,    -0.064637803461848733,   -0.081393149746380539,
       0.044148846448218218,    0.24695146803824289,     0.019883597578796257,    0.043404808467327138,
       0.0091211307526117211,   -0.1236337209406987,     -0.073549781722236293,   -0.16503654835809115,
       -0.010936418027910143,   0.133267121671787,       -0.093054397438571176,   0.091250471138913977,
       -0.06702799771392666,    0.14086568983275319,     -0.01651403629714392,    0.02409711848590718,
       -0.004103512101566187,   0.015557729154325713,    -0.091656339465973777,   -0.016213092890581662,
       0.10898941822395483,     0.24259386591607657,     0.34035165395878364,     -0.11661215048174096,
       -0.13911098885966736,    -0.0072450669689747057,  0.026088372298317584,    -0.027865019684328883,
       -0.040247521576122797,   0.053231748353458827,    0.1463053044768485,      0.070920466555890405,
       0.0062254493023631962,   -0.068865943275737959,   0.052688970741950475,    0.21478245103158469,
       0.070783749701735343,    0.20054195365058963,     -0.1189760680447299,     -0.044874423591931376,
       -0.23561676728701422,    0.091172772639248861,    0.049930695242846219,    -0.038624603569892967,
       0.019480697688519805,    0.11047993117324816,     0.055249078440126331,    0.042213033250951437,
       0.084115282148850445,    -0.064259958339909731,   -0.0039682466119852124,  -0.09657259956608609,
       -0.032429132421330595,   -0.010982367409342296,   0.0080733563106116738,   -0.20408217261660402,
       -0.01659473877548151,    -0.11409963798536965,    -0.15593432562981255,    0.069264278944184576,
       -0.068447488300841852,   -0.089500862229446657,   0.10547738645935041,     -0.046474716755602184,
       0.13225442143682264,     -0.020378407647325854,   -0.085965919988831782,   -0.018630727563076585,
       0.062744797556893633,    0.048836391059133094,    -0.047124930374204226,   -0.10098112640179388,
       -0.038209796917363224,   0.08034826922768451,     -0.062146995662505394,   0.067884272506286966,
       0.081158044812197266,    0.08761295562841552,     0.07109266039763408,     -0.016017481523606828,
       0.043891979861343709,    -0.0691705260224557,     0.10473363781933134,     -0.048682467514076046,
       0.092130918261141101,    0.056179157967413761,    0.0062225697953217501,   0.09876790411749567,
       0.040389235210207423,    -0.011608597411724072,   -0.13842499097192501,    -0.10738344239042978,
       0.014611144980205775,    0.05537161327279002,     -0.21846660411966706,    0.1021946308919694,
       -0.11982893766021926,    -0.023600362957407087,   -0.01527727400148513,    -0.053348236075034292,
       0.036423486798446467,    0.066514997419258315,    -0.12715938663472526,    0.011224600838886776,
       0.0092284950024141589,   -0.10493180741807043,    0.093487646272442632,    0.052593407666629774,
       -0.26708870282049713,    0.053021475362214146,    -0.011392550545008574,   0.13582399512501483,
       -0.19641094454350605,    0.089897738878455175,    -0.13348435607627016,    -0.11254200587540697,
       0.021934680673795823,    0.19199489753243179,     0.033619145034866488,    -0.083501937113076505,
       -0.11677995128236468,    -0.11054573691716774,    -0.075813594498821454,   -0.031950630070174721,
       0.057159423916319077,    0.072488963305331347,    0.12527110320564816,     -0.12114764441622905,
       0.12469471457902687,     0.093440396458980141,    0.10484509116581288,     -0.25464103843328217,
       -0.050364999444624997,   0.0045058399447349962,   0.018828480232836488,    -0.11165871613944206,
       -0.019408799845771978,   -0.082680127209103671,   -0.010238262937078239,   0.10264645238162975,
       0.012543191797911291,    -0.025107756672227945,   0.071999303929228708,    0.032185805793630839,
       -0.16695106491164327,    0.12016318104696404,     0.055510442384007493,    0.012297158573949965,
       -0.13301354680060895,    -0.050796700416501833,   -0.0049949765084015855,  0.059486363685159846,
       0.17145819043189456,     0.065115336302123697,    0.049548074858067385,    -0.066546185206223671,
       0.12164114939104002,     0.015590623517010609,    -0.033912980307980393,   -0.066755414180854747,
       -0.31646211653738004,    0.084686443446423995,    0.07469252219280445,     0.015690683926611923,
       0.038587834780677829,    -0.061578275191580101,   -0.042339223726444553,   -0.047004516415079939,
       -0.087868311871889093,   0.15899207542005128,     0.18321845121139366,     -0.1121893991260067,
       0.17329388414009236,     -0.014534384903859268,   0.1083210795293007,      0.069088586407477975,
       0.049665814340793465,    -0.036345939735431765,   0.076159196033705176,    -0.1195026198884752,
       -0.10621421118340271,    0.1153851514614597,      -0.009973936243263485,   0.025903464863912422,
       0.031129863059200333,    0.14619989921065568,     0.037032197145225383,    0.002622093499482548,
       0.015241263355934948,    -0.049126411798430025,   0.010835551629694637,    -0.021902937685823423,
       0.076503350625574479,    0.21315290700994155,     0.049764885316057127,    0.10004201063767246,
       -0.016904439524694403,   -0.047944214949207455,   0.069705303577928188,    0.043249503424965842,
       -0.049849292870384615,   -0.026947978467777051,   0.049014474167066134,    -0.12689287884639869,
       0.14421563069142163,     -0.16087674552925627,    0.11550818116777761,     -0.24335684352861664,
       -0.05954973196679017,    -0.0380574431193706,     0.17762695534295592,     0.01061206079894185,
       -0.012311306510931552,   0.0060321311698974464,   -0.18603909523648171,    -0.02643373357312135,
       -0.15207912924043684,    0.069885608207177569,    0.10045168009058514,     0.10806233761716814,
       0.054048058905928391,    -0.070414874221529089,   0.078005832904818079,    -0.12127056060733908,
       0.20276625647378765,     -0.20371087474091784,    -0.13195427989136033,    0.18870397245130482,
       0.25785805562790121,     0.023101724704951608,    0.11038214055611871,     0.058675333277101879,
       0.10899475505316029,     0.10571993235730297,     -0.057266028729566765,   0.018227624222959239,
       0.12500347484186722,     -0.02647729488948207,    0.053969801901561587,    0.06571058054125864,
       -0.14635041271491919,    -0.023625062461820057,   0.10044722063868249,     -0.23256195516026806,
       0.13676199518574611,     -0.012467744938109787,   -0.06142169200904643,    0.0091206161388128135,
       -0.16185894321820046,    -0.016424003164310523,   -0.014011593024012364,   0.028698227304701281,
       -0.087619249947244904,   0.054233591704447179,    -0.076153418029693484,   -0.066464444357567945,
       -0.071670613244725678,   0.085617327025439824,    0.0091576879645417254,   0.095676870781991274,
       0.016152902804159944,    0.047937501639896019,    -0.08820449939328065,    0.1048655277526768,
       0.017699786956136443,    0.14260441700800763,     -0.047733788630829936,   -0.012679219439080316,
       -0.065704139401219275,   0.1243885060960126,      0.049828728624925621,    -0.011320945243086607,
       0.090506673730962703,    -0.10222468597526664,    -0.052791663089346769,   0.033988564735504836,
       0.1316328743224488,      -0.084391159831067319,   0.043556280287166751,    0.022711594708339243,
       -0.052729605969715029,   -0.1238915566444115,     -0.11233916041935128,    0.079829015005857526,
       0.10909019035829938,     -0.03924381448127167,    0.0053825208223775099,   -0.0040536595632772532,
       -0.069939579768370869,   0.12288954116240648,     0.094641350405374886,    -0.010657782733554874,
       -0.20966493124428709,    -0.072746007905196045,   0.017372094761173969,    -0.046524327166586887,
       0.04616791210701722,     -0.0097329782228173407,  -0.078156464440414269,   -0.070946245796747243,
       -0.029553742025653688,   0.1510971638146249,      0.054306070057683634,    0.027843124475823676,
       -0.03413015966937076,    -0.15149184017012163,    0.1476560293478954,      -0.036556878558135643,
       0.092279539561944873,    0.047261505289840508,    -0.054272181101167036,   0.0049962862774086628,
       0.13479602773010527,     -0.17271994199428614,    -0.003604990550814066,   -0.022618741637486735,
       -0.090988760569963537,   -0.10164033437031481,    -0.028187512086999697,   0.11059390468378252,
       -0.0091936474283261706,  0.014260800373212382,    0.090881276334674604,    0.070781340374486496,
       0.02944743266122438,     0.026732863147271954,    -0.091377067118299321,   -0.13502287186657372,
       -0.034144556071604271,   -0.036976929909060055,   -0.034927219263058196,   0.079323319889769262,
       0.0082632091928374757,   -0.077265006518259655,   0.23001165187073971,     0.043027589864078661,
       0.027617167651545364,    -0.012665412679790752,   -0.098018933280101972,   0.19265612857880923,
       -0.03694116263239252,    0.046609938232414883,    0.018856541427455957,    -0.087458787125756096,
       -0.11369253291285554,    -0.15455702439793167,    0.20321145508985508,     0.0036718695059640618,
       -0.19896369204166259,    0.09023126454802434,     -0.052554893360685521,   -0.019394624544429438,
       -0.010643410923425115,   -0.04303193607490105,    -0.029990557124910878,   0.30473963964248729,
       -0.086104089248670621,   -0.026850479911854679,   -0.051657243106782325,   -0.088132136547716539,
       -0.013773257765881702,   0.058392269154339392,    0.15333733024994634,     0.10154883700809726,
       -0.15392265575408587,    0.16763614717041234,     0.11212656430094645,     -0.025372014760470293,
       -0.0058802450743514721,  0.19843289133371853,     0.16797616206631719,     0.021964761682403581,
       -0.19029736282826931,    0.076685261337639199,    0.0091301851897702645,   -0.079344950570894759,
       -0.018634791201880982,   0.069711069547192514,    0.053077526306274159,    0.071796051280790057,
       -0.02211162850213845,    -0.06931563342951319,    0.093160499869676019,    0.1048226622455483,
       0.071978180453326324,    -0.10033814674789807,    0.032250296639629375,    0.065274658304934161,
       0.12407885291407637,     -0.059440745534133033,   0.15820248320919161,     -0.13649313235415633,
       0.1338461178564207,      0.12900917761797215,     0.13304316383271397,     0.052322475931827955,
       -0.0079838988404938895,  -0.078860057422712265,   0.11106898530694424,     0.049914949913378262,
       -0.014487536873721082,   -0.033123196491935937,   0.1086020842716104,      0.21617684084528752,
       0.018237632038190218,    0.20698029301941981,     -0.051225702326760339,   0.015625010546889063,
       -0.016638132175724938,   0.097031344350909113,    0.2116920413473945,      0.011322255399758258,
       -0.060942820988865859,   0.16506955585034749,     -0.083608470685001365,   0.011422998911851567,
       0.029417723801156856,    -0.046794861304453921,   -0.23861854028786103,    0.14754216932911754,
       -0.082020761430011038,   -0.092822281622664343,   0.085051470789234751,    -0.022148047904060133,
       0.040027992116086333,    0.071839078542691809,    0.04801298556899028,     0.059687615648656607,
       -0.037729250727286029,   0.069489808313676793,    0.0092936883359382924,   -0.17478603167302093,
       0.090788861706586108,    0.15822756096167256,     0.13577187542366556,     -0.0071423120186068145,
       0.14606948369662925,     0.027521328893836981,    0.019391464456351679,    0.11026194736562522,
       -0.13678803200636291,    -0.056476951280006488,   0.05091382672466805,     0.029827679998409747,
       0.056346702522684401,    -0.036530014461221338,   0.13060003562519887,     0.11809674139602445,
       0.02731755370780492,     0.066440225359704105,    0.026059050198831497,    -0.10442618970035807,
       -0.18617344046552772,    -0.033655607155289632,   0.012052332468225221,    -0.11649581581995207,
       0.013066337080848624,    0.052684366324488599,    0.057558525900689245,    -0.11175493719797447,
       0.083303651596328687,    0.096355166181701035,    0.046105276600973695,    0.1122638893954039,
       0.10538019272396108,     0.11865087753994641,     0.16095125630996082,     -0.13159967376299908,
       0.012130026849748753,    -0.08360187322305182,    -0.027551798555886346,   0.043319917592349287,
       0.011900088555147931,    -0.0078810711420855863,  0.18972987158326132,     -0.029903543316072194,
       -0.061771409704215068,   -0.028860164691251518,   0.040572713288591827,    0.055557862739042681,
       -0.0098161309516785686,  0.17518477085743225,     -0.0777079794810243,     0.077612798053963927,
       -0.023966088731077247,   -0.142938838939415,      0.1304616551905598,      -0.037748674182952441,
       -0.086538517270101895,   -0.012689803464414052,   -0.10002554165627651,    -0.069463165978072422,
       0.056696462651952856,    -0.056025591120871805,   -0.075549115062921668,   -0.05775786625060584,
       -0.050542864611694174,   -0.037405241939838754,   -0.0072602558450911969,  0.36739277076694626,
       -0.08245739755916219,    -0.041084284057300947,   0.17855826407180403,     -0.10526228721867056,
       0.033454002342151463,    -0.033360883650344758,   0.044959853292060974,    -0.010326078389182172,
       0.050434204744130379,    -0.11782533353336394,    0.011184223513252291,    0.16349159504833097,
       -0.11859897753945468,    -0.021547134642688596,   -0.036300667699134523,   -0.082155146371565888,
       0.049698326010910308,    0.020899033616920124,    -0.055140962821370161,   -0.045461137503914256,
       -0.0038061412561941847,  0.018853435943539061,    -0.085174469905916469,   -0.017116356309777436,
       -0.17763385638338133,    0.0074037622350762427,   -0.017271254494935787,   -0.069320549670240483,
       -0.050682045915015121,   -0.18830171892654815,    -0.13606324351167368,    -0.03170496636226957,
       0.10694190710301074,     0.099630771257764483,    -0.011215932385049369,   0.0097885363106651885,
       0.10935688407030089,     0.027465635589947038,    0.061514470729070875,    -0.0066001301612241374,
       -0.04712030639839896,    -0.086215122598830948,   -0.094081638202605775,   -0.18504181348510565,
       0.081952831020416908,    0.18196196179976976,     -0.12961849414638349,    0.043818658301482391,
       0.027498791736390138,    0.089223955778198485,    -0.16816913126576175,    0.079198857843465642,
       -0.057839665712120687,   0.11535877028129923,     -0.12996677959026234,    0.13796125655328803,
       0.018149952547591566,    0.0091219027069109337,   0.070186451610414008,    -0.09665571317946664,
       0.056344028014772243,    -0.0042071873816640539,  0.080240269416431156,    -0.031489164593916145,
       0.08520186691693217,     0.031855423396049201,    -0.10730888281607819,    -0.001915537557611811,
       -0.073409507975492394,   0.075618169359394222,    0.18642079165826725,     0.10885904936781263,
       0.068229268224136247,    -0.057406921706942643,   0.16689156023270396,     0.0084789536732978402,
       -0.088313254459186932,   0.12311890678559399,     -0.043516642969014245,   0.20302353709382615,
       0.21381814008567054,     0.025542215502652649,    0.19911907702387452,     -0.26765749060365041,
       0.056964777238552075,    0.083333747921837495,    0.052724908979258099,    0.12285605819675438,
       -0.042163928348837885,   -0.095349924553796178,   -0.11632420438452437,    0.079700029649540288,
       -0.073918272996700118,   0.20814596248187248,     0.027106254610131789,    -0.11687013218331251,
       -0.11201594219950403,    -0.071414652694099606,   -0.14388793602152428,    0.009807347619584128,
       -0.0017673394563837951,  -0.14107176580116637,    0.072934835122888134,    -0.037684334352468714,
       0.052237827604531023,    0.058678654489627065,    -0.044582130313236726,   -0.1887834887340287,
       -0.0032060603695306944,  -0.058260138724529939,   -0.071855540469362475,   -0.014864562260959302,
       -0.042106812412991794,   -0.056041428332504112,   -0.086363756571142147,   -0.1548005517033178,
       -0.029473945740863278,   0.14096066892211168,     -0.051158600932382864,   0.038359265371417012,
       -0.044512086059243706,   0.069022712899934849,    -0.029349821514283336,   0.15732666243802704,
       0.080467136400254144,    0.049986033101338694,    0.11139252558478345,     -0.081044973289908243,
       -0.23117990780141748,    -0.024662128797964325,   -0.07480547265167839,    -0.14395140276874255,
       -0.030008785624695923,   0.049416899539431076,    0.016045422365129236,    0.13682953613697185,
       -0.13793782130413232,    -0.047574110638794007,   0.0032815271323626757,   -0.02924755492345836,
       0.041283721958334421,    -0.29591462496978349,    0.075969141677486834,    -0.065535463555388987,
       0.072646675550005729,    0.039953433212452483,    -0.024054398697749377,   -0.13457834320648909,
       0.048643343965465512,    -0.1721225980270838,     -0.089243847087384101,   0.02221573958901911,
       -0.15739340182273509,    -0.090822707925615281,   0.0030318658517327758,   -0.047048840086138188,
       0.023332682535308132,    -0.12790906361603838,    -0.12604129238427919,    -0.11566010569539519,
       -0.040678185494344633,   -0.073474053386072352,   -0.041961343158225195,   -0.082667377279384863,
       -0.076069618131906602,   0.012078756360333759,    -0.046187951129253536,   -0.060474598800462187,
       -0.088421972696601292,   0.10969408459722396,     0.15012195097415074,     -0.017141848067577695,
       -0.17176025749033527,    -0.16815868782962648,    -0.18830592501845153,    0.039049196806749439,
       0.19664748430996698,     -0.061544613155728747,   -0.071741047213644021,   0.17263182789888826,
       -0.11729665904622205,    -0.12749830404761942,    -0.018385634460081894,   0.062241289255856209,
       -0.14917519223055326,    -0.01593494593070589,    0.020000043964333313,    -0.17620500286554275,
       0.042290096374694178,    -0.099764245267809012,   0.040454672275628545,    -0.034289640143572428,
       -0.013021945403368967,   -0.10990944717724159,    -0.12169696919728543,    0.080489807744232214,
       -0.1609048261919328,     0.073578134787594882,    0.086259980361723596,    0.10219800020569625,
       0.055985057662836193,    0.044674677205212801,    -0.039817616602155229,   -0.017743399670760333,
       -0.06514771118966213,    0.027616820796199121,    0.04930559336118822,     0.055198407265179002,
       -0.049515069233912502,   0.0078799573877491643,   0.083263580316966124,    -0.056409474872600597,
       -0.082048518957139521,   -0.0058106636127254734,  0.019652987195055888,    -0.084249841759029956,
       0.070247144050381682,    -0.044123837225658546,   -0.021255779183743558,   -0.0801587969897435,
       -0.033392502496015761,   -0.010656331613788659,   0.040042151372198007,    -0.090565223185978996,
       -0.0434927042544105,     -0.065599625893403318,   -0.13918081216477315,    -0.21433050824698427,
       -0.0063787247472822887,  -0.19855709813369898,    0.026709285126679892,    0.054841427705639594,
       -0.27513594188619017,    -0.045056017385865926,   -0.092980454313332364,   -0.18566301398306687,
       0.14539957096785106,     0.027971221196022064,    -0.065033965955041614,   0.0061543089138266296,
       0.0013201950132242157,   0.081292634114618817,    0.23221119679162924,     -0.10251452443141706,
       -0.0044512824619754778,  -0.088779549929713,      0.058271766533271915,    -0.13783087596280585,
       0.053673947121607564,    0.035560073603542609,    -0.19625142675770993,    0.0057915199248397805,
       0.15615849770527637,     -0.016085301462638726,   0.088326843566757227,    -0.013046978092319427,
       0.13560003281410493,     0.090145317354764776,    0.072051302929148062,    -0.032084189467297478,
       0.24726343042526724,     0.067035442131771442,    0.075970420263275121,    0.052688403620913697,
       -0.048582015479031238,   0.047692556137350253,    -0.12028269652805311,    0.010823421708252992,
       0.017192949104647446,    -0.079082086695224665,   -0.10976862914354611,    -0.15357112264394709,
       -0.015639942824463945,   -0.051176940937032331,   -0.014381302229809108,   0.11391426658748012,
       0.24379534759878788,     -0.043980089399030545,   0.015943849027566979,    0.19810006852821527,
       -0.15282149125626787,    -0.00039601955264928447, 0.22995834054107794,     0.014950701140819374,
       -0.04916308079544883,    -0.067832129190173271,   -0.077366722445284419,   -0.032170114098136013,
       -0.0027703997029534452,  0.15752226132462555,     -0.046818068308448126,   0.078787883456450158,
       -0.10700510582902707,    0.05309345507461103,     -0.090462175906079689,   0.012956661293271856,
       0.079167877057093772,    0.057596404893094151,    0.050871508944728409,    0.2206728795340834,
       0.13688391133694355,     -0.013695499382922149,   0.030985463419656883,    0.1773027671316936,
       -0.037694971578417329,   -0.12863496954669545,    -0.19550662492712975,    -0.047497989722699474,
       -0.11888374844706756,    0.079129110430963892,    -0.11705839040398881,    -0.034047737805500786,
       0.055655458747636152,    -0.049449039750280283,   -0.056522873047356766,   0.0033990209488017828,
       0.045075211395465734,    0.076299946955210238,    0.2052666760627164,      -0.021923523049974029,
       0.0067885927641122036,   -0.029118916762784584,   -0.10616250096524531,    0.062464006090836618,
       0.047810018853885791,    -0.052123840962923662,   -0.15603351105071142,    0.068322589211478352,
       -0.0074798681108888716,  -0.012684278979737623,   0.020206587330797499,    0.0056693861891000093,
       -0.00067649394015806101, 0.15147326215458265,     -0.08342831167174139,    0.070579300963941077,
       0.042424878659014315,    -0.21910358943007172,    -0.089136272073622763,   0.19302563428735534,
       0.14314006406330629,     -0.054001142500518129,   0.14298251668968148,     0.006531500186989907,
       -0.052323418510261427,   -0.18683584590860447,    0.047467972770710132,    -0.0049932071671601568,
       -0.12769904807274371,    0.03901385599727452,     -0.013871414880079726,   -0.17657147516247429,
       0.023628015964123075,    -0.057558095742992955,   -0.11548671587235078,    -0.052319424139800369,
       -0.037040293324878348,   -0.035519513224828027,   0.046983088325189187,    0.10861090950283581,
       0.080737451330375368,    -0.066170428739810605,   -0.018685512916575758,   -0.040065846501790542,
       0.27090522733119093,     -0.15970182360420759,    0.13334085515734143,     0.0039157825119842758,
       0.17472951369433926,     0.061961898590157244,    -0.050638711565493683,   0.027261989478750893,
       -0.022987115935019117,   0.042037946995629794,    0.090546672806783954,    0.18255568012828605,
       -0.0641384716410109,     0.075533606400832329,    -0.03387655890714443,    0.14786147948383283,
       -0.056444006864263936,   -0.033614666949435962,   0.09421639373473549,     -0.011596366306082977,
       0.074471759500546519,    -0.11478110239698799,    -0.063559990637608352,   -0.080069261985203602,
       -0.1066118484552572,     -0.17930330837711259,    -0.068391035514291612,   0.14128404993733612,
       0.062000679171600188,    0.10310033754596976,     -0.028299418547937816,   -0.0054580171209942267,
       -0.2362106499562574,     0.044960441156645409,    -0.10453184189338538,    -0.083384352551091057,
       0.14972794400108286,     -0.07786323423288552,    0.16735482633321136,     -0.0032006652427807453,
       -0.10737303317082178,    -0.14592200822703716,    0.11429264016473868,     0.021736857003955671,
       0.085793800321174438,    -0.066053079552604643,   0.013445988707679751,    -0.19925782977861747,
       0.12327117109386163,     -0.05366484637533997,    0.04794634202540235,     0.014319129686659651,
       0.0037917979235771075,   0.017350932615198138,    0.083274306188117389,    -0.15219238159389636,
       -0.077503892881073039,   -0.081334792391838204,   0.080615075601363412,    -0.0952133380372195,
       0.068826459589756472,    -0.098125392634747649,   -0.0039360582462062491,  0.092147941437009648,
       0.044430113654356784,    -0.10476339487399419,    -0.15014913207240138,    -0.13213421057729144,
       -0.04838390847589185,    -0.012669263371465997,   -0.17061563027163493,    0.0012483187144207136,
       -0.15457063720011877,    0.078564025484455749,    0.13070525107439226,     0.042004744782754296,
       0.038188604107390368,    -0.032191781925266408,   -0.002138598668986952,   0.15357478397105173,
       0.14212925324309464,     0.067759243108222858,    0.072692462074644054,    0.11981377790997214,
       0.04310335078715636,     -0.013284460625706217,   0.044177180488076485,    -0.23753151377393372,
       0.059930087732843577,    0.17199280364747385,     0.02598525240220969,     -0.011110864802417426,
       -0.021291358584197187,   0.005660650302295598,    -0.21014560711774019,    -0.061114184915463547,
       0.017329253567649094,    -0.010148983737793504,   -0.08514888499506755,    0.15588514802829331,
       -0.005939495005142072,   0.13242085205987536,     0.047973972058671668,    -0.10735982102175685,
       0.031490207016948359,    0.14940996537757506,     0.075024233275285998,    -0.15215763333518875,
       -0.014642879666500682,   -0.010339880759632315,   0.01362579402783279,     -0.20986208301418047,
       0.027688395946039238,    -0.025440184266731107,   -0.043011992700906651,   -0.16963278946787896,
       0.093024808146859927,    0.075497026752772742,    0.10571531661489803,     -0.039464138891873862,
       0.089497245013183874,    -0.063206637619709849,   -0.068027521599114918,   0.0080492022177877896,
       0.017152414470138946,    -0.1368139284327336,     -0.086771314132810681,   0.079822956725233027,
       -0.056077148998364204,   0.11942068538427449,     -0.28844192934055257,    -0.028656257808032711,
       0.046215318348933797,    0.04198915081122602,     0.1370454025882322,      0.062365519970758329,
       -0.025519654347521459,   -0.013793794304734186,   -0.018269743568872794,   0.0064949990216809327,
       0.02176987650111209,     0.14593998316451648,     0.20850442718992573,     0.0053652955982681459,
       -0.072264766112198592,   -0.023518402928050477,   0.059933360598198461,    0.1422733399883602,
       -0.14869098693591867,    0.082841210234775281,    -0.041408916564557807,   0.15181491644996095,
       0.12683547623124217,     0.0034924709169863238,   -0.054358261649994202,   -0.11074185006954651,
       -0.057921461086124851,   -0.0460791016328609,     -0.1649964354650027,     -0.05307946948872283,
       -0.071911505238054313,   0.084250217923856272,    -0.13470801012361547,    -0.026672615276953519,
       -0.045653210192536042,   0.069132423866824666,    0.086989642280066878,    0.15595401201050543,
       0.096675630471500518,    0.040128077308591796,    0.10990092359879428,     0.11191235795928534,
       -0.30814338775147748,    -0.041266674309002237,   -0.091206716145135702,   -0.050880929562543649,
       0.14158307351444041,     -0.016254544236567078,   -0.14278947396274888,    0.047403851618443911,
       0.11810897825465284,     -0.14728158347691059,    0.083327814049033708,    0.05596386526160102,
       -0.143317017179315,      0.070351439322303269,    -0.33829026260606582,    -0.050151971188041294,
       0.14046547182556271,     0.037384904620407985,    -0.066424526489531024,   0.012755764651980557,
       0.020783784229258681,    0.010391136947710987,    -0.058582184019691085,   0.11561099814653582,
       -0.030671144844523043,   -0.14888473004291253,    0.029627525061346034,    0.050095049180658643,
       -0.061268915926238197,   0.12491577100782306,     -0.10599988994292064,    -0.097246877254622624,
       -0.0041743261439870036,  -0.039124163889379185,   -0.026549239884537994,   0.035882829352368834,
       -0.055970984991918618,   0.18239735409577468,     0.073031283839051303,    -0.0047150627563852633,
       0.17848661670983262,     -0.044404558116242915,   0.076749822980802629,    0.066632763066912237,
       -0.015027047648315773,   0.054673376436125708,    -0.16052344786855052,    0.0091155058277198244,
       0.17457341231196885,     -0.052239844423993306,   0.060807563239393271,    0.0080461988139167804,
       -0.0081443504508053807,  -0.041435371466126372,   -0.063872784657593176,   -0.0042109070894659067,
       -0.090509132872495332,   -0.12202211081499566,    -0.16652310726453057,    -0.034390559531089097,
       -0.058967488706671775,   0.045600782482397184,    0.048898869096663355,    -0.091205714545390282,
       0.036721952971666021,    -0.056912028219437527,   0.075504853239438036,    -0.1018831914947355,
       0.2005311342029524,      -0.025087602572320039,   -0.17023307233465451,    0.064795241525915759,
       0.11263793908029829,     0.01842188801090161,     -0.022857979728173123,   -0.038596057526626128,
       -0.0013085036213717049,  0.068134871368909541,    -0.31508979114470842,    -0.098443780687726773,
       -0.0677513279309023,     -0.00094943553109059359, 0.16244760156013896,     0.047145076281372038,
       -0.13932663539012061,    -0.015698407083695635,   0.11164115521038163,     -0.053765373256392343,
       -0.025376288289177731,   0.30468325762395315,     -0.12735284623779156,    -0.015159494039813846,
       -0.011136054053695169,   0.18814317893298016,     0.021512382404840023,    0.035877565740739817,
       0.017592952611627376,    0.02757802926238332,     -0.1364244617905308,     -0.10267861249894231,
       -0.1385106616551989,     0.027819132965299195,    0.053583229144430658,    0.02832704916604285,
       0.010249431220691139,    -0.00045912736470590104, -0.00080832551724818735, -0.044577335427649696,
       0.12537179501066015,     -0.086154592956203341,   0.016264171478178449,    0.050212470141042936,
       0.015679428776554677,    -0.087713966795257461,   0.071971716791531498,    0.10736199844177084,
       0.089763912780314925,    -0.043136464944640671,   -0.028602406779699569,   0.19465891784624198,
       0.055851642199115786,    -0.06147301834642193,    0.11949745687247655,     0.083388156024293725,
       0.076534220366534164,    0.067557728224655667,    0.0042021435291049744,   -0.11704970814482733,
       0.051512701313937259,    0.035865049392216013,    0.0060840334863793656,   0.041468920421561695,
       0.18607030303645297,     -0.060099771347742352,   0.080145972524673384,    0.020927401290068828,
       -0.024957893926987718,   0.17076401995964513,     0.02029206259703923,     0.053716077927979861,
       0.020526661560345688,    -0.25922378498995247,    -0.096294734574719182,   -0.090496302221082903,
       0.055636538008732771,    -0.061507830540852883,   0.11988961062770231,     -0.17882051304267024,
       -0.020614362789023989,   0.012178392672272305,    -0.0087698737188445543,  0.0034972939875906736,
       0.0036586033800503279,   0.051004207289742268,    -0.062626373498275087,   -0.2328083356772524,
       -0.0097212804014968693,  0.011433166476824925,    -0.080947728216765269,   0.055247249599493661,
       0.016198517563925655,    -0.17815534947300715,    0.14492071364828157,     0.086059307739498381,
       0.095534530081431451,    -0.15075366536821067,    0.0065874041701569803,   -0.098131295180802589,
       0.033152020260258833,    0.052472894440825792,    0.032718300735825268,    -0.27478361147324054,
       0.027318388952833887,    0.12983041932178246,     0.099485062191083828,    -0.04615102756037949,
       0.079719684435469507,    -0.067241388417988476,   0.06647060979425741,     0.084838935066465296,
       -0.075501253907878152,   0.081596365585894448,    0.040161220606343945,    0.070682124569966615,
       0.085256192061062511,    0.055251414464188561,    -0.070629475928433189,   -0.073514105385083864,
       -0.14605754321210049,    0.0284737035296194,      0.12183295958201877,     0.013886150574183806,
       -0.095112582866272471,   0.05820941155641287,     -0.26392756862263761,    0.080991110343517608,
       0.093565868065831906,    0.01623652923863772,     -0.15856717227933759,    -0.056519771781514488,
       -0.046771859647268814,   0.09215918595392901,     -0.034688098529200344,   -0.025794654221330791,
       -0.03557852865496075,    0.049711274298111119,    -0.076653979407724393,   -0.070592295927575627,
       0.013411477199899413,    -0.032857497872101488,   0.064994320561414548,    0.051509205229044015,
       -0.052989303100576632,   -0.072803740140655146,   -0.055210122590603553,   -0.031238420446928039,
       0.040593969916204641,    -0.043803497334937387,   0.10085886539753347,     0.023963676175996027,
       -0.039758469363906354,   0.035669648477335753,    0.055319276777323012,    0.078189952642782556,
       -0.12897341266736734,    0.084683697851945183,    0.048582990775802054,    0.24693727623710499,
       0.014425587246953983,    -0.16822321986449851,    -0.10730930811511442,    0.068166331924462864,
       0.15914922875054138,     -0.12486050521652525,    0.026033932899188778,    0.023421650655946688,
       -0.022509381958062173,   -0.13391731027248893,    0.14841625358180449,     0.14454757800908682,
       0.21287240627672135,     0.18435888765510969,     -0.10370587529736748,    -0.091742637629679422,
       -0.11321818846302836,    -0.050004187857465646,   -0.11743925764620883,    0.0099096761397101576,
       0.064903964702521993,    -0.02587306767610318,    0.017515979323387745,    0.17457153079320917,
       -0.072422141434238085,   -0.12226775929450184,    -0.10628533557941142,    0.043275494474292735,
       0.084075199226903277,    0.068865383232815824,    0.18419376645424176,     0.15237457054809944,
       0.060446991243994858,    0.01725031418253533,     0.10447353066530206,     0.18287765640645082,
       -0.019758889722131089,   0.10054842543519456,     -0.14362778426532002,    -0.16249121503549538,
       -0.11898093086869885,    0.080409361601383303,    0.024407935068228873,    -0.041927203812273654,
       0.017534959735219548,    0.14213489063917195,     -0.07512490996077964,    0.23165560011498543,
       -0.023425951379541426,   0.046596053665338297,    -0.013884405761706142,   0.19259118030430722,
       -0.058820133319656159,   -0.04181802870689854,    0.20505986566059142,     0.13476190497008336,
       0.051591386719076794,    -0.020157508571948202,   -0.070985002581113565,   -0.1057315094406671,
       0.033113591857744241,    -0.038486841959984523,   -0.12483889308366009,    -0.023075194058919682,
       -0.086466931365540761,   0.15068517897900854,     -0.24614825616792643,    -0.09451344508910417,
       -0.067793791166782053,   -0.098079930356010814,   -0.020470567596435882,   0.034617720373630437,
       -0.053178505097347999,   0.11222322079758082,     0.035638314957960063,    0.1147119282946908,
       0.025957438655355689,    0.080894023349516717,    0.031925797609830636,    0.080109735142006047,
       -0.10223050351689855,    0.15058145537140979,     -0.047004377959569174,   0.044339751702493324,
       0.075686818889992957,    -0.065811822712295506,   -0.030282814393180146,   0.02045861398095291,
       0.0020176650367868462,   -0.23436331463254037,    -0.20624568290398676,    -0.045784522078648478,
       0.045935636621670085,    0.20441081068719935,     0.055157407797014564,    0.092785098448116457,
       0.18862945116465091,     -0.052461633277728667,   -0.0016391982462779005,  0.022598027282231113,
       0.16343669032679956,     0.0058682866214499162,   0.061954213466575869,    0.0036889082273879889,
       -0.15026913649575246,    0.080928163245990142,    0.083012674885235407,    -0.039018050232357479,
       0.10805711799685921,     0.041605504196458462,    -0.088868171086925629,   -0.11279926910671216,
       0.077940627160250076,    0.052941412650762069,    -0.11076767493971656,    0.02382724737326174,
       0.056948508843975398,    0.094370903968766851,    -0.049739559441464222,   -0.028304656180595546,
       -0.057197139115914938,   -0.089093776101361544,   -0.0072827651537225686,  -0.090859918977546764,
       0.12763594937961178,     -0.086002860171010928,   0.13648874931419994,     -0.17626497954527048,
       -0.10061202469089919,    0.069547886559393979,    -0.023441223383604437,   -0.072215496544642224,
       -0.032238303861902476,   0.15187032999768005,     -0.029966939428860268,   0.12504242839245269,
       0.074292930924355183,    -0.056965916735150071,   0.070968061702556665,    -0.058506406865531893,
       0.022165624134926967,    0.090624328234864299,    -0.010632691764025698,   0.012062742680023069,
       -0.15449024737518552,    0.17249134237229349,     -0.077221415129423224,   -0.0027850544035526083,
       0.1349376612002838,      0.076906642782899243,    0.22654753903374877,     0.15826236903199778,
       -0.14290174502384179,    -0.13722120835058219,    -0.094760722019327143,   -0.014187005035401733,
       -0.068162782185448786,   -0.0016183066891598888,  -0.11469343071317739,    0.097066294430615249,
       0.053495697063420632,    -0.060860240097488146,   -0.10150215287033178,    0.11467606555433124,
       0.089428734834479481,    -0.11563324770230435,    0.20896606341983789,     -0.087406544609759315,
       0.10417399582676755,     0.0089103999121113893,   -0.061714510664437915,   -0.11388730389687017,
       -0.094784271123186228,   0.26380957257649268,     0.23266440672287911,     0.066511596380877308,
       -0.051435011563959507,   0.072035068415615633,    -0.037249840600209125,   -0.075793016458651857,
       0.080457808447688683,    0.010058504699431427,    0.031917143102045707,    0.017776556970729822,
       -0.009308219020822836,   -0.059509983368511307,   -0.05622065428789607,    0.14655812037394975,
       0.047262318930683209,    -0.16113967901171644,    0.12484665938924973,     -0.043291349454824428,
       0.068033017200826162,    -0.2115476837851954,     0.073175247595948872,    -0.11970508958707746,
       0.024699008754851561,    0.19530301883503515,     -0.007943813828243898,   -0.1348138905548594,
       0.092478544291682785,    0.096406279278293761,    0.0063917092088002156,   0.01502159213023775,
       0.00023254451110390692,  0.072294089131874739,    0.033019700663814676,    0.083386019347603424,
       -0.11317039369472932,    0.047190097797145385,    0.092602029765549015,    0.12574211644079983,
       0.056919620646577573,    0.13632687835022717,     -0.0045024245175498082,  0.018613084643131366,
       -0.13369303422277271,    0.046899699546445461,    0.05517222968105942,     0.017206908288348439,
       0.0085876279432531497,   0.035754836335743605,    0.028181591488817895,    -0.14827019854943618,
       0.19694542867456319,     -0.14580344986527516,    -0.0076204229564497891,  0.021306361158157344,
       -0.11945511624410861,    0.031316944601134586,    -0.028486994574603706,   -0.0058244438053916565,
       -0.0041783734038782962,  -0.085402152954411739,   0.026743017338737241,    -0.14983574068435998,
       -0.032756664491749521,   -0.086620301352123397,   -0.078993445334965579,   -0.10683997060342651,
       0.10190134769455976,     -0.032993433639738466,   -0.037010040141005986,   0.0063281229354252098,
       -0.12753408744551464,    0.17458601142687027,     -0.035649143212001813,   0.10230219157209977,
       -0.070708533444788363,   0.11886207305317731,     -0.008522651805858936,   0.022483747925752473,
       -0.009120925486350219,   -0.065630389248692869,   -0.20002418437753469,    -0.29354392102460908,
       -0.065280220553333212,   -0.0046093936675679834,  0.049015675457118255,    -0.069880090091487129,
       -0.056886899981549242,   -0.016579151144134923,   0.026958259874769849,    -0.082227116064182995,
       0.2140916302731507,      0.018178507447398361,    -0.14577677534236477,    -0.0032411070732789298,
       0.099049572799367047,    0.0077944421329076679,   0.060279278949821602,    0.055578905184125268,
       0.031115618642135419,    -0.14446716798591902,    0.14464026121212231,     0.020336919530354689,
       0.1490292618381677,      -0.028669553420461596,   -0.0057132783411155182,  -0.10994531431680406,
       -0.10860491132507892,    -0.10760885067986695,    -0.092440144853647224,   -0.16309823410201379,
       0.075735274927398011,    -0.062323400681296159,   0.031114221901121744,    0.060397283385958629,
       -0.060099595943935699,   -0.023489072646993913,   -0.072216650181330444,   0.16540529605612644,
       -0.089370279900230776,   -0.21954564479281122,    -0.15306501600133968,    0.033759243529321546,
       -0.023004592146933161,   -0.0070385523736892436,  -0.13727883190434745,    0.076762718557533027,
       0.20860675827194458,     -0.13830033634956429,    0.12741352133398792,     0.081445470926278532,
       0.029254383353361127,    -0.004482927666050825,   -0.086492932023901209,   -0.1222842285432469,
       -0.14671389487363973,    0.0089156046866799704,   -0.045121440066340834,   -0.14062143188609819,
       0.024569415468074899,    0.054550256618967813,    0.15137736881501576,     0.017072304816215758,
       0.12813907869228863,     -0.11287660462049334,    0.033197629272510049,    0.10497887814691934,
       0.030632164890127319,    -0.092581583202488452,   0.0082008730419569111,   0.019893513186028999,
       0.0080837976767345679,   0.013782643295778831,    -0.10689368593398632,    -0.047115452141511166,
       -0.11684174868159719,    0.021594829582782131,    0.06678880611134895,     -0.13628673844193617,
       0.1760597053817278,      0.062406885784692806,    0.099082736499102653,    0.1600215137701119,
       -0.049316943125886616,   -0.036741159166054888,   -0.16019294458156569,    0.090101877998970223,
       -0.05234298470999238,    -0.0079301772715141272,  0.0041554345176262452,   -0.14630874086738377,
       -0.26739204433220704,    -0.061394728865983253,   -0.020914859329002177,   -0.035254360720644043,
       0.099454883711448422,    0.054097279252302927,    0.090381843388570401,    -0.044302398287012608,
       -0.22640364696130114,    -0.076250887746428422,   0.068737825937882094,    -0.0035883307960278572,
       -0.079477119824791942,   0.040588073853919798,    0.11884136343385467,     -0.095154473703878181,
       -0.017902915674119585,   0.080571067000554802,    -0.062536646622146752,   0.097127265881486347,
       -0.06226918155740687,    -0.052389976558520041,   0.22681400612475605,     -0.044341228886284244,
       0.0013869946631155305,   0.032540502622844213,    0.080001381925735332,    0.10608418879960697,
       -0.14366435331541511,    -0.052023687145131663,   -0.080119252151250875,   0.0066667672045779645,
       0.0051570121982892365,   0.03773576734629757,     -0.089547414285932284,   0.065228461286868128,
       -0.038408283362792311,   0.0032699362324151754,   -0.13729206032649507,    -0.053839414494118068,
       -0.062849211769726229,   -0.033957633085387677,   -0.07566891108483767,    0.12887790380934977,
       -0.079589430049545523,   0.1667541508794011,      -0.075115761398829445,   0.029327902056499908,
       0.11200120039234869,     -0.03185745537284447,    0.01690611073679649,     0.093035223044477644,
       0.23416789476257582,     -0.12374141701285553,    0.046634632653408857,    0.199442519322371,
       -0.14574263553742575,    -0.021102039690103741,   -0.06057966473908017,    0.12052318811092454,
       0.12419303074790698,     0.074061039292236508,    0.060315318141438416,    -0.03653803664569201,
       0.090558306048399637,    -0.12109476457435339,    -0.010173497897256004,   -0.068160698053173249,
       -0.063851098287755648,   -0.097390733313489811,   0.016182987014380673,    -0.091008768631614501,
       0.016040628516105205,    0.091591874460144385,    0.13322699848716613,     -0.023299597125334647,
       -0.14476713503858057,    -0.0018763815824749674,  -0.015091992641024983,   0.015722351029379973,
       0.14458240016375207,     -0.23486578194558627,    -0.16472957600176383,    0.054426695353281276,
       0.040919102764536128,    -0.12007337927530459,    0.11915145864080948,     0.016798489594180614,
       0.060238275001270616,    -0.065337300924818348,   -0.17271557549181463,    0.19668730114223903,
       0.1714451297623294,      -0.12395627606851106,    0.0042663564354554588,   0.05038623591612356,
       0.019540402425998263,    0.0051500664806984047,   -0.084773896005711946,   0.12260479441015622,
       0.085039095276511753,    0.1186088765266417,      0.14707143031531875,     -0.13120571037210937,
       -0.15485209436027783,    -0.025602908661705365,   -0.0017180526238685532,  -0.01916240979959281,
       -0.3180011976118578,     0.079315777064946968,    -0.033314868604704506,   0.016445974543543761,
       -0.0038736798685205529,  0.072756923516031205,    -0.01608343362631114,    0.080239023662400474,
       -0.15123579263735429,    -0.018020464426243533,   -0.1174027465393413,     -0.06497868083621007,
       -0.010144701248622833,   -0.025547544509805436,   0.021595156704490012,    0.05259272081963523,
       0.01620020448475603,     -0.13736730329236146,    -0.029022450348938529,   -0.0092094697487492515,
       -0.13276002585860489,    -0.047331552791578871,   -0.034856140733101601,   0.22320860241393822,
       -0.044640336657154001,   -0.034168386582880232,   0.03703720123561044,     0.13360650651836434,
       -0.088117722389339223,   0.016784958147296747,    0.15115717259136247,     0.10878684699770561,
       0.11014139331024268,     -0.051607229687912426,   0.070430739145219565,    0.078591631791950445,
       -0.095788005953698629,   0.1850368972293982,      -0.088925108710644657,   -0.043228229192594468,
       0.18944547046251486,     0.018843693018517359,    0.030933249272447831,    -0.18112958253278671,
       -0.11746421564202993,    -0.14370547780239151,    0.14943060561848762,     0.10305074048733312,
       0.028893468220330502,    -0.026095199701130646,   0.064119583575979855,    0.22173847800744539,
       -0.0081568997170453836,  0.11096089278675486,     -0.07697233528521806,    -0.03263266681527232,
       -0.062090226731746773,   -0.029029160836235187,   -0.08955859280092425,    0.042189166560850339,
       0.025172123867790809,    0.0071614410756845959,   -0.067460473867450452,   0.10030790625009287,
       -0.020582180227248163,   0.014693540576530691,    -0.11529430872213041,    -0.09766581197708292,
       0.18369555201295557,     0.085716562613995712,    0.04455626832871637,     0.072493100377251304,
       0.054587975629754926,    0.14504802873281178,     0.031395457658074548,    0.032147741416805112,
       -0.16237997813007013,    -0.096303057245599177,   0.069739950962025399,    -0.23795736457946148,
       -0.056560681177337729,   0.050304154441791503,    -0.012366735190398711,   -0.038735667491925668,
       -0.17924461844590256,    0.078849489996313291,    -0.049385165780996672,   -0.18569548915829867,
       -0.10755426895854622,    -0.087726714124215205,   -0.082333298158629525,   0.24415723959009986,
       -0.016633503752082633,   0.12352771717868029,     -0.085259207362797421,   -0.0077039760215991447,
       -0.061775449921956729,   -0.10977299165711683,    0.14804146426288009,     -0.029408847609047491,
       -0.1677013943006217,     0.031409290411045489,    0.12721022840129059,     0.0077355879604740843,
       -0.25950404779706288,    -0.041569802670989531,   -0.07956672987606872,    -0.21265543848123006,
       0.057628412403792399,    0.062668647322106794,    0.18834604496587623,     0.10567062235923652,
       -0.041871267172094301,   0.073105603993746715,    -0.11596496096283138,    0.13138005312104328,
       0.24274182574659825,     -0.0044787760874375896,  0.17644893525005179,     0.098627600132500201,
       0.076775810236659303,    -0.093872751445173097,   0.027774450111862206,    0.039855866022054209,
       -0.12454244002995193,    0.032580279434744112,    0.081545436300524604,    -0.044240399006495262,
       0.016608228465636317,    -0.024276582673286168,   -0.073903022077375841,   -0.0077789415350013168,
       -0.1430800448174509,     -0.079006560743105192,   -0.0070429943686276409,  -0.062711903815664244,
       0.025221745204749287,    0.056542256264714909,    0.13361685329929099,     -0.050642559578550891,
       0.13507371843874841,     0.12137433204056297,     -0.19762091950694288,    -0.076357462678854612,
       0.094873699572713924,    0.049621103717599084,    0.082228346788723372,    -0.06097575816131829,
       0.0131788160801265,      0.010739157256299346,    -0.058035158259266174,   0.017845742220994519,
       0.022238094702800172,    -0.01700580069505123,    -0.008451724691048771,   -0.0060117661717191554,
       -0.030849287207261419,   -0.11747263442685763,    0.16588718970523281,     0.12795764191237566,
       -0.054788815638640596,   0.043035692451426175,    -0.065998237363027012,   0.096628710637941206,
       0.036712482792366843,    -0.045774568232007082,   -0.011030637051532396,   -0.095329566992069348,
       -0.030442711831940417,   -0.082882134966837218,   -0.060205618315081401,   -0.047869994929011353,
       0.037936044659532819,    0.083935585745678679,    -0.047906287890040478,   0.052378736835135678,
       0.062625479053998623,    -0.1924320135159038,     -0.15053144574176502,    0.0044203133864314341,
       0.023620802253324906,    0.043960806254304666,    0.16221210095170996,     -0.048216405331199599,
       -0.046659382718970535,   -0.10486905053196345,    -0.11345992212813934,    -0.034399101402343098,
       0.013565863951214676,    0.0026908355658564224,   -0.022934410032664179,   -0.19867998083917671,
       -0.10500721914092917,    -0.034453910495714939,   0.07317589017937734,     -0.090777777277668434,
       0.14037348779507852,     0.089701897996358845,    -0.13421166845999585,    0.25326544417404762,
       0.081808742307885596,    -0.12543115216636844,    0.030290326957029517,    0.07799050487139865,
       -0.065118310412255534,   -0.058834209369185882,   0.1888713597864613,      0.19045967592971108,
       0.12533137887571655,     -0.035033531615212998,   -0.0013015145212875241,  -0.1714345653475812,
       0.021181711662085167,    -0.041739660226839226,   -0.03481540994967313,    0.042385277254218409,
       0.022373761724319798,    -0.099514141164403463,   0.058204912047166907,    -0.016613724867838915,
       -0.026212719882133736,   -0.072882009054225261,   0.20179840367062543,     -0.095956797232039953,
       -0.085245247821634743,   0.091599955796266647,    -0.019244677859020409,   0.033461115852726257,
       -0.0043914449105080878,  -0.087641265701946552,   0.12294571934167643,     0.043914824405883297,
       0.017740559156134667,    -0.07222384743755679,    -0.10976829146238766,    -0.040089436034475463,
       0.12721645509731333,     0.095733928098572937,    0.10653935956734929,     0.068141346017870544,
       0.025136137248125079,    0.091963625767221863,    -0.11923457195358543,    -0.10906275812331682,
       -0.053459156308749589,   0.0019112193913431246,   -0.034669566611889885,   0.00030341110612002202,
       0.12104929449228655,     -0.05112406179481311,    -0.00052443832889307674, -0.0099111547245488516,
       -0.16250359949136947,    0.083564829329036111,    0.034368365775788549,    -0.10984318359037457,
       0.020366257594630961,    -0.0044232367584523162,  -0.052401550385984132,   0.15260097720862018,
       -0.092579977577288364,   -0.018848712844188216,   -0.024699492099126009,   0.13450567124914778,
       -0.018583860113434637,   0.12263610891663974,     0.047655015189628835,    -0.214210462168831,
       -0.22438676969200033,    -0.035595507762034975,   -0.043617171413084806,   0.16893578112982732,
       -0.20156157090817015,    -0.037241818555668549,   -0.12221079346371415,    -0.14522688954935151,
       0.091417228480604865,    -0.12253261518424838,    0.084335707298121051,    -0.12139756203287921,
       -0.051101116789302972,   0.10840659800383279,     0.0011307198800372211,   -0.15249084737998417,
       0.084265254737763112,    0.0038034804614525638,   -0.10775816376572071,    -0.0049266322964626377,
       -0.05354914539077478,    0.05058411305973267,     -0.076405770946717133,   -0.11095273127273531,
       0.021660117970124817,    0.0060150716972877513,   -0.13955651083618245,    0.031120973025167076,
       0.046272206585716437,    -0.031481937392711427,   0.062991800810893991,    -0.13902662799854199,
       0.12836528038340358,     0.04472907982618566,     0.010824668426208075,    0.0082940977307334844,
       0.12356131145066993,     -0.12938725005732213,    0.056805594826424402,    0.10838500751470534,
       -0.071408463312912576,   -0.077402403039258674,   0.012460440057582142,    0.13155256149844133,
       0.065971538912503319,    0.087785242972782562,    0.015626608209130154,    -0.11071343133116426,
       0.12635861730079723,     -0.092250840187884264,   -0.014571306871952495,   -0.051541688398243649,
       -0.1177827486827947,     -0.091499120242564624,   -0.075772673841618579,   -0.11174557690237044,
       -0.24149217935682851,    -0.11173649332312913,    -0.0037665921428836286,  0.05241926051449932,
       -0.0046583812220376032,  -0.1262130070954488,     -0.10459640137392776,    -0.1105662730323049,
       0.098151977279879302,    0.20338994985155789,     -0.023726256935690686,   -0.13502131617345042,
       0.05549599409101022,     0.079833879940385849,    0.050682024934712959,    0.088069558145844259,
       0.17342602809911326,     0.11940471681859641,     0.04467452540334868,     0.20050998405873319,
       -0.21777455277309141,    0.085055595913340859,    0.22397223267560148,     0.062603536687601019,
       0.038109060164890594,    0.084401980666274676,    0.098951941350519407,    -0.053104412459744461,
       0.060434450452446817,    0.052065562013287915,    -0.04384117127841438,    0.20378857497150898,
       -0.086742856039539476,   -0.12342670119243154,    0.055580552109487862,    0.016741444039981662,
       0.1315744496308098,      0.020780766439960397,    0.019882097175057473,    -0.016066312966915564,
       0.13791321271654003,     0.046478621743929013,    0.16719822804502651,     -0.00076135169821297209,
       -0.15874284378720119,    -0.064725203912450346,   0.029635616663171344,    -0.14035339096628183,
       0.11274857976761225,     0.093797896260355243,    -0.046605645283890114,   -0.13026338615718999,
       -0.19960552770483037,    0.023730930777574044,    0.033365056823678386,    -0.14271616686379132,
       0.023104487442906319,    0.048366544565626397,    0.061992991068014834,    -0.047978389708926004,
       0.04792853735711216,     -0.0061022724033740258,  0.10730117678920956,     0.017385250669955409,
       0.064958771039643162,    -0.064885237738681545,   0.15694943534482692,     0.024573320033895521,
       -0.094114172648285213,   -0.10826657790561729,    -0.056661466534820196,   0.074960226585866263,
       0.041377099900156207,    -0.098633889795957774,   -0.022887523617743051,   -0.084790927023739582,
       -0.087787764996827319,   -0.014194057910895216,   0.050925672355869069,    0.11805524459463608,
       -0.040990777298353744,   -0.076817635317622812,   0.060306831970139932,    -0.003218933615447726,
       -0.12847725272995675,    0.12416704225037316,     -0.14877793904332465,    -0.026446119194920879,
       -0.023095862718697471,   0.1128137653049905,      -0.05096452531830796,    0.16726806994833757,
       -0.094815789886472088,   0.22360562483549951,     -0.18572077287480901,    0.10738319184769907,
       -0.098947694822902346,   0.025075530565253142,    0.11526111681374854,     -0.091729024211068599,
       -0.075600415475199273,   0.047326084695984136,    0.063592043812220889,    -0.067444199302620397,
       -0.037347386166735282,   0.062813126579021633,    -0.16578202978370879,    0.050269665490931488,
       -0.020015145444112634,   0.03739121453654614,     0.087632769425378315,    -0.10908261017807078,
       0.18295397897892626,     -0.10131803040021625,    0.027661638700354565,    -0.057406339971063182,
       0.034473514658993815,    -0.067339054864128445,   -0.045373917944294719,   -0.094202833238698297,
       -0.070437727518515986,   -0.092878508759717024,   0.090386633731447202,    -0.1131545654763256,
       0.061679268403208254,    0.084401587989083871,    0.051452719287964514,    -0.065082902922141583,
       -0.093137556612045133,   -0.18490310818784494,    0.011176056683315776,    -0.15971941965383143,
       -0.17124191137061504,    -0.095761317048602024,   0.029707900153829327,    0.090248849962561176,
       -0.047145975534234719,   0.099538779528896393,    0.21989747916737526,     -0.10810157718781842,
       0.033306765760191537,    0.14803813923979792,     0.023862444323081995,    0.17548478570113482,
       -0.042912490672020714,   0.058550158844151351,    -0.10147934024080671,    0.079413502463263619,
       0.084153844185482274,    0.009192231960267588,    0.098958003283619436,    0.077233459522183703,
       0.045475187484461235,    -0.140455036809185,      0.14317310599398869,     -0.26707187946237854,
       -0.13673103057298838,    0.043061943684593207,    -0.027940755844191808,   0.14068821448666041,
       -0.042812743085202346,   -0.0051497731028409491,  0.077359149642170832,    -0.097172391622716306,
       0.1491720946159984,      0.094620476551493693,    0.010167798052734935,    -0.08234026212473923,
       -0.085332933287503354,   -0.024120886711839127,   0.11092777706508627,     0.1042314113066895,
       -0.079680289041998947,   -0.079644941032100999,   0.15042044575938179,     -0.13746751502835031,
       0.025487719601233923,    0.11460319715949753,     0.050199193676882012,    0.0055439683103954366,
       -0.11221132486086709,    0.0219734324790637,      0.21061736314835841,     -0.017793776860878616,
       0.07136893465004783,     -0.033641423360101716,   -0.057674657908387508,   0.01744663300252081,
       -0.032916569394140123,   0.072251526228112511,    -0.12998554052878661,    -0.068902891295638993,
       0.050161392081721747,    0.097691203804849969,    -0.083665591404198464,   -0.12392244847768255,
       0.13559598794579364,     -0.013608971090228138,   -0.043129565566570285,   -0.024177717358342864,
       0.015471681887653152,    0.27807318406152148,     0.011866742423420718,    0.057358977993579766,
       -0.029109704194252115,   -0.016292658093565476,   0.14708590523756399,     -0.095362467494144981,
       0.10500055537436247,     0.058919588526140612,    -0.04432339239845929,    -0.054922804680488699,
       0.13150105971523937,     0.11334371065058252,     0.02431893824879957,     0.19388129353089478,
       0.073668148543510698,    -0.23612930648250943,    0.020521260252175429,    -0.025318752817103524,
       -0.023507589762772479,   -0.084058070798591386,   -0.14788943477341557,    0.013329679231930024,
       -0.046049008894758145,   -0.016487832207248219,   -0.098664143725362113,   0.0072686307089056476,
       0.11905398952682385,     0.0030658568165025032,   -0.12125559908882484,    -0.016545044631362749,
       0.16265515477129677,     -0.082821077145277561,   0.016558854193330745,    -0.16987027416719186,
       -0.10211345678871703,    0.074009719032161608,    -0.10506252895613022,    0.044330737290276145,
       -0.065866367894758374,   0.034350084975996432,    -0.12344937334060226,    0.026250196194388314,
       -0.024966708138842036,   -0.13801734533275128,    0.16993877702406532,     -0.081964924479784013,
       0.24124173183588224,     0.042383787792161301,    0.031986432846875822,    -0.082634549493978665,
       0.043970443594207417,    -0.02987005065388856,    -0.032926449074146436,   -0.016839998746266252,
       -0.31107745576352408,    0.03957739780703011,     -0.026007955438654126,   -0.13800744680474972,
       0.12856447836782228,     0.22034054977103573,     -0.0076238608938082311,  0.13691373422200712,
       -0.078066220016910104,   -0.02002489088512386,    0.060658744806020966,    0.069127379437668224,
       -0.037750273297997267,   0.090938217354646786,    0.089430297390907215,    -0.080294029520542029,
       -0.022524534502373957,   -0.026816128321392192,   -0.069942699088215529,   -0.14860372241694839,
       -0.1599235352296616,     -0.13893244604535598,    0.085138807775580624,    -0.11135665779704457,
       0.13868000365118649,     0.097072262101542114,    -0.1764862898209256,     0.20342886516992262,
       -0.015922752138215888,   0.022713417873501975,    0.097702718491363416,    0.07342445390644306,
       -0.027407545879976916,   0.066816817121077579,    -0.021598624946113823,   -0.11956493343240354,
       -0.041155398024637399,   0.28890296636148094,     0.041899219602909266,    -0.20421457571571,
       0.059425491386122777,    0.11320272728759165,     0.050873922373706831,    -0.034765497687648347,
       0.005276092724899038,    0.01986946054162609,     -0.22713291408506561,    -0.16323928777615054,
       -0.066465629668952225,   0.075486904904248239,    -0.12709295882835986,    0.02131467690257962,
       0.068832016878435237,    -0.018011496729643764,   -0.1169248194657643,     0.0022792299273667622,
       -0.0093894181027289955,  -0.14795054752896222,    0.18540387759070159,     0.16740113426247083,
       0.031113219711999103,    0.14106777665683778,     -0.11102433332015653,    0.045458228742458605,
       -0.064931835134775087,   -0.06727872462942075,    0.0060107055902737369,   0.083758741719164378,
       0.072753227449458419,    -0.0051142147647872099,  -0.13795717588330561,    0.061609432478790069,
       0.068983797426882709,    0.20117537649515066,     -0.08357587025178953,    -0.01222086612355424,
       0.024620566511526505,    0.078348925123719645,    -0.11106018676412496,    0.015716263328534964,
       -0.019540117253558337,   -0.098224329616532158,   0.028874203594423574,    -0.013045961048459221,
       0.013436513113469214,    -0.058760158268745338,   -0.028216291413788123,   0.023342930601549277,
       -0.0022960420977704964,  -0.21149283010582812,    -0.051043948557003713,   0.10778558077835865,
       -0.054911222826455428,   0.025918108751863476,    -0.024286594624090312,   -0.050424506439214423,
       0.065668585804945473,    -0.12535846084800362,    -0.13041228228106902,    -0.12294028415470251,
       -0.063819082263204055,   0.0050085569564186846,   -0.03483034804219963,    -0.0055726567881905029,
       -0.17437343766987676,    -0.10202748754145559,    0.13655752695457854,     -0.02359367986684088,
       -0.076792072357521737,   -0.011983118907379596,   -0.097705833299005049,   -0.18540775738270487,
       -0.10511616665234981,    0.12816299756515759,     0.035153207365341568,    0.031701091097681183,
       -0.068105459887495848,   -0.10258468530555798,    -0.085962819133278301,   -0.0098376015663859985,
       0.13017935752176341,     0.14094975424399236,     0.0035343403714523372,   0.15166491730053211,
       -0.090778911729922626,   0.015531869207776734,    -0.16950770874850296,    0.070062263335899835,
       -0.02942501337186347,    0.008011415805431743,    -0.11411316382110012,    0.040086422920530974,
       0.12691493513371824,     -0.034531253066034932,   0.052560476484508949,    0.06234789902011649,
       -0.11266235904530207,    -0.11521558035010251,    0.050559698784502997,    0.090003783569090445,
       -0.15648669044154587,    0.067490938857363056,    0.0078710138703831003,   0.024619719818815156,
       -0.20451322496727642,    -0.18447251829209099,    -0.02077235587151316,    0.029894784162141398,
       -0.2956287495909955,     -0.027013708346789414,   -0.029924812239570026,   0.045295505516528237,
       -0.0037498329646097495,  -0.082610670065415157,   0.058980873775199331,    -0.0031143734904285642,
       0.085495578798631261,    -0.16751304298761674,    0.14745958265098102,     0.033654178878229371,
       -0.075048277549822295,   -0.068798055466855357,   -0.055966664763153096,   -0.24095925352447156,
       0.056280189672379743,    -0.070473149063088977,   -0.017285668030613099,   0.04957388319568997,
       -0.061504296106372029,   0.046271461973764735,    -0.20120656759593253,    -0.024975138150753987,
       0.11462763806493274,     -0.036540643353159055,   -0.18844087774949639,    0.046358341754950926,
       0.22694778375457705,     0.049685954036646975,    -0.0067817593701574282,  -0.15115754321123881,
       -0.02404169464484069,    0.037740556542047679,    -0.10722568208038544,    -0.038406407611074965,
       0.14457654764946315,     0.022502640912654762,    0.14804843471613494,     0.091153370010589041,
       0.094790271876708576,    -0.12231086864872005,    -0.08698069090630671,    -0.064245174901637947,
       -0.092710900836915161,   0.062172566321237299,    -0.073575515338951958,   -0.013432996128197733,
       0.0054616107737305341,   0.024849827619631445,    0.014102194476530048,    -0.064574470871988116,
       0.063402288012690294,    -0.067875144023880105,   -0.0052750560520030713,  -0.023884693595069111,
       0.072718866213717953,    0.076798946846926036,    0.12300502355773651,     0.12720485631515119,
       -0.088138657640844775,   -0.13116107805534,       -0.11806404064084584,    0.090008880600147279,
       -0.2152344487283446,     0.0052973913040513946,   -0.088546923944547745,   -0.094767629228056594,
       -0.0023076115895375882,  0.0077542640505490219,   -0.056264806168768458,   -0.088705792689277974,
       -0.015081099333112549,   -0.038742168804613925,   -0.088035087408365367,   -0.030063668950693904,
       -0.22963612502417205,    0.0012382765851980046,   0.19760412637211619,     0.053889774736920026,
       0.0086405438693409366,   -0.12247390627255123,    -0.014417014548167434,   0.13654430106184387,
       -0.10619619270673425,    0.027899133928176723,    -0.16514937549412373,    -0.037673928001013324,
       0.025850985870191127,    -0.056097357078985582,   -0.048139952588293608,   0.088604009110482648,
       -0.054882264891217142,   -0.025652172006935637,   0.069453543262177966,    -0.061296024385927052,
       -0.1947696589731078,     0.021354746561486865,    -0.20917613243298977,    -0.088365539633381868,
       -0.067679860160175784,   -0.18051815316811942,    0.0072123027113095463,   -0.014391522234365958,
       -0.044026220261378361,   0.075011488769339468,    -0.15752553837152741,    0.10847996376255253,
       0.025301964906992994,    -0.077550094887826354,   -0.026139425672609781,   0.011220162153531412,
       0.17473242354281504,     0.084622708365564764,    0.22024927644688558,     -0.052237463698165627,
       0.011454954556134199,    -0.013859647139024217,   -0.16963239612324577,    -0.0014172237746628638,
       -0.015254779893764741,   -0.065968375911030969,   0.028151990582895775,    -0.17694299907527034,
       -0.10862474194146719,    -0.066815163537778832,   0.06248396983872942,     -0.043339548781086937,
       -0.0061727294720102712,  0.14900295735100502,     -0.058497977072294594,   0.012027124222884584,
       0.10697101136325707,     -0.0011615789751040183,  -0.18585910864373392,    -0.046565917594745661,
       0.12046467010867482,     -0.13056202992107199,    -0.099126107055535151,   0.061858200971526535,
       0.089089983723407387,    0.15886277318862244,     0.10537912431178047,     0.060595722317463845,
       0.028604513849417982,    0.0824877673322435,      0.047120378185295707,    0.11105379929008055,
       0.062688256731615558,    0.057833717981171179,    0.012373289116642388,    0.064280272545806233,
       0.090495763302452015,    0.22438244665725632,     -0.11824543712864848,    0.033202368487487179,
       0.10472969871751232,     -0.078505939739536165,   -0.054860898113194015,   0.10389922356157344,
       0.077591461285013388,    -0.10426102600160973,    -0.085503031616362038,   -0.033053687112932544,
       -0.090515942452844139,   0.1316568096114836,      -0.14890189962922926,    -0.070378094914783154,
       0.025088036036605872,    -0.022722621721287126,   -0.048410539613969697,   -0.1132156900428356,
       0.067361218589724464,    -0.022622826860811816,   0.0068338213142721867,   0.22708888987656478,
       -0.0011095878726983645,  -0.071944082051731334,   -0.1431022538177345,     -0.068263568588893764,
       0.1180133774615995,      -0.033313549499172694,   0.19811772373290829,     -0.12841020599594721,
       -0.19386826420342082,    -0.06544930772440774,    -0.097905409178642114,   -0.022568295561994682,
       0.023647647864680391,    -0.044060915951895159,   0.059261270000816033,    -0.12099375805647911,
       -0.030055043766547912,   0.016214304915210972,    0.028674046451577489,    -0.01769608377481631,
       0.016199499875454201,    0.1203295414093932,      -0.032464914296576837,   -0.22410939342622216,
       -0.076751076685125916,   -0.012362060687542364,   0.031395186486747842,    -0.10499872001064138,
       -0.091920001742869142,   0.0089410024130918957,   -0.045030154173681891,   -0.15674694549661541,
       -0.094428966869467362,   0.097543217509011432,    -0.024534202321586377,   -0.071459215676439633,
       -0.16447482820500814,    0.095682397130794059,    0.098890944988157606,    -0.018683922723963242,
       -0.043456709421492691,   -0.13206374167812618,    -0.075512502082993288,   -0.11431906576558928,
       -0.015596722440846464,   0.30985933919895131,     0.010831223705896504,    0.21822341641533857,
       -0.041735240348785202,   -0.14339385310833244,    -0.16480911639443749,    -0.1817257324196711,
       0.036702079521339831,    0.061850283623707765,    -0.033966018669537135,   -0.063281927005227168,
       0.042469914763841154,    0.0073218853488702853,   0.14198490020482682,     -0.10716403209276047,
       0.040667386476068913,    0.031971264218470463,    -0.007292130919959507,   -0.16752843588863769,
       0.082056705604917873,    0.05324771769731082,     0.12362483596799866,     -0.068588793460899466,
       0.11893851796977957,     -0.10408541409782425,    -0.14640142175344206,    -0.037703341201471174,
       -0.15584447818557745,    -0.015123408353469998,   0.039405320347175289,    -0.027706291680863877,
       0.0079682457888512297,   -0.082865260464214843,   0.0040509008825048674,   -0.045538799779807175,
       0.14021307675270828,     0.24021421655272521,     0.011793335502961954,    -0.028042043842031059,
       0.20556691895080517,     -0.17083847734934116,    0.14710722614497265,     0.047972262516221713,
       -0.058922902942789027,   0.0038042172009840145,   0.027391552513433066,    -0.10295831770327012,
       0.067330647202406155,    -0.08278652599934086,    -0.07446124976534195,    -0.061972488778792093,
       0.049026002415212031,    0.0042352085106140639,   -0.017688792673719662,   -0.065525654337102932,
       -0.10361159026569641,    -0.0023556670247760255,  -0.11820806373204902,    -0.009125130776199154,
       -0.18317793004706975,    0.067946116194316314,    0.09403025533930412,     0.082882957700628368,
       0.13922035795400356,     0.019994422668581806,    -0.054439086818987487,   -0.051214704864070537,
       -0.01521594657413603,    -0.082862970126026808,   -0.073831883446438554,   0.073936952742505835,
       -0.15016582563906228,    0.1059541311407004,      -0.10387150142374992,    -0.036514585808444841,
       0.024910165794307101,    0.1152510237242704,      -0.005471473198043449,   0.030895843259118618,
       0.020249989725429678,    -0.045597434862628197,   0.063149243290912649,    0.089688484862783677,
       -0.0091133349069707926,  0.026935376364880206,    0.026940157682417351,    0.10649924049626361,
       -0.21681099982941721,    -0.14022725779036274,    -0.18769027547073852,    -0.041345726363992807,
       -0.12011221014510981,    0.031577361897445248,    -0.035707182763563813,   -0.036630432026006396,
       0.0050714132997664299,   0.042638715198017957,    -0.017495805514605778,   -0.095134927913233969,
       -0.056742447331541927,   -0.041099738145505993,   -0.014636351391572556,   -0.22515713016592209,
       0.1574184052526221,      0.031686235598685566,    -0.03348113615581684,    -0.11288409988756862,
       0.054492878582270227,    -0.16624526775901685,    -0.068854653390702708,   0.01647208935080139,
       -0.02879611652655956,    0.080562755073255027,    -0.0022244649059632851,  0.18881996044281954,
       -0.087670256942002769,   0.24922056374002033,     0.085826694379937951,    -0.1324992202516499,
       -0.10818326227881928,    -0.12901102022402633,    0.2188766765576701,      -0.10679208415063672,
       -0.061698620901310862,   0.086668351234550467,    -0.098430269862824424,   -0.015099875828457237,
       -0.041124857572903246,   -0.10659709117870318,    0.15405429032450021,     0.03342822690105432,
       0.10467778737772059,     0.082795582925836872,    0.010788345247821247,    -0.084156993282637857,
       -0.09837882044777925,    -0.064776969971078624,   -0.1037493655397955,     -0.13112325359834817,
       -0.042562978747284118,   -0.017667857505233489,   0.12210723690955866,     0.031680315944907035,
       0.043755458751592452,    0.0306787179741317,      -0.11217982292580293,    -0.05064769860349206,
       0.099326026625549235,    0.24515789387469422,     0.0057280580581706196,   -0.17628502401400498,
       0.038689671090986269,    -0.022597017644423917,   -0.089213299394140785,   -0.027499247608923749,
       -0.027619935486738766,   -0.063020926166369687,   0.001662808179411009,    0.19547600873935556,
       0.092449354528954586,    0.21408597651743061,     -0.023892701764665538,   0.080245724538429708,
       0.054325511963365339,    -0.030382164040246608,   -0.16486812785224644,    0.079364647303662578,
       -0.05555192919844984,    -0.015717370570187496,   -0.034099197358075886,   0.11400732493088023,
       -0.044357889056963418,   -0.024418244371089196,   -0.090363533903457194,   -0.016722872896804374,
       -0.061833740046322319,   0.11327453082213426,     0.17725319582864157,     -0.1811049168048427,
       0.12307497203030847,     0.2577996870484035,      0.11186889767876593,     0.14398039316187608,
       -0.010384288969800919,   0.05108162754905661,     -0.093174869338913321,   0.11093800382411267,
       -0.039013922846957351,   0.080903924341788322,    0.019485918181859876,    -0.004509514374829964,
       0.030421917572219292,    0.12546062577382114,     -0.050649865947777463,   -0.049170977908341768,
       -0.090214554487459311,   -0.13750375982044227,    -0.062768632652651868,   -0.092162798747375846,
       0.018543431491689116,    -0.0027144144592153138,  0.17475273259047786,     0.060975372541515423,
       0.14427412217131255,     0.052469039778587856,    -0.27129446451093048,    0.12100107556051226,
       0.070174775380310389,    0.01638212955512381,     0.11844017729425249,     -0.047415862782872797,
       0.079562744885552442,    -0.074364681531804006,   -0.13517494904907815,    0.041445190903852777,
       -0.1352964765867733,     -0.036859329465889622,   0.08798107619053111,     0.21273404975264457,
       0.044411663714456449,    0.053426975264480606,    -0.057534172409911946,   0.040696087912114653,
       0.013864827785131723,    -0.15558776280259151,    0.0063709448497124462,   -0.050645390989333981,
       0.071606005883191284,    0.0477371681487277,      0.0048648001541937028,   -0.063823128114885053,
       0.090236550514843361,    0.084257836609169967,    -0.12009816327035518,    -0.027160061466737863,
       0.12693361157976202,     0.060626541904084806,    0.047721086921087806,    0.077214383531405098,
       -0.1062579326523613,     -0.10281864822860047,    -0.19219240190630532,    -0.018103290334008312,
       -0.10896691909301294,    0.14159567727270075,     0.15627624972032775,     0.084337799129978311,
       -0.12526904236450548,    0.019299106530697063,    -0.10019606627539486,    -0.055340051292263812,
       0.020971119903175038,    0.016466099730465041,    -0.034750699691055112,   -0.019826443689725998,
       -0.16140401440590144,    0.024719836605221531,    -0.17826716969738401,    0.059530287730527917,
       0.04496520383536369,     0.10874707001425081,     -0.17880322205497506,    -0.033224486625401242,
       -0.092345542354660637,   0.00038761985034332751,  -0.051328247962265351,   -0.0060696203693994151,
       0.11988711255148633,     -0.038366256942715747,   -0.032821214756636026,   -0.049886664066597287,
       0.077577432496444942,    0.10237152126502025,     -0.050854766926338543,   -0.12508023601875876,
       0.0093865475346260868,   0.034325106095949964,    0.092970671174296318,    0.15974441696509367,
       0.18339425817495278,     0.08832628750765234,     0.0088424423131567148,   -0.017213922381373613,
       -0.077281193227820871,   -0.078540074250528724,   0.065745418689793639,    -0.12859508237316816,
       -0.070989204655911145,   0.075186158130462796,    0.090758721783932864,    0.14660262506624627,
       -0.055959904327450502,   -0.0070107350473633916,  -0.095100534307316992,   0.00852617858208524,
       0.099806822620681565,    0.0083855902571518363,   0.033993799693530918,    0.19523572573904652,
       0.054041324227344797,    0.032135656729522372,    -0.030687995931406829,   0.047254367718923128,
       0.060838271183838867,    -0.18481375867040717,    0.08699550824798806,     0.042804114725644014,
       -0.033919036363352736,   -0.052474936295731189,   -0.065093487790605517,   -0.023155551005816323,
       0.041668264277647492,    0.036282948213489145,    0.14111811929303442,     0.067694188487637044,
       0.070193923408356437,    0.031254958107043353,    0.070620258315214651,    0.15348958068279098,
       -0.21567495394621772,    0.17221993772584082,     0.10744312379265469,     0.13064060506289954,
       -0.011737916692297217,   -0.11967692436436363,    0.26839840401592907,     -0.047608765761930134,
       -0.068057942280020794,   0.0067641114720752241,   -0.025101045237202423,   0.050321375038531492,
       0.17741513275214527,     0.078303336384495159,    -0.10489815836365297,    -0.23734932089124594,
       -0.12460167946628607,    -0.056314316601867427,   0.056894528801649906,    0.11382440406333019,
       0.057809664789469473,    -0.019559348164258573,   0.052157624887798411,    -0.024987558910145563,
       0.054042872423886092,    0.030133445821161821,    -0.22200195898879321,    -0.16998339962952067,
       -0.091062279886769085,   0.054211648288819053,    0.13885442180765065,     -0.043814434088341986,
       -0.014379444081216825,   0.083116374434763635,    -0.018918632296361086,   -0.095016857399502413,
       -0.17170690706370106,    -0.060708784898896757,   0.069877979238334553,    0.082023018398317535,
       -0.1118363850612786,     -0.10989308937403798,    0.10399970980643934,     0.22196985133009944,
       -0.091240896452781647,   0.015472424310043866,    -0.016766359349813739,   -0.08534386728603735,
       -0.042653762246654826,   -0.13237273124060506,    0.051811647337491384,    0.13242449606849802,
       0.095383528948769614,    0.2048195292530603,      0.024955597421617761,    0.096862597388830796,
       0.10803868896906882,     0.099921329392867742,    0.095129531115619267,    0.016890202694394851,
       0.058369853048422855,    -0.012652211463385236,   -0.16662720491417007,    -0.04328841917666798,
       -0.17302920392022636,    -0.092252033407976428,   -0.086867322603538188,   -0.037772433170460994,
       0.12060072035520129,     0.013508748355174089,    -0.08457888391751002,    0.025370065585941199,
       -0.11553795304839828,    -0.0036481693745210216,  0.087308616736286107,    -0.0050379917060784053,
       0.029417835208594503,    0.050744162298372072,    0.094597403883201675,    0.11602966995517937,
       -0.020045308449537228,   -0.098506076552988583,   -0.18103748146922705,    0.033559279718153819,
       -0.045786323116144147,   -0.084886873873875862,   -0.089565621094464462,   0.078545803439124318,
       -0.043005476565674071,   0.014859775199572996,    -0.11756351594607906,    0.06709184014932891,
       -0.036353686737875965,   -0.20455448969512471,    0.048631283453541604,    -0.020981263201069942,
       -0.098320804658053623,   0.099262719368384433,    -0.06261851516269698,    0.0096780796384340149,
       -0.012503488433503733,   -0.022967408655983103,   0.040407395663047761,    0.04378019993874923,
       -0.2082173568897428,     -0.028785593981991642,   0.11087936841523836,     -0.21202226263760343,
       -0.0709345939356779,     0.17620268387737875,     0.050000835009098542,    -0.27125486515058306,
       -0.12037243315583449,    -0.05556252552467561,    0.082257595993906446,    0.018339770643912665,
       -0.086821422313209301,   0.11651002461681821,     0.082206333822894273,    -0.038438899490803591,
       0.13492858646360334,     0.012029672797003824,    -0.030507548305097075,   0.079324390136770548,
       -0.058714169416395505,   -0.1131570337359476,     -0.12357950828524766,    0.050971750648516632,
       0.013803357840343354,    0.16556372689847515,     -0.039472968890173508,   0.12818458089686385,
       -0.019943879732416122,   0.00025926972905070469,  -0.050216349100919294,   -0.070218046939855921,
       -0.026965095305772832,   0.1718302865568504,      -0.080121069275817858,   0.061077104976141688,
       -0.031048503417578147,   -0.020816008626560641,   -0.17131380306879618,    0.14889035908212706,
       -0.10424774230760687,    0.019443273143708879,    0.075716303113081029,    -0.012702755162623612,
       0.090361415527521374,    -0.084572103646929186,   -0.089334353081648055,   -0.10397915458110046,
       0.12684394313352865,     -0.29464923680490857,    -0.18929536196840366,    0.095501987855474535,
       -0.057270169476129264,   -0.035058452826601062,   -0.083630861298369899,   -0.084058348772125549,
       -0.08910968865557331,    0.06450289787774123,     -0.06365030693186903,    0.1413097937027458,
       0.14564305780081005,     -0.038316459334394704,   -0.0069830354425563347,  -0.14829187924149961,
       0.15573290811711418,     0.16373483019767018,     0.046400614317646673,    0.0091980724784781458,
       -0.32417689675600958,    0.10532548368928903,     0.14299500936066678,     -0.11789865304677392,
       0.0032292361836435413,   0.0066905054618942306,   -0.071919740352014774,   -0.052776933413096694,
       -0.017804654931086867,   0.022976691130589463,    -0.056967161260014505,   0.075549616583714937,
       -0.035276301190746304,   0.099480960620718331,    0.036805189272303057,    -0.022544254322492314,
       -0.064576960542647249,   -0.047691036254517767,   -0.11578802092628469,    0.085905437035010121,
       0.062886400622318567,    0.12971441692425525,     -0.15062988666896537,    -0.10086732530938534,
       -0.035182093342213144,   0.13015446223614524,     0.065400561378583896,    0.11392940550646326,
       -0.081534459012044466,   -0.043246385186065175,   0.13455723637730188,     0.048818576845495454,
       0.032256591280735214,    -0.061273404349089879,   0.014495596586115054,    0.020039657322215132,
       -0.039593365264066281,   -0.12999752736900189,    -0.0548759383932277,     0.0085205159406962147,
       0.078654766163647041,    -0.0057060350306722182,  0.20671600211335822,     0.09903041456214795,
       -0.032155922082922388,   0.12100094740881391,     0.066480678106679916,    -0.036298191596323769,
       0.15202839599475038,     0.17270823023754237,     -0.029025971990840987,   -0.026349715391131345,
       -0.087345757645451091,   0.051411531950833263,    -0.034370514716879103,   -0.017767184731005772,
       -0.068363040386313606,   -0.0045538368793635597,  0.037584279238635117,    -0.096907055562950886,
       -0.26551303149011984,    0.039468129320332737,    0.13693696052992482,     -0.0047889601713512423,
       0.064035961540229003,    0.029869385708314412,    -0.0074575793186931697,  0.028179895516071911,
       0.17006675098426102,     -0.054054689833891265,   0.19473898757730912,     -0.14504339958039697,
       0.033557262439490025,    -0.10618645655841495,    -0.12752071574510923,    -0.029656511650320766,
       -0.033541289167669353,   0.1148706629854396,      0.072932978089710665,    0.0023131691697178629,
       -0.16241628485612716,    -0.076648291585298747,   0.08600477915218703,     0.099044613074178611,
       -0.10884937895950425,    0.0303101592607899,      -0.027690969786607081,   0.17450090440466978,
       0.085152672733588772,    -0.05432254871803411,    -0.094061653235340451,   -0.072875724242011414,
       0.16270546965266883,     0.0090337243337628298,   -0.082700734910954296,   -0.13256662483432907,
       0.025706717738859304,    0.095525735571966072,    -0.22054581337739079,    0.0040679713024408155,
       -0.1798513386472376,     -0.050242011968763364,   -0.058348645488951648,   -0.026385149656683073,
       0.033182449286721948,    0.0082966556536082196,   -0.015097092047249122,   0.04372466235895283,
       0.010500478330901921,    -0.051610795307551409,   -0.022954024004739351,   -0.12377415547075214,
       -0.098760555560922045,   -0.074738639934137416,   -0.10013904526624597,    0.12634208391277024,
       -0.069819684043256475,   0.17736311471518001,     0.12708607447532788,     0.064744006418680389,
       0.10070755333990648,     0.054420963592378642,    -0.054390409117562773,   -0.064353661053760072,
       -0.13008959321211042,    0.15314095762043292,     0.25726797060110124,     0.048434344274552989,
       0.093212421945557594,    0.064389383651135876,    -0.070151134070290819,   0.05611053655559891,
       -0.04088161437043647,    0.15673461936772914,     0.10476476781461684,     -0.092976969008335811,
       0.05479236109834542,     -0.056935562754958091,   0.024983141961713463,    0.10196496895486742,
       0.11711024391676268,     -0.093267915936070145,   -0.19236603858848203,    -0.038705991606207191,
       -0.20760003356877016,    0.021017512007480851,    -0.1400128612980861,     0.054875086409403757,
       -0.17963039196808769,    -0.045304905475182684,   -0.1961964638248197,     0.059471839906931466,
       -0.079081773888372286,   0.037465972226264077,    0.052615178724018309,    0.071713714277992252,
       0.14697452089185617,     -0.064187113203527657,   -0.017984370092691077,   -0.18515248967881121,
       -0.067592450554594966,   -0.0081999527351964904,  -0.1801431191639829,     -0.14282513634093316,
       0.02314889798375307,     0.070046438485342019,    0.00095051592517579652,  -0.027576173694055083,
       0.10954843993747777,     0.022744745917048687,    -0.012163739951858616,   0.12244382620469711,
       -0.1411689923746417,     0.11433740412723899,     0.06657602166920569,     0.23129322512409753,
       0.044300796340110506,    0.086906296454728207,    -0.024896851317113011,   -0.097823380617085717,
       -0.1427405992083749,     0.13139167467033658,     0.062151230602099178,    0.053427375248673234,
       -0.021880401174093025,   -0.16800556712385606,    0.059197201775384622,    0.093991951148789374,
       0.12279604495948518,     0.14433044503481324,     0.15946554608532509,     -0.092427027576982096,
       0.067913803762478034,    0.05420172625183272,     -0.12288086470770931,    -0.026167494236171696,
       0.056620763539057449,    4.7786789306713054e-05,  -0.034619383849218165,   -0.029725800918176101,
       -0.17485622875068096,    -0.00033291381795222917, 0.01621168689289379,     0.12825022964393507,
       -0.14243842147775043,    0.083903284796013597,    -0.09445642482390805,    0.006044010368552611,
       -0.099681907977706347,   -0.029192215372050113,   0.093141784200569552,    -0.069621791031846306,
       -0.061245887222541859,   -0.095284600372537928,   0.081563919704410584,    -0.22375543199177844,
       0.12918111621089695,     -0.0049267144939699574,  -0.080427083022838602,   0.045993508346734061,
       -0.059507295131698244,   0.046873577146608308,    -0.12944562187506839,    0.1351020876183604,
       -0.018861721375585755,   0.073342826035292852,    0.010579554751632799,    -0.056220649775287949,
       0.055914924137164604,    -0.17166661914225526,    -0.10136586566265424,    0.087798691576026891,
       0.03323499235305992,     0.053708398282317799,    0.014299688528043579,    0.011484522355846592,
       -0.13674452759344266,    0.12053183855939212,     0.16049481295203455,     -0.086300570467965049,
       -0.058468980264361245,   -0.12217220819266983,    0.054478480281967313,    0.024034920889754958,
       0.036616308936927501,    0.03067212572723009,     0.049012261291582752,    0.038256818489564116,
       0.062200937605739193,    -0.046069859953247451,   0.10061946656449014,     -0.0669325890571245,
       0.039850759860133395,    0.044289402318567372,    0.0054032976760772181,   0.10219037656904351,
       0.00651779872403187,     0.18235626327070539,     0.046006939622015124,    0.11449330084274871,
       -0.19523143947902988,    -0.031038985431134758,   0.18496414538288752,     -0.044984328231231593,
       0.0095121200354507003,   -0.13166864984699603,    -0.046976054051113013,   -0.052205632785561264,
       -0.10235645904920161,    -0.0026367248373828627,  -0.0043649873441636549,  0.027154661433570929,
       -0.15085027656386277,    -0.033452997488268264,   0.040637966253082795,    0.049731921141927232,
       -0.15351047851254598,    0.15877187840987886,     0.097171764708610026,    0.09695640917846754,
       0.046361410942822374,    0.055911817345430985,    -0.00068188227085443326, -0.14548719261980386,
       0.074825741253944589,    -0.19968356977070784,    0.02626301196417535,     -0.12919214963192321,
       -0.070784934383318246,   -0.075816744714044218,   0.12407635790495412,     -0.13086490803175979,
       0.058944508740117363,    0.19290429593736486,     -0.0050328861257705462,  -0.17522367741578498,
       0.03074591363461605,     0.064714435922903463,    -0.15907734291663275,    -0.1049458039010974,
       0.21815993709180018,     -0.0027326323733002675,  -0.070196046924419914,   -0.15984327891782701,
       -0.13421880194642463,    0.34574936650788934,     -0.074979008920295562,   -0.038447601441757427,
       -0.020628115104817636,   -0.0004417760597049754,  -0.0083427892472185492,  0.11018063768531133,
       0.10943824669712915,     -0.1315018465487624,     0.020667835570076429,    0.020342841013686282,
       0.15301987480364429,     0.041466311506904024,    -0.14980784506312844,    -0.082786122711776308,
       -0.14532150476155781,    -0.0026996427381625813,  -0.16866534075706496,    0.02581222877134684,
       -0.0059812267749171279,  -0.067981387929289705,   0.099706196524075849,    0.073473804966486159,
       0.0012586697265244624,   0.038633092136484144,    0.10884358301378627,     0.052541916365340557,
       -0.043743966570270396,   -0.088968025404267154,   0.01725840154243577,     -0.090938796684313178,
       -0.039540248244607563,   -0.078492816143993754,   0.025328193225665763,    -0.011896949844673863,
       0.10857972588212048,     0.054249721731032485,    0.090821926147095569,    -0.067863938866616458,
       0.059492284680321098,    0.11143422331338451,     0.064687735059420465,    -0.095212045226226713,
       -0.0013162762684920974,  0.08095507997759209,     -0.082863671671439418,   -0.020357448901283853,
       -0.065146838841182511,   0.067881990712200801,    -0.2041590002846066,     -0.019259701285276574,
       -0.12981958467634411,    -0.060339439598256467,   0.024518132421387343,    -0.033567030199016877,
       -0.089746054373742362,   0.0068871656699203863,   0.017000972200048797,    0.17052272760936527,
       0.040099129695207444,    -0.18588955583083883,    0.12788632946015616,     -0.14100536576921535,
       0.18716908575612279,     0.02924659599989515,     0.0051238442100714895,   -0.036690960935722404,
       0.022568063176827021,    0.034358161319809774,    0.032694709176766437,    0.022420236991905908,
       -0.020393203566578338,   -0.17225590145725875,    -0.082791102827254326,   -0.012674089874567458,
       0.14052587834350452,     -0.0065015689611964966,  -0.096036352666339961,   0.027396174732204986,
       0.17321805200169269,     -0.220358250879226,      -0.16154855720935468,    -0.052880625409025064,
       0.18160871508296544,     -0.065830758228426059,   -0.11297336131596938,    0.14193108478657276,
       0.21585440167054606,     0.011314409429485381,    -0.13437055754592109,    0.15866876874222569,
       0.08623600630507007,     -0.0040173140574941667,  0.096160514084732515,    0.060942301438114785,
       0.016876570575337729,    -0.032538996933365046,   -0.14323471918139996,    -0.033736727984522361,
       -0.029778265711306241,   -0.02871719636204275,    0.1227650318328613,      0.033450286640634604,
       0.020327587354148996,    0.13655535220512638,     0.1497008938026651,      -0.037676246010617025,
       0.12024767465237707,     -0.12256867642210342,    0.047570961939474875,    0.036138505218854575,
       0.095667197551113331,    -0.020562099201428544,   -0.25931899236516665,    -0.011394591810046135,
       -0.015243575674150358,   0.096656026821142119,    0.070603900828262858,    0.059433232425707465,
       -0.13864360727408898,    0.10568670342260272,     -0.11067951085269881,    0.0092417932358490364,
       0.070195737049939658,    -0.066682049639353341,   0.039040374906533018,    0.027299636853658063,
       -0.07595920235837976,    -0.045876714609465817,   -0.11211070505174003,    0.1218068203060949,
       0.17070332150168843,     0.11946987023332646,     0.01733872275282114,     -0.12612078973851551,
       0.10255844307781865,     -0.010336302186803098,   -0.051865562786156651,   -0.063707979467782574,
       -0.021902186375939627,   -0.075260490500070304,   0.089807223053537527,    0.095577300538353588,
       0.0067586982848715851,   -0.097536842125515721,   -0.072229487518142191,   0.18530480643741737,
       -0.027171219361268612,   -0.0078964772286926783,  0.044838907398971325,    0.1189069548161584,
       -0.0040204857714741145,  -0.0073884087143702704,  -0.099155435468760725,   -0.091076722488680262,
       -0.048623094127541858,   0.016837463792859008,    0.17516004238192961,     -0.068728486347488751,
       0.16804380633653279,     -0.11659912934275042,    0.045112027626173473,    0.041165365307963525,
       -0.077211594479472748,   -0.11093584827820976,    0.0052250011962833819,   -0.014006131238348096,
       -0.0056779052290015196,  -0.054281392822841029,   -0.1248043315373687,     -0.011508887891125363,
       0.10268579411727403,     0.024247659947030292,    0.024750118540492742,    0.1284898576191216,
       0.11841741722872123,     -0.020674800784790129,   0.082916494914368186,    -0.18264164886988654,
       -0.074736103306522111,   -0.049836158802278825,   0.066407517568061236,    0.062242173111786599,
       -0.0033420907107076236,  -0.058994469435661293,   0.015966527350347669,    0.010778852070241186,
       -0.027865858115022218,   -0.0035093245532974437,  0.031859476563423188,    0.1310711286236573,
       0.27709670670839137,     -0.041178502965708665,   0.13081491057592637,     -0.13436953019892517,
       -0.011891724290959586,   -0.045138348142697737,   0.044801970371996687,    -0.041437020167171282,
       0.031641223081082408,    -0.16624826457161934,    0.10462097950166646,     -0.025428742082160276,
       -0.14170376613172031,    -0.041810284320832086,   0.051948667934667347,    -0.090245072934500917,
       0.051022628261452201,    0.14567890422762503,     -0.12215583702289046,    0.018043781102007404,
       -0.091245382943874909,   0.087375686541513953,    -0.030607854610670625,   -0.12529657836038127,
       -0.060028471217871832,   0.13993358805590872,     0.0006426338811801359,   0.099038365515134757,
       -0.18997268557209096,    0.04614416086661343,     -0.17778991016751169,    -0.11223711077858237,
       -0.075378089781147892,   -0.061804410404681515,   0.01967321537814385,     0.075171455768030554,
       -0.015217313755131544,   -0.22064392925835222,    -0.0056219682822397157,  -0.15653380553806051,
       -0.27472100949713268,    -0.039883089680033436,   0.014467534020387713,    0.16144255879607089,
       0.17530851366951447,     -0.17094387471737202,    -0.081570602028950168,   0.10482438596371013,
       0.036745427025743051,    0.22390611025615773,     0.12683983952763908,     -0.14381420741375084,
       0.00039586762099298733,  -0.090452297044722185,   -0.15476595878676561,    0.1169718898757582,
       0.060118903169353366,    -0.13276220929117891,    0.036190858777100959,    0.074934705444056032,
       -0.027903456584814267,   0.12257413481015496,     0.037615526778165126,    0.10123068836890538,
       0.051500848610295129,    -0.15888292643845231,    -0.088803782615215474,   0.12137990731380999,
       -0.037124577776968828,   -0.072082492674284696,   -0.12417821919045524,    0.073551320373231477,
       0.10994345837562913,     -0.19613701556283719,    -0.11922625957001186,    0.044238138005141737,
       -0.15241383017717397,    -0.12752861996836207,    -0.07025526116989271,    0.090321358261872084,
       -0.10699518676298161,    0.10338775056980341,     -0.15182112080509971,    0.12828410389987935,
       -0.052654021240398204,   -0.011840144187352922,   0.096429208479013151,    0.085460660422359128,
       -0.10989221354359484,    0.058091219558611011,    0.014801313576101423,    0.018999765015605515,
       -0.17734612743175404,    0.044537355416611177,    -0.091938090548891169,   -0.093489222143638695,
       0.0051581365948688814,   -0.2235937078036361,     -0.19251178399863622,    0.013206210148967739,
       -0.051372565399347189,   0.042957413388657356,    -0.040093372912840972,   -0.01987492579621079,
       -0.0022812499086512488,  -0.061250790298906239,   -0.067446450096916813,   0.085995140420619648,
       -0.17491174787659355,    -0.013636462490128475,   0.14990104386693609,     0.12257876546749856,
       0.01043552849844318,     -0.025464717628294602,   0.11975612024932464,     0.030835210865787686,
       0.15532047125862741,     -0.039993304850892003,   0.054785054007682576,    0.035488317219365385,
       0.013210482015638342,    -0.021930864398365429,   0.10939794758097393,     -0.19727638247592913,
       -0.028141157010441266,   -0.21421430363514171,    0.063467582751341456,    -0.012937730691483665,
       -0.13293474775533515,    0.0046180891139180821,   -0.07360756267438423,    0.010687032242466556,
       -0.11296593312271327,    0.048907281086821977,    0.031364901945084796,    -0.013853852548876265,
       -0.048086743901551703,   0.14204276332168908,     -0.17395217416550374,    0.02980025612912874,
       -0.017157495006910811,   0.0026989120311091104,   0.095885362121153186,    0.11463128795256061,
       -0.075628668654077025,   -0.069511638270141257,   0.10938652722647463,     -0.02702662114453213,
       0.097177027103225594,    -0.064583837495926499,   0.20984436198194986,     -0.051775839851417399,
       0.15908418133840799,     0.098217134575604728,    0.018796954980319698,    0.092880580174877825,
       0.052379870496767234,    0.094520817402364246,    0.039165804761768411,    0.029998429538624461,
       0.13425134661650548,     0.13297236606979415,     0.02681347364138113,     -0.05144004280501456,
       -0.011808410385219202,   0.036878290035697786,    -0.089731005812503789,   -0.080275321839462704,
       0.012057820371971607,    0.15934149152774782,     -0.031814118471430827,   -0.24343264949879972,
       -0.063234893174168638,   -0.19285842203489317,    0.056342863866544565,    -0.10612050694725343,
       -0.23319403711788445,    0.052835847199309664,    0.062130698372899335,    -0.095010540199941165,
       -0.11970436815765169,    -0.032166387032209101,   0.04179357521846884,     0.00080872147710651845,
       0.036570585386580284,    -0.19015667248841919,    -0.00085191400900718611, 0.00075084719099913211,
       -0.14083590820201319,    0.011263951128724654,    0.11981928087167854,     0.079577464157619959,
       -0.025390187985452818,   0.029485116467528216,    -0.047313024355450879,   0.018967547257627566,
       -0.071879980527273249,   -0.037606061084736242,   -0.029252197573889895,   0.11134102813363106,
       -0.096360364435192511,   0.047953217574271387,    0.08320719832782944,     0.17324974487463662,
       0.093323272850278124,    0.056557556072759266,    0.029557812950370192,    0.064895234043787664,
       0.014874932530930553,    0.070384036676716027,    0.021644442342024582,    -0.084506135902048807,
       0.02845654565336957,     0.07102869297156586,     0.020070431679229749,    -0.24605686084244791,
       0.098132814312193284,    0.0078124257320330327,   -0.030226599827443641,   -0.099427895187569698,
       0.1188152942394478,      0.034611138803455212,    -0.037887367590240938,   0.020483115961675048,
       0.11332901123259441,     -0.022160799841454148,   0.03550370002756699,     -0.052186713178594232,
       0.098816354848135474,    0.029023236365927494,    -0.063503707642954085,   0.028321922839733522,
       0.051806112785311408,    -0.10160544305011285,    -0.29374260009006808,    -0.032415875956751383,
       -0.083780731683018583,   -0.25439965288900557,    0.076629725186972933,    -0.037957341635546191,
       0.029725983656477644,    -0.090289601730462049,   0.19206980062303233,     -0.10253369508936391,
       0.0099945606885010665,   -0.0069863268888848383,  0.0055764418124107209,   -0.21052328921595442,
       0.076958090266003185,    0.091185426454803681,    -0.031540869406294803,   -0.041362318395466488,
       -0.091507620080828092,   0.011622829613118935,    0.17039820527156554,     -0.086804052870620207,
       0.10557953088359306,     0.012626659475235695,    -0.14576974699988338,    0.15436828636383035,
       -0.0052901680575579996,  -0.2473480675467386,     -0.23366697888550975,    0.06061826352428383,
       -0.062562162037471683,   0.019243675970170477,    -0.209841256601601,      -0.0045042801339371464,
       -0.10410528957545055,    -0.22965683913419055,    -0.077373825197377219,   0.015177130222863947,
       -0.23596132215068505,    -0.12436560060591845,    0.063027846788926992,    -0.079659430147055565,
       -0.0096397446828725072,  0.02635558885822303,     -0.013980116145331739,   0.075314202014900911,
       -0.011430281261923697,   -0.061575584458212311,   -0.012824459216732656,   -0.028857885207302064,
       -0.051603600361078972,   -0.070853821293976188,   0.081264989031301346,    0.032174619241649924,
       -0.23534771051984016,    0.083819336218505708,    -0.10640103440669532,    0.03231565905175602,
       0.12189442432233709,     -0.11621587590480144,    -0.021132382655411848,   -0.05482295039836399,
       0.12023172522307911,     -0.07735175843350911,    -0.0076423835517223891,  0.044305838764115875,
       -0.033532316100866315,   0.17177796809356749,     0.041817317541741464,    -0.074894381208412464,
       0.037358278456081487,    0.0047850119281727561,   -0.00084369298812814273, 0.066788071091993167,
       0.051785516528229027,    0.086435066398452387,    -0.16051636601239053,    -0.023403153179054531,
       0.034470854060454886,    -0.082496089533097672,   0.046970718080052154,    0.1940058773983741,
       0.061266223870290397,    0.04648568832002116,     -0.11295112929309124,    -0.092056888464550818,
       0.038886953909887334,    0.0086197953762626005,   -0.038212876713342524,   0.096292823461664845,
       -0.093585399559522831,   -0.10920227083714315,    -0.047666588707577465,   0.064090791606792236,
       0.015912471269334628,    0.089581394966816275,    -0.049201050856657567,   0.17824838996516545,
       -0.053333443255397101,   -0.057859188020921187,   0.006934755120067187,    -0.06641899629479639,
       -0.027328829649813514,   -0.13941555523419141,    0.15979520868137151,     0.06872507514558196,
       0.043384700644218586,    0.056614693695749063,    -0.13247248057886593,    0.07338167967295435,
       -0.069856394758892437,   -0.25885567601928289,    -0.088070439540818349,   0.025024433250617237,
       0.11500981624341323,     0.021824861117947011,    0.087530015326152968,    0.10078432044981975,
       -0.17697610155136234,    -0.09646816677270964,    0.037363707006230124,    -0.097900320074353647,
       0.10494233341083184,     -0.056385196095898038,   -0.14607003268540608,    0.14874890877447164,
       -0.011412795501537482,   0.27347947985303689,     0.11250662826187621,     -0.032946066067618823,
       -0.080312202230454377,   -0.039085238612999076,   -0.15158286347280112,    -0.0069583891809209151,
       -0.13786870672961407,    0.10097165720310602,     -0.14557876020779376,    -0.0057369611749992309,
       0.090831722370484286,    0.021951372177960424,    -0.054767813513570095,   -0.17877460936155687,
       0.17456788086978664,     0.11282292443665309,     -0.042648709217711016,   -0.059724073167738263,
       0.04925280157772232,     -0.084877216581735485,   -0.06142352020790888,    -0.046949746763533917,
       -0.0055933022020777674,  0.018630919455912186,    0.022609773024100419,    -0.11561825898613255,
       0.03499826989258116,     0.0060132334402449791,   0.11541293766349611,     -0.098955248806064391,
       0.085356641520041604,    -0.10380100036877926,    -0.093675174721028071,   0.12671274601236349,
       -0.076529050182944591,   0.019866280084961861,    0.0038804993772938072,   -0.11994097810517212,
       0.019358725012185069,    0.059469086366420051,    0.039610185902921063,    0.073701897424623589,
       0.05824713497861167,     0.094687031840908861,    -0.0078430374081778984,  -0.033441657749274933,
       -0.038445508940729421,   -0.031090837887353836,   -0.055979029341680933,   0.090837933608538313,
       -0.089303538091536114,   -0.068736889210329791,   -0.061514843819215265,   0.025042310804198123,
       0.036107558713592343,    -0.06269215055092392,    0.096458932384360374,    -0.01987837581063737,
       -0.12784221563305795,    -0.0431664541176957,     -0.13639941549870027,    -0.025402910659756514,
       -0.16370667057957214,    0.10960342299526472,     -0.14909051952892174,    -0.042761555990052533,
       -0.048156917853289523,   0.059744536052263625,    -0.051162915162332727,   -0.094445971745128685,
       0.14062012275333868,     -0.044186678898243022,   -0.19764742844833416,    -0.23511975988315642,
       -0.041265458130189621,   0.16873939109170583,     -0.080254938132092599,   -0.13980363702761806,
       -0.047052739291929602,   -0.092009249484926656,   0.10354265313380609,     0.15276585602938753,
       -0.12163120593951493,    -0.07756802364433997,    -0.21609523169568523,    0.080610490029200968,
       0.014783659070458217,    -0.068993627136733113,   0.02027491921622835,     0.091870589054330348,
       -0.083147597881131491,   0.18418888100865841,     0.068381347374084064,    -0.13497404328658727,
       0.048239231622100934,    0.10836542239383586,     -0.0088859917595769944,  -0.017975015546947349,
       -0.29994377385140131,    0.11118345774210017,     -0.03608682512430543,    -0.010287854637207289,
       -0.060135512080306187,   -0.1702106474554006,     0.038638006446317867,    0.1019665195510976,
       -0.14249317035939041,    -0.074478035781328777,   -0.055554047325391633,   0.022913387520000862,
       -0.10244481098172385,    -0.00073112034550186153, 0.1530472013122964,      0.014624927494206378,
       0.063633241450738218,    -0.026279302415335964,   -0.0076790722602028206,  -0.017988054232724999,
       -0.012653193155792756,   0.058654367091284236,    -0.10243005920626891,    -0.041554626143751938,
       -0.0028418987494846391,  0.14037008947018847,     -0.15845622491095285,    0.058226481055360643,
       -0.13261522490527963,    -0.016190977657353642,   0.0037421042908296707,   -0.15665468343060687,
       -0.0040129908002654834,  -0.098603061966990077,   0.056939437378181738,    -0.013544136331171387,
       -0.02120959653396982,    -0.0027307680145856484,  0.056410456455591347,    -0.036187183464527643,
       0.12862697917693808,     0.10319925096897503,     -0.047105895914908588,   0.0038920899091066784,
       -0.25924652728786052,    -0.11588386392469185,    0.14267494460550034,     0.087694175610390487,
       0.021295383897033802,    -0.047831731412627213,   0.14112237993375285,     -0.10623455517935017,
       -0.030019463204502845,   -0.14907990474842375,    0.14715814841086383,     -0.15395894859750098,
       -0.063354578232687947,   0.074394503083113087,    0.072685888136056781,    -0.071988584861552574,
       0.02539408367275494,     -0.099412215151164551,   -0.022207975056376263,   -0.12482536942966552,
       -0.12175538587480124,    -0.14396765924512414,    -0.028001000822748069,   0.069252757483583893,
       0.0079189281101845078,   -0.051748969176578542,   -0.0092850705428399096,  -0.057961912665672612,
       -0.053704451107721762,   -0.04143389513069326,    -0.27978886997237645,    0.10181401913423063,
       0.20693509879747865,     -0.04289011547908942,    -0.0065259817706340689,  0.12985369357022303,
       -0.0039870946371129692,  -0.05810360084806597,    -0.023065453922465205,   0.034835152484955202,
       0.11957195965205164,     0.16288157612950771,     0.086639001033180355,    -0.15402999262479328,
       0.17993631535560339,     0.018937550203488272,    -0.095078887693718667,   -0.0067802956275983825,
       -0.012007398524556713,   0.038120807452481371,    -0.1535637548421741,     -0.089263879130248622,
       -0.086577061907092093,   -0.092783573855677981,   -0.23136778900374222,    -0.093633347475248346,
       -0.19958204631029475,    -0.077671492526816141,   -0.0091802487238623071,  0.054270553180442813,
       0.0567617745871936,      -0.1076575372354954,     0.0066745626077090005,   -0.10239540184118151,
       0.090570220689924916,    -0.0036938652297421248,  0.0021204465442472538,   -0.14044579289016401,
       -0.1337213423447447,     -0.18441986476078917,    -0.13432301059550306,    -0.029629261117725923,
       -0.0006449378586932356,  0.076066335162574578,    0.0037340717032776508,   -0.031209346773105412,
       0.052121583609011861,    0.061909065564243679,    0.11958194829906484,     -0.045970967978192216,
       -0.09858876037012676,    -0.020782022912898511,   0.2289241032530617,      0.050436167069307834,
       0.035907181825242315,    0.11676280933594212,     -0.0069436433181051214,  -0.012547490048055426,
       -0.091996429476585248,   0.14494218972493286,     0.10214597213353641,     0.15003153473257816,
       -0.10243196700037728,    0.085972102643097015,    0.044092770352568991,    -0.049234568387901682,
       -0.12647523886767167,    0.1323090609347724,      0.078229166109172882,    -0.034053869349924673,
       0.00070682412938140706,  -0.087596653477954659,   -0.0096374487707226106,  -0.070855332418833891,
       -0.055940367545580495,   -0.15811535511646232,    -0.059819345268655941,   -0.2206078679312598,
       -0.1059895877190855,     0.069161960022072186,    -0.043461401155012215,   -0.044219911412190491,
       0.074613559769386037,    -0.17531549259081769,    0.19087119772635336,     0.19207976640061031,
       0.083112304318502181,    -0.11961705058731008,    0.046397366752818664,    -0.002518323447534861,
       0.022430063496528659,    -0.047753889390899223,   -0.062948822451095079,   0.052621056731487391,
       -0.16773238392426837,    -0.12525083069488571,    0.038513220088019419,    0.033578657615803906,
       -0.043529850225513457,   -0.22317521686896213,    -0.059479735487707415,   0.12073327733916121,
       -0.058388943475395139,   0.062687805804019434,    0.10597040068973404,     -0.1138548238400349,
       0.022825643348549494,    0.028498565444299816,    -0.026734128930025653,   -0.04782684061909432,
       0.12983604028933091,     0.011553405893255188,    -0.044317161099387353,   0.10771838442690523,
       -0.30302028982508994,    0.068600570680532574,    -0.12571283415068896,    0.13862162019798369,
       0.063888522773949796,    -0.087492730913905623,   -0.0043634769510632661,  0.042813277027538996,
       0.048414225551262562,    0.062116936021233263,    -0.037221836763331233,   -0.12500319786028305,
       -0.034998646360053842,   0.046023604609269707,    0.058493524491672291,    -0.086499179625350253,
       -0.082708101066388484,   -0.012820574623243014,   -0.11290598664479104,    -0.03160149575385094,
       0.11171606332299901,     -0.034041377328362356,   -0.12148240162085466,    -0.013087443028704864,
       -0.024650150024537944,   -0.1354595406964518,     -0.22093051519174883,    -0.23568517570135902,
       -0.0085088027753652245,  0.056498631621778622,    -0.1515314669732743,     0.073166305982849081,
       0.077462986604062339,    0.053824837146002245,    -0.21358443349567857,    0.20389205636166191,
       -0.08442855526505498,    -0.031170529828526635,   -0.14817074694759919,    0.10128946964471222,
       0.019237319245744112,    0.0506217960988493,      -0.2160173306372275,     -0.098540698505297522,
       0.10439587052292594,     -0.00021940450818481441, 0.084302210984770504,    -0.028371018690925301,
       -0.007144792726132403,   0.046289970145892777,    0.14334721005066983,     -0.11527616229146134,
       -0.054368121836128415,   -0.002008769875571016,   0.11788519405904896,     0.065390918194258477,
       0.1198365983225424,      -0.16832256231772971,    0.0087240831255001594,   -0.094467802047934465,
       0.01944817949202797,     0.12769720966806775,     0.02330404367412826,     0.069457366694699402,
       0.089094489929606654,    0.040115072660506366,    -0.026224268864893489,   -0.13935832278318186,
       -0.17003627241417477,    0.050810360665447224,    -0.10436311136927835,    0.086441712558900111,
       0.22923974698743768,     -0.028258067148170349,   -0.067003363176805691,   0.11316729399244713,
       0.028307330444442721,    -0.083552088122392454,   0.09264783498407167,     -0.14899161382413281,
       -0.06655775492318497,    -0.015838632336101492,   -0.026315633576131117,   -0.16835266882584926,
       -0.13685568575410256,    -0.0077905952294030079,  -0.033497578541205254,   -0.11562038680112183,
       -0.01014742455326121,    -0.063013024225242825,   0.0014062882408348706,   -0.0098181260997603926,
       -0.011648982090063213,   0.00775412305512498,     -0.026705414327713055,   0.061329619688138978,
       0.032229275200026428,    0.011717024143582869,    -0.0202166643004493,     0.040186153647979998,
       0.090498767539503519,    -0.07948179957104029,    0.11587467521195355,     0.072058487656926268,
       -0.083124787326524549,   0.018142884107401006,    0.1543866100485384,      0.072883988089662732,
       0.063579743155709592,    0.060549164805515664,    -0.12706668594790066,    -0.094649901152831575,
       -0.07535074027543294,    0.012604739095938025,    -0.046892185601951943,   0.057031609260603314,
       -0.00046312153277750954, -0.10474542959545774,    -0.044860383889137122,   -0.070105651929410109,
       -0.013925150497700715,   0.080068130926544148,    -0.0067200630313583734,  0.013615990936193645,
       0.22541931092812237,     -0.0017163982506651521,  -0.068303131494151251,   -0.013953188614310422,
       -0.10497106640354699,    -0.045755282084341362,   -0.1727961100627485,     -0.062458663401831163,
       0.062823574499337786,    0.018755999427282826,    0.0039183389252960502,   0.031691141431512145,
       0.094179899442386431,    0.05831375149823436,     -0.15102291041733876,    0.038394017694273398,
       -0.20943506116240518,    -0.17437156922264807,    -0.022018651572375651,   0.045176662375491852,
       -0.015531534750188534,   -0.042158698289180681,   0.16603887599320222,     -0.076067953196442439,
       -0.079612074598271007,   0.099765261400314553,    0.079956973842975079,    0.29107859823538412,
       0.15668645560077343,     -0.04320886355804883,    -0.12912056383335288,    -0.073518765690434168,
       0.048702650651332148,    -0.090995209067334562,   -0.16548333208934105,    0.1867543402676097,
       0.030739566537271272,    -0.084203468759275577,   -0.23830218180346749,    -0.092234185087518336,
       -0.013978363397764804,   0.017437287465658455,    -0.087410435545800386,   0.21551309319352632,
       0.053853210637488429,    -0.005005538753912281,   0.081249523715485508,    0.1482316257778461,
       0.11960003286712029,     -0.097673046708573283,   0.032409797960101218,    0.092430908601225145,
       0.034100701284053708,    0.066297754847551918,    0.19273224885031387,     -0.13793568639343873,
       0.040288665072697433,    0.20697045759742702,     0.09839947311530764,     -0.0090835859389793282,
       -0.04491570919316798,    -0.061475836124438056,   -0.034405238192008823,   0.082819355504065439,
       -0.077071431908425761,   0.11914053303378104,     0.0039914400785578388,   -0.017107796744172187,
       -0.077236368674375805,   -0.06937452885851772,    0.071551265512416556,    0.029623256450212448,
       -0.086055408212471138,   0.032427453695403917,    0.087199242004187633,    0.017792476219528505,
       0.22623494603300995,     0.16384803359377834,     0.17165448199743466,     -0.13556597648927701,
       0.031632340509787693,    0.16480538827346289,     -0.041941227693119636,   0.023043680701845558,
       -0.1972971614164247,     0.091760235589995229,    -0.091199904217730082,   0.040353849743873085,
       0.032802200664572852,    -0.086856796939309713,   0.11627602697521641,     -0.033527511179727944,
       0.15948879619826145,     0.14761613689497177,     -0.028257883775233458,   0.046980765125291341,
       0.035440723347270359,    0.076000557996208473,    -0.1353120827292234,     0.039161025308198878,
       -0.027251632008322063,   0.094129237387656967,    -0.029605764761201987,   0.049532711891664367,
       -0.024839181869464412,   0.033686641441686427,    0.047748874495016795,    0.018757497799158876,
       -0.12306684607283319,    -0.058839483791831258,   0.056206864410186977,    0.21868562292944838,
       0.093180376976762291,    -0.090909482060543834,   0.10276338494906366,     -0.051278955521256463,
       0.033412234564882175,    -0.069076473930093488,   -0.049840831227812216,   -0.029905859063285405,
       0.12675630091726978,     -0.011080342718860296,   0.13591418778131903,     0.096011992254233722,
       -0.056722124451772576,   0.03414878808728658,     -0.013105173132446746,   -0.0789894990018256,
       0.041104433661516671,    -0.087484693681232531,   -0.018736082348899265,   0.0808575687929875,
       -0.021177604080788927,   -0.1384645558771205,     0.039546526391026841,    0.10845798341143439,
       0.056619255983863831,    0.15679695578994982,     -0.040638047120547208,   0.089767940260654169,
       -0.15114415021695629,    0.021718162943207765,    0.16397344489246529,     0.17435344940710631,
       -0.17728318184696082,    0.18930629181520633,     -0.13293913869621651,    -0.13615472861360578,
       0.071593886455792705,    -0.21321002920036961,    0.11521160962915329,     0.045443054542112629,
       -0.07961975897879936,    -0.11007293238734671,    -0.058986665047273429,   -0.095141028818375037,
       -0.038074950027131481,   -0.062269544165746274,   -0.04452670766485925,    -0.13989442946205907,
       -0.018388930603616748,   0.089715738536606859,    -0.10400839102665678,    0.16426810066961711,
       -0.014523671530738004,   0.10603389271965186,     -0.0096331419949128409,  -0.13031710979688621,
       -0.055485743308740253,   -0.041194188786567804,   -0.074070131856843746,   -0.05338746663510608,
       0.056837336053735504,    0.024132233753042187,    -0.11027964340817324,    0.081678523757191035,
       -0.045159590795523959,   -0.057916150370922126,   -0.091377153283557999,   0.012832155223537414,
       0.03293725146831443,     0.12284635699922919,     0.089014132400874038,    0.036416102807512341,
       0.16766496423072286,     0.10483482775501475,     0.032233492381655335,    -0.09168249975827153,
       -0.0087205297354158058,  -0.069745078172997271,   0.036072956780928415,    -0.17065813099704269,
       0.023452342318728864,    -0.12874554311838887,    -0.070850008262143244,   0.019225903035458267,
       0.10001460562140652,     -0.0078867939054290924,  0.071944019170837079,    -0.0044280286989269949,
       -0.069310765500279425,   0.066678728431331935,    -0.22174142267205738,    -0.12895626907225494,
       -0.081170065231617197,   -0.13712597946263419,    -0.001725376578597531,   -0.066983957609039968,
       0.20528301618884895,     -0.0087994902931136376,  0.23038562554506645,     -0.060558593480636101,
       0.020291464781268607,    -0.13431540000543513,    0.10103388225240681,     0.059930200301754791,
       0.0048811806171499654,   -0.0037794161551683962,  0.01841163931931273,     -0.12120420741572233,
       -0.0062991213583070338,  -0.096314376634897739,   -0.24069693532421255,    0.15292237031014966,
       0.02274586334310635,     -0.17009525785463223,    -0.031419611227766514,   -0.15611694337357104,
       0.12715542058140347,     -0.21878794195445894,    -0.014447352586547718,   -0.21737769628856626,
       -0.0074462828905639163,  -0.020472135599631867,   -0.065765122697866815,   0.0063456287531145211,
       -0.033031132183600223,   0.019583569868011078,    -0.10173032004161314,    0.068879694883624346,
       -0.14858121423370474,    -0.10232578465366676,    0.081202859327343252,    -0.086036265397618689,
       0.23521915427723347,     0.0021275428334319446,   0.11984883452004251,     -0.17592235157669947,
       0.12385461440911501,     -0.082069551593129023,   0.034355143791071754,    0.041163763801790508,
       -0.0021136617202238799,  -0.11297627549152209,    -0.082029399757925475,   -0.11239349236022116,
       0.0077787267406130168,   0.067386951547627832,    0.054316056948686554,    0.0056904961635354809,
       0.026822166823759794,    0.089454840841332317,    0.11646603142013064,     0.028363300105557116,
       0.044941773476442695,    0.02354764739113999,     0.032309605441848528,    -0.040577408637244267,
       -0.093302733287911291,   0.089120155207565513,    0.020146662089504469,    0.0097816281840802932,
       -0.035918462010945375,   0.1245881973784974,      -0.08550636565137526,    -0.16713024650475958,
       0.012867698323292199,    -0.11825269488829078,    -0.055168349959899846,   -0.033493198826887977,
       0.058360202806176077,    -0.0002706649776320839,  0.0045909044530430838,   0.0092509662877406501,
       -0.07479667595572069,    0.021926595969747456,    -0.075596234214453856,   -0.0057711349707111346,
       -0.098105482716669801,   -0.033815667727273284,   -0.017205810652240718,   0.14478066941618709,
       0.038935622004484624,    0.086539176452792105,    0.058947411234790255,    -0.0030578518800545027,
       -0.21069736298515226,    0.23492698268815995,     0.10727283446308697,     0.14060069923859528,
       0.083759020906800902,    -0.018759067923498563,   0.15583831824216629,     -0.14816343592357537,
       -0.013296420248856054,   -0.25807734042994795,    0.10906644938680721,     0.21590466468111941,
       0.12761523312462777,     0.12813772519261823,     -0.15528277516323039,    0.10832257882576064,
       -0.019806482584539566,   -0.038099657788384839,   -0.039936531663290281,   0.13493168354199078,
       0.01470991490220582,     -0.05507899876763972,    -0.053557659348806977,   -0.011685393227470586,
       0.068502738866478646,    0.014354110437808102,    -0.039196329099051186,   0.056024549050581227,
       0.07486422500778446,     0.20498159542244462,     -0.049890612288685215,   -0.04300308701432258,
       -0.13444524886120948,    -0.11199318350478628,    0.066226129476114795,    0.0068370021980789352,
       0.069021583850595009,    0.18466173350553236,     0.045282108673398679,    0.0095389376011382285,
       -0.0483771000170993,     0.117464504393186,       0.10972761235604454,     -0.12786031731466665,
       -0.0078548156291676097,  -0.047997106754182457,   -0.090780305933877897,   0.052110297317711177,
       0.21817949504744993,     0.045946351768575117,    0.03051037078090019,     -0.15722638069710321,
       -0.015258442538603043,   0.039708970635935883,    0.060349075511205469,    -0.18656464677425758,
       -0.041869933582554135,   0.029409938596008999,    0.076815932963295197,    -0.15856280856016891,
       -0.022828831574277654,   0.067076101592328033,    -0.14287627061262617,    0.001529870605531477,
       -0.14583909262739381,    -0.14383364027513806,    -0.050158870711475241,   -0.010400752149458334,
       -0.0090016896106556443,  0.054087279495166535,    0.18999756937109136,     -0.087215663938157745,
       -0.11044463985353918,    0.14836292239908669,     -0.045111105736680195,   -0.0021768839019806144,
       0.048209259446239133,    0.04241486722418137,     -0.10834612486483799,    0.045418842564778919,
       0.21956476433056951,     -0.014159897690708693,   -0.28111193651416932,    -0.068716167246135565,
       -0.082991694056425883,   0.031422641666137216,    0.053305182877775532,    0.043056397891374033,
       0.060644023741464353,    -0.03960578435614822,    0.033766692135134092,    0.0015488259263115346,
       0.20345140871213699,     0.03720369157502007,     0.17101705484317639,     -0.073071680593916014,
       -0.036786338470127036,   0.058291365027324148,    -0.014009339083782008,   0.11634240032816909,
       -0.051444219287080171,   -0.050410527683858473,   0.10314796653949895,     0.029189642281346653,
       -0.11768492912293543,    0.1107322961746962,      -0.020217873809973322,   0.014718785632011367,
       -0.0039926386941843547,  -0.026701105404757616,   0.083611623886876166,    -0.14858268483429299,
       -0.039070229377050264,   0.090201212316944807,    -0.078159273734163148,   0.088619119568147608,
       -0.02312254613558376,    -0.050915091106958042,   -0.033899341602378667,   0.015792527227571108,
       -0.11916685318789455,    -0.18051676751992016,    0.091613870635006589,    -0.099405330320755769,
       -0.11645987923991662,    0.048188823387713596,    0.074202992022943962,    -0.0016222157998836556,
       0.0035605818374491935,   -0.12663087767639913,    -0.28238605708556164,    -0.070205302306017001,
       0.05690134798401756,     0.090156861637250965,    0.036469705541285695,    0.11518332675848184,
       -0.12545991190465844,    -0.12716264871492858,    -0.089626183283768784,   -0.04902650116827631,
       0.13716147143400659,     -0.057507452450922189,   -0.0335877402030791,     -0.080082725447953834,
       0.21431944476980325,     0.0025877626930122175,   -0.063541468788781669,   -0.07929281913602719,
       -0.0063111150149864565,  -0.068371380380592595,   -0.04180929424981579,    0.10420697810642902,
       0.051322471956984202,    0.0009912173638038542,   -0.034580703042188292,   0.050509508888825209,
       -0.11968086705274886,    -0.00080699907315306615, 0.087990284555311798,    -0.076073619882052954,
       0.10115313621150822,     0.015009205816186188,    -0.16677805443180391,    -0.19014783092639242,
       0.093164864606826867,    -0.088865900148764929,   0.12293519748146607,     0.0017829622764265534,
       -0.085793273825814198,   0.10312059205758611,     0.27963930297946848,     0.042462206472795451,
       -0.085920113055689626,   0.02742919962105838,     0.016704031841334639,    0.15521475846367727,
       0.14265444714175302,     -0.022825912598685227,   0.0054993475985152607,   0.034427673162460912,
       0.0033428564559796941,   -0.066019813252098894,   -0.054910868211112747,   0.057684340176506518,
       -0.15164973316736269,    -0.017405592639220358,   0.0686489185294126,      0.0082861534195809265,
       -0.14853549362854648,    -0.16878441728644022,    -0.090544855961151444,   -0.03417597057926456,
       -0.058410481171799679,   0.068556397226538987,    -0.10932475584722606,    0.059643916937440249,
       -0.16197938059734779,    -0.01936240497244331,    -0.0001618405264251338,  0.069313285266968186,
       0.1558569632989926,      -0.12184566021552114,    -0.030208692829703562,   0.022561920956658016,
       -0.086709328873622968,   -0.12735936234867695,    0.19472602996811789,     -0.08511249956137204,
       -0.23401925479793359,    -0.030522965915405004,   0.035988413258280456,    -0.01225375229217794,
       0.080191645127092273,    0.031827373536352642,    -0.13935436331951737,    0.0927204091122103,
       0.023430616939696322,    -0.06050577143085023,    0.084723234941401368,    0.064185609661372878,
       0.062775263716250848,    0.023692585735439246,    0.2087861458748432,      0.04733929558125919,
       0.12926184064710183,     0.055519159898937749,    0.13866178713536445,     0.25147426231701897,
       0.021815505491299205,    -0.12788155839399035,    0.026674445714109134,    0.053586745101057834,
       0.086137536404598689,    -0.071067433231219404,   0.049651027416216104,    0.17989383577806384,
       -0.094808164559501529,   -0.07450091079438971,    0.0097075110716886934,   0.12538021567873855,
       0.057612335523744118,    0.096718996611557959,    0.035294562636276484,    0.019171826777401851,
       -0.12806341968942042,    -0.024028488085190362,   -0.089346188034968271,   -0.025637746846871461,
       0.05724642468272112,     0.054424889018753329,    -0.038150236506313974,   -0.021300007629516001,
       0.12222730924532463,     0.10366024877736438,     0.05554785306888535,     0.067683820448932702,
       -0.0808998115370788,     0.10740982652085995,     0.064979901035853327,    0.039397314553101311,
       0.21481366892360679,     -0.13926105039374312,    0.069871084053039767,    0.19293883915997845,
       0.024126958774397606,    0.060197471112039838,    0.17018850597285484,     -0.19197578151547881,
       0.04777878936493217,     0.19417096269948236,     -0.16292870548127983,    -0.086114399437012823,
       -0.0064440751937866634,  -0.04493688905283684,    0.020761052746630218,    -0.071198241540037024,
       0.042837045192721454,    0.10713686560183092,     0.0026586892891554367,   -0.016274313433044332,
       -0.0087401250973499125,  -0.0041021474940772327,  0.11529202187037017,     0.029296547777456033,
       -0.026224064024815242,   0.082923050116018776,    -0.16165952559970981,    0.042183514800681408,
       -0.10323801347709097,    -0.079765157327929076,   -0.013696551772079849,   -0.0079227602507738644,
       -0.061666823285393906,   -0.080541828721387335,   -0.093915614687947943,   0.12011169264317105,
       -0.1794931048674353,     0.075550536418390324,    -0.076008997638604373,   0.031648903905937206,
       -0.12071599042437776,    0.098732560271118652,    0.18710542886093476,     0.13965075350092748,
       -0.1317153657751062,     -0.023758961474572512,   -0.071332809921679577,   0.0010416323898718087,
       0.042197544854420392,    -0.032374216252268509,   -0.1069784513293829,     -0.009300566300643083,
       -0.068874607890093101,   -0.096060602062179756,   0.048717645667807209,    -0.16476129564708092,
       -0.045164323181758448,   -0.013723602179392336,   -0.033959657767481867,   -0.11323290176547922,
       0.1751635893522672,      0.036470581157278976,    -0.04451906703320168,    -0.072121568067256697,
       0.095643370193264868,    0.094899578981046978,    -0.051984390254630537,   0.083413778182591908,
       -0.018460551470890613,   -0.030873452882219699,   -0.16438412643389988,    -0.042888433171480403,
       0.058349195031449405,    -0.056732190332275743,   -0.14981462032503648,    -0.20877100868691728,
       0.026239504602555384,    0.13046812912707148,     -0.02206174353475341,    0.004145883708898861,
       -0.10862040447004316,    0.027578560554794355,    -0.10048953541964768,    0.12881640744800049,
       -0.0015684194426198402,  0.078404734851068622,    0.061087356143232116,    -0.074990949821668706,
       0.03157158213974276,     0.069109558037125221,    -0.1792513495743161,     0.13282794646291324,
       0.15207983139112796,     -0.1034905248351321,     0.07965035502436367,     0.021817622095650295,
       -0.1467848639766908,     0.048329111441679271,    0.30287758748013999,     0.0231690160199962,
       0.073327463064827944,    -0.18924039537442233,    0.096872930842010846,    -0.073496469399015024,
       0.034033495777557765,    -0.06298767233772426,    -0.15874142843713343,    -0.13618499973181245,
       0.061959928501524042,    -0.062461665713167754,   0.14236874214382017,     -0.04472226161436281,
       0.016396228025498963,    -0.065059772049697595,   0.11705561249566285,     0.15967909607700898,
       0.014267742947886073,    -0.042028323026271519,   0.20781472193756176,     0.0042617321479472576,
       0.076305825027805904,    0.16336568281792516,     0.047801337751103956,    0.046438689402038061,
       0.068750318589006973,    0.084505581880272088,    0.0084409737841680803,   -0.21839686223854612,
       0.039047304654696371,    -0.076944047569633967,   -0.088783719377578063,   -0.085396675393787369,
       -0.1280132974054482,     0.011329526646254872,    -0.029748613020147051,   -0.089017236268893407,
       -0.055461983876714527,   -0.042616073783566071,   -0.19043634693052519,    -0.056782777068659598,
       0.092209517470331639,    0.0050528775608208775,   0.11544817470603158,     -0.053982321686744827,
       0.16225084698404654,     0.16814818917955596,     -0.069290505476062442,   -0.083411463176001899,
       -0.090064731062565143,   -0.02814740139210822,    -0.049710734293395502,   -0.0030596149357600979,
       0.037557411738734892,    0.084833192569908927,    -0.15852749851239145,    0.029639306632898627,
       -0.040269249129803099,   -0.072938264424711935,   0.0016619215451338324,   -0.17446494658354689,
       0.018281382070898484,    0.077323563481818222,    0.11018730250902477,     0.26307099700060715,
       -0.10044480438867752,    -0.08431368443001723,    -0.086190767669775348,   0.028911815728144111,
       -0.21205888005599655,    0.0753246587399901,      -0.044567657407130506,   0.13220110333047694,
       -0.00065156997189519655, -0.12037998061595125,    0.069502814562679996,    -0.061791303975667698,
       -0.088845970105558114,   0.17475466389720123,     -0.10423894257645556,    -0.13498506493679016,
       0.051332786687363768,    0.14274285666226005,     0.11914924804716373,     -0.032721208857863081,
       0.089555873503056646,    -0.14883977927675662,    -0.0011418834271649451,  0.14006241852007259,
       -0.19753236876762179,    0.012715582649032151,    -0.038384735580026301,   0.013954808444641193,
       0.047612537493656543,    -0.023769505006130003,   0.091789649886386049,    -0.057467674872268448,
       -0.067618325936357457,   -0.048616716068621391,   -0.12791404397723075,    -0.059205615500415858,
       0.019799829343160134,    -0.12489845959250902,    -0.00035172810671027369, -0.053689740259523375,
       0.10163871045728197,     -0.17171336032483961,    0.14055783529218915,     -0.03414175567265388,
       0.093029640950790707,    -0.091850237051854772,   0.019106741465688092,    0.15264957800130216,
       -0.12439262056623973,    -0.0016756411480783795,  -0.013404764034580045,   -0.091528350839720954,
       0.10133112027214682,     -0.13381379588458983,    0.090188262420559828,    -0.10811342737071937,
       0.034204946687065564,    0.013650033503961255,    -0.093618843416837905,   -0.31857040319255175,
       0.049924164499417327,    0.088630510482813993,    -0.10835450790532367,    -0.02066116388402426,
       0.064296632510364576,    -0.21175534396870915,    -0.0080729878045791865,  -0.24036934872173904,
       -0.024270882674491161,   0.013492722017272975,    0.019008083843384291,    0.11089472226387574,
       -0.050162932732398198,   0.063341726402757481,    -0.079879685397869146,   0.0046258244704082607,
       -0.050680233552645414,   -0.10288407568770788,    -0.14762082825930839,    0.14951813399602296,
       0.065647972663339813,    -0.071196633344439153,   -0.11300474053747513,    -0.095549120417565594,
       -0.02799346236448004,    0.21221542866256113,     -0.053376262866363926,   -0.1415198317776179,
       0.044845702030040673,    -0.06662667844460271,    0.11601827942412138,     -0.0095151799607645377,
       0.085781627850814252,    0.12096710915544691,     -0.0058366774445586384,  0.09768934132055343,
       -0.05769953165068429,    -0.13288272215602742,    0.034455754196828177,    -0.010629210940997917,
       0.0058646353166625746,   0.084528700458184947,    -0.046307550803005332,   -0.068933552597887082,
       -0.16380585437726364,    0.27198762679328109,     0.02130622775416955,     0.10425276434988581,
       0.034230391278948259,    0.027184800323544915,    -0.048756161805724313,   -0.054865730402325188,
       -0.015636157343294915,   -0.062891940463890794,   0.042305179948539058,    0.041383515114853268,
       -0.050392966084396348,   0.0048938468848471507,   0.12995583890783347,     0.092238538029099038,
       0.039345614343265459,    -0.037001948320801524,   -0.081416441776268653,   -0.1557843000498203,
       0.12129074075118332,     -0.049387769522463792,   -0.1347921741517786,     -0.32452357367308082,
       -0.042277085479172881,   0.13706484028435353,     -0.054394605143311126,   0.021766344388042123,
       -0.10457178836398889,    0.08249658959512382,     0.021648893016788844,    -0.074303446709668541,
       0.03020341559068658,     -0.1131413198794765,     0.11252229662868658,     0.0092384223401317939,
       -0.015338194320614899,   -0.028295683255423632,   0.077481788841800875,    0.1200599545992625,
       0.056295044946666081,    -0.071191479560368295,   0.0077753932917055263,   0.066011717097844758,
       -0.014928805320532191,   -0.1198237271903415,     -0.08910275928419803,    0.068484702250196941,
       -0.061776217996277492,   -0.02504183840654017,    -0.12555095765609178,    0.047180376049060301,
       -0.045098152749624379,   -0.11949494274921615,    0.067044974896798643,    -0.071027059682460439,
       -0.16551651631119216,    -0.16944460914329101,    0.068908386506461222,    -0.019941072244481814,
       0.021765785134631139,    -0.067586889912208709,   0.11099831168668779,     -0.086111557429285127,
       -0.15456478374364141,    -0.016585923085337052,   0.0041314693062460012,   -0.31234262234268467,
       0.017254363085591196,    -0.1128233729321975,     -0.10436360428760583,    0.064775192985290164,
       -0.055714186259320266,   0.10305046231333644,     0.05585418137492297,     -0.13405417996606694,
       -0.041527169167968919,   -0.092812729760739135,   -0.02057032955019163,    -0.10463715757725232,
       0.052638903857822689,    0.081634207300643344,    0.023079628604164439,    0.036451846698687347,
       -0.1715170279641533,     -0.096160903398798556,   0.094274230145554,       -0.027956464054111257,
       -0.066639693137369616,   -0.036599923119180408,   0.1011714064537643,      0.032562245624796496,
       0.084350878273627555,    -0.012967331825047715,   -0.0068611021168900662,  0.059638521505555819,
       0.046403360582979496,    0.073727878740066005,    0.056253216948686562,    -0.09949253273270213,
       -0.021511035304517059,   0.0031243890193811096,   -0.14796978396667645,    -0.054672933064813793,
       0.090871713957603226,    -0.12297510700582737,    -0.16028906299275672,    -0.10354426631536456,
       -0.11267933640011432,    -0.081684669907332294,   0.15661496875938091,     0.082436995782089947,
       -0.063736651044886627,   0.11411769869880108,     0.092270415899477154,    -0.044893717719868866,
       0.21202892537340515,     0.11933098073903742,     -0.029715969759526964,   0.1615034693940165,
       0.10878418724853427,     0.15344042936933344,     0.025551810114207461,    0.13139828828761807,
       -0.071033291404119916,   0.025323017451983558,    0.050104898188154154,    0.031705716682141262,
       -0.063789998150443034,   0.18259179902610259,     -0.14491786882316063,    -0.16134648325402318,
       0.0070356384428373435,   0.036534380996925402,    -0.14762452573925441,    0.024091756200901714,
       -0.23100025484105391,    -0.046572727987738594,   0.043984100364727267,    -0.024567927689862691,
       -0.085700995910313646,   -0.039584917126123817,   -0.041678275253304344,   0.0016857514951318861,
       0.13212005730614451,     -0.16737474074478978,    -0.083060951393759158,   -0.050030906262585745,
       0.14483340644735573,     0.027027924180164885,    -0.06344601464965266,    -0.062010384507294181,
       0.059457771055458179,    0.001735603788757303,    -0.17990669398221068,    0.16641821113187591,
       0.10859566139114205,     0.11143448847421691,     -0.015660993147574631,   0.094589370643015716,
       0.14834559698170904,     0.069158342672638998,    -0.047259144880479512,   -0.019451937136849323,
       -0.20863923618515759,    -0.088204272926840327,   0.11808441245512812,     0.0062173005762958394,
       0.027020491504607586,    0.11427836957463586,     0.068981983822988244,    -0.017552172022214829,
       0.0079432514559104016,   0.094008283684867647,    0.083398245552776987,    0.086759154721738882,
       0.050938191577225581,    -0.026616499924874075,   -0.009657793567689997,   -0.11063638850613428,
       -0.012807556709259055,   0.19571312228933577,     0.085412122042164071,    0.10690098926340282,
       0.077242271324083692,    -0.015507704543963696,   -0.13657416669479061,    0.099580357294550781,
       0.043416570358827108,    0.1261050226797617,      0.15782258727498272,     -0.0020390399428496242,
       -0.031984762710377056,   0.0043237178161550163,   -0.019162652694990887,   -0.10511163583932844,
       -0.10365329333374138,    -0.028406262227413211,   0.087007318772458903,    -0.017821881580344211,
       -0.027916127595368101,   -0.045166313948870593,   -0.10548530541044986,    0.029222784890340456,
       0.036590739600556539,    0.014158011014732311,    0.057235328426297929,    0.036459548934252496,
       -0.021823902215935789,   0.10835989180703974,     0.0068921085103829634,   0.19146636970126824,
       0.039384768485102292,    -0.004244259888081402,   -0.15869150323298656,    0.063800532614939509,
       0.075192519391037674,    0.11849498122039764,     -0.0069381379895018854,  -0.12018459982957791,
       0.020186758083451703,    0.12112439235632141,     0.056381446751743079,    -0.043263296149856398,
       -0.015334236316866588,   -0.13361972377216386,    0.065555471188850079,    -0.25126934166510967,
       -0.054385482265453561,   0.090823421696804851,    -0.12476501509803362,    0.066743840123368134,
       -0.06500254426072298,    0.0063485622986299926,   0.20977278565866841,     0.068284041791522185,
       0.027968117016859508,    0.27990558661283621,     0.058832540571233896,    -0.12942283723552314,
       -0.22819176951295206,    -0.10785699392083568,    0.040931241217534331,    0.11123862725094691,
       0.051242052008005134,    -0.17118504514845273,    0.048319254934529793,    -0.10509421462222948,
       0.048748550154968796,    -0.16805964273241047,    0.073039998450332294,    0.028495718270062486,
       -0.14235729634494826,    0.042787826912742806,    0.099556562302255069,    0.030094208359537536,
       0.066418918279452857,    0.083487528336288183,    -0.12092207866814475,    -0.039296583351059865,
       0.19024613904846008,     -0.15199724649567012,    -0.046054413111498799,   -0.0014212812008994099,
       0.031270820330381525,    -0.17230697416950597,    0.039417298337164508,    0.047714190094628184,
       -0.12908147651884877,    -0.13642661304435655,    0.013175481308145028,    -0.1965082401695448,
       0.059723136725243882,    0.018434402613583693,    -0.057189637332695005,   -0.070724852189557347,
       0.16170703670465406,     0.059298877988431094,    0.16536011309508394,     0.027710404669680229,
       -0.024454030190626003,   -0.055124816721008475,   0.13442532666898793,     -0.015922466276926575,
       -0.026154513305323476,   -0.075584097802575162,   -0.06302291028804799,    0.010725103436095427,
       -0.10107826123249794,    -0.070694789263482091,   0.0087004471504711408,   -0.096937582246756887,
       0.078629696055865561,    -0.021346611771761941,   -0.025722743697290808,   -0.14846913226052197,
       -0.091959859864506444,   -0.042160165686601636,   0.20812563849899587,     0.06423888032166826,
       -0.19111016091557126,    -0.16495050990524426,    -0.0054381752946671916,  0.015477727939061357,
       0.097468154370041526,    -0.028260224836117571,   -0.031032342150116955,   0.0058744774240347469,
       0.11036658691421182,     0.017100061784314072,    0.18745412872996917,     -0.055681779411311298,
       -0.08423125143341903,    -0.053890482689784351,   0.058445047209623791,    0.047083493362981392,
       0.29581242257865792,     0.023461591464338696,    0.0049348467457572117,   -0.038269783199806492,
       0.025800764877018247,    -0.05660681910577868,    -0.084273266100291747,   -0.060137767085033184,
       0.035423277935419391,    -0.26562579704022687,    -0.049221721772489159,   -0.047420842138295401,
       0.030735905272090559,    -0.0073988997488791102,  0.063161443534234613,    0.095265726327431868,
       0.17366443403008841,     0.18909326891384401,     -0.003701219412625547,   0.16388909906711327,
       0.0097805192553783449,   -0.0091477909905966926,  0.0099020791041191415,   0.1188540690345284,
       0.073734439760974088,    0.063234439136841153,    0.016306033198796633,    -0.16108731180663291,
       -0.023251577782801,      0.066146374946010694,    -0.14143557864621539,    0.11641440540061905,
       0.039724218937648305,    -0.0047051120677374268,  -0.19002725449909269,    0.010052425024675527,
       -0.089812367465575638,   0.10751414439090319,     0.059235451751046587,    0.12801594111459563,
       0.093801667153129917,    0.090826062134889543,    0.0098472859442799918,   -0.074307312359763344,
       -0.0080001352630524256,  -0.059941503060441576,   -0.079690533161907606,   -0.14292345823966368,
       -0.031008025922599193,   -0.15380341991348459,    0.072722252218031441,    -0.0072564411046875613,
       -0.061786455167850057,   0.20216494072878485,     -0.11457533003586677,    0.035493154755027227,
       0.03513608962419492,     0.11516055626367819,     -0.1703106872321776,     -0.045351920286465681,
       0.0067431694437648029,   -0.022543329976258318,   -0.15736698947996794,    -0.010806883650605448,
       0.25545798183735691,     -0.11867494286492622,    -0.078817375067382095,   0.027694065873673332,
       -0.066675788851480927,   0.021873035859111344,    -0.011386261456416717,   -0.027781940441545187,
       -0.006083524874158407,   0.10131504258899149,     0.085198723983268998,    0.028671943923982538,
       -0.026695484007692855,   -0.10806478370547057,    0.16262511078206152,     0.053502444442818972,
       0.014057935205624379,    -0.021445924540584211,   0.023023104814746655,    -0.17739874596022792,
       0.054201538407309444,    -0.076039594127074089,   -0.09197664513009593,    -0.050235528393706964,
       0.0029577092525347598,   0.12948873137909211,     0.11391422257519697,     0.022421533963577305,
       0.033864541944385776,    0.23064685838978854,     -0.07010463929678519,    0.13637970110753714,
       0.10774679027595988,     -0.0025125589985610141,  -0.036488091426362473,   -0.2405890318602508,
       0.02088307796060581,     -0.057881304968936641,   0.051921602324200448,    -0.070642567147569363,
       0.095723113437869448,    0.038769697307965194,    0.085321035350565302,    0.045855323448095411,
       0.043486663044778898,    0.11076703616129795,     -0.024967331258323556,   0.081960188543387325,
       -0.13717104385678361,    -0.016751620970704883,   0.055566532823737261,    -0.00034340910685787783,
       0.089454747346099331,    0.0098717653688329271,   -0.19804316916007966,    0.054796327879915112,
       0.033590910952963425,    0.15253684649527938,     0.11565790954051434,     0.15012842686472216,
       0.18822059448431921,     -0.10290934001455619,    -0.18502866404596696,    -0.23854237628876743,
       0.06148161301762075,     -0.032328846089993583,   0.064144071758063567,    0.010415078276722379,
       0.040141728939773122,    0.13030560993784063,     0.062840988252809704,    0.096067627221954111,
       -0.0034261844235676138,  0.17880088425685878,     0.065376973428321924,    0.028402286027694533,
       0.068466567309139886,    0.0068769335160594088,   0.015704843640272834,    0.11037746703550602,
       -0.0016544070940442811,  -0.044544329209858916,   -0.041469557509078631,   -0.099839462491508338,
       0.0024150712392895586,   0.12575564226798286,     -0.0014903367157421783,  0.060390116173190622,
       0.052796550758979127,    0.09184353564294602,     0.058554724727500375,    0.096096030761680454,
       0.020553548576764183,    -0.036226887608038896,   0.063402361140171476,    -0.15405185042101674,
       0.049158203220416641,    0.10070712444506141,     0.012952159171625583,    -0.18047211428375998,
       0.0048383402626780347,   -0.060364489270717026,   0.12595834375167209,     -0.004918031703887495,
       0.057074876752622503,    -0.090446688331115105,   0.089187462025925229,    0.099285325095992319,
       0.00026468235139559017,  0.20537589970319781,     0.14558095469544727,     0.090961216907303591,
       -0.020413947059238966,   -0.016513606426625256,   0.023787683529843472,    0.033958598792525996,
       0.14595653384789814,     0.0069579013611724052,   -0.037426982718401253,   -0.12712415247046108,
       0.12336873757394125,     -0.032133741752939121,   0.10377581378585504,     -0.1224435454757868,
       0.081772001248468201,    -0.10445250247158759,    -0.02843452693803716,    0.20568674894943875,
       0.043609925095543824,    0.049261944813903863,    0.13111226260593817,     -0.018044648753023498,
       -0.26798872502068433,    -0.22280702187016974,    -0.1065927187681415,     0.047699728301435075,
       0.027696392462959206,    0.017766638147800586,    -0.1130224232662229,     0.086871563434211665,
       -0.025437329731622969,   0.06648520045361074,     -0.053512187518441431,   0.075343733741941477,
       -0.010881630251039639,   -0.060565211238743172,   0.10015321800024336,     0.12264447328510084,
       -0.096697579113882715,   -0.14790999732446725,    -0.0860467162233369,     0.096878871104843389,
       0.10523100559525236,     -0.0067457033771930689,  -0.014161739348842026,   0.13973756760200207,
       -0.0098019282662424358,  -0.22015049364336811,    0.019259468094917399,    0.0061656269572217086,
       -0.021878951898989616,   -0.1432153851611748,     0.031817289041325761,    0.26562958324658487,
       -0.18636134233942425,    -0.018794945666120277,   0.14655300445742095,     0.15649784154703175,
       0.049835859540958066,    0.14513918542928744,     0.0078671066174314987,   0.05987535726602939,
       -0.09454844520843074,    0.060140284199606937,    0.085410194259553207,    0.15475032327411867,
       -0.015381161496907896,   -0.13565333536972632,    0.04341916172112615,     -0.020537117081110584,
       -0.055667094023375524,   -0.017055499494623011,   0.065168130102358557,    0.0008777348701445066,
       0.26520066745012172,     -0.021092199773922921,   0.068517569358372915,    0.10151358040996833,
       0.044951789498602332,    0.1422898998274652,      -0.19799465057788029,    0.18006617557285431,
       -0.04583150449878258,    -0.043723009027156395,   0.041677020742809955,    0.040989935943595172,
       -0.14955136449824183,    -0.029800645027572355,   0.099400340319215505,    -0.10410314376336324,
       -0.16036596606173278,    0.15972128362700311,     -0.0048035189260804785,  -0.031584195542895238,
       0.036842130175236666,    -0.044300643209135335,   -0.074213686791895606,   -0.042761839064395235,
       -0.0050301219667840038,  0.045920540062331622,    -0.027888176371442745,   0.13331331163736845,
       0.20621632138102386,     -0.087799228133969343,   -0.018192497273727262,   -0.0079222629542569332,
       0.025065151297388025,    0.0098655850253324927,   -0.19483176754060097,    -0.12067372865333573,
       0.0042699727535086083,   0.071965275178035887,    0.094170039915494719,    0.091023225037452346,
       0.17686387269122417,     0.079341069566918707,    0.0828891204468402,      -0.067347287461479707,
       0.0082938033427097067,   0.008004886439454309,    0.015859248766787147,    -0.01099423168532008,
       0.047824718054802005,    -0.042102075602131306,   -0.02921737267124103,    -0.071361422654786427,
       0.17703119817907639,     -0.068356062845422283,   0.055463832593019388,    0.081516582601156282,
       0.051039994332947876,    0.063297376747591796,    0.16853418778404913,     0.022424335466331154,
       0.09259517579762977,     -0.061941813480159737,   0.18808766794828224,     -0.19178742277871416,
       0.14932245443331979,     -0.072705044089341309,   0.016518434007098425,    0.089773050951811498,
       -0.15548811173486074,    -0.022469825635156961,   0.12576970098919277,     -0.0036898872430729812,
       0.16788146917924532,     -0.087191092529915859,   0.00098620339412144441,  0.10445650861369149,
       0.03497955570096993,     0.1380622192045155,      0.038536737074608057,    -0.14685158651716815,
       -0.024366971997032812,   -0.19138007699100709,    -0.097821260488306291,   -0.0084854774039404262,
       0.13653628574016499,     0.046618880974661082,    -0.12483377050657191,    -0.10815197854261091,
       0.095544056164725805,    -0.17492979400491029,    0.046655865332624599,    -0.016076534649625929,
       -0.041848356530567149,   -0.058399466954665268,   -0.091814733095024997,   -0.057675619225282165,
       0.18069510512984072,     0.072634109807172914,    -0.23666744377733573,    0.051139054696685261,
       0.071415816078465824,    0.015329990958417481,    0.026504427974311403,    -0.0097607276931006223,
       -0.1004785197280362,     -0.010615855691301079,   0.053859950714915908,    -0.07504791938116992,
       -0.14937202477794431,    -0.21104010627239972,    0.027346001608462674,    -0.11315959849672144,
       -0.056461876573283443,   0.10184248829699313,     -0.12809072119542605,    -0.12631874840075458,
       -0.013828891374717867,   -0.1670870923641069,     0.18370091998429419,     0.025315111902844301,
       -0.15231303421796227,    0.10086046209634239,     0.088372982732374192,    0.038016617632517728,
       0.089553543203366615,    0.069669397671606403,    -0.11897341030323727,    -0.038841083815468344,
       -0.034932648545190716,   0.0050198704180491674,   -0.19368404038846201,    0.13564325975912483,
       -0.029044512268465727,   0.11255859194618112,     -0.024607899566448783,   -0.12026351094932212,
       -0.051942284078279659,   -0.056975391067322724,   0.068808617119108587,    0.045509559632543342,
       -0.033052444709724092,   -0.028166846152528562,   0.031346783911498359,    0.13081881778595533,
       -0.21136477005914853,    0.20812186920788261,     0.042946658597280189,    -0.027909080967131412,
       -0.1385654561382608,     -0.01284368888817693,    -0.18537508313296208,    0.11768063277409069,
       0.0094794745746936918,   -0.081572328832331772,   0.072014867594018622,    -0.20360618799478736,
       -0.0092822084619313162,  0.067702997224815611,    -0.018643945446437691,   -0.0045854175692906923,
       0.12039693099121003,     0.013458401002632223,    0.15043594504631916,     0.055902328528687165,
       0.094238169922767928,    0.16745714202250014,     0.058605092977143114,    0.036639689440016901,
       -0.12673230689445097,    -0.1071987762914406,     -0.096794524912168375,   -0.02657026482426093,
       -0.10339963809379518,    0.059734291481166227,    0.07064326778800617,     0.0012576113079977558,
       0.062580471322637943,    0.1539570440171221,      -0.068233392281277769,   -0.061758933914816072,
       -0.038772331446296028,   -0.11876304427933947,    -0.11644573855242701,    -0.11315157075047723,
       -0.058350992528113259,   -0.018006050123599217,   -0.049499175297142345,   0.034131631258152578,
       0.0090610595441001918,   -0.14888178976560726,    -0.031454269119443733,   0.073470986135297692,
       -0.012129115164536474,   0.11818857519248124,     0.036206711359985246,    -0.0039966143888940913,
       -0.11177052345209003,    -0.0024799027268387541,  0.039122221589426166,    -0.020352391432499606,
       -0.021216267873114644,   -0.066005574244651685,   0.049432935682722147,    -0.010326952638824584,
       0.089481592017595021,    -0.010927705304844826,   0.11070655304791044,     -0.17409626359147351,
       -0.21242080351892284,    -0.048902882324979614,   0.1289495740232324,      0.0083875348096972002,
       0.0063682644853766193,   -0.0048194395782813759,  -0.12287227136002608,    -0.072600381188765606,
       -0.08467770665130879,    0.0056522652390610106,   -0.13322802784817669,    0.045177199271437478,
       -0.17643103312035191,    0.08695726935854213,     0.032755112037345713,    0.12158269439545363,
       0.0049938555750787339,   -0.027766368033890376,   0.076007828508808647,    0.11015121188527185,
       -0.017260791266252195,   0.035237416001228733,    -0.093876344480609275,   -0.043676674546458377,
       -0.12652876182294359,    0.21678666380496722,     -0.097013813895886328,   0.055623433883514775,
       0.082299178343441332,    0.15321025180541267,     0.16883295504637247,     0.080260943869952792,
       -0.017054557701334187,   -0.01001385341838296,    0.14457398089806803,     -0.028734658227349719,
       -0.16301697655840641,    0.06273955910875148,     -0.046601560399016605,   0.1677567212514042,
       -0.015602082528099562,   0.15543442422222745,     0.13380105671413892,     0.078805728580542245,
       0.058804915618884512,    0.15431571334839622,     0.020343480556522759,    0.049111794973870047,
       -0.032032796488836515,   -0.0062497192168641672,  -0.0024608541848931665,  0.062975623871488903,
       -0.13255835472984112,    -0.11969696043945663,    -0.13973266394769912,    0.16919120466452131,
       -0.053133691561241266,   -0.13718335495423234,    -0.064400579956749512,   0.15191812069869567,
       0.084236755972335639,    0.10347977614074309,     -0.054258780326238133,   0.060923011656768875,
       0.25605589544894902,     -0.017220105480103692,   0.079016979878621593,    -0.066072411771997644,
       0.036276808309697886,    0.010514962021198542,    -0.13699264666916156,    -0.10358377808538857,
       -0.041116948322037578,   -0.036511883901858021,   0.039008250209382797,    0.2963708771027958,
       0.033770574699575409,    -0.030182546119482793,   -0.043521644424164896,   -0.14793169809737064,
       -0.030286570285804369,   0.18163689726424126,     0.039413977551548823,    0.065223082893112461,
       0.065589314856779948,    0.15682479491161216,     0.036171779021661687,    -0.14386326669415994,
       -0.065957837253248247,   -0.071641362142336656,   0.0806548537998375,      -0.012577873766363015,
       0.21265121982536725,     0.081905522408129774,    -0.016508581599427356,   -0.15348031343073928,
       0.0025525808360760422,   0.17681519310611626,     0.11214005981818982,     -0.078977252887474966,
       -0.17498894815964516,    -0.17192477848758542,    0.01192506486056252,     -0.1478457093780273,
       -0.00095777952170205977, -0.22694280941849052,    -0.14310776836771544,    -0.031662160142655257,
       -0.1442620281113515,     -0.11655005371871534,    -0.036309835539187145,   0.015860732261762423,
       0.16490519190018904,     -0.048031371595364795,   0.15149073478888567,     -0.12620249988182103,
       -0.047602635883979283,   0.10241035355516187,     -0.073998328449885631,   0.023296652258375291,
       0.13085559850265208,     0.021848284711655803,    -0.00074808550492024006, -0.089281549606475774,
       -0.026657683827179812,   -0.061985380413412838,   0.13823899845117704,     0.14968185575855342,
       -0.0045766743129883342,  0.0024406006510226206,   -0.0084533015645882302,  0.1043696525242909,
       -0.067359342193121438,   -0.10809044810973904,    0.11389616927174212,     -0.032574736785149862,
       -0.12747360217717782,    0.0031753768456085421,   -0.1490032395957816,     0.076991103714755135,
       -0.155194183930527,      -0.025083994447696052,   0.091706357440407546,    -0.12276977854255242,
       0.10820621295664086,     -0.12076952851297175,    -0.0082947976549106565,  0.10313821841203692,
       0.030442749470492747,    0.014182181872530585,    -0.077617570604025229,   0.090443795975002475,
       -0.042922119476216089,   0.047235413511512711,    -0.044755270937405028,   -0.10579513206661281,
       -0.025769071314968507,   0.016264730616739356,    -0.070778797676772143,   -0.00058980058050667021,
       0.11689176394684916,     0.060635961202326734,    0.0013595318287002028,   -0.061875506603348625,
       -0.12913316721583812,    0.24903189061895892,     -0.18880245963362727,    -0.028396008276861229,
       -0.0003597177788628135,  0.10530204682602952,     0.100046988027958,       0.10515620329393832,
       -0.029343706932411086,   -0.04910920998854134,    -0.037245975590356285,   -0.057136869170639246,
       -0.0056469951500506786,  -0.038647669857379857,   -0.0027842983032420245,  0.1737024477485386,
       -0.050758217580923311,   -0.054560465146674529,   0.13751514891653527,     0.052739801447260523,
       -0.19714710459546561,    0.013324777281576643,    0.014849836356351303,    -0.0090313858530333257,
       0.077918793578138842,    0.16793467175990753,     0.079962858127736486,    -0.056902531061692393,
       0.012338377024373369,    0.11422899156336991,     -0.046530631730258024,   0.14635334775365014,
       -0.017220357978460697,   0.12751620972580371,     -0.057264044173383759,   -0.13425011019636923,
       0.069091927465615127,    -0.15258754829863655,    -0.0097288108607906307,  -0.093414185702010322,
       0.058643713724728541,    -0.062622856370213517,   0.0570693051128194,      0.013707453668632647,
       0.12820679641778554,     0.091540474633130073,    -0.018448908572094157,   -0.044100046167548874,
       -0.031561612902946207,   0.0051884962266182943,   -0.09161470485891024,    0.1640622955430657,
       0.16639465494277336,     -0.091436352739623153,   0.079615838830057004,    0.014508906537991998,
       0.054345451101401793,    -0.047546727025414674,   -0.13519998765640445,    0.069137490961109618,
       -0.021169748059731094,   0.066429579963258378,    0.10925396317533008,     0.061571066140796785,
       0.036733056008916867,    0.085595843986988301,    -0.18296106709603938,    -0.14375674770959296,
       0.030855026445396609,    -0.12581365977661738,    -0.021093734545387859,   -0.034170454617671847,
       -0.052525589243194538,   0.065433194727001112,    -0.022517989691338079,   -0.043140460033541064,
       0.019902825909831473,    -0.13439555691887511,    0.0040449001603974303,   -0.12989485762493355,
       -0.0041472377473600972,  0.01074178754639102,     -0.14204333811620382,    0.008131542931875263,
       0.16482195848382528,     0.005677219015672039,    -0.00561452225645496,    -0.07012679098699133,
       -0.1305819181980763,     -0.1021528690225595,     -0.0072980726594120866,  0.06480042822310024,
       0.12805354076416156,     -0.22997519875848058,    -0.010367560802510941,   0.0087939505549365516,
       0.044409011464275852,    -0.073848437267334546,   0.0964101687572472,      -0.12470664500828584,
       -0.13091562388679734,    0.058156249395556803,    0.10993946599137323,     -0.002513126349530252,
       0.32019172090712145,     0.071611485192320912,    0.11034230110879217,     0.025286534205047659,
       0.1531072311193547,      -0.029700642794550328,   0.24619885502936947,     -0.044829832083370762,
       0.021412215050666605,    -0.23155123413624643,    -0.063767151451936663,   -0.046288937844803979,
       0.085673477152606439,    -0.039025708549223617,   0.027270785374789816,    0.20647526868931868,
       0.065034452094040948,    0.13352537306401197,     -0.044253108592794951,   -0.086811518799665921,
       0.031021577996584844,    0.043691010090777083,    0.039907485299240146,    -0.13111735377282657,
       0.027506052613920161,    0.0020150570060894924,   -0.18830543160429644,    0.033192557664878879,
       -0.070162665844417424,   -0.1556263208023474,     -0.072257997911626043,   0.095485078125918457,
       -0.030232045227809486,   0.0057493400577357644,   0.022847812300828756,    0.0023357628280918346,
       -0.024741520871338778,   0.0080824976042011311,   0.071615393180430323,    0.07038231019771625,
       0.077214505610997963,    0.073527884371717075,    -0.014019657265262319,   0.080414544879892275,
       0.0013829588125851,      -0.16630407646973366,    -0.016015963203058398,   0.10531478850267667,
       0.061339780724533118,    -0.039175771383042256,   0.0079430703923966204,   0.021580299418785642,
       0.18069839140653363,     -0.0017325072997156511,  0.022958370852976383,    -0.057333073906610403,
       -0.15078678984533908,    0.2722947646797319,      -0.22368633404786359,    -0.028713072253508803,
       -0.16567720751767281,    -0.0040294643246023849,  -0.014672301131426769,   -0.14020743721276166,
       0.059969583876023587,    0.05863647016186594,     -0.070530540346469051,   0.19955568487687517,
       0.18701328766754527,     -0.079098008891352836,   -0.2090762923193345,     0.10946787486099911,
       0.018866941029821713,    0.13264813667235478,     -0.034943752243696856,   -0.14139357049602647,
       -0.092095449065159318,   0.048410876176302922,    0.034261409501376378,    -0.051250237269558317,
       -0.020396998947953798,   0.065816456096181586,    -0.12651712746507682,    0.018297776712553074,
       0.069739523469155171,    0.13013449620994849,     0.047881608450566771,    -0.0028841178125187179,
       0.11501062181806813,     0.16838860912041506,     -0.16361945445010337,    0.09075013674663078,
       -0.0096934925631783526,  0.16180897277337453,     -0.088939967608180834,   0.026473470088015896,
       -0.14820850355055698,    0.026440086169332383,    -0.022703709578009591,   0.10266703990242541,
       0.06875739255501849,     0.12618079085557543,     0.017133251642551851,    0.1815582004702132,
       -0.14965861751795959,    0.063623486431333073,    -0.032788908952110896,   0.13773469666406066,
       -0.068992975637976336,   -0.087023564774404275,   0.0096104283965260454,   0.036677267229836351,
       0.015346051647272799,    0.16933237334330026,     -0.027837964622460541,   -0.1096767912537685,
       -0.072673201382882427,   -0.051417555710135926,   0.017494537991533752,    0.053732990851020762,
       0.019560532837959114,    0.026407438331207768,    -0.0069441493986397256,  -0.1665404610003737,
       -0.076053146552734985,   0.17826224132582197,     0.045808877774672893,    0.0036371576290004076,
       0.15145515955938882,     -0.091442593626727145,   0.09113690518726808,     0.21482875279644234,
       0.054056234325342567,    0.035434515578330217,    0.16791577131785915,     0.17973897032341951,
       -0.047880437862932168,   -0.17101267977210025,    0.028422707291548669,    -0.033810852903579103,
       0.11882540383988825,     -0.025643553505815292,   -0.052270405422860627,   0.018902053289771261,
       0.012304273306565467,    0.17674839729168695,     -0.026244321440092429,   -0.0082142586412491652,
       -0.041479075578324413,   -0.11033575796296978,    -0.1213002658337855,     0.0055041001062650519,
       0.099220315308208171,    -0.069344384812197873,   -0.02099925064634646,    0.13214566622252918,
       0.011610533749607804,    -0.018643143263224818,   -0.047636859711000783,   -0.096152788001783146,
       -0.13246235817956648,    -0.054539510326007061,   0.025614039200375555,    0.056714374607836009,
       -0.068544542053821669,   -0.067211364696627751,   0.015686742701276846,    0.044411502170149546,
       -0.020156742742796805,   -0.06389853099019549,    0.035834901465075383,    -0.036272880271681497,
       -0.11438540099359994,    0.036732030920731851,    -0.1590508596152275,     0.073869803616040952,
       -0.051799350261347639,   0.014516701934423129,    -0.096717123503390484,   0.028915965597381906,
       0.088575696503141371,    -0.12863364161642424,    0.041026914726758748,    -0.068000991412925524,
       0.057302878584840358,    -0.10216820469241346,    0.032859392725544438,    0.15783138359652743,
       0.013460809675466383,    0.053175948102077764,    -0.080324120427730294,   0.24884450435363495,
       0.1720549890295664,      0.18699498905306283,     -0.10809577768829284,    -0.0038781866174045568,
       0.14917801347072043,     0.16294211257050625,     -0.15172712133797497,    -0.013352592987388123,
       0.18671892393962886,     -0.13697166642545006,    0.056108845268520086,    -0.12816481850831185,
       -0.0031741320409214673,  -0.041383917638243679,   -0.16035221917021125,    -0.12282354995518797,
       0.13782085420082502,     -0.1873536993975197,     0.045472217654485524,    0.091412936071831652,
       0.19280378232800799,     -0.048733953045254547,   0.0067507657257318172,   0.098330488957113008,
       -0.015198593982276312,   0.12338230278782593,     0.1573272063564555,      0.14096829898087351,
       0.094617860332182419,    0.015790081111838852,    0.14992555584300163,     0.062434138078085448,
       -0.0069182649586627745,  0.036269008854593832,    -0.059130388248723222,   -0.046097187015561883,
       0.041387632416331713,    -0.041333024862995831,   0.19822753179613664,     -0.018969647166278265,
       0.026746511957951837,    0.16318991042724343,     0.086052948923964756,    0.016763089066148543,
       0.066465735751486787,    -0.19345596482696067,    -0.076887902824636534,   0.16279261850746762,
       -0.010689145645188048,   0.050176613469240947,    -0.07519991743391663,    0.06817599502114767,
       0.034922042361035556,    -0.25689604008373407,    0.11430649907103421,     0.015567607659981835,
       -0.16860372623740078,    -0.026169252437208454,   -0.06479835692231127,    -0.0048316757469144787,
       -0.067584692129743398,   -0.1022198577433116,     -0.13370931568275596,    -0.0089924134643387232,
       0.17387710877351206,     0.067799275132324671,    -0.050212044384292429,   -0.12518017481645144,
       -0.087563011848308239,   -0.028343543070445825,   -0.025678861465225453,   -0.036060641315670647,
       0.0385138011098283,      0.0076526901168924976,   0.043624800776045344,    0.157660148846996,
       -0.09892027036754511,    0.040120737361200337,    -0.054903540459992607,   -0.18324709099834766,
       0.0065849589222620871,   0.023840771531794154,    0.10129937162169161,     -0.15453246449842789,
       0.16595659919685318,     -0.13896851096341373,    -0.018581253894474011,   0.06414118776554921,
       -0.07778130174187016,    -0.12770184714488311,    0.039206352070593399,    -0.17003042398196322,
       0.15462850771028355,     -0.074227076201816011,   0.10461923648816854,     0.035542868260166526,
       -0.14612132268473668,    -0.021927035769932237,   0.11187672835171483,     0.014016834381913599,
       -0.17895939089757634,    -0.17681513762928125,    0.063366635962250159,    0.14807499739380686,
       -0.0063359594373656007,  0.00042605289689008879,  0.087070589871158177,    -0.15331687057819543,
       0.072727738824424931,    0.0092996097687358323,   -0.15935907364445567,    -0.058367115476703292,
       0.010250182231462653,    0.064762643360740821,    0.031046130635635105,    0.013273860434217896,
       0.0073558587631816809,   -0.052564173298707426,   -0.10860233822930354,    0.081174956294065445,
       -0.093796618724060227,   -0.032793398507550767,   0.0031750839903942497,   0.15248018783478065,
       0.12570168319135497,     -0.057671080445658163,   -0.052380203658038429,   0.14518186301034955,
       -0.10820277767013985,    0.0053821934937216803,   -0.057847575924795828,   -0.099537497290946714,
       -0.0024094083565210714,  0.03304697044140463,     -0.032995047942019774,   0.15245400482555652,
       -0.17405776150271379,    0.015246728740460517,    0.072870083290559842,    -0.017226234428922262,
       0.15772306000573846,     -0.089861298040380122,   0.055433164325250028,    -0.04919464590733514,
       -0.1828051303375425,     -0.036727514451357898,   -0.082714862049831014,   -0.0699209033526344,
       0.14785934342709495,     0.14596265562398839,     -0.066686676296602368,   -0.042592326853149162,
       -0.044149451282897247,   0.015716810550656421,    0.11115634639708093,     -0.030428203763237308,
       -0.10428225712676197,    0.022899237744097155,    -0.077018838066406706,   0.023811804652434265,
       -0.11946238501858396,    -0.12464085906975567,    0.25255199940040951,     -0.016269439183158357,
       0.012031298317278848,    0.046873038768417585,    -0.0099850137999366994,  0.0076428934272982346,
       0.047109275168753711,    0.080219025208650416,    -0.24055328946998025,    0.10953494622763307,
       -0.056102584478449659,   -0.11377141657363816,    0.076752291503813741,    0.15595021306940154,
       -0.14587420064489942,    0.066691375691704413,    0.048768591258209038,    -0.064558553457273807,
       -0.020188841361944883,   0.10800426765379562,     -0.11504266305881831,    0.03547816014658832,
       -0.093779841248711623,   -0.028930035131550007,   0.045343700819932269,    0.16876052511019332,
       -0.077833040695608147,   -0.15909625859788323,    -0.016944229666705647,   -0.030380561750037279,
       -0.12908447562633166,    -0.22975119544556552,    0.094048422706710488,    -0.20675917884983661,
       0.081019890171456638,    -0.011326235227565661,   0.012912459173086466,    -0.097598718918419328,
       0.054898514872406656,    0.070981621624614702,    -0.084012906285572952,   -0.054855069596088823,
       -0.11703131597859548,    0.003885700395483025,    -0.035113557862338857,   0.0058916039773265327,
       -0.036570464736910779,   -0.0080939910608729335,  -0.067657643009121207,   0.05708215587833021,
       0.089704886665169209,    0.087808220417964752,    -0.19765991651770767,    0.10956072235641721,
       -0.16032355781684562,    0.020068664154796748,    -0.08330658835201854,    -0.19290824566949311,
       -0.018067817460368899,   -0.10798577873347688,    -0.19841856319931969,    0.14122574684780531,
       0.089038949983687832,    0.02632769090630167,     -0.061640091111606614,   0.043347852897308817,
       -0.087111799984002924,   -0.18217065477841474,    -0.038428362627056303,   0.17289056886044563,
       -0.039381329347813986,   -0.14451589361689832,    0.053420867977466903,    -0.06333252056502503,
       0.036358614007775188,    -0.045734072829402769,   -0.096496546493893651,   0.065572992632735874,
       0.052429538730786658,    0.0056020044778709319,   0.035345797192575405,    -0.0076370207836772702,
       -0.077622580833069887,   -0.0047203115927423244,  -0.03676288733004774,    0.17502557004384126,
       0.063080617369993666,    -0.024684442683449347,   -0.15230321094678567,    0.0058413045359845131,
       -0.14023300903390379,    -0.1138639616794357,     -0.05163171634503886,    0.1039886893159858,
       0.29761992726043707,     0.022324368601846351,    0.10274257853179816,     -0.013142865203628357,
       0.036413470382229265,    -0.1043949910481865,     -0.038409264615559421,   -0.036746462998981461,
       0.016813810659293001,    -0.14120578040391585,    0.17034768519385998,     0.082259899571853978,
       0.013632327526561811,    -0.14875615755694035,    0.035393881556774497,    0.082054586953932293,
       -0.13372959240344579,    -0.032373988741304899,   -0.12035241105848948,    0.13021618798472878,
       -0.051347680394060735,   0.12202553973294904,     -0.11433335104972087,    -0.073811692179256524,
       -0.1944160928771963,     0.052453116603832069,    0.057743712448993997,    0.075513525869558007,
       0.047159590680912411,    -0.0081933597396218992,  -0.15389935504783678,    0.02553511596841641,
       0.071823364622944266,    -0.09209074867957287,    0.11038229470273353,     -0.047249941172053403,
       0.004667381186253006,    0.20241299522605008,     0.12231461089233846,     0.071439189901432457,
       0.056285366490920842,    -0.10029175057183436,    -0.033001936577884271,   -0.11453033870631561,
       -0.10171469180658638,    0.13796681286486362,     0.1130821467763201,      -0.044080855688085632,
       0.026258345328658381,    -0.061954339881680469,   -0.16811000883639879,    -0.031993426778155976,
       0.19447865419165589,     -0.089429552656246969,   0.053102079668841798,    0.05258452037813062,
       -0.10168996110536194,    -0.18785420376332324,    -0.11577822326552413,    0.022907289962835666,
       -0.0052835733855243795,  0.043109720102616989,    -0.058013958324460851,   -0.07348546156597302,
       -0.0026748366569809504,  0.038228756071465572,    0.034689243304657724,    0.066649520844406313,
       0.2001873153922227,      -0.20047408507814865,    0.0021867496743246135,   0.019521734033290324,
       -0.049669378189618078,   -0.068688458900997312,   0.039310675872756863,    0.070816291132117043,
       -0.089301165254163845,   0.004763368163406596,    -0.0076196521099254179,  0.17376726358170336,
       -0.020768912279098325,   -0.052796834074794532,   -0.032577629385343997,   0.090590135962844473,
       0.026827329876006299,    -0.03257500776105824,    0.025709653468988753,    0.032487458931819889,
       -0.063967230895413368,   0.15903619990702322,     0.085066328577595177,    0.032424594060813272,
       0.02961397388405115,     -0.24028270527213777,    -0.11368446709242343,    -0.027213938293742385,
       -0.16702753822619262,    -0.029053000187693013,   0.19392445956242368,     -0.087321910211566309,
       0.013419100294234352,    -0.053842240479320617,   0.0069303744533680631,   0.15182768395913809,
       0.017816486241688557,    -0.049603698532969059,   -0.10347634103243772,    -0.038609248741115355,
       0.16073733580761768,     0.12112876070539325,     0.14518994492478357,     -0.071311351156814654,
       -0.11429221454333893,    0.078127451073515139,    -0.055924425252102977,   -0.028171003879237655,
       0.0022879446688878532,   -0.039841829927940504,   0.2425674939327831,      -0.045847697888643235,
       0.093529816891370965,    -0.079985450382307796,   -0.052491715834468169,   0.2248347475665175,
       0.10376532042265761,     -0.21456013685168493,    0.083265310595095371,    0.062015586231283899,
       0.10205257363342043,     -0.14963388556836621,    0.080452871473897708,    -0.12764289276800936,
       -0.056684015318034207,   -0.11653138060602199,    0.020462086919461147,    -0.013894521576022022,
       0.016960755866591754,    -0.10621362122139401,    -0.080704531253164652,   0.050443650660647904,
       -0.013331063353271234,   0.060035646604554516,    -0.28444169589263113,    -0.21201126323761826,
       0.040832915104042827,    -0.017045656618285165,   0.031384085146231741,    0.063733260035576639,
       -0.012102216457652772,   0.0033111386629809132,   0.0078380926775175538,   -0.15943952834028102,
       0.014737100028261771,    0.055007319115385575,    0.044950181262679689,    -0.01349441734993418,
       -0.12033629448179481,    -0.030578373329123498,   0.057029468314465682,    -0.12455775043791556,
       0.010191407690462589,    -0.15981831911723576,    0.070283433996528963,    -0.068917742659164435,
       -0.060512060061524771,   -0.061859921490076582,   -0.098054062771550515,   -0.024731004680732097,
       0.077484858645103627,    0.071145493512612595,    0.066608924266635131,    0.030640745060167663,
       -0.14597930979216381,    -0.31285952285534974,    -0.026098643036612166,   -0.0148177417239354,
       -0.11833006546463465,    0.094770584310485795,    -0.030785983790987577,   -0.11327930442363707,
       -0.073323434896458511,   -0.073498392511127775,   0.059062753794557506,    0.019820038397710522,
       -0.018450608397757855,   0.00022254413866371753,  -0.1117457641967128,     0.026673794985541396,
       0.040841365561126303,    -0.0079756720220816105,  -0.032918784795945573,   0.04688648656717824,
       -0.07939768947686543,    0.029536664030448467,    0.00083917019822299908,  -0.21066428835631579,
       -0.091442747605380043,   -0.15244781639709043,    0.014922361135228176,    0.16100787851406223,
       -0.039100976088755242,   0.1191472326729755,      -0.25035323060932879,    0.030501620911436815,
       -0.011138171928037082,   0.11533922232036165,     -0.075350779719662628,   0.016373711243517532,
       0.0076701539058564756,   -0.1128477891277716,     0.04598945034380747,     -0.047270733064817168,
       0.16196002831309261,     -0.088102430606885579,   0.081827755045076556,    -0.16521450426920942,
       -0.0021200646357247299,  -0.089690982967062724,   0.15483249626578993,     -0.10335809792371184,
       0.083014990603898733,    0.056354120316010649,    -0.093776263840151183,   -0.0022676896041762505,
       0.088890135244872312,    0.09235386115222087,     -0.22100805796743717,    -0.0098185347790791799,
       0.097627217621292187,    0.098007489962386896,    0.057634162847896332,    0.017411921085211196,
       0.10103949155286246,     0.023408438465186518,    0.085410749856285093,    -0.080100753997506852,
       -0.16712220523312196,    -0.024798803461802209,   0.18862107968234362,     -0.033541774620028733,
       0.043724236585936403,    0.086562324389984319,    -0.0055349349372147329,  0.12032613949070582,
       0.077271860753188495,    -0.15507808244883714,    -0.10992902886898465,    -0.036694304206089892,
       0.022087614985110596,    -0.074807193554396731,   -0.091216276994927931,   0.19336279143456431,
       -0.024782617782962854,   0.084329630408680939,    0.0042784299480101515,   -0.011585163309982893,
       -0.044160718443911971,   0.12010630511927303,     0.16005986905100619,     -0.080811609772489093,
       0.026154274095339273,    -0.23586949854710598,    -0.037678488353910126,   -0.099592641396906545,
       -0.01885192481670275,    -0.12085445581247209,    -0.24029021029257897,    0.091987276957574582,
       0.099547571683428815,    -0.094834954702698898,   0.064395339189317183,    0.12033675403455313,
       -0.029886333853248799,   0.17142665412648553,     -0.0030764475192568922,  0.089389162073763725,
       0.099552311821985387,    -0.10592649838732612,    -0.14050281079296886,    0.13739752096324301,
       -0.05175144632392973,    0.011569923539924039,    -0.066085639600091964,   0.14549328936381686,
       0.03890778588068957,     0.16814432950285776,     -0.092735370447251261,   -0.1797281020678019,
       0.25153068622102676,     -0.023391135028392074,   -0.073437405737836067,   -0.028536174706359971,
       -0.12668477751466145,    0.0098111809340286106,   -0.084925688245355485,   -0.089486834907013368,
       -0.22974023560708054,    -0.019812261424669728,   -0.018957911693851071,   0.0032839019261199066,
       0.019447327092650738,    0.085592662360207766,    -0.032314521085572569,   -0.13644381165940964,
       -0.0069758293428696773,  0.048085720891301933,    -0.0062385994944590953,  0.083542470495619886,
       0.050787954051221149,    -0.1280243154532085,     -0.21490986006967314,    0.15690665149156302,
       -0.051768552599241596,   0.16660390473211822,     -0.13235782266373286,    0.036590182411110998,
       -0.046290815439448942,   0.13296624366064799,     0.025930470948884416,    -0.04582523122637313,
       -0.075491703522918202,   -0.19322145036120839,    0.062235296353443,       -0.059386896663537948,
       -0.15309201920960136,    0.0031848880593702291,   -0.020805608553110248,   -0.0076164621049968342,
       0.027244129730537879,    -0.060067978044899675,   -0.097330685278902457,   -0.12855317776700448,
       0.12993969692544152,     0.13724843893662966,     -0.079584552098407035,   0.1073134092805204,
       -0.1114924361644813,     -0.13084050436048572,    0.037300265014923784,    0.053151689252469145,
       -0.17634827887352048,    -0.066650390029125026,   -0.08811794651730423,    0.096819177519001487,
       0.074562501293656547,    -0.037450592804267734,   -0.0080327752773171422,  0.064991927727810872,
       -0.031225930871923029,   0.095746204451316111,    -0.028281749759169993,   0.070229197650560821,
       0.062822992902821978,    0.10570666582082544,     -0.0091059138800281027,  -0.015632370337440679,
       -0.047668725747172611,   0.086839710208574478,    -0.12055643744786196,    -0.085716642256659384,
       0.04437061582594394,     0.015926143855317914,    0.060885378487079998,    0.077226705614021146,
       -0.0071945629170968471,  -0.052454721168236747,   0.092291457135758856,    -0.02050563028616708,
       -0.039858198620308309,   -0.012686639692059918,   0.10314076948021209,     0.057294660906910773,
       0.21979064869258816,     -0.012359573320566404,   -0.15900519604557922,    0.12962372413912429,
       -0.031420246568965582,   0.08207696493239465,     -0.095147207269715942,   -0.1418809573160375,
       0.025083167137351675,    0.031405459537303365,    -0.024814956338897146,   0.14926761181929193,
       0.047657891532141776,    0.038579323090815597,    0.078839526476400718,    -0.025370360138465522,
       0.0093304359112668985,   0.084675882833400634,    -0.018093726310307597,   0.22627322657706561,
       0.062170978727578471,    0.052421881096280348,    0.0012045835370644872,   -0.057253762932365115,
       0.021397942446837268,    0.13992616290296936,     0.016128050723295241,    0.027072757836209653,
       -0.036375849985520695,   0.082386279921542432,    0.14223979043024951,     0.3431159869204608,
       0.25517262556020981,     0.081566371112117272,    -0.071910745939276169,   0.1637416729657889,
       -0.13966216794945321,    -0.19570954995044951,    0.028261677532714805,    0.045386557835963195,
       0.077096708456391841,    0.094896979509767276,    -0.18090899059165055,    0.069797744755833585,
       -0.085177999688827957,   0.12294476590160247,     0.21650133417946421,     -0.058422049499494991,
       -0.002210732405208104,   0.0052370035645421583,   -0.014107301480573847,   -0.037092371768389767,
       0.00080987622796037449,  0.042528923794835354,    0.025182861106988617,    0.0064665749750184819,
       -0.013438831198551382,   0.010628056911045156,    -0.051213396827690931,   0.029905038270240533,
       -0.10382018794644023,    -0.050927242006453023,   -0.12107286555014642,    -0.12169020075959472,
       0.082065050683154506,    -0.081833322960318075,   -0.038749486066646716,   0.055863936196465562,
       0.058855397677698179,    0.14000030885923093,     0.072470342103175517,    0.033483661937802979,
       0.094165534322064537,    -0.088101384435158331,   0.11138163066281076,     0.041645116611933708,
       -0.1703279873295061,     0.074389337118223611,    -0.089025230813537512,   0.09059639145876644,
       -0.065366850107167751,   -0.028876831934638532,   -0.025770756751276575,   -0.056164199785124047,
       -0.13478689727861287,    -0.056871359158790616,   0.066392687220341862,    0.23101797645936037,
       -0.0032844414864454529,  0.10311001623575701,     -0.043377788409903591,   -0.065540341104646516,
       0.12749014205757139,     -0.039711344941337733,   -0.046393153140706037,   -0.04359240608101194,
       0.024357277642096341,    -0.16936416303637289,    -0.016653390036546447,   -0.13194810855918793,
       0.036566184905960045,    -0.1145296345485434,     0.17217557263070907,     0.10986484678632358,
       -0.18530167005322173,    -0.059224594924889407,   0.23192445168578774,     0.074305868363293448,
       0.048061290891027571,    0.0067083681774930508,   0.093633984498575934,    -0.00015440327976075542,
       0.0097186854464022827,   0.17183650018785357,     -0.0064935407611903459,  -0.028528392833462667,
       -0.044503912159615563,   0.064442788767832757,    0.043753197003779103,    0.0048006621064641073,
       -0.070553406737764252,   0.031577503027330193,    -0.09973529370683748,    0.0083095763680576008,
       0.061081066777445112,    0.036701369620975477,    0.12635161720195642,     0.098458578181749953,
       -0.0095710738230897815,  0.042586674142931907,    0.010641247276086284,    0.14442982033372384,
       -0.011050108118937016,   -0.019716797627093122,   0.091774156921849995,    0.064423552433483217,
       0.10960824185111127,     -0.022005522167823807,   -0.073528697169560453,   0.079529782427780402,
       -0.14576635340992466,    -0.05072166521585747,    -0.036831253433153958,   0.025021291344857172,
       0.11703269528893032,     0.014766526322856844,    0.18374791761887829,     -0.010480330217658403,
       -0.027503006796075976,   0.061625238028059526,    0.13196099971502967,     -0.087013776439108306,
       -0.12815619194791683,    0.16818310701435807,     -0.25399684093929292,    -0.075199459164786001,
       0.0074032298814392184,   -0.027875133330350091,   0.24200830106263796,     -0.014996280068479535,
       0.014145521961820753,    0.074295916315844854,    -0.12626279292297499,    0.14682401845303467,
       0.031112295931094616,    0.16070674212133251,     -0.26215231745998502,    -0.019592933776031964,
       0.13250235902122484,     -0.14503948478982462,    0.14644043732943343,     0.046485340151987395,
       0.067583437711333599,    0.11459684153089979,     0.12779588109952889,     -0.064099163908896473,
       -0.093005435762373481,   -0.049399034098123233,   0.020437144924790519,    0.019661694480966007,
       0.13964108161690644,     0.081995674339644734,    -0.074053425397352698,   0.16356073354683692,
       0.069164606440289225,    -0.012269510841915682,   0.041473895548882096,    -0.025014136458779736,
       0.011015593554881561,    -0.094510990169675624,   -0.092389421148795503,   0.094439709672275732,
       0.033922241560611237,    -0.2723199511394182,     0.069350158814188601,    -0.081127983220964109,
       0.24349760070578766,     -0.021655441192373923,   -0.036320463368534235,   0.048169787156634725,
       -0.048071919835374059,   -0.0059770719222504275,  -0.011224515939306075,   -0.082044235663038631,
       -0.064805058782544361,   0.020976795879579256,    -0.077146748797558465,   -0.090096215106509558,
       0.055964251033614985,    -0.079508425443679503,   -0.061382774893653201,   0.067914463597465377,
       0.143384624886915,       -0.11184308033994997,    -0.15148121097261905,    0.020802707618578234,
       -0.10396898766718256,    -0.080756323770028671,   -0.067777124040583489,   0.091801272283925428,
       -0.15101697580098628,    0.067705364364711959,    0.24753202266097141,     0.095517623430619633,
       0.10037622416235525,     0.054595759224521818,    -0.011719300263848183,   0.064127535622902423,
       0.12868142747898853,     0.074719971832898455,    0.0064545039426394009,   -0.029295317348339046,
       -0.04162401414048169,    0.13978519942716064,     -0.035270144921386859,   0.10947221271154978,
       0.10106888123016619,     0.018579048327668365,    -0.017030139581179233,   -0.16287110758405449,
       -0.070497642505817734,   0.061124491617881672,    -0.1249457272946526,     -0.017342234535905818,
       0.016907089637693922,    -0.041165934163262127,   0.013191128827380895,    -0.013480726302828394,
       0.034380339576512854,    0.11662318824311413,     -0.18724990581082659,    -0.042785381383979804,
       -0.020408796222565445,   -0.1139920501901775,     -0.042783835405221501,   0.064405935054217794,
       0.11491431960116477,     -0.079396765853593745,   0.027224582340540877,    0.087220782980829553,
       -0.071381478273936039,   0.099121286955714857,    0.00038595128429228214,  -0.013404002153471397,
       -0.037583892014237417,   -0.030179297682956019,   -0.12344446690500425,    -0.048339814424578284,
       -0.10092357010044202,    0.049740824550090136,    -0.072296018842010396,   0.0058372498242434748,
       0.032586803767515445,    0.17245637258113483,     0.08885958227872949,     -0.069378222847548021,
       0.14081485069014923,     -0.01396803439103181,    -0.10750753838578973,    -0.14161530788861923,
       0.129595764568911,       0.12892696492556802,     0.079464908827032374,    -0.08802460297839379,
       0.26103462863598209,     0.15163484916992653,     0.017401280695314596,    0.17662246136067589,
       0.15518545217553234,     0.16022744459180602,     0.061584150646227694,    0.098682806137771806,
       -0.17286295931730897,    0.067994873474338038,    0.0059016897277296594,   0.14161953151093473,
       0.054577921586960898,    0.16796342673728468,     -0.088409411759413789,   0.050080917491860534,
       0.13899136386318023,     0.16988900615067062,     -0.020893430235946454,   0.13381783157658564,
       -0.042143099220091372,   0.002114603880888982,    0.056517625586720542,    -0.027621385369543144,
       0.12351680704900736,     -0.092948353089639515,   0.097197047638272777,    0.071291546181295781,
       -0.16920506453670164,    -0.094665511872244465,   -0.046238981166529435,   0.16669951073025646,
       -0.052498002825263623,   -0.18608573126081412,    0.0021977964390734791,   0.07487828220271224,
       -0.0029350466894597035,  -0.060133955764304123,   0.069539835113531609,    0.067813089962785456,
       -0.23209674553436704,    0.062787428037490378,    0.0072694418714159964,   -0.048494773543667206,
       -0.099802357667415062,   -0.048256346733410588,   -0.021734797711467448,   0.010547626006609053,
       0.012241645274632288,    0.043976239664010708,    0.26873771570450755,     0.022800983862474512,
       0.20393498215638831,     -0.077444273237142786,   -0.085776370082797898,   0.15368318494903246,
       -0.046465521360676637,   -0.029839343930890518,   0.081702824759017356,    0.11898585900161968,
       -0.0082135728956487502,  0.056082145887179601,    -0.024329735158944904,   0.018397435636632174,
       0.08571091651243988,     -0.026689342173375558,   -0.13507415111687829,    0.076971029478181741,
       -0.14792110127876942,    -0.046598344123844677,   -0.10470275310812682,    -0.0071918102937671416,
       0.072371115939568312,    0.069125961218769891,    -0.10443245821871221,    0.0074333169153835647,
       -0.069699273078486973,   0.071890109767369481,    0.05523519119202433,     -0.076077664368069745,
       -0.051417794706348149,   -0.070478092173336615,   -0.059451338245751516,   0.013101982690071526,
       0.09722579758722634,     0.14179410166097658,     -0.035983866461375434,   -0.18560945314227531,
       0.07532950368000238,     -0.16107153081463729,    0.034953266725333491,    -0.15690328372458784,
       0.0075104175474390968,   -0.18105339354296657,    0.25989979485778131,     0.14649298130512184,
       0.057963547415497862,    -0.010565683834401294,   -0.0040256727572890744,  0.066746366006207827,
       0.097317267696004489,    -0.024411437033685625,   0.075995730790441807,    0.037012873843010059,
       0.08395170804448962,     -0.036502888092410833,   -0.10396252266452517,    0.087876239413164497,
       0.055662068424018746,    -0.090282778217078891,   0.094810020309923734,    0.068606614675238833,
       -0.038623700869145267,   0.079561499043489192,    -0.03867558061721902,    0.29560799955052014,
       0.055526305932758473,    -0.20845882831267576,    -0.063745499123633517,   0.10149539418140407,
       0.0096764913132391557,   -0.12688006411064134,    0.017933654198724551,    0.053265715862161049,
       -0.036914479364679793,   0.075015095229145803,    -0.020345234500906625,   0.097260934111389793,
       -0.046794429734134571,   -0.088739294021784113,   0.084900499143503297,    0.032567358764538562,
       0.18132965971071793,     0.08073808179645374,     -0.083405826934834976,   -0.039934590257760937,
       0.057136215054592453,    0.019794021131729355,    0.041974831405782939,    -0.038389528602060734,
       0.016819137225617568,    -0.014016409081281584,   0.02140604856017659,     -0.024069829923218898,
       -0.052918736365836806,   0.093938212175805849,    0.020878042718649487,    -0.048407779654843705,
       -0.10920172668582928,    0.13477506680733148,     0.060929417997608815,    -0.15440690325078221,
       -0.045677918487029449,   0.040848720851095095,    -0.007179737166774545,   0.006256727236333583,
       -0.029640765226099645,   0.12923992788108363,     -0.018081014601869193,   -0.24697319298544859,
       -0.13385211322268084,    -0.036838156578617366,   -0.036343142054288215,   -0.019449304333797587,
       -0.054754742314272534,   -0.17289768919223006,    -0.030174260368614161,   0.065595714172823866,
       -0.020877392055603534,   0.068524210548104897,    0.069191263535862427,    0.0057737574836501339,
       -0.05802542877127715,    -0.36946882040821949,    -0.081781231948677272,   0.13359047353967596,
       -0.013616462944637635,   0.10539957630740332,     0.048981824842049819,    0.011039046055803064,
       0.16730044659218224,     0.054190775649973773,    -0.12541474218392507,    -0.0062387741154336981,
       0.3492994462192906,      0.026791407828004526,    0.05884241360246624,     0.11007856793357984,
       0.10312188308446707,     0.061036863505244149,    -0.068860662850057569,   -0.04812809348062453,
       0.04052802258715614,     -0.059471482793896448,   -0.00048075543433778289, -0.039352376914388101,
       -0.031641158385016223,   -0.11620965186540762,    -0.078839975019556668,   -0.027066401989567217,
       0.11721196059508635,     -0.077056435002128013,   0.02339502086309813,     -0.10718387771023151,
       0.18581626700567896,     -0.058561955373853107,   -0.014720803663548179,   -0.0021030964923344948,
       0.05257980240974483,     0.09469616985454947,     -0.12971714223691017,    0.084639216272100498,
       0.0055052824655421693,   0.015699944229870776,    -0.014294648660969939,   0.095541654804710802,
       -0.032169897062645607,   0.048587249515654587,    0.046396343175597807,    -0.0590722173090691,
       -0.15387556983625456,    0.064239611630775684,    0.15515898839009301,     0.10222642218379649,
       0.032864853462433001,    -0.039686439931788768,   0.005892665853230305,    0.061421957022333967,
       0.0051910642563292968,   -0.078711463284276167,   0.061638116362587439,    -0.17091501743539933,
       -0.0293597167513894,     0.082013503363903104,    -0.11181906745047671,    0.060558974897310672,
       -0.026457835034045786,   -0.034938355341116972,   0.0022063669293204847,   -0.099759165929114282,
       -0.034909839312238594,   -0.0035920274940026671,  -0.1890607043958466,     -0.032095443494450079,
       -0.099055669417533965,   -0.11541005712943336,    0.15302543033371147,     -0.09979641320719658,
       0.035955965707673392,    -0.11222012612805458,    -0.11734578216580926,    -0.132522270610759,
       0.21630619457958117,     -0.038419347447762778,   0.0090566736867393055,   -0.24078282543611851,
       -0.12528544372560776,    -0.058128487480179625,   0.12974011050903794,     0.11565638494706676,
       -0.03066173078552703,    0.09452239162109663,     0.044846418042277292,    -0.14108026730772349,
       -0.21084738804222264,    0.050147726493634699,    -0.071182132936497958,   -0.12966691374960307,
       0.0034377843920107079,   0.020948100033255982,    0.14834912010532947,     -0.0286689447926269,
       -0.11702470556577678,    0.028962851858835886,    0.0015622763864650922,   0.055206323428837224,
       0.082002076744254526,    0.17864740523779582,     -0.13905146668194562,    -0.037845309680148945,
       0.015632726527341486,    0.097211638709961856,    0.061206833648732632,    -0.06695563717908351,
       0.15219724836441045,     0.11801736606811791,     -0.11835292210469511,    0.065713425940236755,
       0.21904837864913937,     0.0022817360394305182,   0.022573655807341619,    0.053100170873028818,
       -0.057874544832327068,   -0.06152479021059104,    -0.035731497042959859,   0.056282161917348909,
       -0.092376168067975273,   0.069013706560343738,    0.13028858473733193,     -0.14821932443643038,
       0.11383800498466649,     0.05742623037561613,     0.15444513164590307,     0.067419043639285442,
       -0.26214601741844851,    0.048357987222576337,    -0.037305597295614619,   0.011589392514827601,
       0.021780407266619541,    -0.068990511671866012,   0.11541020133018122,     -0.090504284972303797,
       -0.17447426644680278,    0.016805174700806055,    -0.14729839659153951,    0.047692408784137275,
       -0.11152559532363462,    0.06197517352114127,     -0.038967617141068694,   0.15650199439321313,
       0.14416383545957595,     0.046121914583450593,    -0.10430492160592611,    -0.16793903587077771,
       0.038118248828555461,    -0.068229403934251392,   0.13175257002861154,     0.051725674777199242,
       0.21044690102335561,     0.10927977443733917,     0.013000711375088979,    0.040984193669403597,
       -0.068281873684918309,   0.041586543062994315,    -0.072517076888838142,   -0.19835394406330584,
       0.050152320352771458,    -0.10418513712927244,    0.068457994723425189,    -0.13950214427399649,
       0.041582311333174735,    -0.15505047931624838,    -0.084913843743960563,   0.061957238500970326,
       -0.038995179636772084,   0.012424197159514764,    0.051887942515895222,    0.22922946750988457,
       0.027101998597609124,    0.039799808526324643,    -0.08592640265598063,    -0.15103432186236679,
       0.10069776914003899,     -0.024634743603935819,   0.049498126363004297,    -0.049023222162593569,
       -0.1403525060055075,     0.0047220883847858145,   0.055735692240450926,    0.070509534763718545,
       0.0029713850185213433,   0.14429439662166285,     -0.034727998145841273,   -0.12288447493713983,
       0.019971740218715214,    0.1300998921244477,      -0.12252365915587626,    0.10865057848289879,
       -0.012464247859343955,   0.20449653364632991,     -0.056432214953621058,   -0.026259893911419082,
       -0.019336511342536188,   -0.14387725151642841,    -0.2171152884277934,     -0.16042302799768013,
       -0.082999431905839721,   -0.13806103459701791,    -0.14426704004926177,    0.082817108453844004,
       -0.14752832191772555,    -0.085765855335620686,   -0.0063906929039879764,  -0.19112434622656574,
       -0.082965756644626562,   -0.10338632347671396,    -0.012795694351285435,   0.013169283515030647,
       0.0010875064634481603,   0.10328243809318449,     -0.067669491317615557,   0.058835273613008637,
       0.043027742297839441,    -0.07608174436128122,    0.134297650319916,       0.10933220229627813,
       0.081749834998535026,    0.00060450790688528107,  0.0081254818281275443,   0.080072330175636586,
       0.10536322847343921,     -0.090117023471085078,   -0.016878889277762207,   -0.095002722046340998,
       -0.055907204650292905,   -0.0026754447664360868,  0.11152173420341352,     0.00037347872444047896,
       -0.018415414873601817,   -0.08956015363063069,    -0.011135493351245149,   0.024831175829240798,
       -0.042926658769173134,   0.037448661355523917,    0.19847162929783546,     0.048952034666508354,
       -0.1661679584976061,     -0.17429092119473164,    -0.12512701422677833,    0.13064967547848269,
       -0.010139535960482799,   0.2173376544393309,      -0.01098498211485798,    -0.068248522477337301,
       -0.15445376247588286,    -0.098358194439397362,   -0.056198448983264974,   0.17402959224787215,
       -0.048937059019288097,   0.12950185585670851,     -0.071330715161754668,   -0.057773659270404544,
       0.012889233856587575,    -0.092093180639749,      0.034257536778494677,    0.044187248865006898,
       0.054803139414563246,    -0.073603157575610756,   -0.037563637177677925,   0.20494622816788205,
       0.067398829180100706,    -0.081032791068368248,   0.026909633708693505,    -0.13870727942819655,
       0.0030227167842316067,   0.002715305127314098,    0.17988298702955341,     -0.079968453988227509,
       0.0020455771933577472,   -0.10750183613788232,    -0.0024939528024923371,  0.1756069848705728,
       -0.11419844367106577,    -0.021152755205600521,   0.042625746118032187,    -0.091004490416829995,
       -0.016155741906980776,   0.044417453004988783,    0.18863515918988466,     -0.049910576067519474,
       -0.010216906374509897,   -0.12155891507018812,    0.028475059091173583,    0.11308612480558955,
       -0.024696525243416922,   0.027966246337151088,    0.012407766767983823,    0.080606599551236432,
       0.0018340381928247504,   -0.022560341309741674,   0.057619566559702837,    -0.0036821450858516135,
       0.042029629806071903,    -0.00017659522704790639, 0.10186721291431108,     -0.12595756242788289,
       0.15123464233039036,     0.033810936759400778,    -0.18165807970382727,    0.024137109634605969,
       0.030600046743145648,    -0.21550893932728513,    -0.10895242401293578,    0.0075604574315784722,
       0.13505250624688209,     -0.1186796415848798,     0.023869399068651934,    0.023020996212129927,
       -0.051971826102122316,   -0.052203935387245937,   0.094153342906023799,    -0.22779195327099691,
       0.12605049824550651,     0.058739174516029356,    0.22244388855142766,     0.11871669465349127,
       -0.085192187011742235,   -0.063279202772587848,   0.16636698610918682,     0.044803454850111904,
       0.1102225944187179,      0.055123686886101655,    -0.15231618080073056,    0.031596602498878759,
       -0.13371295890012361,    -0.0018442206160378845,  0.028310596221029664,    0.04356588556865737,
       -0.020129823726538071,   0.029107705196312131,    0.072550385525622749,    0.25934258066597915,
       -0.012218004672951813,   -0.12054823179763387,    -0.12273692959290818,    -0.22026778281989104,
       0.13978883934484027,     -0.21384824019411666,    0.010536687450911643,    0.07961930327149104,
       0.037206099353485816,    -0.034387931073913559,   0.088739501668726711,    0.076727832178770744,
       -0.020377177374672321,   -0.18539808272877664,    0.13395544408432317,     0.0077105070793697418,
       -0.11132499091622948,    0.09419809343164684,     -0.11082594942851395,    -0.07163175455383454,
       -0.01269205212309157,    0.12254616083788657,     -0.10431127516092462,    -0.01726742919435011,
       0.042865078253832976,    0.03187182802211997,     -0.055838397449464366,   -0.13168068507845235,
       0.13148967072392384,     0.045477637621311483,    0.061211964649392082,    -0.0034280023934594255,
       0.071260997253998107,    -0.052589396105833366,   0.0014185070113315818,   0.056376454514486085,
       -0.091993520816669408,   -0.066368831171369255,   -0.02985564215412434,    0.075396885177516887,
       0.027291898496165531,    0.044818266154487946,    -0.043628335804699978,   -0.0043685661970302454,
       0.1601498016961736,      -0.0082374377994008686,  -0.061760406573188126,   0.1316499465128359,
       0.040151169789446731,    0.036873508145640443,    -0.043986458468112485,   -0.021546458481535916,
       0.028597279167337661,    -0.12979218909952914,    -0.05042385324968128,    0.13561303759227711,
       -0.11165404427185817,    0.032478637805370782,    0.031284720130768016,    -0.084852635755199884,
       -0.050026780928156725,   0.12290400868133666,     -0.1282365942702583,     0.043150062903407248,
       -0.058038454584575752,   0.015298715732591896,    -0.26659088355849542,    -0.26473696442715228,
       -0.028147405784114125,   -0.021754090728075968,   0.18366420801921299,     0.025420942250654843,
       0.045141364641066037,    -0.061324957503462084,   -0.021969506600012657,   0.095847345478786469,
       -0.099543545356239549,   -0.024477082831882498,   -0.077609676671598266,   -0.056573875222897342,
       0.064691947135883707,    0.052636819027209632,    0.0099742634746110247,   -0.17057339179302158,
       -0.051996441762360013,   -0.026678921203006092,   0.11581607887228931,     -0.054412246020292938,
       0.16196710184172011,     0.14746472733913482,     0.041182099006496845,    -0.12078006867525981,
       0.23282580148857795,     0.13696162241987692,     0.054847318476537052,    0.016906655382243743,
       -0.035733671764656805,   0.12760220858765908,     -0.034581891151276162,   0.11241076749052911,
       0.18767540935381913,     -0.079457466982222918,   0.077029031112757509,    0.0072111879161277006,
       -0.0056075261743940286,  0.017543140784896979,    0.18948825524660909,     0.17851888948092778,
       -0.04686812781541607,    -0.038976835484766909,   0.070446365154596235,    -0.077555657964905503,
       0.13145425635677704,     -0.15612364713902399,    0.015535013640274873,    -0.036092753037303728,
       -0.051552642612916623,   -0.28221559748482372,    0.066926866459006626,    0.081083129660523431,
       0.078557684002498379,    0.035746489808544765,    -0.0051414077419037682,  -0.099602031216082132,
       -0.10441902514446467,    -0.04608818881668382,    0.047406962208799412,    -0.1090528040960623,
       0.18011384167230732,     -0.16505438516198259,    -0.12442685921959423,    0.088089075786243462,
       -0.079453465100419396,   0.05831179945355091,     0.18147317570800831,     0.057432413344923362,
       -0.011356972814132432,   -0.19117543579232463,    0.036092426860972922,    0.094255959009412041,
       -0.095680739479027249,   0.098713168433718274,    -0.036608215876275441,   0.057161792075350062,
       0.005121445636073526,    0.053127791539776439,    -0.049101512690643785,   -0.046937637378247909,
       -0.12592994557894835,    0.027492955644362362,    -0.1198574528277804,     0.047088478275903484,
       0.01533380650593584,     0.12670969072684549,     0.16039462761936099,     0.011331025747576454,
       0.14391716931388243,     -0.0023204673356250101,  -0.093831316114729044,   -0.020286155517512616,
       -0.047670881449109054,   -0.062938180641881072,   -0.072168720931702054,   0.032332814195767327,
       0.12527413754418318,     0.012999914716823574,    -0.13551216282136183,    0.060232571863982828,
       -0.018103577294203553,   -0.12161072837857891,    -0.11652763636919389,    0.16780106678042844,
       -0.036590059330899746,   0.17556663685395113,     0.076798269412700196,    -0.12170328878603673,
       -0.11372477275079976,    -0.16194528539291483,    -0.034727503322858413,   0.031074533834201321,
       0.059596495664061055,    -0.0059267661174322531,  -0.2332808962843676,     0.14552761701402356,
       0.11238449842195525,     0.038902977292669574,    -0.070536670551960931,   -0.054222365362211519,
       0.099709719457275553,    0.0081992973203722473,   -0.086153806406318492,   -0.0095538313029880344,
       -0.020798571067785394,   -0.032081488249125212,   0.14703485095512259,     -0.043994231064576977,
       -0.032138852843522026,   -0.046081498490301472,   -0.14846004487083653,    0.093926938601139071,
       -0.028040209927588853,   -0.020131433621956137,   -0.055064212867435007,   -0.12613220545312226,
       0.0088113130187824906,   -0.071256086711472946,   -0.021195350159885842,   -0.13748025449300058,
       0.043957401018544451,    0.097376079266846355,    0.083995145209275493,    -0.14915837182357683,
       0.13726498580719509,     0.023100537453036189,    0.10246506805846989,     -0.0037194700534178837,
       -0.05263604075147274,    0.127363736481509,       -0.16309443440663937,    -0.18940482487035151,
       -0.056698473517683971,   -0.045763472151848728,   0.050313363008501394,    0.0018293910600562895,
       0.040925827123773309,    -0.092479197262287871,   0.054802540826696777,    -0.019189159865050837,
       -0.081867852911803152,   -0.030585675803713151,   -0.10240624050300208,    -0.008831452288433142,
       0.040513056962735827,    -0.039281319511936585,   0.14707420576937502,     0.10656321818314388,
       -0.1621868035881221,     -0.006855883556839748,   -0.047083683240423724,   -0.057538117666477089,
       0.13338727865445221,     -0.044507685054621798,   -0.11169962248208018,    0.21497494726183292,
       0.048633636167306558,    0.22963065854850087,     -0.056871172579207853,   0.037322312444511049,
       0.034346468193659038,    -0.14821524473090175,    -0.15107897564107087,    0.065978350200235569,
       0.12983659963786021,     -0.033165681784061284,   -0.032825876228259762,   -0.11046563311766822,
       0.020920418763279928,    -0.15996706295989849,    0.00016721626170870287,  0.11367343335121191,
       0.018742038570803206,    -0.15628094122339975,    0.19024931971632617,     0.091922247934248594,
       -0.1188443360226682,     -0.060298995501302369,   0.028067222555048309,    -0.057533414787525494,
       0.10142092665640809,     0.04876555018381705,     0.0093354336590805009,   -0.065328036646234364,
       0.03648108825301815,     0.073954808062155375,    0.10160051558905592,     0.14231398450855506,
       0.023915615254765175,    -0.003594045826073854,   -0.049796750329440351,   0.12552162598581634,
       -0.055301521693523106,   0.035695249359777269,    0.080148680768543479,    0.08907853749152557,
       0.015557698236158372,    -0.00066594729094435548, 0.065474721636706756,    -0.12316364367710658,
       0.041413101704572193,    -0.15354897040872456,    -0.052613434079666482,   0.13169707486028345,
       -0.065807641749452861,   -0.23597385078107283,    0.28995676109570839,     -0.10246893995673884,
       -0.17832028606592432,    0.15748576290596267,     -0.053241532822062836,   -0.030325663023423585,
       -0.13778171990314964,    0.078138570938601437,    -0.0034274520851560308,  -0.034535653038811523,
       0.054394683076886469,    0.042735896392260879,    0.097002723566707597,    0.011722639359216006,
       -0.13247687991208867,    -0.1389563463771176,     -0.22641565861934831,    0.025293973572581917,
       -0.028732298628189733,   0.061223666138463202,    -0.077551228509308651,   0.02407228682193812,
       0.099797229062659379,    0.06162391318368958,     0.017959319952715373,    -0.066336838567738907,
       0.032659681557162992,    -0.024549411183282313,   0.0027540975316480286,   0.15880892751460493,
       -0.034453282395172272,   -0.27294991086831366,    0.11664612417771429,     -0.26978403797680511,
       -0.031739163450510061,   -0.0017920345882607221,  -0.013392977411816519,   0.19803145309040168,
       -0.11192519889194597,    0.030121646236658021,    0.052333678625930774,    -0.020509458567712788,
       -0.0063610219828439587,  0.12671970253488396,     -0.0088132808360322622,  -0.054160067191370516,
       -0.030744836731935267,   0.12475480489846666,     -0.032009794294233167,   -0.017664568418835666,
       -0.05893335414525222,    0.18225546791912117,     0.072491900526637648,    0.033754430234096695,
       0.1984674004058791,      0.067648807700733005,    0.048232677615735575,    0.20707104199708473,
       -0.042061259412018409,   0.013719919329737592,    0.010892151204573822,    -0.026989833070451046,
       -0.058637217404385704,   0.070904947871549717,    -0.099912284363480625,   0.017182137800014506,
       0.037155940286859236,    -0.032657758251555036,   0.19132556474670434,     0.1151871600027175,
       0.18415131921804281,     -0.17401328594874296,    0.017817009332161876,    -0.083211299495187574,
       -0.1365194049241498,     0.0092807572707609594,   -0.014928949385797679,   0.027878365886604584,
       0.060284247411054294,    0.070492445613018886,    0.0094134900244277203,   -0.012656782729204945,
       -0.090562062701345564,   -0.0050744282037442339,  -0.012146707229432254,   -0.23698262723313429,
       0.094105790930962219,    0.062340572761367584,    -0.030618381150460418,   -0.18956059003755588,
       -0.10285087789765002,    -0.062637045447208314,   0.097072814556014367,    -0.01893679621036809,
       0.042898073318152458,    -0.15220186429334548,    0.0050378540470885037,   -0.013704895162193111,
       -0.027898271820718284,   0.15272334152018754,     0.019599234142383001,    0.058369856655611355,
       0.02879182040464481,     0.053524121086809442,    -0.01391769076937927,    0.096883658001270412,
       0.017737145152151725,    0.071393742173916822,    -0.16668391327377505,    -0.11369331705488506,
       -0.0025098142658233555,  -0.10725897031139515,    0.014581310510703886,    0.19933746340579422,
       0.018229973717188958,    0.062833815106530577,    0.060296753523262588,    -0.097775557031956728,
       -0.022143959524507911,   -0.0063433876610696112,  0.079693302101726218,    -0.16040600873378794,
       0.15809969454308281,     -0.18313316893721804,    0.0023956411751258387,   0.10790671684029787,
       0.083922342994004528,    -0.0028712309079769373,  0.15700605043847543,     -0.08179472725777448,
       0.08045462057600318,     0.078172005773084918,    -0.018060461415163459,   0.24266278414859824,
       -0.14347326231853688,    -0.14917326852337251,    -0.044312326356136897,   -0.12481029561813581,
       0.080844803375502886,    0.076219453805966175,    -0.087918251957732799,   0.20355750755928426,
       -0.10884895611869343,    0.094674285591630561,    -0.15104435389912543,    0.11677273835435115,
       0.065975701588024627,    0.072922121299214104,    -0.10516134620265027,    -0.012263640148312317,
       -0.18126651669288435,    0.048374328843101312,    -0.12188658507298102,    0.011901240087498825,
       -0.010160571567360636,   -0.021904985721700469,   0.026038657198011468,    -0.04528076374037495,
       -0.021361881785941318,   -0.1457158874878591,     -0.04155241051371468,    -0.236235286650197,
       0.10526725978731802,     0.043507251666802971,    -0.071699257563868649,   -0.095399935704686925,
       -0.069775306495261549,   0.034402521307470922,    0.074346762427886084,    0.026687668487641102,
       0.22130618650563508,     0.076834873978173471,    0.089390272035523091,    -0.031163789928746639,
       -0.055515425998418272,   -0.064581618197142782,   0.078617133252065596,    0.057337677495051989,
       0.017130388200063334,    -0.075931234446851181,   0.0085500244625591627,   -0.061854376720970591,
       0.20257979549431687,     0.013840872772735404,    -0.061583368973294084,   -0.04140634987023397,
       0.076368692942204136,    0.059846459630943906,    0.032807314703653549,    -0.045657169087316554,
       -0.14590482207877339,    -0.07670879280084833,    0.053522038557761373,    -0.039248678361615025,
       -0.12405805356259465,    -0.11694645312655398,    0.027939522723216818,    0.012631843089663169,
       -0.043833401641059179,   0.24582821609583788,     0.075130285296660576,    0.083692021294299909,
       0.29856307699845636,     0.0072785711479207583,   -0.11217380169585818,    -0.028450342456486297,
       0.12108943624539084,     -0.074950776865991553,   -0.08958980011624422,    0.025191093564159141,
       0.07314025172634403,     -0.012053448378337602,   0.23322143550523516,     -0.047493452900206727,
       0.054763418083342945,    0.0091157335315895892,   -0.091035956398282797,   -0.047020919443013294,
       -0.083357092096431606,   -0.1181430585890106,     -0.13228366861420984,    -0.07700938746926414,
       -0.12678630743215688,    -0.072116895691189259,   -0.12330615276088221,    -0.069993691632491736,
       0.14631747189487343,     -0.069831900025923543,   0.092203733703551047,    0.02628078062465149,
       0.11623275877550379,     -0.076829275955863613,   0.038958711942841749,    0.12777127297838065,
       -0.0093791248067246601,  -0.10791912498106168,    -0.027644358095630487,   0.23195679088533505,
       0.015372103745960493,    -0.014503136638254869,   -0.094078473413001046,   0.1062578655487188,
       0.088213904388842607,    0.036590563882490906,    0.062440145674046245,    -0.069463544248409365,
       -0.067372575061916407,   -0.051104110438794176,   -0.073249639076437362,   -0.028649204101401253,
       0.22551293488483828,     -0.01236381649542297,    -0.025280975265502999,   0.037522964970422554,
       0.16442590649490149,     -0.077177229777412495,   0.14084535449736907,     -0.10478084774323121,
       -0.050810930928758533,   0.0015734482019940758,   0.062028511148172802,    0.10386980071019647,
       -0.10016869921045521,    0.0073763703654353974,   0.014745216673054378,    -0.0063219494982374143,
       -0.18918774261849955,    -0.027221860783999491,   -0.064658107956281505,   -0.012832116478405356,
       -0.18275032747385392,    -0.12680394885060592,    0.054385798075811211,    0.17006571093323022,
       0.084395437443732055,    -0.060141977299772442,   0.085848401174652672,    -0.029888432544430396,
       -0.0089360660824395755,  0.058962364388480813,    -0.016496779435542681,   -0.013324606565125957,
       0.13584696576943628,     -0.062656137411543605,   0.12758861548541503,     -0.075148316105947299,
       0.057010732405373576,    -0.072515177754696167,   0.048494995063462359,    0.0013791205496440535,
       0.052181132319212911,    -0.22794689412474639,    0.11468462507343889,     -0.18514088438344531,
       0.12588078812495435,     -0.056475075053345189,   -0.09289500052703821,    -0.079247246697646892,
       -0.15122263644603826,    0.044848584317727577,    -0.067226581540689598,   0.077000452850803452,
       0.029700623523076418,    0.086992194875090662,    -0.15183418624134282,    -0.16184508918591936,
       0.02140719154612436,     -0.11749609419723157,    -0.02715126620462361,    -0.095716809480429044,
       0.096697493220737438,    0.10358127900959646,     -0.044625449686797401,   0.013944905622405256,
       -0.084644902297364433,   0.10887628410078277,     -0.10107146713813196,    -0.11116286256424718,
       -0.17376650903249893,    0.067058815745649356,    0.024231702148754076,    -0.12542412555397095,
       0.037320143031168297,    -0.028343387743311022,   0.060584344382446483,    0.17081737434212624,
       -0.01606127439534458,    -0.055059361281533145,   -0.13889291076255658,    0.091499494298905748,
       -0.12504197476544066,    -0.17063468184219457,    -0.053620309900438284,   0.087418077383623019,
       -0.062084087295631925,   -0.11468009072702338,    0.095536512331988122,    -0.024741571599046611,
       0.096302068014833,       0.15219674678213885,     0.1047286852035036,      -0.14983092984131025,
       0.135044602817634,       -0.23389497691861938,    0.0061737288122490084,   0.042955004140660814,
       -0.011784308212800042,   -0.073467595365035929,   -0.063783458304093169,   0.13823806599374688,
       -0.034158470303220619,   0.073504258286401752,    0.069535279334586086,    -0.12613951129602041,
       -0.086417611859533769,   0.098025947588991871,    0.12666759898648852,     0.0058110474198956718,
       0.048868704578832294,    -0.11994547480664275,    0.19865960248546427,     0.083085924491646798,
       0.098430398177069736,    -0.041725304304798018,   -0.033239763548428634,   -0.10375563071180928,
       0.044468321550614726,    -0.00096251022882337103, -0.053226161188722636,   0.0083993603075594343,
       -0.13376390094167984,    0.067255041865572102,    -0.010300491188832197,   -0.098008528895671562,
       0.0036210058838168158,   -0.0044863831921143366,  0.27270410667493672,     -0.09131188933085449,
       0.13523463632827493,     -0.050811476081918709,   0.073824702220796082,    0.0085648998435927295,
       0.052056914728694337,    0.24781237139508747,     -0.11027618848320254,    0.030418219893226368,
       0.071474213081981749,    -0.1087938191081381,     0.011029722463015005,    -0.083322107872939255,
       0.021842005118440005,    0.049379088257618456,    -0.047652198400304636,   0.017885833357166231,
       0.22317069094515968,     -0.072141113320057598,   0.12485231227096354,     0.090117638232325659,
       -0.00412258392334374,    0.011415530313329141,    0.0668174063576846,      -0.052483928136466691,
       0.15548890457370571,     0.029003481216709932,    0.029679165773537602,    0.070889657485104396,
       0.093453875027112179,    -0.15478112602973446,    -0.002091477154205473,   -0.024484750024790204,
       0.073523892342028996,    -0.0026951533209566766,  -0.15063043782370281,    0.093980172081016763,
       -0.067574516413470606,   -0.060694008816667012,   0.01817584766040067,     -0.019041279786920814,
       0.074290416283101582,    -0.021496042601644963,   -0.013148933378553794,   0.024280383433500287,
       0.044806040628073807,    0.075782225925152297,    -0.041399626199139603,   0.10021536920023076,
       0.088834709607117923,    -0.1080822207731562,     0.076895326307627215,    0.01184991497621728,
       -0.03959260642125801,    0.053341425652801568,    0.11191972781039178,     0.093514051752549857,
       0.09867046873670135,     -0.018362315375869041,   0.14640661732143645,     -0.027281643704760224,
       -0.14067644642501012,    0.0064270311607199787,   0.053998399823909492,    -0.063354677517956148,
       0.111535009463913,       0.017036093749376317,    0.16371344709033583,     -0.15773647877532404,
       -0.034566666348919459,   0.085486989496713184,    0.077434877362134141,    -0.0075456593611448273,
       0.24168950060389141,     0.21377522915039243,     0.10435572019887636,     0.165725955110129,
       0.18294530070582835,     0.057986840311048699,    -0.081619014608917184,   -0.032593300946411732,
       -0.12000717544094971,    0.029395100735031529,    -0.1611722656116501,     -0.19613283722873076,
       0.22658975463460021,     0.044039408746578294,    -0.012993325765406542,   0.28465734229673195,
       0.14398474866151978,     0.00084206893602467667,  -0.043224127485021524,   -0.14928393584154101,
       0.091262746384938365,    -0.014790044170348956,   -0.014564717349452251,   0.030424846393532646,
       0.045466145466078231,    0.020551004937208926,    0.13542357906481275,     0.11014625629813715,
       0.10084852191383954,     -0.19175345398222174,    -0.083607758927066692,   -0.025172500562536792,
       0.10348966818112607,     -0.00095479549514328969, -0.23205982139704753,    -0.037674044767073429,
       -0.14097983954972618,    0.065496294294013491,    -0.060978158468677782,   0.0025943369832849787,
       0.13956071185985539,     0.0031322324248863349,   -0.0071655770986799473,  0.064981366439186741,
       0.017489276703455896,    -0.0083669335004999332,  0.098591410648955172,    0.0042505658780661697,
       -0.038101178888917828,   -0.011805445424834485,   0.028627849848779658,    0.029815432068811591,
       0.054347041667786165,    -0.043966180023446211,   0.093985654582950773,    0.17782644099411218,
       -0.18871381549147792,    -0.039158592482742942,   0.045960832334187927,    -0.0096190039065740425,
       0.031677037984367426,    -0.056562532373393072,   0.13821732247824037,     -0.059980543197747517,
       -0.15408863997088951,    0.15649843581196507,     0.14978699024356654,     -0.0141056905957602,
       -0.053545619057839743,   0.38913325346915023,     0.058309933719806001,    0.15220707836556349,
       0.13790723393136381,     -0.1299706413349466,     -0.076846959753731056,   0.014478275418007534,
       0.095541433408267651,    0.056629831997962635,    -0.07642769213852478,    0.028217490352749855,
       -0.050855138715479649,   -0.086294654488021219,   0.014164107799798414,    0.171950422158064,
       0.05465572549335633,     -0.1130652040258863,     0.069225242734953951,    0.034344720916317011,
       -0.042960010605540493,   -0.080568170423383309,   0.020299829135505352,    -0.13762642210064785,
       0.040442018241598938,    0.19911159655191837,     -0.066788666188960094,   -0.13343309641638013,
       -0.14161769863673676,    0.048067933843439145,    -0.064627989690857091,   -0.010409160044765699,
       0.081187302510179235,    -0.060610383994071051,   -0.040962519771140883,   0.24519249308118957,
       -0.13956179761841678,    0.067871196251384658,    -0.055345588314418798,   0.020591685001128273,
       0.031421309152445419,    -0.079107779053237973,   0.049264021805570872,    0.080693770300698686,
       -0.032654120612106173,   0.071342766826486853,    -0.1134616662525605,     -0.020294501759973223,
       0.042051743561193004,    -0.029945222427637537,   0.076450462380277001,    -0.13928711726962989,
       -0.024337680857479289,   -0.038533147571805121,   0.047910300415745857,    -0.13736930691183394,
       -0.13659898810575452,    0.00074531873403418849,  0.022769086861690987,    0.13109337080995287,
       -0.072889267767306462,   0.029092716010847765,    -0.008614034477478218,   -0.093221319927053431,
       0.021124326539704412,    0.078688800200973866,    0.12080537675470583,     0.019755487201871626,
       -0.06623384191573467,    -0.26152090472648931,    -0.0057030129565848985,  0.06901596488887457,
       0.01610161875236274,     0.019352002466465408,    0.044807962608690549,    -0.10266673939648532,
       -0.0033892129731310544,  0.094251620079470036,    -0.15254544202306633,    0.0092312063005182739,
       0.04150200686679633,     -0.026668121683530836,   0.10085826942856828,     -0.036170337194836359,
       0.029128921153304864,    -0.13092299929072385,    0.043680071916669248,    -0.083863181265746184,
       -0.011189750518032686,   -0.087251030623579487,   -0.16732213301211563,    0.092152568142148797,
       -0.034617741501966982,   -0.04655514450861431,    0.18254103588469939,     0.15545622447112559,
       0.0075374236336765979,   0.017924347213452377,    0.20269464746867835,     0.0015615620957230459,
       -0.17765353455004587,    0.083351050163554583,    -0.15669907181802264,    -0.042775408682247142,
       0.079120540303433864,    -0.014192994701999253,   0.059315104351407855,    0.16186375568262981,
       -0.041810384805884657,   -0.07817657608661624,    0.048129112127256832,    -0.12846928347541772,
       0.096105519470624942,    -0.049200404094898287,   0.026678948579382612,    -0.14815257034965149,
       -0.020762940973833854,   0.08750541289611409,     0.046987555783247099,    0.11901388783515303,
       -0.096599873167098962,   0.12844899081216524,     -0.068911474457279284,   -0.059759019939675029,
       0.011310885824839155,    0.079408830529329982,    -0.061074069720687685,   -0.0002327645473166113,
       -0.00050420498718121629, -0.26335505603237425,    -0.12713609840657186,    0.15401291690855054,
       -0.095461596625331879,   0.084875768863223594,    0.11527296220082173,     0.0018602278747207712,
       0.069844736241004332,    -0.0137608548765991,     -0.11551200974247659,    0.11396254088766214,
       -0.13816008108168912,    0.14138862617675313,     -0.13606441131706179,    0.12750786627824684,
       0.043877050788126072,    -0.11916441871158354,    0.075726387412263327,    -0.20015347573368064,
       0.051666378428706819,    0.22767731534268967,     0.039953993718538916,    0.11632570605100481,
       -0.0065271330929028443,  -0.070002175039778444,   0.00099689241852731511,  -0.094291526686588217,
       0.23419803292057081,     -0.056096589941993846,   -0.022358642258858346,   0.11967710959623142,
       0.048712714915805699,    -0.046771988390150565,   -0.1953945396451712,     0.036998983604760075,
       -0.032800025952964905,   -0.01534561516923174,    -0.025977373017121497,   0.11654707444053169,
       -0.12940370080971667,    0.056752154261933925,    -0.0017207216425985195,  0.040425048731854853,
       -0.052850248511613969,   -0.0031004916946536154,  0.002341868345733271,    0.023293812696956514,
       0.032971984896975573,    0.11931989343027397,     -0.053858281389899829,   0.054677752099543162,
       -0.047137630015014829,   0.010041850904480551,    0.14936949654370207,     0.053780338963650226,
       0.0081792575440035719,   -0.11752163306775974,    0.16904991284844695,     -0.039129019954504352,
       -0.036727953466371949,   -0.047114261293210974,   -0.068399418502250911,   -0.080370171547124045,
       -0.051774417015252455,   0.064557365443997983,    -0.050873356998906709,   0.065123856259171858,
       -0.084495311406173806,   -0.10168635244441561,    0.15709802342367621,     -0.02681986002179116,
       0.024748648061886744,    -0.21416215737509392,    -0.073052777064643401,   0.047660104871524028,
       0.093514594902723749,    -0.14833683425768118,    0.067730029439334705,    -0.11257190470543799,
       0.11881050495073732,     -0.10557898722914544,    0.0098599969151990548,   0.044696912788131413,
       0.086606441091073197,    0.10389678603853321,     -0.037008604629666403,   -0.056175267208982652,
       -0.062572803100778507,   0.025480996039183107,    0.1025120392652815,      0.085216949675391646,
       -0.23594454465464609,    -0.11245992122751775,    -0.17809342019058241,    -0.092437386360475854,
       0.079877739479442017,    -0.020574388838332472,   0.085183825408256836,    -0.087927897721095188,
       0.095042744182466055,    0.1052453536280927,      -0.0091023069350264704,  0.048791178544131682,
       0.12640360570718381,     0.023595337268417428,    0.0148639775835194,      -0.022868552163734894,
       -0.15548068528525683,    -0.067979728760803174,   0.23032073597570718,     0.074767720303011598,
       0.056775071329123246,    0.054633079718658155,    0.180261427976496,       0.049738063468544771,
       0.039730435124503895,    -0.026504625443485572,   -0.0081498439480767772,  -0.013958396181185943,
       0.050203035810782934,    -0.14610173383451666,    -0.1389584968781335,     0.051007527025922442,
       0.037526397241901759,    0.13571581887716716,     0.0086132911695363818,   -0.12332264549664362,
       0.015535423162950712,    0.16642193909233341,     0.066661176817272655,    -0.015119229155116948,
       -0.16745060810442314,    -0.051813519245126047,   0.068389618681828718,    0.057817034268738299,
       -0.1080506146870396,     0.14181059459223783,     0.14927519174034237,     -0.034339682565990771,
       0.087338250255966393,    0.13012324801922615,     0.10973738517222908,     0.14579538017895674,
       -0.085433517254781058,   0.033447059288486437,    0.19999324862249721,     0.042639075767084471,
       -0.095227861643333647,   -0.10709583310967788,    0.052413086776383906,    0.086980783517068963,
       -0.080272127117787612,   0.043231408968934154,    0.23012980460294805,     0.03262960084142081,
       -0.076339226813946462,   -0.057781418833836459,   0.1845228337168115,      -0.0020379435514701217,
       0.073316895052838588,    -0.089824570439190024,   0.14596538685004426,     0.014059633234764949,
       -0.13682791566927363,    0.019182417622315324,    -0.022611310642353642,   -0.12496588095036468,
       -0.059260014110198204,   0.099968803635561765,    0.029707739247888949,    0.070321762778745592,
       0.15255024350911384,     -0.00099423415955233237, -0.0077628026728375288,  -0.25080716706078543,
       0.22352990100622486,     -0.020932148546472584,   0.052918600844272939,    0.010818729122924487,
       0.10972779341975467,     0.17893722918178806,     0.028285889450030348,    0.036584225158295021,
       -0.11610315887613423,    0.060019302729377541,    -0.021602791555591534,   0.096320141956405425,
       -0.17156428034864768,    -0.093040372711980693,   0.00040402654212002599,  -0.10949095715859027,
       -0.11832306994900881,    0.10005834237143667,     0.075997543064763251,    0.15603739414066056,
       -0.15400052028466421,    -0.10049187777302299,    0.035905342817288778,    -0.12101122883092406,
       -0.11174450534009156,    -0.16944837414158642,    -0.15095070206881434,    0.11321161346602587,
       0.0028629664160799576,   -0.12504219159778257,    0.072618572766862219,    -0.047221212603837028,
       -0.045120025249415573,   0.15447092437875662,     0.016872351588604305,    -0.00035404102465991932,
       -0.014934169925437432,   0.0117288665821694,      -0.056286209065595581,   0.14252782955453888,
       -0.034201147800459922,   0.034084934127053462,    0.044779083720446158,    0.10095724443799087,
       0.010848711398495518,    0.011786267056696262,    0.021150446574507493,    0.039025088046993374,
       0.044871937695532639,    -0.072266718742925673,   -0.00096355558072756418, 0.004198852854875367,
       0.11814450157725756,     0.070067696942960708,    0.072789812721618455,    0.015310247451193961,
       -0.097635535224419506,   0.15355546819352744,     0.027471765991745764,    0.18426922131455503,
       -0.044416814777432326,   -0.086518927424468733,   -0.10225012367710705,    -0.20446599915740474,
       -0.12488945678613346,    0.023320450657494239,    0.061782120526986867,    -0.12972345350517578,
       0.15485964853857651,     -0.0010447517843937748,  0.27799287022655683,     0.022403552174647359,
       0.076016903550665857,    -0.047986285408477547,   -0.0630022719989147,     -0.0091941192723078366,
       0.027851490523382524,    0.013330935577356824,    -0.11565951396361152,    0.088288716115258167,
       0.026106546323781721,    0.028159138489033883,    -0.068486492473080529,   0.044024536471374776,
       -0.12500163604766254,    0.089642033049216641,    -0.22315300297195162,    0.059363932362107602,
       0.14203026762229459,     -0.19218615430641559,    -0.0078949587020310519,  -0.024121401760270236,
       0.045461955220913536,    0.17985481444898274,     -0.23602953825962986,    0.08799621243150188,
       0.079076589682443021,    0.10296376193188263,     0.063163659203165426,    -0.11464777706319609,
       -0.0046942911268225262,  -0.0010994266377155823,  -0.016576507253555361,   -0.086043552541130525,
       -0.12204621706115916,    0.11419067869570064,     0.12659269176713892,     0.025092379578130167,
       0.016611326535737207,    -0.087687470585840296,   -0.1214461209306415,     0.025774489444458315,
       0.025576740426405564,    -0.024378354834009061,   0.063478586400850592,    0.076750352490871906,
       -0.10466004749500016,    -0.033198571232208353,   0.084513570566454116,    -0.030358421906049576,
       -0.059029741781372429,   0.082253998941327802,    0.1234284262759488,      -0.052783676372936517,
       0.042076968541999257,    -0.16904842317164459,    -0.09120839844800116,    -0.14499531788965112,
       0.0029380834584528202,   0.090896195447640327,    -0.047429773362175014,   0.018618720868522336,
       -0.11442016795010079,    -0.10199637101986116,    0.13775519352262272,     -0.010631941126691746,
       -0.083454727475974474,   -0.1242454144728099,     0.0222253976007841,      -0.017437998098522714,
       0.085993633082662183,    0.076695642886783946,    -0.0034149306860402628,  0.12480257504337161,
       0.11492310368828546,     0.22585671579396377,     -0.098796256613007769,   0.031228612155259374,
       0.048218291961764803,    0.19766748764464748,     0.06210121230703626,     0.067491032606327994,
       0.17648720972763715,     -0.054047518670858566,   -0.1168830967142625,     0.013344376595921503,
       -0.072792440048986204,   0.10625831901019459,     0.012217794667932625,    -0.10287500100787345,
       -0.27293239657829133,    0.11733597040210794,     -0.017948905969306421,   0.059723122014550739,
       0.13672856804916811,     0.08385943412673158,     -0.039558454475118895,   0.12524126061758956,
       0.21416993150599298,     0.074411173807704067,    0.053292057327481532,    0.071739897837392999,
       0.047239478545963297,    0.0051514909171927244,   0.06276037887514424,     -0.10754268724169891,
       -0.076752353780872848,   0.074773236877068397,    0.021296388059847859,    -0.025673328423411568,
       -0.019327687038975961,   -0.025865023057809335,   -0.031396273336234806,   0.048621037350292884,
       0.059421070446529001,    -0.084261941625403639,   -0.10080391392887107,    -0.0027762464824519456,
       -0.096613704968066372,   0.090931320145344552,    -0.046575151292272188,   -0.2022746902085078,
       0.040528680805757424,    0.059417115195802485,    0.025300124884987847,    -0.027814696318015447,
       0.13965416771283093,     -0.077445398036930707,   -0.001506568076541444,   0.078977636744571506,
       0.085958585487491052,    -0.089076830701718346,   -0.107221910327274,      0.053289143144982898,
       0.022477836443990446,    0.14338701011285035,     -0.045180868089440461,   0.016742653255098137,
       0.076001382049944277,    -0.093189279940217321,   -0.12624860202003438,    0.041738888056115975,
       0.0341591539213505,      0.056973628369465137,    0.25517654866035511,     0.097275862985057679,
       0.034843551124100702,    0.030876242173574816,    0.023293105085625813,    -0.10675399416969353,
       -0.021949721953649522,   0.14773654980664294,     -0.08095291320318139,    0.16744852566757484,
       0.061716917334778319,    0.012277621079171269,    0.048966331428063545,    0.09649294878640835,
       0.16875618372810056,     -0.10244144103788282,    -0.046546044456632546,   0.037587410864205785,
       0.18032460259950506,     0.18229364025219724,     -0.15055700542781267,    0.048779631175619058,
       -7.4836703540503632e-05, 0.035237827133002338,    0.1005086237368269,      0.0016397713128831048,
       0.021617345906268903,    0.2462585393874378,      0.16092719414544845,     -0.18280968815580856,
       0.12157270862570969,     -0.047401670007168287,   -0.10704254068980901,    -0.022859937667444291,
       0.086990019075799827,    0.075425503602980934,    0.13484888387136809,     -0.076621442942694573,
       0.08447284757320582,     -0.17284305888486931,    -0.1569125092827402,     -0.15071832271334085,
       0.14855087105399681,     0.051878530759636818,    0.10171419216651841,     -0.0011446766791886041,
       0.067954633393428152,    -0.1247181981928035,     -0.061003146041765925,   0.11024801523922284,
       0.15617545500347838,     -0.007541527045536762,   -0.093122335683620119,   -0.079176651301146858,
       -0.053749586696033254,   0.040543337322110393,    0.10661736688014219,     0.10680160904524885,
       -0.041222027331531151,   -0.11512364778478075,    0.012521482983950512,    0.060332638361250787,
       -0.15295518162122893,    -0.11090126536433632,    -0.027751444751194131,   0.12684123954129098,
       0.15226654766867204,     0.02177004521192813,     -0.13767082553028309,    0.0085996923268090528,
       -0.046593402538396361,   -0.0014835343477267193,  -0.037071874191083355,   -0.13219674803994308,
       0.019727835418126859,    -0.0082858584784485691,  0.030226464396598429,    0.064057024586825329,
       -0.039308592513562432,   0.038977130694040941,    0.02713798573474158,     0.065600043483457993,
       -0.065762028442348339,   0.13745861199684811,     -0.25543456580399221,    -0.043221463886324495,
       0.073579665907967731,    -0.10031646378250972,    0.060554173932352122,    0.0074787554018956506,
       0.093285346135476357,    0.067871903172787615,    -0.089994308894017341,   0.21681006358210134,
       -0.16729285298590743,    0.015229390147978345,    -0.07132998602806917,    0.062200428243864556,
       -0.13160593548216476,    0.10857763736378517,     0.10775372141653936,     -0.087650212504961814,
       -0.067883625845866449,   -0.15972497023124507,    0.051799035336927153,    0.27024627587231581,
       -0.053019208519469077,   0.10369522346912598,     0.02542165038560169,     -0.094799266505960142,
       0.14918925411042652,     -0.039423590205663314,   -0.012824343289717717,   -0.11521407946408997,
       0.033070456091914315,    -0.0090178594926993809,  0.21804003802332267,     -0.044614787583892618,
       0.12889702696790381,     -0.18751882097269509,    -0.15030855375597088,    0.13143054937058346,
       0.10384626327121209,     0.12216293022894258,     0.017203015667976766,    -0.087024212572818546,
       -0.0017555923511614595,  -0.05412253239594475,    0.013414447431789425,    -0.12668429991966595,
       -0.079691928268335419,   -0.011143386443311719,   -0.24760859520599185,    -0.10957437223372589,
       0.014166814110594783,    0.049320718141532494,    -0.067903053588769802,   0.031528197236652261,
       -0.086414631558748081,   -0.12915507964090009,    -0.032276842315567031,   -0.14240530652965824,
       -0.064047434183289745,   0.09616332189191483,     0.10406228364567745,     0.039158458329681942,
       -0.011477058009733553,   0.058691574580676663,    -0.091435117928584123,   -0.10143283084859925,
       -0.026067720377266266,   0.1445004619119041,      -0.081819434114491649,   0.033985189644464966,
       -0.074930413425470882,   -0.023900900770626645,   -0.14023529581769539,    0.025376426048054151,
       0.042644764562811854,    0.065494048434640073,    -0.086854242175077881,   0.035054846157303685,
       0.17270033929330192,     -0.08127878394939439,    0.021643293021017088,    -0.09321351635110349,
       -0.055517438280391865,   0.037713722319157178,    -0.024686358115441571,   -0.082189301265209194,
       0.038732227319166999,    0.057419582220234508,    0.073054895999488348,    -0.0006971382732264917,
       0.1419963097158897,      -0.23042658821994078,    0.096470815289262185,    -0.12123968778054527,
       0.14951119302227553,     -0.023262476136402272,   -0.061940961156419679,   -0.089737624483509845,
       0.063250992396294642,    0.035481523661295519,    0.053739523571992687,    0.053933470239275486,
       0.030533116995048116,    0.087702206389171589,    -0.17191510067292048,    -0.13649850534909275,
       -0.024864374442834489,   -0.047645232417643464,   0.10756684678503274,     0.036618984610453299,
       -0.062131156893018735,   0.11731843316216828,     0.007756181701489822,    0.044916331980747078,
       -0.07526608975202545,    -0.074108805943780026,   -0.028632246447555271,   -0.24482195645651231,
       0.16238900171624021,     0.053165607112025282,    -0.04578069056258275,    -0.056957792193192053,
       -0.11535997607630646,    0.17375317805754201,     0.050336300192069805,    0.077849550804900025,
       0.13605432249677982,     -0.077129623118719806,   0.25083353952819731,     0.11666360240437038,
       0.040466390912696444,    0.083686829857689771,    0.10252168422833076,     0.17008332124920161,
       0.13444495101265172,     -0.0290191193133,        0.09024168002174289,     -0.13130301959317978,
       -0.12408419654369798,    -0.048518188955446351,   0.13962255676189492,     -0.064980655174254068,
       0.058331732975670181,    -0.10280804728650392,    -0.17133161681725614,    -0.023732919212959381,
       0.0005301646560126181,   0.050912034558737558,    -0.1520929968077345,     0.02955249997227381,
       0.089232383991234066,    0.00076673317878070359,  0.072671988562274692,    0.022017918116693437,
       -0.010309928738944041,   -0.024059019436410596,   0.14347602797883874,     -0.25498492788587346,
       -0.083943993788504714,   -0.10155868905015276,    -0.069325698031089789,   -0.0068592305192196083,
       0.084341494382668539,    -0.090120030941992391,   -0.076064047825243328,   0.035485490359367391,
       0.029588624927630099,    -0.18330840183190672,    0.13372061898630694,     -0.033335425641786313,
       -0.11781526325878142,    0.097607371243218846,    -0.10270238977210987,    0.027348323936793293,
       -0.10328678051891053,    0.085210836816366348,    -0.051422327638561569,   -0.014918555606159935,
       -0.064362835380332495,   0.088841971403440662,    -0.10244836075907827,    0.051949521488422433,
       0.077739179337732583,    -0.091425185140156046,   -0.091142808731825828,   -0.16180424013303518,
       0.12161217972853122,     -0.05515695116143636,    -0.067076556435906806,   -0.021224654115707824,
       0.0049212598436059775,   -0.086992118100982438,   0.0038395120377702789,   0.045148835265747991,
       0.065859976217731847,    0.10821043822084825,     0.091559319653188295,    -0.004962402943169692,
       0.067455084243285432,    0.020232419789606233,    0.017351716537480709,    -0.063771156435229168,
       0.14294649496538864,     0.084851784904176775,    0.21359011037836034,     -0.03951870466378081,
       -0.17561276973303949,    -0.0015960525889816338,  -0.030886082398686582,   -0.086439562988562674,
       -0.094956979702193189,   0.0073599778821249306,   -0.13092350694446137,    -0.09140652074276738,
       -0.048853822281490919,   -0.028085305437673302,   0.01043990730097894,     -0.029657048775916999,
       -0.07726894152459976,    -0.22375640027167998,    0.15325999775405272,     0.041595169293981799,
       0.16330654837353337,     -0.013551809417558217,   0.056216918262501296,    0.19781960740415019,
       -0.0044411241702452748,  -0.041961863709919361,   0.070828911323526714,    -0.13899193222526843,
       0.25011323408981107,     0.042842519480606633,    0.055436252532894276,    -0.024661107465925109,
       -0.035671258041711985,   -0.022923381758136692,   -0.064704326640521226,   -0.067452979400445034,
       0.13845531249175852,     -0.1649643366227474,     -0.057319548519699628,   0.011936894602805576,
       -0.02453482612401614,    0.20787009745699644,     -0.037442000449281268,   -0.024623945058738734,
       0.11303510333132379,     -0.10642800811997895,    -0.033884967532391397,   0.097938293875673751,
       0.10060963676006116,     0.0051005746997354121,   -0.1246073369534451,     0.055426934584542203,
       0.1578857353991969,      0.033123128900479019,    0.0096876522849309483,   -0.13998403210094462,
       -0.12251462453699338,    -0.025948524678918106,   0.063745370698154905,    0.16559464247360231,
       0.17983255053105163,     0.1512417679577073,      -0.063886485348651226,   0.066153249111902471,
       -0.084839949561779843,   0.12119233623445143,     0.12803244856409671,     -0.083768285830778291,
       -0.049661503473737434,   -0.043214445265710687,   0.10152375582712005,     0.1889458355031387,
       -0.047498468546145568,   -0.19361053345618803,    0.0020968750527395703,   -0.011232564434013404,
       -0.14086154238583401,    -0.016502322171128257,   0.040621368543427745,    -0.062541886914470129,
       0.12854815714049503,     -0.076995241738413975,   0.068827070221840397,    0.016066669562974409,
       0.027212757342961746,    -0.08588568318508577,    0.070215972214723643,    -0.0089256502384984886,
       -0.035490427868378402,   -0.088903919912756924,   0.12375416715588645,     0.12147445298705489,
       0.029734281713890608,    -0.32259904212283019,    0.063493630974053139,    -0.13745234634656717,
       0.00049488825383161433,  -0.025608722638816951,   -0.073988476820243218,   -0.098741154838913756,
       -0.03354256454738621,    -0.10713006916929206,    0.097509177114456461,    0.0058891444687039426,
       -0.08966954836501978,    -0.010610280414851361,   -0.024895277924684558,   -0.09855358852407857,
       0.14374712020476654,     -0.14236102391851352,    -0.1880720280489887,     0.092378435569016162,
       0.093649137324719633,    -0.069081312363881833,   -0.033334620894323638,   -0.038057489574420053,
       -0.079068301658297063,   0.071570068901588901,    0.19796940770034721,     -0.19410865867979585,
       -0.012966895589255893,   -0.017844915089279823,   0.049310635276721658,    0.035122903201905122,
       -0.070304015388146221,   0.0054605362902510717,   0.040037446498682364,    0.091204473458274982,
       -0.097743702360912538,   -0.13161843926589256,    -0.097446188908502498,   0.12436641128208191,
       0.03552751832983099,     0.15577271636779411,     -0.13300612870558587,    -0.042343642468583673,
       0.0081928141527484906,   0.064088129427711776,    0.086321602678297749,    -0.24311460411285671,
       -0.21605209273123058,    -0.032435865924097987,   -0.031733116842625586,   -0.071130197228069555,
       0.011442685127901269,    0.064810203743364492,    -0.041912222222977656,   -0.040790402107827597,
       0.0025706792455088383,   0.038378349685397342,    0.043543370754921991,    -0.075912854316660491,
       -0.021439763936291233,   -0.045129396513015757,   0.12720301292949748,     0.083023851104790228,
       -0.095077691017965663,   0.13181574166441315,     -0.007632744173761653,   0.098765238966663407,
       -0.01309182067392935,    0.14964871620805187,     -0.087762090323144193,   -0.12590986989600417,
       -0.11408246645450913,    -0.092771812333487302,   -0.067593240378383296,   0.015217901774621685,
       0.086612735184511694,    0.041087337201735775,    -0.14432307883604117,    0.096009198360629017,
       -0.055815331168598284,   0.14482721959099801,     -0.099347253687488174,   -0.019429718611009967,
       -0.13397601637269532,    0.067228638316005382,    0.2207716787468337,      -0.10089905731046522,
       -0.11943765897873389,    0.11191168713967363,     -0.13785387957457282,    -0.19017291389555105,
       0.078813634007058597,    -0.10180719012788481,    -0.1090426383230713,     0.11850128272353627,
       0.16286557236690494,     0.26294163550214217,     0.086176796350620852,    0.022000888705305321,
       -0.037451880446867064,   0.039580688574488473,    0.17134353701953409,     0.14998892762498417,
       0.0038891441432203737,   0.02716159111821257,     0.078336265417573311,    0.14642562818882451,
       0.080313687277035112,    0.061524668299372046,    0.062431461161177454,    0.010299744728777085,
       -0.15236438766173271,    0.12154004243368367,     -0.038943537966917754,   -0.011404079178498052,
       0.13991149901842354,     -0.042317157546314529,   -0.079721290026495806,   -0.094917214346450507,
       -0.12942709296686536,    -0.12384261704492115,    -0.16731561115507779,    0.014636311493892461,
       -0.16105494640884865,    0.07476523341434746,     0.046050074741327357,    -0.020994360736083423,
       -0.065680132026523078,   0.090497556911613541,    -0.022711602267986492,   0.034098878618666777,
       0.034176399751518247,    -0.070007966283021694,   -0.042708102007748862,   0.04634531555641231,
       -0.025949226747691619,   -0.099164299315596116,   0.032201013399711341,    -0.067976663853816024,
       0.040431844200208317,    -0.18369020467143757,    -0.083078058032282284,   -0.1693151556249661,
       -0.12091860429665829,    0.077136937146497234,    0.10676745832965551,     -0.073000509705763952,
       0.18359172589548522,     -0.14935902091775452,    0.12778013665669377,     0.018272815000599119,
       -0.2052811252960399,     -0.12630527679106135,    -0.073106151113160392,   0.028626372791926501,
       0.12022310991504205,     0.033278200269960659,    -0.048113591964011916,   0.0057605148952800935,
       -0.0093694758399667614,  0.10108972461096534,     0.10591880899551898,     0.079169970833629061,
       0.10433896949557919,     -0.071564794118242792,   -0.098344844630693123,   -0.092279199746067603,
       0.039427142589060195,    -0.0069009753760723427,  0.042750140579166207,    0.021182002750665462,
       -0.083850378676495363,   -0.12063598076431098,    -0.011584729960964983,   0.1102932139022042,
       0.065560543284218245,    -0.030244277742118547,   0.073039404441390593,    0.15103013231510709,
       0.095953306336075961,    0.10178357149940817,     -0.020513931062363121,   -0.047443058378942596,
       0.087780457487753108,    -0.020992625009966945,   0.063386798592652685,    -0.18117991795015725,
       0.092273180821564244,    0.098089996873618912,    -0.028062943454016675,   0.0042806116100913951,
       -0.022502892724131716,   -0.046705015470983643,   0.1158471375892456,      0.03028266588367835,
       -0.09011021784792568,    0.14835434911020787,     -0.079269210591392164,   -0.035877068759700988,
       0.061830862107120674,    0.16868276997853818,     0.07629117516438999,     0.0048892980528270217,
       -0.12113474060097836,    0.042316384323005093,    0.054002953738918412,    -0.044103782780636321,
       -0.040158821404429758,   -0.010587274477347189,   -0.010329011905159322,   0.11237424482274358,
       0.076246092217111344,    0.07342314143913399,     0.13017606946364643,     -0.11030319163710953,
       0.1664325581617663,      -0.086711076976077411,   -0.091006593062238655,   0.02483671533249221,
       -0.1897685254431315,     0.0008935009739842268,   -0.16426467884883655,    -0.071455782500547113,
       -0.0020477521490168066,  -0.057414678583406015,   -0.056701456727849146,   -0.23205506739351531,
       -0.1292731260997719,     0.049059466620023133,    0.072449998612393873,    -0.1106584378281603,
       0.13631164033143464,     -0.073684191224505521,   -0.12242434613902836,    -0.067921962845301775,
       0.23048759593267296,     0.12302240790754143,     0.033903497850164006,    0.10844626239798703,
       -0.071698686927048602,   -0.025770689035657445,   -0.18743512596515535,    0.10328906977199419,
       0.025734226282522133,    0.020160215945500586,    -0.042644710663257465,   0.12273924283811999,
       -0.064175846849913648,   -0.037840236685500198,   0.17846865044555721,     -0.068178770539765218,
       0.18929132503651314,     -0.079911643434284904,   0.072364005994939182,    0.024577830627867888,
       0.098367915256802774,    0.060940457411585783,    0.055608894093171782,    0.11982158710998583,
       -0.1852038882935893,     -0.057642887836528649,   0.14027344544229678,     -0.099185824874264389,
       0.02263797839007518,     0.011212738438144972,    -0.030871935761225315,   0.016193413057111833,
       0.040331886332745509,    0.094306842902063037,    -0.1305123138816297,     -0.13991860426738895,
       0.18715838510533328,     0.14727451018839444,     -0.075074478680235951,   -0.032264236948548089,
       0.057536701833181443,    0.18549340562323227,     -0.012202891158332766,   -0.044535473380310706,
       -0.017208193851681326,   0.080187849512772497,    -0.049589891025246836,   0.032809592603763427,
       -0.049622781513092115,   0.18891523119888837,     -0.08625284533390791,    0.11138463176694115,
       0.045582912950315399,    0.043412895433268039,    -0.023000182765890189,   0.026807972176001778,
       0.051025576602499852,    -0.12261041269779729,    -0.18240886706813236,    0.053437299329043932,
       -0.096008758837632449,   -0.05697479790111698,    -0.008974521285632843,   -0.037415416643165444,
       -0.11954599908760286,    -0.0077447078170423712,  -0.12604749872373383,    0.005771621244201176,
       -0.18155262388753041,    0.11579839711972237,     0.021106005897655336,    0.060624597901438752,
       -0.087950421118268424,   -0.096129424664460436,   -0.083247177960193944,   -0.059866087745107543,
       -0.050172503446112751,   0.060048618846292506,    -0.129456153630959,      0.16954615358771855,
       -0.027108857086387602,   -0.10853070989783273,    -0.11221492294070826,    -0.10256761485308125,
       -0.025954466370594311,   0.21360200559607531,     -0.059963768379545632,   -0.009157103684019216,
       0.047567783112890005,    0.0019196049994349837,   -0.061092557881251439,   -0.31423530716804998,
       0.027548451554627294,    -0.0020459416139606435,  -0.035741912729664781,   0.028403059118895489,
       -0.035249782181990943,   -0.023355768908116956,   0.080024029697559743,    -0.069204205627699744,
       0.10612547405893158,     -0.16192182695559443,    0.062978001445386123,    -0.050453476685285971,
       -0.078047486662739265,   -0.063246028904120205,   0.08511046914506229,     -0.13647166704918304,
       -0.033712869901894038,   -0.066696986164215849,   -0.062953063720066177,   0.2629947329677923,
       0.061345624317007505,    0.015292224529992711,    0.070043166947634544,    -0.209983153180199,
       -0.053128010997223377,   0.097639019035780858,    0.053367475663428227,    0.055937205180172964,
       -0.035636767465352909,   0.028560809709635065,    0.097825492866493044,    0.10145311448472018,
       0.15850731779931054,     0.017147514585217478,    0.071580859029766228,    0.12521013713371604,
       -0.17619955006784399,    -0.03801043514195758,    0.0026880805743523008,   0.041055776007754757,
       -0.023049113807333304,   -0.17501203963430281,    -0.1864151673964671,     0.005723328381885784,
       -0.093768316525009929,   0.043095396673046842,    0.12772138459808363,     -0.038788286780144628,
       -0.073746890698756673,   -0.1500807090183808,     -0.19181108081313583,    -0.092794916924225118,
       -0.091428257107541044,   0.13283558019825292,     0.053863142183759621,    0.032940225626983545,
       0.072378810004598698,    -0.037224410851101675,   0.15499941424838745,     -0.016051696657840165,
       -0.14004515148839261,    -0.038601075362561098,   0.078088913020221362,    0.053137794346785117,
       0.019465275538744047,    -0.052043456699109952,   -0.035886261578229203,   0.047171108353884217,
       -0.019748533625109348,   0.097417740536721448,    0.083127226193234885,    0.1201249298636529,
       0.050517916461886282,    -0.21827975325491908,    0.043178510357763128,    -0.029423838060447273,
       0.15834817621367347,     0.03726014053504563,     0.14010231678754953,     0.13728627564359747,
       -0.077935815589078999,   -0.019660677268474078,   -0.16296944715013809,    0.03653567153890093,
       0.18914193227540968,     -0.020045477450021672,   0.047995157257031254,    -0.08774801294479774,
       -0.031404298169255287,   -0.096353138489836038,   0.09815174873902352,     -0.036191674747670183,
       -0.14734562887008676,    -0.00041790594345076162, -0.023293363647958892,   -0.254686043365492,
       -0.078103987879108494,   -0.088756167382078241,   -0.099240754934040845,   -0.019831059361355721,
       -0.11335150640302422,    -0.14431657937185741,    -0.016812488300497228,   -0.026221095077002866,
       -0.085905240580134004,   0.086740965625194386,    -0.0047258776900135149,  -0.030746525520276523,
       0.081509816631500281,    0.04911284903098951,     -0.070021754207212489,   -0.28033256510872828,
       -0.12154229093628874,    -0.055993333271753917,   -0.12422024183839896,    0.11077980672171904,
       -0.033908545183772676,   0.0081113763708954567,   0.22545411404752783,     -0.019320540265292403,
       -0.032968872848276695,   0.0018649334414684166,   -0.038632198342647701,   0.11636773790094293,
       -0.12718099434069369,    -0.0045425182316688358,  -0.048363876418798774,   -0.030590268869173834,
       0.10323374147805635,     0.10205736187425091,     -0.031312681424083548,   -0.0014338135531874667,
       0.1409831887369476,      0.099232211270450843,    -0.12727233060540363,    -0.098690961134355257,
       -0.15042959303117856,    0.10064306957460287,     -0.10944459142361428,    0.18472810711779838,
       0.08912628528830209,     -0.091785325574239934,   -0.061465221527484321,   0.057715348840806174,
       0.014608777363968581,    0.11287573969947516,     -0.10148981266568989,    -0.14708491702081478,
       0.052944021008224096,    -0.065016355371653151,   -0.20733852655477791,    -0.027217935662605969,
       0.098949011606096218,    -0.082241635379938463,   0.064568454300224093,    -0.10417112907144405,
       -0.1094698153851143,     -0.046527604959146276,   -0.05556170998169066,    0.0010160904950406047,
       0.11752261095889113,     0.066167039574198172,    -0.011168020815876801,   0.036944521838769395,
       -0.075266820874907589,   0.33867205043359982,     -0.038053627576115745,   0.041883512371042042,
       -0.0095888015011114831,  -0.045669250208315117,   0.044968849427673353,    0.06206839723224896,
       -0.026983314357961537,   -0.097603143644773627,   -0.15222518045687944,    0.096804121790758979,
       0.086683567828104297,    0.088644858214277852,    -0.026284930810990641,   -0.14171064291447596,
       0.089301071120203329,    -0.042354214617606467,   -0.14486531992673773,    0.13574956226448487,
       0.088165970653458728,    0.065822428377514453,    -0.16279976272420948,    0.14671277591332804,
       0.03553804546821588,     0.048948205721484901,    -0.031874236231396798,   -0.051180052418858965,
       0.091611716937371912,    -0.059682094898585197,   -0.19236753440840407,    -0.010046458789602124,
       0.11260501532404706,     -0.15108144798199363,    0.11314098490264078,     0.068034204963486167,
       -0.058580248702481644,   0.07399682683788758,     -0.15634009274226618,    0.11683523902318953,
       -0.046695545400800086,   0.025717991226644765,    0.080757227675313861,    -0.017743157144780673,
       0.074361796993185431,    -0.020575442478285244,   0.061544192642988951,    -0.12295114121514998,
       0.099321032140000834,    -0.072083176258829151,   -0.26948025826968652,    0.13975133728167108,
       -0.15052323001101187,    -0.026538999616613847,   -0.019299718921545871,   0.11777742003855982,
       -0.034044795010345311,   0.10570973332585763,     0.091166074940420533,    -0.076526935864181328,
       -0.051998513323129471,   0.072541776051376308,    -0.027256837776021357,   0.024572733580508047,
       0.12701615215796028,     -0.02542922069906204,    -0.1604598063434389,     -0.20570543289137733,
       -0.093356005570176759,   -0.14856765990603835,    0.097940051131241559,    -0.11975329090396808,
       0.05892650602789392,     -0.035507335681373667,   0.086702736611523001,    0.14031371193712167,
       -0.0062800485508714013,  0.067726485668412745,    0.018203645108666885,    0.07128278743036677,
       0.012727916607237509,    -0.10772158447333879,    -0.082846872908097016,   -0.0041411721063034854,
       0.080305989240804246,    -0.099910775643569413,   0.11476273933531669,     -0.060037344540446132,
       -0.045309263287418959,   0.16220117950581434,     0.13621190619443277,     0.00054036481929291302,
       0.062985433695971482,    0.025515026156054547,    0.022467047774125205,    -0.059618490077816326,
       0.1020473920458332,      -0.068670228717214232,   -0.11259791507046824,    0.089208322140053004,
       0.073102548747618373,    -0.097969931010168404,   0.032481975556678193,    -0.053077224377682378,
       0.17787939795955052,     0.14323908289060985,     0.006225863628284015,    0.20525108714379517,
       0.069982063858531271,    -0.10245259271795257,    0.030372128448949626,    -0.10076134549404454,
       0.033456770310806738,    -0.026925740060915568,   -0.096479542027718315,   0.07382096035595026,
       0.070742892044423647,    -0.16416039887653419,    0.04840047955219802,     0.10531523570243176,
       0.028427543185779926,    0.057041742358300181,    -0.10779239579151352,    -0.019998227789517185,
       -0.033374622735624311,   0.061673773221099834,    0.017544425475985899,    0.068850933965150921,
       -0.063089373631262893,   0.22231176318553508,     0.089665788487117704,    -0.087813355202329621,
       -0.0020137753446370036,  0.063232723228931129,    0.02738203046838408,     0.0085326382983393102,
       0.11692715908010445,     -0.10714743191337431,    -0.086244821342113004,   -0.092194558325960296,
       -0.1079580729700623,     -0.10535518931297455,    0.17210089779117033,     -0.047232927848788887,
       0.024713194214824201,    0.049059813459126279,    -0.0043920048797371162,  0.0076893687796483218,
       -0.16776100516804632,    0.12175097118907234,     0.061395555763641654,    -0.17751382834619428,
       0.0031781679087219301,   -0.12377137659671951,    -0.01725768735395759,    0.0097711398942777958,
       0.15013286208171042,     -0.018064255597071179,   0.13449132396575131,     0.10564581876912042,
       0.055561574437561989,    -0.073737818153667839,   0.21303750206632388,     -0.089719723365957432,
       0.094360944682789355,    0.081986912519439778,    0.011612321366490236,    -0.088527106803164807,
       -0.27398292187378032,    0.10213993110859673,     -0.035383039083721229,   -0.15194943113747367,
       -0.078230383666042874,   -0.17636903919363758,    0.095869500081510656,    -0.0047585272987493961,
       -0.05914199465608018,    0.0070277044735525228,   0.083155677302253331,    0.16495031870016441,
       0.15958506671471168,     -0.13527069504876299,    -0.050799088192726098,   0.080596570955508484,
       -0.12052393483429771,    -0.0046189323184925336,  -0.005070259381938301,   -0.04683138214869647,
       -0.13913976644861756,    0.060784542190305463,    0.053016323251729919,    -0.14483105530333032,
       -0.0040382954925186803,  0.13211708479579623,     0.050181583755892559,    -0.042286468533701521,
       0.01493587152357735,     0.016398512790833493,    -0.071548297373726644,   -0.0029546325539898943,
       -0.12311321275971332,    -0.085064671248173324,   -0.029552651498654638,   -0.15494819825916237,
       0.05639196726155999,     -0.059592884834491988,   0.044716674807816569,    -0.13630415205711105,
       -0.058129782309775752,   -0.040190313405655112,   -0.056653768409669805,   0.036729468672812807,
       -0.010133364118179998,   0.23323854343700356,     0.012078368070301795,    -0.020490628889088622,
       -0.039329198766405261,   0.0012198812235480749,   0.03676543121976384,     0.023626745009791176,
       -0.12642237825987085,    0.081457170462002862,    -0.01427624962293389,    -0.10836732807012642,
       -0.036742714486909217,   -0.086958027619038133,   0.14204080998728849,     -0.12811308318614623,
       -0.013241709827661282,   -0.037053266569541547,   0.062313093965491576,    -0.19130214097847104,
       0.025664275726214072,    -0.023189451700664877,   -0.13143432561944643,    -0.095789134771004425,
       -0.14419425742619718,    -0.082544439199032149,   -0.22726590678587172,    -0.068056852972783063,
       -0.02734534661721157,    -0.0087335515850959534,  -0.13300059394095845,    0.039384711824318977,
       0.059122787216942821,    -0.024480050760550372,   0.088724706020023719,    -0.008291782709262641,
       0.010258519306798742,    -0.048128397622938711,   -0.041522232246139587,   0.037721085227769735,
       0.0016680252673828139,   -0.017002452600299277,   -0.032412846767608965,   -0.04026931935978742,
       -0.15446226773489458,    -0.14362277843100335,    -0.10060977847416375,    -0.041066860352076483,
       0.17009555120184713,     0.073475030338404787,    -0.2818449847147238,     -0.11788683333798303,
       0.15672990624277894,     -0.019500034228212292,   0.10079297020964878,     -0.034884445379881522,
       -0.05860496490872473,    0.21518413230269734,     -0.12003162682257021,    0.064786015953518267,
       0.02797507962024863,     0.053668031849046616,    0.26213719573600025,     -0.0085629239384670697,
       -0.05967917751103749,    0.0075027786581232433,   0.17773537361451749,     0.055602757531783259,
       0.035202911912300558,    0.096616947864833977,    0.029127160521998006,    0.05710619758449776,
       -0.052791781553673166,   0.062602718847283051,    0.15280209332847702,     0.0062292428781041513,
       -0.24029587263429464,    -0.074812660974935732,   -0.013623973621979587,   0.074709492141942127,
       0.05911696620666685,     -0.0037877026599331095,  0.11180313749932465,     -0.21951682781568835,
       -0.036070514359886549,   -0.038249657993398641,   0.1486832908499312,      0.0072236520799563442,
       0.0057026111635515011,   0.13999772803552821,     -0.063080348308860654,   -0.0922027978303082,
       0.066866653007536414,    -0.00038687729326844196, 0.11548683651293158,     -0.13144217728023913,
       -0.11817154614931698,    0.026875544332775531,    -0.027053281130006566,   -0.17152714373385811,
       -0.0042016915084441405,  0.025352175287386022,    -0.13973063583087025,    0.11844230896412784,
       -0.086846236314105901,   -0.10012390490099408,    0.21700371710613509,     0.18247008540332449,
       0.025733507639773265,    -0.0058669999687546975,  0.11741449598172926,     -0.014425438023330519,
       0.054566445876520653,    -0.0095820192677950871,  0.046284006105032874,    0.012616556370744103,
       -0.053358284998568276,   -0.12051890554640227,    -0.034862689383467205,   -0.088794991574150037,
       0.13178436873123026,     0.10650762196547987,     0.067532005882261006,    0.059765621431012696,
       -0.212855528197125,      -0.03553663826829169,    0.063234151707129815,    0.11114183091444477,
       -0.0093640939748872425,  -0.036454288397985819,   -0.027882849956278807,   -0.15099401358677422,
       -0.14307919451613063,    0.1221717618277388,      0.11837060191396509,     -0.091974994191078227,
       -0.16283211703314926,    0.096522945391771128,    -0.043082936479246207,   -0.13757770434627578,
       0.017112105078396625,    -0.030371250588575361,   0.087098860513291562,    0.074840785413983826,
       0.05566642586288454,     -0.054943544938277682,   -0.015581984236068465,   0.042097707219413381,
       0.10775056515439076,     0.064889343990059883,    0.14274342295641732,     -0.12267022912865026,
       -0.13854480363152211,    -0.072886177285073697,   0.048668221931534569,    0.21889359632213154,
       0.012488300413750543,    -0.090631403693504656,   0.1530109506466584,      -0.026158088206774423,
       0.0073547067448821325,   0.090996788408162846,    -0.013159611506233196,   0.17216769998235681,
       0.0681634766735284,      -0.12270585152398057,    0.037493147026956886,    0.0009671707792034169,
       -0.12347340142746517,    0.10631437345121199,     -0.00019661062995936576, 0.014324794704286476,
       -0.12145788370999874,    -0.18516744584923953,    0.25964386402933959,     0.11809158903574936,
       0.091659044319505445,    0.16303319201335814,     0.043379777653541403,    0.013603173723813623,
       -0.0052220271535212389,  0.029450309661058431,    -0.018914865052605846,   -0.096686343189289342,
       -0.012487033704443349,   0.0083571151530395724,   0.16543143525837029,     -0.084553650265665359,
       0.18885178034064737,     0.080015583844246882,    0.14843420977210978,     -0.12542439556046003,
       -0.13769413743008388,    -0.015782301907789786,   0.05114912929310142,     -0.064216499652126238,
       -0.037840073265702448,   -0.0014039861041241358,  -0.10633028351333805,    0.027921601862725565,
       0.017147286792449298,    -0.025852776848999205,   -0.20948636782415775,    0.1800290987488361,
       -0.054651189923366726,   -0.012643764270411617,   -0.15978430361287838,    0.022730407993616083,
       -0.034322098129314346,   -0.098378641977700881,   -0.045375128460155484,   0.10393903688316386,
       0.055303706090253243,    0.003897497477855805,    -0.087479412825590297,   0.00098822741247963936,
       -0.20696132406529721,    -0.13610798655200296,    -0.012582334332169966,   0.24884694273631361,
       -0.072099694867570688,   -0.056169030847768218,   -0.016311915423815902,   0.063471638000485331,
       -0.082386552772602872,   0.073661864885465195,    0.017436582974023764,    0.0062259852313667225,
       0.24296837819161829,     0.083894933999142815,    0.061721536238705375,    -0.086904551083048537,
       -0.13470349945994251,    -0.015308489234018874,   -0.058637562527958799,   0.03504075027206921,
       -0.26346123542339661,    -0.03569374673699105,    -0.0090376852522107663,  -0.015277613979726009,
       0.0055298787873735954,   0.001251550657282813,    -0.15432947266692396,    -0.061010477304453525,
       -0.066259883982685508,   -0.0076462167565417788,  0.12088754352280259,     -0.023748266878271557,
       0.020007501388417542,    -0.067414354748255009,   -0.063158712588004318,   0.098900948440977854,
       0.06514960000501395,     -0.0040898576903766375,  -0.045811756507296013,   -0.025224883043347676,
       -0.19656675666178378,    0.2698573755408491,      -0.025694030455345757,   -0.094988306698207348,
       -0.011017468364385032,   0.091006227848899043,    0.13355190752469351,     0.014063835257296421,
       0.071012850846156425,    -0.16190626618024276,    -0.032364558195366891,   -0.0096398392742986193,
       -0.085821815064897902,   -0.090209684848556834,   0.028672433650647654,    0.0081219202483687747,
       0.075148390248633457,    0.038520494808086454,    -0.067676083449375896,   -0.054284200259739727,
       -0.13658517565945377,    -0.10935002894459855,    0.093435737889596235,    -0.054382583646901225,
       -0.15137204064496762,    -0.16517601606633395,    0.085166235888033986,    -0.035281104675735503,
       -0.067267050224696673,   -0.21259980155891953,    0.047463139453820163,    -0.070273608203379717,
       0.083679878798464363,    -0.0074554530034243883,  -0.07919742383990501,    -0.025468160653213893,
       0.05832867719382822,     -0.10849994239753707,    0.040471834384128054,    0.078767196041924975,
       0.15126992965530131,     -0.055001410590505305,   0.043379967459978595,    0.035086368882579461,
       -0.10491458653427468,    0.071418878851339601,    0.0013190940026213092,   0.057978572678345261,
       0.012097207888153154,    0.11149816419615685,     -0.099420861010198106,   0.15662415496309329,
       0.063999522684075674,    -0.090995803623209401,   0.14018140119398767,     -0.14377953984112357,
       0.12511835708631622,     0.075816440918505201,    0.070172181128443326,    -0.23515143072245764,
       -0.11404772877659805,    0.13038129572086507,     -0.095891970025218862,   0.16320761737424461,
       -0.012488639980440296,   -0.082086843697589368,   -0.14345151428816763,    0.055649942835105382,
       -0.0053883849040278313,  -0.0067985581303340679,  0.15661121537464337,     -0.063551874080462534,
       -0.04562562319953771,    -0.088595249671959392,   0.029167538597268478,    0.1047358021138671,
       -0.041305938280509796,   -0.066567671313223525,   -0.05325325538113744,    0.055028554982505647,
       0.10716322256675649,     0.062850458442019183,    0.10324962786091497,     -0.0078555752306601299,
       0.028525339896751822,    0.098662979760070393,    0.01062432592149631,     0.0005595344545303335,
       0.055983121586766153,    0.31561861609586345,     0.016171766654091257,    -0.12972818208261921,
       0.064627135609617387,    0.1566678680782676,      -0.092791618956234903,   0.11306948136081697,
       -0.082077513160690688,   -0.003714010421533694,   0.010174580799673228,    -0.014565447656932686,
       -0.056654560089236555,   0.18555160832395989,     0.06965390574927964,     -0.059990504872402546,
       -0.14100268053916218,    0.043341812966068607,    -0.031621007309005383,   0.058101505142990055,
       -0.070771238779621687,   0.011632452222988735,    -0.038168550927791325,   0.075386358002606985,
       -0.038560132397150546,   0.01491404650517263,     -0.22004751303612965,    0.07601786880237292,
       0.062508750389305701,    -0.12516234222267542,    0.15605941274124016,     -0.090952690559851571,
       0.0081271132845207421,   0.037827632686158741,    -0.15834247173549293,    0.057439902387244661,
       0.18811238688124149,     0.1719111189347183,      -0.029328204076073557,   -0.12390804985071266,
       -0.11777224750485941,    -0.19109844088824829,    0.21095160770298427,     -0.031362446472636404,
       0.023420051072745886,    -0.033076414642307733,   0.085355142193825201,    0.020681281112969872,
       -0.036978525648084438,   -0.05774197587186234,    0.16155879628239159,     -0.10649588781943922,
       -0.098601094089467517,   0.027431669299658727,    0.24603571002640603,     -0.042875650472154997,
       -0.0074485006804872241,  -0.079968347542067122,   -0.093008330197506511,   0.076166162573850935,
       -0.08140925566487188,    0.16414365826092769,     0.024981589803408859,    0.055290130085440953,
       -0.012061118817453564,   -0.0010201592429883023,  0.17224025832017814,     0.24076675930891889,
       0.037315619812157426,    -0.15716563770980904,    0.077312435498560206,    -0.072595092363381755,
       0.075614985854738886,    0.028103630255279548,    0.11959291875082602,     -0.11221514520683526,
       0.088072967386425602,    -0.033855316248979743,   0.10583626187957604,     0.093769578859402944,
       0.096015248935260936,    0.044868401677213017,    -0.20765008859986997,    -0.078160534866907758,
       -0.028186789770350121,   0.0043068484251403746,   0.073722015485308642,    -0.074342775789991086,
       0.17566019144275064,     -0.061202883400928026,   -0.00090853940454919437, -0.20243461340321964,
       -0.0185179195718497,     -0.071326134504851396,   -0.058936011211773609,   -0.051536204647992891,
       0.11910553538301823,     0.11627932221444869,     0.016914509798651927,    0.078253404011249486,
       0.022879103884575543,    0.0004801706775119062,   -0.087151319661685892,   -0.19444333163010574,
       -0.040680842818005859,   -0.16976931895688596,    0.010915967355368809,    0.048274440280608774,
       0.090148136322836858,    -0.011266134949002218,   0.068994508568974849,    -0.070371106781512358,
       -0.10966786754614903,    -0.15254522056488931,    0.18342815866546724,     0.03858861781526797,
       -0.028077490942209661,   -0.055428168543942793,   -0.041118779522297047,   -0.035974869279546413,
       -0.22914322581311866,    0.061428033462356854,    0.026990908726307265,    -0.12113494865089651,
       -0.0068551220378096165,  -0.064097522384120711,   -0.0041732957525521044,  0.089565603646863584,
       -0.0063405861743198559,  0.040208989697126225,    -0.0043875351929053268,  -0.14767879794127539,
       -0.062867865305034187,   -0.16034602896771297,    -0.088855162324216683,   -0.13359512017549455,
       -0.02643953149506514,    0.024420864546425058,    -0.033317031763452999,   -0.037945385394927228,
       0.12499428744556269,     -0.073213709462230853,   -0.10759912970142539,    0.071576579566241721,
       -0.13459086857176081,    -0.013974019492048843,   -0.048615885754164347,   -0.060293549203051432,
       0.16798147921794118,     0.016090570804983349,    -0.042830132143335371,   -0.03390869945917948,
       0.0070639877007690989,   -0.1915706114411419,     -0.073059554636856261,   0.17762203951822983,
       0.061045933758175117,    -0.13839961963053568,    0.03362133922113892,     0.03834838071001595,
       -0.023444318633985425,   -0.10764098997527508,    0.043702580741536177,    -0.058257853755838994,
       -0.082908320645948663,   -0.19429603285236841,    0.1969246692858555,      -0.020673217515896628,
       0.053636511441264266,    -0.046219721722300544,   0.037297486625645263,    0.028258460037843981,
       0.047754218696779926,    -0.039891926655209846,   -0.072269366825138862,   -0.044956958957473203,
       -0.034940368049563922,   -0.11442411851236875,    -0.18996193462962019,    -0.0179258299352003,
       -0.18633557126227934,    0.026468740460853984,    0.07769732465830613,     0.0027936781920777152,
       0.018534942685052007,    0.12161674357702724,     0.32590858260968464,     0.036403047976738157,
       -0.066936026796943424,   -0.089741802439311527,   0.0058199823657565965,   0.01388210838261998,
       0.12412125243903085,     0.021637000711549913,    0.05593480829925522,     0.081473313845300349,
       0.11539383467520459,     -0.00087176866671258898, -0.045172751794244972,   0.24457623092927894,
       -0.026073196918280576,   0.067668034803700441,    0.046795046517955345,    -0.11773754163036201,
       -0.14455871036169027,    -0.13239775174824286,    0.20950369257765397,     -0.045426634529725111,
       0.0056979567463906859,   -0.033421563166224862,   0.01522253086744085,     -0.03518934885592799,
       -0.058148274864602889,   0.056902961336955743,    0.07064292850402755,     0.19083258955065463,
       0.11842751675865182,     0.021758356869727154,    0.051960437220139974,    -0.021322334766862669,
       0.079708513336798126,    -0.037461278297899941,   -0.044038842697206287,   -0.042526291635936214,
       0.16207233568403528,     0.078772429209926068,    0.14195214119639885,     -0.05704078804786325,
       0.07964749823591942,     0.012859813655498858,    0.092161754230943541,    0.1507687358494588,
       -0.014815281380544706,   -0.10446284832853656,    -0.03498197317006882,    -0.15943335141016596,
       -0.12379365654231214,    0.0039702292184170627,   -0.05131000743861832,    -0.15666300505581951,
       0.034220529628767087,    -0.13960125300677134,    -0.069098920717275178,   0.0011999708640859051,
       0.057710678305818316,    -0.11522383091301981,    0.12858691844411224,     -0.0046663883980553158,
       0.00099915691277050172,  0.19867615613370462,     0.1629327677293507,      0.0083661712259738789,
       -0.31267652080218389,    -0.035952200944397841,   -0.027608914624318852,   -0.071206766463987575,
       -0.021599237713094022,   0.13934800137757131,     -0.0049067653937450821,  -0.16399150313010025,
       -0.11968390860242623,    0.05571643292941799,     -0.080322349874557386,   0.017588921272316729,
       0.0036622947088412374,   -0.32322750434634273,    -0.17816887052218638,    0.054816717805504664,
       0.029571725931631272,    0.14023924918957309,     0.075275049361641838,    0.039496011939472837,
       -0.21368782990386934,    0.00074414966317842878,  -0.04149353522323232,    0.053770347420784889,
       -0.11794022782960349,    -0.25372628294197669,    0.15277852354896568,     -0.0071447869421005271,
       0.041269035602518302,    -0.11198940060023035,    -0.15676718938233414,    -0.026173132188508457,
       -0.08576647256949653,    -0.092764768799581537,   -0.0065488824981442288,  -0.065527908698472373,
       -0.18875338084955678,    0.10289470228070176,     0.077583694944805506,    0.10267270251662595,
       0.15795663219318201,     -0.013201751543802039,   0.068870941433122806,    -0.037227974844341524,
       -0.03800778005659939,    0.0076532722477649006,   0.14320191908483673,     0.10949080495584738,
       0.074656058333911937,    0.02006664181988688,     -0.028545920610968362,   -0.09943891337634185,
       -0.026425387221650748,   -0.02854759111502167,    -0.077968013556528618,   -0.11324433625025385,
       -0.071571023561527392,   -0.091473342509695132,   0.10765371667383268,     0.059065546578436851,
       0.015039022206267436,    -0.14021627669875084,    -0.072312133968574277,   -0.12824424238338264,
       0.055536936179895531,    -0.082660397812128514,   0.027078559156415702,    -0.046914383388634441,
       0.043706080827586827,    -0.023890807632562173,   -0.11061217347113822,    -0.071922535362636403,
       0.011430068223237815,    0.047367065511560134,    -0.064278687320734967,   -0.07940424204152198,
       0.054850809837642386,    0.13583307319554536,     -0.023096171259652715,   0.097316549006675843,
       -0.012194294624827809,   -0.02934670483586347,    -0.045571469397554396,   0.04232845214211594,
       0.016717033319590464,    -0.019193103896596456,   -0.023758337733770531,   -0.04799171580938752,
       -0.06472523261013971,    0.025125387350854681,    0.015089917072521556,    -0.019767543850915364,
       0.032106274463193932,    0.03897973918608804,     -0.078968558502634165,   -0.093238373604526054,
       -0.14991802186494219,    0.0197365779778985,      0.091650878674984476,    0.047893956722553338,
       0.090444383576512216,    -0.10582642841545931,    -0.074299037786144106,   -0.22012893646860129,
       -0.0051562288518185017,  -0.029945366525490454,   -0.12481410514895769,    0.14209441790118302,
       0.14660427453676667,     -0.066643333725839721,   -0.085428702132341883,   -0.079429697674462132,
       -0.087195933941398199,   -0.023558739995708677,   -0.10895979598240893,    0.014657701460145675,
       -0.08478998032640489,    0.02382059338958227,     -0.08071133123656947,    -0.053349646516924643,
       0.039621966158293581,    -0.19403857677401776,    0.039079066316774214,    -0.17481374561846758,
       -0.1678867949904771,     -0.057224780319054439,   -0.11626696225948793,    -0.096124295504914192,
       0.15154205746659064,     -0.068850787852280174,   -0.014190248765256642,   -0.044277911737652782,
       0.031014228587068964,    -0.073254544686326487,   -0.19559033649190014,    0.21139369044198739,
       0.058507086050897286,    0.12629270224901432,     -0.11920801017712472,    0.025696010259138865,
       -0.017475962825732778,   -0.075334073023300641,   0.068483972249622257,    -0.012562109438982078,
       -0.19415835211073332,    -0.0065204808345665742,  -0.012476171579127086,   0.18865874654339976,
       9.18944331556662e-05,    0.19531702932473261,     -0.10437795680220334,    0.11913327060474498,
       -0.066896876831044602,   0.022802343736986537,    0.15023689522770589,     0.1246357858910825,
       0.0096943965182189132,   -0.12417334070906297,    0.022465094933470969,    -0.016955282644057462,
       -0.089864574053706625,   -0.10372455653306827,    0.14804884516784014,     -0.001797647645144027,
       0.08729329670048093,     -0.022322516929930755,   0.07976050089220707,     -0.13078994499575941,
       0.10305019733119103,     -0.03427385712136171,    0.15031045757034997,     -0.13047608504735858,
       -0.037809010283425232,   0.16241727254194729,     0.063560224046068509,    0.011728729711225343,
       0.00019390326495781745,  0.070071081856322506,    0.059837737122280375,    -0.16982837005594864,
       0.14534656407665014,     0.0083445429059350699,   -0.093168806828184,      -0.026188858927731366,
       -0.056860499258225276,   0.085093899860406483,    0.065373389132671336,    -0.17978219868298737,
       -0.029838318573764362,   -0.058851958211670913,   -0.049827079197031353,   -0.023148024934688833,
       0.050263383652481883,    -0.02088184983515462,    -0.0089358455256605112,  -0.083015280989621729,
       0.12698050940637001,     0.065327251574270329,    -0.05249487051573775,    -0.020939034162913907,
       0.10626083573719609,     -0.046671262560362733,   -0.092551715478732602,   0.1911371289844,
       0.11286032293883141,     0.14772384470598313,     -0.070714181717274741,   -0.099033704954603216,
       -0.029820938040805132,   -0.051043643156173248,   -0.067963088787352841,   0.053787109820506641,
       -0.10147591185925063,    0.016102659597232279,    -0.013679813984346872,   -0.18939411681357077,
       -0.049606378190746661,   -0.13499798776381652,    0.20479870805283709,     0.15366404333545075,
       0.022261128668995628,    -0.084242873021871029,   0.23561974578994613,     0.09501467891761925,
       0.04725794110419327,     -0.043320647871400046,   -0.081624981042580411,   -0.044904972719195309,
       0.1009933758419795,      0.083909045221937276,    -0.061059224176347043,   0.13471353955618168,
       0.16976485286799492,     -0.0043126928322543435,  -0.042172397540499902,   -0.044090401579300595,
       0.023762986578766562,    0.14323162325580627,     -0.19443146775822526,    0.020488464810461123,
       -0.017476945844367497,   -0.1465957197779022,     -0.062013541889566759,   -0.09358722538228785,
       -0.063758507787366692,   0.055212896337818416,    -0.072810625183718503,   0.18852780842094,
       -0.024962021000488568,   0.14095064325445592,     0.078793711677745723,    -0.041220095730987269,
       0.026173345806017788,    -0.0066702289596782963,  -0.05818403095365951,    -0.035554120158447867,
       -0.093785169499703197,   -0.024643732329657771,   0.095068354642833405,    0.109534158872978,
       -0.0042961616236637228,  -0.1553716352146281,     0.041812622839906576,    0.076357072333495035,
       -0.080536115353445875,   0.10454552224743113,     -0.26926428865813945,    0.027513247378399629,
       0.029680007421431558,    0.11596386434142725,     0.10494377102060944,     -0.0018399888345776729,
       -0.068302662651272883,   -0.099105171020649779,   -0.19701167966197516,    0.10162177344532643,
       -0.16913291319182905,    0.018720864724178461,    -0.16193483596006369,    0.082177243990954274,
       -0.13270148620816269,    0.089144795904289545,    0.062946798875143969,    -0.15090843362647552,
       0.01918216819504566,     -0.11018122103548934,    -0.055745933796241508,   -0.060030315815032854,
       0.037552803573166482,    0.13073680116608929,     0.096564163784566726,    -0.010335386589528973,
       -0.054956184519250072,   -0.12956685705966969,    -0.14867099737804648,    -0.093084601284447871,
       -0.25022831275812879,    0.029118893918088334,    0.17008735830152016,     0.14959543374289494,
       -0.029778879929349945,   0.057718360811438815,    0.09371750680423574,     0.049885035777434139,
       -0.017311115207877495,   0.024258815412603073,    0.02518039531001999,     0.055793327926639324,
       0.031309744454317105,    0.25665870504242921,     -0.067286641081351822,   0.029934603616233624,
       0.016783907765008273,    0.011501698128109004,    0.052605107128529685,    0.0067790639398782127,
       -0.060816613450006024,   0.13675398346166795,     -0.05345800075732525,    0.04687774031676803,
       0.19497309509432445,     -0.17293660663422894,    -0.011769471092967172,   -0.041694478750802962,
       0.0031289418325710161,   -0.067339231864339308,   -0.10854704633042203,    0.04569560677342531,
       0.02977315684823157,     -0.076083790134310353,   -0.03057987701519161,    -0.11567208645546094,
       0.045696734514812425,    0.026312853859841417,    0.10823279285365246,     0.0043901480409721206,
       0.043469648833230103,    0.0097419985065034902,   0.17981220375636031,     0.10962180844172564,
       0.11637903449845431,     0.18098521123021091,     -0.07510656694776377,    -0.10595236177452765,
       0.0072322478994666685,   -0.081445553629389128,   0.027363244821985266,    -0.063268136768707933,
       0.069383242671486933,    0.0015514647787942329,   0.17125042317426856,     0.0069394818765808651,
       0.17850082103997958,     -0.0084489129885620441,  0.039100260985640505,    0.060228388120305655,
       0.0097970298524063543,   -0.046663552079174976,   -0.0073382067581652197,  -0.06438194042595867,
       0.079589589001716129,    0.023478358687315879,    -0.035234139253365708,   0.18597217062947985,
       0.050059472283572035,    0.01906102268338138,     0.14655706924515519,     -0.022061980449165214,
       0.012409625493439106,    -0.099671950933719111,   -0.033291421083763283,   -0.023564631783438164,
       -0.068097606436264363,   0.037469606392486469,    -0.26460362431645668,    -0.052887582428099121,
       -0.15763714934810313,    -0.035673156871235526,   -0.095132896770187284,   0.081062317731113567,
       -0.09096799486039478,    0.17948820930747236,     0.012980109950647748,    -0.25392982765396804,
       -0.04044793565939854,    -0.099573682636905414,   -0.20969665901048493,    -0.025783422463708742,
       0.13082547143604256,     0.068437295487906474,    0.11865754853916965,     0.024313988585290758,
       0.11534549662816319,     0.023737245664343189,    -0.11337730714079468,    0.10461488668579765,
       -0.021293938091343806,   0.23318780615490084,     -0.075652459722552537,   0.043005086313865251,
       -0.067447257713108735,   -0.035754595706459946,   0.053597258848905094,    0.15188390997379395,
       -0.037716479972456286,   -0.16256588513930731,    -0.14197570431166376,    -0.096607521672653129,
       -0.08576531894107238,    0.095038205615983057,    -0.0773868698404101,     0.13637625117130511,
       0.0056418225793449378,   0.09718557926862692,     0.093761909412149638,    -0.10111372040455764,
       -0.059893024837621385,   -0.021344696171379272,   -0.039557358503226878,   0.042641052035696993,
       0.088043945494406722,    -0.054050825410518831,   0.029934449077602336,    -0.086390120272406293,
       -0.13950835934425104,    0.10416014855133107,     -0.047527202055380018,   0.016723037288197014,
       -0.0099356667232455911,  0.1108456461293801,      0.0093205924078379725,   0.068394458607710443,
       -0.092379996981391044,   -0.0093672761284358808,  0.12671868258300489,     -0.029258610797086103,
       -0.16440908565796775,    0.016083674605933469,    -0.0085549518192706824,  0.10400813925555945,
       0.086869971337587212,    -0.1461309601015042,     -0.017486885851683016,   -0.062928721734925974,
       0.059931182192065294,    -0.16189726659821649,    0.032385679492525112,    0.080213800806787569,
       -0.1498561176901313,     0.15973390198080883,     -0.19990967895224004,    0.021084859883329109,
       -0.14079349415930159,    -0.075402647119805877,   -0.10088049913952532,    -0.095475105176600572,
       0.17650711116170612,     -0.063767086245901647,   0.20660253386451266,     0.064260304590329914,
       -0.035234404616037093,   0.16738941679381827,     0.0099042447432223599,   -0.12397089065840461,
       0.062187337658357891,    -0.054663210665135756,   0.1667880309927752,      0.10594432132629703,
       -0.028365319414067398,   0.060218687291869244,    -0.06496100564822703,    -0.070799699344870209,
       -0.087510072457788732,   0.083173835252261671,    -0.013473651907155288,   0.10361256913171263,
       -0.21781216410170043,    -0.062362033956020323,   0.0013155341523032812,   -0.15622780774013137,
       0.097598191110519053,    0.0160378043706501,      -0.0018082507655757555,  0.094414784879292557,
       0.058925466999158023,    -0.015903842701995283,   0.042060420684028169,    0.22209438161566575,
       -0.076606757959766084,   0.17539126276833944,     -0.058423390657523291,   0.032300700925707894,
       0.0067131283224692315,   -0.06109950435767228,    0.16023093213515741,     -0.084053990533658668,
       0.03969895516462621,     0.026968025926391248,    0.035378609147876675,    0.1405589656338341,
       0.24440047461480871,     0.0011280864602520174,   0.25852884426179634,     0.083117882433108747,
       0.084353077410561458,    0.15141033627869796,     0.0028331598909261679,   -0.056749495081881679,
       -0.086449380903761155,   -0.13254489225178287,    -0.13993848657972677,    0.14700192011128776,
       -0.051307456434153,      -0.13364082249382975,    -0.02737615361953126,    0.064478858841973893,
       -0.0397919742555672,     -0.1321076904453686,     0.054206510305011606,    -0.1154780202929593,
       0.094127857147330712,    -0.0089511482002191788,  -0.0017285751186111656,  0.074907456164499883,
       0.014806396306051392,    0.13949945335901337,     0.14760326977995686,     -0.034937630170721198,
       -0.024115888346275274,   0.13113999430905354,     -0.096364226058744798,   -0.10509570652413969,
       0.031779128652048516,    0.048259594063877698,    0.12247451054027116,     0.0013635138409664686,
       -0.12148620110657986,    -0.0080450671293256226,  0.065337579079626104,    0.19047566603913008,
       -0.15535506058267373,    0.050096480170055413,    -0.06353488650874109,    0.09872001581317566,
       -0.081706739236004466,   -0.023894155171848619,   0.030594122491036678,    0.13578399816874992,
       0.096542188217170602,    -0.082730487127037899,   0.075765994037938919,    0.085952014827889889,
       0.0019012501760726098,   -0.020846575339212713,   0.062828700427400797,    0.076326841541986212,
       -0.015381302805357093,   -0.18757895041057351,    -0.069121516926811802,   -0.025903417768949999,
       0.23999263210466537,     -0.00024768815588459953, -0.073479858187058947,   -0.0025964180036107953,
       0.0086208933416341699,   -0.041730030977153082,   -0.026623287003133142,   0.10510089673955088,
       -0.017861085232927214,   0.060640153971476422,    0.015279486320883266,    -0.10579667595941514,
       -0.088119487529595447,   0.044826632088935794,    0.0886948383061337,      -0.12364659230691313,
       -0.117631577648069,      -0.10151757491250107,    0.092887586905622987,    -0.14975882791731279,
       -0.070751955722619608,   -0.13062667130807779,    -0.20753461295608949,    0.16317699771400709,
       -0.040330139653861133,   0.057059038003329787,    -0.057594040480445245,   -0.093884368903902005,
       0.23698284433344324,     0.038764659399888671,    0.0067559454114169875,   0.079261369698678849,
       0.0016108142266774376,   0.055278271212222931,    0.047099887451279056,    0.045845553810494037,
       -0.0023140740142320445,  -0.02940965137305342,    0.028266614268984625,    -0.15505131510990697,
       -0.0016334222809876995,  -0.07855378338982387,    -0.052559103176357001,   -0.023609328919299292,
       0.021376231848999856,    0.18583367020259947,     0.082106968412831285,    -0.02156290345188433,
       0.028688398096995978,    -0.062399691128837219,   -0.074251658678752705,   0.016035383123438815,
       0.05288808426794836,     0.0071380341140926413,   0.15820862543325273,     0.052127647931139595,
       -0.033154808143806509,   0.081433236761050742,    -0.06326560389381429,    -0.017145336072335555,
       -0.023622302706459822,   -0.048667906652244422,   -0.18466436135698858,    0.023843772477732027,
       -0.018978203392203626,   -0.013667586773899848,   0.043738225520962445,    0.081817984660271265,
       0.18928556768306976,     -0.15020489066839793,    -0.027052830634315999,   -0.18828826055156969,
       0.066662648320467241,    0.19022944897354202,     -0.023452079221540866,   0.016042353238015474,
       0.20925245087516436,     0.063957396151658436,    -0.24560795267999264,    0.16953281643111481,
       -0.029362019698285946,   -0.08568762592877438,    0.1502287771081649,      -0.16871032511543937,
       0.067317406694057724,    0.08649799450446484,     -0.044809236885573603,   -0.017780867946430145,
       0.067999100281208424,    -0.09058627609516319,    0.019994945311777888,    0.012330834399749777,
       -0.1506802473337743,     0.070895005388442595,    -0.0096740615378060474,  -0.16909147955682066,
       0.14445976389340304,     0.027375863880327422,    -0.17199700201975535,    0.011808786495226105,
       -0.048648273924713978,   0.015381132487647553,    -0.10010144359597337,    -0.0006580545265002344,
       -0.038697575190653533,   0.069745342880332128,    -0.07197425981533967,    0.18292899293148457,
       -0.19682371848529731,    -0.019338528576434182,   -0.10602928754056357,    -0.096554113062209151,
       -0.094748338642654889,   0.058163224599225433,    0.064350145934006703,    0.078881315563325449,
       -0.20785054687597126,    0.045642395829118547,    0.16520046512668279,     0.099908172595903025,
       0.1372982625019584,      0.048197389306543936,    -0.13203541860239335,    -0.075944388744744351,
       0.028354308790378965,    -0.12314704536009823,    -0.003923501790882359,   -0.027449617470111438,
       0.097670165573981879,    -0.11334100221835454,    -0.10957911253120164,    0.16741665515425214,
       -0.083184637879726728,   -0.14414479422326321,    -0.021669770463392787,   -0.21334138922669607,
       -0.10563230285188435,    0.077027896478697039,    0.031441702520094289,    -0.25471652444864978,
       0.12877578011343338,     -0.13630355614000342,    0.097198658399805862,    -0.031957463078259696,
       0.083166913841898171,    0.059283396308974112,    -0.042652628678713563,   0.014619756088018358,
       0.035159436474626798,    0.13080570077096798,     0.083428028145021302,    0.033974724524262381,
       0.087967979710319083,    -0.12641828570889463,    -0.0057040129376026219,  0.046029217224852835,
       -0.22532588783974491,    0.0039456617825252942,   -0.021133100166735357,   -0.139733778798703,
       0.087343402611708976,    0.12518004264954402,     -0.070174442840051893,   -0.024257039533278353,
       -0.014205392217865992,   -0.033604359889888788,   -0.06014893646259141,    -0.012872861739881175,
       -0.089751349058288063,   -0.036030134828649099,   0.081559184095589168,    0.14054936353769684,
       0.10349298683029708,     0.069159175241818083,    0.030559206929065705,    0.0055671606404439572,
       -0.061448780558626778,   -0.021015807482046778,   0.19437701043827907,     0.078730830889946785,
       -0.14781834184056483,    -0.060730370274278911,   -0.09296125601729173,    -0.019964451643448004,
       -0.13562669245287912,    0.12150962795008917,     -0.069544668389425121,   -0.1838632449988831,
       -0.016478164109870408,   0.017118660213155334,    0.03256039779092669,     -0.097200772221407036,
       -0.13255425910732818,    -0.21503304758051611,    0.042103509050528676,    -0.04200194218646254,
       -0.017188916785368664,   -0.00024931793964383067, -0.12091221142903778,    0.043475085760594508,
       0.049258289249760785,    -0.094816657165730595,   -0.023985904015361624,   -0.1098858658865248,
       -0.15000704291168987,    0.077848474474502993,    0.041287146449274892,    -0.1720143043484601,
       0.1406975871600607,      0.090015801951781715,    0.0031945459830933515,   -0.088763099442119978,
       0.051078506178838932,    -0.0062416406074447574,  -0.057585586353990595,   0.16065285986389996,
       -0.049542394842749006,   0.0072077109886504176,   -0.0026286492361016489,  -0.082677716660251366,
       0.10546349838047969,     0.040405375036147946,    0.12054713690196137,     0.004413630394670855,
       0.24117276876729196,     -0.0038638491814072702,  0.098023133224268102,    0.088740286860859496,
       0.05524065608304396,     0.077570278778890403,    0.18906855635061071,     0.071876107944982046,
       -0.13697023351293117,    -0.040164342274289028,   -0.11831104685277569,    0.20755803208914925,
       0.097387073447505898,    -0.004204127459382789,   -0.027501405992835633,   -0.089916163231553312,
       -0.0027341568330255805,  0.024503840879717399,    0.020960258236368379,    -0.020096560711631219,
       0.059296907285545847,    -0.053534414187280874,   0.20742493670800563,     -0.18958046768549158,
       -0.07292350937391523,    -0.033151225804935985,   -0.0069246126867625775,  0.058547542585873191,
       -0.10574834282779869,    0.040179680816664551,    -0.084363679164075139,   -0.079128196452696933,
       0.034516424617826329,    -0.14788813809922066,    0.088601774617030962,    -0.065912491723229688,
       -0.011933718755579834,   -0.17411690029540125,    -0.049432974242562579,   0.14639355354810146,
       0.017990128103593309,    -0.083910553691382214,   0.0034696914354863731,   0.066253745211094561,
       0.038402019464857939,    -0.088402738749508436,   0.10656106917440315,     0.05919083797211673,
       -0.0049261195044483924,  0.19096036958111867,     -0.033643050546917672,   -0.11233313524876257,
       -0.10415523774116364,    0.036367743350740916,    0.089959542013577601,    -0.054911372966283935,
       -0.11024563949726211,    0.071707926929213905,    0.17259297047358033,     -0.11091327257470389,
       -0.072922880600968035,   -0.0031873637162394934,  0.12323383127992513,     0.074589196554435133,
       0.040496585880333918,    -0.052838016362083545,   0.056447157185131533,    -0.045177626222825382,
       0.023130009234620958,    0.025591208328578571,    -0.03608121645435064,    0.13539716709624638,
       0.010628080398490069,    -0.058020597720187653,   0.057681243884538096,    -0.25107574328472942,
       -0.05753511762230909,    0.0018822853874863681,   0.018675089427253804,    -0.09311932866288955,
       -0.34037534027035943,    -0.073298023218558106,   0.10912793086635481,     -0.12876796097696624,
       0.09335664552351218,     0.031715377125713297,    0.15090428237954501,     -0.0062551123052968869,
       -0.012507414615904841,   0.13317917348088451,     0.10709657275037021,     0.19509740354000674,
       0.065637199716571101,    0.10126708951616309,     -0.024719095240412714,   -0.065453852719559488,
       0.0018962653174446377,   0.12662525518972953,     -0.11495878215636457,    -0.077113912538343474,
       -0.13543994597731357,    0.036734149317155816,    -0.078102905622775221,   0.063842623346144003,
       -0.098423189316786966,   0.047405752039981583,    -0.1394163534488983,     0.025543506491437374,
       -0.057200608020800472,   -0.012459142256451299,   0.0094448853594494495,   0.074420981032773378,
       0.04042602353359831,     -0.063980645670871097,   -0.0027474443338222515,  0.0083479726740328924,
       0.11165088385868731,     -0.095685540485098877,   0.27675599456732064,     0.083674142258932133,
       -0.12693040924392116,    0.066902617722863794,    -0.060141817686762404,   0.016049398341460006,
       0.11643241389978481,     -0.040995161305471796,   -0.17886588355851335,    0.097474177051757357,
       -0.1009654507991303,     -0.0030141749664469057,  0.1585035800932951,      0.016473432265888995,
       0.065030611296019919,    0.17990217578327666,     0.12685652316810772,     -0.019456442060172833,
       -0.018017441684226313,   0.08900957070434376,     -0.051370907169714111,   0.022611445800345294,
       0.10674584270642412,     -0.040097670554617493,   0.18468866483407323,     -0.13370906524039416,
       0.0077655688464696084,   -0.028590582660058015,   0.075833204039722532,    0.070145443292920884,
       -0.0093991404016360112,  0.13913940269443698,     -0.10575860922433625,    -0.076997563265829683,
       0.0091862260143185381,   0.28114468679527649,     0.095289479101974522,    -0.14680223909700257,
       -0.057667152477875537,   0.090746735855001148,    0.091690432250142992,    -0.016331794191469073,
       0.17334616493361435,     -0.059140118243845026,   0.031742376724920342,    -0.054549637770031183,
       -0.066769425408850683,   0.15500276097255783,     -0.09251836733019346,    0.10728342365609636,
       -0.17634157277275966,    0.0503212359512938,      0.0027408011903475938,   -0.0063774049169081949,
       0.043769527059591452,    0.049281046648138517,    0.0049875940231242956,   0.019163208219383547,
       -0.13929647904399822,    -0.11363315245342372,    0.010167260245723776,    0.13351028806599533,
       0.1232795705901919,      0.07461094895720842,     0.15331877736723659,     -0.19315417206508825,
       0.050394179823870018,    -0.021291270382281152,   -0.17336814899627195,    0.052151177138488262,
       -0.077975991886801169,   0.019189653657825979,    0.03902751561632703,     0.078886658151778838,
       -0.0046780657810338968,  0.031213368508774205,    -0.088278799652233578,   -0.032225536858874006,
       -0.12075118338906138,    0.11959316019816874,     0.10781686239675646,     0.1485902858483826,
       -0.082039321859253209,   -0.17447267495759894,    -0.00034215814646897536, -0.087649627470168481,
       -0.11891805183224964,    -0.069565249647868893,   -0.11472840829441663,    0.13026427729601109,
       0.1490629702061996,      0.042124148450992882,    -0.12343371007837045,    -0.12467678250212882,
       0.10236598394598827,     -0.022392209031602012,   -0.047730213208079034,   0.017585162469819813,
       -0.069039698958447734,   0.14609955161769478,     0.072767527427338607,    -0.0069139027219341544,
       0.11353043157332146,     0.19315631693356819,     -0.16331606547714,       -0.17821031392818745,
       -0.064650353543045214,   0.049299547945721334,    -0.095209496980505806,   -0.22791073486253124,
       -0.003962059208815991,   0.22260236093068814,     0.0034834547602626701,   -0.021033616917017293,
       -0.097560724546213451,   0.055868052817772143,    -0.082403956681152912,   0.03234433956517218,
       -0.049126170795032231,   -0.063623629963930603,   0.023067897642573505,    -0.066903251771588471,
       -0.083144298665189659,   -0.053822816099848868,   0.15201031239904228,     0.24563520296468075,
       -0.15739153344108803,    0.02314914541162081,     0.10440206051935132,     -0.049146550470430886,
       0.018385690248493694,    0.070893819721407653,    0.10377137726713113,     0.14724321021868053,
       -0.10543262996935805,    0.043725581267172478,    0.022377895238245727,    -0.13500659558807113,
       -0.089879390224319955,   -0.062050053885026747,   0.0017508848561978438,   0.010738865829316286,
       -0.020896532211883638,   -0.16043235569965331,    0.079560559482385051,    -0.076046240470272017,
       0.074259481135175318,    0.12349759139917033,     0.14281598172727941,     -0.026251500525596924,
       0.042115639059464041,    0.075087519360624785,    0.0032306382114461836,   -0.068944844122178647,
       -0.037030189045250295,   0.10984476261492561,     -0.015005748431362336,   -0.070225543257172493,
       -0.042720503840512646,   -0.00015756917209503306, 0.071444081518589428,    0.24351652861389642,
       -0.080417621673018497,   0.009994414450895224,    -0.083174425856056333,   0.041177004171864443,
       -0.070772551868071937,   -0.077111073876423811,   -0.087831990548126987,   -0.21060380938301695,
       0.14923592576024317,     0.15310754890451192,     0.024816442130959172,    -0.019812771848578818,
       0.00018785095292686072,  0.13297428304767767,     0.019915365485376937,    -0.087338147132150004,
       -0.078516625908688895,   0.022888462777517708,    -0.096821263085837772,   0.010328556074264743,
       0.036873931068420379,    0.066039511482880148,    0.1618179590618388,      0.059471126391903946,
       0.065880419348380237,    0.1142082756875816,      0.068704266408090645,    0.0156029506646818,
       -0.020733984355350905,   0.06841133865467483,     -0.021282957302506116,   -0.042219598637884541,
       0.054606451570811204,    0.013165426111871003,    0.12074934953208558,     -0.10908427116897089,
       0.0013515351634028109,   -0.1062654288232279,     0.27759957668969898,     -0.035192743076686447,
       0.0051659669705263617,   -0.01189710723655427,    0.030184243328533915,    -0.065197039827484662,
       0.11780098095757369,     0.097812594178996237,    0.17615596580534562,     -0.10346902146740307,
       0.078938455100649452,    -0.17072714600943376,    -0.10555206284787638,    -0.080972282278800059,
       -0.12500548755072635,    -0.12068293886339543,    0.1708801678461625,      -0.081311823533526534,
       -0.062550713769080613,   -0.090624387247748781,   0.0038178068750337815,   0.18852738136781641,
       -0.10323676304064192,    -0.0062548465656567,     0.040180903775769439,    -0.1456591935249468,
       0.058181674153343244,    0.12568181607887613,     -0.078154955579728749,   -0.14657782375516226,
       0.06772016651597787,     -0.13867376718359242,    0.14590586839488306,     -0.038155868883694329,
       0.049211871752746328,    0.058517223461528892,    0.067979368674203941,    -0.12756656372217703,
       -0.076718012386680204,   0.017575482645477966,    0.13514160486703658,     0.055628035587539523,
       -0.065487849377972557,   0.048689055315344509,    -0.037823835488348889,   0.072050899834033982,
       -0.08929979264604615,    0.14259705894758501,     -0.14156361843548748,    -0.011718471667202506,
       0.13337774344575684,     0.11179718241497122,     0.017249434223342078,    -0.095840597786149534,
       0.061937678904296641,    0.054606345821405222,    -0.14409817290715982,    -0.087292954775018652,
       -0.084042850818546261,   0.18882890952623019,     0.058651503736791649,    0.096211023921142114,
       0.14766613563720812,     -0.012048230554932458,   -0.12879204927010601,    0.078041478360063782,
       -0.089055935549411505,   -0.11041846539329128,    0.092791826474148298,    -0.0013373341191372408,
       -0.0027397108534395823,  0.0042299794556356317,   0.098253594874447417,    -0.14665430181113348,
       -0.0055348557351422231,  0.038582379705709574,    -0.10553680269927626,    0.094417042616590952,
       0.080409953743397947,    0.2214613278725294,      0.12457512117792438,     0.0274331389481276,
       0.0691115423370397,      0.061887645228046816,    0.031243616338742057,    0.18167258382770779,
       -0.030654637747652903,   0.083360561118092841,    0.1147667907117281,      -0.11881752002549478,
       0.075299533234133006,    0.056147834997823248,    0.13056820526090221,     -0.047546698550671278,
       0.15655435751531616,     -0.085455118197987817,   -0.064422883746805826,   -0.16310626825643976,
       0.035871721847183458,    0.024423139976986294,    0.10073888870282346,     -0.057185790549241895,
       0.062632870000495749,    -0.057521766292686918,   0.092399774203308666,    -0.049636733984507742,
       -0.0069975359742342966,  -0.036752028497455312,   -0.0045877667653748001,  0.00064078039315881678,
       -0.11759054234537573,    -0.058022248167321815,   -0.079412703746103042,   -0.0052092416318761511,
       0.21331680315205678,     0.21185047759670822,     0.11770487110304199,     0.26250110997704601,
       0.096949247321838447,    0.15506388648205113,     -0.27522333528399556,    -0.0072204222754631339,
       -0.065087944663475394,   0.013668429800854184,    -0.12962273974127964,    -0.14084055580865415,
       0.018716232893770661,    -0.028353523510164912,   -0.026672775921189572,   -0.055725140797065413,
       0.090429280069159665,    -0.046840684004771566,   -0.022417612362549393,   0.077687435641625488,
       -0.048983194239887812,   0.031781316304975972,    0.020195417619073362,    0.0053566141231052161,
       -0.10682692778508039,    -0.15294028081128766,    -0.10450614764904662,    -0.010473756686043261,
       0.066751165620144437,    -0.14511284175039438,    0.071852233078165767,    -0.067706371985975525,
       0.074372679012362428,    0.18056046341789053,     -0.063295667048065787,   -0.095851729207826156,
       0.20024367256805178,     -0.099688874685142745,   -0.007408776455016323,   -0.030787001343659214,
       0.10151356911733056,     0.0065379110775634422,   0.10322796939252904,     -0.06581104441353576,
       0.093744669299166486,    -0.12940107724518585,    -0.19607560760186138,    0.125587066918594,
       -0.101942204114427,      -0.032603941181548184,   0.054025956458733856,    0.0011795976608736931,
       -0.021307140427013035,   -0.044863512265711933,   0.08121875288309903,     -0.066628832717313471,
       0.0033566137209179829,   -0.03764005621566107,    -0.014979545707065051,   -0.055703793784852115,
       0.042175450771258886,    -0.16423972107959042,    0.061742023297597273,    -0.11842107949609779,
       0.16229585728916129,     -0.011409280633513909,   0.01279348468738368,     -0.2012791178298042,
       0.013122313270371546,    -0.07297883529049104,    0.16139480169967882,     0.0016880754705233432,
       -0.1551518739046121,     0.030407794805864648,    -0.025787808106181274,   -0.033578205997536491,
       -0.11720213782567186,    -0.030886366980548443,   0.046208807786501556,    0.017532764517759227,
       -0.10667000074388219,    0.075232237885616518,    -0.11639726011396356,    -0.11544280560343018,
       -0.074210566595334815,   -0.064290950242097578,   0.066305036317610908,    -0.11921847283658292,
       -0.08890198121364111,    0.19533619491185003,     0.016395789896777785,    -0.067082690481383073,
       0.23031731818783019,     -0.19775467850179476,    0.076892151409379661,    0.0036991254214701376,
       -0.034794472992195499,   0.0088911824289548518,   -0.0072093877669860851,  0.057424806065472636,
       0.13399199333880568,     0.14071733908968589,     0.15932168306886774,     0.081806282863429239,
       0.034433566661211792,    0.09193034427019621,     0.13454409185540162,     -0.055063113760224838,
       -0.043713831334636799,   0.072565794830556113,    0.00051222526202944485,  0.055745013714134838,
       -0.046880132114589551,   0.18148953966967182,     0.080221665875496714,    -0.080960490707674124,
       0.080132414232459218,    0.073153793748703067,    0.11555912747591349,     0.032596297356394591,
       0.10515407178960372,     -0.19689280102288206,    -0.040979035862696661,   -0.12375531125306248,
       0.092580556251315407,    0.13319063977970705,     0.080152676004847379,    -0.10316010126521734,
       -0.20593489953048333,    -0.18549190460503409,    -0.032453177745799804,   0.054428570195232083,
       -0.16126336262419894,    -0.023586212595465672,   0.076933980690034778,    0.05016092181688285,
       -0.074525021107951742,   -0.15046098589079399,    -0.16412556782424717,    -0.038535056729868934,
       -0.087142359480959039,   -0.15274436196526761,    -0.077562378953519917,   0.029943912695674958,
       -0.15556849095138928,    0.048188331522929881,    0.058786945131501456,    -0.11202036299099111,
       -0.083762583002087471,   -0.033630937991957321,   0.024642440855624066,    0.025817760201493557,
       0.0089399296944334284,   0.042011409950994109,    -0.059178250569649898,   -0.060243048242188769,
       -0.18703960811997611,    0.19214166408259553,     -0.15539899248982997,    -0.098382667364398504,
       0.10708126499827511,     -0.067954521680756122,   0.015706661958638162,    0.043703693315234118,
       0.00061964850941515805,  -0.070072571195099825,   -0.049010211545346925,   -0.11547731806273692,
       0.051381785807046929,    -0.041121434568389431,   -0.013558604005604272,   0.12095109155649626,
       -0.015814820503740237,   -0.057946394063110869,   -0.024482301968856805,   0.13235080183370393,
       -0.056916059095069971,   -0.011670122771113817,   -0.084263348081486361,   0.12722073627188327,
       -0.11168071329038716,    -0.031755094123774787,   -0.026847030483575396,   -0.14686128114988087,
       0.14964260858275671,     0.072224546203704859,    0.040120944923050739,    0.12388523410868268,
       -0.19864370219646943,    0.10264848065171388,     -0.030239903528998028,   -0.046518551857221084,
       -0.097965230134826886,   -0.093803634185704823,   -0.0096190781119406023,  -0.059916566191859214,
       -0.081077054612561358,   -0.066038529523603631,   -0.020985214589784501,   0.18721636114338752,
       0.1935226546413189,      -0.070605758693149404,   -0.019522718695729382,   0.065398129247263556,
       0.14629939583743856,     -0.019816239555668684,   0.11520703316316894,     -0.055482043629004725,
       -0.056259956503903474,   -0.10433051298083776,    0.1269261988514461,      0.10448108386810387,
       0.016608134136966643,    -0.14840184520880786,    -0.016578301242011619,   -0.014961172008700972,
       -0.040430866605903219,   -0.029625835378040213,   0.061716149518857968,    -0.004729667903107828,
       0.085028370012724064,    0.045428523680825818,    0.054779405121710173,    0.073237327567386032,
       -0.055804153491623071,   -0.12427484678867766,    -0.035795049439085798,   -0.078500285956167051,
       -0.0030215994944590794,  -0.1290374199336472,     0.039412757336945534,    0.10508930670009789,
       -0.08370817199978671,    -0.022067770397355135,   -0.20494464605161364,    0.11780423277768365,
       0.055270661868231749,    -0.14624742045317909,    0.053329452311637347,    0.13793943670562189,
       -0.07096000145131659,    0.057255006835942444,    0.040507283052061575,    -0.11984078324399228,
       -0.013060744867634644,   0.2023045336219671,      -0.11055412070652615,    -0.036986930652159584,
       0.017234920241164953,    0.201427823428213,       -0.12974103567227968,    0.038089117725679869,
       0.16849167020669786,     -0.22343602496011569,    0.013493808998537396,    0.00085812966493548949,
       0.10869224980465562,     -0.2517732169727333,     -0.20839198109781748,    0.0030852916058046638,
       0.011857238886649463,    0.062143702072653344,    0.091297608911401151,    0.097197979731207002,
       0.12287310219313066,     0.085542271652834581,    -0.049535509137632522,   0.098892736607257128,
       0.027631030998192578,    0.12544872933460105,     0.048327307001799109,    -0.032725301594376838,
       0.12278227521861136,     -0.010364502666469769,   0.09460095807557814,     0.036853802644188111,
       -0.021277577461960066,   0.027257609097920799,    0.075867527559156558,    -0.0053337401624773207,
       -0.11199855122930111,    0.10084325695022012,     -0.054810393187925563,   0.022527546520494716,
       0.1848102124422363,      0.075596735027409837,    0.093299766939719725,    -0.20105959866471476,
       0.046439938421947415,    0.218704981806816,       0.030687063129120271,    -0.1470751069382859,
       0.13908679809824687,     -0.048930344581527001,   0.12834942235720131,     -0.16530556442482477,
       0.062166391428818794,    0.014853724397251904,    0.058718822844271039,    0.12144814669296883,
       -0.022621818857373185,   -0.07345646842329133,    -0.16576515323711891,    0.027884984504488505,
       0.051941635490025125,    -0.060701700862819223,   0.035183670895594446,    0.15118560777975742,
       0.093345897950922685,    0.079456518463804526,    -0.041676093121462421,   -0.042018417352508858,
       0.02125348794406581,     -0.020873738001945523,   0.14910681482023347,     0.14411855682746724,
       -0.016673218350463398,   -0.12612975019116549,    0.041133687313113378,    0.048421382739170016,
       -0.052847156804715724,   0.0025892223375610993,   -0.054709717897716302,   -0.11724121852477809,
       0.064528543988930848,    -0.16453994442121295,    -0.071581949256032618,   0.1286750135777196,
       0.038146274032642771,    0.020944140820553219,    0.24981245971921992,     0.011126145307857832,
       0.0064999586404702152,   0.079944663188585022,    0.084618467319214741,    -0.16639539552855823,
       -0.012695492729773454,   -0.071725491594862911,   -0.013471424030517497,   -0.16512818105871646,
       0.027363632126961884,    -0.060010449512074925,   0.11202153951973705,     0.050341192084010236,
       -0.13090278941176847,    0.05564715410807064,     -0.19353904008494083,    -0.017690906808837819,
       0.06112001700056538,     -0.06101122784839063,    0.048151835719122384,    -0.022738302462985843,
       -0.060633485253277192,   -0.22751821700107219,    -0.01104259696498478,    0.11489179381285804,
       -0.06573489750085254,    0.026315290429638361,    0.039471141691036576,    0.17500452534987515,
       -0.015868835213259772,   -0.078354343097255988,   -0.13409206963692957,    0.0038040730673328006,
       -0.028137799406471403,   -0.069212309917607504,   -0.016049442085961527,   0.053294715862360412,
       -0.031096703717800725,   0.042113134069977971,    -0.22191399306850446,    -0.23447638481054991,
       0.014214451456988946,    0.035239854821396993,    0.17491300028626444,     -0.038512260494266551,
       0.011920054255606948,    -0.046103865567441275,   -0.051528374454251138,   0.13562640687237223,
       0.089276567716286864,    0.091793590786363649,    -0.027257347921850483,   0.02323650898661039,
       0.053984304126732281,    -0.16960054645604433,    -0.0049870672569398491,  -0.03817423865718645,
       0.013466384501093945,    -0.063291145445387345,   0.096372630128566977,    -0.048212894204990878,
       0.28316356319513186,     0.17631656198846521,     -0.092847069175114816,   -0.1107949951042564,
       0.16374990650271967,     -0.09486851504994484,    0.06744552570266403,     0.11286008888523708,
       0.10205881337787392,     0.0015546909532180098,   -0.0723280027672739,     0.023911215569130638,
       0.048629042306881295,    0.085957573992423111,    0.13606508531756478,     0.032793032335767816,
       -0.13513305059086567,    0.0039868481488664039,   -0.048084272460262811,   -0.011734972556543937,
       -0.15723699298802274,    -0.12354141193754718,    -0.14394260611737145,    0.11759769952623486,
       0.087295353506591816,    -0.071755846684136912,   -0.00061542250736271349, 0.070916125357054868,
       -0.058386794227522729,   -0.081631163200192744,   0.045752771991256103,    0.0057870274013082593,
       -0.25433834005797107,    -0.13552025535729123,    0.064614706807142305,    -0.0633510012361371,
       0.11671478122455055,     -0.1707200989697302,     -0.13076326845141117,    0.062628943284479863,
       -0.0079475442599320281,  -0.098427720878044508,   0.13811703475716486,     0.021051636310087843,
       0.11694222525744725,     0.14928259164071533,     -0.11968224218465937,    -0.11396977921895776,
       -0.064921595737646082,   -0.011879368259091567,   -0.012682772132042207,   -0.12142109281508866,
       0.011578637873796654,    -0.15974141276531489,    0.22256887207266296,     -0.014684639774148203,
       0.011721017856420829,    0.082489091358775635,    -0.0099244432712255158,  -0.05691690175491973,
       0.0056805556074154637,   0.083842260629546056,    -0.040529005042811872,   0.11065470233290539,
       0.12613128823253078,     0.043116812609345606,    -0.087246026754816186,   -0.034540163820049388,
       -0.13438340953464628,    6.4375528053887705e-05,  0.042890213330388192,    0.072449119333589496,
       0.055277212086047217,    -0.088555134544050187,   -0.12343681537737315,    0.21963346417431412,
       -0.036974549401362029,   -0.12261986988997822,    -0.0086930978947265328,  -0.066275106048790819,
       -0.10223923647947721,    0.020962342868874644,    -0.1310490016163911,     -0.27842315286386232,
       -0.21214421951994911,    0.17269291290338148,     0.035836836655869383,    0.12793214246670195,
       -0.18577213154995745,    0.066299447563547484,    0.092522325758496865,    0.041161984518904841,
       0.1016095230039171,      -0.02583963113076982,    -0.041487607874434701,   -0.058835894435947333,
       -0.092264665443698796,   -0.17431156776073059,    -0.10718459940691603,    -0.19523904261951103,
       0.037000919474967801,    -0.14358378716180328,    0.035420066212705395,    -0.08921086661567644,
       0.092724721145830621,    0.064951545116402748,    0.073547919711725293,    0.011497772695864045,
       -0.18376081196299485,    0.046844647423792914,    0.11315398694096038,     -0.13015951601737807,
       -0.059340901055191762,   0.0045893401414639785,   -0.055732085642997135,   -0.037267573298501736,
       0.16492963214503439,     -0.0038481735450008885,  0.067904658487155697,    0.052171344924654341,
       -0.083282528191728211,   -0.15016226081394674,    0.022130630901795137,    -0.21846766595750849,
       0.059802381167020073,    -0.02939578280019978,    -0.060020860268833721,   -0.11029029290492821,
       -0.22139761040096989,    -0.10517902904837763,    -0.025474876462094828,   0.11165026938944923,
       -0.11723118722637041,    -0.084347445188115724,   -0.0097176223149817303,  -0.1251350105535381,
       -0.025696773654771222,   -0.098442621318950194,   0.014369408324099938,    -0.012059638343063251,
       -0.044253077194750322,   0.087597889882142024,    -0.088904950678616729,   -0.17147821290718826,
       0.020252385621109675,    -0.067113345517729586,   0.089448543784126588,    0.057776386718407929,
       0.13664002651091595,     0.11341538759013318,     0.035881329993785793,    0.034638817790403148,
       0.05904666033437047,     0.043918138895418804,    0.023766845848204977,    0.019448119999114711,
       0.014113998666691835,    -0.064665359982087237,   -0.10007553468422832,    0.070665552730146852,
       0.057089077327133003,    0.089783187659270236,    0.06929859791985149,     0.020230323496331859,
       0.10920275532557566,     0.045585351327239593,    -0.032483968431140486,   0.015038623041180834,
       0.02567984982150218,     -0.0072942556833265086,  -0.12815097304159573,    0.084278819956177448,
       -0.082934730205816043,   0.012352442542389317,    -0.1542052913351567,     -0.051426103699473112,
       0.11918937646562357,     -0.19249511871327854,    0.0046125099706258721,   -0.089843030547447467,
       -0.056094036916231188,   0.014627827295106057,    -0.044897199418615641,   0.10215131760399428,
       0.098165115401310524,    0.12126367975727963,     -0.13282568108296594,    -0.11980964947966712,
       -0.053382873565185326,   -0.026501459916941725,   0.00036006860582822467,  -0.069845266850305232,
       -0.032683606545837705,   -0.18741250812923343,    -0.0089915339926438867,  -0.054015140366835232,
       -0.027553522721827022,   0.096523275279827611,    0.032997836578868373,    0.10847641500079022,
       -0.027380358827037127,   0.02135204667124195,     0.057154404004857953,    0.068427055608108134,
       -0.18181041718270091,    0.14051191287630835,     -0.019746122574533086,   -0.11569414115723153,
       -0.003507728839700539,   0.052635463129943764,    0.10883212595171629,     0.087906025797779605,
       -0.11761211233300703,    0.0088687253600085482,   0.060588415619077907,    0.29544808609772027,
       0.13597023208755282,     0.065857973925801033,    0.025204749023501997,    0.096127852544238127,
       -0.066772032576461887,   -0.17776264058914193,    0.028736127356250848,    -0.12256908819104444,
       0.024231112168136146,    -0.11672269487684404,    0.13634957412717866,     -0.080987960507019743,
       0.12397008363210718,     -0.14322884137226433,    0.053513605148748741,    0.051700293260022387,
       0.13931496755649569,     -0.048890333012927265,   -0.25631768378873721,    0.11086846137593252,
       0.13831960832250123,     -0.044455788096357092,   -0.019369184027041485,   0.038247800059438064,
       0.18963065587569813,     -0.096530684644537498,   -0.11902712003968501,    0.10344300794551185,
       0.027365655867291991,    0.027612403635349135,    0.0055188074207857055,   0.061779063798742526,
       0.0027194026622872798,   -0.074703608436327229,   0.046991030833059028,    -0.14131752736047262,
       -0.089252220349914313,   -0.040334268310444218,   0.050417971362414458,    -0.10298353694884001,
       0.031890775664783308,    0.037379883106963101,    0.021886665949402289,    -0.074052751877499989,
       0.072022511873721093,    0.085852636423811857,    -0.064433475717883923,   -0.046333418409661722,
       0.047787158450645503,    0.11139537776134507,     0.11012298590128936,     0.010557273883409962,
       -0.10294645747968961,    0.00058957186616219025,  -0.2926149288362595,     -0.0084381975055099288,
       0.22965514921163943,     -0.030332419854098749,   -0.12422431612462297,    0.053074528228349363,
       0.065018982460303187,    -0.079780833773207271,   0.045428930715957626,    -0.071988217107350899,
       0.040051406084926827,    -0.0025952628331269191,  -0.058799919603478031,   0.056307005015534789,
       -0.039132356983381633,   0.18616456443876581,     0.087510543064058921,    -0.017008522489093934,
       -0.036266351787870729,   -0.16598322091556564,    0.15671492122962297,     0.067852373601316768,
       -0.012560705293546158,   0.044016279320720657,    -0.0071009637977774379,  -0.064484643603769792,
       0.030432944084005278,    -0.018781931696692934,   0.033207136674212871,    -0.060160598548633017,
       0.19388321268987607,     0.0084652093915156493,   0.10956275601776516,     0.19346638349389209,
       0.077757692707682444,    0.0094169327693673158,   0.088247756101756211,    -0.16496442252397955,
       -0.0036331507848549774,  -0.17443822372619167,    -0.004101896584660366,   0.1276445256297479,
       0.016337734229590683,    0.18632467940078853,     -0.015931950353059315,   -0.001302876590808182,
       -0.12349098833210936,    -0.12547276610810942,    -0.13375026135694085,    0.030216414014927476,
       -0.13107930824270389,    -0.071491277643243881,   -0.16431561433631728,    0.029841683337032465,
       -0.071908618660632639,   0.024138400363930373,    0.038594534640970464,    -0.11436485546349597,
       0.055182721760520602,    0.038692538613885212,    -0.085031082315205286,   0.011517125914282065,
       0.018606442885213206,    -0.071649803678634383,   0.037826037567785041,    -0.1401075146710983,
       -0.26481545416783514,    -0.059901230036479389,   -0.012578948399141513,   -0.069956950729524139,
       0.18381217979055228,     -0.013521065668104086,   0.0068119988108928586,   -0.039949292978621723,
       0.018602573174668624,    -0.085522551661117774,   -0.07724991669800553,    0.081160706851803349,
       -0.18875087246978581,    0.18881119920479256,     0.090894260198880195,    -0.11444587198811663,
       0.029078524954417231,    0.098723624072276278,    -0.061771018967051436,   0.083265751662761872,
       0.23797724917798288,     -0.032722012422422501,   -0.076350072214032991,   -0.085303153023394196,
       0.11464515838713094,     -0.039456269799908884,   -0.16361676461486571,    -0.16797279629392597,
       -0.15895187569645952,    0.026306999753080963,    0.083868999832758792,    0.17274880238702653,
       -0.0067863723980768689,  -0.061834741985512386,   0.013196588651458023,    -0.096236281263456763,
       -0.078421153333375376,   -0.041242285677662541,   -0.029926540133863533,   0.096624368114445303,
       -0.13692160039554466,    -0.007271256875657453,   -0.01464598767596037,    0.077576990721295314,
       0.032983884851128492,    0.02211230943572725,     0.19147687408016884,     0.068050842719122595,
       -0.085103089265489817,   0.0027787360469955676,   -0.19619386808241801,    0.13581036769585347,
       0.030920540927244989,    -0.10679986392595844,    0.10222872866694717,     0.091969337717326266,
       0.097376750859950734,    -0.05645592471913162,    0.049785651804218692,    0.11062123738802895,
       -0.10239251209130858,    0.11710915811459872,     -0.005908530203744336,   -0.12535510025938149,
       -0.071546950276084376,   0.044134272861611763,    0.12488387450251523,     -0.0057858379079160638,
       0.086652381966997663,    0.0051435360479054025,   -0.19777203333168647,    -0.047000578997195855,
       0.080356554315096695,    0.055087367466642063,    -0.091590707183178591,   0.033987780463698131,
       -0.041982156538512977,   0.1743321986890676,      0.015747151649139604,    -0.18406889425768425,
       0.038685567453459677,    0.12791513831456303,     0.13629583725296571,     -0.060334735374142946,
       -0.051145450685128206,   0.040133022945593594,    -0.10161311986895109,    0.030352967404722077,
       0.17855009056055507,     -0.06863816094251407,    0.080955835733521983,    -0.044888822513466431,
       -0.1112778669469642,     0.13645220026083071,     0.0012591222174587573,   -0.050680918192591566,
       0.10024672860153314,     0.024536480234689035,    -0.057104799907673691,   0.00085554091134650706,
       0.037529536535167565,    0.20970522657107443,     -0.18508215507123299,    -0.077282373350888126,
       -0.08198982931813735,    0.11955921836861326,     0.16019581584184753,     0.093620131114279401,
       -0.072883136140321034,   0.073621481112916873,    -0.048496877144355896,   0.1676575538123958,
       -0.083387932495360542,   0.095611389865561808,    0.08042362558347764,     0.088715700201296502,
       -0.083020071128917503,   0.043880384939269115,    -0.087179708193894492,   -0.1395171672624767,
       0.037547775022194543,    -0.05780884698925564,    -0.04707898226534428,    -0.050773712674966311,
       0.032515001360107175,    -0.12394683792760777,    0.075949087072803609,    -0.12743117531437914,
       0.06370872142288464,     0.091326771925813718,    0.15765018568227973,     -0.043220391983749704,
       -0.067130484258876341,   0.064602470094266576,    0.074431020591966768,    0.010486926757532251,
       0.090110779071395419,    -0.15041581639801493,    -0.11046585121429284,    -0.20797667562744815,
       0.08723643164801137,     -0.19344657413568436,    -0.030181303398621854,   -0.084468938328645174,
       -0.051445007507923982,   -0.047815691989090969,   0.023581826470700784,    -0.078051247789307374,
       -0.013350128568456415,   0.097501346283153101,    -0.016822726604412117,   -0.067619444858433644,
       0.087084198048518385,    0.17361150915771242,     0.085496764824869842,    0.051077882062314575,
       -0.045826944053507332,   0.10183830178319768,     -0.060205592487526938,   0.034462233675661237,
       0.080164674279839948,    0.12765327822166778,     -0.025575989012510878,   -0.043724203127939551,
       0.016708642429883201,    -0.10593159732291213,    -0.0057403692426349334,  0.1176381909928208,
       -0.033708258441918257,   -0.005027327782297677,   -0.15267679122600725,    0.09495591951281053,
       -0.14518993451009976,    0.018439250478658232,    -0.10608999775573169,    -0.037811327276514289,
       0.10112077204261491,     0.20553058380186373,     -0.20524090075015305,    -0.03260115205116796,
       0.11997456363912215,     0.066879773545884619,    0.037976149798914428,    0.031889566070987051,
       -0.052117519783762001,   0.034660875135443997,    -0.12380588169699155,    0.03823899729006789,
       0.010997516744761257,    -0.037464171714896514,   0.039356998445289323,    0.093368645907577638,
       0.083440007246780357,    0.12259712134710593,     -0.23643758964941355,    0.071833012806545318,
       -0.0090388911000302413,  0.0077118547032211816,   -0.015840496272919662,   -0.083329805945685786,
       0.27298258253084556,     0.099227909626151342,    0.0079415027703269234,   -0.077843207927697874,
       -0.038861029678792527,   -0.015215967082449114,   -0.12366932282738996,    -0.091072606239794615,
       0.0097968984402900874,   -0.066928157536444155,   -0.015380062750223841,   -0.09192165849232041,
       -0.02618477659596467,    -0.13522361842922084,    -0.010814549327568609,   -0.11808690950292801,
       0.05393216271818338,     0.22394434122542589,     0.22462286286660724,     0.084355252504168934,
       -0.063430853223649913,   0.16368698742608279,     -0.046792375957155408,   -0.27917727034150791,
       0.13986329780549245,     -0.062713039783314814,   0.096171069454900698,    0.094182145200587389,
       -0.021714836328322561,   0.17543408853534803,     -0.069930397199662098,   -0.095190582728982773,
       0.055606651934374945,    -0.012398168004213941,   -0.068706630199414157,   0.0097556670482308837,
       0.032533147774323867,    0.038773111391649934,    -0.056619819893563565,   0.019203023236394615,
       -0.13356466832230138,    0.046443728602589211,    -0.12609522408246274,    0.17386748952839709,
       0.055348527878225098,    -0.12825378723561787,    0.068980631934486808,    0.13043813381643685,
       0.12782933600016039,     -0.0027513207792854068,  -0.10150144673404696,    0.055857068944482988,
       0.052751091743095224,    0.089158834064855363,    -0.020561903782505234,   0.13395214570031413,
       -0.20203752993800211,    0.059147556208213298,    0.02535537267482614,     0.098182549751156617,
       0.16816769655392097,     -0.14132283882096264,    -0.093556274687392263,   -0.12161084806594728,
       0.02261037181082234,     -0.072851088303548042,   -0.06221191596873947,    -0.058549850035614998,
       -0.19992814834169564,    -0.072757328891550149,   0.1630052288377542,      0.02531597684360036,
       -0.062795124123112653,   0.084226765237659762,    0.033730327208195236,    -0.048985429686588026,
       0.095029286382958517,    0.02561687092249244,     0.001783022370997612,    -0.11204814322825887,
       0.083245681476736624,    0.19528864499407939,     -0.1229098305700646,     -0.048344637682852416,
       0.084366230170264817,    -0.11928052170450722,    -0.025844860658876118,   -0.18712834642489029,
       0.16197396403913622,     -0.037248272269047554,   0.015619075249545793,    -0.013163101206243187,
       0.071049927556097764,    0.0062560666576021362,   -0.011955623384278535,   -0.14145816662613261,
       -0.046487412279035412,   -0.073955975158815412,   0.04596468832354423,     0.11047031247602497,
       -0.075175136635168005,   0.030743727722719653,    0.036814727219223402,    -0.010760131743237016,
       0.0074273051218892872,   0.0066498357861676377,   0.081242605315834285,    -0.092163183193114104,
       0.10145673597824614,     -0.058877350719553016,   -0.097106363726178591,   0.06514829771434838,
       -0.097296386512773961,   0.14696202498208091,     -0.17214034907518175,    0.098093869355607988,
       -0.052728169023359459,   -0.03378376961913835,    -0.10503969494471556,    -0.20467836995048677,
       0.02381859776396917,     0.14538566548345433,     0.12849424726266373,     -0.077649920431929711,
       0.10143713843888212,     0.044399456061133484,    0.041555149709118985,    -0.14261910327169364,
       -0.10431772161505772,    -0.11672719079441038,    0.09867171271836539,     -0.097960865789456245,
       0.096566954952961109,    -0.13769221458465619,    -0.043913629530770576,   0.11640569917470923,
       -0.046938740198271316,   0.20269039374095568,     -0.17978827450282414,    0.17686577031453829,
       0.024316759728775734,    0.023131001920505344,    -0.04502553993330291,    -0.046750561560673663,
       -0.072261503636114457,   -0.11639519651718523,    0.10324176652568107,     0.00119537186083477,
       0.17215774477282922,     0.049789122572960476,    0.14295898213887709,     -0.10891313399544063,
       0.16424884895824166,     0.21335398171706649,     0.15675117443082207,     0.1176210577143556,
       0.12135993858442685,     0.11973953817534137,     0.062953382682151671,    0.12460849390102749,
       -0.15257390030301932,    0.065793447832558055,    -0.048083138240508194,   -0.035863784720161829,
       0.11498127862864786,     -0.038643644814219141,   0.022503817860314621,    -0.12599667351786806,
       0.22650723548704205,     0.11222635076615663,     0.052926152962899958,    0.014703327984669145,
       0.19234876393677966,     0.076040475980114194,    -0.0043285619455231397,  0.070165350071555332,
       0.0055923381921915045,   0.029518051058043972,    0.15321780977568109,     -0.0091113904511881116,
       0.17993442340943175,     -0.11444728772662772,    -0.0716808586973154,     -0.055321987069508513,
       -0.018553529925199385,   -0.044338777654760894,   -0.0077680627146690037,  -0.12981910044485712,
       -0.033597808728994483,   0.1109374744966022,      -0.040084530191319148,   0.027439667088759057,
       0.00087828617960285281,  -0.076632910581794195,   0.080440702278914145,    0.036586075608664614,
       0.011817637536218027,    -0.042754873625148883,   -0.050281461411233318,   -0.08127934065436189,
       -0.079338740116876832,   0.070750087506734213,    -0.15697603743670738,    0.040919190211288231,
       -0.018409890241900675,   0.0060304718312372864,   -0.088872965677493629,   -0.022646615681760351,
       -0.087168508598893871,   0.1777552396549002,      0.068492508785681139,    -0.027706931210606262,
       0.03673568032831874,     -0.10227337417656396,    -0.0092004333722409074,  -0.10672242265197231,
       0.19350954572346774,     -0.017512268453892178,   -0.037906744892675634,   0.0014247270067237281,
       -0.08151776833849915,    0.056765069657963456,    0.22014838436351716,     0.072748300662299148,
       0.12561616021537372,     0.00098170075776248433,  0.063170735319375421,    -0.13090226435529015,
       -0.092418812379185686,   0.008565119021340703,    0.20552787545870888,     0.16148480771730817,
       0.07963924542291384,     0.070160817695320482,    -0.07332534289183408,    0.19919958800735299,
       0.05614245022044273,     -0.00096873919274370764, 0.12557478946513309,     -0.049016496117280137,
       0.035918207905300918,    0.12169660308376377,     -0.027199349986576162,   0.07956636139992411,
       -0.049693522099908884,   0.11803854726542688,     -0.062350229774425094,   0.011617561265854153,
       0.049386691968339946,    -0.062611611803338199,   0.12536651274986038,     0.18431009706830989,
       0.01925689166455722,     0.016321874266905873,    0.0023348252670174268,   -0.056539827221472244,
       0.13323060826312089,     -0.073598623856082665,   -0.16902594074733843,    0.084101866315214102,
       0.0097370005626879683,   -0.049177120022710755,   -0.038490949941551639,   0.076917449425361717,
       -0.073891742300611213,   -0.0038267697832060537,  0.068142753766735509,    0.023802946637283606,
       -0.038661456498991408,   0.050665975302281265,    -0.042746253996211944,   0.047342753784174525,
       -0.049540980728439418,   0.15345128446257492,     -0.1529118423268831,     0.025863133517098354,
       0.070043851606158364,    0.0070718103939737429,   0.31824809015532496,     0.15010997016726801,
       -0.082462722442863554,   -0.00083702860075821213, 0.011312052992997068,    -0.031271817930981931,
       -0.33325501423500697,    -0.11810041580130903,    -0.098292737771486505,   0.039533214902845427,
       -0.10005825122669175,    -0.09163478098378719,    0.091696058242517794,    -0.13827872699117641,
       0.077650024693791647,    0.015967347168855478,    0.045900639926596161,    -0.027067577690622457,
       -0.048792804583033353,   -0.067006018232407691,   0.098980734483254229,    0.028440866092847229,
       0.04579721400269763,     0.083153254181583897,    0.022893110419532556,    -0.061814581403048789,
       0.035828648252136205,    0.12101581612515734,     -0.10107802261119631,    -0.04822698064832686,
       0.032646882813562129,    0.065645274550237706,    -0.045552287956481176,   -0.0065499573384393177,
       0.18946076567418274,     -0.079662090247034023,   -0.20388672512384595,    0.12532868232830963,
       0.05608089136719039,     -0.074259551235176954,   -0.13829914020730066,    -0.049112510248988987,
       0.044359953663717033,    0.025511826850461834,    -0.089366071314178869,   -0.13223578693059254,
       -0.099464897427624432,   0.0089025386995808652,   -0.045462720584469929,   -0.075443357642124315,
       -0.10704163077735585,    0.1604832446688865,      -0.027904079079601928,   0.015092367637922623,
       0.14450712545886146,     0.0072277351742133554,   0.095331795049974188,    -0.08317628131073164,
       -0.088704281503327445,   0.205789330461214,       -0.13114707180619228,    -0.21661109517065852,
       -0.052307870474472051,   0.13808015062150722,     -0.020191746492423123,   0.0092548402152320235,
       0.26755562691169349,     -0.15030629648431193,    0.034882378392875849,    -0.043483742158266586,
       0.1697022860939558,      -0.017236732984802224,   0.10718064821192659,     0.06117054522426673,
       -0.011949154253085584,   -0.12801970058467285,    0.0041718062469840922,   0.014174731565594926,
       0.091579385212769759,    0.098966806982660624,    0.068070265174987474,    -0.068878523656021207,
       0.004767635914836605,    -0.061570240796784179,   0.065374279215181075,    -0.056329136501176831,
       0.11230460676313204,     -0.26231578364356256,    0.00084045243345520423,  0.14113559307800716,
       -0.005364401380620493,   0.1844963194297902,      -0.050951224233760507,   -0.13109407524715636,
       -0.012771410698616485,   0.095748996932787447,    -0.031977548128872678,   0.075297923990382348,
       -0.07937355705641029,    -0.035531723679287606,   -0.074281973882874192,   -0.07233525439672725,
       -0.1959769261736401,     0.029491411276662941,    -0.023892306807015151,   0.15060733952383998,
       -0.029909778968020981,   0.04874820312802261,     0.0068633135401543104,   -0.04586641640930357,
       -0.072087659009763841,   0.035840719080535786,    -0.023971553514176038,   0.023028187115754536,
       -0.030494078645748546,   -0.1576680111990979,     0.2719849109723701,      -0.13219217807912487,
       0.0054733766705638166,   -0.13626712085846637,    0.18645915995239376,     0.070259537599694971,
       0.078306924126900518,    0.23663661135978559,     -0.060080323206422787,   0.060386683459499761,
       -0.034315876328221674,   -0.066502224134601301,   -0.094729224046950097,   0.014031531825977247,
       0.0080160086839748228,   -0.085029949867126309,   0.028094041220288395,    0.019881073236926641,
       -0.0093262542626514552,  -0.14370729452918909,    0.016996097732936682,    -0.06562964817835544,
       0.091975753739914151,    -0.023861952075828214,   0.093130345856416219,    -0.029747255134158396,
       0.015548106915129745,    0.1112612043011369,      -0.063357999264880047,   -0.053605454498421162,
       0.033402850540483579,    -0.087433070883112585,   0.0097778108728974068,   -0.069912687690988989,
       0.013161063754131385,    0.001671614776060593,    -0.10420071214604,       -0.18558256885588842,
       -0.14485828375771903,    0.10054371275273556,     -0.087085293639444991,   -0.070962060359884782,
       -0.15323297174519818,    0.061272189593600125,    0.086266380747411109,    0.01331259015018642,
       0.14812723978956224,     -0.14153909750322977,    -0.097387708469103829,   -0.13001190357724546,
       -0.019390093367315706,   -0.049783648869263744,   0.069098428542259532,    -0.011602851174157523,
       -0.07645395677197557,    -0.079500549415175051,   0.10891275506894599,     -0.023379114768041078,
       -0.13896640299889354,    0.070317811437049613,    0.1974131992108723,      -0.039261128532392636,
       -0.11794729220438169,    0.13937332536729174,     -0.1124729761762743,     0.12382894312971314,
       0.064117137931225601,    0.021120593591971687,    0.20191054343210113,     -0.059261431895710676,
       0.041182684640469744,    0.0033526444058077955,   -0.033626363846093535,   0.0012006613402688396,
       -0.078610085287540293,   0.065896369062568766,    0.24127571722158186,     -0.11602046918013886,
       -0.18710452044015521,    0.062972547745109478,    -0.14006533544286301,    0.14997879927095031,
       -0.071203330475089574,   0.14470107954438433,     -0.064450661792943842,   0.0075508646098818161,
       -0.050257030097235117,   0.075811248221146585,    0.0003295048960654922,   0.0058314271817343005,
       -0.030443897765763339,   0.15910902351472664,     -0.11574917864458605,    0.094421557100650422,
       0.017769883746663672,    -0.16898265715291655,    0.11155999867068198,     -0.099537659997350397,
       -0.016271761511394176,   0.11148555612045569,     0.10214749609814457,     0.094393351826439126,
       -0.084612790209552285,   0.047115594835002245,    0.059729757806399761,    0.10966222220814294,
       -0.055953270769259461,   -0.089909183179828697,   -0.026616207404354941,   0.056459392302212107,
       -0.10304209249272779,    -0.015146198109194231,   -0.11743888908657997,    0.1415098941916097,
       -0.13694306641626394,    0.13103122460205543,     0.14719775972145524,     0.11901271865869006,
       0.046108060337422201,    0.053485945151968764,    -0.048582011503893553,   -0.11147538980597449,
       -0.18544916975112749,    -0.095080701485741909,   -0.043680609100123335,   0.14323246559925193,
       -0.22019709703768686,    -0.010401868011072582,   -0.027420118151168477,   0.053381527283724972,
       -0.080636138446320421,   -0.054954601017029023,   0.13238797129479427,     -0.0052654876551631183,
       -0.12574504577373061,    0.015343070478894379,    -0.10722382807964433,    0.052299593582439366,
       0.12769532049946394,     -0.046220111108454399,   -0.067618434795888832,   0.095690416664585859,
       0.0825560197474417,      -0.11821623153150113,    -0.025139412020126314,   0.097270918189176422,
       0.086919694807683148,    0.059060603105690918,    0.069586744536617631,    -0.16014384277217508,
       -0.16432281563941578,    -0.047207584449831426,   -0.13911788225388183,    -0.022679138371458282,
       -0.023129970975361902,   -0.11996274305275165,    0.10171581258648474,     -0.0069333386961997583,
       -0.073863956248517021,   0.13029801677995903,     0.11644283040743945,     -0.051745294690965594,
       0.0957601345561509,      0.038861267218932752,    0.034640361382847887,    0.13422676244422385,
       0.09884177894100965,     -0.091168831214720317,   -0.007816900463681881,   0.085025892329266828,
       0.10808673617841609,     -0.099611899577130056,   -0.016727652334682288,   0.022158827818348908,
       0.088872147529635001,    0.019907334228297754,    -0.22730569574304674,    -0.095826248487896185,
       0.027271602521273884,    -0.11020556096164102,    0.022884781520667051,    0.046822465178381324,
       0.051531033102646014,    -0.14433675709869503,    -0.071972493521927514,   -0.074952788805335971,
       0.090829115166056879,    0.074938782371345616,    -0.037398581851981264,   -0.0052136497540509526,
       0.10230075712421549,     -0.14636460766862866,    0.0708502097437438,      0.21838665107329921,
       -0.10077610745713377,    -0.065630257478113893,   0.075149997206921254,    0.044983365178028971,
       0.050214803355637751,    -0.051414294789580026,   0.038777276916663196,    0.093168998138407857,
       0.049326373031230095,    0.15610096179215588,     0.10664221394236291,     0.052856210710918686,
       0.077270738786164375,    0.0049240909341728804,   -0.016099778310936147,   0.055509185965422356,
       0.15148563928912986,     0.036853282518759987,    0.031393822074110421,    -0.07986775923413772,
       0.067946467309470529,    -0.015936910155720789,   -0.14632933804219211,    0.055843614179562601,
       0.083615213556227738,    0.055938448593584961,    0.047354956715913346,    -0.054493617321147166,
       -0.16306737227550286,    -0.16642332337665558,    0.035554117135808187,    -0.080981760318635201,
       0.053349398635395215,    0.27714626950306881,     0.011275432087094273,    0.15312575605142276,
       -0.13902031724126834,    -0.26492601640288882,    0.014096232832388124,    -0.10556956925853825,
       0.069782969168838208,    0.071483319967516126,    0.084486510947884813,    0.074045507890423246,
       0.082618621684880517,    -0.098840495460669767,   0.056806387643861464,    0.03803807283853522,
       -0.062109543049708144,   -0.044587948331064164,   -0.10214944628849956,    0.067197553780391536,
       0.077606723169667782,    -0.20567097646433716,    0.06585393866388714,     0.20645827396235192,
       -0.098230859333052256,   -0.092560445112078088,   0.14539081043583046,     -0.12958971717000028,
       -0.08455774738986864,    -0.19989886049942854,    -0.063764658419773704,   0.044562638726001219,
       0.16059756397613273,     -0.10867682559151037,    0.043784925894982618,    0.031375963628904532,
       0.027069602154654718,    -0.049918015484113579,   -0.040230218846083521,   0.0098655686202555222,
       -0.025915458583571516,   0.042186878616987222,    0.035154211395315493,    -0.11737752829369702,
       0.0099998424230687936,   0.0050585737098978074,   0.035360777474234918,    0.072896933760603036,
       -0.082565145534421888,   0.15284348625718647,     0.080196582193389321,    0.092969472684531249,
       -0.14698005564447836,    0.088811987277161553,    -0.066612992209857391,   0.078816718276545905,
       -0.042687926660695444,   0.037787386733098963,    -0.034271849942607707,   0.11252525201565525,
       -0.079619012166004755,   -0.035554789605079441,   -0.038841739538395606,   -0.19130741602595328,
       0.22633743053486688,     -0.089788536267765659,   -0.054942789247482755,   -0.012537551387565078,
       0.16467117397203881,     0.27089031294585914,     -0.0067984642058208922,  -0.12895363448433042,
       -0.10295159326884598,    -0.1269311637765739,     0.053734433927366473,    -0.037325224084853677,
       0.10095111758362244,     -0.045153888604364228,   -0.16144858923120797,    0.096944782761794537,
       -0.15975650394102225,    -0.050959889201897715,   0.088041329291963621,    -0.070322436411952557,
       0.09797932091179451,     0.0028467522499483911,   -0.10393150518148934,    0.031364637117698151,
       0.007723241213341555,    0.11677645331157965,     0.15835498747894849,     -0.097194070295762464,
       0.02489535160821061,     -0.13904064635316157,    -0.10523619436348235,    0.12241108099560047,
       -0.063427865867541872,   0.053258036429040333,    0.12126330659917536,     -0.10039125320344744,
       0.18484744119632673,     0.11728388529339989,     -0.075334433054321387,   0.009747108363487118,
       0.039534112088024473,    -0.17796005808695578,    0.036824321420253374,    -0.0077264701606905677,
       0.16405311024668537,     0.033805528305254004,    -0.10702462048077727,    0.081589031916679045,
       -0.014470095308035218,   -0.057014802731279977,   0.060118154529958306,    -0.014173796557406772,
       -0.13746232241614434,    -0.12404502837667869,    -0.043509247114654627,   0.031140137488984029,
       -0.071324948807202693,   0.071699086027130265,    0.07871255156825939,     0.17646203093165924,
       0.0010276425435895038,   -0.13183805758554751,    0.14377461798230298,     0.10113140027102635,
       -0.096075678883175308,   -0.015918885365464867,   0.00042672586266234974,  0.0141970934288164,
       0.017645084087107007,    -0.016035858970925604,   0.12193013660635746,     0.15147360355205752,
       0.1337309419745597,      0.11747583178520947,     -0.16619009343212551,    -0.1170449249169342,
       -0.12183598116604699,    0.075147603822168854,    0.067231395265191993,    0.10587848163104221,
       0.032258214183680863,    0.03636925437158614,     -0.032774022333049588,   -0.082874381814649692,
       -0.19181761201133293,    -0.1017330518093916,     -0.066556402638880657,   0.067882735247376216,
       0.0020141951669410633,   -0.0034975341711725302,  0.17876853621630273,     -0.048826716716272443,
       0.067491798661200864,    -0.042849164609994633,   -0.154622986991061,      0.12549216600860513,
       -0.12743539785613292,    0.16846373402184731,     0.00068530171349399753,  0.11474414053684734,
       -0.047691854181610975,   -0.051941919361206047,   0.032429595609340743,    -0.0059595035583044683,
       -0.06640801453482291,    0.13568197508652369,     0.089923124900064599,    0.017161172732962061,
       0.046239412865577666,    0.07977138076290273,     0.0044510939751928819,   0.0099181324158233476,
       -0.13748404351371035,    -0.1609786980504733,     -0.056157975924642979,   0.011366381200637536,
       -0.019437132796490075,   0.080723730087735868,    -0.20700086418520811,    -0.10773450682334554,
       -0.0035075653467166509,  0.05208212650895222,     -0.010925708295986755,   0.13618596730470531,
       -0.12177862045016484,    -0.13614019847679465,    -0.115348226883457,      0.050699260577231446,
       0.077581635174341967,    0.039958546186849915,    0.25010461788146859,     0.074781813261006025,
       0.0072297512346891496,   -0.14297237396243695,    0.013151568403313716,    0.023640786293250865,
       0.086944388079375823,    -0.1441857948801645,     0.022809785033106184,    0.10630200510457011,
       -0.095971771909721657,   0.046900497023020245,    -0.0047205272284143894,  0.015210940875397674,
       0.098683259680385729,    0.18255289728102803,     -0.026550203366259906,   -0.042256429308888233,
       0.044138865265596655,    -0.12572932389803015,    -0.082706202975429133,   0.24195083872258774,
       -0.17218595677424611,    0.10459876011289949,     0.020106825640169548,    0.046525419004879255,
       0.008073421706463163,    0.17259846590864594,     0.03381265787830845,     0.11010620243409878,
       0.0088474705638552156,   -0.097672568544917959,   -0.16011882342913025,    -0.06981540177313128,
       0.0085907273676589409,   -0.10683374892512282,    0.13965395109582734,     0.12855632695702202,
       -0.022576682867701932,   -0.033450914663361329,   0.090093355267434908,    -0.11542097042211338,
       -0.1237771280889824,     -0.13476020648613829,    0.0061497558069220568,   0.032770372171421966,
       0.12831244285375373,     0.090461828775304273,    0.037554675957932764,    -0.040465287485025515,
       -0.074720841586207315,   0.027117740365967976,    0.057431217287972902,    -0.025806376921828446,
       -0.096404787889896731,   0.087840310800685398,    0.078292886518620292,    0.071182623149875848,
       0.15725132007254961,     0.033827796829446727,    -0.11158496340121046,    -0.24024152716304567,
       0.10601061012186984,     -0.050106313237565835,   0.049444210974787586,    -0.0049263739817280629,
       -0.060995453238160358,   -0.010431325747899541,   -0.10193130354909007,    -0.048568426399027795,
       -0.1095486747289721,     -0.16702353418710911,    0.058756067203174403,    -0.026435274039961622,
       -0.022241259843969175,   -0.017956106256934543,   -0.11912688531863944,    0.092974298194903021,
       -0.1011861251731663,     0.21226702298711581,     0.032894901349142205,    -0.035255650766632875,
       0.12428211716855944,     -0.083062435879072805,   -0.079137980332979932,   -0.07530920868163711,
       0.0077779193538322234,   -0.077849339445143703,   -0.23826027249187559,    -0.098367738241236985,
       0.0022710108278311833,   0.054525690375705337,    0.07807577188491191,     0.094677046641715321,
       0.059360629283414977,    0.0082329022143230284,   0.21074928638858512,     -0.043353118719162975,
       -0.029635845627179459,   -0.13252524231873217,    0.10099924951681155,     -0.18380297642369656,
       -0.14816935216934429,    0.065931281724461249,    0.0082464693770121777,   -0.040148199752343246,
       -0.06198140434884368,    -0.067633477899582115,   -0.17123021160947163,    0.12806166359792806,
       -0.0062496918678572001,  0.034816955826624495,    0.068182404148679057,    -0.03515585027655227,
       -0.11429082541727943,    -0.070191685446735042,   0.16571687460391796,     -0.15063794368721092,
       0.0087711153649292425,   -0.18100023513531124,    -0.095164764384119832,   -0.078874619888557013,
       -0.086624579560706419,   -0.02522947906463336,    0.06247306579353696,     0.064468842865779391,
       0.054590728677613741,    -0.059257015580182412,   -0.20378249329148893,    0.16560630683383651,
       -0.023634506777871184,   -0.047088980841167971,   -0.069820055116696852,   0.044463088961650549,
       -0.040918386848490876,   -0.037857052156089671,   -0.028135426601945769,   -0.050076123865784444,
       0.11575398867789444,     0.020714533586168125,    -0.20201473553625415,    -0.0075498294953393339,
       -0.08243719117668355,    -0.054536073337811908,   -0.13870730257754416,    -0.082281704488708099,
       0.083127499927861184,    0.037765660732117096,    0.068609549015721499,    -0.047559815047046622,
       0.11388306819219812,     -0.011248260924259092,   -0.12479542976305731,    0.091098344963457145,
       -0.033443730718868449,   0.13587017634820436,     0.0083600147403491663,   0.16971349942258401,
       -0.065429248744178409,   -0.15929816433829005,    0.01185407508330779,     0.029759171389475033,
       -0.069850008071761893,   -0.0097511772937758836,  0.029973824311304138,    0.14219194498534055,
       0.094630134751048076,    -0.045377464924816799,   0.021497485880768455,    -0.094536379334410212,
       -0.092118835794801915,   0.085314837541217242,    0.13049513258799775,     -0.045523382623416084,
       -0.085162440747647006,   -0.023582540210501188,   -0.053090215521688057,   -0.0023649154903099948,
       -0.020450354815870871,   0.14383214016414048,     0.13627599510674954,     -0.08165766781863866,
       0.01546772580289571,     0.15987823501866194,     0.083741606727429252,    -0.16637563503213673,
       -0.023932867315037416,   0.10792089218919199,     -0.13017142585629918,    -0.083667046568882228,
       -0.078920098608198069,   0.1126590122868267,      0.038015202158209901,    -0.061978035973852361,
       0.059408874549712505,    -0.044861406700792063,   0.046329054664972148,    0.028599434734957081,
       0.24908898663062512,     0.17125708835100287,     0.069412491497525514,    -0.07263486777387354,
       0.20571237305577983,     -0.0025820854128797469,  0.047748040670507891,    -0.12244548295496015,
       0.18991511613074738,     -0.0074977193423957228,  0.084450259661084839,    -0.021930451177218008,
       -0.07720239158327849,    -0.13724958725876268,    0.10617249137505837,     -0.23145040561698188,
       -0.080860112971541012,   -0.11272989679904215,    -0.20387865420663051,    -0.085199284658821872,
       -0.099651750917805745,   -0.046333286634876507,   -0.061846428855805644,   0.10947322331989889,
       0.2014823677785014,      -0.19369523475715497,    -0.12559818831986314,    0.011957144460884497,
       -0.063504426675021652,   0.061963162954973658,    0.0069450106807107809,   -0.044838047180002838,
       -0.11207811021481086,    -0.031195930410386562,   0.049807123920669605,    -0.26877725604719183,
       -0.035965707046488986,   -0.013233350832217175,   0.024231040349394377,    0.05160975808846649,
       -0.021578741529252696,   0.085052589261626926,    -0.087998722612720501,   0.03756942803861521,
       0.0029456019230828826,   -0.060324761174339353,   -0.030694283480512584,   -0.096013003497783633,
       0.067935784609603062,    0.10685427864814008,     0.14934870790959445,     0.10976348498026964,
       -0.077347878416856683,   -0.10176985136518298,    0.054324085232571193,    -0.03930481033750409,
       0.12037229658126837,     0.20832185926708599,     0.026359988930166597,    0.10090173779646035,
       -0.052048853246255238,   0.025544177150888407,    0.072218504221124025,    -0.06217950131909071,
       -0.065164466662313472,   -0.013409508912289684,   0.07381621900608111,     -0.091271428412525696,
       -0.096392520842016383,   0.065497746797315654,    -0.050715868660262446,   0.073852262410254318,
       0.17715058727953495,     -0.048691255525126056,   -0.077787556637199953,   0.080622254629602416,
       0.0029403775031402457,   0.19645304158810778,     0.2239614567938121,      -0.076285976636664338,
       -0.18874335535084211,    0.066507018760608674,    0.0026627209839063005,   0.088401041818564424,
       0.0048741552071933023,   0.09596449378145569,     -0.11542505455305858,    0.086688726281363704,
       -0.043769563673522666,   0.089809089726598623,    -0.13769972952628401,    0.074882796379341754,
       -0.0045172025658470807,  0.096190373251832703,    0.0029878990489905686,   -0.10829009468660029,
       0.17413345204003933,     -0.074936212017046144,   -0.091938499642418875,   0.04026890290955995,
       0.045073634675444091,    0.1241781020743368,      0.077721917642025365,    -0.068376043757176375,
       -0.1056752904679549,     -0.051656246442194201,   -0.11450552455735036,    0.11326885471989118,
       -0.0064037000726809984,  0.11425919464258591,     -0.010022039563992724,   -0.18133211295427459,
       0.019961449105540256,    0.078406126987360367,    -0.2207405165914737,     0.046159209947915614,
       -0.15418904162333269,    -0.047471552105511017,   0.12110054266303397,     -0.13619193281540753,
       -0.099601634591638663,   0.12852773125331704,     0.11112014661329325,     0.023152092833976137,
       0.16756264839632759,     0.12723162514175029,     0.084078582707218422,    0.098864302572781282,
       0.025196277402969907,    0.16736893141128173,     -0.0046286133057765536,  -0.062890872722761171,
       -0.073067794207291689,   -0.090098652917560015,   0.025125313775950679,    -0.15329547288398998,
       0.059195267762757457,    0.12616004354769048,     -0.17558960365970863,    -0.024770471941188761,
       -0.025646916331581626,   -0.093760131546307468,   0.078413408620115491,    0.077796704131467567,
       0.18720491833357797,     -0.10813499031641943,    -0.15517320941403034,    0.18884795252704845,
       0.070846552654487485,    -0.0068626784608083894,  0.063152291763648061,    0.010734506784687941,
       -0.18178849084973683,    -0.050214193936903129,   0.069399461005187998,    -0.12267028115182241,
       0.12544408555247191,     -0.16774395381316803,    0.079154747389055105,    0.088878793561285627,
       0.0099186284875896844,   -0.027524291652415087,   -0.020921851570728789,   0.12332894287547103,
       -0.22943085825170348,    0.081548474136919652,    0.026424989938256895,    -0.027893493789318401,
       -0.10249764469009319,    0.055206302185288825,    0.087078553073051873,    -0.091020442278644711,
       0.083116970118855174,    0.0010730051359810833,   0.2128760648219431,      0.058870437445832417,
       -0.066908619248055648,   -0.023686436554169993,   -0.045795704546390842,   -0.10689433847150752,
       0.11020820717439098,     0.18978764321739625,     -0.042997863131035263,   -0.074261994194066941,
       0.019892873700079829,    -0.04105045283885829,    0.050024221580528667,    0.053732944561209743,
       -0.041611088751151111,   -0.068719534204759403,   0.062950827580020643,    -0.0098008171596824824,
       -0.062393903164301205,   -0.19531985815230177,    0.062586934126766136,    0.026202555133119226,
       0.15788965782634753,     -0.20840340131645613,    0.025245764357233566,    -0.09222017998755741,
       0.0016500017636597686,   -0.16746593552496983,    -0.059099921148983943,   -0.19998121795614696,
       0.067977088276979458,    0.0084872928022625901,   0.071328543704016104,    0.076217952894575239,
       0.085601098240102175,    -0.082685990945533264,   0.19437597007069873,     -0.061355182236176073,
       -0.084095448954045873,   0.031050826420970602,    0.019840421657698205,    -0.11502019151752081,
       -0.099568420506763067,   0.031507066242505211,    -0.027407240381140743,   0.063866983086176166,
       -0.027872676906766938,   -0.020757703836898699,   -0.0010670905097309343,  -0.0035963338431828848,
       -0.087862943277510555,   0.055685602818439518,    -0.10133926710529316,    0.0063274531311153775,
       0.26647369151668998,     -0.048656464492607944,   0.019098860545922781,    0.076467664617875755,
       0.028699689803895777,    -0.013092702294260978,   0.044364959832840167,    -0.049640432547714795,
       -0.041764617571919599,   -0.027296117791095621,   0.069342155435798539,    0.084973593738371614,
       0.16446792220009393,     0.11426504559017353,     0.17029193254771352,     -0.14513979030978519,
       0.070089343068999749,    -0.090643047753734357,   0.058825481842799177,    -0.086034247271555814,
       -0.095749536971142982,   -0.021209272868860707,   -0.18985160402271314,    -0.097944632370437046,
       -0.0094415513641175411,  -0.085848071509130361,   -0.08520565887609384,    -0.0042974099514026878,
       -0.1615082341490805,     -0.0042467068974509498,  0.0036057538529322662,   -0.048453893826489326,
       -0.12181272142046105,    0.071450013100489443,    -0.20600181174743032,    -0.092007269666091712,
       -0.038811227767494176,   -0.0087932494145301736,  -0.018355405326919136,   -0.02737593791290481,
       0.14107277537668217,     0.004890068710473771,    -0.062040294387079309,   -0.038597219725307039,
       -0.12399428254128501,    -0.061309994687412238,   -0.021477973851375027,   0.14833936079115503,
       0.069779409021737931,    0.14688033971331921,     0.0060959833668375735,   0.14128524733610398,
       -0.0043372608334878871,  -2.8788337917595025e-05, -0.043100742466252014,   -0.13220138956588612,
       0.084714732423486261,    0.012852381139047846,    0.054803083528210901,    0.13062126878013294,
       0.050513763080305966,    0.10881998663597268,     -0.072535739329627702,   0.18406307738408328,
       0.13044163014294363,     -0.087449938042889794,   -0.017006666351797227,   0.12718919750262694,
       0.23386460814807022,     -0.13315468643549294,    -0.024518445835240998,   0.12233493660341757,
       -0.14775065247174587,    0.14734051868407613,     -0.070019045475667702,   -0.031638505225934394,
       0.070528305036669556,    0.0071640419701184486,   -0.07689977435225992,    0.084872450569288285,
       0.077634327137508979,    -0.21472105985349582,    0.11314588122199767,     0.17714149994665682,
       -0.062226699878949437,   0.027354291488277973,    -0.06488039854503834,    0.14623897417752871,
       -0.15236676021321491,    0.0047274715838151564,   -0.20636104610150252,    0.083820708650961182,
       -0.02124797879295277,    0.15346536864800833,     -0.087200020584055876,   0.014404818010982687,
       0.12866728160245172,     -0.062395224556181336,   -0.032391085515344767,   -0.021785754262525599,
       0.031336002841737293,    0.0068873230516956511,   0.095981090655752832,    0.14216276623448715,
       0.048881428199533394,    -0.1118083130528561,     0.095300676999117068,    0.071470213063255003,
       0.021592364336761889,    -0.048512346627858541,   -0.024896875855956624,   0.020501330734622063,
       0.029190541319065615,    -0.028922056056469057,   -0.10177609676053917,    0.069623320037487918,
       0.0063275988220662712,   0.11655203085547047,     0.083168328069905567,    0.079315298331748274,
       -0.026781641971275236,   0.027743752104621898,    0.0087131599753812027,   0.17986867446464413,
       -0.040362301716054455,   -0.11927391566504024,    0.028519514038046076,    -0.069151008224385829,
       -0.16442925345602541,    0.063189412139518897,    -0.081391829427024678,   -0.01335055627104181,
       0.0063543238002711213,   0.047033566701479082,    -0.010190969005524379,   0.027735525888690826,
       -0.080577675194991094,   -0.004864398096940328,   0.026932648043763423,    -0.071198449732408353,
       -0.063466803124369281,   -0.21423490408020898,    -0.027353371539720131,   -0.077109109326710654,
       -0.18076428158857638,    -0.12988645560118828,    0.029333808794633487,    -0.0045460104580401939,
       0.18754462868771332,     -0.11492018940926635,    0.15163503103976186,     -0.019264270689026912,
       -0.039542867915892607,   -0.063366912511213597,   -0.25462454831056253,    -0.016972843890752258,
       -0.062353576268657208,   0.21894020766973488,     -0.099317621683526494,   -0.16491239548474948,
       -0.15191734978485988,    0.09873839200426697,     0.085180209286133513,    -0.090567131341975485,
       -0.11565741308710632,    -0.0011274721104447775,  -0.13452151050269004,    -0.17498034557866779,
       -0.032019929683051195,   -0.0027585721635451678,  0.021905926927652655,    0.10708168949009185,
       0.063321950583597658,    -0.092625116322979997,   -0.11566360942474836,    -0.093975567641980728,
       -0.0011326605535267346,  -0.17052611582481395,    -0.078827495927754912,   0.085298815116048435,
       0.069305967171275351,    -0.17121728455803814,    0.016585853492877244,    0.077314151833345765,
       -0.10094231799792557,    0.010066623371801166,    0.077113760348642368,    0.055630026861718515,
       0.083949038863846956,    0.054450830390333931,    -0.053785399862219412,   0.02892213477163922,
       -0.11089249253966703,    0.0064513435167247932,   0.053095326950128599,    -0.038099886105769656,
       0.063548799287842281,    0.024471072963707523,    0.07366415500117153,     0.31533803932402393,
       0.025511015553591788,    -0.17018285810451106,    -0.19827543626283417,    0.084351272983457889,
       -0.095876880796997285,   -0.021779274709684285,   -0.10974853077102736,    0.20083931712073452,
       0.0086206323080042363,   0.0076698500917257648,   -0.065706796093563474,   0.1791427250324279,
       -0.088062135914481587,   -0.021270095629109941,   -0.057844335442026766,   -0.051088831583916805,
       -0.18096677948871778,    0.03975744029465185,     -0.007642244312501302,   -0.01886640628133936,
       -0.11662024976046589,    0.13244405702761869,     -0.10746695925904162,    -0.0466244357556167,
       0.14679620321329717,     -0.11672048284820989,    0.098260928900843064,    -0.086720490882855161,
       0.079044818555342136,    -0.22058332196016181,    0.15156882802685726,     -0.14414351641911088,
       0.038750637979033595,    0.094149649443607555,    -0.11813453036702708,    -0.11146645897610914,
       -0.10091321164427321,    0.0096200907290899459,   0.038945203007368756,    0.032918755071244137,
       -0.10308392725302756,    0.17901174510769768,     -0.13056274871709911,    -0.044773681417048072,
       0.12960423175752264,     0.13320644965737122,     0.020337179264847474,    0.095588361350216589,
       -0.10688021045347436,    0.17300036448066095,     0.18765422020613004,     0.03278917610716215,
       0.005145661195338179,    0.089765442947261895,    -0.059823131720361911,   0.0015824305058093542,
       -0.1629489881801382,     0.048449222739405537,    -0.23313653263726203,    -0.0028631877153911557,
       0.043128592138813933,    0.006350212759678309,    0.017004836112877866,    -0.019487214528990413,
       0.22276334427892849,     -0.04728519447240824,    -0.11026475326015567,    -0.089188953866484316,
       0.075170589718661765,    0.13899255916955872,     0.0041010965714362163,   0.066305313243792047,
       0.15998163964772227,     -0.016942057610728506,   0.12742668447395375,     -0.082600034028654942,
       0.17282409764320297,     -0.0071313596733667941,  0.045745153438560157,    -0.077541620578578635,
       0.070353571157174277,    0.025197000683787437,    -0.0012817436031139877,  -0.0067536408606700456,
       -0.016834912440568357,   0.067609570445687744,    0.20219146612903949,     -0.048384766003865452,
       -0.0016307131081174688,  -0.049370292017887035,   -0.083394324552179253,   -0.023273849109418411,
       0.089989105329021685,    0.13042084862054049,     0.040380849103535454,    -0.084167266521017761,
       -0.050100962307201929,   0.028461569878903054,    0.056680753007868623,    -0.068408785243535358,
       -0.0083580516440161998,  -0.15619968338379081,    -0.055805633051408995,   -0.038408093221769218,
       -0.15520786021611663,    0.19823374334204183,     0.017409237220855626,    0.079427415481616942,
       0.078467922481703811,    0.10571130671085306,     -0.12343665965215224,    -0.03883073350070336,
       0.012929370386531892,    -0.0029874473519280052,  0.25927790222745745,     -0.006497023097668175,
       -0.014220495302175805,   0.091541672612940925,    -0.022841329868728454,   0.036831509389243101,
       0.0793431538444513,      -0.013637106796470719,   0.20691261170993391,     -0.080028995619031457,
       0.072435913466433105,    -0.0094506600326264983,  0.10236851140432061,     -0.087556396451168764,
       -0.128097192587842,      -0.1668401899368209,     0.012652743596793758,    -0.098466742351291728,
       0.0039386395431488903,   0.091188914219781758,    -0.20142658810271769,    0.035425078198945435,
       -0.074761447337397424,   0.036008004613586032,    0.089403567474141049,    0.11383711533233586,
       0.11793936905645439,     0.010422004677453101,    -0.097145846392936552,   0.071887361319859636,
       -0.040152074109961126,   0.025247743666564446,    -0.056854738254205908,   -0.027658368835405851,
       -0.097801590939447958,   0.13328957649040424,     -0.16326215341479472,    0.028116468867248699,
       -0.019169715292508369,   -0.10606813073140915,    -0.0055406914932413084,  -0.07509865976990536,
       -0.017527207253663687,   0.16233393718748762,     -0.068923278857364823,   -0.22130715092171624,
       -0.081809034232196043,   0.19345660554714258,     -0.0021848926024274073,  0.11045643903769009,
       -0.16191073321858498,    0.14513529489075325,     0.016974637502132454,    0.067390449876244901,
       -0.014994734000718286,   -0.20581922630925065,    0.049527859549403433,    -0.14176081286519746,
       0.13874519673223079,     -0.015353210361147757,   0.088140126069226124,    0.053228443118793746,
       -0.063036253907050838,   -0.060624882660464979,   -0.047029180770521442,   0.011276962608213537,
       -0.033085263245777215,   0.15607271820974056,     0.021582759864163064,    0.053688574727826885,
       0.0082017544461286274,   0.018143366070263071,    -0.16058767154838821,    0.13083878912062008,
       0.13878021664734719,     -0.16380477546737474,    0.045750670378380966,    -0.1150691901347298,
       -0.086224386758438062,   0.015739352944077495,    0.0083677163475270253,   -0.17582998210448736,
       -0.048367606394551857,   -0.019244566527065157,   -0.14163540500547084,    0.072003580639656201,
       0.046182959577393615,    0.035183041868047119,    0.031814734741138606,    0.035232176413131533,
       0.045506766380010541,    0.048448160630590889,    -0.046636322957061133,   -0.053421806747187058,
       0.074765718968456796,    -0.11838457805008695,    -0.12092675380591264,    -0.14503714973404794,
       -0.061841285176760442,   -0.1938429837147006,     -0.13998240318322849,    0.01617328631953641,
       -0.0540121167375145,     0.02311190484991537,     0.11759487002127154,     -0.0070973038270225591,
       -0.078696389528224331,   -0.14602043796199707,    -0.029975870108439238,   0.05466205745023011,
       -0.011499589704179854,   -0.07200779739851744,    0.018580495349712397,    -0.064897000958305986,
       -0.065830923200576374,   0.0052948029492204248,   0.1505439866397742,      -0.1834291027836828,
       -0.10942546307074624,    -0.011161485972576482,   0.050471876066370602,    -0.017362107485607878,
       0.14002376880917206,     0.26120822361092355,     0.013494890766783375,    -0.032116005222897009,
       0.070533822297341064,    -0.18249000134388504,    0.17548084877252487,     0.060619176075422013,
       -0.029706992115480516,   -0.055297008922053165,   -0.095533898068813586,   0.1459626519571609,
       -0.058547704163463929,   0.11528735882300434,     -0.099546660804024481,   0.056597376126749706,
       -0.16753269734603798,    0.045327396896294836,    -0.085091367169282089,   0.11305529508670338,
       -0.14341746502414043,    -0.14041927956762831,    -0.034468192012779883,   -0.03253436931419211,
       -0.065939828998932373,   0.09686039018876122,     0.029262132673866556,    0.11289346776527436,
       0.0068311678045115259,   -0.089968950412780274,   0.1839305849069155,      0.015020404288463494,
       0.041561866715623424,    0.065381365933959892,    -0.16292999329684507,    -0.0050044650177601254,
       0.17572561292743585,     -0.18891415932078684,    0.016572236780275123,    -0.070894024779174919,
       -0.11111219037254362,    -0.037851526296782137,   0.056944617238751799,    -0.087522935499134175,
       0.1450284868498363,      -0.01310799134212484,    0.022966316787272883,    0.080675213605307369,
       -0.036583044402131143,   -0.18730676726361475,    -0.014934735031121136,   0.04174558654850221,
       -0.086243210313468432,   -0.015652699834415789,   0.032436774855102886,    -0.10716797969483513,
       0.17351466610866059,     -0.0061046189283603114,  -0.12209626396433396,    0.090595289068076026,
       0.14753182971645468,     0.025055028687375646,    -0.047392506243335526,   -0.12866616822636393,
       0.09590424742482391,     0.13131542306661551,     -0.11028079331547784,    0.050732223871411478,
       0.016061376991744383,    0.073934475178178111,    0.011039156241019504,    -0.049140252848956907,
       -0.13388256249422012,    -0.16484609543458259,    -0.06247700914410724,    -0.040600114664805606,
       0.030593712209581882,    0.088332112176662481,    0.082276281925413697,    0.052964854621341442,
       0.071399111400028803,    -0.12704496691054951,    -0.16027008688932604,    0.0071702159803923625,
       -0.20475622556100254,    -0.042715759746176099,   0.014326761837544937,    -0.053676081728633057,
       -0.055381318591856937,   -0.06877307863691659,    -0.15149399769029218,    -0.14010049571148633,
       0.10671162269436578,     -0.0046757055886359426,  0.005746579069922925,    -0.21003892355840623,
       -0.014763875279513259,   0.067317632363311286,    -0.0046437200136319953,  0.0089763185404761192,
       0.13429382974375811,     -0.037420086964084845,   -0.14804730637356672,    -0.022358376869095146,
       -0.086605994676157885,   -0.046636250962484027,   0.0738335156857646,      0.16997540853890203,
       -0.10834232172652562,    0.067870755954871353,    0.018276822245476311,    -0.1279952628843011,
       -0.038352098422224527,   0.030278554773690684,    0.042045250933926373,    -0.19063929160472809,
       0.20401839452415352,     -2.5805239190025372e-05, 0.0071073317178523346,   -0.16063500277981416,
       -0.018875182403796549,   0.082123446730154773,    -0.022896295470819086,   -0.027323756667322424,
       0.075749033958806097,    -0.045178932484692083,   -0.076883773001957811,   -0.12572193216680341,
       0.13580635271368768,     0.095199921307554489,    0.061074643437822755,    -0.1509054466674386,
       0.10095952520907667,     -0.090980236130226391,   -0.084616490482273571,   -0.096120748655985078,
       -0.061038730192712651,   -0.23391510399698953,    0.0077945693455842525,   0.16466428613551709,
       -0.073985266740144245,   -0.060891276053322611,   0.011158604497876916,    0.018515443540687682,
       0.0015285340848354024,   -0.026939103505080646,   -0.078623219293040281,   0.022038565720011578,
       0.046054795331053965,    -0.08573031136149166,    0.21601426652980393,     -0.032149524780851181,
       -0.15917347564919385,    -0.24140709396674365,    0.12150449237158734,     0.038760005037745821,
       -0.033299527568237647,   0.093504046522606243,    -0.064388306457612204,   -0.11240197883188974,
       0.11168835032289388,     -0.095897045431333761,   0.027273347066909735,    0.20441173170502636,
       -0.076792999288804176,   0.066686046241046168,    0.047677048703435518,    -0.036976491989576594,
       0.079773851242342805,    0.066937307304340304,    0.068356303991291084,    0.069989984973163805,
       -0.097098597217360486,   -0.030400225837297783,   0.044727981545210217,    -0.021395875970498312,
       0.05069746567135034,     0.24667807338503631,     -0.031154375391423517,   0.03710562727985741,
       -0.05256513387853988,    -0.032923524088751009,   -0.0059410578366926887,  -0.23444795668916685,
       -0.12492973607489175,    0.033828924463931896,    -0.0096642035855159548,  0.095255890140000368,
       -0.085862299466210198,   0.25616650606256308,     0.086742764911923023,    -0.055171157377778862,
       -0.033196631842193472,   0.12537658610779714,     0.023332460046002812,    -0.17412258111961071,
       0.11234173794283885,     0.077547044335568235,    0.13907372182292249,     0.016338113864494141,
       -0.086880313522152267,   0.14239045274763978,     -0.05759344370104396,    0.054953721712289808,
       0.10268575937559199,     0.097581153331534318,    0.024535062563236388,    0.10785261966413001,
       0.066065139724304334,    -0.066222983271254768,   -0.02872564602602086,    0.20805015706268865,
       0.055089153071548637,    -0.020276198192787236,   0.028652996699561287,    0.075654439566125886,
       -0.025727628193561773,   0.1535084408934114,      -0.11011472228781384,    -0.074996984791827925,
       0.10443627686655578,     -0.018252404952730013,   0.14495505797418123,     0.092115166281142399,
       -0.11877373562136656,    -0.12856316963768374,    -0.1319023378624328,     0.0068546359068889038,
       -0.15604222544962768,    -0.088296796719472548,   -0.011002252255813222,   -0.14976098613306038,
       -0.043291604896360553,   -0.10778378758461066,    0.12456087438808947,     0.12996595541230296,
       0.13107034714194907,     -0.106194170309848,      -0.16284604296116201,    -0.10177849667092609,
       0.21519268938275743,     -0.0042733182099362575,  0.015538469421608006,    0.0064323740352217025,
       0.07080281279163024,     0.15740543650197658,     -0.062668126714993097,   0.12902632996673088,
       0.079293790061700148,    -0.084005272397178241,   -0.037589535138282164,   -0.01042469149762156,
       0.036797547707698955,    -0.098927472388068871,   0.03544967089391092,     -0.015086396642522792,
       0.0021868514524273049,   0.018750904102958123,    0.014388006618153874,    -0.1584762334964375,
       -0.19220681376731052,    0.063654518234708996,    -0.14522570046036498,    -0.010849646471942949,
       -0.021847917415330202,   -0.017551133002139414,   0.036785721176987592,    -0.078941537671450901,
       0.18301606124490291,     0.22792513896550617,     0.11584095764551461,     -0.12432346005800547,
       0.012208918521250358,    0.076146208160368267,    0.18117021691524951,     0.097109721357928433,
       0.15907925570788006,     -0.072203733613242102,   0.029405168996129362,    -0.19066072261642805,
       0.017343224683855012,    0.10462081682784255,     -0.081300547370973419,   0.21427824473264809,
       -0.086930080708039981,   0.1762191502590128,      -0.20608621965537721,    0.25501317206367163,
       0.083730854696749235,    0.056909767349083915,    0.063754557241729307,    -0.096444237424039805,
       0.021766962225946044,    -0.02279952770933355,    -0.05073345077728441,    -0.11687191784137442,
       -0.17124487753762591,    0.048725767813686698,    0.053914679462938479,    -0.0088720605710578462,
       0.1471368314746303,      0.016591421698906025,    0.064182243082659282,    -0.051297973191124328,
       -0.027894989500829536,   -0.096620657600434007,   -0.049839508609483871,   -0.025781487081164279,
       0.21733293825170583,     -0.098397836004176883,   0.079288428119703977,    -0.14556687458231227,
       -0.12967254608272516,    -0.026296392996351527,   0.10850706787600563,     -0.04076543369356897,
       -0.14051951082241051,    0.060514164531494691,    0.024269890031319134,    -0.14157972514930803,
       0.040284137508307727,    0.10310864092923226,     -0.051866780457946488,   0.02681376210405402,
       0.041431794452398661,    0.062605326954969995,    0.042659806412937221,    -0.0076754895615877179,
       -0.075707134757869943,   -0.10160831917319747,    0.16438683045875388,     0.038727409448337843,
       -0.035832928734930332,   -0.04783484015469313,    0.012756010465858577,    -0.10598057153302731,
       0.04304219701382124,     0.10268195921926332,     0.088523431820469525,    -0.052180200599673945,
       0.038653867027594151,    -0.030183293390536464,   0.12151768787039648,     -0.063425168438174084,
       -0.074808039850229366,   -0.055732669749183644,   -0.066473745472217391,   -0.0035230560870708151,
       0.14816141504671479,     0.0083895146139449199,   -0.057987312223569377,   -0.10260026737583151,
       0.01168462741624268,     0.054506820542666062,    -0.12013240347830689,    0.013681059946469969,
       0.13742032591338479,     -0.097928797599653977,   -0.065889981997941272,   -0.059981405049654171,
       0.022772908437510144,    -0.037406185109215236,   -0.12626318336851292,    0.15710515283464677,
       -0.0032383643427161854,  0.0067993999296526364,   0.049850203808754968,    -0.088749189319137806,
       -0.035673350517262475,   0.16007401684574116,     0.097994020939457929,    -0.094172320717909264,
       0.0472778304104228,      -0.17032304351299971,    0.0039096961756512442,   -0.023965013446557961,
       0.084127316859447035,    -0.016946969347050318,   0.037889575257474509,    0.018104221530806312,
       -0.13398478830295821,    -0.085669059989505622,   0.061889581942374608,    0.020201654702555409,
       -0.15384637404191923,    -0.090018863863632489,   -0.0263797356629401,     0.025745352367594433,
       0.15240949567102235,     -0.10349009526165684,    -0.044667509415807785,   -0.13057773319693569,
       -0.046716564697100678,   0.098907477239627964,    -0.038496216494782624,   0.11814472764794126,
       -0.015955346201496377,   -0.13055188463639816,    -0.07735488486239378,    0.15762745066993417,
       0.00078077993516960918,  -0.09054778155749682,    -0.15793841345749138,    0.12906585684063945,
       0.25504639897144804,     -0.092305176619662282,   -0.12048725422418521,    0.044899767125805158,
       -0.010437411837080447,   -0.11728423771760794,    0.022047726607338627,    0.11760073999013314,
       -0.20115101845350306,    -0.012782155252153192,   0.12533929844958411,     -0.031199709675887241,
       0.096286068473936462,    0.22824681325615367,     -0.0079678002353377794,  0.020704478060444346,
       -0.16208173726461611,    -0.031409039914612483,   0.021456728084617138,    0.080087497582687683,
       -0.12440191992999143,    0.02134245214994596,     0.089219066673200537,    -0.10122888998301748,
       -0.035270241604441088,   0.002631371036228714,    -0.074045766083079945,   -0.059244484334148757,
       -0.09812049496012086,    0.066471153897325816,    -0.03568440589657014,    0.016600394909375836,
       -0.21371131432398888,    -0.046268620457937455,   0.023128706852433654,    0.053707727274580008,
       -0.081427342356401297,   0.15946638299996033,     -0.047757151456655142,   -0.0058538110751488823,
       0.022043300858455839,    0.02338853672293871,     -0.014517707736906658,   0.011582683467715998,
       0.021473003427933363,    0.27799850117053598,     -0.020084568198917355,   -0.13209403349512538,
       0.076872184178493369,    -0.0025233672059277951,  -0.037657411583254613,   -0.19176719918377289,
       -0.082811809417399518,   0.029643953246627868,    0.09209435362118068,     -0.047745180075764414,
       -0.063572385279479449,   -0.091249856292307613,   0.00067652803095140184,  -0.099716621982614898,
       0.2572986562165363,      0.00017193356229910136,  -0.078257496644784971,   -0.036091777214261822,
       0.10497268098081776,     -0.025560438209693004,   0.11087213162937301,     -0.042512791757308155,
       0.1077062938782415,      -0.031331504649623573,   -0.07202237325948356,    -0.0086645036919349595,
       -0.03854018510478651,    -0.14250725722310276,    -0.13805739318663671,    0.048417401766100307,
       0.19651868679959386,     -0.042701254946543046,   0.065214312494835475,    0.028086594014785825,
       -0.10965881131481778,    0.019178932596414219,    -0.09734850009318953,    -0.02596935788557771,
       -0.043567811122054413,   0.094907100604838979,    -0.14395326863268187,    -0.10463917128773922,
       -0.035756706758426737,   0.036582230571307092,    0.019997694504834098,    0.13167343099632406,
       0.087922076804552218,    0.035215954189906681,    -0.011849028943884,      -0.11726439394318242,
       -0.049535460743759543,   0.11083459686012434,     -0.073426521408343381,   0.050612028494764136,
       0.009416151916240208,    0.11210516600553465,     -0.15543638266890056,    0.16687102091654651,
       -0.038816137432100675,   0.070186293311782916,    -0.13547831578935929,    0.11946691028658354,
       -0.070546494714145563,   -0.11007096098498181,    -0.0791960538895531,     -0.07848244553264834,
       -0.027450422717128907,   0.051150933971711963,    0.090064840941494528,    0.068239023234111615,
       0.15845873089644644,     0.15734262011647071,     0.0054585544484897358,   -0.16942545073849594,
       -0.14184653820147666,    0.049455022910612705,    0.12884084474898427,     0.14355672384045093,
       0.11195415868428288,     -0.086558807287547918,   -0.0074933010282305784,  -0.048769975688210107,
       0.0076746108272931109,   -0.11734965754183846,    0.11309932683476455,     -0.21846867432830994,
       0.058044624526218142,    0.16232707564793164,     -0.038509546604707734,   -0.034165033504891418,
       -0.10015121975800444,    -0.040152171559103479,   -0.12034153712507804,    0.001313892655781892,
       0.056479909689558516,    0.19124120903843111,     -0.10023651136465549,    0.076973226267205583,
       0.054514168852625444,    0.15819325872292922,     0.24885553624006729,     -0.014717600440916781,
       -0.093655128739365615,   0.24032295253463976,     0.029382263668319881,    -0.097090340676049561,
       0.11092893478065573,     0.072117422574266635,    -0.079747896581136402,   0.052035605728235228,
       -0.022988628661290852,   -0.022743103191934906,   0.066331885710605179,    0.03813641578682276,
       -0.11174974264741239,    -0.068021458833342513,   0.13483780199681025,     0.046273570467254825,
       -0.036345994899208624,   -0.06184288163570436,    0.027418457232921217,    -0.21154285176123913,
       0.075595081769058325,    0.009461937278766399,    0.0023961150967988908,   -0.098448253824598014,
       -0.089157161747378297,   0.01834382805627972,     0.010503669057325273,    -0.17978818817308814,
       -0.10219504588433991,    -0.0065757336257786401,  -0.11576235763726203,    0.0071353368236467853,
       0.076248248174637601,    0.020502251207681621,    0.009666649579507542,    -0.029744706825147564,
       -0.084238209357071603,   -0.080024956851604129,   0.038952333584633951,    0.041324529956982679,
       0.087884530328375066,    0.0095372820695784916,   0.027546770408657145,    0.024928781758454088,
       0.1919725347911467,      -0.14558109474139699,    -0.08416776703977967,    -0.029087769488266871,
       0.30266744953086189,     0.19304403587537289,     -0.15591786670416335,    0.018562387162447722,
       -0.053025025186055612,   -0.079435037257599997,   -0.072611905352005207,   0.028516869420013323,
       0.08545895494832087,     0.061329866484914793,    0.083382580289349972,    0.0054949380239796061,
       0.099545761592415308,    -0.15142821970088646,    0.04899461451857013,     0.045964819043172248,
       -0.11836354891453042,    0.048358789167378138,    0.043234400448374233,    -0.24535673292538449,
       -0.081767987467062264,   0.19776739540145877,     -0.0073398572322910527,  -0.024113770968290277,
       -0.044463361719021571,   -0.035211742692507417,   -0.038984647499747664,   0.044379156282193744,
       0.15255516757366078,     0.07012354468373444,     -0.070535721362031262,   0.23140900856304675,
       -0.10119382372180928,    0.028186857808694274,    -0.12529465629969086,    0.044562478594942105,
       0.095150049528259867,    -0.075960549995787968,   -0.10268508800786844,    0.076011680627035727,
       0.09237149339736854,     0.033658121293934279,    -0.10758763702190741,    -0.037937019056845454,
       0.13174691148520096,     0.02821849038152735,     0.01169719390641695,     0.042674499490070059,
       -0.055566550734046545,   0.12317829561124539,     -0.023999383056148061,   0.031171195741929773,
       0.17208377628485777,     0.058362029075423989,    0.044357235764235295,    0.12100641504902637,
       -0.1106831668025076,     0.23315258359654439,     -0.16150756295267255,    0.075358695273293058,
       -0.10311608286751039,    0.12657549976561905,     -0.15299366028179925,    0.017325118747903035,
       -0.020204874512030752,   0.033262370764486418,    -0.046358016769778541,   -0.056389261768834416,
       -0.26932800080887176,    0.054693919959841505,    0.20369572317073159,     0.069498396766576667,
       0.044235292690872528,    -0.0058758459852363623,  -0.016424491397042062,   -0.034283378158023632,
       -0.0038736444377656626,  0.05223373527353669,     -0.18359988398123592,    -0.20542636968258882,
       -0.037683063705390686,   -0.056947594958557307,   0.055492401241369158,    0.094604166305083767,
       -0.085898059030793464,   -0.10518520280722131,    -0.061202182334312363,   0.075204818971610202,
       0.011838097868655417,    -0.16603627710782223,    -0.029619764285620402,   0.035510357706758047,
       -0.065793309121306404,   -0.20687182368633503,    -0.026689767225512497,   -0.10648905696710934,
       -0.07426149129678937,    -0.05871570795299557,    -0.092945843204838702,   0.15350105791022464,
       0.0038588661757025648,   -0.047099749409261073,   -0.10008044881819859,    -0.11604627829598575,
       -0.016083654694501737,   0.088415001873473439,    0.13878845260790026,     0.025034435778271111,
       0.020595009212675121,    -0.049474636053386895,   -0.018100187429522255,   -0.021765399213437654,
       -0.066614947250259238,   0.005760886645431177,    -0.077447010026578417,   -0.075857089636175379,
       -0.0053752744790010578,  -0.010327711274436444,   0.076390363489112351,    0.062996365830710666,
       0.23553896456766321,     -0.15832067204902153,    -0.028332388247000198,   -0.053527143876784374,
       -0.15568749838547083,    -0.059492293296618162,   -0.23219239861170077,    -0.16245833991645317,
       0.056398375499260828,    0.13442200347672237,     0.068077946781865822,    -0.091350852440648403,
       0.023204525127111349,    0.0052685154356701853,   0.1025467354263486,      -0.10682115123869204,
       -0.020751919708530464,   0.1572233861322474,      -0.12113782536173284,    -0.15119173597747179,
       0.10787967572807174,     0.026562254836678859,    0.023175056781837476,    -0.065074393711992515,
       -0.069955323309937339,   0.021125490159400028,    -0.020927367507427942,   0.0086805733128489208,
       -0.1552353011526984,     -0.034478398487387006,   -0.048457123946692951,   0.17026435126980052,
       -0.0048242199605966398,  0.17017330247738022,     0.017222007441247883,    0.022348952864597618,
       -0.046245672929496606,   0.10291083098409951,     -0.069264503131386934,   0.0097883731722074666,
       -0.11629673833861481,    -0.017425822379063961,   0.051191312905887111,    0.081125156266103643,
       -0.018270218063955516,   0.11828914098087338,     -0.18785837167306452,    -0.16271656801132556,
       -0.08561675576708544,    -0.17804875500883544,    0.13766911958980779,     0.044331213723506693,
       -0.0023910973561945582,  0.045716225877853504,    0.22007384344611866,     -0.18763019749570589,
       0.0024801322348965925,   0.0012673321817115719,   0.013732541178250027,    -0.026610561777949966,
       -0.025989224133530983,   -0.036480918128947049,   -0.041859600991140847,   0.077853664517660945,
       0.0085105829116228788,   -0.079974401905619455,   0.046882992425689836,    -0.085414483901738877,
       0.060407888286030317,    -0.091755649639755535,   0.065454889234648386,    -0.089170052484910625,
       -0.090075944755708931,   -0.0022428659829620496,  -0.15660140734388411,    -0.00026651170497909884,
       -0.0052557354283375678,  0.16373426856781403,     -0.014413104499063183,   -0.1433142271220372,
       0.0036847970090515035,   0.057845814294731748,    0.14954035486971021,     -0.098043432296818889,
       -0.063165642487727255,   0.1004080342865086,      0.0025409716195860001,   0.00035289987704745012,
       0.0415248278503908,      -0.014550588897238394,   0.12417683673115412,     0.085521016534242073,
       0.090656380705776488,    0.053328183619327202,    -0.12478165852212462,    -0.21739177784820871,
       0.14087199225545233,     0.10912132353783072,     0.22564575060497538,     0.089687195414330928,
       0.02054341508223595,     0.015004863362649126,    0.04705440838376132,     0.024491520262377831,
       0.026223262695020781,    -0.017795536787120519,   0.078591704546400645,    0.028504466449368538,
       0.025153526012621698,    -0.087648693639116995,   0.16874194758725666,     -0.18356741945262042,
       -0.2242853066521073,     0.12159283870210096,     -0.13558186980075698,    0.050764696170681113,
       0.040861701637342561,    0.0037331380673352528,   0.075822566506681968,    -0.05525890861704004,
       -0.015259811277585964,   0.17910524474781972,     0.0124432754833909,      0.17764895400141267,
       0.17990787880836717,     -0.037337476211029876,   -0.05084915033340362,    0.17316051243156189,
       0.061056125188970536,    0.11955096323804423,     -0.0028335461882989703,  0.059960689038836078,
       0.12339788273909343,     -0.041886417978199336,   -0.074174117451441507,   -0.01966796277177657,
       -0.088194258054543076,   -0.063036143972105121,   -0.026812467476302927,   -0.16794599703332727,
       0.21434498072001473,     0.11864152975968728,     -0.10446730499968447,    -0.034561989552563427,
       -0.12932567029194617,    0.030935354362534421,    -0.023966149016401508,   -0.0053201822773282026,
       -0.058023964524596877,   -0.12701328976776941,    0.10929067127225238,     -0.042488428083144056,
       -0.057283721992167996,   0.080706778978308441,    -0.018891883696455138,   0.048541088299025162,
       0.0069186356173512459,   -0.00050458707148557172, -0.093711700194887781,   0.030013734556690937,
       -0.15622463794976854,    0.019309970818533483,    0.07064214179939135,     0.056527514495840217,
       -0.15675670222879934,    0.09201306264744108,     0.077929130661471571,    -0.071367889342674518,
       -0.061651881316076122,   -0.055980464376786415,   -0.01765071579726929,    0.021812919564865946,
       -0.045141187520115908,   0.044362874234739634,    0.13114203937042296,     0.035681048062464436,
       -0.14764419764479514,    0.059866370341910599,    0.010439710969062634,    -0.032379261628845905,
       -0.099719013253196431,   -0.20652701970650081,    -0.12460160457345615,    -0.082201148069450572,
       -0.027494490693041034,   0.030536961059388173,    0.048229947862501135,    -0.045198482377945867,
       -0.0067429441034919822,  -0.14211430910309669,    0.035984656009663468,    0.036989150462131762,
       -0.0030645238162245146,  -0.21046512796099481,    0.15233693387569441,     0.12801518198059825,
       0.096833543315136245,    -0.077345210552386592,   0.062488909845445514,    0.1267310673966433,
       -0.15985841571866108,    0.11452065170391475,     0.086510199196241727,    -0.087265959217639605,
       0.023542224469452797,    0.095755023565328848,    -0.066924633417814822,   0.078572278353149907,
       -0.12339336750254069,    0.082428200604488217,    0.13938671425926505,     0.19900495404720062,
       0.066437895446505899,    -0.0062972976875734421,  -0.11748108645458663,    -0.19182118937776688,
       -0.048621952548580726,   -0.075063997044735986,   -0.034681885789590548,   -0.10808994054074966,
       0.14536887035384066,     -0.072995185339015334,   -0.097850803284714349,   -0.042494828476303086,
       0.22512299488897233,     0.073504891128165939,    -0.14881691733566027,    -0.03393095912660235,
       0.10655000292657027,     0.079435969239500873,    -0.025258600110181488,   0.047417099699615647,
       0.0233124066454874,      -0.072026515946808298,   0.097597724120733573,    0.24402121189874756,
       0.12555658163235681,     -0.12554822025608892,    -0.099776669144536409,   -0.20990110508238266,
       -0.046744654511171803,   -0.10254364594278681,    0.087213115663759957,    -0.16863557221603243,
       -0.011635391623839605,   0.075347989817815042,    0.060960957573229349,    0.003899768594411295,
       0.026783631264173515,    -0.10018474495508828,    0.10785131364879712,     -0.00571703814944057,
       -0.0081663997761392982,  0.13264747029507312,     0.21000706765169322,     0.077400979563064826,
       0.042563833245124173,    0.0035337611806676855,   -0.02495009681011609,    -0.10175455257786893,
       -0.052263685262415878,   0.080124155364848168,    -0.021983860491347373,   0.13662407552178865,
       -0.0076167902804131302,  -0.048442007061513095,   0.30507203387155607,     0.053084159894416581,
       -0.010210212449546459,   0.027245012587008711,    -0.10229937643086263,    -0.06275971777855012,
       0.02915526080949999,     0.01609277763837335,     0.046543739122742019,    -0.10116781843724043,
       -0.061352864759384666,   -0.075285954721729817,   -0.032572162083483493,   -0.23616086842520617,
       0.016603042385414074,    0.1451717605134451,      0.10047246497883019,     0.1293119732077552,
       0.061508704715270014,    0.095668896484623359,    0.2684707723714479,      -0.1260586544663044,
       -0.028087766777364978,   -0.14994453004272928,    0.04037192121375234,     -0.038243229385910106,
       -0.16242402883295484,    -0.029205100624530647,   0.11386077478919503,     0.18216909952137489,
       -0.015350815661855975,   -0.048338848830212958,   -0.10545639227898033,    0.023065805767306598,
       0.073909045122149492,    -0.056723725216860678,   -0.018274683013482045,   -0.040794765877420702,
       -0.16101268178618849,    -0.10595561649832073,    0.085111504129703364,    -0.061852188506738466,
       0.075215084999899734,    0.078582844632738541,    0.056799158029015702,    0.062082837817030959,
       0.059215150936285536,    -0.13597556371599964,    -0.02399509999280371,    0.059375968170945904,
       -0.0810082623638268,     -0.012443389286721328,   -0.040984878463841093,   0.20191573160958642,
       -0.088584210735001903,   -0.025012761863597688,   0.11123554714843173,     0.056201053700270329,
       0.041634107939070734,    0.11273236081376925,     0.20391071651209086,     0.05381211788046187,
       0.10227454563983211,     -0.036166771265433453,   0.16406421443129932,     -0.082285277100301951,
       0.023231240123990998,    0.059136904302384975,    -0.048886825680794457,   -0.1093785143863885,
       -0.16814373293565707,    0.12603256408936736,     0.015533044643776844,    -0.060067610993860848,
       0.0072440749041878631,   0.026670867337193226,    0.19062574902247201,     -0.10709172021850137,
       -0.065472086169441696,   -0.06491030970305052,    0.052610733747008073,    -0.068355215863183549,
       -0.2055984246864267,     0.0013338384237469355,   -0.017252234699691657,   0.044800997757644213,
       0.22947267490636469,     -0.20400749347515088,    0.075403584288313674,    0.21026176567118895,
       0.18241660186236169,     -0.081693614527716646,   -0.10346692242493775,    -0.020707097128145523,
       0.14108058153544778,     0.0039185418781174149,   -0.14977817802943999,    -0.089393404288202735,
       0.14765595583262867,     0.0044388605338740762,   -0.091624371424846696,   -0.090326641719502873,
       0.13183371206815178,     0.063984858298473168,    0.11332800501428215,     0.086818288255323436,
       0.035969712327797408,    -0.10675998008710488,    0.042660677560581083,    0.028440173686616731,
       -0.16089100728520483,    0.028027318170461297,    0.014138508387264073,    -0.15389618994961626,
       0.057827825455689243,    -0.059940288533036068,   -0.22336509528821602,    0.05710577624534266,
       -0.024077462671052489,   -0.013548033089985725,   -0.0094645074473871521,  0.05638092785000566,
       -0.030330025000537334,   0.035731755152664448,    -0.10142641752520373,    -0.12816008431431361,
       -0.012790222965369077,   -0.12045381137812865,    -0.011627514561753588,   -0.13611663072798111,
       0.014390327476281974,    -0.0179908667467292,     -0.11918915185102175,    -0.040089645172784065,
       0.067257396322920271,    0.073768958442377255,    -0.071366684996858637,   -0.076947877982240995,
       0.06539073344999731,     -0.16762079479037767,    0.012620677267811391,    0.034183746877427604,
       -0.26237616835908717,    -0.18026907102391312,    0.087900271885666265,    -0.032989629745395335,
       -0.062055499354935532,   0.018386256279422593,    0.025006622452497074,    0.2061468531229684,
       -0.092359203050767377,   -0.047348042820740704,   0.1252448470186581,      -0.031354634189152492,
       -0.014752099684793508,   -0.085443477504872245,   -0.086437528325517599,   0.058211327764510087,
       0.1150443786289041,      0.15701987516400107,     0.091249072235279255,    0.092522590477404798,
       0.028770534183363058,    -0.092462831884502286,   -0.041478960847730312,   0.0015401366388759277,
       0.00018844486991948959,  0.037232579320930846,    0.057587978135912966,    0.064077155761806268,
       -0.048402634215328796,   0.13050325949705127,     -0.063511844230758577,   -0.057007715821924702,
       0.06555881460350492,     0.052090042244157995,    0.10659685205533191,     -0.10648398654623566,
       0.15569389939435807,     0.083695472996971679,    -0.0017477839920863694,  -0.027156584057933111,
       -0.037783801024169311,   0.0018109782546012303,   -0.047146758686496815,   -0.1177096571284416,
       -0.042837224386019314,   -0.051320698007999439,   0.17518796580152782,     -0.083044234145559601,
       0.17166673990570264,     -0.13447060678010969,    0.069614563489426656,    0.16381772298628328,
       -0.1287093664091222,     -0.041169811488876169,   0.079001123052626979,    0.053095906044471355,
       -0.1821303699717714,     -0.065402547839303923,   0.071761303400886559,    0.058852137743139438,
       -0.054482000070134998,   0.057548946126936104,    0.15862621332986379,     0.069523206869172766,
       0.073651046292598832,    0.053569523396936936,    -0.072463769031623992,   0.026913476445411238,
       -0.1190742000531796,     -0.05153954786794028,    -0.067945889906725787,   -0.11095278288396217,
       -0.026404179197762671,   -0.023977146323147007,   -0.010988133832615828,   -0.018213503303924711,
       -0.039822764636841257,   -0.031537774458600044,   -0.047738342642001469,   0.12674417203577701,
       -0.054285009522955681,   0.20200297377020079,     0.1744925052586685,      0.018521660926501784,
       -0.049729954651107799,   0.13250016658208275,     0.034050902769648936,    0.11343682563047318,
       0.10210232438636997,     0.076956437442501691,    -0.0150327385756965,     0.038461074900122273,
       -0.0056894324875105054,  -0.16113111779190636,    -0.1563361059005704,     -0.11708737403612067,
       -0.036352457991879646,   -0.11888863424491167,    -0.09569089935863008,    0.16007925342600865,
       -0.13740906487223378,    -0.012274941895558137,   -0.048044294621138503,   -0.01768010549048878,
       0.026400471491731151,    0.020658013821093946,    0.043833820784996078,    -0.098129114661121161,
       -0.18816219291416578,    0.022929763047823043,    -0.070213461578243985,   0.0044713772112013233,
       -0.0088161617244599984,  -0.081638456812329258,   -0.23310332619843907,    -0.18523996796457295,
       -0.036327014243130083,   0.047045983280546315,    0.077428311534876629,    -0.12913934641832198,
       -0.20565384831700531,    -0.11032581272153973,    0.062357294223161608,    -0.0063853234809528661,
       0.11763664198023858,     0.032704920496349009,    -0.070275110213242384,   0.024360534654644612,
       0.040363992323988768,    -0.024848572551517685,   -0.11900597988501585,    -0.0089355884370720499,
       0.085284573044328016,    0.20665619083762909,     -0.17473356019858749,    0.062874443017424272,
       -0.14004813011686681,    -0.18497440763522052,    0.04909596413472897,     -0.083608355715853039,
       0.088912757396946693,    -0.016861792644562619,   -0.018793341895310893,   0.0084497738472447247,
       -0.064394264529970088,   -0.040438601960092739,   0.012934123549866715,    0.0007254546950873045,
       -0.12746250282568836,    0.03836887451215501,     0.032782657597202336,    -0.10221780772919783,
       -0.013380936199783935,   0.076201400383000009,    0.12387456097569353,     0.050574412795903467,
       0.11526340259976145,     -0.10844222659038508,    -0.052617924135072776,   0.018843757680510838,
       -0.23198351140856685,    -0.1043979292712247,     -0.079036034669179592,   0.075148476996531294,
       0.22155008569754134,     -0.0021995965166705478,  -0.13903142113630954,    -0.069084941346653522,
       -0.025091793162255915,   0.26647591282482708,     0.063093442431529964,    0.045075000514936819,
       0.0077054130859981135,   0.011927952295757653,    -0.0072717309442007659,  0.19683816731420933,
       -0.026276004069194493,   -0.016829771860829984,   -0.10551552544741682,    -0.059259324936796108,
       0.015645495825162645,    -0.069592585780069605,   0.095710783964442686,    0.067003500886243836,
       -0.0094393486359385329,  0.080760417982421395,    0.095630918079405089,    0.16938746135970742,
       0.14815226352606403,     -0.0040734355310111754,  0.069705673333844795,    -0.12532478818682086,
       -0.026676674679324917,   -0.10166029796153948,    -0.14994253653184345,    -0.23791848781803906,
       -0.019825852096275375,   -0.043596078649210744,   0.12286460473960265,     -0.012401134643580697,
       -0.21894864020202526,    -0.074352183061081698,   0.047876762673417422,    -0.018714375452221828,
       -0.048699107822928148,   0.12397778196856768,     0.032239942216189005,    0.10106911675510967,
       -0.072324761012780223,   0.1598825079869827,      0.051924120445185865,    -0.024319855237463023,
       -0.0084096794264469019,  -0.055393269979064796,   0.079141626150659256,    -0.00089075360766020404,
       0.17512298557494108,     0.024059279269851852,    -0.059775356434506113,   -0.058366110159237691,
       -0.029130782014207834,   0.037577807369716616,    0.11967414252478865,     0.17419784733905977,
       -0.18456830345251821,    0.03735472169213816,     0.13238776574060698,     -0.064767651851649635,
       -0.11632265523090557,    0.04790246270286852,     0.023483451692890629,    0.085963243499795366,
       -0.10521450376663113,    -0.1681904499056984,     -0.17511536118444912,    0.0026115351215918576,
       0.027064883471198405,    0.19498042750160732,     0.068748283735337645,    -0.021693364296258615,
       0.096682210891834999,    0.017875382439386533,    0.099639012480279121,    0.12696400631390592,
       -0.1271833444680375,     0.14872818228898074,     -0.047572431077635646,   0.11285441719707025,
       0.11886070185259261,     0.078953036058264467,    -0.078388230749015186,   -0.054507027183512496,
       -0.064239624084143548,   -0.065035983239961223,   0.17377771847484916,     0.080547936823579344,
       0.043900464893985469,    0.096463380017987044,    -0.14390118939492988,    0.19580658220618952,
       0.0014645242191861658,   -0.011783683719302367,   0.066710091962986579,    0.15502416346567194,
       0.11393211952329838,     0.026283399238641789,    -0.028533840710848718,   0.1577942876332955,
       -0.093965845319889829,   -0.0010627968705614315,  -0.20239520623380688,    -0.024643790929243778,
       -0.12976404700734456,    0.054151617175349442,    0.0034669830788919163,   -0.030041731896820089,
       -0.10148290691130687,    -0.077890512629758463,   -0.058528404209715543,   0.026714399511163268,
       -0.014898109415323057,   0.15479318488670665,     0.074857614920415413,    -0.028626334618532812,
       -0.078440913792847552,   0.096203530129096437,    -0.17481719700343273,    -0.065993057057432636,
       -0.0033233107994919244,  -0.021931083585596322,   -0.046180982515762713,   0.12079747784942289,
       0.02724796104527015,     0.038573763521458436,    0.13271700642247347,     0.027712495056413732,
       -0.059471500059783716,   -0.12737561573243511,    -0.022670635856870652,   -0.090310881856930536,
       0.10503179959662487,     0.052103741758883208,    -0.12216297038193251,    -0.014188231910732214,
       0.1122271264790345,      -0.018758733238868175,   -0.20286199091314061,    0.11426634983343244,
       0.015508933163649218,    -0.12217541090861989,    0.016482149658891006,    0.043577388019533529,
       -0.12625731738579068,    -0.20300345722274268,    -0.093253477027220422,   0.19122594132957332,
       -0.0020027812592686677,  0.069629451086000244,    -0.0071942854939486475,  0.096434929557219023,
       0.16655239961482865,     0.016191336222492542,    0.093800485090134056,    0.036811431341741925,
       0.12405982903211882,     -0.085399078690144986,   0.088127433730233018,    -0.095398580410652536,
       -0.032293128228966017,   -0.11094457718581106,    -0.23177338547120874,    0.11662665988629205,
       -0.086506823141638364,   -0.076295259354512285,   -0.14983384408928668,    -0.092321345880211333,
       0.091089762521308959,    0.12362117447413812,     -0.027891252813823139,   -0.048985856163123891,
       0.04531779657384246,     -0.20405285216516739,    0.089941364557763234,    0.079256986282953204,
       0.046401870861471475,    0.031261890238549569,    -0.096117129139222796,   0.049015803334136333,
       0.18267162098650613,     0.10879937168279549,     0.048226371719873248,    -0.099562033184191531,
       -0.056243869388706423,   0.15769576410621072,     0.036503980541325309,    -0.043814280284543768,
       -0.055751766121630353,   -0.18399042471548988,    -0.039929432926735522,   -0.023041794956921151,
       0.093309327368540487,    -0.071300398612030594,   -0.10714116016287431,    -0.17900486097202442,
       0.20258358121344219,     0.0065498622573373338,   -0.018445688029859672,   0.049273951442215178,
       -0.17923407780253406,    -0.13308652069697574,    0.20586026669209093,     -0.013181114973991968,
       0.1015788480140405,      0.035521134697998641,    -0.01727003189692651,    0.095185789757221542,
       -0.057586282423346707,   0.053718595641796575,    -0.063497846779610512,   -0.10698980933600445,
       -0.12114819391525003,    0.0002542915839217339,   0.027329627183502972,    0.12425322558724664,
       0.04356493028842038,     0.038294509805301989,    -0.18122910187971272,    -0.026812478260960927,
       0.097262206358229131,    0.0025775581053712952,   0.002284858263131555,    0.14148561730107825,
       0.14723733288637053,     0.18483701811640613,     -0.23366432466901069,    -0.055049840705414799,
       0.071445090523924337,    -0.02081670810268893,    0.015694029053168804,    -0.015111241648824882,
       0.012669856298038159,    0.012719655354492907,    -0.02106296594152313,    0.1707267619533559,
       0.0432435840856258,      -0.031494240349422338,   0.0079486203358418595,   0.044838254675965562,
       0.098370176009845142,    -0.17026828305597991,    -0.066875288888254975,   -0.089105397936828437,
       -0.08311563107456181,    0.076334668252572527,    -0.10831462266396177,    -0.033333926337788908,
       -0.064670773354810224,   -0.16164268053634037,    -0.17809537855173807,    -0.042501544656908558,
       0.013213050831589761,    -0.069278376538741471,   -0.21846684303867892,    -0.084934006229566886,
       -0.086751872250558651,   0.0085935571383600855,   -0.002336272039103581,   -0.10090629532841797,
       0.011413583338214645,    0.012020421723995206,    0.084144090158100746,    -0.032322615695761982,
       -0.12128753173409126,    0.060888032810291516,    -0.041487674217099604,   -0.0171011562040887,
       -0.0035166042929679277,  -0.093089252837628547,   0.12236702276359561,     -0.20220303898523342,
       -0.035298692297035444,   0.1299325354237664,      -0.074274137853078279,   -0.16525766157960822,
       0.076444557636552696,    0.20168147251649526,     -0.068881533138562712,   0.020015249230888869,
       -0.048672937429874275,   0.20315582446007704,     -0.165028332735392,      0.035782341503930351,
       0.15846124538142425,     0.12094299298303039,     -0.0091161262354049217,  -0.098539628507880422,
       -0.14086597180294541,    -0.018292285422666976,   0.0083126801856124883,   0.039576716484952798,
       -0.044219423875892616,   -0.03367231540170465,    0.082086422532481898,    0.19497775614462573,
       -0.10101889884806324,    -0.18754786193367728,    0.093136817654664777,    0.028513019729602261,
       -0.17228105278353328,    -0.08152580099498162,    -0.11080057330020868,    -0.023258482501054629,
       -0.035886337812196259,   0.13628049268900885,     0.037961076620638572,    0.0049873858905195041,
       -0.078616850628009383,   0.019828345009965352,    -0.098297503844557571,   0.051706581065613502,
       -0.040356520287754827,   -0.26536892370679244,    -0.068883634956133463,   -0.0050297307251893578,
       0.12954171890018165,     0.095704045351054673,    0.039332551390135861,    0.13229785099728611,
       0.052651019867428234,    0.13116041841187581,     0.20633349931644185,     -0.097865402789004519,
       0.1327110188594279,      0.077788674263791519,    -0.0012427730584571902,  0.0065796458254069462,
       -0.0068209363880348713,  0.017516612271347418,    0.11608101713789769,     -0.032759114313028179,
       -0.08281631014692982,    0.027980726309364195,    0.050154072536736219,    -0.067627338647407484,
       -0.098262121675996406,   0.12817037023272707,     -0.11277609235633593,    0.015243379516992114,
       -0.12868454439065033,    -0.15344385814219957,    0.050650803126773121,    -0.088352513878160538,
       -0.043163762863153189,   -0.015637284522336824,   0.011324665941004222,    -0.017071836894394333,
       -0.11218326025728972,    -0.011386892274125544,   -0.049920617218973611,   0.063357404051566979,
       -0.21337166434331253,    0.021211133300718707,    0.064899923948377083,    -0.19553433034371911,
       0.082844635879501347,    -0.16563518545214476,    0.048320194035050779,    -0.044846698273993069,
       -0.030893291729682998,   0.0026535607707887541,   -0.018319131316230877,   0.12876777936156802,
       -0.021824541800135176,   -0.031119984653880085,   0.11922066245808972,     -0.024805099346176938,
       -0.12424634967492551,    -0.04093700102018405,    0.15685849528068366,     0.017848678718007844,
       0.16823412385361419,     0.10018948989597641,     -0.21743852736469749,    0.027030904239057778,
       0.24908806647995121,     0.060464166736985916,    -0.070592889597663189,   -0.13768257692076394,
       0.13943104754643101,     -0.024010382435025443,   0.14789282201636034,     -0.13341669504679821,
       0.056741767070773295,    -0.0577740542374931,     -0.0039210321660201729,  -0.087033239795534456,
       -0.25810766274523839,    -0.14150928906537152,    0.1404571854754641,      -0.13801577568851991,
       -0.18380414272098761,    -0.13203398087586427,    0.054163832060209464,    -0.025658610813577298,
       0.10446311947522186,     -0.030234078159531951,   0.10049068330339268,     0.120599129879627,
       -0.004375269359948906,   0.064971985156196732,    0.057007957006024533,    -0.026548763252326767,
       -0.070173774284278401,   -0.19404670236021682,    0.032073852644275598,    -0.0293196644260122,
       -0.0065050080596217559,  0.13516888980230518,     -0.018744539825952446,   -0.040372833032399656,
       0.14169934713265009,     0.0059538743318703884,   -0.13492206344962898,    0.083502845234022377,
       -0.07232828534559696,    -0.070313067034835919,   0.0081708087523950854,   0.0090965078072524769,
       -0.10380588837152116,    0.011382061971600868,    -0.0544344056866988,     -0.10818095294965256,
       0.026633890616782795,    0.022979454068758221,    -0.065952043316816353,   -0.1012297441864231,
       0.0029965934217353468,   -0.075525552727586986,   -0.12511505621021091,    -0.069699740861508236,
       0.0094863560730374281,   -0.02478533853677415,    0.060990331093333239,    -0.03978970232377315,
       -0.059170866430367244,   0.02235840793617341,     -0.17976147297549488,    0.20504701427766089,
       0.056126115285887929,    0.03219572026778874,     -0.16061476979192085,    0.029370382390310153,
       -0.076296479848971907,   -0.047477707019697148,   -0.041139195433259536,   0.12322052234883145,
       -0.056662135480161399,   0.046423638566191985,    0.005792426259218734,    -0.067923371283817535,
       0.058482936173194902,    -0.026422739559830832,   0.020878359640634479,    -0.069893399867398898,
       0.11420451359080507,     0.13224101424297116,     -0.17858582442896714,    0.023136177054340401,
       0.0021905035626285756,   -0.17925044149657235,    -0.064385755669734382,   -0.031279135880207816,
       0.0069316120588195432,   -0.14391769738953342,    0.032326873190941477,    0.064977918928404085,
       -0.094712810178349927,   0.10156761396778322,     -0.17460937473273219,    0.040396743422327581,
       0.1382232074647077,      -0.095518638609655995,   -0.02835417214945923,    0.0050104203727587768,
       0.098657810388326189,    -0.03705255843643749,    -0.15883331434933573,    0.11871387730006859,
       -0.071828845401068098,   0.059367968414627922,    0.25139577441106192,     -0.1103426403487085,
       0.15762091215256258,     0.067850348002562066,    0.1522415654013331,      0.0070791655575377782,
       0.11110528681155028,     0.056677901611395222,    0.03664651910219064,     0.063420078414981665,
       -0.079123449740294338,   -0.06960562388735736,    -0.030358000543504168,   -0.064438998256001287,
       -0.13835793095470511,    0.08748867714429788,     0.044124172977525293,    0.15390281356089267,
       -0.20153307823729594,    0.0030559722119854332,   0.095631511509198713,    0.21421603065220657,
       -0.034772282710772061,   0.11345663380912742,     -0.018209972874515694,   0.057986046194495613,
       -0.035815093572204235,   -0.034677191247855246,   -0.021618079647463047,   -0.032259060303055906,
       -0.069492090674994483,   0.076304730251042147,    0.078636503950109612,    -0.15471793879533616,
       -0.21810487342338836,    -0.047887653168718028,   -0.079010954576178266,   0.076713834218375174,
       -0.067912169848505469,   0.055425118064587886,    -0.0056692437517238299,  -0.0082812092419489013,
       0.00026815885095237899,  0.1113464357496165,      -0.022281682487722297,   0.15102400658985257,
       -0.13104144360623457,    -0.17591069455651481,    -0.24110936846265357,    -0.0089748892294120881,
       -0.0032939640706784248,  -0.038836552683121119,   0.067941305120856568,    -0.16402695101571782,
       -0.024842936344611384,   0.060520568397156194,    -0.10105373169149368,    -0.013954142211967056,
       -0.076550023873274115,   -0.025273118642536868,   0.10732573135160488,     0.064737366877764352,
       0.077695004873595708,    0.036258473391610264,    0.082284531401695574,    -0.13216485077116721,
       0.079139452089761642,    0.10581511360449464,     -0.027083724264330127,   0.062970910280670381,
       -0.081850431007709556,   0.10237725185751258,     0.013528379389309135,    0.18210929326309902,
       0.022724037832604845,    -0.045388000026349289,   0.0391589556671827,      0.076149380338176573,
       0.11600555408375846,     0.086041585967440465,    0.12687356772035366,     -0.056267716459005405,
       0.13869100871030882,     0.075142818321124183,    0.011715152686113625,    -0.10120976815327855,
       -0.20977731764193211,    -0.13492266729713789,    -0.046897340749623546,   -0.0179885735699996,
       0.059260417671330876,    0.11032800345059594,     0.20815116264104261,     0.012726110656174593,
       0.021723077895540115,    -0.093493038241895796,   0.096800751467166227,    -0.005801209223483172,
       -0.065575364764023411,   -0.11412895779584133,    -0.038534069783519476,   0.062715864036884061,
       -0.060085371433657622,   -0.14275794396872535,    -0.0057591762204213968,  0.16800265816940252,
       0.041592577433521141,    0.176897272222519,       -0.071566295085598933,   -0.14531756067609303,
       0.15353541920886588,     -0.089668815023852294,   -0.10378389456462624,    -0.067385938822423094,
       0.048332964747687314,    -0.02551368896871084,    -0.0056567975897865953,  -0.13090241960277249,
       -0.027920874833450585,   -0.032943805332739683,   0.022921288248968053,    -0.013525260248561908,
       -0.18396403332153502,    0.047534834048484097,    -0.0014873789741967477,  0.0055763179282677655,
       -0.04545269034714125,    0.02122469306792962,     -0.021163269335282092,   0.16775442969461371,
       -0.0074545403513975967,  -0.18150422577150135,    0.041019697146744617,    0.03452055034322981,
       -0.030824493922023608,   -0.086506574401169239,   -0.18132009756721429,    0.1808423204630876,
       -0.089365580102336417,   0.032417903931129588,    0.10366473423404031,     -0.0071472615934037743,
       -0.0051853076685863296,  0.14740117077219045,     -0.18814445951750572,    -0.023486575566189882,
       0.071897266083133723,    -0.13137780057050352,    -0.062373166761917884,   0.13443815490808825,
       -0.010578315219305407,   -0.10123377330357103,    -0.19381910337205924,    -0.079751057929725797,
       -0.040224363128581186,   -0.19406379460757781,    -0.040830374005738079,   0.17232710671243995,
       0.020226637263380025,    0.030093231568539186,    -0.15352275305083318,    0.1835504327441175,
       0.043656706731700724,    0.043382471089716081,    0.11614956322581801,     0.053986225238797439,
       -0.020391283551064336,   -0.075985698904433768,   -0.055854976975381838,   -0.17675530858485222,
       -0.20572425608839937,    -0.047172865256097145,   -0.028453430226945881,   -0.038237599988169252,
       0.049049382408050742,    -0.093845756552058859,   0.13888351571649268,     0.078101701961896072,
       -0.029959972858162841,   -0.18384078629818981,    0.041544370683385658,    0.085986452921496245,
       0.010863351870266222,    0.03932767147953322,     0.064709534854429068,    -0.11434632287571393,
       -0.064186969830115584,   0.12952632038303705,     -0.053674062029774747,   0.071085046301910745,
       0.13649935470428851,     0.11438710365746682,     0.084919528708048794,    -0.059037538038472497,
       0.0075833035323315118,   -0.13647386271920403,    0.018763383977071259,    0.039762761189314218,
       -0.13245992610164684,    0.039913336954391261,    0.12798050867284111,     0.1679576868880259,
       -0.075501117603655604,   0.14356305004237369,     -0.020735979637816315,   0.062074926024596001,
       -0.041812587255646377,   0.020872813312761286,    -0.081621247517595627,   -0.022032640603554806,
       0.026134122845357474,    -0.30033729369091655,    0.014366009402872476,    -0.028857529859907145,
       -0.051837323649454835,   -0.13188660144692427,    0.028359137026403115,    0.065127316040804434,
       0.023665004206646304,    0.033765812327540078,    0.21277378598851868,     -0.22070474318887712,
       0.010151963295630298,    0.010213915952959297,    0.072952374920193935,    0.035821790232618334,
       0.023123633168746195,    -0.1459570005558912,     -0.027075686518719187,   0.012387973599632906,
       -0.1262744283999481,     0.16959370585986283,     -0.0025542026954020781,  0.15738135696169861,
       0.09601293100367661,     0.0040878341218922153,   0.029125390531048151,    -0.028742684331521912,
       0.024217163299164662,    0.027729131116844066,    -0.094462120551476292,   -0.081214162137215454,
       0.20341670862165426,     -0.099285800304103056,   0.14165268023825603,     0.031987089200645767,
       -0.071759097219564111,   -0.05273683052074097,    0.055893513666890299,    -0.24621264933952589,
       0.05698071353951057,     -0.04605297723803338,    0.014759567068276965,    0.14067918057305004,
       0.19709304406300091,     0.043789795916057243,    0.099857173637947882,    -0.021772317951077556,
       0.10828856901566418,     0.054834731613668294,    0.046064782419395371,    -0.05820948682195113,
       0.047309321717913425,    -0.044944178098494297,   0.06320308509736472,     -0.021784897745590007,
       -0.052749217199954755,   0.22591356799995505,     -0.0052833556990731414,  -0.053637205374161612,
       -0.11452753822564757,    0.080220933516043161,    -0.11053437492639714,    -0.034589944733685214,
       0.18705002385969688,     0.0052599337105983818,   0.081384423112515508,    0.11273474837338154,
       -0.13851911933948968,    -0.105072961278091,      -0.044087815683204648,   -0.057583258944631184,
       0.19158983625496034,     -0.052951435799198199,   0.058586971491575483,    -0.077614353267982772,
       0.0061702694262534691,   0.059821034206608448,    0.093421449773510204,    -0.058191976587737233,
       -0.03073474153232417,    0.034541825856284188,    -0.03458747238167046,    0.10372305421804121,
       0.093852176496917475,    -0.092799335931133334,   -0.1820161030465535,     -0.083965615971516444,
       0.064127983307934608,    -0.046082111356363802,   -0.1048745179270124,     0.11620704402917954,
       -0.062922277494494791,   0.064970662149750585,    -0.082516735027296256,   0.068178737207183496,
       -0.047972114808169861,   -0.062042498816893291,   0.011714823104209527,    0.02254343178340602,
       0.083346074628678574,    -0.14994958380369883,    0.062325559359788084,    0.040937454459378783,
       0.18139940249662367,     -0.0071768198436490231,  -0.016969078722565402,   -0.003474823711267339,
       0.050052042910317708,    -0.027442763307311234,   -0.053854593545545532,   -0.21735691512371025,
       -0.035002155410294937,   0.0045851997410106442,   -0.0051740933590502716,  0.083180961288201252,
       0.13729103962600486,     -0.0752052224712116,     -0.024547717110226568,   -0.051324108910522623,
       0.097070690061091633,    -0.044567165654354569,   0.0033650288644659809,   -0.1744525012978618,
       0.093454912985434832,    -0.1708588905456489,     0.088260676481850139,    0.06774410417788404,
       -0.077619783891711383,   0.11889983672471902,     0.22431703610823073,     0.015432879847532183,
       -0.016832223356040312,   -0.14254690762252437,    -0.0042353753886911934,  0.18041171797579114,
       -0.11387547789088577,    0.02451076410833283,     -0.084874596932935392,   -0.14380707890473135,
       -0.074138150374228592,   -0.074182042514492785,   -0.19988881282892537,    0.01144300251764919,
       -0.041971044282796056,   -0.19513085251125684,    -0.079596836826802173,   -0.11048753083254212,
       -0.017411917077274651,   -0.01957055979804297,    0.060400929833083511,    -0.053332638126256798,
       -0.10276907553353812,    -0.18549772342417331,    0.02882838415594079,     0.14212183751613469,
       -0.066717144944227896,   -0.042719096216981917,   -0.09613527977816512,    0.12912957651152232,
       0.060402157284162358,    -0.051890805054933431,   -0.07486610833626034,    0.17840041367958118,
       -0.20396881218418514,    0.016996744750749852,    -0.074262433567093653,   0.062047390509614622,
       -0.015886441122151134,   0.078754452142904857,    0.11710556640163533,     -0.052457833582171931,
       -0.0054787635080777008,  -0.011457778966691087,   -0.18414247036927175,    -0.12101799706887978,
       -0.23460218596733323,    -0.11083917917482884,    0.034878363684732357,    0.077500304427916417,
       0.22524447757097363,     -0.025884491235058961,   0.049494147006096958,    -0.011678562650495074,
       0.050675333004136222,    -0.11498271015773508,    -0.0046271027224751874,  -0.045334425923592957,
       -0.02704805375977434,    0.10488245457039869,     0.023665895883379418,    -0.011962520738981101,
       0.059008509276380787,    -0.14511431242941522,    -0.13576197587579236,    0.22658938521884758,
       0.11567532976601286,     -0.11874697476755659,    0.0016718606192720432,   0.12204321791174455,
       0.11376075845378041,     0.05053981236512288,     0.12394020172280254,     0.12780062004979706,
       -0.024485197691412421,   -0.073012040631844008,   0.080077244042182916,    0.070431578366155601,
       0.020021048183267852,    0.10163342317090736,     -0.024696736671998565,   -0.03515426021940813,
       -0.097999518898880034,   -0.02255420122768953,    -0.050234106778125502,   -0.036766476636373051,
       0.27585168437443097,     0.097541130999302617,    0.26996748012922223,     0.096714488975644095,
       0.072637565900314838,    0.0043554866414899727,   0.017701557091110542,    0.034912764863568889,
       0.11003537632748639,     0.06746203148897828,     -0.082559585404231806,   0.17552208878104306,
       0.10669917625870445,     -0.14554378559285489,    0.012561896836014993,    -0.12862988557364033,
       -0.085566098550040853,   0.071009666495471538,    -0.0035438743616420911,  -0.021238406011090685,
       -0.17943816458742942,    -0.13677834414677051,    0.00052215368843768276,  0.040818803858302631,
       0.017683730644385959,    0.06323253975326612,     -0.051371179035587779,   -0.024945193327959192,
       0.11868627029399664,     0.11899880610605924,     -0.027358499238569201,   -0.0075267826984282355,
       0.060044412248912347,    -0.059264228348368905,   0.30408234889975161,     -0.046259846530292879,
       0.047636770811560702,    0.066834997977754329,    -0.20268249872838251,    0.048707253037244838,
       0.03299881245041577,     -0.11519452723811968,    -0.24270333276582112,    -0.12481297097648708,
       0.01033122384853624,     -0.033914313219373271,   -0.04379989302577865,    -0.11898260745126037,
       0.0066994880260512184,   0.12439576993081415,     -0.042606575738522376,   -0.037825356654585626,
       0.076082170861127826,    0.092911657652936228,    0.033843885507958367,    -0.022700257140448578,
       -0.012745429109008197,   4.8228527088061551e-06,  0.071993644775396576,    0.090003225547756555,
       -0.024128739162019307,   0.026826859261712837,    -0.0028275818099118347,  -0.0041553762869571027,
       0.0729452103338116,      -0.087696028850851329,   0.090616324404976578,    0.17612800748842314,
       -0.027394366484526738,   0.042359781531291725,    0.2152397895140267,      0.032751622666642832,
       -0.15978060492680479,    -0.010052111273294358,   -0.092099782524927648,   0.17224588482959236,
       0.13937734158584136,     0.04718042797833269,     -0.015710786395356089,   0.042694029098958801,
       0.010914994321841084,    0.032413488241428069,    -0.018784002617312397,   -0.0017253942706460697,
       -0.090579028901469918,   0.063968310113019178,    0.17836060467620724,     -0.062799678302039835,
       -0.1514871859953853,     -0.049633112796930112,   -0.06987182971878414,    -0.023021836217650634,
       -0.056725566794192758,   -0.12361638670576436,    0.066885503620520786,    -0.031480154897143259,
       -0.091658941748309811,   -0.0730882383423163,     -0.17074333239155648,    -0.13662017219208222,
       0.21348319342389185,     0.041333392894119629,    -0.20687027743144062,    -0.095212741366863071,
       -0.010292005474597275,   -0.015951528801276094,   0.055144644559686269,    -0.040227627904730515,
       -0.13426258756934628,    -0.017597710769545916,   0.022484235861702551,    -0.11553349785817983,
       -0.15541256956508892,    -0.0055455210157816012,  0.035215875368709751,    -0.14693537922073965,
       0.026704534665766576,    -0.13020869051240117,    -0.038936959927711005,   -0.21931508821020856,
       0.024496469667618911,    -0.163029889531524,      -0.078491402898431817,   0.029082382540337057,
       0.12921838304213029,     0.075428987830134409,    0.033100106957083028,    0.12568280936592319,
       -0.02584164826164552,    0.15770143354463145,     -0.11102598734227501,    -0.04002997652735367,
       0.065438692068512008,    -0.16451335590393107,    -0.20100468912346231,    -0.0027353243212522261,
       -0.064622587499902046,   -0.031165572450962267,   0.056469860166664172,    0.089361694356791338,
       0.0018581045625541033,   0.032627071021351511,    -0.027711289415554202,   -0.16398185634717855,
       -0.024126672592526231,   0.012346071830061698,    -0.12315280619297836,    0.044487216147816963,
       -0.11166102933575278,    -0.14107409428029949,    -0.11485581095508293,    -0.11552861994700966,
       0.019486209274815855,    0.19487044037384341,     0.062144248177461045,    0.019759447867510112,
       0.062761244987995846,    -0.12848987629442474,    -0.083738074008533947,   -0.017454197187013683,
       0.026879707176325995,    -0.016837033630198388,   0.093701152438893764,    0.083944340337208059,
       0.062830522456762156,    0.030539393297878636,    0.045832395040132007,    -0.1259327586138535,
       -0.17048838647961018,    -0.12762701672558421,    -0.002594360814977225,   -0.21805130318085961,
       -0.13160364339304673,    -0.1025840995732417,     -0.19391557016356759,    -0.02671978913159544,
       0.014150171010379076,    0.084437747156297677,    0.18945005932328543,     -0.027488025565002246,
       0.14735704557974377,     -0.086687827162209269,   0.022694654212180559,    0.0053959393803999492,
       0.077886372407003426,    -0.050650347887613002,   -0.10259863900766709,    -0.018758161727829757,
       0.11175911090199703,     -0.0099968784628741165,  0.040463065317612609,    0.04043082346997133,
       -0.080945668083641828,   0.14855891448191683,     -0.10347778558664047,    -0.0032137884055663517,
       -0.2127841841234811,     -0.10108042027465654,    0.048243335594593033,    0.077186493475854545,
       0.064747342029124869,    0.019143356277199351,    -0.0024055814745703426,  -0.1482833580917613,
       -0.067809977546233469,   -0.051510754275970731,   -0.17386649761383399,    0.048250731065656256,
       -0.055236912035399661,   -0.048960942649558761,   0.052793015372432354,    -0.14229593362302895,
       -0.040934804700073657,   -0.021708197861917446,   -0.21039265298347179,    -0.18438523570331966,
       0.15809753772862647,     -0.011798495374417833,   -0.042711730163824055,   -0.063099232655174212,
       0.13903456187682336,     -0.032329535912460676,   -0.20298058173086603,    0.007738262580429655,
       0.097621988606255566,    0.01178913078190807,     -0.012644176835999381,   0.14824199084042611,
       -0.16974227025840682,    -0.089592810080497132,   -0.098609175002525459,   -0.049575161089900725,
       -0.12648010176353153,    -0.041358129268646321,   0.1579261230129852,      -0.082940736346245242,
       0.11570105917865833,     0.022231690859442196,    -0.021836169593747054,   -0.017523296021255519,
       -0.10269894334936341,    -0.017822903152177941,   0.027103665792107011,    0.12478742589245968,
       0.061682993572549659,    -0.01664653333255034,    0.10008989416146256,     -0.13895925190259664,
       0.11666287432605683,     -0.07575649429805148,    -0.013664182049615758,   0.02514173913799804,
       0.078961775183154836,    0.01455594216443412,     0.10289485096763094,     -0.0013851201283132223,
       -0.025263534507790845,   0.26628063657522705,     -0.11351854259835122,    0.034023090531218998,
       -0.019034389518583383,   0.077701467807864036,    0.056338334145539896,    -0.0073704862767782278,
       -0.11720175627176045,    0.15384295013139421,     -0.0071958336727984398,  0.16577250579014058,
       -0.078143079050830636,   -0.041227544332410118,   -0.012425629068796977,   -0.12585166058847624,
       0.0041455212827344271,   -0.12067982878034166,    0.21568321989295139,     -0.013007583485599871,
       -0.084254783210356954,   -0.0094101036368592385,  0.017216568719219793,    0.018218481711169569,
       -0.17512694241214186,    -0.085240191318713965,   0.077812643472775306,    0.094850731643138009,
       0.14051787753231715,     -0.026321423605240438,   -0.049340239940107083,   0.080633405149290599,
       -0.032597336486784659,   0.051164670668584822,    -0.099310330056268534,   0.15446852630079846,
       -0.14524214847223976,    -0.010234151865616091,   0.024267026486769962,    -0.020093266999512641,
       -0.047193996559753398,   0.16531898911374782,     -0.046459734585931937,   -0.038100071848514661,
       -0.16377880754570284,    0.081634484676202476,    0.042126307566909771,    0.043654201418948733,
       -0.038644362463414197,   -0.072496840079031885,   0.28512901729701878,     -0.0072848355595933386,
       0.10746541820314642,     -0.16169360575016545,    -0.037212551102032601,   -0.0015986078276537898,
       -0.1714292078735481,     -0.089409114694420547,   -0.15036696863567395,    -0.11489178169186207,
       0.10057374856167633,     -0.12215093866136853,    -0.0064495902209806052,  0.075625629919208515,
       0.16324931544083615,     -0.019302937193785979,   0.0818483825825118,      0.1802793547495678,
       -0.02282428062074697,    -0.0011406582066366406,  0.08007183894632576,     -0.03713917151962183,
       0.049336256244875129,    0.089785338673834675,    0.01731273255109745,     -0.03377661148797409,
       0.14521758578183885,     0.021547679052501056,    0.043700834444379784,    -0.085241513831002078,
       0.0030418606788252074,   -0.049532946158844973,   -0.13358926759612438,    -0.033392543067730748,
       -0.045503245848229311,   0.10701488270612063,     -0.049700527881261287,   0.033894400153320153,
       0.10173617352871016,     0.17283361706781558,     0.046509492223398161,    -0.13462094641673295,
       -0.15522257006977247,    -0.126032840534548,      -0.015769227525211399,   0.060836875481648026,
       -0.11494213319532227,    0.14732493613600661,     0.1396174978160763,      0.12339928870406015,
       -0.14637756089887255,    -0.042098693545490666,   0.086204337501078657,    -0.025586601033705223,
       -0.064269781929868153,   0.09663691869643444,     -0.099343364358817118,   0.11939249684339651,
       -0.08545499691830348,    -0.017687719731135476,   0.076538402719747406,    -0.028571799811792,
       0.051632021429333722,    0.12233549073300141,     -0.20417928873346133,    -0.018643756128528862,
       -0.17692786616178111,    -0.050018938272116717,   0.17607430624280496,     -0.063143314579640494,
       -0.023768411660297136,   -0.087099693440961995,   -0.010098527131264965,   0.10864135508464456,
       0.15972845443273809,     -0.058872842687480539,   -0.20348122831017593,    0.029771750490888409,
       0.17597133223010866,     -0.049215713303697749,   0.14706467506843951,     -0.048514731811093455,
       -0.010637019626498965,   0.26278995475561318,     -0.024900410370874378,   -0.065600143758727969,
       0.15295566455179455,     -0.039182581075474177,   0.1062928534707501,      -0.11648419937510453,
       -0.064239310858417373,   0.032217244783654481,    -0.089063533179991702,   0.11987814640313392,
       -0.025720506281796542,   0.071914250815273861,    -0.010321579857980647,   -0.19019044791452858,
       -0.034108048941707353,   -0.014545105060118375,   -0.10310560501228504,    -0.065032510723822684,
       -0.051678666953439097,   0.17423006413889064,     0.13057172375228687,     0.061410120455431698,
       -0.012372113633567473,   0.14756694089896308,     0.042568980871679388,    0.15747067410137272,
       0.090740230468056807,    -0.063883142397154702,   0.1745451893436645,      -0.08202793857804587,
       0.1609353879457035,      -0.077577788871254022,   0.084361441008597327,    0.023527577609243257,
       -0.085402256077954528,   -0.051875733832782198,   0.12622143240684516,     -0.026630240851969411,
       -0.037215984928051969,   -0.085865039381501612,   -0.045683882602258252,   -0.013644132118111147,
       -0.059822432971606457,   -0.082843127090079655,   -0.11140350540388819,    0.086471726976074623,
       0.1010123434619063,      -0.16006670146472632,    -0.19511026811397111,    -0.074413113137442158,
       -0.067039723989079286,   -0.075101651359875315,   -0.059676190750251476,   -0.0043511278553416272,
       -0.061686071483918872,   -0.053350389468769778,   0.054643837449879634,    -0.023308397792910364,
       0.12741814780363156,     -0.037316203389970562,   -0.12884583578347328,    -0.018597155240356298,
       0.046440698125334252,    0.10791598975653353,     -0.020943567290293976,   -0.043173020556720454,
       0.010458287458746104,    -0.10931060915209036,    0.13136797363060898,     0.12405649606000699,
       -0.097869638481259499,   0.17031555477561416,     -0.038516307635539329,   -0.024341931049598569,
       -0.094268276274250246,   0.010962737624048844,    -0.052465366382602942,   0.033710394783734166,
       -0.015669040543967835,   0.10433061863667305,     0.080141285324713679,    -0.14779664905838916,
       0.065109573322861991,    -0.047237256941291668,   0.059775237910562058,    0.14797441347038565,
       0.034547736322363937,    0.15923061600306479,     -0.0082160752326974253,  0.0030035946598269397,
       -0.064344331966268375,   -0.029520989237798244,   -0.11667303497156081,    -0.090624555801077755,
       -0.16769742009863967,    0.11634212180000016,     -0.09241375214000333,    -0.061414318670815968,
       -0.066189389893702572,   -0.031318857111150469,   -0.071085158479769622,   -0.064529217285189011,
       0.035602566669951034,    -0.13428895901481372,    -0.17842235195172509,    -0.032137518862168264,
       -0.030092549578542311,   0.053114687442381979,    -0.053950204319062257,   0.065499870480088776,
       -0.033117355921838593,   -0.047352307583570237,   -0.034198055846604285,   -0.18207867864990473,
       0.033653922449843679,    -0.093038303160034683,   -0.036464608869768239,   0.041170253638134577,
       0.048164833948899873,    0.22572104406651866,     0.029049245571725373,    0.044370431903817398,
       0.0034788079007295096,   -0.18406015768357203,    0.033187951534231319,    -0.11530785475857436,
       -0.033594756840455563,   0.16888045053828438,     0.16954029946731852,     0.082291320811229765,
       0.06907519111315906,     -0.29255961497109728,    -0.10973619391071431,    -0.060107790565906642,
       -0.060266767075574587,   -0.1079428743253802,     -0.11835593285963342,    -0.0022403684215417498,
       -0.038488996659458631,   -0.093632199217655379,   -0.072603397627699823,   -0.12096146517745303,
       0.090955840970023905,    0.093004477036654279,    0.06572600729112664,     -0.050361720063157041,
       -0.10449660776677744,    -0.088899580550154483,   0.0007400877663337785,   -0.16715008976333182,
       0.058032758361728422,    0.021740382633706434,    -0.23936747543734618,    -0.058453015586552803,
       0.036378134778971914,    0.04384060924944292,     0.068076462948198205,    -0.024732027548364458,
       -0.10356094282503535,    0.095746675275800941,    -0.0097138962922808068,  -0.0079168205701663531,
       -0.078430886345839057,   -0.051220935807420695,   0.049777664049199005,    -0.015216777062587549,
       0.16743165839779414,     0.087110771718301921,    0.089027359882879756,    -0.1057490628196593,
       0.1618702418222443,      0.030751179807761223,    -0.22464448718152275,    -0.19422129939033214,
       -0.23002033355690443,    -0.023174528357673155,   0.010173226023835562,    0.00077834475784800856,
       0.040350967078284533,    0.10180906635423534,     0.0039338031475887811,   0.15686088344864341,
       -0.047692644429603907,   -0.0076696659045705122,  -0.00090900046989692766, -0.050215588822656775,
       0.031364740850788754,    -0.1134429640537014,     0.1821948874647189,      0.040763557416064855,
       0.051925353884584427,    -0.01724810596933566,    -0.090986312705213859,   -0.15961482560906312,
       -0.10255296538376964,    -0.03519165019866248,    0.05546923087809251,     -1.9317891438540638e-05,
       0.0015074311925540101,   -0.034127077304734778,   -0.01150406252224051,    0.0189477040797509,
       -0.037375621915578999,   -0.0096247548728850708,  0.057047076954746756,    0.010244381517136358,
       -0.072379209944688869,   0.098156698027844352,    -0.10970449034635557,    0.028966584565999237,
       0.055947826776886631,    -0.20807859602622189,    -0.15172483307083223,    0.18102589537271346,
       0.10648804496630881,     -0.08352397088583062,    0.031837524352789491,    0.212699386451975,
       -0.050768780305570436,   -0.13247575087539226,    0.084491525178289464,    0.053524348799833206,
       0.12839786923342777,     -0.19020962021968438,    -0.032442000270830641,   0.047535163397218555,
       0.017701083963885721,    -0.039790175888244628,   0.073074861514913297,    0.096861148342114609,
       -0.076385385281139376,   0.078345060850081832,    -0.21066936695220662,    -0.10291432665874191,
       -0.075961781081700319,   -0.16928378427786708,    0.1073355163179406,      0.11897366674051593,
       0.0043969475360114236,   0.13575490786780156,     0.096529692493374342,    -0.095650896748709927,
       0.20297389968016019,     -0.029795832036534898,   0.11446994926325249,     0.25431994700025656,
       -0.038076364661906427,   -0.0052483640551611553,  -0.031453145503676803,   0.11880692303922875,
       -0.070752339990670973,   -0.16132679371474951,    0.085670955295375342,    -0.061029771167796766,
       0.10173205871645166,     -0.075893682942384286,   0.092276456263092971,    -0.17070862538184178,
       -0.038221695528680544,   -0.045145428663507133,   -0.099063068125695861,   -0.090332686627157072,
       -0.088964883922454802,   -0.026220332161593418,   0.027828277105204573,    -0.015743178959912257,
       0.0048868467696325576,   0.13614633865848841,     -0.025358219287751463,   0.10523709874811313,
       -0.20433930011169579,    0.019473829805422206,    -0.01684742795394624,    -0.029145080566979585,
       -0.048300904393103208,   0.024129359924936335,    -0.10558281979415322,    0.059873342070703744,
       -0.018127383613741131,   0.18781040817601985,     0.12628986273839979,     -0.005762193692288595,
       -0.00057013256577285228, -0.034066659977768803,   -0.071896166182404672,   0.22593336128545535,
       -0.089954479803586188,   -0.071067937116049723,   0.029617700867188439,    0.18044620187448068,
       -0.02844826399685834,    0.098758275795878953,    -0.022891764311639317,   0.15720123336732991,
       -0.010453641941350698,   -0.036567183748610982,   0.20801099237913423,     -0.21255027795366929,
       0.031656605356352438,    0.027448597768957909,    0.23854040158746248,     0.093785470959460604,
       -0.052265250120350423,   0.12561015104255011,     0.14191753263078566,     0.079259902929867884,
       0.13729650663453333,     -0.13096316236139499,    -0.20454284217588997,    0.090380023297207887,
       -0.16156103283710127,    -0.026597666244435086,   0.095344631928186596,    -0.14712920263640109,
       -0.08045382772932759,    -0.039015324886203767,   -0.17703375737461333,    0.17925973539493412,
       0.0015318343677832909,   -0.057045943066179952,   -0.19628755372037304,    0.053705968392688111,
       -0.0025190288775733538,  -0.087240187591038201,   0.072427254207210981,    -0.069962714778072074,
       -0.027325831388739581,   0.097520666844660112,    0.055634894642574845,    0.079653603851967389,
       -0.0044939469365765927,  0.075646719315475924,    -0.026624377954593395,   0.028960682797964592,
       0.07377445260384799,     0.023670028888380611,    0.0091519857437971416,   -0.1278750557016603,
       -0.047967920938976269,   -0.046682782682454842,   0.039142650397996803,    0.096398578761203474,
       -0.085951763571037398,   0.031801764004762152,    0.092344094319304015,    -0.010204833496861351,
       -0.029561736345217221,   0.087148525762812262,    -0.020014763037216318,   -0.17060486435030772,
       -0.16145355491122165,    0.013428805189223892,    0.015393905953648191,    0.020940537796966904,
       -0.008942502115388079,   -0.047028069741801945,   0.065991471572522997,    0.069396097545300808,
       -0.054503751254784488,   0.040943348746880631,    -0.070182502259728163,   -0.0055145920815214411,
       -0.26378040313655132,    0.14167342061886556,     -0.039587842613810043,   -0.0087740077272110643,
       -0.010803327698350768,   -0.022166901810335225,   -0.1475531891270295,     -0.054935320008996091,
       -0.030570537438321981,   0.051701294470949635,    0.074131348367951946,    0.13327225143631785,
       -0.038208919657205027,   0.1112176371999473,      -0.054118084939118592,   -0.041089080768020897,
       0.045417865872441766,    -0.050328697430247198,   0.020911734123509811,    -0.14255900972478386,
       -0.095269652347960962,   0.05296520780458281,     -0.087686711428062489,   -0.1361138437859426,
       0.016977003149087299,    0.14705691904373416,     -0.098676489552750074,   0.10600280091623243,
       0.045852177059375776,    0.0050619620604490292,   -0.085050808034549785,   -0.13350347422080094,
       0.13469419783714404,     0.17978703875319468,     -0.13096512079896266,    -0.046855370434429632,
       -0.023216137802913595,   -0.037476832638651723,   0.012726587076430946,    0.068107602466039335,
       0.074170317423652349,    -0.087108135620977009,   0.11928919999879091,     0.013047922350464064,
       -0.17740339137624275,    0.07460931862573969,     -0.071692570896718044,   -0.1845776441806114,
       -0.098189227479286961,   0.10235696739027585,     0.076196459649734011,    -0.057103719506040741,
       -0.011794075841522408,   -0.011165253368578506,   0.0068220348012747855,   0.0072436971979148029,
       -0.30042629161641038,    0.12654259236781679,     0.09999660308507595,     0.041961837156929714,
       -0.040697161319874692,   -0.083469685763808726,   -0.013141170473181122,   -0.1200206162138564,
       -0.017220907981505818,   -0.036274354960506572,   0.017267608945909972,    -0.023239604989760514,
       0.0039833434765570736,   0.2380473377404696,      -0.033561752119334431,   -0.10033849081141626,
       -0.081645564004348234,   -0.01244096157973495,    -0.068331367728922454,   -0.077809185774516662,
       0.16657249082321887,     0.12350910860156238,     0.18867022624647478,     0.15227061171534176,
       -0.10263433232631497,    -0.21442248970730973,    -0.067695250809250013,   -0.024310609558952166,
       -0.18703306408047446,    -0.02142854789745216,    -0.14694589600027536,    -0.042869952545608693,
       0.092817831548537649,    -0.049032044190574907,   -0.078157929445149432,   0.045637760636441344,
       0.11059938419509652,     0.095308688376056411,    -0.036604543475988384,   0.1159080437179658,
       0.0095525760795914256,   0.048494088166434121,    0.012680692147484393,    0.11434246739913626,
       -0.15728230343063535,    -0.12923431010465072,    -0.070447656534789085,   0.068632483463583513,
       0.065908646473007926,    0.079830441920178893,    -0.13744937749014707,    -0.066707171114926397,
       -0.15413194257038498,    -0.040853065767428524,   0.071636811837813008,    -0.0060504814549016354,
       -0.041057431842465089,   0.10712907028097035,     0.039125465983331671,    0.1319070193385132,
       -0.084584332326277115,   -0.15286651230251569,    0.049112512120846323,    -0.045322063630967371,
       -0.054552777617023845,   0.085607727169966494,    -0.010895834145240823,   -0.036749571149249316,
       0.15391717486919038,     0.076846579608284532,    -0.096314551458056133,   0.13558704390674173,
       0.022334827604784398,    -0.13966139849522224,    0.045778488305581948,    -0.12857919733750184,
       -0.0010211272064905167,  -0.010895378940992077,   0.2673554487364827,      -0.033813123080039753,
       0.022637754050916524,    0.072712515738931741,    0.068416400722826176,    0.1825986045687783,
       0.013599998269974994,    -0.14325119105385423,    0.081716929869102145,    0.10446991463387852,
       -0.12324404770694684,    0.012671311878959309,    -0.030556533765624696,   -0.00010782019240533972,
       -0.14067666748340335,    -0.14815280153668867,    0.088115544064336734,    0.12509902555825955,
       -0.0034906461281636065,  -0.040777970479998732,   0.0057584110927475828,   -0.068940448294983969,
       0.20655164786709518,     0.054685453072940322,    0.044623390144549135,    0.23708709092810151,
       -0.027621909026543587,   0.13900532705890317,     -0.054563266245517002,   -0.0015864064852416403,
       0.10074128232524199,     0.077742647971179649,    -0.01714630212380952,    -0.11468058562171311,
       0.1343329679596944,      0.074208095505133381,    -0.040589985991862351,   0.024831696323089986,
       0.2005341072827371,      -0.052256372507917911,   -0.12884821299208959,    -0.017050901634084396,
       -0.033159136159979168,   0.12410061916334203,     -0.088924431625871311,   -0.077496524453702226,
       -0.037508579318913306,   0.13570498855099675,     -0.022327993687314484,   0.061690715460292825,
       -0.010230729431860791,   -0.046390118012099239,   0.098091361014308653,    -0.086228824794801151,
       0.045659277839442555,    -0.017167977619600192,   0.16251329549798557,     0.11051454627075816,
       0.11173684016769078,     0.033270447684876178,    0.0080664390510970518,   0.090602470722785461,
       -0.14109684642072606,    0.020577816847043177,    -0.035859281567695502,   -0.16143134269416648,
       0.069672453141144022,    -0.13711275139332912,    -0.11978972370234398,    -0.26762399714557084,
       -0.078767016081599972,   0.052961088925470086,    0.047024482678794853,    -0.0068304836208085504,
       0.080720068200297992,    0.04498505622212258,     0.079983784209601103,    -0.14160260178395617,
       0.121477822892696,       -0.0021319572853905414,  -0.099122989361551436,   -0.13829565208028491,
       -0.031803281189782075,   0.036739473321192248,    -0.062974303340290749,   -0.05207147261169065,
       0.10643850670809879,     0.034541864742077079,    -0.095556532576394751,   0.11739039105109267,
       -0.093971082272045522,   -0.076824838306131557,   0.017877256246415014,    -0.018423165051156241,
       0.099201563497359965,    0.13467752384402093,     -0.029023309728398675,   0.096995230491240689,
       0.0088944590177793409,   0.01784869499770593,     0.022418837257477103,    -0.19086226873307374,
       0.07420913308695154,     -0.11382639814157983,    -0.11920805911343539,    0.063354073445508849,
       -0.10323999840898965,    -0.092455927266185609,   0.050791137352660887,    0.13698577680137378,
       -0.016461885073535073,   0.11460408864472597,     -0.097796957476528473,   0.035947582712324844,
       -0.022813184243952695,   0.10541329187108203,     0.051006869638589344,    0.012385723641177637,
       -0.039478658479044373,   -0.091274795911228682,   -0.0054109062702760516,  0.023289576671653586,
       0.097024013216837651,    0.1000495338817826,      0.027378257069893972,    -0.035086941666781647,
       0.044805111772054214,    -0.10658813562404032,    0.21507107223075728,     0.0058925538764394427,
       0.079049037411144496,    -0.14930159147917441,    0.040338782617962587,    -0.21054621752559899,
       0.041014306244838851,    0.042640734016139874,    0.025980921754058445,    0.0076960719084679663,
       -0.059029384539178463,   0.012627439785188165,    -0.10704714517898857,    0.20033958519411207,
       0.11519815880778074,     0.053209568090237747,    0.064745438533886951,    0.19116784301906872,
       0.032926207273043212,    0.044700628562148827,    0.056758728420148154,    0.17405530984040332,
       -0.075420512605576986,   0.010220108878549057,    0.03329788567758802,     0.095772438271905708,
       -0.024880667427527793,   0.1594130251525562,      0.083138272344082553,    0.20052979128380233,
       -0.07688280212846918,    0.13565170536857732,     0.009467562139102291,    -0.066862674283500623,
       -0.06833820216657098,    -0.040307364240472106,   -0.0493770834052394,     0.14772823077104005,
       0.25014918519043899,     0.074462137882949503,    0.031930363906999014,    -0.23966219731146271,
       0.034659186343500403,    -0.0008103062813017009,  -0.0085825511394225316,  0.050892694877061335,
       -0.055421409281592018,   -0.018743003950256468,   -0.32166287109434843,    -0.0073254047276318122,
       -0.14600460404174692,    0.064234058899695579,    0.078818109933228339,    0.1811522339161156,
       -0.042873104920182301,   0.098960975511376628,    -0.0040282084554986736,  -0.08963470394416341,
       -0.010719895889261349,   0.082374123543890732,    -0.0033412514000694671,  0.11292523030642362,
       0.012060764199450969,    -0.14184039208587176,    0.04138723457348667,     0.076751290040002584,
       0.021399157550840143,    0.080343466503528194,    0.23856021669725208,     0.008960417921343616,
       -0.051968042986157086,   -0.059371454468193162,   -0.069299585649170853,   0.064760894882759587,
       -0.0013561999782149285,  0.047308177894615076,    0.063223589603505659,    0.031474843607323083,
       -0.1106898871481776,     0.10708419623711185,     -0.068011379795073532,   0.037379555096150915,
       0.13884206937441385,     -0.0089168374797173652,  0.078498646815242282,    -0.0015988717211831819,
       0.094267260946926501,    -0.15115982058264432,    -0.15791321025425656,    -0.026043852768700301,
       0.19517931199001265,     0.13516736927332454,     0.022356083187133235,    0.046519383706391824,
       -0.023542273230441953,   -0.077180535587460172,   -0.036379634445396561,   0.04527007026334004,
       -0.14823873351969979,    -0.00061112866228431838, 0.045613120792009534,    -0.06429475346209948,
       -0.023352188297753439,   -0.12847869052742406,    0.10583047320169925,     -0.2154518731614638,
       0.21013653402318155,     0.029407356736207542,    -0.0071474312317513031,  -0.14991533682167743,
       -0.0062935808646828705,  -0.15384919441395692,    -0.024981567680516299,   -0.10820426828988626,
       0.18126934417098031,     -0.11938497553202379,    0.035380868951695878,    0.19167665139663037,
       -0.058640470970980393,   -0.097726366790260172,   -0.0081888162943134328,  0.041871775978505936,
       -0.065854690053828768,   0.056364024834097685,    0.01146159242215612,     -0.13667599156296262,
       0.12788651185333424,     -0.10985395489068545,    -0.15637467266008312,    0.18060374335548945,
       -0.046983072650602302,   0.054920372211855542,    -0.087306500528045838,   -0.089667155663092968,
       0.056074815732604547,    0.17097253006955931,     0.047535084830582462,    0.0050277277648316018,
       0.16763882696175608,     0.080915459913077581,    0.041077886572323453,    0.024879654746352019,
       -0.0050656290886661268,  0.085888004507332374,    0.17340660975785285,     0.076449944280132159,
       -0.0046232333321632128,  -0.021639241604918775,   0.1742900352167269,      -0.12475883953302491,
       -0.018357361982646359,   -0.13629987227964974,    -0.032904904270996779,   -0.11627039587155806,
       0.09628727958141553,     -0.12925264536411599,    0.093228420347536464,    0.011178809715119363,
       -0.15134937567811313,    0.032059677912148241,    -0.061301642979142631,   0.13620384562023111,
       -0.11261599935495913,    -0.1213798313493854,     -0.0075857856832532884,  -0.013613012822512942,
       -0.10802184776441097,    -0.012067665807438168,   0.0026234268813734958,   0.0084790074186786683,
       0.046573233932386847,    0.033844393631651155,    0.097517163886016917,    0.05231928505773091,
       -0.071253181046174952,   -0.14738183473301353,    0.031609760244670555,    0.1411488842723177,
       -0.031549310714271583,   -0.0073288213813429391,  -0.021108866737681274,   0.22571278368353723,
       0.039345491100100952,    0.050327323925075017,    0.011030085159748581,    0.099982453630452245,
       0.11465799296391234,     0.0040245938855293997,   -0.070675740854770061,   0.009137715921137558,
       -0.095073607394257659,   0.088200420825576956,    0.039433362072536851,    -0.15298584652929231,
       -0.16100036903301121,    0.16375174433315171,     -0.0088908794437755519,  0.078847244990123758,
       -0.022161459702829726,   0.089915164889680252,    0.0006990980314833823,   0.0086820550192247149,
       0.10212460392403817,     -0.021016997819353084,   -0.038687349006816328,   0.064814526562658195,
       0.060989130243941071,    0.0685347475931357,      0.082249772662803505,    0.068514401598630009,
       -0.096251119903634247,   -0.010688161907829997,   0.10502219969680163,     0.10814348198561249,
       0.087678761837238176,    -0.021844055676053492,   -0.21477145526285529,    0.081034326047493749,
       0.15797993307855671,     0.16922117756033461,     -0.17851770958317287,    -0.029007349139598571,
       -0.0024154355161092951,  -0.049061196896022688,   0.089819033299187251,    0.074798384468528656,
       -0.10958500665078234,    -0.13362910263714201,    -0.20420155018227032,    0.080422398009946508,
       0.25946239340044325,     -0.14963021470658147,    0.18908895122979658,     0.025410277641611783,
       0.060400379812643699,    0.1012687155057764,      0.15351583459982845,     0.15670995224515985,
       -0.19847436295718696,    0.0027033100277683922,   0.12361664380280254,     -0.11018754308883184,
       -0.021278771542909435,   0.096371365480534071,    0.053703397737528184,    0.083521721142649469,
       0.035892512783269201,    -0.035868868239604786,   0.036302729040603124,    0.00048400070948265454,
       -0.10596863022423764,    -0.20553519706517837,    0.0084958246906477429,   0.054981364290618839,
       -0.26622939859969785,    -0.024943489730604639,   -0.1129349076256105,     0.047607007841085673,
       0.050329676828051,       -0.062640387749300724,   -0.11573977007598114,    -0.036177302580484537,
       0.11524947380244499,     0.13225785346249497,     -0.027307643339041399,   -0.0035187090647472727,
       0.020878006890144678,    -0.16858398621452619,    0.044318250769989485,    0.11452153138704588,
       0.0025741338583283539,   -0.0036100451004833153,  0.10775378718431956,     -0.019253262126510295,
       -0.0021477812294005034,  -0.057627871625722471,   -0.21899854626109447,    -0.019222994410285184,
       0.046072929288772171,    0.24879303699785024,     -0.063054822312190367,   -0.0099204330216953671,
       -0.019416804762461656,   -0.05962336269937648,    -0.070433991931315568,   0.047694957047308965,
       0.014367112048427735,    -0.056421410276372819,   0.019394083295246976,    -0.0042825590286187818,
       -0.021091152781719791,   0.10555876508029441,     -0.23694475871414544,    -0.070438933845738697,
       -0.14762474579844684,    -0.0025218083575178885,  -0.0099356975888459896,  0.21146594855164397,
       -0.093040939171479847,   0.1375670136236963,      0.016777412587013978,    -0.042804199078311379,
       -0.07714307433468176,    0.014791891871685984,    -0.037033847439581907,   0.078685844240259012,
       -0.039491426970649779,   -0.040987968782931594,   0.019023338078507677,    0.12739699142421623,
       -0.0016447285319890828,  -0.093749781074113081,   0.011372172130001202,    -0.029273852558407136,
       0.089545382127621767,    0.028805928694397777,    0.007105619091158857,    -0.060142472633719517,
       0.08423123126952678,     -0.015855364425183198,   -0.10645295338178178,    0.11464818471529956,
       -0.076891198696093163,   0.18744667998795481,     0.039087385401165603,    0.00012142840529905195,
       -0.085612375617774072,   0.077009583282092162,    -0.030221696341147734,   0.054514084661256616,
       -0.041466646788069064,   0.16020165579286708,     -0.18821461216131979,    -0.27997839836116706,
       -0.08686830538798769,    -0.050953654310780826,   -0.0010482007374957494,  0.22204005764965976,
       -0.136098850876198,      -0.096679350564119221,   -0.20108720679754999,    0.04422829381720212,
       0.018379089519579925,    -0.061994761487162417,   0.034196386342269361,    0.05237286385605755,
       -0.057966681417731696,   -0.032711627232659773,   -0.09968762320880234,    -0.061692356233403918,
       0.0713225611012102,      0.026325808638550947,    -0.076221736286292308,   -0.042625525089758726,
       -0.24250463048698284,    0.10871761954672651,     -0.079633127766020551,   -0.019120110380042039,
       0.14684122656603477,     0.028222418549466093,    0.084588958792475119,    0.13262635876660606,
       -0.015021077935783738,   0.13553264519393646,     -0.043783246817187885,   -0.03338650007862607,
       0.093602788321497765,    -0.10823339182529955,    -0.1459213156525857,     -0.072728633900000242,
       0.18471227896457576,     0.097970039698074399,    -0.088281648340763449,   0.18887204511838979,
       -0.14743373416561986,    -0.087567616085302669,   0.11782314871644074,     0.14148328282237549,
       0.16006997698439074,     0.11774537697630019,     0.067786910389805805,    0.031614582506940291,
       0.01813857623621587,     -0.017968850966356031,   0.090829363077183645,    -0.038033354292639279,
       -0.072389054774455203,   -0.062175056837097523,   0.027680598822479537,    -0.095775850917756769,
       0.10017462302469626,     -0.13485465456528267,    0.25139965178045987,     0.10053446940386998,
       -0.11185392970596414,    -0.12300015655716814,    0.068776731593498716,    -0.096760662900538003,
       -0.054375076744473103,   -0.013011059923524134,   0.016940594701870489,    0.044986984289369626,
       -0.032338825630931066,   -0.016465787311249314,   -0.17460207367175359,    -0.04696587586798999,
       -0.081514452752369654,   0.086799057294292034,    -0.13613003906593521,    0.017215180562047815,
       -0.0068201093229088641,  -0.16434902366867404,    -0.022611697611437543,   -0.0081934540333179658,
       -0.0011774998513694596,  -0.013519979373577962,   -0.14200039530185041,    -0.033982592263640927,
       -0.022563584305677602,   0.0059084859786034307,   -0.11755328717047538,    0.1032287236600239,
       0.013342812832249574,    0.093689230503567755,    -0.031530140660644183,   0.098373185655353967,
       -0.1527085377656171,     0.093002616996395879,    -0.09525804805798864,    0.045293125558716577,
       -0.1745334914601539,     -0.14129882476802486,    0.07462543612620319,     0.0060421096107398887,
       -0.021988902223239092,   0.11443650459802217,     0.1068207958426638,      -0.10894339905283665,
       -0.018845613221431284,   0.20800151866173741,     -0.13809091936061599,    -0.19713505568922854,
       0.071154301855638188,    -0.045310541489505522,   0.049663528476334436,    -0.018807005624854375,
       0.065245291740779962,    0.06862412045639571,     0.014717398747961869,    -0.048494503638390973,
       0.078945599736757216,    0.023740784258784009,    0.015106218324760438,    0.006814476374165759,
       -0.055382619049338722,   0.10923738417320265,     0.0095451089065430872,   -0.060615928540235044,
       0.10884397279390136,     0.079294562691912249,    -0.062111724991109729,   -0.097797983338470423,
       -0.037429213313847388,   -0.096854049738712367,   0.027116968782176676,    -0.033155771537669854,
       -0.030171089781786765,   -0.11702923525480219,    0.018879353671563997,    -0.086637057528993505,
       0.043324255025672623,    0.051912092013913405,    0.094851678104820286,    -0.22438017336112276,
       -0.051119069038255263,   -0.0045517231950651946,  -0.034724073531992569,   0.048611987415425641,
       0.053331369994117826,    0.014184749783113433,    -0.082764199767847671,   -0.0046997616367413821,
       -0.17464595794074086,    0.06221744519838622,     0.021474771834617604,    -0.15754171138472789,
       0.11170235621747038,     -0.2711100166311205,     -0.048857782355561041,   0.016656499014872681,
       -0.0021739826743578947,  0.061615353831435592,    0.0048169240049200307,   -0.17613796949436183,
       -0.014391416818778677,   0.011709917413046753,    0.051590981161893944,    -0.050875916639371424,
       -0.026299872497454583,   -0.020020719521761803,   0.0028821280664197363,   0.12033883374064579,
       -0.031674268818015688,   0.014572957397242726,    -0.039014574893161458,   0.13260203050180794,
       0.067178168441515973,    -0.002109161875690681,   0.10866789424064457,     -0.056713023288276411,
       0.060220363052295826,    0.043525557538602683,    0.17966197035524303,     0.19896233951798933,
       -0.10966495411089744,    -0.085369099244036614,   0.016265224693020879,    0.26487161127930448,
       0.016798893406212843,    -0.083040130198182002,   0.16151226070038366,     -0.0041482275466722318,
       0.080391380449077579,    -0.0065080519851128298,  -0.0033581528391751349,  -0.091147244915000702,
       0.043662793916500263,    0.27291764104044564,     -0.1275520468416009,     -0.1206530805826866,
       -0.2793310806357413,     -0.0086555697387673963,  0.12535801037535471,     0.10019271592085496,
       -0.23884232131137592,    0.11340178517499919,     -0.048359636406601493,   0.044862889612086315,
       -0.12763625832214359,    -0.095259880739349614,   0.009047406048729667,    -0.0050005559159035842,
       -0.14650749206651426,    0.086232458264229761,    0.068629616240778624,    0.094402184986804333,
       -0.039099738320931887,   0.04680808327116303,     0.094883601168301315,    0.045059176999723331,
       -0.012633948952372246,   0.24111001677115548,     0.14974218628248775,     -0.075793596877619621,
       0.17719606834673587,     0.016826772427486314,    0.01955874932444962,     0.023165229857985591,
       -0.02600749503256964,    -0.11886299143359248,    -0.10451712574064843,    0.10378235434483121,
       -0.1263379172623865,     -0.05154348473542833,    0.030431387227262432,    -0.015945338361802133,
       0.063022903876597494,    -0.068416811092400956,   0.0063569208089112109,   -0.25701887967160603,
       -0.13848127461592691,    0.13602487044390915,     0.14199980502032503,     0.11663867141446609,
       0.028502785492418289,    0.010348887724711951,    -0.16167582591368984,    0.088952997198614922,
       -0.12056802207936343,    0.16603819656957694,     0.17107185303372008,     -0.031522184248057555,
       0.057258305474768914,    0.016416420195404107,    0.093870290061588355,    -0.083132801365445028,
       -0.029890036160850331,   0.059049206736555143,    -0.034933123559032629,   -0.15332495153196829,
       -0.17114692877035093,    -0.041775262340708788,   0.15584332665488426,     -0.026445434669776485,
       -0.066759155781568352,   0.065132570027318384,    0.030807718026291304,    0.1549006642468346,
       0.18612419564263072,     0.07838845341217171,     -0.067381321246028636,   0.048525221721954712,
       -0.10132019499490524,    0.085981654215901912,    0.039165351107687152,    0.053150018810112477,
       -0.073137877063117238,   0.061137390880399219,    -0.11108488592485784,    0.017153884029501434,
       0.24938023668054043,     0.0049484169674359688,   -0.053550938750558032,   -0.036520210326147551,
       -0.11161045432541795,    -0.13079871502279813,    0.070925664364779067,    0.021994458568961806,
       0.067909724809087718,    -0.07695015677211306,    0.073738540393743682,    -0.021257482988126068,
       -0.076621792759733909,   0.04194483536317975,     0.057986133932666918,    0.049168534582792967,
       -0.053588981403423261,   0.11374891348364076,     -0.042909931447319707,   0.12169204598483387,
       0.041381364487291739,    -0.051252443759163963,   -0.076101871747598956,   0.023002554318145414,
       -0.016306935156117381,   -0.030122723883025244,   -0.087408145891678127,   0.16462933719443243,
       0.1026955480530249,      0.1316549686752557,      0.0095871252612323918,   0.17025454929384728,
       -0.037206467144640223,   -0.12276922255993708,    0.073567254757647638,    0.1508166354424913,
       0.079768796304990425,    -0.011553904113977196,   -0.032146182543175722,   -0.14890062196915863,
       -0.045235724592312766,   0.20186559111852698,     -0.047333427155723501,   0.18669716981088066,
       0.23389672499126171,     -0.068155140264487116,   0.033557604435142337,    0.25518465344606622,
       -0.073716783256564875,   0.0071443106873298858,   0.049659669269293071,    0.052033330385743426,
       -0.024749321824036778,   0.093256350540519228,    -0.033782691941570527,   -0.21825645314376807,
       0.21418428395076025,     -0.026688032747776876,   0.091164036010881508,    0.19242093485115344,
       -0.040857095355313545,   -0.015649251932438456,   -0.014823188650758901,   -0.12887686133070531,
       0.074192354312750439,    -0.0091624635611989892,  0.014957538645523509,    -0.026058042757087983,
       0.049313891794878398,    0.086206746593242747,    0.050291138747600266,    -0.026013038495476506,
       0.0068444869254245238,   0.098943258477924581,    -0.087558729154558645,   -0.11302816121771181,
       0.14379019543513361,     -0.15849845456093345,    0.14103421048476977,     -0.078970107801646802,
       0.0092752123604681047,   -0.0037052626676677639,  0.12920526002668012,     0.089926574641858173,
       0.084304464782741187,    0.13060756987125696,     0.023397737052734527,    -0.11911280335996918,
       -0.067269031554646225,   -0.057972859807711018,   0.091149711555389451,    0.097675657572598426,
       0.076636704524917013,    -0.0084462025166493968,  -0.052668145698083174,   0.001055787630514813,
       0.055532509259149765,    0.060763524143408451,    -0.15115101719846524,    0.15594343426005755,
       -0.037491618679768024,   0.081506711370181617,    -0.10295624784992376,    0.010503181049584101,
       0.028664359971463396,    -0.055415224825848444,   -0.14840860082935864,    -0.14229976173813932,
       -0.15984878161770719,    0.0062631834463691104,   -0.10406524836211209,    -0.048625447186727691,
       -0.057185988912286448,   0.16832128049405792,     0.0080579817046450598,   0.071958908963215593,
       0.10386438893300631,     -0.03456982396606819,    -0.078617550476136527,   -0.02079282348433216,
       -0.047478170339045701,   0.10660198111038323,     0.25896188235954876,     -0.14106126524802606,
       0.040374200540061363,    0.032913519812324696,    -0.10969990626083723,    0.1434198529105967,
       -0.062041210384501583,   -0.13406398083609153,    -0.064843420574063865,   0.021813238975069676,
       -0.060352579475162538,   -0.018695363187454406,   -0.015228070256622784,   0.017961170376306766,
       -0.042141915869224361,   0.055656701871899895,    0.06715750838995227,     -0.075350078323931313,
       -0.022240101406538464,   -0.10383202040746338,    -0.0044449453361059829,  -0.20431354386572345,
       -0.13616299759694889,    -0.0095663359346553779,  -0.077737000806727755,   0.20311496580635174,
       -0.012714078090106171,   -0.037424563271140694,   0.024682360858595064,    0.067872149017099495,
       -0.053343740163729107,   -0.0011003856563969643,  0.012720612628375042,    -0.084992698168783853,
       0.027474521683571292,    0.060496504093211105,    -0.13688379952163116,    0.001053486531553325,
       -0.048930127240198427,   0.037236267253563805,    -0.050371451856775544,   -0.079457608686295422,
       0.050976699275744775,    -0.12581096277050352,    0.018681483277513362,    -0.23394304155597037,
       -0.086519426947868558,   -0.091775623122376151,   -0.070868629130412086,   0.15871438216729913,
       0.048829831512447755,    -0.027829054827118487,   0.069362834553585231,    0.053957497224755617,
       0.11784928861451327,     -0.015370059640119551,   0.1296701854045523,      -0.082373585122618415,
       -0.028939124116429713,   0.11442771927671815,     0.1458115863790215,      -0.12916982525588913,
       0.088736933561050266,    -0.10627657520524962,    -0.03701228483019689,    0.13108106174988104,
       0.0064043465690837966,   0.022666053216466406,    0.078488801377070594,    -0.095832690556221387,
       -0.00098897600674398463, -0.096278654107159981,   0.023111612199239479,    -0.11523797212695526,
       0.029101697739556592,    0.094641075979191844,    -0.1322733389147828,     0.05857415160834524,
       0.19527568064467907,     -0.18938882605904298,    -0.031766299942763865,   -0.14591056017393858,
       -0.16691337416246066,    0.017119794452891128,    -0.012047798229852615,   0.055444899678297105,
       0.074345895915643306,    -0.074941441095174727,   -0.014391913303133145,   -0.1650691810881906,
       -0.13898180222979467,    -0.049095256097791938,   -0.28018367521129584,    0.0072583686837050382,
       0.0039393305942768851,   0.16593637961076371,     0.06414817890601697,     -0.016538446297325142,
       0.085650499503643257,    0.07431202820063415,     -0.068334205158236572,   0.0064327539282497403,
       0.068275390539536351,    0.10427631474031983,     -0.10665098171660348,    -0.12890027322762446,
       -0.13511818343710602,    -0.18766545008977997,    0.13182893950425711,     -0.05864725640627122,
       -0.0057063160327560742,  -0.024993438411487212,   0.14693198139571537,     0.0087019358793499046,
       -0.10110018273166786,    0.14895484378398155,     0.094895384690478646,    0.055452821473024133,
       0.005957059901857519,    -0.022085706031135032,   0.01955318170395326,     -0.029510511604899453,
       0.078750021845750084,    0.1670638152349494,      0.0069797323120043787,   -0.12833880892532812,
       -0.10952154664612362,    0.26583525884706211,     -0.13062524482817878,    -0.0028310659288526599,
       0.085323672771905543,    -0.19197716744577448,    0.081208431021378882,    0.016727568934050217,
       0.013238548691613556,    -0.10188932018912962,    0.069618885595658361,    -0.048598651962537168,
       0.0089107727551571286,   0.046469925677641966,    -0.039848048928966387,   -0.18162095569572573,
       -0.17610991871730708,    0.080425427419376652,    -0.047127017420125754,   -0.073386737125253856,
       -0.017844642954466021,   0.11092407957492292,     -0.06708113280598936,    -0.19743069014755293,
       0.14811012330823056,     0.069408646263124235,    -0.10861663023354609,    0.056971102491699205,
       -0.12180716211182875,    -0.063715233617468323,   0.07362279625831733,     -0.027515788291834441,
       -0.023232110493723798,   0.1032739378750426,      0.1159651394086386,      -0.098860537212189972,
       -0.064468178582934008,   -0.0062394234234082009,  0.026719816035904211,    -0.19681941795138641,
       0.0064156602394013044,   0.096536697680187508,    -0.08783952347722794,    -0.063330547554169822,
       0.0025673605822565705,   0.048069346329316323,    -0.06412698338367534,    -0.057668448195488664,
       -0.10145101681659896,    0.13149739144608005,     -0.061110180710747836,   0.11575916615767155,
       -0.0080861027232804663,  -0.24973241925647324,    -0.22577297360469492,    0.053810377272163631,
       0.12493059031902161,     0.16310406719404746,     -0.070582434826393481,   -0.051533449742809281,
       -0.11499209742119434,    0.151814875859763,       0.10444149854865152,     -0.008258679432427694,
       0.001557775711262871,    -0.11121702204668163,    0.012418496456709562,    -0.04061243378500394,
       -0.081303486013259749,   0.021119032555131416,    -0.014896855246905313,   -0.075516526266666203,
       0.00032421989051686212,  -0.15738654969874921,    -0.11649437100493817,    -0.064521552659193154,
       0.072962422037245275,    -0.044123303505203805,   -0.036147603128112375,   0.054643177274584301,
       -0.0087493637744672313,  -0.12678191055017696,    0.15920248032284837,     -0.011195525250055259,
       -0.17595981105354069,    -0.14810136098870144,    0.020875825158089847,    -0.14906192739734059,
       0.0033597451318056345,   0.0067498149584861947,   -0.092854486553461721,   -0.010121834778025661,
       0.031602719441354045,    0.0781964742292382,      0.24238944696414544,     -0.13556621326549875,
       0.012608659490880223,    0.033120693403074289,    -0.15375047596232413,    -0.20396223195563326,
       0.12927228339275129,     0.028168967484644224,    -0.027063689037482214,   0.051461144280180525,
       0.0015747806125611602,   0.11554532853616627,     0.08058589558471127,     -0.15332934115114327,
       0.18056956431947252,     0.12599763221255861,     0.14954220050716358,     0.077044211926513645,
       -0.010469053317700349,   -0.19898867051227898,    0.027369014834359603,    0.0067563664719264387,
       -0.012564723484035081,   -0.17436158566922008,    0.089566324791844176,    -0.013397578252644822,
       0.11204274866584808,     -0.046809115999015216,   -0.046744707148664966,   -0.10170404923681482,
       0.10689855980097555,     -0.087284775834546677,   0.058032968682174182,    -0.04745441676878176,
       -0.037903014235279364,   -0.061974911169340313,   0.091541517414473042,    0.044504812928545988,
       -0.11271134162003528,    -0.0721978770743405,     0.017686333265046573,    -0.02972073725844503,
       -0.16000319439402971,    0.033723685915417183,    0.025543336879938837,    0.025741063369915707,
       0.044351222382577757,    0.013862128957670397,    0.0091729470671940688,   0.085595620122012994,
       0.11508196300555723,     -0.018537018837735019,   0.035306338344165446,    0.060293233617406197,
       0.10740079996269769,     -0.14365137121310603,    -0.1189298863237782,     0.058498757768754808,
       -0.014662341548171826,   -0.069949444825748927,   0.012680272000535809,    -0.13125879883604114,
       -0.085581817523073617,   0.19464535433306168,     0.12620919624160959,     0.10909751590649981,
       0.14275557604973999,     0.13781979170563211,     -0.043335688779646032,   0.16438499164235121,
       -0.075754438949932973,   -0.040568950929139237,   -0.10072829257590744,    -0.0664662454025923,
       0.092594007860081623,    -0.078345267887799538,   -0.11245168128777765,    -0.14807916528725296,
       0.14539196996547235,     0.022640108053547586,    0.052237025112591394,    0.0076112358968015055,
       -0.09309599940523286,    -0.063522256043043956,   -0.13771041410377258,    0.06943138775471544,
       0.046914781306758253,    0.056673732261987374,    -0.082318498218501901,   -0.067289365670168577,
       -0.11146133334246544,    -0.034453469026058836,   -0.026908542225850565,   0.0098090607113419173,
       0.1669519313474257,      -0.14823733551264592,    0.15589452446225996,     0.18758048953600753,
       0.12576721360041701,     -0.0890001168519685,     -0.22679153739738311,    -0.12413408552860256,
       0.066815398739272822,    0.10435447043571341,     -0.052256387796774668,   0.13179304869022612,
       -0.064301478386829508,   -0.10029016211643178,    -0.01297532398265891,    0.017592064242680023,
       -0.12889938177476493,    0.023717004574199674,    0.23289090336815155,     0.18113941563614377,
       0.00070317252669047092,  -0.014944258949866188,   0.24328260933839249,     0.049716815205497089,
       0.13261110377706048,     0.048874090809630497,    -0.058436163173515215,   -0.053301638309414472,
       -0.023230159909446657,   -0.13029782372715609,    -0.22264504046770614,    0.027822705731303302,
       0.069868468149041185,    -0.072438537002482151,   -0.0182745911673848,     0.033982931561720844,
       0.021458614181368966,    -0.041189867411799377,   0.033658392924171998,    -0.087020608442375941,
       0.1036035604799589,      0.17204659867447891,     -0.15617909050824019,    0.19200110322507899,
       -0.067174985098878051,   -0.10457589833881592,    0.0024552004338412917,   -0.023142759650566145,
       0.17993263958193617,     0.085253644486201818,    -0.024880615749647297,   -0.12943270839595419,
       -0.098730262970094185,   0.10152477575043309,     -0.1289505912615112,     -0.013063851402711497,
       -0.046214822839900541,   0.08736192420347326,     0.008531067170819185,    0.0809347173938985,
       0.039486228324955935,    -0.058071241137155283,   -0.089135786224647198,   -0.07196251708579246,
       -0.040593262927756585,   -0.060529686905687885,   -0.082748034554085581,   -0.12208358826335143,
       -0.0012437975665973273,  0.068658261918899705,    0.097482581366353724,    -0.076467878687363156,
       -0.018462784708526272,   -0.08561040284140832,    -0.0086641373017212128,  0.072242200490657479,
       0.031728353342553008,    -0.058413434667440776,   0.048357314368218628,    -0.085963065323425569,
       0.064609727734018949,    -0.050892232595137109,   0.018664838963135921,    0.081179796820148725,
       0.011015075899438854,    -0.10856454738596305,    -0.033399424540430711,   -0.00046473568795852779,
       -0.099182341642209126,   0.10303720080205239,     -0.12494604760947406,    0.12190779645062771,
       -0.066627355688216178,   0.067110748745680252,    -0.12801916085354464,    -0.085835865874758221,
       -0.014267246370458552,   -0.057245903805204841,   0.023935541743256149,    -0.076254055957699463,
       0.014923294229761186,    0.29841558694440251,     0.19167907456003228,     -0.10118495890106315,
       -0.044500735412820326,   -0.026169747569494872,   -0.059622615688855886,   0.19751415258057012,
       0.028972400005730557,    0.1172765055174067,      0.18232588666994895,     0.029848088573361242,
       -0.022490160307315751,   -0.12344444017635657,    -0.0051423638409197258,  0.067817390178783118,
       -0.053613151682994929,   -0.041799905683184951,   0.099270630911281382,    -0.080694427999848592,
       0.014957719320651664,    -0.17696073813524499,    -0.019474129225557767,   0.037392775585286871,
       0.068632010653772099,    -0.022609776359133221,   -0.16265451798892766,    -0.002964192667122994,
       0.044158178280401708,    0.073455770521242747,    0.031303741508821793,    0.012205924304913355,
       -0.0040504474496734603,  -0.11780968508489791,    -0.11988190581206318,    0.075918063126489216,
       0.011690592366146174,    -0.046764236352445927,   -0.0070723883578078708,  0.044026534548028046,
       -0.098908478302192904,   -0.010204666820798123,   0.11455721926801463,     0.002880771700154874,
       0.037954861844831995,    -0.081289688920877942,   -0.072487106882050262,   -0.066577334023028276,
       0.14252853279822469,     0.029848893161476112,    0.17301260876349622,     0.034173935731452811,
       0.034888400874366315,    0.24521434295774616,     0.069688633753311746,    -0.13786862359503865,
       0.20747556836493897,     0.045739253559413655,    -0.0051572223023084529,  -0.07616531222205998,
       -0.12246904137325641,    0.046739402918049525,    -0.066531473498580782,   0.073585720325523296,
       -0.033431659135829662,   -0.088620283043491788,   0.099594982528819737,    -0.047625711163316625,
       0.14503442328636659,     0.00784973941290182,     0.0033387033870859468,   0.011982620866925583,
       0.17735480683243768,     -0.21857788000901038,    0.15508516438230993,     0.23701810093862519,
       0.10047626873029426,     0.12235622454496019,     -0.051550953758362557,   0.093252807949777514,
       -0.14143683340579488,    0.089864855158109158,    -0.046671629900668594,   -0.12038227479814279,
       0.049285345636574981,    0.081191757828307398,    0.020048991103254254,    0.2557462659736463,
       0.072979789029141692,    0.085870988498282813,    0.0026333836627255311,   0.13475550414934184,
       0.1201703609640852,      -0.088463533660133986,   0.036043063372345766,    0.11135623308251781,
       0.083073291692013551,    -0.031555594790625835,   -0.069868951991168091,   0.049767957544170079,
       0.19414407973545489,     -0.071325127151051493,   0.11260003320273869,     0.034431283117472115,
       0.052563556562943758,    -0.074851163420397743,   0.069000234388032544,    -0.048750609057194409,
       0.14135364279389928,     0.16073970731061291,     -0.0083385393709087124,  0.13318812706257824,
       -0.1270603013025248,     0.061872256271158277,    -0.040487880213066325,   -0.017803673138102286,
       0.029321181881616341,    -0.087022870705021974,   -0.1087217913216405,     -0.064626873811480592,
       -0.155271741646758,      -0.057307267162131692,   0.13469899750508274,     0.062235662879130536,
       0.1620975142257933,      0.0018311663119427828,   -0.1188569122978908,     0.088119165524554052,
       -0.18506746491809889,    -0.0092123868258785959,  -0.084687463390292317,   -0.039047607883085436,
       -0.096048727655642555,   -0.077821995414457099,   0.16855635779368627,     -0.028622188669388697,
       -0.10028899489836748,    -0.016492463498845103,   0.11464761323332104,     -0.076354781498015278,
       -0.0095922783908299961,  -0.2036900095394974,     0.05288740881735645,     -0.099703603608125885,
       0.036587631296308223,    0.20419986747200353,     -0.10062514985428316,    0.1009739837258644,
       0.039260861881554164,    0.040201734364975449,    0.026879461752001756,    0.1964964538620538,
       -0.03108447583285185,    -0.016786166401743192,   0.11609944623350667,     -0.049109688103037438,
       -0.056366402318520054,   0.06875551634525924,     -0.16726777966255474,    -0.012725593403729741,
       0.20217442815764397,     -0.098666871828131525,   -0.021300361247434198,   -0.16998687670814744,
       0.081005907055705567,    -0.075884044750557489,   0.053874861550897699,    -0.045134518923832807,
       -0.077649389589919598,   -0.017475738524911612,   0.16182558572837538,     -0.15002621708910333,
       -0.10054472217438032,    0.069017572818907885,    -0.021450389311152562,   0.084753810978393226,
       -0.025254071632950788,   0.0094823800441595583,   -0.18522402653214828,    0.12073827313775246,
       -0.0050538690727516544,  0.081089413799565413,    0.015289131724696231,    0.087570814698950505,
       0.048140812662986858,    -0.047425635213249738,   0.084636653765110897,    -0.037131592139384793,
       -0.05416603598675937,    -0.025529610348370015,   0.10178872432547215,     0.049467584534209311,
       0.04478298277352781,     0.068026185265177397,    0.052149109657066733,    -0.028785353567256606,
       -0.048050507907446978,   0.054075686251875803,    -0.28192052418154573,    -0.027252380467166055,
       0.17942023379624594,     0.09497104649543342,     -0.16358829431051786,    0.12140000222816213,
       0.049385220279685768,    0.20664328272051163,     -0.015272028154510994,   -0.012937192986191875,
       -0.231204493335363,      0.004031800717252669,    0.1139478342910749,      0.077127394168419294,
       0.076951294553807531,    -0.036382249858536206,   0.043621250363159732,    0.075265459237241039,
       -0.053587361558285515,   -0.049698055882784878,   0.029979449035682438,    -0.065481138477619744,
       0.21004604500018823,     -0.16260513215081862,    -0.099571224883239134,   0.066202809180683511,
       -0.17510309652609729,    -0.15299357455464563,    -0.075500599165390259,   -0.19824401872271877,
       -0.18400830669990106,    0.017200182718046162,    0.066978858473906541,    0.044514046354931371,
       0.077914861794730533,    -0.10523039163435974,    0.0016155400896114037,   -0.1021103802771286,
       -0.1591702483957704,     0.19204995194555058,     0.079787459094801422,    0.060411239338980974,
       -0.066185417699733393,   0.094039915352321535,    -0.10157138110543587,    0.1615963424720929,
       0.14506685241434214,     0.10462723597781655,     -0.091676116474609118,   -0.042736899312012827,
       -0.038887942723662701,   -0.12074441065302474,    -0.058535997545897722,   0.093867403600944088,
       0.13525155301634476,     -0.0036480089177574472,  0.14983472715483953,     0.038407878952770064,
       -0.037526869373821457,   0.037831458694448851,    -0.15798025460191728,    -0.055022381159950978,
       0.065461285021159804,    0.030280127203209391,    -0.0047719886016710632,  -0.087945912525939154,
       -0.046088135068996762,   0.1672821310952976,      0.031891192731649746,    -0.061374558401127995,
       -0.028683192332559539,   0.10260010544696556,     -0.069107117140589369,   -0.056144803996615422,
       -0.10104465293280285,    -0.086348823095760863,   -0.035958259861824278,   -0.090769246449551297,
       0.045857100857446369,    -0.058742632894627535,   0.0093029667482031203,   -0.038815182650227632,
       0.026586916758669761,    -0.006603711777287957,   0.019070485262763153,    0.089013947074083125,
       0.20418058239268969,     -0.19681501805922808,    -0.13394252333476517,    -0.066245062215227066,
       0.0029370195233643873,   0.1339181098319436,      -0.10558082643421755,    0.21822695077193077,
       -0.068652777774558249,   0.10256139866861215,     0.054072188847422153,    0.086265722331660605,
       0.0048138729939479442,   -0.0065438715379672954,  0.088012867733216218,    -0.011671734085958141,
       0.1031711194831333,      -0.017818923256826352,   -0.054590581320502166,   0.040361177259381049,
       -0.039698140668953469,   0.061617169531565569,    0.15736830773845553,     0.037567957314530206,
       0.19154049244746255,     0.17679375442755599,     -0.029293397770817492,   -0.11557505665340718,
       0.078022002376782321,    0.098887643010602155,    -0.01393856048021622,    -0.14889577785073932,
       -0.031472582618225796,   0.012833628359438654,    -0.042705003095455371,   0.11708854751699563,
       0.089668786192371466,    0.057828968665914152,    0.014804765398552966,    -0.16221676704097646,
       0.053946988537018042,    0.25224490731515886,     0.0050881186749832602,   0.11247021903663364,
       0.013430794063898476,    0.11166088546212699,     -0.057898997919777567,   0.045549959274608205,
       -0.042654346549805475,   -0.13748230600928532,    -0.0262215463982137,     -0.013323422119811379,
       -0.056694951782926162,   0.097429524068519013,    -0.048305246091885586,   -0.0096270727608770545,
       -0.02304495005077203,    0.062648301406321591,    0.16863824295003521,     -0.18316005654204884,
       -0.025950436845429716,   -0.016310324645703804,   0.01621529949332453,     0.053572172874630855,
       0.081982057232931296,    -0.063612501441204422,   -0.12557928050443307,    0.025162703763879194,
       -0.023031788745293418,   0.28478672487485496,     0.023695785720016377,    0.036184991135489133,
       0.099908589819213661,    0.0032084227694161361,   0.13055145768341331,     0.19204893830880199,
       0.071487393424622361,    0.0056771151364160746,   0.01113703819445659,     -0.052677270868168327,
       -0.039905999924419566,   0.03243715656699403,     -0.058633958663890609,   0.12301689251329788,
       0.11217802763557229,     -0.064021512934959432,   0.13516280119668952,     -0.099628436892629485,
       -0.076834281439720681,   0.071711877096819435,    0.23039964230745455,     -0.24054177445414018,
       -0.082914811490035295,   0.084150774324243824,    -0.090977087822068217,   0.18780206392991408,
       -0.018947180279306124,   0.038410968922248004,    -0.034287879533427719,   0.068676218812833256,
       0.027888525881806361,    0.057401966125737815,    -0.066723092868964273,   0.078211573790372788,
       0.0064564097403517259,   -0.19235477215955543,    -0.095471489176009311,   0.097497401705076828,
       0.20752930511034876,     0.08382006993926655,     0.093544940586797701,    0.025162673654169507,
       -0.062053705240283752,   0.10817401540447651,     0.012453178778804898,    -0.014522310922429289,
       -0.07587205018727701,    0.033065156682388554,    0.015360125449218965,    -0.014039168293330729,
       -0.055151395846819336,   -0.20702514630574664,    0.12866603931254283,     0.14131268368921454,
       -0.024608310929883553,   0.12296316941014011,     0.12014209222668309,     -0.0062430318419423193,
       0.0097000446059325798,   -0.053651955755290304,   0.14263214936712237,     -0.052248648829575549,
       -0.092187188615724044,   -0.13119384683849861,    -0.16598890072043257,    0.21107452755286968,
       -0.009634579705482,      -0.021661809536476707,   0.06859073076583648,     -0.024585221220861042,
       -0.031372894167964183,   -0.068538309315637994,   0.092500729779913998,    0.1593580315305082,
       0.048073565153914762,    0.050073351716378799,    -0.094110140292560263,   -0.018730747453671634,
       0.13067398241225556,     -0.13915822617305718,    0.11086173575090312,     -0.10739979570462255,
       -0.03703866100942723,    0.020898451303477904,    -0.086181993346463759,   0.07628573219100257,
       0.011810843090835958,    -0.043013664200060274,   0.010805041078095965,    0.095912415248913294,
       -0.049337230908307543,   -0.011415445115887608,   0.05782769113460566,     0.058118506742547996,
       0.063226713995386361,    0.049622783404483686,    -0.010850713006121455,   0.11907461894586854,
       0.13172841233311738,     -0.051799196489277353,   -0.10861487445048836,    -0.10266908428870777,
       -0.079553766989548746,   -0.016450161529450526,   0.054638962914863261,    -0.065843079663510218,
       -0.042018571626167629,   0.036918117246463815,    -0.10539949396342305,    -0.03766998863215458,
       -0.040118030780651667,   -0.047787924313536116,   -0.01590614764652605,    0.094943216014596696,
       0.011729324304852976,    0.33243400845797155,     -0.12402072672166779,    0.023688461905683248,
       0.19326925877982401,     0.0050691507258666677,   0.069446751876005117,    -0.085875535104201359,
       -0.012293255297013139,   0.019102855351050989,    0.10364765633944065,     0.21089426109444523,
       -0.016597111092636178,   -0.076905252212212546,   0.042598731447731131,    0.099690566765111441,
       0.043558522531117354,    0.11274601017092968,     0.027233307605833344,    -0.26086973903686561,
       -0.092625273017125573,   0.14064387473887652,     -0.078203451110269009,   -0.13579915052300448,
       -0.062010810818649786,   -0.17490971806742855,    0.11294650082507214,     0.0091047036888538251,
       -0.061108255293575581,   -0.13380177438402088,    0.039441059974905344,    -0.015911218274690719,
       0.12690799139514131,     -0.010529439599029532,   0.14877794830688471,     -0.08343033502883955,
       -0.040661997453555726,   -0.031955176173506579,   -0.0001876813233394072,  0.0096758262855276209,
       -0.070847473258522309,   0.042771756887754211,    -0.041256899984537673,   -0.099415816471935162,
       0.065177974074595663,    0.077586204839585129,    -0.05319797367416975,    0.1046850209613765,
       -0.071664273048542837,   0.05602166605904315,     -0.24721736846171607,    0.10786261841992346,
       -0.01624484842108749,    -0.061898084114768749,   -0.10846916314404297,    0.087779582473297979,
       0.08507583404098909,     -0.0086488024217449225,  -0.024946185182451799,   0.13492259895936962,
       -0.096830708172144925,   -0.18271306302787116,    0.13155837233182072,     0.10403358110895446,
       -0.041971329123721306,   -0.0077193956168104746,  0.17799232652124083,     0.22233786992179713,
       -0.090654616039416047,   -0.10582297035638574,    0.16010005844601174,     -0.15846437849342201,
       -0.07422079394920289,    0.063002797054197757,    0.081176784226632465,    0.092727377176288941,
       0.065267316102531517,    -0.051732536939612911,   -0.033973825301262556,   -0.10724516685742455,
       -0.046864918738444714,   0.01124651687291648,     -0.051219461946456657,   0.081671483365229072,
       -0.051986593633011773,   -0.10483092426423746,    -0.0038502320266187531,  -0.018568392488776751,
       -0.013929123799124105,   0.14232071678136377,     0.11006975830686494,     0.035601120469927486,
       0.099682367612844755,    -0.0025897133417618319,  -0.11422484460093707,    0.14997501541329147,
       -0.10076990926500898,    -0.010777430641954914,   -0.20465241291384104,    -0.087653108190258427,
       -0.13780590978242646,    0.00077650894253545656,  0.14187733271150452,     -0.1111166098293442,
       0.18040612713890988,     0.052965221676824707,    -0.10682638107456138,    -0.081402544188015846,
       0.027395558654669232,    0.030752884859260293,    0.13709689624985172,     0.1365657063049788,
       0.072598902092469456,    -0.047465917416483455,   0.12611441292800007,     -0.046081927716498834,
       -0.0061817789675241187,  -0.11527473690560745,    0.053540667984974359,    0.007018094762955251,
       0.0056803929740396192,   0.013645336704257516,    0.218215490929246,       0.045040126992955787,
       0.19862650784074412,     -0.037050679275552764,   0.061565679791789479,    0.1250349688072547,
       0.18103428317598808,     0.1192896870177898,      -0.21575246307382948,    0.0020022461309774802,
       -0.0098252830417912863,  0.025320872404670697,    -0.01892950275071251,    0.019627101750747736,
       -0.099942085304848646,   -0.044329677123267519,   -0.22679253865883689,    -0.12169044701154803,
       0.075413691524106444,    0.087460876760188988,    -0.054974766826875944,   0.087170760529434954,
       -0.017218998244818328,   -0.10691249892214791,    -0.14800937480928933,    -0.16310312551885919,
       -0.0074369255375477585,  0.083069065405252829,    -0.028053342091889887,   -0.069823364622365144,
       0.14642373621021967,     0.02528613463887398,     0.038456410650020104,    0.029867033728508914,
       0.020408738984541576,    0.050534938514238861,    0.0051978183686104389,   -0.050343737485431479,
       -0.021798173431462918,   0.0036488373088500968,   0.050233981045789286,    -0.07634532129089644,
       -0.11687982571812797,    -0.06541178143633801,    -0.0060303371789297644,  0.089127414656722137,
       -0.095748847500473022,   0.093253136076218032,    0.09266406798152016,     0.12168198923940314,
       -0.084092206081235202,   0.039308379291156846,    -0.011550573321096571,   0.2484149138282753,
       -0.1063853069857658,     0.096049091903631326,    -0.036412383084807896,   0.028130125105240412,
       -0.25922585497119716,    -0.23226898915058872,    0.08639661118098324,     0.021647751037861769,
       0.13299872979991292,     0.055297006127460413,    0.15387857048309911,     0.11349760440579174,
       -0.093966353611182857,   0.0058329629982573333,   -0.12384088572735581,    0.0054384228377887082,
       0.0078779817874651131,   -0.11910986740933371,    0.13231732903853666,     0.067612348295646343,
       -0.22656294726626047,    -0.029917851337479703,   -0.20784320274746465,    0.060597608724332883,
       -0.020079384732459404,   0.011299549240431047,    -0.049012694552867754,   0.17762483032326526,
       0.059002004477742162,    0.10986042009075402,     0.074203184493737556,    -0.14439241917417922,
       0.11118812613239576,     0.1625954577546761,      0.0091472812332355439,   -0.012357669974132863,
       0.041665976277666349,    -0.012990584598575671,   -0.0021960921696353901,  0.048874020335245162,
       0.037306870985656583,    -0.036605723518331107,   0.059098273796883635,    -0.1982641019142222,
       -0.074822503569213994,   -0.075248105054217321,   -0.050660406609333582,   0.074729331909137886,
       -0.17018541848430088,    0.16627822784687318,     -0.013836847929583942,   0.035276312401057275,
       -0.085486903639364467,   -0.02155653456538258,    -0.065909139027972172,   0.023731284440456794,
       0.057714776396705747,    -0.098397705124132512,   0.10679442242759195,     -0.0039017369843879213,
       -0.061218906697981253,   -0.0013648326260155691,  -0.10853086768548939,    -0.20134471565646461,
       0.024830980793196015,    0.015227158538762749,    -0.088218130121723026,   -0.081401427577656768,
       0.0774494507344205,      -0.093056163172171344,   -0.1665313360841757,     0.06421816897567828,
       0.022996175250414974,    0.034123814059396768,    -0.052460334042119701,   0.08655383640435213,
       0.043046194638577194,    -0.23823132950112788,    -0.0016446741274680245,  0.14976839133627645,
       0.011013744821712659,    0.0067416940826068739,   -0.14422509092159366,    0.074388704577731543,
       -0.079874561091734769,   -0.0084892546259174983,  0.075314708984593345,    -0.012630130121683063,
       -0.025190760683483193,   -0.10369774744106813,    -0.056172013303770765,   0.059243505388500393,
       0.1183975239015032,      0.065925393435753293,    -0.016183112837438583,   -0.02018431632176446,
       -0.036802997536214549,   0.11721546670050302,     -0.057247603469309877,   -0.10245198047809198,
       -0.21350724295753401,    -0.11891790105134546,    0.010472033594550975,    0.021613071899212005,
       -9.7680333126515251e-05, -0.057219659055077018,   -0.036001798407385606,   0.007672075645489513,
       0.061110939805140693,    0.26892165279125707,     0.038593780075678527,    -0.14192285687891026,
       -0.053972904409945385,   -0.18227507145939581,    0.055063369008720643,    0.10653477610399718,
       0.032148503346124825,    -0.013366916087072637,   -0.079014682314058227,   -0.0040161772065977,
       0.11902337713171875,     0.267644150830672,       0.013765359132326439,    -0.082443121359358218,
       0.13023945540581275,     0.22444053370279085,     0.098796424925454124,    0.046562965355934599,
       0.075087576237718529,    -0.1726053455664126,     -0.072527160566839124,   0.13811298323953075,
       0.1045688464529059,      -0.14485456218702969,    0.062557898098714371,    -0.088413004410322918,
       -0.034183693230360343,   0.070032983036091151,    0.097631509733247038,    0.23777330979600869,
       -0.023457068987236797,   0.082431123936997364,    -0.060937027244453545,   -0.066090922691265985,
       0.043265419345052604,    -0.0075420138055763142,  0.037684751633258254,    0.040865650016172247,
       -0.023164422520229683,   -0.075754333776862137,   -0.21530613257789424,    0.056648791095271184,
       0.029260532632940286,    -0.039788540145419549,   0.059055565488656515,    -0.12792692725675003,
       -0.046519665199944431,   0.10946379002906956,     0.046143028248641804,    -0.037081707302498844,
       -0.065128267385091462,   -0.13005417833246782,    0.0039487951720404268,   0.08103596838883502,
       -0.24112056128499459,    -0.082081198375636183,   0.10526962088324184,     0.14798113143867814,
       -0.0037358455340819039,  -0.026176864709936295,   0.1115580703784725,      -0.079034532705151372,
       -0.12669470396156957,    0.00044765119088392875,  0.022793473234265282,    -0.020639718338111991,
       0.12413581758131775,     -0.084280942191121699,   -0.14291113699393987,    -0.045865780713996857,
       -0.048013852212652156,   0.059030073833668532,    -0.094542347247952213,   -0.14726624764368473,
       0.0070288761800238724,   -0.080659735532359056,   0.018781042367562339,    0.00064660746606690425,
       -0.23556137753989959,    0.13069814504641034,     -0.091740328020145603,   -0.013337815449220636,
       -0.18006864305149597,    0.11059758066213875,     0.034178202995596998,    0.061153458889258071,
       -0.089987033548331846,   -0.017092153506256615,   -0.026700792275027738,   -0.18381943366136413,
       -0.046295522595823681,   -0.010552019786968856,   -0.18975797935542948,    0.12981823897046391,
       0.13403927706799168,     -0.18423276276800762,    -0.20414564805424096,    -0.057916771551816799,
       -0.029130915477006511,   -0.066783249402635317,   -0.12577151710936765,    -0.12699635939549508,
       -0.20075037741801086,    0.027044267023969625,    -0.059306331399203417,   -0.034654445187670066,
       -0.010474301668588145,   0.089520237364801469,    0.16341405683691868,     0.013048054169136149,
       -0.045602406488886894,   0.038604053400118313,    -0.053576311857661499,   0.039862374252992702,
       0.14514599819321738,     0.10373836930523149,     -0.016273881187798395,   -0.11428914876404281,
       0.10526006796147182,     0.026608036018176202,    -0.012158640834585122,   0.050018672619412917,
       0.18271659505422755,     -0.12792487972038707,    -0.12307496011184375,    0.14475751861066116,
       -0.1122614278589098,     -0.068924284753162424,   0.0078120341807710221,   -0.13252243795527915,
       -0.13604612467297397,    -0.065226790051862285,   -0.0012384490550286838,  0.079165333115922831,
       -0.014481691423467561,   -0.13528830979948187,    0.1383092954616934,      0.019965049644842588,
       -0.00061169576007864867, -0.066267483608326766,   0.015891745518375404,    -0.065820153674427007,
       -0.083500350917401309,   0.10825104095078965,     0.026113839025262986,    -0.04960222053809453,
       -0.044674718773909008,   -0.032624652562254788,   0.12749712885035064,     -0.018023403283501209,
       -0.17664678238917192,    -0.012459994911861016,   0.083556930142708458,    -0.0033433926778408231,
       0.0039319333236569479,   0.1244217748934307,      -0.13286222031708908,    0.024485259856879358,
       0.030700974296160102,    -0.20029821263824682,    0.043257029879406453,    0.11471036182958932,
       0.033408499820209075,    -0.014645412961607009,   0.022769559635181742,    -0.10529779109296407,
       -0.08043805248646968,    0.06696896994638675,     0.0018690992191572357,   0.10284435276967779,
       -0.12662272427176929,    0.019842874049787365,    0.0077252646303595561,   -0.10963729187131588,
       0.075666515341821478,    -0.046202993120555334,   0.037518728600347773,    0.0049803783689195968,
       -0.077739118495973411,   -0.09535241732743556,    -0.084968878556043584,   -0.089083400907788685,
       -0.0259682931195616,     0.0069174045766408447,   0.12257029327633781,     0.21538942540498868,
       -0.18846533603640722,    0.12275800666580777,     0.090600862011385855,    -0.20808040035098943,
       -0.011077674684631077,   -0.11638321693600898,    -0.024772035631956523,   -0.01109606257992584,
       0.029683764018060214,    0.11810201392755874,     0.084135462612307449,    -0.070747288045323528,
       -0.058261068550945538,   0.036097857368426675,    0.10185770730905781,     0.077429562199786778,
       0.16526572453630062,     -0.033952512975261008,   0.047297640429800086,    -0.12712594231902991,
       0.064291322969094372,    0.20885851998410565,     0.023013042066528315,    -0.19167770097258446,
       -0.09395024925000256,    -0.043935751061936278,   -0.192518820308409,      -0.082766822516821853,
       -0.11991957131259956,    0.013928693820105345,    -0.17093886213471265,    -0.14535759280799526,
       -0.13029761084185532,    0.092218484480638185,    0.0054852522156066778,   -0.0058705667827383175,
       0.064287656304667026,    -0.2500397978451101,     0.079535617912477888,    0.080389542663565475,
       0.1522510234072777,      -0.049106209483115879,   0.12665787488771224,     0.013934337604752812,
       0.063654319051722599,    -0.04948609999451082,    -0.055180287222367751,   -0.047648353690529666,
       -0.07857032240950089,    0.052933964440885307,    -0.086972030760328764,   -0.1160892415116247,
       0.092231204222477589,    0.026760108417711745,    -0.16748892218953274,    0.045191149067378394,
       -0.083521743259383524,   -0.080144319138036976,   -0.17363122947189452,    0.065704355661296662,
       0.058699426886001299,    -0.04155102867142399,    -0.076813907491468533,   -0.065129035806727797,
       -0.040974784619142807,   0.055486556086156033,    -0.1066758039508162,     -0.046389682831245095,
       0.12940578746812267,     0.027636683552240249,    -0.04788888715798878,    -0.033316883187278087,
       0.0065563152284632813,   0.028961778948843431,    -0.046209400256873957,   -0.030675945476984094,
       0.19991707433989711,     -0.15947566880856007,    -0.15962926861960652,    0.076244199283655945,
       0.24514355926978348,     -0.0080766266697476531,  -0.044757519574694642,   0.04149622083693795,
       -0.22411078112356764,    -0.099383095912249697,   -0.0039785958508755312,  -0.070391336461658918,
       0.11587194985466701,     -0.058909661683540365,   -0.017713066149147083,   -0.039613760539066463,
       0.0050375006112307278,   0.10701704479419342,     0.060542683537103334,    -0.040571087773050594,
       -0.22171540923243291,    -0.092870467744683632,   0.14564647831221084,     0.04628485398172523,
       0.10074010607976341,     -0.006402470515308973,   0.05978835217041803,     0.12597248562218233,
       -0.047167462964986737,   0.056688997490196215,    -0.061320135476796371,   0.055463301327100402,
       0.049620589168936587,    0.044454900828895264,    0.047408196638895436,    0.07196770406223861,
       -0.030313619931858792,   -0.012839477383599973,   -0.021304539430255762,   0.064728021800973312,
       0.041624458759629855,    -0.074248379072216514,   0.047865938673060215,    -0.022692371915858659,
       -0.080119358526287029,   0.11521889383092662,     0.15253200715641504,     0.055636270018703915,
       0.15096750490989813,     0.14818055948309639,     0.018632712804065144,    -0.066571304954829338,
       -0.11031217548085435,    0.033812356055102688,    0.14218432759454308,     0.022137468101878544,
       -0.15719344795953513,    -0.090537690952192856,   0.11234115107895237,     -0.076643457842995935,
       -0.23332717171322467,    -0.18498721909852284,    -0.12208024034533826,    -0.022863465563663758,
       0.019658377874381412,    -0.03475080631513125,    -0.015963732119622671,   -0.089181366460483844,
       -0.090532002899138306,   0.070687077266806883,    -0.16263285751711634,    -0.22941956876008726,
       -0.042311909519569715,   0.018015907644102637,    0.23504421562371466,     -0.029427564821896048,
       0.097105095431996261,    0.050724347356688695,    0.063340010722630763,    -0.12039788406502865,
       0.0093691300557603285,   0.10967004694402339,     0.1087296619629306,      -0.026951061810656058,
       0.19453496346940805,     0.040242686439392696,    0.037787378493571708,    0.058872938307711016,
       -0.22509997064388981,    0.1565188044193635,      -0.043738551913451044,   -0.16467281567936606,
       -0.026169551435732501,   0.0068815931442593953,   -0.11763427262797208,    -0.022617157209408725,
       -0.072094019361374287,   0.079242978633774622,    -0.095173463122599625,   0.11532274210307598,
       -0.0095868866865618935,  -0.14347869030546151,    -0.076639786488990821,   -0.051855720158097363,
       0.091443340031771764,    0.111407607647154,       -0.16995398814844553,    0.07752255788264889,
       -0.013995449488200603,   0.11479683407087692,     0.12501626596207779,     -0.048793240358379009,
       0.1770465988777149,      0.15741594741869605,     -0.07720250597400205,    0.1150422917615809,
       -0.051481076462955189,   0.081071386986184518,    0.12756570346462046,     -0.1369585156039749,
       -0.0047459154284492135,  -0.03148364902079797,    -0.0027751781068390997,  0.12650937165094478,
       -0.085461037360374553,   -0.11411387290011304,    -0.096830931309321855,   0.1060272666364022,
       0.0087847420416555019,   0.01701861241249018,     0.092148407489568443,    0.010343172998377398,
       -0.062729322476993643,   0.019318823186379622,    0.020933124985937419,    -0.13553626107616926,
       -0.15053643360286578,    -0.072849404835626269,   0.049038993099887379,    -0.2342073160910606,
       0.049877887903420813,    -0.11558137564199662,    0.038608956394368753,    0.14782338510140297,
       0.017594389697401167,    0.068449176400605216,    -0.09399426376767972,    0.071178192599352416,
       -0.14047826887770948,    0.06406957560215068,     0.093877222086175161,    0.08389300106011964,
       0.11838214899833818,     -0.070834521386522062,   -0.17523390599361582,    -0.02484590597426142,
       0.1161857962096656,      0.097500157794973216,    -0.16130040133435503,    0.022452690751469169,
       -0.010120258973843299,   0.010930389091531306,    0.08432758190023848,     0.020286883274913486,
       0.10159047795826445,     0.028592818294602435,    -0.050954586821993254,   -0.10717009837556866,
       0.15451976733710387,     0.07029252641466352,     0.087785889065201961,    -0.026518227386041641,
       0.072959273828008375,    -0.20833323547389812,    -0.024506010964095583,   0.1097552359295636,
       0.11720773587825772,     -0.1766869240291736,     0.056475279921986782,    -0.044513298732690998,
       0.071122420929097013,    -0.085814421035970076,   0.12660657970166858,     -0.14522305179248143,
       0.0045512587841071549,   -0.016675483107119027,   0.073419735038620107,    0.03408526178500542,
       0.066395210185608552,    0.089112108430792397,    0.0080370997364707375,   0.086915390979859397,
       -0.14948925148207157,    -0.10437414246218321,    -0.048943295247562128,   -0.01227094774312759,
       0.02617381296115812,     0.064553559195485916,    -0.12802233213531081,    -0.020688334335109644,
       0.13390240074098184,     -0.036547606187004394,   -0.096392448850309023,   0.0016667923419518716,
       -0.16126749646730509,    0.096817915187514328,    -0.050861616657158853,   -0.076882243373874587,
       -0.0086667750989563429,  -0.027653507271926833,   -0.15339154675913086,    -0.062829665335556367,
       0.035328034286682686,    0.029623178491056959,    0.0015659978671638142,   0.10781138977699865,
       0.018444060318783026,    0.099488692961375025,    -0.15666721667755315,    0.0034684252418068981,
       -0.037805969345192418,   -0.17783808921535207,    -0.063834796086850873,   0.10004010242093848,
       0.0067491534476498451,   0.1989599171546251,      0.14708875267538796,     -0.020077749351309231,
       -0.0062308064460940933,  -0.01408676327159572,    -0.041113160416232405,   0.060337979498579754,
       0.071853102064559152,    -0.0046310642816362168,  0.18609381245117404,     0.0049886310085304093,
       0.33020449933129015,     -0.087733161214000085,   -0.16106863913681929,    -0.096301766653629675,
       -0.0084158572000900822,  -0.067418032328381061,   -0.053378531510565035,   0.18112091584380791,
       0.10791616300793713,     -0.17064406037079016,    0.01198899607481127,     0.071739077278164531,
       -0.060890895832078025,   0.030335110545506069,    -0.054174742386403893,   -0.048757582020775819,
       -0.11949883280350662,    0.1966729370906688,      0.067866138741863355,    -0.18171147969530207,
       -0.0883423482298029,     0.049336879675800603,    0.14773745949560302,     0.12237594536458042,
       -0.04113909160002422,    0.069535017606379437,    -0.016000811004504775,   -0.064368115187702551,
       -0.080737180809357836,   -0.19824600551560492,    -0.088930467580614389,   -0.012316185642218647,
       0.14516612365134735,     -0.011288826062503692,   0.037321632973401742,    -0.063185609342824661,
       0.08778965429228347,     -0.14397620160823527,    -0.083045270473361285,   0.045544748715676001,
       0.053989158901087124,    0.013978255831560654,    -0.026211294401545841,   -0.024991534714532068,
       -0.023287156952289095,   -0.22095289674057464,    -0.12846603750182259,    -0.04251954579582104,
       -0.032006634586806158,   -0.016412911353394916,   0.064063659552353464,    0.16408362763292661,
       0.05850577514798154,     0.10361883035916765,     0.011941276792723332,    0.11268455980054382,
       0.16946505925090255,     0.09195044433334669,     -0.095358767080164386,   -0.0076376614600119769,
       -0.12400479429411856,    0.020988217280783306,    0.029996410440548269,    -0.03895065228782571,
       0.11211932308499764,     0.039196375726023802,    -0.053335504461556993,   -0.0021570746730166374,
       0.21393570260878569,     -0.074833518678482119,   0.21305494866128138,     -0.16077657146390562,
       -0.035271308896397478,   -0.01564135985547576,    -0.059301010534447321,   -0.075987234928791586,
       -0.24280377310885071,    0.018091711526941896,    -0.064860213646750847,   -0.13091309605290477,
       -0.026629091799909708,   0.10608059680389891,     0.019152242302830916,    0.16754608317495184,
       0.012231541905775934,    -0.11581000391369753,    0.0062926056349944985,   0.11154471800756349,
       -0.06141686818313695,    -0.0017760536881461651,  -0.13044547866120573,    -0.04398832071339033,
       0.08199624933046662,     -0.30427862184022703,    0.14257660847405082,     -0.048534189523109041,
       0.037200573223570531,    -0.11099409388368761,    -0.029591886391235334,   -0.017608723868943514,
       -0.051933807535275142,   0.017219527228834242,    0.083144969074320674,    -0.17712836473029467,
       -0.16818315553987126,    0.080212151437426132,    -0.043095361817653367,   0.062911314988138997,
       0.024952278639549193,    -0.16376704936093295,    -0.056147109605224302,   -0.0026823622219521136,
       -0.16092596602443096,    -0.023607705295339631,   0.020194181242807988,    -0.1492473660641068,
       -0.033560087618747132,   0.00041088717680868875,  -0.17203838537811722,    -0.15816552431821276,
       -0.092961477745593518,   -0.08768908065341284,    -0.02415047214369961,    -0.016377299337085774,
       -0.038631332535133102,   0.0054075598927977534,   0.0003005549993570257,   0.090912242972000123,
       0.12656583769106239,     -0.1885453132127772,     0.059232274287775603,    -0.033281425079605742,
       -0.01957474128195389,    0.06547184075330767,     0.044124807182389425,    0.059305142995621701,
       0.0090974399326403665,   0.18613692217552916,     -0.054246755042454207,   0.10926313739523201,
       -0.046854299311965192,   -0.0910388615786831,     0.0008175656789414724,   -0.20811154433179652,
       -0.04633189600737056,    0.072114758011149555,    0.047800270064393066,    -0.097231578801047991,
       0.095390680007634163,    0.044066222306580444,    -0.084939098368608815,   -0.0093037469325940592,
       0.061200277509942398,    -0.11419282562828689,    -0.1604187817720501,     -0.027472561955698881,
       0.12740453823168138,     0.044247579245094523,    0.010106416257448823,    0.057603627158061436,
       0.11068499270664982,     0.037581471984285117,    0.031312097550593943,    -0.1475366528444062,
       0.1044040169340647,      -0.092314751111226695,   0.011794709036489383,    0.062423428436867275,
       0.0046897755449776543,   0.11108917388986858,     0.15025124508416887,     0.0906032854730109,
       0.089936612328299401,    0.065690861515282195,    -0.10945880281509372,    -0.081641915465651416,
       -0.045266136502210001,   -0.01996829080475386,    -0.046375384289518783,   0.18299923284263286,
       -0.096734172271606286,   0.20666069442947432,     -0.033137425224384745,   -0.08372128799647148,
       0.093310867427690583,    0.042872903503501675,    -0.036392978046561809,   0.015060811758145196,
       0.15397777381858868,     -0.055024063935549816,   0.025826809916016567,    -0.03319153147131871,
       -0.16198394168737132,    -0.11334292314628422,    -0.071243097569619732,   0.0075345582478801403,
       -0.19750251850208603,    0.040131716427630505,    -0.0082565626663732919,  0.031225354747938163,
       0.037003909323206526,    -0.17763588121460705,    -0.041235007921896806,   0.092952041966759325,
       -0.060948630334736027,   0.14797785008838479,     0.3088209588329543,      0.0192441855715678,
       -0.090685045275289866,   0.15535061419690338,     -0.23172073609351135,    0.055444640734955315,
       0.16615563634198843,     0.008819976850050008,    -0.0023063187058498993,  -0.030564111316100994,
       0.13733517980317314,     0.086070233908621591,    -0.11854376537944945,    -0.059780230659214423,
       -0.095348052668273606,   0.020143963444659123,    0.04133746944872789,     -0.10942446570037563,
       0.013456064344683051,    -0.037589197071109727,   0.063476201764573678,    0.0031341818832343292,
       -0.018510390083137509,   0.049320689152098536,    0.16316164695698618,     -0.018944081178361917,
       0.082356390408626287,    0.012346026994312637,    0.24320100743265755,     0.033282603055368398,
       0.16186735975088321,     -0.13760236573939932,    0.042646540182107673,    0.041431311923313306,
       -0.10010926035996591,    -0.015960622813290731,   -0.071561834867594543,   0.0050868144651192975,
       -0.11899186250824795,    0.081520148628790895,    -0.078723720257839649,   0.090425924708185154,
       0.077992776011446316,    -0.070537700752765803,   -0.09493219055760066,    0.070302160404365072,
       0.060879746858593903,    -0.11470362296752304,    -0.051910162977224839,   0.031397943480218002,
       -0.1467031345016335,     0.067926084447623061,    -0.0021962135459752917,  -0.19390231925334073,
       0.027416104482079363,    -0.047227404364471079,   0.15308725408527415,     0.02462284791890313,
       0.064228472752489357,    -0.082875649021399753,   0.032861544333439824,    -0.022533753520751407,
       -0.027401932200591402,   -0.070909129539447224,   -0.17782735606454123,    -0.059978182251968312,
       0.074324637845077354,    0.087606497325550425,    0.18904408763587613,     -0.013641692945661808,
       -0.10331186758463334,    0.02818755306818619,     0.009486958384485749,    -0.010114190111669143,
       -0.11032529506797303,    0.082065332375805697,    -0.12851761378962903,    -0.019341861213261667,
       -0.040508025534162995,   -0.084139241642594287,   0.24888580551652562,     0.04830109767593016,
       0.0989558080556069,      -0.32863359162580141,    0.027343419806576806,    0.010657865697121901,
       -0.15278490444199827,    -0.045243398392458146,   0.28289347997892866,     -0.12189821933763663,
       0.040659467917296591,    -0.025691664737721241,   -0.053964442730413766,   0.18982214482022836,
       0.070006019685060261,    0.24009230150854408,     0.079282018850285019,    0.069764808723594973,
       -0.072274685672126651,   -0.0066738758687993616,  -0.11238262590901354,    -0.062977835764806464,
       0.012176443180887828,    0.047504004894067663,    -0.053332625264749155,   0.027669867855451821,
       -0.095600949109347702,   -0.15169633695659596,    0.12938916582383519,     -0.094635399791369715,
       0.052961654968739176,    0.12187295023460999,     -0.0089884217072109477,  0.03131613793426935,
       -0.084593907504352667,   0.024549171194220856,    0.068618347958749659,    0.080365133171821757,
       -0.02026830453126589,    0.0026591103038270582,   0.11222946511518972,     -0.1723721657471006,
       -0.019670987509476705,   -0.093881169026185804,   -0.10799007974977903,    -0.063189480300800835,
       0.072160463401214028,    0.044516623348511419,    0.011176941258741328,    -0.11111884582480112,
       0.044841600407479969,    -0.14416857432829419,    0.087701420484789877,    -0.044051525244369949,
       0.11388488475963189,     0.017534349261957419,    -0.018209517395530977,   0.0026892071268923221,
       -0.029780515426073555,   0.053841859674213503,    -0.11436688575920508,    0.040776382464745665,
       -0.14249258177825674,    0.017215349830014968,    -0.081532426816241732,   -0.095984843676533357,
       -0.00017834805724716886, 0.091872956436924585,    0.086879037812004234,    0.15660434370361329,
       -0.060344809327849233,   0.050639183183339861,    -0.10023193950345335,    0.0032192940594026262,
       -0.0070266491536593164,  0.10422584418504674,     -0.0053167929502896984,  -0.042155844577443237,
       0.049805135800243067,    -0.1728067293932013,     -0.050345391814880985,   0.20728724562087625,
       0.018161608797678006,    0.082692930283663132,    -0.098026719408504492,   0.099789867329430154,
       0.034180681181749245,    -0.071023119713065269,   -0.16956014457222446,    0.18420344470104291,
       0.10967802126709612,     -0.0053580488069762955,  0.16558689164382281,     -0.13417636069534022,
       0.092207032011446366,    0.010582217301103957,    -0.23406511419135295,    -0.15362192577987646,
       -0.0043774154322511775,  0.063739314739003017,    -0.04839824170422978,    0.073771539432821123,
       -0.081693907683143954,   0.0065562268576472797,   0.086705815230481098,    0.10422626954760537,
       0.052109838193573191,    -0.01021826644590847,    -0.087306251035816185,   -0.082067174527186371,
       0.0094354016726404897,   0.11750568120479069,     -0.059201570246246615,   -0.13861556424983418,
       -0.10046693823093815,    0.054294836507567841,    0.089314672805400036,    -0.032020619696141728,
       -0.11199077267126044,    0.067004413864461626,    0.037777546894190786,    0.056131893436786484,
       0.034474286983574791,    -0.062513762768377779,   0.0042443449565213801,   -0.022864184508281087,
       -0.058487017492578834,   0.124901850798302,       0.0078533707877214316,   0.078485696923739121,
       0.11866861805239211,     -0.18053800350061563,    0.019443738735741654,    0.14271247053174393,
       0.050013948971402412,    -0.097461055486013248,   0.123931162839418,       0.037423871982129722,
       0.05158877986408994,     -0.0087748476245369106,  0.076809873136178347,    -0.10052382458079653,
       -0.075419198444427765,   -0.054646056618153617,   -0.096793887882697258,   -0.11012423850494044,
       0.046358670969837527,    -0.14901784245759617,    0.16868791398296587,     -0.13276018613769389,
       -0.035183589711816211,   0.19560262151214511,     0.12400365686574398,     0.14992170129802307,
       -0.039264874091260699,   -0.040154603620306692,   -0.10168328426726672,    -0.098833670418622732,
       -0.17237967988537953,    0.049958857171455803,    -0.1312418107922261,     0.019643827646919479,
       -0.076269940701960928,   -0.076475067176256267,   -0.1470172546772027,     -0.21912332884925304,
       0.10125286281193409,     -0.10916744854253652,    0.082066165161933449,    0.0069337477484517377,
       -0.093021716372875068,   -0.0022851370222117091,  -0.083249622668765816,   0.085862855077226449,
       -0.032801229993750132,   -0.069573782570662393,   -0.32165886759122564,    0.03758028344487617,
       0.089575229979166643,    0.024815771963578516,    0.025616649523913695,    -0.10611361969671003,
       0.033830249432005043,    -0.11282692492172254,    0.035570856936410905,    0.026839672708416355,
       0.098600820899507668,    0.032736558453365913,    0.060439852826183658,    0.18112167901616552,
       -0.13923729497064583,    -0.092400730957335656,   -0.09676968580072158,    -0.075111136346994942,
       -0.10958224143752683,    0.1449548561046772,      0.065324526963233098,    -0.043391312039143266,
       -7.4853289575527941e-06, 0.070119934580325449,    -0.016685419632658439,   -0.061241449489691881,
       -0.02651345205055947,    -0.027860134557747818,   0.042351218236261992,    -0.076880884186579221,
       -0.0029155067834198407,  -0.1266033313706082,     0.014636551486346575,    0.04306516333338356,
       0.087274487682589566,    0.037617206602170543,    0.044278712693598787,    -0.082706800192024033,
       0.10679959797501444,     -0.12558571002535787,    0.095171380794912649,    -0.031642004797829457,
       -0.036734666602577494,   -0.10715018550086984,    0.068514970396846203,    -0.047441230370713378,
       0.090887039305424924,    0.20638613765501693,     0.085560398599887622,    -0.062006943990624216,
       0.014172906367727995,    0.17057237399320246,     0.026000884055353869,    -0.0048772576662325156,
       -0.12451518102078514,    -0.13222633775585918,    0.021261889031254578,    0.069918937403917761,
       0.018155965120855343,    0.016295270539285069,    0.11283432613722486,     -0.085456823869509327,
       -0.086351399197267323,   0.17059897465008725,     0.066345735436226003,    0.17615273589628283,
       -0.0092700501252035092,  -0.15978737246508481,    -0.032335957246531842,   -0.14569490114944839,
       0.13463495671921696,     -0.024882717477790674,   0.035335472200766035,    -0.10336674200616734,
       -0.013281352441106488,   -0.10318960548353395,    0.057185206042517589,    -0.16693414837058002,
       -0.15688076897649555,    -0.014641102314376285,   0.019471113933654891,    0.12221518459159053,
       -0.001238376895788389,   -0.055198255942298963,   0.26753527284836359,     0.096654178349652523,
       -0.17818127684774226,    0.17371865410418766,     -0.14977147182621245,    -0.092088402087790774,
       -0.015575922824492501,   -0.049216871576752627,   0.1259923608625397,      -0.1058719353688831,
       -0.034311081884113741,   0.018526790264796863,    0.09559433748315227,     -0.031914647574029065,
       0.09031307961629656,     0.02611141413390371,     -0.062913739361112456,   0.12736368458926989,
       -0.10313271093100577,    0.0029050201031642826,   -0.01511193881949662,    0.15580573473705614,
       0.14853780767167934,     -0.051347590490291223,   0.055424427640497279,    -0.057017109019997458,
       -0.063423381272389223,   0.0066661260615025466,   0.084890109241395062,    -0.2141051225436921,
       -0.018203331939959461,   0.076007337610630388,    -0.16964440567308442,    0.007126546553865601,
       -0.0061869236049739065,  0.21299365149285718,     0.084364978180984304,    -0.16523805131570371,
       0.026727391712709749,    -0.088011238713161868,   0.037656782743042898,    -0.12899397512480537,
       0.035507898772143436,    0.016023282904367154,    0.11783630072409056,     0.13030287514795696,
       0.18647245183954059,     -0.12757396554751782,    -0.091620583320623228,   0.19171450099177467,
       0.1619123151870645,      0.13712560444118688,     0.14466367136761843,     0.047275461546186073,
       -0.10569186908800654,    0.19079822023662285,     -0.001863483416318571,   -0.02404371877078728,
       -0.041103354560985433,   0.035989376556007771,    0.012051938301691628,    0.17050938701828619,
       0.083990506961714534,    -0.13126071544337239,    -0.020039191119722157,   0.0035257712812336237,
       -0.068246579193912291,   -0.059782201773998823,   -0.11873440694793301,    -0.08810618328496761,
       0.077211971662589529,    -0.025673001845394092,   0.020533361702555392,    0.16266549550038564,
       -0.12969321055279293,    -0.095641796491301473,   -0.04696441677531852,    0.03674011732834901,
       0.12082082704116406,     0.086165360840990662,    -0.0098741702374917778,  -0.097971644555310836,
       -0.024257229440688571,   0.062542869177596258,    0.229857964390346,       -0.08622039018220394,
       0.055978857312338488,    -0.16179858600623198,    -0.098375399994505092,   -0.0098107397674896193,
       -0.011812116848017567,   -0.085417714671775918,   -0.042442925815008942,   -0.1776471152727378,
       -0.17267577234859632,    -0.02703997988544354,    -0.015687343740347141,   0.14549961090886904,
       -0.099283278626816504,   0.049260043933035201,    -0.10866547040466473,    -0.011859373447069837,
       0.011246921423202313,    -0.070504788973448487,   0.080048030971070314,    -0.077356686401038335,
       -0.041937288404685913,   0.075927547075736374,    -0.01740131474566544,    0.094602419408172253,
       -0.078055495626511887,   0.039154055140330032,    -0.010485972543691024,   -0.10619256576347415,
       -0.068035506670914764,   -0.12577645023038919,    -0.10294633838532125,    0.066740263791458893,
       0.11098963976496949,     0.081158696748825504,    -0.10426163106280741,    -0.072265045577059109,
       0.21429382404597291,     0.066864629617704688,    -0.020323480013901059,   -0.022661461034478234,
       0.18703429657723,        -0.096245858628566106,   -0.13528529523003716,    -0.036399399405142641,
       -0.056503937603668751,   -0.08720537721998485,    -0.082174402719745923,   -0.019752842712758758,
       0.080563478851608375,    0.083624217349252156,    -0.0021555392615997095,  -0.0002294070810108309,
       -0.074449781904334614,   -0.029860539481916162,   0.052538122270101149,    -0.05964307293865128,
       0.15461396256805371,     0.043590149969004517,    -0.034274600121246571,   -0.064828947457481495,
       -0.11215434006908946,    0.068896386365904908,    -0.062614046801561754,   -0.11547533745733249,
       0.012859081574460739,    0.14852845688380198,     0.0441338048836597,      0.10307056446052877,
       -0.029718454129884379,   0.01524496979071055,     0.21173898406281474,     0.06284090199683337,
       0.14132261238386642,     -0.095561146819009707,   0.071312625972219226,    -0.067060634032627908,
       0.010722737893383058,    -0.096693114638836869,   -0.038053381030494056,   0.096817529390138837,
       0.23887129388463418,     -0.14544707123898673,    -0.012578108448484556,   -0.0062150451705648424,
       0.033659988236182423,    -0.13121287134410217,    0.047559307064776256,    -0.032147835552590806,
       0.16560221753713011,     0.12694348738228925,     0.022048460725600474,    0.033297538223214629,
       0.19092198694424964,     0.040661471321257033,    -0.048819533985341938,   0.046940172207365627,
       -0.0035798265509110923,  -0.029880853852969881,   0.067333195381224564,    -0.066080385213383094,
       -0.089166620550274384,   0.20444216375730215,     0.054929311095466581,    0.084743277462379391,
       -0.10701757781993215,    -0.010781291682421503,   -0.10121745370461975,    -0.065618098691994919,
       0.083631918995497573,    -0.12920548733353207,    0.014018617015532774,    -0.17037486012359671,
       -0.26499182297918361,    -0.12997350155152121,    -0.027311433130468916,   0.0084297602228304413,
       -0.123120426661016,      -0.039411409003201295,   0.26780266635566108,     -0.10900678934440257,
       -0.26622257731040133,    0.076994757426783564,    0.034698978613292013,    0.16835162348719374,
       0.13164558809491358,     -0.26528909262510464,    0.0046088765651430543,   0.018842659196652272,
       0.033564662906562716,    -0.035070414214966504,   0.22580828166386185,     0.013735016290969022,
       -0.032162526307355332,   -0.06383061483374447,    -0.16803883365550265,    -0.067152854506645335,
       0.075816072289074152,    0.12729989962476171,     -0.065011883842680404,   0.013641204612818012,
       0.079179504068827386,    -0.047744151541434854,   0.00014968835944628722,  -0.033398540946931898,
       0.0044236966025696083,   -0.028366994739410338,   0.11374728333419633,     -0.1697931408110416,
       0.042301213635923061,    -0.028652148006928668,   0.011619361462477114,    0.14736243363705021,
       0.045882800245684502,    -0.018523693719648161,   -0.085617858637686145,   -0.20485914361933097,
       0.056302288959784848,    0.084999501199027327,    0.030098216009052312,    0.21966031972653891,
       -0.02431038511979975,    -0.31774718337812446,    0.11621599152361133,     -0.0026884142027429714,
       0.12567646825576551,     -0.054759691520925365,   0.060503571345092655,    -0.020943388974208589,
       0.008422263578556563,    0.066941398102677643,    -0.087091605615980588,   0.07332998587171484,
       -0.0057074537725519438,  -0.17011828590242914,    0.016767323794911672,    -0.12918027816008937,
       -0.068776791316306138,   0.067123211662599866,    0.12114784845754405,     -0.0030244678668771997,
       0.013592053802419037,    0.026557180846603148,    0.014894495268584964,    0.034215357435475074,
       -0.0046803167206795216,  0.054647394183473731,    -0.05148312318912477,    0.15006006557977072,
       -0.013835234227893258,   0.13559143035282764,     0.070379478091314049,    0.05724778334910248,
       -0.090712224599721711,   0.056386469977982683,    0.024864599584019809,    0.16216633879780809,
       0.049483548538952891,    0.076217634893724961,    0.0022574606777029226,   -0.035078643295177299,
       -0.042092749626551684,   0.034329676805977483,    0.024726209805665051,    0.12910087180934945,
       0.12092522097290703,     -0.18584332327150546,    0.064219737387960579,    0.036522979209022907,
       -0.064339308826352304,   0.0030786730513361442,   -0.20454487106307154,    0.11162829882535721,
       -0.10123821335696535,    -0.052036864357238928,   -0.020992875728644653,   -0.060386355769848368,
       -0.049499456090248313,   -0.079348564963947404,   -0.08949976502361344,    0.047709541409632149,
       -0.011517849534228963,   0.18377234007551579,     0.015287221116623333,    -0.016413042419916,
       -0.055576277019142077,   -0.14366584985158115,    0.14900940286636735,     0.0048437076849490333,
       0.084656428883873536,    -0.047435634920371644,   -0.057469459682296525,   -0.11814316480753277,
       -0.13523746010328599,    -0.12596408976368892,    -0.0028242823909586652,  -0.16290118093163877,
       -0.075967749963717426,   -0.2684870419600362,     0.049967806523789154,    -0.16348112348192015,
       -0.033881605688432147,   0.041383669050611666,    -0.030241853323842379,   0.17572302881828178,
       0.046688080771739929,    0.085245566531153991,    -0.011488707945341339,   -0.018156543997681261,
       0.10530498490351205,     0.047316052483623507,    0.15265674367354062,     -0.11128283322501775,
       -0.05801877204985232,    0.18229926184524967,     0.052563038476859288,    -0.071388565764214915,
       0.057729038049079244,    0.039934731640997763,    -0.032668204646753657,   0.081274727242121925,
       -0.22364440743758338,    -0.15084031140073867,    -0.058966290643502041,   -0.099722171128973358,
       0.020889202037782269,    0.036738753265959517,    -0.11870060674313214,    -0.082566575138976389,
       -0.10082938583814366,    0.049251751714754301,    -0.00022023666092788399, -0.025209855224533048,
       -0.024558370881689273,   -0.05471146220958413,    0.059976221971942155,    0.084001213079824791,
       -0.067913986977353874,   -0.0063866659756853413,  0.11530146307482533,     0.0022035720444212514,
       0.18441255406471221,     -0.18757823116937913,    -0.14265783605933222,    -0.033926684669191076,
       -0.22503494836450713,    0.076560750974310116,    -0.11276248808145878,    -0.099873950880969009,
       0.039461943677717722,    -0.078917948903027293,   -0.025772267436560685,   -0.010928700606155391,
       0.019028841709930761,    0.028858335758753999,    -0.029345823746407793,   -0.12537215888210956,
       0.13039635151432782,     0.016402497756606932,    -0.062071996988725647,   -0.094677471592555601,
       0.18591382148608035,     -0.12376033481265991,    -0.027694027700708109,   -0.11078133433192701,
       -0.084836759904440895,   -0.076738259358389446,   -0.13378900694161402,    0.15015883826497137,
       0.0058275075710447809,   -0.043492880900797851,   -0.051177549321102939,   -0.13848603393144024,
       0.0082181526245708979,   0.11306597952931573,     -0.11753897533643974,    0.14439993579766403,
       0.023088180762132284,    0.055798880912228857,    -0.013651458889502076,   0.048781945582702151,
       -0.035212690114923555,   0.04741720738521879,     0.0010245196250059589,   -0.06191154952008552,
       -0.11773195666095414,    0.086627248255744027,    -0.24597924219887937,    -0.045321617293873954,
       0.19073407985903626,     -0.078719461143576461,   -0.079731522996378951,   -0.14126162434505402,
       -0.16619819932191229,    -0.11659169231880891,    0.045791275981093199,    -0.13157807846285471,
       -0.032221112852813004,   0.066079375570903875,    0.27023214652483252,     0.086096158748875676,
       -0.10913039563475431,    -0.18512945726224106,    -0.15892270717984214,    0.051760793412867559,
       0.19491092926360212,     -0.11965180106350107,    0.033224358901252402,    -0.046575022133161115,
       -0.044467727636150381,   0.074635367524052643,    -0.013145532008426396,   -0.11163322886141287,
       0.16194799825525319,     -0.14325941795538955,    0.036750560006799382,    -0.086958201914664843,
       -0.076054046428760264,   -0.10626425795054259,    -0.0084352674281614123,  0.035834014899934589,
       -0.10053709672211865,    0.025461408663522731,    0.072899742161055187,    0.0085193317321451845,
       0.092162687798554757,    -0.10403864741051054,    -0.022275234522922367,   0.14927251452211601,
       -0.10447116875397121,    0.11520313455471137,     -0.06705216258719543,    0.018861474665974088,
       -0.06755719958660765,    0.11676041780971501,     -0.17057894809658802,    -0.075805481395594967,
       0.10975273086198208,     -0.082825695432400662,   -0.0061171278639964447,  -0.076156199796693524,
       0.15538059521286787,     0.075877373088324485,    0.022411681987465727,    0.025542847997649828,
       0.039111100374792707,    0.014925450045170211,    -0.0008373287919097443,  -0.0083007822948358515,
       -0.0036501623880161845,  0.14738853370749333,     0.1476929948688078,      0.0062977054599757708,
       0.12626517442577742,     0.16616501152148316,     0.033377908435331137,    0.023157256371672253,
       0.087810491704462673,    -0.057162407471631684,   0.013747521596416091,    -0.1210794169882734,
       -0.10672394852995337,    -0.026009035910180875,   0.024752150343315526,    0.043065354607602732,
       0.039958520791117842,    0.031709091852797952,    -0.087369919479700811,   -0.017280922905792865,
       0.16184606032413421,     -0.13813600576339885,    0.099539703992241504,    0.14425429006274793,
       0.036345010612603229,    0.061784043938286612,    0.11000634465993889,     -0.035166657826935253,
       0.11924600995248474,     -0.010704161595511703,   -0.04891166821653848,    0.14352286278520909,
       0.073355338352003335,    -0.019611072865865883,   -0.00036830610741611473, -0.16777809217213682,
       -0.083502744283967006,   0.064521563293059039,    0.22268823482531955,     0.08543424705496544,
       0.075537761565674821,    -0.13898323283223762,    0.035791900717703627,    0.062134062884816828,
       0.049665663370887396,    -0.00095557344313791258, 0.17819745999553124,     0.11816088331745914,
       0.092981949539208131,    -0.015425779019848766,   -0.00020597868923347487, 0.024243201974573379,
       -0.063981663757144508,   -0.086462196024684079,   0.084657077749999338,    0.1231111675436838,
       0.16968121936688901,     -0.0035190051421088581,  0.12849948084848381,     0.081349448780342046,
       -0.04025369288718144,    -0.053583307850974274,   -0.066273911897107851,   0.097005173256973581,
       -0.07071133415595407,    0.039735405785501242,    0.086856699154175807,    -0.22442047210036034,
       0.11001916403234646,     0.17978269293967802,     -0.1306045395512051,     -0.10251034079937138,
       0.020620923883383623,    -0.023572786257829131,   -0.12306942525360715,    -0.0078366168611899104,
       0.062247312800366543,    0.053692180863932029,    0.057508954659541443,    0.10247473844644006,
       0.083818857678057926,    0.086287010824578514,    -0.009343660168501992,   -0.027043234279744508,
       0.14279243045829978,     -0.050014001996250293,   -0.070748546517440836,   0.041455062922264856,
       0.1405333835931436,      -0.034634826558205205,   -0.10740771427720525,    -0.1125582671854591,
       -0.1114747024870283,     0.023688259034408785,    0.083331906123429292,    0.060982977555376683,
       -0.014859681245434403,   -0.015598653742472811,   -0.090221737274799305,   -0.070512336859097788,
       0.00074168962631121927,  0.1447573752871415,      -0.010663141134380046,   0.055713555016815422,
       -0.019509925794099593,   0.2059926169228852,      0.12441077530468213,     0.038923127783769634,
       0.10530489220469796,     -0.067203790625596213,   -0.016297109935783469,   -0.031311894958446489,
       0.10301820914186664,     0.092185083511904992,    -0.015314268129094434,   0.079115717954077042,
       0.09733090631503663,     -0.070551759233586309,   0.2243733393462807,      0.12585344369254822,
       -0.08846839365773905,    0.042490769322222371,    -0.0095893346359421493,  -0.25515500335193614,
       -0.078319012390034248,   0.045773926439283352,    0.07151626223151962,     0.029337089865355735,
       0.28112134249951543,     -0.095638809472376893,   -0.090287077789557094,   -0.11476313350079641,
       -0.01973430864624141,    -0.089637296394747115,   -0.033199250852540531,   0.018243696585495132,
       -0.00082114473639637378, -0.018522244610025503,   -0.16937540074015414,    -0.1124689285660046,
       -0.12524150320181213,    -0.19191430013817518,    -0.035457074413793685,   -0.00057138482571407034,
       -0.029711187470307945,   0.059459391294527417,    0.070786661366861153,    0.078477339820829509,
       0.012272164683714594,    0.051064743314669571,    -0.10453546043544215,    0.06434509451003792,
       -0.078787289543832836,   0.098286903094000441,    -0.083057554596983399,   0.11191077408542856,
       -0.05162564505198089,    0.23963379309837826,     -0.091293551172746956,   0.1641386487515033,
       -0.022723177556927911,   0.011000214850392476,    -0.01249499489899643,    -0.075234626967910306,
       0.041685219917326238,    -0.090793423391517039,   -0.084065793767471614,   -0.12096052231260414,
       0.21348788824189685,     0.1425760560770887,      -0.025538762979493299,   0.011242629379729942,
       0.015163685261964002,    0.025252288091133127,    0.011543540719681908,    0.011862257276058769,
       0.22738475311375672,     -0.043448237899147445,   -0.12202653073040633,    0.092555346436056313,
       0.037515055305091811,    -0.2068625208753139,     0.10725164196326545,     -0.14648029864495898,
       -0.054312207144691559,   -0.034587833555949916,   0.027422820983082574,    -0.02594025246288896,
       -0.053752227870543824,   -0.01808425287599711,    0.099063350543774478,    0.025195025816878894,
       -0.11594702491439196,    -0.065665941729902755,   -0.094932117180681438,   -0.047758697842148361,
       -0.055692013145697598,   -0.078270585285721506,   -0.18766500655108165,    0.025500810356370671,
       -0.16248942446568601,    -0.096132683809440803,   0.12189765235344524,     -0.014821706528807991,
       0.062546069502890406,    0.069832404578978977,    0.15673840478745862,     -0.037795854567044762,
       -0.04781541454866383,    0.11131058109504316,     -0.083401078029270215,   0.0058651054886212691,
       -0.23560803479580422,    0.084102485508429858,    0.042693187447458418,    -0.046682717102824733,
       -0.10399642235506465,    0.039529272886089664,    0.043164252523138574,    0.10254860194566173,
       0.12816858586750471,     0.00049754765044689175,  -0.2192881043372065,     0.11830998480117975,
       0.12075201369697858,     0.11775766410284436,     0.063867257647828746,    0.19643508114732175,
       0.043816872513436834,    -0.12157085785017552,    0.10627097465476226,     0.030553303610582248,
       0.016004208602984068,    -0.15949197538607982,    0.04499333380923954,     -0.0073704459158723248,
       -0.058073453632025304,   0.0041536228287664591,   -0.087207620526622329,   -0.045781123884187092,
       0.079875555198859111,    -0.21662760272804527,    -0.015878886845114116,   -0.023487633670406471,
       0.12502683368837023,     0.023556035232817511,    0.16490952157150224,     -0.074687222608653681,
       0.062625166068159044,    0.067510445350879286,    -0.069415158327626694,   -0.070448203252784253,
       0.09209664871351167,     -0.037791131202510125,   0.14845810060781936,     0.010327341328038427,
       0.048926192207610048,    -0.06792806391338882,    0.16242424767701119,     0.024209179602430443,
       -0.00061824190179019835, 0.037105783113797149,    0.20316672848872072,     0.14202855762749217,
       -0.095309384195372049,   -0.006543289491157657,   -0.13192018003267841,    -0.034977298154432568,
       -0.009893020312513932,   -0.012310761902640351,   -0.023187636865944956,   0.10387965084449201,
       0.14228670442323268,     -0.15011048984734296,    -0.12572911700476327,    0.01265604284037098,
       -0.16478274657135139,    0.12335448471599331,     -0.079471090944886053,   0.12357117494997391,
       -0.24860724488365785,    0.05718093437522212,     -0.041246529349796834,   -0.050960066288930725,
       0.052274624774277807,    -0.049278988642736291,   -0.12298503701378988,    0.12740226693139106,
       -0.057193017914367567,   0.043432983463777809,    -0.12719662348183369,    0.12139555017739653,
       0.041092311718546985,    0.038606306822727803,    -0.080310506197012521,   0.068899492092952,
       -0.043034484408375047,   0.067573094264234218,    -0.10775312925000143,    0.073565243678753126,
       -0.11117083670499232,    0.0055852285016401975,   0.20472427218413386,     0.066261311784020782,
       0.0059794270944413608,   -0.14623468795025812,    -0.091067158627949341,   -0.0060534605623156108,
       -0.26839952479616985,    -0.18515797073586751,    -0.037413099038794806,   0.21157578199790988,
       0.077430760411049168,    -0.18796877896846206,    0.1049919027876533,      0.010810389243657421,
       -0.047065400660218547,   0.034806219803910438,    -0.11067078454415366,    0.046849912418358515,
       0.12289409488193793,     -0.01942875712003133,    -0.020772998329071445,   -0.050152503970713899,
       -0.0044469572272468165,  0.0058742014155525601,   0.15156374015271024,     -0.0042776817474087965,
       -0.067306152714975767,   -0.057005658175070348,   0.012143190859815677,    0.080418651853583711,
       0.048590389491608689,    -0.005755145854880718,   0.042593469175364274,    0.21320145378389865,
       -0.059997301933096624,   0.1956299788994571,      -0.10363494620120436,    0.056220274833158015,
       0.079127816671225593,    -0.096446370230964362,   -0.014255908674581298,   -0.067382463974170068,
       0.045393371975827393,    -0.11028790546887873,    -0.080788412028722376,   -0.063709211371115335,
       -0.23186332111532279,    0.0016386789485179493,   -0.023512967821413093,   0.01721029035628082,
       0.092839652302525957,    0.037305013283576896,    -0.076769772916365928,   -0.16617283272555566,
       -0.11711713284995437,    -0.010013126678150356,   0.12606567899041435,     0.032079721088814975,
       0.097764919050657137,    -0.04012487957268962,    0.078372702120128299,    0.095091236377419827,
       -0.015380630562593837,   0.055499812849658527,    0.11045845490564486,     -0.0079704163809506765,
       0.006119382994248336,    0.0044765979807324177,   -0.28471299777832865,    0.068488077224213836,
       0.091237362461448077,    -0.091909671651180663,   -0.017078807726397187,   0.070333837978812735,
       0.0053107090409475364,   -0.011866443620216632,   -0.038557314001332076,   0.0022771644979105651,
       -0.014983626288097743,   0.041719381567905015,    -0.081618950443528113,   0.042199782921829271,
       0.038591510201011661,    0.16611431237032692,     0.21868831586683438,     0.094384240641108771,
       0.0017238714913296385,   -0.091830846983207579,   0.19147963380521935,     -0.097088099244502929,
       0.063180573676772225,    -0.0072234914169473649,  0.16226576547793189,     -0.1140303389257771,
       0.11370651951109051,     -0.19076680254320369,    -0.036126289478897032,   -0.077317246654568017,
       -0.050177133463209123,   0.00088547633383506338,  -0.017972417463696249,   0.0013592185766625594,
       0.061890485373328821,    0.051393240863233193,    -0.059494853133211387,   -0.021599867399871155,
       0.089253313475908813,    0.030480175306266032,    -0.16042227565797731,    0.16588068776901532,
       0.11101493238024042,     -0.073349353591022154,   -0.11690021246502233,    -0.16425166572743663,
       0.026088346207479591,    -0.14907009414338349,    0.15293967389780125,     -0.08764185772772054,
       -0.0074948247744653206,  -0.066658639903543482,   -0.041737913113432279,   0.079892890947070166,
       0.065309091103686906,    -0.089579418926875612,   0.12087016881761015,     -0.0054057731034360401,
       0.11575652705940291,     -0.13553179956121375,    0.21195975418949001,     -0.11997782778483587,
       0.052781704992930854,    -0.078189782902316346,   -0.013002171229402067,   0.037011650374171666,
       0.0037419951696905894,   -0.12432960707922412,    -0.19672726305823271,    -0.15364273416700724,
       -0.10180661076004729,    -0.085919037010169341,   0.045640417330895633,    0.059517184925565722,
       0.028776238119324591,    0.024393598796599476,    -0.070405504155052118,   -0.20534236782520179,
       -0.016027318098776649,   -0.021452240416909713,   0.057355929747005097,    0.14167320022402072,
       0.012253142562669146,    -0.11428148806940915,    0.03559906789488014,     0.20671296694422162,
       -0.087473159993851551,   -0.17516005135407822,    -0.12545431399035467,    -0.056828386865789449,
       -0.093241807021561943,   0.07174609918134113,     0.040779791806553278,    -0.11307302635512927,
       -0.018695599158017811,   -0.025163335776527351,   -0.179419849649607,      -0.0367522447102131,
       -0.085149030953416083,   0.075173757311428432,    0.056715917071970004,    0.067825059452306297,
       0.021526325083075025,    0.0020705422419077212,   0.043207140733647023,    0.068597794642517612,
       -0.032916642865095595,   0.069276627878621405,    0.024370246422470855,    0.0091717396625375404,
       0.040503781636037732,    -0.0077139071171589968,  -0.13989824070996415,    -0.17446103500054091,
       0.10677396997775492,     0.094496978433241396,    0.013589925014780631,    0.018268014055656714,
       -0.062493953130354774,   -0.0060134457769192573,  -0.088847931306215711,   -0.18358006646757835,
       0.0080174622345389138,   -0.17609516319519958,    0.020289857406399502,    0.11120925214577183,
       0.26319785389519695,     0.018991328361027085,    0.10671542929593969,     0.10385376293044661,
       -0.074715668702381652,   0.013344666943678127,    -0.071177225449477036,   -0.080440068698006031,
       0.085459587292852024,    -0.13222906642177804,    0.015776196021157967,    0.025624002834714596,
       0.097765473569966219,    -0.15269596254916751,    -0.082334627335834437,   -0.022838465354863603,
       0.039893125906155888,    0.034207270355305887,    -0.20964406472087954,    -0.026785772023379509,
       0.062977512305076186,    -0.11691224853371332,    0.0061397465525773482,   0.19619385113981846,
       -0.10484777379794283,    0.24538324184094246,     0.026424171337413999,    -0.13351471252931532,
       0.063130608953325562,    0.13718837867180156,     -0.13390891011790398,    0.029628265541152908,
       0.043864024595177915,    0.013331356084027607,    0.15277402297552745,     -0.082712451412237833,
       -0.075801001060452552,   -0.091769394524188225,   0.010072447150878504,    0.043974782742116213,
       0.072895103413526063,    0.088889604638806102,    0.016880367091087686,    -0.12359958187119417,
       0.17644065767687916,     0.046646491110606612,    -0.11472522731503579,    0.074178957322680886,
       -0.10895497140037483,    0.012986416678350945,    -0.032215081177276901,   0.01470028636199361,
       -0.088457894148495836,   -0.10178827748556057,    -0.04348965211045424,    0.11372675583909805,
       0.22160084117500245,     0.071751521593217321,    -0.075683833943037307,   -0.17293955702041822,
       0.11597460087823599,     -0.030230464807973766,   0.15613675402063013,     -0.17024527067570719,
       0.097319053617007767,    -0.05085148920808201,    -0.044348809270456833,   -0.041873039749688534,
       0.054524196845585619,    -0.15192375015716783,    0.10922416988670684,     -0.11381754778661268,
       0.0024015371839582371,   0.15103014923203617,     0.011782894492484383,    -0.028305294223458413,
       -0.12636379281511681,    -0.016883403132211164,   -0.097287368686206452,   0.094161872621319337,
       -0.06161780720879835,    0.0017433351721323365,   -0.02340057078070026,    -0.074494838225252602,
       -0.044346929049956976,   -0.003440141601259817,   0.07130657744104052,     -0.14440342140120521,
       -0.10832897283561152,    0.032593238024984109,    -0.064846307075165227,   0.06928324993445141,
       -0.26018643983952644,    0.00087454259364568802,  -0.11532357698950806,    0.045913703588693171,
       -0.095759921390009078,   -0.018538447850650792,   0.074855382297350587,    0.035227580242370916,
       -0.10562752077325549,    0.049430069149622162,    -0.046534247111920127,   -0.078085820551006116,
       -0.0080958139209917537,  0.00069191933414849624,  0.047786882556821633,    -0.20211197837742423,
       -0.085751909280084887,   -0.10242245978085635,    0.10353102137856113,     -0.072311109384156275,
       -0.035168261520242133,   -0.067227336322014997,   -0.16020698589728957,    -0.22556918518124708,
       -0.032324987158650856,   0.1467976127460561,      -0.097749312395501151,   0.12442926914139484,
       -0.00011178793647718781, -0.0014227524322965018,  -0.12805655460693352,    -0.22613062340968254,
       -0.14018437925105093,    0.12060508052930557,     0.055358736813013294,    -0.11771045227596945,
       0.094196390218603737,    0.063930048842503195,    0.10605293125970858,     0.021643361309385885,
       -0.060008322513392366,   -0.1972783527740874,     -0.0030641454241271959,  -0.018597777924550713,
       0.06494846552163791,     0.010480258188487102,    -0.058490686870065173,   -0.069516962707662902,
       -0.090000530693689684,   -0.061745405193882746,   0.035582475916405717,    -0.18341088273481634,
       -0.016357439983497733,   -0.097770534801974757,   -0.046847589366228244,   -0.093108399736087727,
       0.0067931101110741028,   0.068498161354701242,    -0.093822426991761923,   0.094770331217128467,
       0.11520999159220895,     0.039813827757890351,    -0.036480137632991912,   -0.13796823966045632,
       0.09702122713869489,     -0.01942197129048201,    0.068867408858451329,    0.15959569521228975,
       0.22790808438299842,     0.0074332422610352937,   -0.053282002334939037,   -0.033805487950218607,
       0.0077577172144598812,   0.0573503996083271,      -0.11546890508981475,    0.020604388409204775,
       0.073825740996216055,    -0.030548638388471265,   0.051697020997779522,    -0.032779361302311641,
       -0.00051987064441967948, 0.14709674193434033,     -0.035468796523596108,   0.0041673159958017219,
       0.2551462603633553,      -0.056268909502299694,   -0.00080028316878236736, -0.16355046597214762,
       -0.066738063273402162,   -0.2253863041609134,     0.0073352040563642012,   0.013717524846654054,
       0.0240434343986809,      0.13886996087400807,     0.028201078470593131,    -0.10418285479746844,
       -0.02991999961536411,    -0.029921611878420594,   0.19207596260554538,     -0.13747833073312288,
       -0.17689518792665304,    0.17895081788838227,     0.099909929520041796,    -0.03697359486730456,
       -0.035204541829552287,   0.035951577379021424,    0.075079003469295663,    0.020588725013730869,
       0.11056069878443595,     0.02724325420605913,     0.10626401536733472,     -0.17557705775379648,
       -0.069440084549665521,   0.097974903014926201,    -0.19795074341122873,    0.036539809765545113,
       -0.025255618463824209,   -0.017609455125483162,   -0.27694920980617194,    -0.11684818036744041,
       0.062223910182894665,    -0.11764111542464872,    0.071084915248005087,    -0.0498855465122909,
       -0.0053521201302911504,  -0.060785002504596265,   0.1617040365901109,      -0.092842041464620315,
       0.063231976692171163,    0.081161857411598301,    -0.15369384801411801,    -0.071889849279561546,
       -0.037250858591552222,   -0.015835353040503455,   0.021770921156776625,    0.16290504419394888,
       0.080751331682483815,    -0.055607729247135904,   0.0089996034081271607,   0.17023034114292676,
       0.073185593946554869,    -0.11554789986489436,    0.011852865130456634,    -0.050469578663025871,
       -0.055625594574049878,   0.22863453499426706,     0.00037075045615137621,  -0.17419923838450205,
       -0.21215429567681535,    0.037180108299372114,    -0.035106197853658587,   0.022065342169721478,
       -0.0035153122285123788,  -0.070279306898704874,   -0.042540646619318126,   0.021803014235331535,
       0.075661762849436792,    0.023502563779104035,    -0.064716223771668024,   -0.040706118244638767,
       0.082793532352212595,    -0.17643221721115049,    -0.13093788990145497,    0.064769705579260817,
       0.071924275255438722,    -0.10412030164613033,    -0.079305163914830584,   -0.23566271478755629,
       0.0046177237995634925,   0.036221280308066137,    -0.017619746364633683,   0.136708508339319,
       0.028316250168331836,    -0.12533195418551915,    -0.18841436278580073,    -0.034473298741559293,
       0.10160574136314354,     0.17416327921802047,     0.085474614304094337,    -0.15576931497568317,
       -0.060617201874640717,   -0.11124116078895936,    0.086823850704947081,    0.10675197332325474,
       0.0018153957929366452,   -0.10761181035374524,    0.04114370994763452,     0.074485261006015158,
       0.0052667219206775709,   -0.090950205618195598,   -0.073698951169594656,   0.12033629708192821,
       0.13723409214786453,     -0.11001946944450335,    -0.20550686674911112,    -0.030357613785161056,
       0.075642438711764695,    0.10621626075714265,     0.1036131907914787,      -0.064487154822776158,
       -0.1355478033174097,     0.047835436900802761,    -0.15561985181723015,    0.033601600910401069,
       -0.057379661034656311,   -0.13563652363649087,    -0.16238382492845538,    0.056226592744170613,
       -0.027915356433511916,   -0.071437546699442467,   -0.0073220447677751765,  0.086934596771904959,
       -0.19191123449430739,    -0.045517681034975055,   0.14460952875199592,     0.0089906115349896159,
       -0.082052429628861348,   0.018175606584597794,    -0.12317330574805437,    0.1169456885246718,
       0.025594721987358186,    0.050586192415637332,    -0.034985545319195809,   0.048650453485407689,
       -0.0017993440634559354,  0.022886630943242899,    -0.042435603579291103,   0.042597547079232988,
       -0.044477506633675397,   0.13809087312776375,     -0.081193747679405098,   0.12997694648592448,
       -0.036685179142525587,   -0.10677082639012295,    0.15734502720765844,     -0.021543646206344181,
       0.04345939655993452,     -0.072243034909604889,   0.050104088838595698,    -0.058274170272380972,
       -0.041446122155373938,   0.069662486211781866,    -0.095813555106886591,   -0.21712915806635577,
       0.087875321763068476,    0.01888523277769686,     -0.077813611705267641,   0.047411448695496572,
       0.041508888616257095,    -0.22398849562289372,    -0.033153493198101951,   0.078529260810460563,
       0.26261801754838637,     -0.0052721900177517492,  0.028255811136386443,    -0.07682955899289852,
       0.078089236613055002,    0.0062676185181994798,   0.1215549184230801,      -0.034054956280438087,
       0.0036255817976041781,   0.1384260946918833,      0.037740266866164975,    0.026039354535250823,
       0.054820913613541807,    -0.094438578905248816,   0.0067722136335424746,   -0.12322236591455352,
       -0.1468587402884366,     0.14795604835250298,     -0.027371445855552162,   0.076997178637627353,
       0.13372534244888232,     -0.035147566953427703,   0.0073530844007204084,   -0.13780040840960145,
       0.028800300039377936,    -0.10599899224533248,    0.12831298094401572,     -0.1169253697285612,
       0.072957197646288163,    -0.022360342483109117,   0.24399258547304006,     -0.03838373790098798,
       0.084421760438914265,    -0.074815881280535804,   -0.1033390222854382,     0.12019922561101695,
       -0.16863857577443794,    0.025654031196550114,    -0.075449456423216807,   -0.16113714305964483,
       0.014914365261592823,    0.062071294335702985,    0.15177252147100317,     -0.1073397662818608,
       0.01654126245037028,     -0.2193076887435278,     0.021702742487576615,    -0.19402453322733376,
       0.16972381474889428,     0.040287944628709535,    0.072254108410061857,    -0.04276742290328607,
       -0.11297383351976131,    -0.10141966628132536,    0.096752194181487228,    0.030805807988458025,
       -0.035631876310563596,   0.019260847387354341,    0.025807946756026701,    -0.062038278988794458,
       0.16368110855710905,     0.0039163552332959622,   0.061218480268508513,    -0.12313987835675685,
       0.082744866545057916,    -0.044191482815679278,   -0.0043158242349514457,  -0.054734980729012297,
       0.099916093556352115,    -0.13030919620716919,    -0.016169764205583009,   0.20196264014377244,
       -0.12726099308569752,    -0.013171202450794617,   -0.033575136745505635,   -0.11008282232992038,
       0.062257992950392332,    0.0027194271462638361,   0.054522317113809241,    0.10639369857299254,
       -0.029526982913538044,   -0.183000750351347,      0.15304994716328593,     0.018438040375584244,
       0.11275860601231896,     0.14027163239439414,     -0.020365686477083957,   -0.097789969507249594,
       -0.019662846084760408,   -0.0011788565989145671,  0.0040148452770993066,   -0.077329135152953657,
       -0.065020961052305717,   0.11474201126968045,     -0.0021709908160615129,  0.081947281584704212,
       0.056104437024927033,    -0.15043896098040854,    0.020787725300051584,    -0.1714338253550218,
       0.029484835851158152,    0.048628043704234819,    0.0080318365485426198,   -0.023797704409366235,
       0.042122753956933726,    0.055510988137648376,    -0.0052011734710991622,  0.063190438986179126,
       -0.073272293962526783,   0.030847628216423121,    0.06361686360616961,     0.033511934857488879,
       -0.16984440707134835,    -0.017080076236635443,   0.027153553403044286,    -0.00094879267127913694,
       -0.10178521028092689,    0.094950835259098573,    0.0065525080765830492,   0.22487989251732907,
       -0.064593536261844303,   0.11317236859964852,     -0.1587719762813318,     -0.019242718049629588,
       -0.010933644885608577,   0.020168020417912921,    -0.044613067057352393,   -0.14117185906380714,
       -0.10274190412251571,    0.064340901165369752,    -0.17040255816359109,    0.068397427589592857,
       -0.061859424768912812,   0.039268102637024127,    0.106443208847312,       -0.14443757677946109,
       0.019824703975020303,    -0.10799632160443448,    0.02326847221000421,     0.03114981110659883,
       -0.18858474778845233,    -0.071593807826929048,   0.2167871250691053,      0.099311411964803864,
       0.040615761946651847,    0.016962197783111619,    0.0081963058646973251,   -0.097143937056856464,
       0.041296181997642928,    -0.042637748675222721,   -0.13021894561566741,    0.093366587004314244,
       -0.018644712270333048,   0.14572435106515794,     -0.0006217831188854914,  0.052056028083813939,
       0.054114400198402093,    0.11878038681373794,     -0.055199070445880016,   -0.10565369739550434,
       0.11293588165298181,     0.048835246339438677,    0.19019108295812329,     -0.046872678878160816,
       -0.057105675948778786,   -0.081741602719725234,   -0.02536796908088805,    0.014042962049704682,
       -0.13877943739724871,    -0.054886246378756227,   -0.091129781606288332,   -0.039252829933189869,
       -0.0015718151551097682,  -0.28406319457937357,    -0.17395932467976807,    0.09094175477592209,
       -0.11429407829691676,    -0.12829656504865028,    -0.039658525852077228,   -0.13015362066923386,
       -0.18080968153619734,    0.018425290635455588,    0.016197312527423874,    -0.013986789494489076,
       0.071651146808588945,    -0.10310937512943963,    -0.018466327303467749,   0.014927019750104249,
       0.17583146931125387,     0.1708466384039424,      0.084233400909833944,    -0.23920947594737016,
       0.10607093291827269,     0.10277478874596384,     0.055413369685782206,    0.11485169538649546,
       -0.04292449415140874,    -0.066788762079201772,   -0.0078189644266212881,  -0.067427948489745426,
       -0.14528119682724019,    0.018066533946098254,    -0.10200112651623819,    -0.083215074084238658,
       0.0010111780838054796,   0.06658653341709099,     -0.064477679780230113,   -0.0027472247230387117,
       -0.010289754455549808,   -0.02399909364775343,    -0.0305198830585095,     0.12395196034454148,
       0.087345872506009531,    0.040696316722109223,    0.0040026512455787972,   -0.00097228712074403159,
       0.0043745432198036734,   -0.02370599321569522,    -0.11443038980862469,    -0.0060930194797669639,
       0.035761729860456393,    0.045961631632926263,    0.2343610081924733,      -0.029396177524603898,
       0.10604620641317239,     0.055522972431389976,    0.13608090022991828,     -0.034987734874742535,
       -0.085493391413154832,   -0.23260822887113136,    -0.03597230921623934,    -0.031324824558488604,
       0.067000324426846142,    0.13469305022084466,     -0.24450789814709456,    0.03382816451243844,
       0.032801147420270488,    -0.06270387205969051,    0.30835019621239157,     -0.074225819063215376,
       0.061414051165928477,    0.24722564667553182,     0.00036913471415679546,  0.089420442663753472,
       0.015392247440005719,    -0.0093562719492463423,  -0.011019402784032982,   -0.07204357023736116,
       -0.1178684986843086,     -0.024236207493179319,   0.026336549317315352,    0.023584409919440455,
       -0.065764700865649048,   0.05477065137475802,     -0.03150207737284047,    0.02702795517878559,
       0.03030125588076861,     0.11960115348362087,     -0.15929622217643949,    -0.0001820944678351151,
       0.073063723675851636,    -0.26225917082927314,    0.148259998387128,       0.038924538044792907,
       0.041941858904636455,    -0.043494141271175762,   0.036865494760813876,    0.18611962730246046,
       -0.013515849303788345,   -0.00045881930970449042, -0.017600816258833144,   0.034376866782187272,
       -0.12214841195872533,    -0.010412399543700717,   0.038767412429559181,    0.10005113748030683,
       0.19733384260464304,     -0.077753311116679533,   -0.0024574420700274446,  0.026416490746176868,
       0.15231897764849353,     0.00052071599728826731,  -0.07284808264004429,    -0.15325195419304813,
       0.10696182242958614,     -0.088461807010528637,   -0.048064724345313316,   0.193174507990266,
       0.14514782074970731,     -0.094004692003886878,   -0.13813069680180329,    -0.051157475263012536,
       0.043240687408816113,    -0.025398286742325551,   0.022252965394885221,    0.07318445696550091,
       0.014727136330303033,    0.021418823698943448,    -0.021131468527179967,   0.021243898883432658,
       0.15355578813471038,     0.026172124272261559,    0.055450574948104438,    0.077357690404569884,
       -0.16850708700680139,    0.17812906449333707,     -0.080706397869086136,   0.030221231033253824,
       0.035479698081544025,    0.021076304773428835,    0.16555211868578218,     0.015852220517648358,
       0.027504390552234245,    0.098637025218586707,    -0.067311183649909068,   0.025878966818176315,
       0.015717943673248157,    -0.17260288606841678,    0.0063582695848945475,   -0.10777900595652469,
       0.017494026252381986,    0.0053110507465486435,   -0.031862667171407739,   -0.18002946147484561,
       -0.074849378585304646,   -0.0050272287148433025,  -0.023975309609630336,   0.031359202236444082,
       0.02860884792413132,     0.085933197795397029,    -0.08420849515904158,    0.02717724801746059,
       -0.10076088896037071,    0.14254006718362755,     0.14044932634193119,     -0.087988192393992679,
       -0.17962271787063103,    0.10129443655040796,     -0.14417800982107368,    0.021844859900545244,
       0.16434380342140537,     -0.030694322492030249,   -0.10177362351563671,    -0.079853176426106925,
       0.061762247171646772,    -0.13041872590261641,    0.0069917988033819881,   0.10465394595944574,
       -0.012748646732991718,   0.19716561926360773,     0.079602339644689213,    0.17727710751476028,
       -0.17422424549022181,    0.011804177128631112,    0.11923842863731267,     -0.0062725854737486148,
       0.0035849025189866705,   -0.10048874373050071,    -0.12255979369557309,    0.12910364671244723,
       -0.13722947208593911,    -0.10030369675587297,    0.12287967946509387,     0.15985953949058948,
       -0.038277684354862181,   0.14885437004485652,     -0.13570315123041188,    -0.030224403857746805,
       0.13572354776882881,     -0.057836531346926484,   0.23168691768649741,     0.074620494667732032,
       -0.12375756723923086,    -0.18207604765311414,    -0.015704982305537608,   0.081394872589187053,
       -0.095531393408114687,   -0.13716753956977051,    0.026180401892164001,    -0.090897337290580971,
       0.10029025410999544,     -0.098907014968557777,   -0.040218286974799747,   -0.19894360774467618,
       0.14120694901372563,     -0.063309030078067804,   -0.070055279921941271,   -0.022288113818062887,
       0.04473906241279,        0.026555682128295236,    -0.020158690833200175,   -0.068063255349443297,
       0.19635698355549669,     0.074360836982314993,    -0.019388917473934376,   -0.12548910194390672,
       -0.11712774942029039,    -0.074909589115859126,   -0.011292847018592414,   0.015465685722041038,
       0.077807019053592802,    0.072161801199928197,    0.11034509383832394,     -0.0050796012884662184,
       0.030012594535209911,    0.085998004422428526,    -0.14825281221605927,    -0.19789885579077454,
       0.023699767327579377,    0.038222005187347009,    0.18476928423954672,     0.024170862389457731,
       0.11805938503592268,     -0.092445804486609245,   0.033538224138569911,    0.028066634632271478,
       0.06372987808377939,     0.1212731589645112,      -0.047038294617927127,   -0.069450022144114082,
       0.022073273207996326,    0.014400637015361584,    0.10388434908110161,     0.0097948005033992695,
       -0.09385812689924368,    0.09449477147303266,     0.027785149558025739,    0.17886222635565818,
       -0.068808362483805827,   -0.13876084991071974,    0.079881586270551475,    -0.06694397186322365,
       -0.020693692395165872,   -0.12494934905121478,    0.056102754083829108,    0.037528280230498208,
       0.019049598694900666,    -0.054687147407088708,   -0.08117234181819552,    0.10280002220500668,
       0.14234577344392593,     -0.020598947870882851,   0.089918252750318006,    -0.036845774385699449,
       -0.0065734609846613331,  -0.13207700895718966,    0.044358139574875985,    0.13635802003796615,
       -0.045370840976347804,   -0.014661594796247148,   0.018873501368041865,    0.024856093703746106,
       -0.012253425578582108,   0.010112732458032731,    -0.081202340432824358,   0.21415315265568252,
       -0.023881385667968619,   -0.10865258258981157,    0.15854878453489588,     -0.10448634456352114,
       -0.03938193725153942,    0.097394959876957454,    -0.031509204631471277,   0.0080086428366331411,
       -0.16088997133746574,    -0.044937817100313818,   0.32072736918291345,     -0.035530855370046216,
       -0.16758357777106661,    0.1346545362207788,      -0.046720457136666421,   -0.014913420147532512,
       -0.05972422983039876,    -0.19567042677063762,    -0.036117364923838838,   0.12058171161219744,
       0.069403444645698933,    0.13466015369301901,     0.05619197144563419,     -0.13643167450440791,
       0.017939450426581363,    -0.05346546639500635,    -0.1873294596052183,     0.0087330251609235542,
       -0.051917965271231409,   0.048324127133107186,    0.037865750440997076,    -0.013144134421973442,
       0.17641121384497588,     -0.1447939182627957,     0.16667342372343572,     -0.098057509097267945,
       -0.030286290941226097,   -0.089136832113683007,   -0.0069468629230255256,  -0.087177698563734904,
       -0.28393101749308108,    -0.091412628097735829,   -0.017957509808595118,   0.067214523360372383,
       0.1589009024820881,      0.026475791610832217,    -0.088711504599092592,   0.059530433821889481,
       0.0011888639820774784,   0.032191037105434438,    0.042078884286135487,    -0.0067204675033009521,
       -0.015756690507742019,   0.11237581972152942,     -0.010886702067921774,   -0.040248731495071376,
       0.0015347259832001123,   0.18364852231728976,     -0.075198424504372863,   -0.15537922237556953,
       -0.11790512447341069,    0.068466953737647884,    -0.075118281714442611,   -0.020255811224977518,
       0.10939767360734129,     0.055652569892097999,    0.14341167226016796,     -0.032956472712002936,
       -0.065598089505374657,   -0.059883461836363373,   -0.24899738598845336,    0.015364001590176004,
       0.00042309772697536195,  0.044781090838828107,    -0.21020854332902303,    0.048298736916549588,
       -0.10026423932620587,    0.049723611008336305,    0.11823217055823664,     -0.22665713114592634,
       0.10944442258005135,     0.050074592356700434,    -0.018935770343915661,   -0.14418704111204211,
       -0.050808231345197769,   0.16748464625248849,     -0.0041222353089066339,  0.044035513587855936,
       -0.063703650617259522,   0.077275027184323136,    0.089435705440422689,    -0.04958286241651421,
       -0.084433876082218515,   0.039279878803999677,    -0.055061393137754988,   -0.036278417569478985,
       -0.027157356282925361,   -0.0054482195489407642,  -0.2800132691686687,     0.14276496738282649,
       0.022371312817083346,    -0.10393391116554172,    0.12700813386598403,     -0.064239340268798961,
       0.051955978861129022,    0.0018931564891969481,   0.048144755021666388,    0.14867364901278704,
       -0.11223144794521392,    -0.010558807491580278,   0.013211471400774513,    0.0044957155711673087,
       0.018932358767554409,    -0.1470593335516871,     -0.017177849113489251,   0.10814412906690803,
       -0.11778201153597376,    0.22110978527966454,     -0.0075693048946790598,  -0.12375963663097429,
       0.011339896656373197,    0.015940667634096135,    0.057086286295431006,    -0.043266229812724669,
       -0.042735252663833559,   0.1309487172315299,      0.098345904679743371,    0.029077956846338248,
       -0.06400563267078134,    0.051402765022522383,    -0.052110722672969428,   -0.098495495643877426,
       0.15927321125541594,     -0.07443167559720551,    -0.20784992720057535,    0.013153834588431482,
       -0.036453995075057401,   -0.12310521788004081,    -0.168716472513598,      0.16373190762890186,
       0.0070455964019096266,   -0.072792483697627405,   -0.066800641356066101,   0.025403299769188217,
       0.036776461791400802,    -0.064078094689188528,   -0.0044196710709483054,  -0.2368658855659676,
       0.0066152885344396527,   0.050888098821299847,    -0.0010260297535501207,  0.012048681501430795,
       0.0635455637251401,      -0.032719751021296678,   -0.06757312187463746,    -0.00023273365669680603,
       0.12766620968437278,     0.10872549165984655,     0.018797531700641933,    0.01162063966393391,
       -0.070948813057440482,   -0.0023633519700856976,  -0.11705546164287835,    0.096150593585908745,
       0.28545786107451232,     -0.14878655698573845,    0.083200794427564603,    0.03076053854634124,
       0.14461271304941045,     -0.12290088332216273,    0.087530830903841284,    0.12361395559625982,
       -0.073417778000773343,   0.13189193925275083,     0.11886118728675273,     -0.06240499418346783,
       0.096798586908087569,    0.045100214351852963,    0.064148357073351189,    0.12510074791827641,
       0.040314502710499855,    -0.021356524240905082,   -0.089513667640018973,   0.1634133419976587,
       -0.046159735697477944,   0.019114577175156897,    -0.081920801954043485,   -0.024632473147037617,
       -0.107259219930442,      -0.043728106630659999,   -0.11969370405461999,    -0.043480985956216911,
       0.18410264934344564,     0.037117532257504478,    -0.097385087034745424,   0.041119178600808846,
       0.16835826424596453,     0.077980982915348926,    -0.11092578666206948,    -0.029479629948797815,
       0.020920105179800683,    -0.13752017030675862,    -0.035446716776571248,   0.020589184921192119,
       -0.013609079029714633,   0.11009227892307558,     -0.090066587539872026,   0.20640026178170504,
       -0.01750029062495809,    -0.073450348461768095,   0.0026891305102533162,   0.020964163628744138,
       -0.039539021008272175,   0.22089160685694242,     0.033985552408266242,    -0.24257085899920069,
       0.06832345621048333,     -0.059227406401033453,   0.021051602165510531,    -0.12341403719640077,
       -0.024966415628690869,   -0.12212914435907658,    -0.052850286775289933,   0.0093593044912179645,
       -0.038977713726531547,   0.12850127968501632,     0.032048682949517224,    -0.20566364581162039,
       0.077149754953523705,    -0.047620150641105065,   0.032446363189938196,    -0.03604450501811364,
       0.13143527869276778,     0.046202104555405459,    -0.13259387628496791,    -0.15065536155495018,
       0.084173028054159466,    0.036797338527721574,    0.095917946916054014,    -0.011951923720467704,
       -0.11033302624603766,    0.10130503242160963,     -0.11072285585869604,    -0.044229491300819559,
       -0.083700800724886865,   -0.089768322848923596,   0.00032454917839434654,  -0.23341746293377422,
       -0.010490905344180415,   -0.066966326486636196,   -0.079522492244914519,   0.21431089790106783,
       -0.017559459317732236,   -0.052656299057526883,   -0.029499810924221114,   0.10224170965110715,
       -0.14232352534596021,    0.062798684479774894,    -0.13475678205358882,    -0.020855813059604766,
       -0.031762624532840213,   -0.097417436687165487,   -0.14545480468752034,    0.12994947644390575,
       -0.098391830480517389,   -0.054743349690640986,   -0.0033393709662208476,  0.11712498125331584,
       -0.12210501408208098,    -0.037431171126613316,   -0.077367316491139981,   0.0087493035356789994,
       0.061701720482451997,    -0.051204921400480136,   -0.13560952879951557,    -0.021828474872666509,
       0.058389068621606685,    -0.026921854135440272,   -0.043535748244048711,   -0.014921804228285696,
       -0.10044649320005149,    0.19400400166943993,     -0.0021668744866752436,  -0.14787553302017353,
       -0.018662838582186585,   0.093062228397380556,    -0.048201068281422912,   -0.097823939949451016,
       0.052115748740905771,    -0.13598651058747677,    -0.16736099490793124,    -0.089512612120557486,
       -0.22762938952697517,    0.016985904566136072,    0.19652168372357928,     -0.028339279278310772,
       0.09115723552579752,     -0.040109745365984599,   0.021944876124603822,    -0.10992271753369867,
       -0.14364304281162787,    0.026504833136046221,    0.013969993591140097,    0.033096844123351316,
       -0.043225644407186133,   0.22654814660026568,     -0.0096686476532985635,  -0.06580925333990599,
       -0.10362432884478628,    0.056376634039134343,    0.21669118505405796,     -0.082107081104324506,
       -0.05173061316022072,    0.097471096622233883,    0.069602176093431056,    0.030013534189216245,
       -0.045519927542546829,   -0.074070832105071552,   0.11484835908626662,     0.10741068356350565,
       0.1509532697483347,      -0.061723163135098104,   -0.15141390910007171,    0.013607078451052732,
       -0.11815270666052242,    0.027103144832177052,    0.12213801939053956,     0.013131679727999298,
       0.049797303793363917,    0.07753419550055464,     -0.096192750044649569,   -0.19848746147450747,
       -0.043656044414404738,   0.052612327079691552,    0.013989097841767998,    -0.1783009994765771,
       -0.21346045747511019,    0.13153367495224597,     0.12624203024136141,     -0.13616377986200684,
       0.10620289832611632,     0.097009463528684656,    0.12739929556027993,     -0.050940041977041536,
       0.20920918401030467,     -0.15338807387996031,    0.093773887477797094,    -0.054605599352267574,
       0.015530633364532042,    0.14547728915247241,     -0.027329487236050064,   0.060626757234330961,
       0.031707214670669358,    0.14814759136723771,     -0.13530887754775572,    0.15359156288937872,
       0.09673498455266584,     -0.091378272416428208,   -0.15585668839918967,    0.041653163791237818,
       -0.082940042435723824,   -0.028490421175487918,   -0.23037066912662593,    -0.084987168836094126,
       -0.093542760046575357,   -0.013422272840432613,   0.11222730821827301,     -0.052396156442773366,
       0.077205750190650332,    0.097403366043721282,    -0.0011837194416192938,  0.081291331234627895,
       0.16655475773869374,     -0.095333380910017126,   -0.019393285183451126,   -0.17079811230083025,
       0.12084406634143982,     0.046874403571491349,    0.014221919735245314,    -0.11619651833614569,
       -0.021472315681207096,   -0.017741283866291264,   0.13038566561804918,     0.029727688462805362,
       -0.036289699630772963,   -0.13483293013197675,    -0.12025452790421617,    0.11982729811083681,
       -0.22032373570419866,    0.06749810511361265,     -0.042918331445524385,   -0.034113677988522322,
       0.092155867071118627,    0.069050802852663851,    0.031844464321559789,    0.05204983781649461,
       -0.011636747672819175,   0.046671301391631066,    0.080532767647403691,    -0.026300435543691894,
       -0.096851815646716272,   0.015181948486451411,    0.10658345211647896,     -0.038016910997506842,
       0.064648056858999631,    -0.084423627510280833,   0.015661469024698851,    0.12252224541437572,
       -0.049634287393488123,   0.053477648624717794,    0.0084738022582618693,   -0.024106855675567106,
       -0.020308421057399696,   -0.15931588421014392,    -0.10171462021665756,    -0.0060543926936238862,
       0.2034625080788052,      -0.023403517250574823,   -0.1388821902007337,     -0.0015960900199129347,
       -0.10167881646984664,    -0.017394205150646224,   -0.13720123074449467,    0.11750975145636064,
       -0.031266683289121994,   0.026294313328995528,    -0.13005505095467773,    0.020141461372863229,
       0.072900995520473119,    0.17020811255938473,     0.028137010284668897,    -0.1102751922635839,
       0.0079870323102652682,   -0.1433632842760823,     0.056624554353067222,    -0.056691296823572011,
       -0.19131722725350464,    0.030465073118519249,    -0.042497686633823223,   0.017880094915052682,
       -0.050755733993777537,   -0.07730831256273199,    -0.078652680541409448,   -0.01248990058147415,
       -0.18173205689060504,    -0.073597006154082933,   -0.0059935712542738837,  0.079154149056907375,
       -0.087879516326802687,   -0.021561338651546899,   0.058188735495327347,    0.12511649428632193,
       -0.13598450878018606,    0.11314687237003582,     0.086885712729902559,    -0.069766044178409148,
       -0.022113950728391434,   -0.23372005680337213,    0.020413976096287152,    -0.016631988430460501,
       -0.07535740977553726,    0.11110099344271708,     0.052457597080498838,    -0.23567743213461384,
       0.016597339517468952,    0.071680794101743342,    -0.12099150216395509,    -0.067460797878931125,
       0.037561882561302974,    0.17648930571091176,     -0.041109520940056841,   -0.012005505029354234,
       0.048134773030204386,    0.0064393039877814169,   -0.066045387251533721,   -0.18963307477356237,
       0.12688907954944409,     0.063500706433738743,    -0.11929372694688455,    0.16591218326222371,
       -0.10532784670708437,    -0.15955140039975105,    -0.14428836963531952,    0.083079033429243845,
       -0.088719646634376342,   0.043616368890569288,    0.03440330988192343,     -0.039815253946078814,
       -0.015979240967777468,   0.028212873082717548,    -0.022172643929888228,   -0.042559424830111416,
       -0.10265016402231317,    -0.023286136211941495,   -0.11157974846847653,    0.095008825637137848,
       0.064296169837150557,    -0.12034890987525859,    -0.16477294694243305,    -0.15223235539332328,
       -0.00050773946111094511, -0.062455135207994644,   0.055336032288043999,    -0.0093780916263683459,
       0.10577988491580367,     -0.029611576853687108,   0.046310787568627158,    -0.0058912495481928629,
       -0.31821238226581328,    0.089177869640452614,    0.15933495468858982,     -0.059884664690410407,
       0.055070588264706628,    -0.067128629226359288,   0.21642946041790853,     0.039695771881708995,
       0.048392668225423555,    -0.025388321148378738,   -0.044188362937269084,   -0.15794383004291934,
       0.16992965745916166,     -0.17243359007637393,    0.058314125067144271,    -0.046224802740037554,
       0.13333322590103538,     0.073057604674791041,    0.024404375481991463,    -0.076351831714816853,
       0.0059024788221856313,   -0.06470327070654415,    0.053573656056002568,    0.016847317871063801,
       -0.066466038889248236,   0.022566234828643672,    0.032339003511350606,    0.0067560599127468347,
       -0.005637757519096653,   -0.021416121493712321,   0.034078198530928118,    -0.073991701960772996,
       0.21202167030448613,     0.17004122079628861,     -0.15097647678529211,    -0.055495684924522753,
       -0.094479416643394931,   0.0095095675402729514,   0.057742877465210417,    0.10272011704171127,
       -0.066716485692575225,   0.12439431447891841,     -0.00076744521619079385, -0.021734493106741255,
       -0.1405185129783629,     -0.015188409737918088,   -0.098362197695488179,   0.15976725701159261,
       -0.032600017958460722,   0.09390911002710145,     0.12082211900494479,     0.10170622735372101,
       0.03295178628976788,     0.16609158966569265,     0.25779052360940163,     0.11458600325708648,
       0.042446299829900093,    -0.060774972916610215,   0.017383454655807033,    -0.077299403239572045,
       0.027735551205070777,    -0.10299446665052067,    -0.003291758848212565,   0.017355057081986865,
       -0.006621179665132565,   -0.12754413252190305,    -0.011224763731643748,   5.7871823762040923e-05,
       0.039621188954619177,    -0.14425102912153612,    -0.12937379402283936,    -0.016556564087584168,
       0.035057933403899136,    -0.056402908168423901,   0.032922806925947873,    -0.093756466350222931,
       0.13484418706750131,     -0.037370100579724008,   0.050428417946631728,    0.16422243460891536,
       -0.076910673570256244,   -0.13450364399534681,    -0.097425240664916632,   0.04080965586790427,
       -0.098414082035318942,   0.0098582777436665176,   0.061163393934913525,    0.013543114993875779,
       0.22269962330762605,     -0.20393538524035551,    -0.13953262854398166,    0.021576743273910546,
       0.15388565114901417,     -0.020028296355322901,   0.17862126497340597,     -0.12961094569956941,
       -0.067001666688625089,   -0.017873501345754245,   0.024073891332960243,    0.18203181212006819,
       0.01262415861576632,     0.12594074537207578,     -0.085368246356315167,   0.1145259115373076,
       -0.011320416214504768,   -0.18266305957098633,    0.086037335187244532,    -0.091820741572707948,
       -0.085370587391548888,   -0.05366754309479773,    0.071987502723976499,    -0.050356554950324546,
       -0.062519324539689752,   -0.06058147199319458,    0.025423692133580998,    -0.024391021472683405,
       -0.22555944921303284,    -0.16729665316508041,    0.052557489548292452,    -0.13657166900526979,
       0.01599362142269611,     0.088911476644654305,    0.0097755857385868963,   -0.094762045249484464,
       0.056798712322195168,    0.035977391675466451,    0.0030301937528923999,   0.055714843021042147,
       -0.10858295556921518,    -0.021904533462048979,   -0.054018344489054702,   0.066486003340576805,
       -0.098928577470657947,   0.13110565116234232,     0.0096777463671412142,   0.099091311637398011,
       -0.14584929378903563,    -0.030259411830657838,   -0.0017840128790598904,  -0.023359232438846033,
       0.1510323367657361,      -0.09784488588148435,    0.12144717937608004,     -0.16986504660576826,
       0.066122428531271399,    0.041050371774173672,    0.0097646607454412847,   -0.1109064372307558,
       0.05672099998514455,     0.11850842447315436,     -0.038777120495299876,   0.039207741622991607,
       0.12318670204979033,     -0.01082444197422874,    -0.021758692904616805,   0.16533846127225768,
       -0.091146840153156328,   0.042662288097498349,    -0.14455098284913079,    0.018016468184879987,
       0.21444291904446372,     0.016742822732344925,    -0.03189332121374007,    -0.050195805526970796,
       0.0088124953902459034,   0.20288207677198994,     0.05577220227703783,     0.059191161867483438,
       0.016849361023769313,    -0.070522597002128817,   0.13766880186367422,     -0.1187981064312388,
       0.0061744368803885001,   0.0069544846350397451,   0.17249375343326945,     0.038265026753014436,
       0.034309419517793094,    0.056691895510086784,    -0.062260266157920914,   0.05495789223155996,
       -0.039239993419139141,   0.034066823484777485,    -0.066213952774422241,   0.12797945309582953,
       0.037283009545023379,    0.18326140150960732,     0.060173758000981944,    0.010665754566686206,
       0.093691854141089104,    -0.09620447818252216,    -0.0062800627257696079,  -0.022860507156407302,
       -0.011499116681473198,   0.00056882396771947051,  0.0075769476865636416,   0.071373125962195944,
       0.22973654192907844,     -0.20355727691699813,    -0.16053867169875291,    -0.2194549931789854,
       -0.095606171815476038,   0.080939597731531282,    0.081040628574429632,    0.041791982235955205,
       -0.11718891222294578,    -0.020546050335519928,   0.008649823758601875,    0.070339145664096075,
       -0.1929556435532056,     -0.18469247146386505,    -0.18444122439626895,    -0.076986883273694295,
       0.081894827031414513,    0.031375170003813888,    -0.025138862924549192,   -0.13973614584442159,
       0.057941126272419742,    -0.10224189618483127,    0.015874394579261646,    -0.18292788195304724,
       0.059964595300887338,    0.10147293326932048,     -0.046265694342206044,   -0.14801669058048159,
       -0.039784096689711397,   -0.16940858995387709,    -0.027021125141720934,   -0.001106604274868872,
       -0.044474937899568329,   -0.040188053986357844,   0.0240297347412202,      0.018144261005118092,
       -0.037998927019915446,   0.050263280837410211,    0.20379026149165491,     -0.12678895366385015,
       0.0046197832964564017,   0.018029654118006912,    -0.16327065794568205,    -0.13014192633143543,
       0.11606043276954854,     -0.076847410801949914,   -0.057947768680926409,   -0.25772716892928232,
       -0.0025720525379848477,  -0.061789420498166887,   -0.068611464292624477,   0.030728808055831662,
       -0.17672320730399876,    -0.0036790044476724968,  0.085419779789878608,    -0.05619792208537118,
       0.17904738358939709,     0.12072861668457446,     -0.036035065009215862,   -0.0866315764430554,
       0.076877550287279439,    0.016113901422582809,    0.11706695872018019,     -0.025649972182728197,
       0.10821920591348429,     -0.10817435731079601,    -0.021408857108401964,   0.017758589243255921,
       -0.21360342985283176,    0.18305634647980681,     -0.054289354321804345,   -0.090649688866438427,
       -0.014086522768137811,   0.0051087638461897907,   -0.063119965135491507,   -0.04119332316960915,
       -0.046899556276982786,   0.12581218702604041,     -0.13719096326698269,    -0.020436789567618952,
       -0.038993727257940827,   -0.1639934301064353,     0.082593331622404953,    0.055976006271803977,
       -0.1599922350214826,     0.015189251355194344,    -0.066151274110349129,   -0.10279656987518734,
       0.033696872321774166,    -0.0045191936690834305,  -0.044724294995148843,   0.19926334593191714,
       -0.045609325304528582,   -0.11057856015817757,    0.15191426435890795,     -0.06586281952235444,
       0.11019904345899798,     0.11323664871708304,     0.12992291192539893,     -2.9630184381412156e-05,
       -0.12897556725997572,    -0.052558735485203484,   0.10395303156068045,     0.079294355681641324,
       -0.030040870422861611,   0.18143215927608394,     -0.01931940052821501,    0.15999281823446715,
       0.1317702001398964,      0.089632221521092167,    0.0081765513031285264,   0.17668169419815094,
       -0.0054757349096544016,  -0.01164765348541838,    0.069063440386149061,    0.022522928450781517,
       0.19908108039411807,     0.06130657969294101,     0.069967015004863867,    -0.02867500594681973,
       0.049382044248029201,    0.12824539338618057,     -0.06943363547618378,    0.05994442296754194,
       -0.10537673789046979,    0.11383004963627386,     -0.054816364667205665,   -0.036367843169269408,
       -0.080048611371594608,   0.047609108819606505,    0.071457870835118023,    -0.18293250141413986,
       0.028502886142974696,    0.15611778985704758,     0.038219352576050358,    -0.010717945790043601,
       0.010934437460916376,    0.052184356118601991,    -0.012908555135053807,   0.11865204666976228,
       0.07191097390575571,     -0.14987723521614452,    0.0015273753861061255,   0.14561098188648702,
       -0.022053508760177764,   0.014498857018643696,    0.028755777208695425,    -0.03594978506486031,
       0.17883557277588635,     -0.19640364628360304,    0.035387823996564642,    -0.084176234824670987,
       0.20681046718579874,     -0.031351950506624045,   0.029966135328630534,    0.198216804797202,
       -0.030432317259379144,   0.0047726218248440953,   -0.093037264457782584,   0.10741344429119637,
       0.039617153740850473,    0.062366270218767096,    -0.27404029945022501,    -0.081235684657687823,
       -0.06929482311086059,    -0.22227607234168981,    -0.078588578711399459,   0.067185115395293468,
       -0.21662854858666053,    -0.11029141844800472,    -0.14568490393676836,    0.048756034065871666,
       0.076378775560633258,    -0.020617657088954251,   -0.17319774834385301,    0.14543439069034153,
       -0.058385695777417639,   0.050242598345922367,    -0.14971266360671587,    -0.025836357894956686,
       -0.12508160488949138,    -0.11376582158216285,    -0.077386156450621843,   0.26011373264367532,
       -0.063863290782130905,   -0.12046586759142355,    0.11762150346482619,     0.034359019208014867,
       0.04709994853090177,     -0.12767155982159656,    0.089545156241271906,    0.055458456986679741,
       -0.0082386340250449313,  -0.0013988308735428756,  0.048968196558366192,    -0.048558071556032423,
       0.064456123763876966,    0.10878320835947626,     -0.048141829685359232,   0.060677887407901795,
       0.059827478482016014,    0.12471639565827264,     -0.0083207301933799667,  -0.0088990238090671612,
       -0.12671228775568677,    0.01535761042814718,     0.032870905283419065,    0.012248076657036221,
       -0.069876677016465841,   0.012971983837266918,    -0.055575773838709021,   0.067729154806298847,
       -0.053163759113281694,   0.20327210866801121,     -0.067634564608254899,   -0.028002436629132099,
       -0.0035371007497519633,  -0.051907113410674138,   -0.04533781904898776,    -0.093377400040922126,
       0.060869375672389141,    0.054545817310181155,    -0.064480873674565939,   0.050022818880075121,
       0.1380908937759189,      0.014474486988477244,    -0.17133345743060407,    0.012054118321427302,
       0.074946224730606414,    -0.081863213169255086,   -0.13511916968872004,    0.043215935900201133,
       -0.13827771323414254,    -0.056781507267765582,   0.11978235658287924,     0.079287899979230927,
       0.067991358657067569,    0.011631715332768498,    0.021323342153877448,    0.12981835579542966,
       0.0028522663073888921,   -0.12907629276085497,    -0.015475258930322866,   0.10101325877513516,
       0.13426856954034458,     0.064991336585145124,    -0.068424751508080237,   -0.054233764902931081,
       -0.086153851561933267,   0.062982451424049443,    -0.0041615102917257115,  -0.02636169419045354,
       0.097224625455122185,    0.10219443449305106,     0.032777841045768211,    0.08714665921083796,
       -0.0097598498907301122,  0.16582497150796152,     -0.082164087219124354,   -0.065377974813886866,
       -0.060659246097084688,   -0.037387735004559636,   -0.094136079670032041,   0.081307685343808139,
       0.14393379603251288,     0.072681368298122037,    0.040047061674352166,    -0.30747259074617961,
       -0.072508916906365489,   -0.11864672320444514,    -0.16819990624968359,    0.01644943678704483,
       -0.14737749669266753,    0.070231943671940564,    -0.019313454177018147,   0.12094685348366821,
       -0.10472169130901197,    0.13859191371555379,     0.07592255059383185,     0.065262902568459041,
       0.06632275113268736,     0.047066476311557519,    -0.087259786878535625,   -0.060677314021758043,
       -0.11358414341729731,    -0.049791011489018197,   -0.046723781195933449,   0.089670560838825436,
       0.15467252727836206,     0.056848510476181772,    0.11900357793838713,     0.083154115345395838,
       -0.0109854266647866,     0.1456708559181695,      -0.044064561029120958,   0.035076203334712133,
       0.02154499904571211,     -0.089202504385399534,   -0.063610134474550384,   -0.0803189633234139,
       -0.072318787347034535,   -0.0089752545976890391,  0.012591131113809929,    0.07539710161269908,
       -0.11753729737606436,    -0.21021153438710716,    0.014294777906212997,    -0.10009050325186276,
       0.097516396694056276,    -0.03046670482518709,    -0.0070562482445108606,  -0.1303613745061506,
       -0.085214035677122227,   -0.049176837053935753,   0.12459841304461665,     -0.0073822829049576336,
       0.11607744823113751,     0.16560093110064283,     -0.03330438001691504,    0.02835691094099952,
       0.010185250293921847,    0.036832638283341823,    0.25646939771534977,     0.08066213152117381,
       -0.14580814955313243,    0.10070667027180916,     -0.16027711347282902,    0.068203712511899203,
       0.094195306863233144,    0.14298178968891898,     0.2196845983891578,      0.055401879399741276,
       0.029580505003210553,    -0.091556479809861049,   -0.17985742348693393,    0.027738149991873691,
       0.062449962466074829,    0.1249234470758778,      -0.035864684401630119,   0.23002914803236976,
       0.015769786621336802,    -0.12212686294813321,    -0.14733452767103677,    0.066149660732785928,
       0.10035905165753499,     0.048048813053716263,    0.034383555751390189,    0.043862773180096674,
       -0.048065976088910209,   0.070800002769239576,    0.16482542640486755,     -0.15407409726396132,
       -0.039957412828764076,   -0.07919782563843035,    -0.043752315388204691,   -0.018400374740375754,
       0.07679357228275932,     -0.0032564663505699927,  0.0086303723732801332,   -0.020001158051554987,
       0.064783588099850048,    -0.051064282008568357,   -0.0037051003036757016,  0.095537167875178658,
       0.10721770642944053,     0.011078263248751182,    -0.14166225386339873,    -0.045318790160284519,
       0.033205411273052481,    -0.19439418969291586,    0.071666140409893955,    -0.12748604443172354,
       0.048579219560932474,    0.038672526700514319,    0.02459432548363091,     -0.057587467133851683,
       0.18240871747822415,     0.056487804807532613,    -0.066897134319298196,   -0.021237550539607089,
       -0.1471822695118947,     0.085246567644945731,    -0.023604206057116269,   -0.020674500015994437,
       -0.035670009052299757,   -0.17625511162752305,    0.015926244802282583,    -0.10943420503467113,
       -0.19135573167877201,    0.069542162631173257,    -0.027512947332467803,   0.17545472611284726,
       -0.076617274558773665,   -0.0024256570355281715,  -0.084456137721984029,   0.049363306920266428,
       0.0089634652449881915,   0.11880664343842302,     0.11044183278988076,     0.038457530991527315,
       -0.12079030506351049,    -0.12133146399018305,    -0.071365258793908717,   -0.16010174987997508,
       0.11017351555996059,     0.068551025729617257,    -0.035582909939917751,   0.032058924488979179,
       0.095229211711668815,    -0.00084760786032865142, -0.22420953611472352,    -0.17273840061684659,
       0.1709903910262453,      -0.033897181874988039,   0.045919334830729276,    0.10114780122569959,
       -0.093481473976561952,   -0.072373431293466156,   0.17100986968534243,     0.028335697768728761,
       0.017469124119572133,    -0.029212420360916754,   -0.041176579816543074,   0.00814934727377036,
       0.12931041267960064,     -0.15981141311692265,    -0.24384460335022451,    -0.15023693678894703,
       0.051551501505252589,    -0.01416914571341563,    0.11800214488311231,     -0.058590428017977335,
       0.047269420282126294,    -0.051586221031213707,   0.12740362727001947,     -0.15476528279759302,
       0.085889196382521266,    -0.1518698801819503,     -0.13912795737241898,    -0.1441288689061066,
       0.18799378642056006,     -0.11230064716589036,    -0.025531868108382615,   -0.070030102944310418,
       -0.15587033991017571,    -0.0030857418093601218,  0.072319148367040273,    -0.077115333712755446,
       -0.097076435285456009,   -0.035946539380432734,   0.083349683887723375,    -0.024341388095477624,
       -0.0033235519390771313,  -0.023646476984489032,   0.24342741275208385,     -0.055554678352438394,
       -0.070674773766640206,   -0.092791147772372976,   -0.10874228725409238,    -0.040104108397816696,
       0.06104859660500616,     0.099085916429979423,    -0.15903908003522299,    0.10015743881566758,
       0.063118298062462108,    0.0807694208897725,      0.15203615322907341,     0.059365607891320782,
       6.9141555820143377e-05,  0.14206218243753466,     -0.057378960929671645,   -0.063645107458574643,
       0.083945310494898506,    0.060166181610094675,    0.089112323033312443,    0.048215495940657965,
       0.0237216910610277,      0.17893725564645815,     0.18757450762955183,     -0.12991436429582537,
       0.050561593362931111,    0.018103280488986954,    0.072385835937065102,    -0.0024717704689298115,
       -0.082998463828303115,   0.12098388737256278,     0.022968864773484522,    0.055399156146564203,
       -0.15810921651293569,    0.055468062855420087,    0.075568678156616192,    0.11658578081168473,
       0.033389055142891325,    0.085055258358112479,    -0.09399645268649702,    -0.033482624071444783,
       0.13621095279327727,     0.087069616182357784,    -0.087483440029259563,   -0.0358517195747656,
       0.036591828943014985,    0.13489514815945627,     0.028681452247205697,    -0.0068827358457588094,
       -0.14674467051949047,    0.10336644248519465,     -0.05252500820074113,    0.098323141908453454,
       -0.12968151968216285,    0.17157314999931703,     -0.055915893856812678,   -0.038059294246006486,
       -0.0095904078681117687,  0.055824648147680782,    -0.018735518310131972,   -0.058244093622191039,
       -0.13780705237204127,    0.13191764648885906,     0.23157793378626781,     0.21492628355243951,
       0.035851333783533453,    -0.16416610107786495,    0.054224669512187927,    -0.095054482443007765,
       -0.022764790876509289,   -0.041008163376479972,   -0.090529406732099096,   -0.039145295594133531,
       -0.11530911642663709,    -0.07397600080137158,    0.05263891891615579,     0.036034508848648276,
       -0.064759144820978928,   -0.065940715395959623,   0.10030550820408664,     -0.057190014175339435,
       -0.069106127145340271,   -0.16217129076578141,    -0.079389235780176981,   -0.036535456750648981,
       -0.11761242399441985,    -0.073919778419676105,   -0.045813491046417215,   -0.092282235896205461,
       0.010736701817512968,    -0.088634567987534191,   -0.18923588103266809,    0.0033686979708907206,
       0.067548181988780584,    0.081172698046680924,    0.11178543167951793,     0.023427550538164789,
       -0.046638725034982884,   -0.026951530413237793,   0.2074679624962576,      0.073339970369108234,
       -0.042614124411140104,   0.04356004831692227,     -0.040472998603702182,   0.01049639121672304,
       -0.0084217631682816495,  -0.087095354927465285,   -0.0046726208331399222,  0.026023220857164353,
       0.093190919460586774,    0.012947064948272715,    0.17311762260257374,     0.089605897905556078,
       0.23719091196879538,     0.12544771763892656,     0.099920259739984849,    -0.14544202139210499,
       -0.23158348703651677,    0.030918762000699547,    -0.18434302659892049,    -0.12725135628670287,
       -0.10904083966826554,    0.024422165318755636,    -0.12739995955002542,    0.019245451747627179,
       -0.1746522626147895,     0.018708318159010133,    -0.21348097956171511,    0.14941849445373279,
       0.054049553928301575,    0.058942007192835072,    0.039758450495135669,    0.080543656424900814,
       -0.021648396744546043,   -0.11074044174275062,    0.013164490641477403,    -0.050950603649277892,
       -0.25077593538707577,    -0.0095704959283496108,  -0.046503754063539945,   -0.088177002960684689,
       0.042865353271074741,    -0.15170391012683157,    0.0032562962262281409,   0.074806358948359589,
       -0.025405191637168176,   -0.025245478346065411,   -0.032384599047520696,   0.056365553494263032,
       0.038510637869952215,    0.0092137826781692501,   -0.048944246221419137,   0.036128501698771832,
       -0.098658684071830274,   -0.08697063900761029,    -0.21992708040090758,    -0.024085725505866108,
       -0.045967527192559594,   0.040903959426241615,    0.010770071033442845,    0.037772324170189012,
       0.14126968555176381,     0.03247995340282115,     -0.018179517258107143,   -0.18552833434658911,
       -0.17518373828385433,    -0.17452855856394003,    -0.062914759972723486,   -0.0075668014532005012,
       0.080287988857879342,    -0.018867734645916234,   -0.052829007954603262,   -0.11351419612009295,
       0.043177982837766929,    0.14615478680550245,     -0.033306538385498984,   0.10173006417496704,
       0.17822394277802164,     0.23865426117802385,     -0.043772797130792171,   0.091336185590280866,
       0.033416373857572616,    0.039393789459936497,    0.022062510023282966,    -0.11369357785743174,
       -0.015792230643119888,   0.1374967632663279,      -0.04167140338716574,    0.0040393932200383648,
       0.05971097084167902,     0.25487187592405564,     -0.061405659464211192,   -0.10526299667493928,
       -0.01860828166601565,    -0.019477336629429187,   0.075985939282116388,    0.015033775558130826,
       -0.192898272249275,      0.082594453180287519,    -0.072455199803261358,   -0.027626593931841182,
       0.092206040387606325,    0.11406909580955576,     -0.11514720108594804,    -0.037989431050549902,
       -0.082532533602905356,   -0.17732848274267241,    -0.021537810133596114,   -0.0094367063654174962,
       0.012891406725423986,    -0.055308193301224044,   0.10726594061246242,     0.050066159258248817,
       0.12047655127423637,     0.086819338448168665,    0.02149698249221552,     0.075353452187672573,
       0.049166008743364728,    -0.13376388481967791,    -0.13110874058413016,    0.061198000803079272,
       0.056924187534318223,    0.031183974336697191,    -0.07488401144984673,    0.073449667449356382,
       -0.048964596434475233,   0.056450396372673517,    -0.12432072095897011,    0.015004601486986936,
       -0.17151625247486629,    0.034744023342009295,    -0.12854817446235542,    0.0047661211747736659,
       -0.056759735075482945,   0.24700110836720421,     -0.082588775573202558,   -0.041452640237691865,
       0.13031176186019375,     0.021662330703408828,    -0.085334735273576184,   0.035886975049682648,
       0.091770919290652564,    -0.093655626325451061,   -0.24879303246920303,    0.14483144189733355,
       0.21518863919063538,     0.099076822785755442,    -0.020416288964942252,   0.020340603029139436,
       -0.029449364723889853,   -0.00029265874705561301, 0.030135713003057923,    -0.11668807815265157,
       -0.028244289734345174,   -0.20962888559530843,    -0.032535502310429412,   0.12735680583702547,
       0.12485149204529336,     0.10653645127493622,     0.024119952135898216,    0.090135625908031564,
       -0.086488331510619826,   -0.013752329684284302,   0.23528432617258679,     -0.064074433208778689,
       0.024922737183611838,    0.065238517910107471,    0.07226683523134507,     0.11760397496475503,
       -0.0080259951289207206,  -0.073501605158068348,   -0.073801967560824841,   0.04710789531359412,
       -0.049795216996779988,   0.0024389610677097162,   0.051977678840574582,    0.016804983684681078,
       0.10313138715387821,     -0.022492351981405728,   0.019346009207502051,    0.045934199922839904,
       0.069333441576491087,    -0.018156833317692203,   0.089196107325599211,    0.0035097256124264273,
       0.019756401055020904,    -0.066126664192100448,   0.11976787075914326,     -0.044386867528083233,
       -0.10311184024035255,    0.24972371549328512,     0.0011833774151191762,   0.07268052219923711,
       0.042713735374947812,    0.0086232551811434906,   0.057684788089507152,    0.12532519395322297,
       0.099505366327030401,    -0.06383664873875064,    -0.030078329733358462,   -0.092710386466358402,
       0.068605915902709202,    0.011413596280836057,    0.082806472546002083,    -0.14704405245955296,
       -0.12289223465759914,    0.072702137995237642,    0.037006624959007056,    -0.12668584255700502,
       0.062539236045507124,    -0.018974783671903361,   -0.07403435917749436,    -0.015801699313795301,
       -0.14823888836091506,    0.0048962807429685862,   -0.012821755928580923,   0.14558258416697237,
       -0.14212934880691225,    0.023772814138894746,    -0.13623764607213251,    -0.14261510820149595,
       0.21390250595209873,     -0.13421369508058356,    0.096251799681229128,    -0.044756071052402424,
       -0.10912011337870992,    0.027023332094280088,    0.033284461398959998,    -0.047615633266590629,
       0.10636007800551668,     0.017554610717245889,    0.059862101685917067,    0.079198723366673246,
       0.21213569073197919,     0.21910056252707635,     0.021906539174749041,    0.053273352950987257,
       0.021910163959488645,    -0.17935338042421164,    0.0074418460933911778,   -0.17922385258745316,
       -0.066297055786692968,   -0.051107991976981564,   -0.052547806839755663,   -0.072420290288279454,
       -0.13149998725255896,    0.079080331425901665,    -0.043524695674085061,   -0.093029167729338488,
       -0.0016736883799683187,  0.063523585707516692,    0.00058725124268411543,  -0.026489366021748829,
       -0.29003163062606618,    0.094285749366708083,    -0.10020351894121916,    0.042835206122110239,
       0.053541799843261732,    0.12369140109536869,     0.082209294415067038,    -0.20512704695937659,
       0.19439910749443298,     0.094329489137343236,    0.01855891047917874,     0.064514309115436486,
       0.034513715761353814,    0.047027579538076285,    0.037208718799640682,    -0.054637401375953146,
       0.10967944071899607,     -0.09173546906232001,    -0.020904648890098416,   -0.17072707580631827,
       -0.0067789897490823257,  0.17059276041399701,     0.068260412409570592,    -0.056075464435749491,
       0.12948095832107795,     -0.011998366950843404,   0.033660480576411037,    -0.11519184579788105,
       0.14164323087275771,     0.030538119312004341,    -0.085227159425117854,   0.14638286376180321,
       0.058841210070853911,    -0.050093029325177389,   -0.069462286731808154,   0.072448289215920711,
       -0.13909625715117191,    -0.080967460408501529,   -0.1878006563239917,     0.024509988454515116,
       0.035193347706444736,    -0.07478231867954907,    0.01843176472342677,     0.1049605750904308,
       -0.17175075109905785,    -0.010644167607196772,   -0.0021476352021687281,  -0.0889136692098174,
       0.025608193613109797,    -0.035316676624741153,   0.087559876088571381,    0.11842191699390801,
       0.29100502302471304,     0.24083966886336267,     -0.028961459584978599,   0.11884590497068359,
       0.01233259107070394,     0.19506833723640046,     -0.13410982383255582,    0.079711223263003839,
       0.022424894956546169,    0.080087077855321431,    0.077271902163865397,    -0.009350494850128073,
       -0.011668226108990664,   0.03081824248227959,     0.061453726834987475,    -0.020256912131347782,
       0.024714672727402479,    -0.037819165197468932,   -0.0055675456431995875,  0.097434999510609438,
       0.058449565669529059,    0.12524965663515325,     -0.12080990557625064,    0.082713167844347069,
       0.1192441828971802,      -0.051257054943985192,   -0.078992547706299668,   -0.072371418669082352,
       0.19708409289221412,     0.037419177884065388,    0.094513070684436803,    0.19551510457617416,
       -0.045923889194152467,   -0.19155904240385921,    0.050126149674847013,    -0.081016870254482412,
       0.15297527880789788,     -0.03149262490404698,    -0.14229516299183093,    -0.07316978906693998,
       0.15227511391542639,     -0.088888532643955992,   -0.074939342842443718,   -0.00077570311882380841,
       -0.1325871703550584,     -0.12455528912369331,    0.054675267266308669,    0.010350000168601776,
       -0.039240906458794703,   -0.17265704119729647,    -0.10960222248220904,    -0.054378104889538995,
       -0.018450668631622043,   0.038179831829103519,    0.14319999680195963,     0.093416889602639719,
       -0.029793480267150799,   -0.0095377610975363597,  -0.083889494093064135,   0.019938923442056167,
       0.011077341688219196,    0.13328699100313654,     0.019075199286221499,    0.13185188472599385,
       -0.011109662661349372,   0.11055620913012179,     0.10743829430420893,     0.095042191387224945,
       -0.084359286311428805,   -0.072213270378527677,   0.0095153150492823056,   -0.13450328257458974,
       0.052535993195695276,    -0.12283007342423437,    0.28427482560827128,     -0.023877143958415052,
       -0.046627797194864241,   -0.18415059408371681,    -0.10627297433183286,    0.10189559869935309,
       0.019166094233183436,    0.078315070634549469,    -0.1248569938090873,     -0.037314072526482486,
       -0.071523214775289237,   0.13514296461247333,     -0.093853235649148326,   -0.030111274722079508,
       0.027591905073458791,    0.071832365021372316,    0.0060386373382885598,   -0.011406581922351377,
       0.055026707696045979,    -0.0081167565301741712,  0.053234795179541196,    -0.061350567810432258,
       0.21940716873341792,     0.093707207502739143,    0.0012845155236015757,   0.055817437698697445,
       -0.15317552043984375,    -0.11986972918668878,    -0.024616570391883346,   -0.049249340998357025,
       -0.040669333295862489,   -0.068073124733548415,   0.010093586743866317,    0.06258942872231682,
       -0.021893319691349198,   0.012651543041670051,    -0.26781214178135099,    0.0089491734212574347,
       0.03637717838249719,     0.043083095447021186,    0.14085187686879494,     0.087672715965795886,
       0.041980421467299106,    0.051254609674284905,    -0.050088319029307986,   0.18097164031101703,
       0.10249626619882277,     0.042191372656724388,    0.020175753097876583,    0.087631255659034735,
       -0.084544370987223755,   -0.13875058345727875,    0.036690534808183926,    -0.028215105568482546,
       -0.021463684096314078,   -0.048752031033228602,   -0.17407737514053342,    -0.068168381142963613,
       0.050966584623920175,    -0.12430566763546244,    0.068213453307149882,    -0.32107405044122006,
       -0.11916411894164725,    -0.073709687958841613,   0.13721624552285933,     0.062947744620786839,
       0.18296035795746823,     -0.093628256870844542,   0.089785602850620691,    -0.23898534660439763,
       0.034311293373202947,    -0.19350384909075147,    -0.13086746209869687,    0.0040500161458888037,
       0.040173062096094996,    0.014761006422455786,    0.0042417032854844576,   -0.04784929813639946,
       0.053889155150982262,    -0.058056820738396166,   0.10028215391023364,     0.020781563171567492,
       -0.014768447859817315,   -0.023064704931400032,   0.028296416499938845,    0.1989002137333753,
       -0.078700593881753586,   -0.007029264673820714,   -0.12065280712094896,    -0.015545330342567016,
       -0.029825828226802218,   0.0069381063979829707,   0.024004820830042874,    -0.043277884748973282,
       0.056348091987290558,    -0.061788261950863441,   -0.070099496695467584,   0.014186472808429601,
       0.14315684211651319,     -0.034018044026694422,   -0.0090843746810487201,  -0.095091244505537312,
       0.091625671646253543,    0.0062610375892544548,   0.087822389170019735,    0.0019551134834494086,
       -0.043143340777763932,   0.1223783290004094,      -0.11591505944719588,    -0.046952417497621718,
       0.035935998478142578,    0.016340310124172544,    -0.15519183952562776,    -0.12040559889346844,
       -0.033772454539822867,   0.21764400408526136,     -0.11721012877637858,    0.073296280518653723,
       0.035985357963674663,    0.26881929802340471,     -0.025655789932773836,   0.0057929303980644477,
       -0.098750441968043723,   -0.28931171786549781,    0.10855715625588616,     0.043216366069314671,
       -0.053072890263776325,   0.029618022879281176,    -0.043850284923425395,   -0.17227198343822808,
       -0.13925543539586591,    0.0099839010209047847,   0.063311627385905941,    -0.16867215118020024,
       -0.067041989289594872,   0.069136685127604139,    -0.07690354053671758,    -0.23373735343876967,
       0.13192407676850423,     -0.053169918222675694,   0.093450839615143666,    0.060009008681027917,
       0.033094956560590104,    -0.16512200341510519,    -0.069080035376586107,   -0.055899784562118943,
       -0.1990336364476219,     0.067434813504448965,    -0.17849322396901271,    0.02203714911448339,
       0.021124620516432067,    -0.14913590126711226,    -0.0080579509635160616,  -0.1529184565392567,
       0.045746800802952084,    -0.073229444524434362,   -0.078338364016182202,   0.078908106999910244,
       0.028644757791195925,    -0.095090526445281889,   -0.02073981071023337,    0.039624067023510852,
       -0.0057219627088608196,  0.08263730272369231,     -0.085837370655398759,   0.15613639655708478,
       -0.048836345943946688,   -0.03346087285369817,    0.008663631325159557,    0.0080736429610755028,
       -0.10175478982516975,    0.10554532050669141,     0.11606575577320589,     -0.091263578867066028,
       -0.0090156299543311981,  0.060218966614346378,    -0.035719028388629122,   -0.029475891081235901,
       0.029070597002125213,    0.014281035333615797,    -0.10509096895228101,    -0.14328642815334774,
       0.020839672156659571,    0.20203560596457376,     -0.068700400125312311,   0.056396243345018839,
       -0.037625909264976859,   -0.15093928051381919,    -0.0046421648884092757,  0.00054706405989387273,
       -0.12398271718676072,    -0.071178436068250153,   -0.02843857555942577,    0.069826037192695728,
       0.089257125574332796,    -0.0025617942217208943,  0.085157871100723398,    0.1118860064037786,
       -0.28166976059438797,    -0.001838644381792702,   0.039281533094222602,    0.011630874393739186,
       -0.027510233396284601,   0.024429649363434985,    -0.072288657055914654,   -0.0044564031130968906,
       0.1016580016677633,      0.15502342855635837,     -0.088088431382655416,   -0.043260265058817166,
       0.052465040405462751,    -0.028392375528049157,   0.029116965940182031,    0.045566646563770512,
       0.036646967312218628,    0.0082362407209802032,   0.18032463491043124,     -0.040426551794697868,
       0.026007321966423406,    0.083296999423850382,    -0.0074025907369034537,  0.21878782301369912,
       -0.0088659179624723874,  -0.11387729199028254,    0.080929207280416665,    -0.012844602215271953,
       -0.1214650445160354,     -0.050264640850367352,   0.067382476134795949,    -0.098530759616884664,
       -0.1219482093527246,     -0.079100822740625049,   -0.03147932561132586,    -0.034325328094958085,
       -0.0043479039480442024,  -0.11376951150496997,    0.07398889917507806,     0.024331709947271969,
       0.049479017432313172,    -0.067447918486514713,   -0.088521774411981863,   0.087863989713118734,
       -0.032437657367152081,   0.18396863500897487,     -0.0055208250449216194,  0.00029784388068827133,
       0.21605990562657695,     0.03721642299118072,     0.044740286995814726,    0.024113486129597354,
       -0.020797304270438861,   0.12545540515588011,     -0.035341013334291356,   -0.23672578908082953,
       0.036256086572671049,    0.0040895477279759875,   -0.066214105353407909,   0.090726594528180937,
       -0.049552674025757464,   -0.11288753529583094,    -0.17616842516371242,    -0.092825201943112459,
       0.032837153575820205,    0.027642317014290891,    -0.15585065556211797,    -0.16876954133892919,
       -0.021837891838676765,   -0.063651782503762813,   -0.26239717087193287,    0.047433566982427282,
       -0.10854908745047331,    0.073962617761987565,    -0.18181705181177638,    -0.20348264550745118,
       -0.10632389863261753,    0.08515946947164782,     -0.2245862351315206,     0.05616821809979123,
       -0.13323264749127181,    -0.0060230149454162801,  -0.072512528717137439,   0.097088920154304953,
       0.054002299533686141,    -0.048335435489503066,   0.029995307402521251,    0.053990582571893056,
       0.013734361828264624,    0.024118729010604106,    -0.084340672379660572,   0.044676889613319157,
       -0.1138680402115818,     -0.095825192334324044,   0.19007774942731034,     -0.045202561152994689,
       0.035143200956803775,    0.041684271995746681,    0.02623345569844223,     -0.13146619290084732,
       -0.026231811046393959,   0.082059204946306211,    0.0077195428670775775,   0.074970959840960971,
       -0.0025745200508337125,  0.038762043958390308,    0.16521847950881824,     -0.095988139146058638,
       -0.16473399559571897,    0.0039713806805960995,   0.045395105557305811,    -0.11706421376015198,
       -0.17231654655703899,    -0.022021899519972347,   0.090958081627988754,    -0.11499317399875877,
       0.10453272211066887,     -0.058702144534707901,   0.15177525888883106,     -0.091782759214643503,
       0.13141569455051577,     0.093213309675167874,    0.015832910268491863,    -0.0068966987996494436,
       0.02345003974145873,     -0.12581094539401197,    -0.0074155675204109388,  0.079420758834129357,
       0.095947748749577552,    0.0039503134020381914,   -0.067675694044275772,   -0.13030220317315377,
       0.094400681585201193,    -0.024962451900401778,   -0.0048243590407542726,  -0.00037693393423881161,
       0.13843009995019967,     -0.045809482572989765,   -0.10794663028524271,    0.010063358547616976,
       0.11003161568587241,     0.038834222720119924,    -0.16756626064581698,    -0.10681287368327227,
       -0.070974574545737357,   -0.084935346100752637,   0.006306796704938545,    -0.1050063252773981,
       0.18061895478896642,     0.039036398255653477,    0.02107752525027233,     -0.063288113136222332,
       0.24199745258970543,     -0.06996938419081368,    -0.03023308454858668,    0.024478072379418514,
       -0.0049248675444740625,  -0.0066061142518545734,  -0.21024921618326842,    0.080846388254496401,
       0.012339315695835365,    0.091971670597325902,    -0.039243154569810791,   -0.13693824138996874,
       -0.0239144815974607,     -0.0039464766760277199,  -0.028126491600536159,   0.0098760422552233874,
       -0.070871163381563518,   0.019782565344871401,    0.083558404360706579,    0.11186224059753062,
       0.0021276326448329786,   -0.18021699494426319,    0.14133982663179701,     0.12977565428969334,
       0.13512133937097759,     -0.063469812036748965,   -0.14614860477697034,    -0.095122932594563864,
       -0.033261448913975075,   -0.11458998242864278,    -0.018865938423805458,   -0.13168247085917817,
       -0.13016466292192469,    0.025869658575429232,    0.15373725913691122,     0.015617417003696933,
       -0.014388217521615627,   0.09765460715632511,     -0.009640639163041238,   0.27972253083374327,
       -0.086139550912126966,   0.11818850706009326,     0.031943281275221669,    -0.2895460467947491,
       -0.041137038088275762,   -0.054174359688638374,   0.050467621456197653,    0.055629194699286788,
       0.048267751643534668,    0.11032583270133289,     0.020650509206766733,    0.040985837159690994,
       0.027744169858785479,    0.060511536973498474,    0.24843805535902752,     -0.029971271565703145,
       -0.11107638667591016,    -0.15905335709851851,    -0.080130463818803635,   -0.061837450429901561,
       -0.034524578612893563,   -0.0088275965187993126,  0.0047165222542236663,   0.12786569171870493,
       0.02062853304806608,     0.087125978323828457,    0.13573766248769586,     0.32825175751442898,
       0.048847802432853756,    -0.15562660144377372,    0.15298875916940829,     -0.065078325101739748,
       -0.064010525195501766,   -0.029707379950499529,   -0.023258727706544077,   0.26211193711599212,
       0.11314630259847423,     -0.019942585177774367,   0.022546494124310625,    0.11540868183642616,
       -0.1242381430627261,     -0.13053881175711723,    -0.058538281896005663,   -0.04755261720766097,
       -0.048133102080837153,   -0.11201997457522432,    0.0020872755584917481,   -0.034894372541163406,
       -0.20001916727942301,    -0.014862430976206743,   0.042923847875315856,    0.019844628218894624,
       0.097042326087905695,    0.029606484821836865,    -0.11552911636802422,    -0.065316359351060477,
       0.029069361816032896,    0.030239921082993025,    0.044360931647658107,    -0.099963161732659428,
       -0.19500422639309895,    -0.033890101542787834,   0.032600449315412131,    0.058435620318548605,
       -0.0027229640021855257,  0.1351558779497373,      0.0050494224273281473,   -0.074506490414460252,
       -0.06431887342923194,    -0.018688904969043338,   -0.080259371589142287,   -0.049918210138453156,
       0.12543229271732512,     -0.071686132419264706,   0.028654628370682948,    0.028910371611603283,
       0.065529764503764132,    0.060423105941164387,    -0.0077286786309847654,  -0.01902363228367324,
       -0.061502266360055097,   0.037614868036295893,    -0.14572241238801603,    -0.066223587207080076,
       0.13787676236265486,     -0.016253468394071425,   -0.047233832756829304,   -0.031438462529526368,
       -0.04270735904604115,    -0.22449290887184198,    -0.17196719735196608,    -0.034153469531533046,
       0.077496206227704603,    0.097188885891714538,    -0.057002070423051769,   0.033337567943641837,
       0.083903174094926633,    0.11923829123459988,     -0.047495382694035422,   -0.048865853317595638,
       -0.10866210782063443,    -0.15733325945165128,    0.044909853082868482,    0.027706252302474085,
       -0.162773098110156,      -0.12800377391173726,    -0.061507581070911282,   0.20730449278681545,
       -0.068689357327452835,   0.049507818053322702,    -0.054720411042438258,   -0.12519649674551123,
       -0.17511410170231476,    0.087169506596633833,    0.073520580907223382,    -0.20345466428911793,
       -0.057775200898030107,   -0.047734667808615835,   -0.13687399619661747,    -0.088321708226077003,
       0.029174348915482734,    0.12416338786838477,     0.015315445674660238,    -0.013827852128997068,
       -0.22627271109170993,    -0.056901666644522043,   0.12039149630266138,     0.010581446551547503,
       -0.028487989395760353,   0.086384542761652625,    0.015832151420572382,    -0.10853391080733604,
       -0.13787827625191243,    -0.032093415735316322,   0.13926773756705427,     -0.17053664225050302,
       0.053870252874831839,    -0.15136906623269591,    -0.033583329407619412,   0.049446595599172659,
       0.0035012289271793427,   -0.085319350570753863,   -0.15422888114809322,    0.1412861443327062,
       0.036375120109147743,    -0.14393284423656025,    0.084639267667995871,    0.037137053249066618,
       0.027505243375363427,    0.043995635125404595,    -0.023082762976606781,   -0.0051105377397008137,
       0.055408515985651038,    0.0089277987839266118,   0.11409441006260478,     0.21682403081353852,
       -0.16873536451169008,    -0.15222534465541399,    -0.081443157674260719,   -0.090919058227372423,
       0.14472792978923765,     -0.21346302147628821,    0.13159748444128871,     0.043352724393184272,
       0.1037307239020232,      -0.043913636679037513,   0.034093668474725183,    -0.098797149244347016,
       -0.038023956062225694,   0.052007300815845828,    0.094486379240672921,    0.042134994567946865,
       -0.018895281322089633,   0.059134512903333512,    -0.15046398949421869,    -0.016763867872126945,
       0.12835426005918832,     -0.014020381320519441,   -0.017380336774491585,   -0.073960091689467919,
       -0.15929371252366081,    0.029173085901159815,    -0.23304578514946772,    0.022691374865885357,
       -0.042404592700091767,   0.019520215645088178,    0.05149306201644966,     -0.12905296111141923,
       -0.13914347818238157,    -0.020199082855173044,   0.028533601109711995,    -0.049358275570763985,
       0.071565254968283046,    -0.075464407519040072,   0.060408234987040552,    0.065986270934096564,
       -0.083749948688111836,   -0.074540835129176836,   -0.045409971233574369,   0.03029029467116804,
       -0.14357942023779235,    0.24145749430735772,     -0.1207726307745591,     0.036132577714156178,
       -0.0085831822067065459,  -0.075607214498500427,   -0.033124965272963242,   -0.058219581493195387,
       0.022035990180229146,    0.054395922018929482,    -0.065094971297426168,   0.03043491335784821,
       0.02916237132513962,     -0.11687347945134875,    -0.082272340656801446,   -0.10332330704393014,
       0.11435232411848159,     -0.20455752403562638,    0.019960331025377726,    0.099146819260836058,
       -0.058366983372571998,   0.1162289676489459,      0.18992937515809249,     0.19148112261461281,
       -0.001887125397546212,   -0.13499522252264642,    -0.10060951526755077,    -0.050720804940867774,
       0.10522062082618557,     0.055385923954949415,    -0.075166609729602346,   -0.068475223589208295,
       0.040856613583308977,    -0.039726023853912155,   -0.049333728754420013,   0.1194179325706112,
       -0.17681175993687351,    -0.053674045652889343,   0.12530359172110944,     -0.10300349469689753,
       0.0082677000561544433,   -0.034347612905442519,   0.015790569040140152,    0.17496817433089273,
       0.061449439081339763,    0.073034900432925806,    0.056690900497328764,    0.065185779574182492,
       -0.065958105659053592,   -0.057933964961047905,   0.016951686659112682,    -0.038515064044787585,
       -0.1060629360262897,     0.042464312460686465,    -0.083728567732083786,   -0.0096433598100009454,
       -0.071418489875467062,   0.027014603685107923,    -0.096263692481087404,   -0.020330354320804937,
       0.040725579690230371,    0.05028468419502731,     -0.20512682544303337,    -0.020838002288880358,
       0.0068077662764182492,   -0.15195155595224938,    0.090604159600151182,    0.11977222448017819,
       0.098553225090057275,    -0.082654995647260573,   0.16497041732908466,     0.16457799029221445,
       0.065117133525720988,    -0.089848378159385164,   0.037385337195277937,    -0.11930812199534391,
       0.020832344835183279,    -0.18186498847302124,    -0.035550483540708944,   -0.15833957526262826,
       -0.1847489595095051,     0.012026848675888348,    0.030333752546542025,    0.1948580997334235,
       0.12549712435137306,     -0.023027936673750533,   -0.0094480558200876925,  -0.10202540219011874,
       -0.01786973214599142,    -0.083351212511769093,   -0.029564260932431901,   -0.048531872308631166,
       0.134449267864411,       0.1193889513576271,      0.11143523803067877,     0.026244329699949387,
       -0.046481272106631083,   0.00064173161872667622,  -0.062555122748333247,   0.16296551528948106,
       -0.21619035520270402,    -0.26853300127825103,    -0.036541051695602796,   0.054059756066572651,
       0.073926970066160266,    0.073379745815976727,    -0.021556801551222148,   0.032507596688733514,
       0.10296760369543531,     -0.096544109615177565,   -0.077239133092021905,   0.0019194005045783174,
       -0.016975336788765213,   0.098089087267344249,    0.059050800435100088,    0.029824231319711882,
       0.14546624414684031,     0.11115788063998501,     -0.14319861576712123,    0.018244441234663324,
       0.023189125407804136,    -0.024147421919168636,   -0.14983069119222092,    0.054242669037812566,
       0.095142388387497917,    0.030220454830876056,    -0.030721601919365203,   -0.037243911998719535,
       -0.003155225934198765,   -0.15212614055438214,    -0.046452638737286778,   0.071042847743597759,
       -0.046656310591712102,   0.14621640116736317,     -0.030759771301539132,   0.033482376043924851,
       -0.075949868105392088,   -0.073619437326174389,   0.072644747629648981,    -0.051361987834150462,
       -0.019375757354343257,   0.080719374593910223,    -0.14519069629951692,    -0.11898517225365596,
       -0.10931833912672127,    -0.010854949778346329,   0.050319217640840339,    -0.053065829102390993,
       0.086401463584905261,    0.015063768951754531,    0.090948865543038451,    0.16383570273479239,
       -0.12977500636885417,    -0.10305285781723504,    -0.0037103618422848206,  0.14523372227485504,
       -0.075944908677223019,   0.0036650824866669368,   0.18654252711956004,     -0.052893229415524913,
       0.22281345057926566,     0.2106201417772659,      -0.17696279482188579,    0.11596369086449705,
       -0.15626244818743323,    0.20679847212098199,     0.10816110275214651,     -0.021893890770015512,
       0.050570801256412667,    -0.045024831013546748,   0.11700605939497216,     -0.14686568454209242,
       -0.042823585915383329,   -0.034963665876371293,   -0.091875723364569187,   -0.08641122177900501,
       0.083215374445950355,    0.023969733752049388,    0.056893350876106898,    0.26748474224189528,
       -0.018466218423131835,   -0.022523183391822008,   -0.0099004937618936834,  0.1201118621180538,
       0.022091557641117338,    0.044406558796025578,    -0.19101416209023067,    -0.038210646534450089,
       -0.11304373577467677,    0.046967340543055805,    -0.094737138707310042,   -0.061173300693177453,
       0.0057244590816690061,   -0.034452853244808665,   -0.016892693566433491,   0.021791461717615951,
       -0.15216359507283048,    -0.093457016828650999,   -0.10384799044818592,    0.022215571759860709,
       -0.081962405955533377,   -0.030203538531725915,   -0.24994724324997902,    -0.048670160576398586,
       -0.050384376709455503,   -0.033866499322087039,   -0.10910024104495633,    0.14616331569873328,
       -0.012983257281870686,   -0.080600457775603901,   -0.060774091652780235,   0.1703712561347375,
       -0.028243109985909835,   0.063674784816176694,    0.044756208944965084,    0.20831409757059363,
       0.030466362178273552,    0.047565828293204028,    -0.11925416693716635,    0.02203418520075736,
       -0.026556822584948805,   0.20605531088763229,     0.11748639277783897,     0.073355890590346293,
       -0.18132878979015152,    0.02811753899606103,     0.011778316407605509,    0.048589114624541956,
       -0.1943980048529598,     -0.054361747619336251,   0.077084099528905839,    0.0080476386292457937,
       0.20765047824260743,     -0.07383449664827009,    -0.22194051260296782,    -0.072276030943143679,
       -0.098652409747228553,   -0.0083867364447566019,  0.1152242291950883,      0.031779465442788264,
       -0.070622349823751832,   0.016504197602935512,    0.1606017705746946,      -0.05837610934642027,
       0.13032206265898452,     0.031698313053633353,    0.020741765286225726,    0.14328148565532053,
       0.014789226154974095,    -0.12310424778479047,    0.1090563728680809,      -0.028706030374912532,
       -0.17827086301694473,    -0.1480110947283001,     -0.082463783673013394,   -0.10421496007245645,
       -0.058541362433588116,   -0.056975538889454419,   0.0063009079147848257,   0.10277055111205091,
       0.05668764360482928,     -0.1064215934255518,     0.17585390862571931,     0.13977200657397945,
       0.093781934636970266,    -0.15682712636310792,    -0.038890962098329852,   -0.10710293031720328,
       0.075546157670266914,    0.048319063465704117,    -0.094816447798675069,   -0.093489009967964831,
       0.15621405859193188,     0.13910215451722646,     0.030740947855488809,    0.00024986423230735112,
       -0.088145442626289719,   0.011720765227064726,    -0.010744683824650101,   0.12273535581313931,
       -0.119534298373575,      -0.040239007787403566,   0.084077955241468452,    0.0422335401628849,
       -0.020524313404618813,   -0.049455054214460045,   -0.10548195282411962,    -0.13011696427906605,
       -0.1949503513630268,     0.079860856941391528,    -0.048666313021468316,   0.00558955224905122,
       0.001099112729853767,    0.03514100493607205,     -0.12240669798697773,    0.10039645808331779,
       0.082076885660662929,    -0.042546586179840196,   0.00087325093383592591,  -0.026825216699620826,
       0.0044150011186239735,   -0.040948901229943886,   -0.010363831370627222,   -0.0078521758376975496,
       -0.18303684049731131,    -0.096316285828751125,   -0.034186701197820815,   -0.20286927087774598,
       0.075622548076047305,    0.054625268814028724,    -0.16464216219281361,    -0.040713778671439049,
       0.032724547267896933,    -0.068563610189708996,   -0.099509503251681689,   -0.056400935555639638,
       -0.036493556463045092,   0.18749933697755017,     -0.02095621289422292,    -0.15904067284167292,
       -0.046312015022065299,   0.077466402765153972,    0.26235794576976296,     0.13533067620330871,
       0.03633020702846744,     -0.064671292436458472,   -0.087750886698561611,   0.010401354594779075,
       0.16979665146253348,     0.075611159188036361,    0.052638364757170195,    0.056816933399695436,
       0.2412163104364079,      -0.068472996659995913,   -0.0032554375955377553,  -0.076338570951275567,
       0.041378280528518191,    -0.039459281419565014,   0.00077591357204171915,  0.23196721796443953,
       0.031239677739418197,    0.16214929982487669,     -0.061894614837122809,   -0.0097056058896994365,
       -0.089129171978886951,   -0.055080628795794978,   0.11777670601050048,     -0.078214899280754036,
       -0.10034787553261244,    -0.051609928444059587,   0.12419677228643584,     0.040415920907783134,
       0.17564151908052283,     0.18535215156114035,     -0.010895875169971833,   -0.084829850887074953,
       -0.012622238311983756,   -0.18053151680133497,    0.046501515014776076,    0.02877116982530405,
       0.041430154311725892,    0.070016595078909297,    0.080992257501366557,    -0.057720972467506973,
       -0.022252119876620825,   -0.041872486951155391,   0.085080929454265486,    0.096957841185204174,
       -0.080033728505446239,   -0.059811816418247281,   -0.029024346637865735,   -0.24348496119566701,
       0.044174359323315857,    -0.040286451770211472,   -0.042806486074157948,   0.14722922995812315,
       0.061932056813946756,    0.040337384308577189,    0.13154194491525903,     0.11750701420146729,
       0.020843095832003975,    -0.086655719712199514,   0.020414342922797951,    -0.039498233267098858,
       0.041045152495224689,    -0.21595026368463865,    0.075984063322930284,    0.0044296977295242047,
       0.036099375275958592,    0.038130533856108866,    -0.18801291781594359,    -0.028311602851579173,
       0.14671886530365008,     -0.03565764301252615,    -0.084226195834555762,   -0.055799949920325227,
       0.0033152178113298207,   -0.11051047856859178,    0.047436902479907332,    0.091489467906132493,
       -0.053664291150071514,   0.041438345496823847,    -0.016303997785657436,   -0.02833088281296756,
       0.22432304542819348,     -0.044587404888535208,   0.14208338308075294,     0.013628112908119867,
       -0.03462194058371415,    -0.10659672998239429,    -0.30222833962651097,    0.054731547053949496,
       0.11154111092910064,     -0.24436006308564126,    0.15027442382712627,     0.030165455243112104,
       -0.024559547445442777,   0.03313369024297013,     -0.12182042127908622,    0.047986969555083067,
       0.090793968064951283,    -0.080501004789801503,   -0.00069283330900088338, 0.090389489314115737,
       -0.055499019008545154,   0.045433856738103254,    -0.10465355571421461,    -0.053110946618978638,
       -0.092707144721646276,   0.014652381817956844,    0.011337853194865948,    0.069558459928699856,
       -4.4138312859934997e-05, -0.063020168657249936,   -0.013529628696350295,   -0.0082376618960960102,
       0.069567043907324891,    -0.029028767520558912,   -0.15375710638466941,    -0.11787756549825618,
       -0.030070668369648203,   -0.011676147975009005,   -0.007645883916680747,   0.11648337258947962,
       -0.1227066614803568,     -0.21788840492305164,    -0.10137590449441497,    0.043632861139795941,
       -0.01409617725527044,    -0.024239743394414617,   -0.045391656563658629,   -0.130596094068161,
       -0.071425147686655213,   0.13381977850420576,     0.061699524333205136,    0.038295977616299659,
       0.010297636740119336,    0.19792046693666734,     -0.18997403981463165,    -0.074009804013422567,
       -0.057893755991284643,   0.034851183772893778,    -0.090540676796286454,   0.14101754697570387,
       0.049483044660444439,    0.048784412405280371,    -0.06439980843783602,    -0.021484485047004044,
       0.055439245638409275,    -0.028863777223189491,   -0.096014495488308926,   -0.11566249801401803,
       -0.076162614902938491,   -0.16442651989977231,    -0.021768736338167387,   -0.15433756789591863,
       -0.019655380824280005,   0.15565495443032309,     0.13467533808279072,     -0.072903803129378469,
       0.024540212814803578,    0.096454206286201161,    -0.038185013638504531,   0.16711086217315085,
       0.012263269577807261,    -0.0036282715471522217,  0.1007162692950176,      0.01124614106888331,
       -0.026203951439441341,   0.091815054518124023,    -0.15198336960663722,    0.12164877328256979,
       0.0088953628757283167,   0.12901880277899716,     -0.014010558612233388,   0.030864808494469431,
       -0.10460998682148857,    -0.091549754185326973,   -0.17464785632154073,    0.10510252176771637,
       0.1819730692191299,      0.092517638577926151,    0.091031295780357943,    0.10163336443676983,
       -0.089231328151802194,   -0.097029896389974918,   0.15247518619967781,     -0.083557973449027906,
       -0.0094303818802642467,  -0.024721442064710768,   0.051020660703258496,    0.12898930260841221,
       -0.078732965493106613,   -0.018422295632937062,   0.050073046196791232,    0.058299431233567595,
       0.069314206213492296,    0.070777105442450208,    -0.12295710453564856,    -0.027948956101055883,
       0.031109773786126768,    0.0081929334481072556,   0.032335398810821245,    0.039326894092874695,
       0.1481481971985551,      -0.0038933890672268288,  -0.030699749064638664,   0.086205459452702179,
       -0.018262846131923957,   -0.036025949814600812,   0.096792147775632928,    0.065049344445170104,
       -0.16840661992221825,    -0.094103876666165251,   0.092691571725855626,    -0.087536485214493032,
       0.0014672867170373999,   0.077573874075873475,    -0.13020534934356975,    0.084764090732194736,
       0.073716355916425252,    -0.15170802945350492,    -0.10547728241142675,    0.12410038224525419,
       0.15254613185995181,     0.065333202774119123,    -0.052090644824260436,   -0.049197149174630805,
       -0.11711942751975381,    -0.1435777044996952,     -0.035622812240612173,   0.043083510222313832,
       -0.035215407359193839,   -0.091419563087339437,   0.058896042265105773,    -0.092180560816001539,
       -0.012138581335667697,   -0.093433594279838328,   0.066401407329529552,    0.19547596529606917,
       0.072261985417742425,    -0.049025001346710555,   -0.2333995667636328,     0.19581247669327453,
       -0.1243978664767693,     0.15494264583320494,     -0.054458513200342035,   -0.19535630950611999,
       -0.064308744123854122,   -0.16819881549793234,    -0.021199785839547243,   0.11128483363740189,
       0.01892098819743802,     0.017306929149117526,    0.036177044330187369,    -0.017399395668441568,
       0.085072496459631414,    -0.17256368322689253,    0.085607670674427247,    0.084274340423252422,
       -0.021398431555370096,   -0.033626348022937999,   -0.063398686013109787,   -0.067474167371996963,
       0.051770623596042113,    0.22891363569686407,     0.073127333945353409,    -0.10157992960694306,
       0.1403072140353061,      0.01041751169381902,     0.0054519424185106961,   0.019077240043858478,
       0.037663182834489668,    0.021860751778548432,    -0.03263174856265294,    0.11794601204133701,
       0.19691200759429181,     -0.082829166784186795,   0.1673744590209236,      0.2288731979768322,
       0.085782368452542029,    -0.017596630497491945,   0.038711681551877389,    0.033880479944550429,
       0.18315805804340729,     -0.035306127136336345,   0.13195232177029867,     -0.1560726708016488,
       -0.10840808015443766,    0.077485442505249608,    -0.024592842085710092,   0.038527363016914291,
       -0.057518032346381455,   -0.011187162046088248,   0.064067698900550904,    0.064607242753635788,
       0.20019296973253264,     0.024528457314322443,    0.14674772334294323,     -0.076154210971732167,
       -0.0016421530284420386,  -0.021334817373935517,   -0.088391592472787398,   -0.024746802541143482,
       0.014389737799862256,    -0.05495044079639845,    0.07541765968884126,     0.081082615663319257,
       0.080270901108315793,    0.093823173260228612,    0.13354102579016205,     -0.13600867219287177,
       -0.039372197527561902,   0.16041959263004379,     -0.00053563400528434469, 0.077699297542501392,
       -0.19976686608921454,    0.026000304679725222,    0.0027587245084607845,   0.14331934902595977,
       0.00052916760530785948,  0.027797613160759939,    -0.15599110223535612,    0.020379423056572109,
       -0.14216795036115373,    -0.006957517675501677,   0.10256137747401925,     -0.047013125018004753,
       0.01700345825023299,     -0.077970262652369102,   -0.091067079151941524,   -0.11753516965548721,
       -0.083407141445284605,   0.040743924615349689,    0.018289610949868276,    -0.11014593998669883,
       0.022307462082926246,    0.012683493608984964,    -0.080678358493904034,   -0.15901691391888226,
       0.18460424609262374,     -0.017541562081819236,   -0.1632053160409585,     -0.1290620297629563,
       -0.0041717472408794518,  -0.072934539283984107,   -0.1297226016207757,     -0.1398971796871023,
       0.10199952009336219,     0.14764834925781617,     -0.0015059437528974207,  -0.26533798820588678,
       0.11042139617756924,     -0.047075133853433031,   0.14681240034745824,     0.15233402831351064,
       0.015995160967539196,    -0.10043365047188965,    0.029165978501129734,    -0.030634072508784173,
       -0.10149558778465775,    0.19629400996232213,     -0.0024403164784628541,  -0.043898832405479718,
       0.029353510881351855,    -0.044083701474425412,   -0.071817627953390722,   -0.10326464586641895,
       -0.050327060726637222,   0.097033136880619125,    0.15147778531832179,     -0.082293086902644863,
       -0.20444618259699288,    0.037942043636593772,    -0.0064908782020787776,  -0.10686019471320607,
       0.10450631056461207,     -0.021803569512900505,   -0.054254199378949562,   -0.10019437650217397,
       0.091306566036693682,    0.014312189948159096,    -0.030624296560766866,   0.27074961735433539,
       0.056726180788981,       -0.019456075659899617,   0.13997685258144904,     0.0080185327480850506,
       0.010720311670950692,    0.14235980607666787,     0.026978312690051777,    0.05860070746879123,
       0.050336725318377296,    0.011865207360458749,    -0.10590486076625952,    -0.022774503099066819,
       0.025711433495435972,    -0.12155318176547898,    -0.032261115817359749,   0.087454011992899261,
       0.13325205572729054,     0.12714592761332796,     0.15914492069879238,     0.035007048152477641,
       0.11417115070234397,     0.18298640417730491,     0.0021509625579523156,   -0.0074407327935290032,
       -0.0461464858073697,     -0.0087244702146665326,  0.24332303503819369,     0.082076469983933212,
       -0.019613838074266698,   -0.14947968061188374,    0.13051838805833474,     0.079540992872030439,
       0.034331408023950398,    0.046607250615199922,    0.14645425136427362,     -0.22410913762331253,
       0.016082909396760468,    0.1133359122719973,      0.029730528276156895,    0.019798751462472768,
       -0.049565697314933037,   0.018112048930882294,    0.044018971912882475,    0.081212429801030925,
       -0.080952162607300565,   -0.0091602013450578258,  0.12367085082468668,     0.047702082700280757,
       0.11572585597863806,     -0.17433388465258473,    -0.074176284223592251,   -0.03782762156074055,
       0.083960146435572328,    -0.072367066982398059,   -0.20617966730376411,    -0.10500731692043494,
       0.034736546984292904,    0.0048885957917251116,   -0.045783616783022223,   -0.013935116613347209,
       -0.14441186889695559,    -0.11698762459408049,    0.044549163709108358,    0.0057953650520881968,
       0.024053153118248679,    0.18678405949177485,     -0.038191217672557384,   -0.18542252648184551,
       -0.063349025112545324,   0.0016453575310205048,   0.005289075870445548,    -0.18195155042875266,
       0.16857362997992445,     -0.040110087506479444,   0.094712676885394295,    0.018170217645139489,
       0.067318827613327428,    0.024660211245450925,    -0.047433954796465741,   -0.085192607558482097,
       0.048978719958596012,    0.2048851083021096,      -0.03174689859302697,    0.11081475689169652,
       0.11870849059531861,     0.078751393629484912,    0.11418712076307881,     0.080449805335616145,
       0.055053473294605706,    0.039034839949576808,    0.028299210463509625,    -0.22662544521835198,
       -0.049517440211405556,   0.078321502889395739,    0.10420113366878539,     -0.043061176431853192,
       -0.078838094495084901,   0.18586729288409976,     -0.15301225067782609,    -0.031185433834332667,
       -0.083621004074437469,   -0.1111384895384756,     -0.00018446616837102317, -0.10805067953700818,
       -0.14679891794899089,    -0.039350650876670161,   -0.16084570995786457,    -0.077111677206011614,
       -0.032706344268579615,   0.090706124723142489,    0.10169769092428296,     0.0070078994031781512,
       -0.13436549669322437,    -0.063119304620915806,   0.094765518910717661,    -0.00089575456837869688,
       -0.13793175061387317,    0.088984833848545317,    0.081462347073187835,    -0.11867774029829543,
       0.098240991526333532,    0.020674460053886377,    0.088515944716048178,    0.16728018538526584,
       0.028447442923743994,    0.12917397743806652,     -0.10281792156700974,    0.16644942211245678,
       0.088553618084582494,    0.12750593621860015,     -0.01103009352997095,    -0.010418538766361904,
       0.20272682537376829,     0.17934824173703617,     -0.011072927569821513,   0.08382403803701878,
       -0.15293768901308202,    -0.17662968296983125,    0.13278081916757048,     0.00056044604309919872,
       0.0031981497657366121,   0.028288246050091611,    -0.042377182686044214,   -0.031797606894203891,
       0.03825566608314436,     0.061007965352182524,    0.15462012223812399,     0.12932687089365899,
       -0.13181814598216254,    0.0010872669257618803,   0.019872533170616373,    -0.048663495384597522,
       -0.049481496153229873,   0.06804334882470893,     -0.033125108326818795,   -0.1943695421345373,
       0.048354803606528753,    0.18894030770325509,     0.065950251860964218,    -0.09605464939745903,
       0.11911479634058761,     -0.013778810988165562,   0.1176334002744734,      -0.20577060711049808,
       0.066719244879906062,    -0.082106832952970776,   -0.054203892503342344,   -0.0030275941069195901,
       -0.092138238072441328,   0.031696685133310962,    0.095201567159577977,    0.031163434205630513,
       0.018673431886001009,    -0.19316046437862017,    0.21814507551927931,     -0.018375317800688927,
       -0.14724986306105151,    -0.058851608007228488,   -0.068785351340466719,   0.011134893847868853,
       -0.13582962693969158,    0.0048403997806935875,   -0.046430439053127992,   0.031922771448853395,
       0.17521887938768127,     0.032540725543070151,    0.11457615554765666,     0.19917134250718296,
       0.021500567651102455,    -0.019938701829319859,   0.11351927926768357,     -0.02101982587521712,
       -0.09102111721187936,    -0.13777341485463471,    -0.018081351270459511,   0.065113098902518221,
       0.008703069516600527,    -0.10626374501743532,    -0.10774998357517045,    -0.043301286814744308,
       -0.034246150559839941,   0.033792924470477152,    0.023685467493628848,    -0.034210038995892839,
       -5.7613885423311688e-05, 0.23657889395210269,     -0.10639385715549378,    0.11019586880432676,
       -0.18099250146108803,    0.13009622684623021,     0.069249201735667454,    -0.036759975512966711,
       -0.049963331614456513,   -0.095133698644225051,   -0.00866051141772314,    0.0019888685522491852,
       -0.13660950391929996,    -0.064841936512013795,   -0.02461875763570074,    0.023457290825935513,
       -0.12602152502323646,    0.062669502714023662,    0.062068413378443522,    0.022521474469982629,
       0.024594973026280199,    0.03577457038598264,     -0.025703601199382975,   0.098049084505364065,
       -0.11255359103465856,    0.18043397127425229,     0.02544730032751653,     0.0074406121048231893,
       -0.033026614680546157,   0.11771660602318362,     0.16101195646822269,     -0.046151667602606423,
       0.14074239746529138,     -0.04084700313451739,    -0.035216893763653716,   -0.069541498001513158,
       -0.066369783600112503,   0.083284764101191705,    0.09893955717578698,     0.0023871988789368635,
       0.032361930027463001,    0.070660579221076672,    0.22242031238970564,     0.12107243864136996,
       -0.12569430221813699,    0.031105117570676001,    -0.096785384209001485,   -0.13553093157180329,
       0.0035512670262158041,   0.078110230682744891,    -0.13391910777309393,    0.26828709493952124,
       0.055425962535546616,    -0.10327466802900946,    -0.093603690927259398,   0.065502448150749459,
       -0.10628421972159847,    0.086709986875162195,    -0.0098394431380880911,  0.10757634979462408,
       -0.15115077957672568,    0.057692283526405166,    0.034715946353467642,    -0.14942576167179514,
       -0.096770191079009679,   0.0419226717510107,      0.077603851485761044,    -0.013489239561481322,
       -0.075109901644275029,   0.13804030502269368,     -0.076995586701161939,   -0.09977748158889245,
       0.16560808381072106,     -0.11041300163362738,    -0.068967266443255987,   0.017932414433135702,
       -0.21442452935526957,    -0.089279589306809459,   0.15901843062111554,     -0.076011258521035477,
       0.021920823839411588,    0.12643716124741933,     -0.08468402840440141,    0.025568946064627788,
       -0.0073854497756564146,  0.10745484639461585,     0.16458959432356712,     0.1387841733966223,
       -0.05941233221325868,    -0.024942225818081629,   -0.031063207870177207,   -0.034401399309706288,
       -0.13678290531199058,    0.0013651694416503199,   0.16047857271170562,     0.095474979708730034,
       0.060498672338700599,    -0.0072274203927328792,  0.030210083659449806,    -0.055642790831588955,
       0.0046442746121186269,   0.13635287007824259,     0.18147476672871765,     -0.049229753024143889,
       0.043903956602161578,    -0.063722630628761184,   -0.080336651344973864,   0.12429170771914949,
       -0.12764182004075394,    0.018445833348766157,    0.10245809033525233,     -0.042473665079018993,
       0.043338665000496185,    0.07775749985365836,     0.14238248876491766,     0.063923132033535363,
       -0.05626885732194916,    -0.067981695603232223,   0.060427050814384778,    -0.067696241944360219,
       -0.097994767889885773,   0.022935420006468449,    -0.26250904617423809,    0.015298679821667566,
       0.10692108353150906,     -0.091130626583878313,   0.06464124703832444,     0.06259519604347745,
       0.035320614600066545,    0.22775659771392728,     0.13865175046924325,     0.16868561040293231,
       -0.01488313229934388,    -0.040271691376011227,   0.12682619066751721,     -0.054037095702455185,
       -0.089360823576959944,   -0.0074709958446082412,  0.029435883172118121,    0.0098240227575820648,
       -0.052662421616939868,   -0.0027247656393072817,  0.019390732356296236,    0.043837795281457488,
       -0.077151169659127813,   0.10167016986603503,     -0.07204397318947138,    0.10616775078009798,
       0.024532127086558862,    0.072176403927851129,    0.022430245649293561,    0.065969566677532135,
       -0.05634328588400981,    -0.11296383656221742,    -0.057679176478754778,   -0.10695573334222915,
       -0.098277624351584617,   0.10241884693792824,     -0.27772918707723293,    -0.11978297314965933,
       -0.19394411290578104,    0.047888432958742989,    0.09651122545308205,     0.12341661444502698,
       0.026999093581568982,    -0.15768593177873702,    -0.007730197677900427,   -0.1182320914469745,
       0.019544939672045035,    -0.039625955402963944,   0.02890226757335956,     0.11419305686489921,
       -0.056379329527698335,   0.071872411295759178,    -0.076206256274382378,   0.10434348285004005,
       -0.089258439288888644,   0.14128321359388182,     -0.0087138131018965614,  -0.033948119061942061,
       0.0043407655160108919,   0.11156701248924691,     -0.062787419799576596,   -0.31544191209796063,
       0.0073995898566965781,   -0.053433401655795236,   -0.074741639680626484,   -0.041918790444517948,
       -0.10981396349090336,    -0.026156371729962859,   -0.069494896901842032,   0.030134769873356365,
       0.070891994149139631,    0.08445034948168724,     -0.14036644410653223,    0.033369434824839575,
       -0.14003238823618191,    -0.043051562824491879,   0.18278387520431288,     0.075568764602880714,
       0.17258639884939564,     0.10147613367653067,     -0.039274322296469072,   0.041283592954189617,
       0.047750192149136832,    0.17293011926882654,     0.19036843746295407,     -0.10709763835114632,
       0.033884574271027583,    -0.08509516800131825,    -0.016744247992778977,   0.15522393625102149,
       -0.039235793571226141,   -0.1294899167615868,     -0.084094986815668904,   -0.038172497641090139,
       0.082196185767111546,    0.041861492538147041,    -0.022947182359473142,   -0.077422323799827289,
       0.073356577087749592,    -0.013935889381180901,   0.05534866961845987,     -0.057371216906667744,
       0.15766732446838311,     0.07434998614513573,     0.090017239436439342,    -0.1719029987059052,
       -0.17009514777339885,    0.0076021366167415387,   0.0022718306693784419,   0.0015901522219678153,
       -0.071535858418028953,   -0.034116914482186921,   -0.16796821698347661,    0.10752846456311002,
       0.18633299480057872,     0.077814203280613559,    -0.032830062416985641,   -0.10822234096086313,
       -0.13482633860027854,    -0.061308981041526392,   0.15683667360409356,     0.13892990101094571,
       -0.079690453274254558,   0.098076511464631297,    0.091161325641974003,    -0.004197391155640327,
       0.035422322195122473,    0.0010682493977268465,   -0.01985779621945865,    0.0040090369024788726,
       -0.033053470336123873,   -0.043862520432808243,   0.043830969946577349,    -0.29512561588959463,
       0.039875910980091342,    -0.18920314538239547,    -0.02940401587429901,    0.018417712028604934,
       0.070758901862810572,    0.11199393452700927,     -0.18717034210144715,    0.0095185018769993381,
       0.060057115285670183,    -0.1596197776165536,     -0.11876528693834973,    -0.078872120199027784,
       0.019530908605057583,    -0.033517514388699432,   0.030365420945029527,    0.065994513021561244,
       0.11721488573153872,     -0.031988924051857472,   0.0028220741661695537,   0.10917015307035555,
       -0.11776426697238403,    0.072508368784876737,    -0.0087343775500295442,  -0.015865797785217375,
       -0.052417860389580316,   -0.14413309496089741,    -0.07413428246891543,    -0.10575916007129026,
       0.12495298338627499,     -0.020214599530734612,   -0.0051588877531539021,  0.11683885260242266,
       -0.064496556153967877,   0.0087876702601173244,   0.14061289402745167,     0.037347667334372003,
       0.32920113975324256,     0.007699862711514377,    -0.049211080956396647,   0.032391263217812528,
       -0.080590689218106595,   -0.0027134175691130996,  -0.046718498317837122,   -0.014891428447655284,
       -0.032022678112814437,   -0.026088001698479565,   0.023420472398478671,    -0.14261561690780383,
       0.12315251044036432,     -0.18421201013141333,    0.086465178201531045,    0.1000301430329627,
       0.03287241290099735,     -0.030054572846728436,   -0.072794069816036769,   0.18459517623016589,
       -0.099414617895153656,   0.068300562854179431,    -0.11284011988639221,    -0.1171986619617387,
       -0.051884209416538277,   0.040136934069818955,    -0.06850339316193689,    -0.15670288636023572,
       -0.10579708265470514,    0.18029913917062373,     -0.070582557803385071,   0.093630569436767702,
       -0.011240982008052553,   0.0032757627363277199,   -0.0046660977489168479,  0.041269922733700753,
       0.076303135451505702,    0.0031892619395864534,   0.055818252357735125,    0.11955268771395529,
       0.059995529975624518,    -0.24015203414032354,    -0.07795701234475344,    -0.059897755837783936,
       0.091306602851911417,    -0.14195813523579773,    0.077029163869046971,    -0.036493812249683476,
       -0.19153808844912745,    0.051417124001305742,    -0.14730313360093825,    0.068844596217545462,
       0.022748841421584301,    -0.14495993170288968,    -0.023706821124097589,   0.037050281643575211,
       0.069885769028845399,    -0.066692977821657257,   0.032395844983055984,    -0.027200467941887359,
       0.07577892869106094,     0.18320139613622191,     -0.062193715590938808,   -0.097665156717154214,
       -0.18018598743145786,    -0.051392980405790947,   0.063133989552269398,    -0.091543994781653829,
       0.027097573144553657,    0.14987484951848359,     0.1200079597988352,      -0.12444591916446106,
       0.10116375584234076,     -0.084310497001278933,   -0.055768962342907707,   0.043422583314414911,
       -0.066763870114355028,   0.10793087905524074,     -0.040702874916567613,   -0.11337364907246174,
       0.01084129433663286,     0.0089361080142118087,   0.030532725320084629,    0.011978467253858325,
       -0.11624468319901037,    -0.1184283752022563,     0.1105439816399526,      0.046773321175791617,
       0.12276325538249927,     -0.14788453463427736,    -0.071947288410974947,   -0.15873187843216702,
       0.020069626844985144,    0.08609669394666998,     -0.072567204161293364,   0.037100637205610652,
       0.18786723730356167,     -0.061444377506783304,   -0.015369628683389874,   -0.081957384947125039,
       -0.12902655310643851,    -0.030128978815120618,   -0.03589132193267254,    -0.12333482414867042,
       0.0067438897604514651,   -0.1037530075198719,     -0.095190391710506389,   -0.27227198412543485,
       0.044512203796929918,    -0.080580474460697424,   0.17447683454656082,     -0.039925959345959335,
       -0.070988964371647395,   -0.042953585430942839,   0.094233161267900295,    0.038964821636254379,
       -0.074505065920141084,   -0.015915784806682903,   -0.02233971956633973,    -0.22368453639752861,
       0.14502135750736861,     0.083980241663013974,    -0.12458329008491538,    0.041794977646272144,
       0.043559462788636295,    -0.07881312371079964,    -0.14633582190515981,    -0.09493596132095368,
       -0.072873970464208723,   -0.17885809959800655,    0.053110614597261296,    0.056943403685492507,
       0.011585837678787184,    -0.022204043072025958,   0.19405594502831749,     0.0019050325910201869,
       -0.040535841997820378,   -0.029721789721186699,   0.083105320910392758,    -0.022633860612583628,
       0.34546569623720236,     -0.12758235861360698,    0.068379691473452062,    0.11047376420382164,
       -0.018426703104322678,   -0.090163649925629669,   -0.08062175798867928,    0.05569542589413562,
       -0.081780008117309635,   -0.023586533161981022,   0.070509342879502834,    0.083449890920521935,
       -0.087510209659362515,   0.016552208341264137,    -0.096836371416515646,   -0.15869746453878011,
       -0.021708559612608501,   0.014345836153291571,    -0.0097875542262287115,  -0.11113097015035071,
       0.1646404000591184,      0.041738320852491087,    0.11224419815070258,     -0.14912894542340452,
       0.14273271196781159,     0.056074051097457681,    0.093121066104238134,    0.078519593122173381,
       0.011668961830397446,    0.037045325974714209,    -0.063777797859019256,   0.042104573710666629,
       0.10901701126953917,     -0.061814647206392674,   -0.030150051155207573,   -0.10275237070993426,
       -0.037011980608604583,   -0.11666377796582518,    0.068183226102125349,    -0.067372112139611431,
       -0.058007726054978045,   0.10349760984784923,     0.14923235339669477,     -0.13798902171789695,
       -0.12232084003702101,    -0.060100659286077301,   0.17466431933241258,     -0.048557944435055844,
       -0.01305146622873302,    0.096676500003247318,    -0.17201039550967639,    0.13814325322453169,
       -0.24837950629357422,    -0.10349056206801199,    -0.004993143370475542,   0.061669436804225666,
       -0.045796381388128818,   0.076917435387984456,    0.025888186017113759,    0.01431192734526226,
       -0.05493532515489398,    -0.072639615816583153,   -0.060739056548155583,   -0.039009466419466246,
       0.017873997345270745,    -0.14339624366335069,    0.012792212041453971,    0.1399798889966529,
       0.067191808160724578,    -0.12669324236502821,    -0.055221051408377145,   0.028989384336352109,
       0.088171088064882094,    -0.049893813567473869,   0.00019195923104507089,  -0.18460701401973906,
       0.14874895650073638,     0.099377366431159672,    -0.028312314131077571,   -0.12438850119449818,
       -0.15856566472234671,    0.036813021741086298,    0.14446088419573447,     -0.23087965613834616,
       0.15192029531219492,     0.10122890053778158,     0.037661926167269613,    0.12955724161286947,
       -0.20737453227512961,    -0.11503507881090309,    -0.13754948698043676,    0.090663596391910267,
       -0.095209006443436314,   0.20182279386860194,     0.063297888216859235,    0.04401012051485844,
       -0.11933562293792904,    -0.12238046133269588,    -0.19232312156829059,    0.11230355203352679,
       -0.066931341438899727,   0.0046879757721444261,   0.048988969597542689,    -0.10091073966372593,
       0.010374937767324531,    -0.14134341449347773,    -0.0840191062048979,     0.055330175444332913,
       0.082945101990397313,    -0.071523981115160451,   0.012919876706322365,    -0.028773772796808761,
       -0.026361731240217373,   0.15137687949211798,     0.011156709340750932,    -0.019844080925306727,
       -0.021871127008828737,   0.0022691114553270194,   -0.23003446107431449,    -0.023187551635984006,
       0.09850033767743685,     -0.084139177682746452,   0.13132122641857097,     0.021394523101319677,
       -0.079054290935296048,   -0.056039866986708611,   0.071048888424877943,    0.11836655007774834,
       -0.12943548921993278,    0.010685211204285037,    -0.017268104202699971,   0.015055997972205779,
       -0.041445587342918117,   -0.054327446776761136,   0.040786132586981237,    -0.10970750490231922,
       0.066383991001573647,    -0.19816304059918824,    -0.11222227270835482,    0.061362144439398393,
       0.10037329896542509,     -0.0061870822190911411,  0.050302833417741388,    0.13294207776877909,
       -0.066806274211387559,   0.049183373973652141,    0.076741456050384294,    -0.12895884744621011,
       0.10758614969878301,     0.05967122738367072,     -0.0074022682699968799,  -0.17413446773340122,
       0.038030425191051154,    -0.002065926939247586,   -0.10203871602737703,    -0.14763698987513196,
       0.10824221209264896,     0.14199155081362205,     0.05300392185298694,     -0.059663802904960553,
       -0.10610419758667526,    -0.091358851835264765,   0.060905098246790343,    -0.013406507778478578,
       -0.076416941723760137,   -0.064661453629816068,   -0.059979959666250846,   -0.038211214849661911,
       -0.16352115988250987,    0.096337497993187693,    0.027347994354175811,    -0.022627342690978148,
       -0.12879375650187902,    0.0010372489417829417,   -0.034265476543362691,   0.08562740188961529,
       0.20803398535718626,     -0.032498513631194673,   -0.062526983385943508,   -0.13984512820322145,
       -0.093212338497067684,   -0.092449423134676009,   0.10785016189350057,     -0.049305925734238087,
       0.048727926152161351,    -0.067988982913470025,   -0.05554026893527244,    -0.011561655792712011,
       -0.10778559696915595,    0.070025991887014069,    0.016631330032391235,    0.026129856096393324,
       0.076288942244875022,    -0.16456376561460934,    0.0016425630190549058,   0.062506310615552674,
       0.12562770490108427,     -0.18296049439291104,    0.01140092013797207,     -0.065826013327323685,
       -0.036627825603635707,   -0.15249202026152975,    -0.18547338761153165,    0.033481232120025795,
       0.20103116437569726,     -0.12808490420497781,    -0.039753150085824134,   -0.0016214165706158979,
       0.11725238759479838,     -0.14267819194933443,    0.045527870817663206,    0.062286269131106548,
       0.035667259710363122,    -0.21855555372959171,    0.12727661425940462,     0.032532538268844877,
       0.021829534093027292,    0.033610244961283307,    0.1191297067530477,      0.094861588153790366,
       -0.0065080957994746273,  0.04193563666288426,     0.1337950265806252,      0.011825283780782146,
       0.009936272591309657,    0.065293973350921131,    0.002851281248714596,    0.071656127655103014,
       -0.13585303897593648,    0.012158643406091853,    0.077944653730401117,    -0.064333006250759522,
       0.067800918002597202,    -0.12314287765795286,    0.031298726606732413,    -0.0030050740557141182,
       0.0061103533115851351,   -0.015079976741237514,   0.034605777727925398,    0.0018809580861811831,
       -0.0015646133299814801,  -0.080194542144575054,   0.14443369519180371,     0.035761087539946716,
       -0.043636992248655082,   -0.042974884790327211,   0.087854512558663819,    0.016888495901009968,
       0.025586620864701693,    0.0024409107928176528,   0.019979517094817739,    0.080133261504800851,
       0.10571805604556894,     0.15431610131233239,     0.080345814210055211,    -0.05019032999416656,
       -0.10561258835423304,    0.10504990187653299,     0.0011787256721244321,   -0.24040375083056922,
       0.068766306694183252,    -0.048346648972639995,   -0.11599294809577967,    0.18800513119245529,
       -0.13977727084916272,    0.23990424442783961,     0.25587131815335629,     0.14164175395202003,
       0.093924650723322164,    -0.020522782701621466,   -0.026815277946708731,   0.088597220108744129,
       -0.049776302823867337,   -0.028806878244760518,   0.050890152874175483,    -0.054399596537580891,
       0.10445837478533919,     -0.051437214954018498,   -0.055888144541489618,   0.076651618106333252,
       -0.17981278206573587,    -0.074773104536664969,   -0.060930128664279978,   -0.04989504316531615,
       -0.045823526613788433,   0.17203311760707732,     -0.094466280632034175,   -0.062867118088044988,
       0.029737556866505529,    -0.08146296482427233,    -0.10899838285088873,    0.15451237415745481,
       -0.088744849283216257,   0.0077238559044163413,   -0.046354059653646619,   0.22739590754631875,
       -0.064361913904647988,   -0.090390370472717016,   0.015021508179670878,    0.093988005774127956,
       0.036318729348580145,    0.17984917615866994,     0.10951164008639908,     0.20748776867645494,
       -0.033420024662645216,   0.017085087766123649,    -0.091363047827744126,   0.11225003188653886,
       -0.044419753022519104,   -0.036838946064191067,   -0.013583490905612797,   0.17335224946128536,
       0.16848820105950973,     -0.0079542565993040177,  -0.053000349213931097,   -0.09851580766646556,
       0.0037762904112282102,   0.024146660115579498,    0.20197297519700469,     0.075785716904813227,
       0.1330711601302727,      0.057791740136457319,    -0.051864968189150151,   -0.080051848425000238,
       0.099044271811884535,    -0.012695050063156561,   -0.14013063683796426,    -0.013631566908239653,
       0.038406543107634243,    0.076485315623881306,    -0.037909123571638934,   0.12697229916158223,
       -0.079953428267856647,   0.074344452858968471,    -0.096861298841234109,   0.16009184477713725,
       -0.14559002516735026,    -0.10039124952368506,    -0.032643581401498707,   -0.018546888332068901,
       -0.16824101222231871,    0.056778780787053375,    -0.2437080727091977,     -0.074601015652058636,
       0.062873630488974611,    -0.12132740836091246,    0.10875481746313435,     -0.10898558367713944,
       -0.010733005217345468,   0.091786745762109032,    0.099704444041309515,    0.048711798544472031,
       0.19659008123030014,     0.085568047082069359,    0.01177033286119308,     -0.10710042006716901,
       -0.037770346791507071,   0.029283374875721028,    -0.061446547650390065,   -0.06855991848336862,
       0.10781922246847594,     0.15135673364663824,     -0.0148154238699576,     -0.1850537282839762,
       -0.089673642429721853,   -0.084115575213692867,   0.16200893902225885,     0.00687351817322849,
       0.070504089218182714,    0.026471396888811619,    0.092423531325152408,    -0.02245079773012219,
       0.11468695206973088,     0.010937817461245695,    0.061255071053567749,    0.20969107497322476,
       0.015027757444017829,    -0.30275808872909987,    0.11365525432487505,     -0.21048475663837019,
       0.0094343861902189581,   -0.13066622725436297,    -0.03073538100481801,    -0.10595567592532516,
       0.010546432043506146,    -0.12262833036556105,    -0.082670365596620346,   0.080221021094990838,
       -0.16769270189447794,    0.16463196098950891,     0.043987738275973562,    -0.011591959031143143,
       -0.12906006492456615,    0.017553777672181727,    0.052330850722726641,    -0.18929480367507792,
       -0.00034585626602378575, -0.044988208598835788,   -0.023214299051171151,   -0.12374656438703625,
       -0.13075691541553386,    0.022101509557215342,    0.073623617260922036,    -0.10032647199302509,
       -0.034584440601059224,   0.0051190787678774396,   0.10793981458311676,     0.054137989457163804,
       0.18799105833318638,     0.098833178467700109,    0.088520389728253476,    -0.11513659996940302,
       0.044847530136988015,    0.055282440302431228,    -0.082989443981859548,   0.051140592451027672,
       0.12157671335361867,     -0.11808652868710008,    0.17161337710068317,     -0.046352933556806031,
       0.057586639239501865,    0.012557356281781236,    -0.031336653063981992,   0.13471176304636309,
       -0.091629388005297824,   -0.041991952491099466,   -0.17490632408943199,    0.075931531410077441,
       0.10660060641806397,     0.12202152561197342,     -0.075719336872445975,   0.018313489347200437,
       0.053618430091971654,    -0.093068375302597942,   0.0048031132733939979,   -0.031130965764628479,
       0.12401956260989115,     -0.071375861517080627,   0.0077072973440635816,   -0.0578724191820583,
       0.058646138040498813,    0.012804742526445322,    -0.094339523491536403,   -0.10697122578568147,
       -0.063043449018973102,   -0.15114391548237527,    0.060619601323609502,    -0.10623605519933101,
       -0.029505609919636969,   0.112707670358413,       -0.078815594821294355,   0.086715452047930519,
       0.28153577654499057,     -0.01200743703382761,    -0.065261609047689281,   -0.0050403572443324237,
       0.040895781133537056,    -0.038508218173727238,   -0.054147558172069774,   0.15162398815534328,
       0.076294304835164237,    -0.15453428211703854,    -0.084902813525304877,   -0.077587988122950841,
       0.078906069813850663,    -0.046030300014597771,   -0.041697143523825225,   0.0089111998472651711,
       -0.024712581977262019,   -0.084296545355923069,   -0.0022922172024355588,  0.0017201616245779219,
       -0.13300574045808317,    0.037184596639688858,    -0.13826510829934072,    -0.12054846771038798,
       0.059045970691669829,    -0.042358299809873379,   0.0088806115654641669,   0.015344750803199129,
       0.032987311414068576,    0.024206763154426551,    -0.048205956526851272,   0.10684684111730076,
       0.15657490293235252,     0.084136318153206546,    -0.018596415666042233,   -0.063267182987634243,
       -0.13717100454948353,    0.18664559570534714,     -0.018235750572195009,   -0.00069985027562062714,
       0.066171439405235691,    0.11207988982554642,     -0.0031792118129025087,  -0.068650076650530148,
       0.091535885286269478,    0.11849287851877552,     0.11077220588088471,     0.039913258834935503,
       0.087461742498846626,    0.15226628557767174,     0.0030948729280365862,   -0.1552032898212316,
       -0.098894063721711639,   -0.14868119551482673,    0.024540344198947822,    -0.21160156686987108,
       -0.034276216129405082,   -0.17067876746007277,    -0.051153584311579403,   -0.049483685797760954,
       -0.13633746337670716,    -0.015542117714050407,   0.051729816927025704,    -0.063795545763942307,
       0.11307811395054103,     -0.11482257873551033,    -0.073793966540575739,   0.052911312097231045,
       0.0251426287036953,      -0.031574199766334708,   0.064176311327031374,    0.067019495032865417,
       0.04634519409964144,     -0.14375738164294213,    -0.0038239442000983529,  -0.1057605677475883,
       0.077658505265892172,    -0.1637172321768125,     0.12957907875413657,     0.08335001646921604,
       -0.0064430940895947378,  0.058230981344308638,    -0.14105902844655299,    0.035664081475163534,
       0.15871395564915317,     0.13325583043838132,     0.12599998128827541,     -0.042146321234385602,
       0.017414166247547654,    0.016523910390718117,    -0.14070754967816235,    -0.13825767579802806,
       0.014483959315854965,    0.048661060441051771,    0.091978315605282704,    -0.15115524296090194,
       -0.049301055649736213,   -0.049052916400162488,   -0.078073741982506245,   -0.042785129895924437,
       -0.062504572436241093,   0.19847869540452781,     0.16678067309471162,     -0.01799042217746602,
       0.017516165820758177,    0.27964022666751215,     -0.13143271973027049,    -0.01616835388551589,
       0.18908613932807397,     -0.15306859309344975,    -0.0087801072279700531,  -0.19288678210892435,
       -0.05807380496067694,    0.021200876521164539,    -0.015836249555589321,   0.055894220320571598,
       0.045640382231399448,    -0.0056096284155037271,  -0.051947445006483517,   0.065534701914992347,
       0.13496512383155107,     -0.0026540670762222277,  -0.092169680743498017,   0.05895303919056169,
       -0.013813578284907781,   -0.036471369781370423,   0.04102863563197235,     0.027757067853372303,
       0.047317789739991935,    -0.11550364019804199,    -0.030929918318623163,   0.10705406228491833,
       0.18630832184399454,     -0.13881156408045608,    0.18361190897426022,     -0.0045681458911971257,
       -0.083998938355801717,   0.13698775925288764,     -0.003015209477865979,   -0.07748980415769656,
       0.021275420723348717,    -0.046261993087442006,   -0.12983271991119638,    -0.055807819150497137,
       -0.0089688846404658747,  -0.24243174059898084,    0.021677175504515145,    -0.052927905855294895,
       0.15732659373670693,     -0.032886224682090043,   0.093023974723707881,    -0.08509387631672681,
       -0.029526595215769613,   -0.024341117712507646,   -0.23704046171325807,    -0.044159469451979863,
       -0.11635905987539936,    0.025010131658889181,    0.067919850194728126,    0.1574131158330378,
       0.10782243589143009,     -0.033523591080647397,   0.12425358036911169,     -0.14588377096309982,
       -0.096467242928217178,   -0.15464082330224307,    -0.083139293405680242,   -0.038419268193707654,
       0.19994788934686003,     0.062509008688227979,    -0.077354190766740549,   -0.034514284753654527,
       0.043832221024049683,    -0.011701963575761554,   -0.10246702222718131,    0.081775924175249814,
       -0.078925691234355971,   -0.13247343600060157,    -0.038304288126932269,   0.16982496135438066,
       -0.090199801802422819,   0.031508799790258168,    0.27586451857345001,     -0.05738089549760126,
       0.067563768287690021,    0.13277519102014582,     -0.01924890142984137,    0.1103007951210567,
       -0.030614229612540091,   -0.011930382763893022,   -0.076124297664092219,   -0.10781013862457334,
       -0.13169650601158567,    -0.1360128060202431,     -0.019386593093729015,   0.059350824003846989,
       -0.002486485100101592,   -0.13783556263570881,    0.090614152405016982,    -0.10385799330838735,
       0.047225344356734346,    -0.078191778473259865,   0.068697661356207598,    0.019092952195840732,
       0.040171796569291048,    -0.094482379530460014,   -0.1321050871216759,     -0.0005853142272421348,
       -0.029573621000142727,   0.055115294118389169,    0.018272428053252215,    0.21108398009548451,
       -0.17582545474524169,    -0.14499700506899635,    -0.032362623902618987,   -0.037767432773034557,
       0.12886150838742866,     -0.1673138744884092,     0.03034086361571741,     0.01990528567626082,
       -0.022289698460336231,   -0.042919520710103846,   -0.0066245128483197815,  -0.28594679402530387,
       0.018013998628845333,    -0.14280951207794521,    -0.026687892110667969,   -0.070423998200196125,
       0.16492337167179305,     -0.058593242131280171,   0.028118570358082011,    -0.0048132145360887564,
       -0.0083972912054212541,  -0.072286590258793457,   -0.02414882820240637,    0.050181758881315403,
       0.0092846298984587908,   0.053690768025181385,    -0.18147324897595035,    -0.022962014757328286,
       0.11878536082200816,     0.096284487869028323,    0.007806366269558951,    -0.17336173781737796,
       -0.023112787166968105,   0.10507358147436958,     0.022425536249279718,    0.076219192438706215,
       -0.083989072496131717,   0.013165791893680348,    -0.14124405188886693,    -0.11247383855001208,
       0.12796922226629129,     -0.099871238253274972,   0.001896702660586272,    0.13935967412553235,
       0.072443150713634136,    0.12243758621068497,     -0.028679615194675299,   0.099141882926322214,
       0.056602141455124148,    -0.14099552963744669,    -0.099443374799417075,   -0.21361144487073366,
       0.11351124712708857,     -0.034342128342467762,   -0.070245799436877143,   0.18653488917441435,
       0.04923847025460365,     0.013828109114609279,    -0.15234431051187211,    0.015342144659169284,
       0.20626942884796753,     0.050134552030658516,    -0.088334902211029923,   0.018515778960132716,
       -0.096178882695153775,   0.048923035786034769,    -0.13989088500114799,    -0.060608794766517135,
       0.14528726535725159,     -0.040642430795274881,   0.005815345525606269,    -0.044865259036948997,
       0.038630016813889584,    0.085012532199217131,    -0.097833716241027227,   -0.11861772318866598,
       -0.14062260566874116,    -0.11734587668099031,    -0.018936301038541957,   0.0087336761837278447,
       0.21846737093278437,     0.1440348375375618,      -0.0061239285294153031,  0.069887398106808107,
       0.13057001865870282,     -0.00038141400380935567, -0.032968438283496389,   0.072280500707989512,
       -0.11141088924664877,    0.022394638770960255,    -0.077511856151500066,   -0.12332382274383681,
       -0.0080059090159496568,  -0.2596307998276427,     -0.11312280197765287,    -0.13530881891441993,
       0.013654023756426388,    0.016050267769454923,    -0.06741941738533519,    -0.026243857025172103,
       -0.02584511621586549,    0.022181774141744218,    -0.061822388596173214,   0.039683270253820457,
       0.025774231799284033,    0.010556684290263529,    0.08915919474250629,     -0.02777796692222791,
       -0.03694876364044361,    -0.053253236496426215,   -0.017517728319963472,   0.024516797441498334,
       -0.15406411121719771,    -0.06687813133078517,    -0.024378345602582081,   -0.075001529061132388,
       0.066804509776901638,    0.14968848750742272,     0.085260873986273578,    0.044344724776125721,
       0.10758482034021095,     0.082813054893065577,    -0.064842304934841402,   -0.0014682825993754586,
       -0.043327920914786593,   -0.16184527673875582,    0.017563260970616446,    -0.18704014349296544,
       -0.029729080358333347,   -0.0063364619327540847,  -0.030943945445911076,   -0.0078964837834770638,
       0.060121087833539061,    -0.25512867456374899,    -0.024820578700860321,   -0.071268665034739442,
       -0.14568864260840061,    -0.12545521813116922,    -0.18385596421336681,    -0.15571176920953456,
       -0.17234662893861732,    0.087089521238154471,    0.072670975657735448,    -0.038902842294910464,
       -0.11952623397685386,    0.052107195252811996,    0.11484937779371479,     0.013193109291764225,
       -0.16747484825476022,    -0.0013936598766944991,  -0.010054448700175246,   -0.1457715492213128,
       0.16363629044762545,     0.1933501452146367,      0.028461924203719194,    0.113039200269568,
       -0.034280917942671178,   0.16638588431672516,     0.11982399247649302,     0.013361920543689818,
       -0.041169182098627487,   -0.1086985187644897,     0.011388269604546789,    0.036926256776666798,
       0.12399845055353176,     -0.036251688853096958,   0.072474952756186567,    0.08137147511055251,
       -0.026633638967118449,   0.070236530481222678,    -0.19061242900218414,    0.019876536699822468,
       -0.027079473594039137,   -0.03421239663459856,    -0.14522979897529137,    0.038792586724174898,
       -0.052524063857181266,   0.037701919153304432,    0.02062800077123584,     0.05053067135484475,
       -0.088154893013962926,   -0.074050523483786448,   -0.0083562681158348053,  -0.21142968014057323,
       0.1882983674588099,      -0.041177849142804576,   0.064999233549367319,    -0.028592948885010537,
       -0.031880513500389444,   -0.043081645605909637,   0.098552087873506874,    -0.11993082744565885,
       0.14371703517702958,     -0.15253453968817959,    -0.13014379772018336,    0.076129682804426682,
       0.087800251845213353,    0.27509871123990387,     0.054628660695638834,    0.038896135964003653,
       0.020863322901680286,    0.08923705403445388,     0.069144054594067569,    -0.0005352568303838768,
       0.20614012402815113,     0.013221631270313589,    0.057189200830660786,    -0.22627721310147139,
       0.084707384093218402,    0.024582665159669049,    0.12946072586508647,     -0.02439700294708802,
       0.029246892368819721,    -0.016359812939418218,   0.10704015083306634,     0.15596940413138616,
       0.14681482951707744,     -0.11189285322401239,    0.11934119332168976,     -0.10860238028131762,
       0.063781780781161992,    0.14943756668109884,     0.014246461244325805,    -0.053422741372626731,
       0.11545942038774763,     -0.024490685989395678,   -0.1451258888863437,     -0.0033436203116385282,
       0.007456901545702669,    -0.03426079311066528,    0.062118070125970058,    0.034893787477671627,
       0.1302762811009657,      -0.16510946901927692,    0.14168437820154328,     0.0091575763295367891,
       0.077527284146873349,    0.020826611253563901,    0.019981805630375597,    0.10104941188429509,
       -0.0034925355589677217,  0.07287076421608063,     -0.097216758242248,      0.10081266866036601,
       0.10986071233666109,     -0.004604218247178265,   -0.017626199899634855,   -0.0065794363328307457,
       -0.022620685488877183,   0.025331046989825586,    -0.01311490809961586,    -0.044389842860865884,
       -0.027854398354022519,   -0.015154330901670046,   -0.1189622599428114,     0.018425920914773252,
       -0.072589476756734495,   0.11071215316906896,     -0.0066527011810473919,  0.048960071619043505,
       -0.078698425697731028,   0.06679020930080333,     0.056565183849276036,    -0.1332096126206315,
       -0.1420062521447566,     0.001141581318935673,    -0.11294241571347027,    -0.14748999524943476,
       0.088482809029687054,    0.14760073668483065,     0.023270365108779643,    -0.03379549714332665,
       0.114552625535424,       0.027774280595840264,    0.16274752183204583,     -0.065529759767216547,
       0.0033623378231353229,   0.033444673452089679,    0.044189071901168983,    -0.13310514842500468,
       0.013521650122301823,    -0.0053934766821609609,  0.033467614169819367,    -0.29066649483579798,
       -0.26327773183411673,    0.0026555214643650361,   0.020141467807677216,    -0.051794444630823569,
       0.011221006201093158,    -0.15997776226016072,    -0.039698669464375086,   0.031483890032008313,
       0.09193715878729232,     -0.0015282759433537119,  -0.11587961704735784,    0.039910301780737518,
       -0.040214678802214972,   -0.071213011550260052,   0.049254904585371483,    0.014479701320090502,
       -0.05805312799271066,    0.34554763225779317,     0.08265430788195878,     -0.14277258297285167,
       0.068283110238394354,    0.20648162925790234,     0.0063544865919613076,   0.074998560719544485,
       -0.042542860269354013,   0.14116012076950279,     -0.0080538192093968126,  0.009561655139010878,
       0.058887373371354405,    0.0003867034675717777,   -0.14524564235588913,    -0.038455248859256295,
       -0.23562979356990324,    0.068679632478571701,    0.11204789284119479,     0.07479333476859458,
       0.098168612938952515,    0.14597927940471433,     -0.12728927495981396,    -0.22299783101439521,
       -0.15696500535927888,    0.054370820916760557,    0.119294550770883,       0.034292530523048231,
       -0.22567438361160627,    0.020384196170396805,    -0.0068169048600334303,  -0.1067648328820697,
       0.029611028031572978,    -0.015413156964208518,   0.01864323108048091,     0.097885695504561207,
       -0.028133553951992993,   0.029669101293282193,    -0.013628496391066607,   -0.026464814254139525,
       -0.17762654866645042,    0.10335654000430443,     -0.043870454700115025,   0.13324303918095237,
       -0.080164445133485723,   0.05532253334697311,     -0.1677798427511985,     -0.073454486406047931,
       -0.072299128933084447,   0.067899206034128259,    0.13090831841575987,     0.19047518535427529,
       0.069877055311739045,    -0.093827452705365355,   -0.10024415612081075,    -0.048694948132296641,
       -0.045197597124242518,   -0.0071554022412700195,  0.020499217866925139,    -0.19357294273434292,
       0.068506028079420966,    0.13248308312229787,     -0.027716281609947876,   -0.034274748785425538,
       0.022995893921909805,    -0.085830503880977432,   4.8752360155912035e-05,  0.049879934558861409,
       0.19019633021562823,     0.019913055728782443,    0.16451678048191817,     -0.027237414131674041,
       -0.11721692768149197,    -0.010936178371596314,   0.079909867967263057,    -0.098832113301929869,
       0.018589418945126591,    -0.17717567156780992,    0.20337396752602305,     -0.14291135680737113,
       0.09146004440525915,     0.068755574413588455,    -0.066504840519511541,   -0.063414971233119857,
       0.027294444706223393,    0.0037720010618503392,   -0.034935046081155469,   0.039792247639275344,
       0.051990709209010638,    -0.029628261479146559,   -0.01874048446899786,    -0.034167152370919586,
       -0.057188829485185493,   -0.24759715519516068,    -0.1356315401478759,     -0.068712210322296866,
       0.021811766473454425,    -0.018547451007130553,   0.075734718373399179,    -0.045817849186568789,
       -0.064126555148176112,   -0.040726084533083122,   -0.063971039789128645,   0.10611422178408983,
       -0.080668940097242292,   -0.043429243642160921,   0.068196087805296596,    0.11634167242360774,
       0.12862359307405744,     -0.12774287053458691,    0.22749601926561067,     -0.015120658544711275,
       -0.031744600119444091,   -0.032865324191750422,   -0.081773337818846839,   0.10919885218302297,
       -0.024738593812809486,   -0.030565575385827218,   0.13707273122376476,     0.0064904339747793617,
       -0.044661625052683125,   -0.18471327861151643,    -0.14877729398871112,    0.085957621663287159,
       -0.05340910503953146,    -0.10029691557059056,    -0.26004450327853446,    0.051074827461304671,
       -0.046923830902283484,   -0.0052918680314450288,  -0.13236395756309902,    -0.056891700077455767,
       -0.066471524530387044,   0.013549371587586904,    0.091569336870582899,    -0.044596914425445798,
       0.038780520455828249,    -0.12373157305257754,    0.045553528395690039,    0.084219499247423169,
       -0.17951872690305745,    0.0026133716759976552,   0.080039902927086112,    -0.1956568645996471,
       0.04422624068256073,     -0.1141428200685293,     0.16259816441443181,     -0.070425688062344491,
       -0.014599541267072799,   -0.0019424189553144669,  0.059885354956142972,    0.17812083073397866,
       0.024723664064991522,    0.028983826689728539,    -0.044585361388200011,   0.097499205567483649,
       0.23179216767164504,     -0.031725191057100234,   0.09259571739890364,     0.03710235361827327,
       -0.13175831258001031,    -0.044388428600989356,   0.078100883810037505,    0.060327533556689517,
       -0.091233535258327128,   -0.0097210423887751432,  -0.16440269418219605,    -0.01015273762401383,
       0.18384754211150328,     -0.032465271304992036,   -0.035525924845515505,   0.060487644613251665,
       0.066723851519989594,    0.10502793660339375,     0.096840217596667,       -0.08273887417317824,
       -0.0045715172067300712,  0.025726573644772509,    -0.015835597597675187,   -0.20982908088503774,
       0.054950382307644818,    0.046557209339529171,    -0.12819359510610734,    0.064917470702043525,
       -0.029138830858849274,   -0.10855256760262991,    0.27261854948494413,     -0.026669369934080044,
       -0.020646633781466129,   0.0062730180860154916,   0.098161000933402701,    -0.062450868679765834,
       -0.058410088681674757,   -0.038352232171808963,   0.12736788766395923,     -0.07924539171885181,
       0.027684220826848648,    0.064352857409326336,    0.14393771305845962,     -0.097014198444349664,
       0.076357142460818428,    -0.048679404333470511,   0.0080920538349923462,   0.13804911562214661,
       -0.059443643685920686,   0.054721806049751305,    -0.093087682086556406,   -0.17252399019479889,
       -0.060470421024598556,   0.021096937719132503,    0.029452722693481617,    -0.045007158310094005,
       -0.18507557359837318,    0.10059958039869599,     0.16927597578091697,     0.04654191869883028,
       0.0082485601017731093,   -0.17454620473024715,    0.087346084119902564,    -0.13273076809830056,
       -0.12267101989771495,    0.056239514604077646,    0.031774324164590279,    -0.0028203643106596453,
       -0.090496037754379227,   -0.033874828147134127,   -0.0095437647129860692,  0.030479315391174912,
       -0.13511775393451989,    -0.22233513097692423,    -0.11391014375628333,    -0.0017311446911142858,
       -0.20199831981143382,    -0.16688362904450779,    0.13863406900946762,     0.021084457192927421,
       0.021469245202851713,    0.02564900864193171,     -0.10107189652800021,    -0.10302144637652844,
       0.058942622696816986,    0.092006041393930052,    0.017312179857033028,    0.026046058842978226,
       -0.076551872255406717,   -0.072568757413103702,   -0.11806482202584097,    0.16105687136495384,
       0.025848019506711426,    0.034113719893316269,    -0.055567758071498441,   -0.0055251073578560326,
       0.050642751060019912,    0.13186530883590156,     0.12461526928736416,     -0.053562577285401244,
       -0.095391518881954809,   -0.056803239169958497,   0.043786809797832317,    0.088737609083044774,
       0.14216097481520693,     0.016509217233431423,    0.070319212484586543,    0.22937348259942122,
       -0.020364899217449273,   -0.1113668720529256,     0.129912366276449,       -0.081863719461692172,
       0.11464192301600612,     -0.080850116476223727,   0.079788431745224458,    -0.087333320138768197,
       0.059149152087526566,    0.026046333572966145,    0.21775704905375182,     -0.0067376408387938916,
       -0.055835208763953717,   -0.0900202224217381,     -0.12025994181707364,    -0.012358994110808826,
       -0.041929456642274536,   0.056365194725261129,    0.00046570416600329759,  -0.11146243420184344,
       0.072522217351707718,    0.089727832588055695,    0.15438678315651574,     -0.039064161831187591,
       -0.14513906739031407,    0.10918179420864371,     -0.052776186734469613,   -0.088859203756863958,
       -0.029456695251725708,   -0.011346809900671188,   0.015311523598611747,    0.03764197013690164,
       0.17408846274580805,     -0.13503806259503914,    -0.07561147968124883,    -0.006798242840374078,
       0.1182319068832749,      -0.19936344282250465,    -0.14586907048738904,    -0.099862394067511975,
       0.077498684769206017,    -0.19027057503410866,    0.0085696608706374994,   0.05570597206833805,
       -0.048704893421010212,   0.014282819043700913,    -0.057463251991271919,   -0.016797296854899876,
       -0.063871569085235766,   -0.16330750078778386,    -0.050801560651430808,   0.21380763450837442,
       -0.12692439349498041,    -0.17586957328055616,    -0.007562987657187931,   0.039627001740984991,
       -0.0050718032513544647,  -0.030792525605036071,   0.21515201378198365,     -0.12807462096743033,
       -0.032253518594035836,   -0.064186226573546237,   -0.066171215474112505,   0.0015976260622993805,
       0.025126144470110644,    0.12075723435977877,     0.079472526961732223,    0.10167771754895612,
       -0.10143248519795026,    -0.15478319105070495,    0.095536177330480129,    0.042820288775498656,
       -0.1040036338455671,     -0.11704178365379828,    0.12472761515595469,     0.03456890282968076,
       -0.1202573122457363,     0.0027592265136138208,   0.14320153929482243,     -0.056726703853396475,
       0.065786805033809181,    -0.07578427923989299,    -0.063780571076604467,   -0.27367043489078413,
       -0.017012078156128145,   -0.18874198288264929,    0.15707803746943366,     -0.18298159731242211,
       0.064216909853483467,    -0.045760446204183729,   -0.073593548791138358,   -0.024952368473536501,
       -0.12681085406534598,    -0.0023062036201191155,  0.094802016698445207,    -0.060817629058959488,
       0.023360940679093178,    0.074052861275416451,    -0.06531357506576263,    0.18083082030518871,
       0.044594732001871223,    0.013141275292651163,    0.11947655006895151,     -0.0074609799820586648,
       -0.011850539480627713,   -0.16050963844330257,    -0.026718234828400186,   0.17588059701000111,
       0.081877155232222582,    -0.012173484983375796,   0.1613312031241404,      0.12425643523926867,
       -0.10913887680559241,    -0.075525585671047682,   -0.027072452768631187,   -0.097357253732207619,
       -0.051102308874717076,   0.15077147532124338,     0.004861543486130564,    0.014362427339725554,
       0.072754115492621563,    0.10017198602488218,     -0.17240379737809788,    0.10009639567260711,
       0.022095038950006123,    -0.097041241379282051,   -0.10505651861046517,    0.13770382663730282,
       -0.019514258525547258,   -0.026047887569596848,   0.10085219735377464,     0.018897291607114432,
       -0.13138310340687492,    0.10235204196792633,     -0.034260949327845951,   0.049946615499067107,
       0.050213860202166241,    -0.01445937341809805,    0.07854361006979857,     -0.03521412060475157,
       0.049258124934458337,    -0.095704350149939471,   -0.0091916720339289271,  0.27501846162280458,
       -0.12804493994566887,    0.037093491980569063,    0.14633034395187844,     0.083363454679362056,
       0.0098794742063423608,   -0.090958100714055565,   0.039237350917464005,    -0.0041634405872674933,
       -0.055102186087371503,   0.050918463003029282,    0.0020687408622869644,   -0.079132824702493207,
       0.078056792230674812,    0.10561989129730022,     0.01288099151610908,     0.14196100654759411,
       -0.06119286819560505,    0.11636046402331433,     -0.047131362713947696,   0.0075800352992322247,
       0.085088331082020824,    -0.07819809245070837,    0.091285516317253318,    0.1005407871493534,
       -0.058735674072845051,   0.053437402501660396,    -0.034480959147022247,   0.021452008275381729,
       0.13699620382349692,     0.11156195032404201,     0.047546148073170098,    0.069113796949835798,
       0.030757458019075909,    -0.0025344897583235246,  0.09673920479087271,     0.083691204796037699,
       -0.037487299607780848,   0.04349334217945184,     -0.023773222569337012,   0.20150595789753331,
       -0.0037169344997554348,  0.03687269324688746,     0.23719297090541461,     0.090631701368079451,
       -0.085713089956949248,   0.02976121556861934,     0.10525195108721774,     -0.1445600910190688,
       -0.068935639239003713,   -0.098855747933677046,   0.084533174330499047,    0.014809424068535967,
       -0.2420333314812351,     -0.17836156592156802,    0.0049787126866601703,   0.12105228883723158,
       -0.052303623582659393,   -0.072703954517331915,   0.017519321687419823,    0.012482968641778074,
       0.10368172329697936,     -0.09893713128342381,    0.079354506230847568,    -0.0913028976367454,
       0.056408217450582721,    0.11941099851402279,     -0.050568648127610041,   0.027116552803932985,
       -0.1671879632895899,     0.054919696271638119,    -0.036175266499854128,   -0.055896933883625273,
       0.047571187074540486,    -0.055283962335698343,   0.012376787117318778,    0.095227221666038489,
       0.10666519575199904,     0.094234122904910789,    -0.10225068325650782,    0.019619555059140495,
       -0.17642832563396565,    0.044996624841915057,    -0.06513173342362967,    0.031789183156341543,
       0.074353134894031572,    -0.053713312821525916,   -0.17853494756240723,    0.091131806265272994,
       0.017896800080309881,    0.16811833748636956,     0.02330598871297607,     -0.026981111419413006,
       0.086970540065506155,    0.34386467967674217,     -0.16262095202115734,    0.016490506983357026,
       0.070350025238382824,    0.12163384836612073,     0.054508522680046252,    -0.00697309068391537,
       -0.036204930160145289,   -0.077848422177410906,   0.093530325021807581,    -0.15673771864709043,
       0.21391546834535843,     -0.01685309281072412,    0.11795533311681239,     0.024654336051968706,
       0.13417729966964931,     -0.07558227586428698,    0.09235760250914285,     0.13417853667936383,
       0.0079716853890590515,   0.078981852045482526,    0.01092815510257418,     0.0025023542577615552,
       -0.21199188186612658,    0.021366282763532911,    -0.077891783565583475,   0.095291781215951984,
       -0.0078841445668257557,  -0.10425879446956335,    0.13236976315322099,     0.01866197358471863,
       0.066668689125997535,    0.032601958075883126,    0.078332796356262308,    -0.02158505164170748,
       0.17148718646407637,     0.013940834171572261,    0.013861102972177672,    0.019536726857225541,
       -0.099883538531238186,   -0.041706705676891567,   -0.16870842968364747,    -0.16078001734662284,
       -0.018322424556429389,   0.011454111024903849,    0.01778558076088408,     -0.0069805771659841752,
       -0.15246081059742236,    -0.10922547396204889,    0.040268646406751762,    0.055463284729335517,
       0.12118936310752355,     -0.077176202054166823,   0.14432847374384727,     -0.15226232883011001,
       -0.13851342048191198,    -0.10699391973593349,    0.0029920628497938149,   0.11377107313007558,
       0.043329200486356446,    -0.073357862558263848,   0.06533501957270188,     -0.015391470316456528,
       0.047804218808227897,    -0.13025309140748775,    -0.1728105551786305,     -0.0735702513194499,
       -0.063397601990256527,   -0.098889779468454828,   0.00652663044287857,     0.34690867172462581,
       -0.13931160367699302,    0.001965511630384869,    -0.21944817848696377,    -0.092903219674100493,
       -0.01178128460237848,    -0.13791600919307334,    -0.074196620928200965,   0.23422354122673189,
       -0.098439896946496422,   -0.034846139724544901,   -0.14549169183665953,    -0.017135694786765979,
       -0.0063029900791300511,  0.09453162285221281,     0.0034796671891971199,   0.019789199434904092,
       0.0056936132786073708,   -0.14960505773579555,    0.0017244722288187648,   -0.096487023311559963,
       0.056399264636280408,    -0.077333768465973188,   0.10852787706893761,     0.058715512505208053,
       -0.064406921818160517,   -0.033006048087341845,   -0.062783396854959386,   0.07700528682725763,
       0.0046361169543295798,   -0.048551057187101995,   -0.031451796828706927,   -0.012558241173466048,
       0.071221820887546292,    -0.13288609648782945,    -0.06352240702585496,    -0.2307768747422953,
       -0.21581755245699086,    -0.040236046418694257,   0.064303958524701305,    0.062599026622859641,
       -0.17068389748230897,    0.16094980923970836,     0.12297682535835368,     -0.10084349594611049,
       -0.22176281543361714,    0.01023850662817088,     -0.018454245078332217,   0.15694882933378482,
       0.10273150408646052,     0.057555653689162815,    0.079526792925603149,    0.033726191440810453,
       0.053100568639909439,    -0.042840169110566304,   0.01416655516705002,     -0.00084948030220852785,
       -0.083918111567946527,   0.025238415110523431,    0.11780998097289271,     -0.018516807378891921,
       0.025659350793430707,    -0.019014871627489896,   0.033667379194203081,    -0.12934197887793508,
       0.071044604950668749,    -0.10379586002670582,    0.089481300707660485,    -0.10793692737674775,
       -0.050140543428527848,   0.034141875319705736,    -0.015855224294106993,   -0.067237319764018408,
       0.023731990372864442,    -0.1868380463522466,     0.10980761480252703,     0.012034615816732493,
       0.0061838813387642697,   0.0847317458930687,      0.14524490675579899,     0.0415179863846789,
       -0.04890068135099377,    -0.15712782125981783,    -0.019120056942808075,   0.18671867121785701,
       -0.039256952884643884,   -0.044033312405257076,   -0.16882397147881903,    0.056041533393826982,
       -0.018986189644380896,   -0.043824144995670285,   0.098379953098026815,    0.073866750754499277,
       0.14029917943097231,     0.2354013887422659,      -0.071307606889110059,   0.08365705903814101,
       0.068791932167704614,    -0.10710584978305264,    -0.086390557049023597,   -0.10358569872534203,
       -0.089875413375811494,   -0.020945660807488505,   -0.0054784885259578312,  -0.18411262682504143,
       -0.038848993771056564,   -0.10432890156824509,    -0.051335275211807849,   0.0031726797466955711,
       0.22718936969407566,     -0.10646603874934843,    -0.15589842234827492,    0.17335112504310732,
       0.016631248267526773,    0.07954831356501682,     0.051152218683672014,    -0.057292461661176811,
       -0.010340421507008481,   -0.069706016916709634,   -0.086445652778020798,   0.0077226402205607895,
       0.091283596205788589,    0.043683714910082064,    -0.084521311173514385,   -0.070763127541982065,
       0.046384427197149247,    -0.027703870361555763,   -0.085545857742638232,   0.022393077275456509,
       -0.14199752924851283,    0.028933453110079818,    0.11412732574931868,     -0.13097774252069103,
       -0.19366947751808822,    0.042205561377689375,    0.0259621940909689,      0.032970989423437964,
       0.087711888229701773,    0.001306972120180308,    0.0096280589353124769,   -0.029648113408862174,
       -0.0011753992847393987,  0.0051081853639751958,   -0.16527725231279827,    -0.15592279375590631,
       -0.010356206944753673,   -0.066487091361654579,   0.059459655895896892,    -0.042760849592816556,
       0.07417481317533095,     0.15795659059678088,     0.074919220946916235,    -0.24957082359552973,
       0.16266648266995348,     -0.13803883893078581,    -0.15388109652845869,    -0.11775048312921065,
       -0.021110273329755003,   0.051511064145696818,    0.20282348285378141,     0.06956386109243734,
       -0.0597991875027142,     -0.0055940209895789456,  0.14597217952211616,     -0.048581979958351278,
       -0.14784933031344974,    -0.026619347181528478,   0.22249910171520332,     -0.057371845009010679,
       0.0085953968056438207,   -0.046757997102906949,   -0.037100405490673602,   -0.083506187038864962,
       -0.061829099981878556,   0.15553225738715204,     0.061518224415745157,    -0.055412333014771956,
       0.18970217296944852,     0.084395714669575489,    -0.022792395846810653,   -0.0055061185997590913,
       0.06176700196038936,     -0.11375670579327128,    -0.017980448011100623,   -0.049784683218533049,
       0.089455690055312259,    -0.086488784862376211,   -0.092858788857213714,   0.17913406991249953,
       -0.027413835214996695,   0.027323124408568666,    0.095222533851035546,    -0.099912050224627652,
       0.030514366217671028,    -0.06556755161344742,    -0.0039937790970030066,  -0.020674509093143709,
       0.29294316288647404,     0.11045909313180376,     -0.0070096676877339668,  0.097028462102716387,
       0.0061399991687301437,   0.025599434244117855,    -0.10953613175547822,    0.071901866974875273,
       -0.13426933718972869,    -0.047261557685499681,   0.10024190234904141,     0.060064680573502394,
       -0.084639084443677792,   -0.087084267622321423,   0.11275701949601166,     0.067883742957810175,
       0.058862861979425404,    0.00044337015391768047,  0.044907890856125419,    0.040952314342571502,
       -0.039436713950932178,   0.14859554492621943,     -0.0048348509784817565,  0.054007613601415733,
       -0.14169356143823383,    0.073156112353227207,    0.0069156232294194635,   0.10321629771113998,
       0.21509249606997263,     -0.003945557769340172,   -0.067998199058502115,   0.15706166386884657,
       -0.014491772923210612,   0.050122777022325926,    -0.11440173547001453,    -0.10918101316205446,
       -0.15394383446671869,    -0.19372983900508295,    0.1766947249503652,      0.027939733628058773,
       0.14310502101487246,     0.23152345723820217,     0.13657545287041276,     -0.1710523200257382,
       -0.017877986711879297,   0.15336006889750461,     -0.099124815218865681,   -0.027530765932887821,
       0.0031934732493202321,   0.063895062898434496,    0.19297973571320232,     -0.093375769585949855,
       0.016669683836102154,    -0.039745535437903906,   0.016931302521322165,    -0.018936529346112133,
       -0.077657811150738498,   -0.084958366006286354,   0.10174433699844594,     -0.12663215066535052,
       -0.063447049247951137,   -0.031109800619822235,   0.014075273777823562,    0.10888479315641959,
       0.017052259463037098,    0.20781179131856845,     -0.012470278236970011,   -0.038683574776726688,
       0.11454098207874917,     0.030630688383289421,    -0.059210676947364878,   0.057706832819486804,
       -0.032108287042996612,   -0.0046992384289405512,  0.041270044094873982,    0.048352444929199302,
       -0.029094485562402374,   -0.071754339013081328,   -0.057724753966486186,   0.010686664079202299,
       0.049756169166716664,    -0.04409568022582315,    -0.17501251185027825,    0.013540870697978715,
       0.13091763888511496,     0.095792524540525031,    -0.10328853814768263,    -6.1753185246148611e-05,
       0.024172662532905495,    0.07040605348968855,     0.032818444898722036,    -0.058397750032853732,
       -0.045937435529729613,   -0.051416211964639337,   0.086719179691180759,    0.059957879288262315,
       0.029821936088705734,    0.12010389834485613,     0.03434785774883671,     0.16834265087862998,
       -0.27075507148059547,    -0.15104969302908086,    0.092040493157081141,    0.14912989847427793,
       0.12210714359164342,     0.17951649649974091,     -0.058167523592725347,   0.035530978001002529,
       -0.042460993436749091,   -0.12378772193478134,    0.017583565278978301,    -0.071023604077399008,
       0.034253281202257596,    -0.10911370084970999,    -0.0088626280595118425,  -0.015143649734245828,
       -0.094858110329926124,   0.082633206462432524,    0.046817051271432722,    -0.026192830380343621,
       0.1248834976601773,      -0.019503938736368607,   -0.027252150800281233,   0.19166629005660976,
       -0.000576940276993609,   -0.13183199414152796,    -0.16699307191494311,    -0.043605691762284834,
       0.135483440028344,       -0.14285610838074084,    -0.12992546951777864,    0.086536456540943774,
       0.080845963737069343,    0.027044265576229687,    0.063917193962442748,    -0.096482070637804729,
       0.10571355118178218,     -0.13143357328703073,    0.14642078407618186,     0.0066094335838376827,
       0.023711449434233908,    0.086335889433217863,    -0.041574607634431542,   -0.021488465190546605,
       -0.086549259613832363,   0.072368699501626624,    -0.05193873882966394,    -0.0059345480929747455,
       -0.0065971365392493327,  0.012135118218951151,    0.0725393433234027,      -0.091533375073933887,
       0.031127872632876336,    -0.18003399904577158,    -0.070362542904662984,   -0.086158940431575654,
       0.016575478998166353,    -0.035571704913937588,   -0.14626408008027958,    0.01315539421484271,
       -0.11924738146906963,    0.052224740705054867,    0.032013584877770694,    0.086454777953595324,
       0.14860777147639417,     -0.085325384271342578,   -0.028350769245953849,   -0.29597821305937699,
       -0.084241973115929056,   0.22251339302533424,     -0.024627943467208806,   -0.096428669597424854,
       0.086630067427549848,    0.0059343797029917751,   0.11820095719895704,     0.10321852856907104,
       -0.17154818084288997,    -0.065014447136710743,   0.069797304588162926,    -0.048436681109581319,
       -0.17185611103584725,    -0.011563089823081938,   0.20718178257793499,     0.0008881364894368568,
       -0.21207678781453562,    -0.053331031988561199,   0.024038194558669811,    -0.048308482101392117,
       -0.1558591469205331,     -0.083485681393773797,   -0.093912857406246331,   -0.16452988230516385,
       0.034728423656725155,    -0.022146402768521305,   -0.017234231379354391,   -0.16641163737959758,
       -0.14483391698128562,    0.070733349182932045,    -0.01828267831767956,    -0.21450202022082066,
       0.072176630803135314,    0.0026818682999473933,   0.12650248267415873,     -0.011931391531729511,
       -0.058313009048015688,   0.13879733981388206,     -0.086288629382968468,   0.059888713758211948,
       -0.14752892502643039,    0.014589304027681164,    -0.091690681769605861,   0.10176627735242247,
       -0.084437523849344817,   -0.01690612292406302,    0.058672438288964714,    -0.013166984327012316,
       0.044538723358441064,    -0.029216299374632333,   0.068233346768534237,    0.12973423771858034,
       0.044000355319734327,    0.0068527665326330207,   0.10247074215746244,     0.0073502975181222695,
       0.15284040902636983,     0.069288185943411559,    -0.0077978936235908328,  -0.0007267074707959769,
       0.03577500793750997,     -0.1148658033940925,     0.0087540988357344956,   -0.0598992060550564,
       0.13560660610381722,     -0.19418952515522997,    0.11593961179125441,     0.082776859630163818,
       -0.071308078868528302,   -0.068337052384312522,   -0.15652894374390475,    0.06777310790262174,
       -0.13409727802774754,    0.0766068660250529,      -0.10288070834114153,    -0.0045969605401895318,
       -0.040640483855564596,   0.063791614018808937,    0.069963330157831058,    0.11560984579332254,
       0.028857628998625467,    0.08743233984501908,     0.090626689768228963,    -0.013552013150178482,
       0.043480887922785413,    0.042940848965376165,    -0.10006626389453899,    0.097950783618585516,
       -0.066505022716024043,   -0.070399081700591989,   -0.033682810578056381,   -0.022890574553514467,
       -0.061863642715571529,   0.094937721210012552,    -0.063376033393384254,   -0.13771367817282104,
       0.26495896813358449,     -0.0038208186617536299,  0.071344121203967048,    -0.097330698012945305,
       -0.11840249406130492,    0.081215514777981057,    0.12981775071874121,     0.089142800797084129,
       0.042511064075156549,    0.067609568000810957,    -0.25460385612042524,    -0.060843953107608151,
       -0.055063738135146159,   -0.23068400769171551,    -0.11463935057731645,    0.033951910899641925,
       0.08189979019067016,     0.05819806032510362,     -0.040915559108135824,   0.0036991734604851162,
       0.17996579739070481,     0.036862842141707985,    0.0007931167803523065,   0.02269448180165471,
       0.15281626668239565,     0.017228276102345223,    -0.04107881007478318,    -0.060317632893840414,
       0.00030519789014828679,  0.08990850946744082,     -0.094118140529029753,   0.13354478063534536,
       -0.049640435767326969,   0.18221087265682639,     0.12831428257445451,     -0.092460245484061523,
       0.10709122954771021,     0.031138802829734254,    0.059897116228181765,    0.062517344502901015,
       0.018203602492878539,    0.036120867105299,       -0.097658799476672706,   -0.20518926692624848,
       0.013458802652090743,    0.17302994384548639,     -0.055291792822639525,   0.039065563234917271,
       -0.17966071419924029,    0.013617648838739593,    -0.080046227248597973,   -0.06348749223512791,
       -0.0013086912124854121,  -0.14152643131520595,    -0.089385742018767436,   0.037104170061002313,
       -0.016241407598784053,   0.030125271062953055,    -0.22188523989040676,    0.13205231299452544,
       0.024603133394259784,    -0.014846406148855932,   0.091440212771388751,    0.10573039899443452,
       -0.032099429094332443,   0.091155730634339807,    -0.17737877066129842,    0.080144543180632896,
       0.091900231706391028,    0.080253889239490533,    -0.097059118259742866,   0.17195301309664193,
       0.16600078272836571,     0.08653243809139724,     0.025075679851859829,    0.054216946465864307,
       0.12460963437493952,     -0.10866430229284797,    -0.1083704725841437,     -0.092874972359068705,
       -0.18866787178001845,    -0.18608912455097804,    -0.037801056730538025,   -0.049651900683760172,
       -0.26146855744165509,    -0.11246824932622766,    0.044651589329726828,    0.02427385194708678,
       -0.052967979000378244,   0.12534362958441148,     -0.15197082817321919,    -0.14218813860623597,
       -0.023341395166996317,   0.068012940020093157,    -0.011118985652627793,   -0.17956578703516596,
       0.0837196228896087,      -0.034249564746876508,   0.066723580235463209,    -0.047406693387284732,
       -0.040488001650585803,   0.068176984569914639,    -0.024123013108262967,   -0.028447259045341573,
       -0.022633416198937314,   -0.10505151738909012,    -0.048331683778655064,   -0.015454878631271521,
       0.024477062003139351,    -0.13510565461063162,    0.011344616364095776,    -0.069584031309215796,
       -0.094690412376097793,   -0.16965880779299389,    -6.4248439719611809e-05, 0.17707699397110843,
       -0.18040097031544877,    0.056000267183984223,    0.015320816877093166,    0.10258230316452153,
       -0.014637775496179726,   -0.029101021220740115,   0.033657087794449279,    -0.020830725654163124,
       0.028885252149598431,    0.10254471831593343,     0.12213527081522381,     0.11387473621741151,
       0.13907226599761058,     0.23403050175426399,     -0.026048078999162439,   -0.0026232202243021158,
       -0.024543491643602172,   0.12432392473912499,     -0.078651805149848736,   0.0092608339815057217,
       -0.14382408123836971,    0.12173961579361549,     0.20215470033708435,     0.080507959605562493,
       0.14613460243226645,     -0.068929149304309323,   -0.12854644956909572,    0.11140113986915863,
       0.026121925271274448,    0.20140363489239427,     -0.016426554773699857,   -0.005141983683667516,
       0.074286807601804714,    0.00038782701967536755,  -0.17969414556455801,    0.054468317218527421,
       -0.096455383512303719,   0.06594428688784558,     0.030977629476294209,    0.090836041133355847,
       -0.11036536758367066,    0.075424134917595947,    -0.055511248058253353,   -0.016463498641494476,
       -0.010117350897600847,   0.11696792636624925,     -0.025329397126851592,   -0.040604259798177833,
       -0.053943561536433843,   -0.0010960176999201847,  -0.01683583681690675,    0.0051921213438252201,
       0.17441483490165111,     0.055133910185586332,    0.009824518394332479,    -0.1562287067512918,
       0.099377456545436949,    -0.0030293623631109387,  0.11381968966555217,     0.039075583072709863,
       -0.072226645914815979,   -0.13068003571571918,    -0.055675651908174237,   0.045325107223178077,
       -0.037686715227170701,   0.091969216552859917,    0.052903875389167639,    0.069489990542076566,
       0.17062540843065718,     -0.14792792856195028,    0.16809116334359919,     0.10141908614824836,
       0.036716708878761266,    0.00034294676282925441,  0.20449841621438719,     0.19917187161469255,
       0.072949737438276679,    0.27266556707259193,     -0.012362690006524213,   -0.052168551238746599,
       -0.050238868199934554,   0.15113957727570254,     0.087997570106958009,    -0.039043524333434096,
       -0.085247183503670013,   -0.01232855509607054,    0.055299856885397632,    -0.076801840768252624,
       0.0462448480694614,      -0.06431716265874049,    0.00024419667805468392,  0.06237262689574255,
       -0.039096666509123579,   0.089768796897138001,    -0.037127472201442961,   0.082068295193906071,
       -0.014890791922970339,   0.045681982148079364,    -0.12211531942690344,    -0.040964272455775774,
       -0.032423139126403669,   -0.035951816714404269,   -0.094837561488881394,   0.31966104369136655,
       -0.012117354749698774,   0.053649632244546122,    0.06746124702014468,     0.061702648831417267,
       0.1197281885987487,      0.050158286555584464,    0.10784869317559451,     -0.13136158941897216,
       -0.025660937044877923,   0.033523848038733914,    0.24243132331428299,     0.077011189620092055,
       0.0055718204670296917,   0.07670199314478704,     -0.070675890374669273,   -0.0076101418816050398,
       0.0090522005811623403,   0.18190823470600229,     0.040032924842252481,    0.059638476758486304,
       0.022393240583408913,    0.021344160579152699,    -0.053044182705783115,   0.14306129386244154,
       -0.039210911756602837,   0.055524100051050879,    0.03700737739575332,     0.090377561574168139,
       0.1071606353715516,      -0.040082956269002067,   0.059812992548049025,    -0.15296918878331628,
       0.22365947384253604,     0.017149417644988604,    -0.13044168690268357,    0.11170036447874761,
       0.0063112259964545024,   0.17393829216385936,     -0.057864260500749817,   0.12953962221520157,
       -0.011887225933035666,   0.0070702002623531449,   0.048403674721495392,    -0.039692466227700722,
       0.11913687970968279,     0.0033260216347538677,   0.039852462247648254,    -0.067712316932150129,
       -0.18007160231681896,    -0.1226556291822387,     0.10443183931411425,     -0.00041828490612436195,
       -0.012383961480725889,   -0.096430286181822047,   0.11381995807978498,     -0.25476806654417522,
       0.064339194804161712,    0.17135421705378445,     -0.067753196904202437,   0.15625238094137156,
       0.0048799407008172594,   0.059832435467029772,    0.12575842852670746,     -0.1635435712568632,
       0.020638431849750616,    0.067123065947584146,    -0.015854408540715008,   0.07851659903863932,
       -0.16569119925355891,    0.065571617688306369,    -0.11403497419185731,    -0.14176870577639319,
       0.071068451676927047,    -0.082613059010068268,   -0.13462428035326979,    0.083467146642993179,
       -0.083640281806858702,   0.11139228414026867,     -0.10499952036333619,    -0.026744714726259011,
       -0.036736426781330961,   0.13230798631856858,     -0.050970259752663456,   0.015226523810064084,
       0.036985772118625485,    -0.15867183004513549,    0.029379516233594884,    0.12029886430910053,
       0.044239794412356211,    0.071617994905378068,    -0.055322397736684889,   0.13295387772259049,
       -0.082327794820675759,   -0.047172817200223136,   -0.021863087665356478,   0.024108363352488182,
       -0.048114637717364725,   -0.067339235348189683,   0.066279220638223682,    -0.074156646838076531,
       -0.015796937138002967,   0.026581421480418754,    -0.026663416985835783,   -0.16928477841338591,
       0.14502204801207752,     -0.14587422467573888,    0.012781287921510839,    -0.037696741872169044,
       -0.049333587934501676,   -0.002284543026972877,   -0.048340724209851853,   0.16242601185500671,
       0.044270474817132782,    -0.089731146609179871,   -0.11986255144553024,    -0.026266476859130174,
       0.037811214521378034,    0.018896577363400294,    -0.025163200665011865,   0.11655530465464943,
       0.14234456408437174,     0.11502025973164347,     0.0679424184799335,      0.09558043383130839,
       0.12833884241006766,     -0.022511641431967468,   -0.15794216704710048,    0.077292925775586357,
       0.11749254052970932,     0.05791656269335306,     -0.13725174920715663,    -0.035938155910408526,
       0.097908687280098786,    -0.079039256180746031,   -0.21550556903637325,    0.096612982645519069,
       0.17293848090572561,     0.17363379829208794,     0.13952504383363454,     -0.17698748750140639,
       0.10286256073200989,     0.048203148248110159,    -0.036587593364378161,   -0.039565604088074219,
       -0.025837033245621362,   0.089356069102843591,    0.076547095670525284,    0.17783670860506037,
       -0.029692743510683517,   0.092638021468534795,    -0.080598030384325017,   -0.047580843242036111,
       0.073076488374257523,    0.032679129568205595,    0.30538179897691892,     0.12331480507613835,
       -0.082828754391386664,   0.094068574873568775,    -0.10647819612343515,    0.012754166979194771,
       0.0047394612043346329,   0.1712204816985799,      0.049308875556001906,    0.12258081161091508,
       -0.055668594935464728,   -0.13254221433544455,    0.12982712993799389,     -0.14194489332291932,
       0.077654872748476517,    0.12409206210774974,     -0.08108251447879275,    0.11136363776141193,
       0.066706446572435643,    -0.050358188641391181,   0.012389017002505338,    -0.0098453717867252408,
       0.10921255018982742,     -0.052965633099476259,   -0.24573158138542414,    -0.019757710387117718,
       0.15406627442454804,     -0.087316638790516918,   -0.076473984454836413,   0.18428960432656163,
       -0.037744474991373643,   -0.06173545046983616,    -0.00046865650369140891, -0.064311481858949721,
       0.018892373865779664,    -0.11956003659667831,    0.075379267473776698,    -0.085888393498039714,
       -0.11613918595208346,    0.034076453051170484,    -0.014459450033966212,   -0.15497638559462679,
       -0.12142490775182969,    -0.17258420183314771,    -0.036912010025328658,   0.045596296723897534,
       -0.09848051399226139,    -0.049344912572340277,   0.0027048074893949968,   -0.14386306242699312,
       0.081367716420651715,    -0.046621243068175985,   -0.16177335399157444,    0.066032359337419827,
       0.050705858631592084,    0.018730864959806769,    0.049723817827143448,    0.18039176098495763,
       0.10142389962480479,     0.074785149571905699,    -0.17884338141619688,    -0.02706084567767696,
       0.025792241598974683,    0.070264559226917364,    -0.0763832177135748,     -0.11446811480122089,
       -0.087905635069989371,   -0.067234035113294482,   -0.053620889724704655,   -0.15360102465970868,
       0.016747724047963684,    0.075743428379055955,    -0.10959711465955363,    -0.063487843421715318,
       -0.011141069601868413,   0.02635090043804484,     0.14205416666357659,     0.084252595792967414,
       0.02821500239868481,     0.099428146461846625,    -0.074724530592348182,   -0.10146132391792254,
       0.025556457944020453,    -0.066120819598848496,   0.11845890153022325,     0.062871807028146126,
       -0.26737233557820245,    0.013813818161109829,    -0.12972166415847292,    0.081143956713525534,
       0.010248277560356055,    -0.014186656731106981,   0.0042537955452341169,   0.1012071079744368,
       0.058859870103749067,    -0.015108068866197278,   -0.019873821488743001,   -0.061467043721621602,
       -0.047159895104235128,   -0.061101753249349695,   -0.070156945194404352,   0.045814671872231184,
       0.059766280625839281,    -0.01341519957650307,    -0.12765760096895823,    -0.058038071746876703,
       0.04749889342731585,     0.18632669032630494,     0.040868519021646288,    0.063476888370023951,
       -0.10264247589500339,    -0.23435130690623807,    0.13131427047966424,     0.0047936327742365697,
       0.16135421648913925,     -0.19741899897883805,    -0.12528308020568693,    0.039219312978504624,
       0.022082501307969581,    -0.10734937796853433,    0.055516406906456275,    -0.065602695690427246,
       -0.10130705525697702,    0.025078707853264198,    0.015496727980543339,    -0.01148189743883473,
       -0.084131900081461028,   0.0043113858629416071,   0.15114540616589553,     0.10969189175151338,
       0.074585913395542228,    -0.031048063040355112,   -0.031018492798722944,   0.0031536476683811194,
       0.0039591480151425756,   0.09281053068300929,     -0.066350172569046476,   -0.0076718720136890444,
       0.045866203266348084,    0.31956605370254398,     0.026382166230368664,    0.10728891585131754,
       -0.056147839389190594,   -0.12800820519403178,    0.021097597455270685,    0.0032705301563353932,
       0.039643790690833972,    0.017265221089694447,    -0.11484835553722213,    0.045340692841744731,
       -0.10443305495860919,    -0.30175017854341851,    0.18899536809493855,     -0.0019433983826411122,
       -0.015807095590980216,   0.10694679932940269,     -0.092533833465745591,   -0.18553941913376371,
       0.12443568395391259,     -0.014780239639709569,   -0.055148396881929101,   -0.0089260946014952415,
       -0.033931853047559024,   -0.097212424189970434,   -0.14850174289781085,    -0.11508503863741712,
       -0.067085665146845663,   0.013300439406318457,    0.043596265056385267,    -0.030751951063164799,
       0.0030556377849592009,   0.2270226721021176,      -0.0062904372701593908,  -0.066864038965824379,
       -0.049814913793211874,   -0.18190895364358425,    -0.12010807466522201,    0.0097766093694097722,
       0.030181636938033642,    -0.10488056518103304,    -0.03429296054273881,    0.10681199388279609,
       0.030568510308568164,    0.16952665710154599,     -0.03053388477597441,    -0.040036484451604216,
       0.069600581509520879,    0.0074087791206919433,   -0.066447664045232391,   0.047331662253566192,
       -0.13456315241499406,    -0.00079202493645497661, -0.19183606763312488,    -0.068997220529568346,
       0.022892270995135702,    0.038571000486926958,    0.046999578593781018,    -0.079314552341887029,
       0.027339325887078037,    -0.10664913936990333,    -0.13056622881621269,    0.018271732334728719,
       -0.0094899021143482996,  0.080737281880734507,    -0.11035399763513089,    0.014246506974041116,
       -0.039665815334256921,   -0.03723624744638715,    0.19206804454599782,     0.029145253736704152,
       -0.1620226535549201,     0.13589311832475048,     -0.13687978750955093,    -0.16157673178318316,
       0.22998889684094931,     0.060974060044941929,    -0.13886082019288828,    -0.048911097733717233,
       -0.11440061320276032,    -0.013175221263952992,   -0.13751212878355179,    -0.070939657671893266,
       0.014558415757448068,    -0.0973174478309419,     0.023801367299026537,    0.047536687505739333,
       -0.035594734123143935,   -0.031355921418437988,   0.058910015355203085,    -0.049240935240161127,
       0.25889153627781514,     -0.013440181600516075,   -0.14703464334304275,    0.0057391053626038146,
       -0.028523790527909394,   -0.048189685679353077,   0.05980755306486138,     -0.018885409582231567,
       0.021561620359756943,    0.07766353557641173,     -0.11390372700823467,    -0.15486451958591399,
       0.031217647177038493,    0.18187180152582982,     -0.15520287749452613,    0.019640671657742179,
       0.045419934820379058,    0.048133639792534141,    0.14928716717846011,     0.085813498216449166,
       -0.040641309790311546,   -0.051019770366422544,   0.071040738546147633,    0.11056391580728732,
       0.0073790061864543212,   -0.12338186929298513,    -0.0033440290067878698,  -0.13968756863452006,
       -0.079381942643431125,   0.10418717090924737,     -0.056500995753811928,   -0.11114348789234048,
       -0.074782428306875592,   0.15069592736580775,     -0.023417519007338419,   -0.052577336850268594,
       0.038497504561486276,    0.036736913065074303,    0.01658880723836469,     0.045964851500175104,
       -0.21237945574723247,    0.0050245157161658682,   -0.023032299915217616,   -0.075429714370925161,
       0.06658829602356664,     0.069510506811412978,    -0.090134243814690568,   0.035485032059378217,
       0.10153230955131559,     -0.092525984357107863,   -0.13127762719014507,    0.020211329298715674,
       0.12156935810711494,     -0.019596524665851042,   0.086961908964173232,    0.068344331183352466,
       -0.15466544006415567,    -0.13395101982027216,    0.2253619415028042,      -0.012937722820152769,
       -0.034201290849918436,   -0.06188740087998592,    0.085072413890582579,    0.26402582177191042,
       -0.11527788083653194,    -0.069939569283745812,   0.0026943576178369913,   0.020980403867679073,
       0.056554189707317834,    -0.02497581694316367,    -0.14499445603693897,    0.034186139115863212,
       -0.10351110090934157,    0.16700872355818205,     -0.026920840830827422,   -0.14102848023264813,
       0.15382428531848852,     0.037142192037456133,    0.22059258056920331,     0.10954255872805886,
       0.10213109813885811,     0.047115396817307094,    -0.094130440901933149,   0.03400233098809833,
       -0.13107460679001209,    -0.058721717857635053,   0.017837305217611808,    -0.23690660182755668,
       -0.096755752988318372,   -0.02717893406852824,    0.096837354069291379,    -0.079382444427157028,
       0.0088059283171027583,   -0.16260505451322441,    -0.10804564984316385,    0.033992813096120775,
       0.04072527827666321,     0.02157351088066967,     -0.10522735595799285,    -0.061857392617205839,
       0.018803889447225424,    -0.1644289247853197,     0.12562033674754744,     -0.19130953161715089,
       -0.08128753753687519,    -0.0089143891838888521,  0.029445216934309411,    0.0047863553552251088,
       -0.062222569580903636,   0.10940480795616855,     -0.016273782399116914,   0.037508182695567473,
       0.013543601500009052,    0.023719898029239985,    -0.055095701523195546,   -0.058417921714078516,
       -0.013454909444920306,   -0.055166382259618299,   0.054806893485631065,    0.044227708944684967,
       0.075762986808683375,    -0.066284681823753619,   0.020643611549092597,    -0.021999931513532571,
       -0.072761479197711212,   0.068350706454317858,    0.14143098391367012,     -0.07507525536327643,
       -0.050248360655232971,   0.051166545477584521,    -0.18223255747222314,    -0.044008554398643741,
       0.079684453137387784,    -0.12472664906638108,    -0.0031580792868984788,  0.051620993011177618,
       0.22093972833073233,     -0.19082260488683531,    0.030978100331469464,    0.022798214814510897,
       -0.042931696753127593,   0.038445337028047276,    0.030727891937496643,    0.11846028964449497,
       -0.023793662710166488,   -0.0026098071759302231,  0.0012127791474175614,   -0.0071605354831628248,
       0.16103851791294735,     -0.018010039337630936,   0.16933983348839618,     0.016475217960633202,
       0.10952384962701885,     0.049246892417307488,    -0.19623224713754953,    0.17926639523595511,
       -0.071202152055160742,   0.12169134629427136,     -0.22872645229906147,    -0.019846283049045118,
       -0.019703666085726698,   0.058305390547126759,    0.2201036370052423,      -0.12410933356669783,
       0.062704405756313794,    0.043048551289343727,    0.099896540227835964,    0.11631088605821492,
       -0.075884447017750586,   -0.062694300611494932,   -0.097733748106599044,   0.10040932115061696,
       0.11839998923023692,     -0.028987205637773277,   -0.061069849596609271,   -0.10233532563168418,
       -0.010122605391841628,   -0.0033584229880458966,  0.15655778609524013,     -0.16087875728437834,
       0.030225793636312549,    0.058990934157939712,    -0.11299480769750476,    -0.056758572135809919,
       -0.14999715357266197,    -0.13387281496394252,    0.053977840954607531,    -0.084882906170019132,
       0.092408463633195742,    -0.11771290799219711,    0.047585678493669306,    -0.051022699750158787,
       0.18060885283957234,     -0.019011356778316078,   -0.048098121150288345,   0.24949212411507438,
       0.056857814739003087,    0.026738856160900007,    0.11692564088759358,     -0.082434637358287294,
       -0.1753415130091264,     0.069461066124955229,    -0.19734777636128245,    -0.040294588733704208,
       -0.071300329627415976,   0.065124173861244819,    -0.19453354022736299,    -0.14621021349928323,
       -0.024071032466516928,   -0.086312832037057932,   -0.083448843430099992,   0.011893529472600315,
       -0.089238316973290446,   -0.064069223197077599,   0.16459244343279536,     0.17473773951651356,
       -0.0016962469689048424,  -0.055057583796948167,   0.020354468121665595,    0.059532549881308738,
       0.0054433011414467096,   -0.052194227662231876,   -0.074568116393661343,   -0.0023376315700802917,
       0.0096464518946350955,   0.00375999502696844,     0.10307920732413223,     -0.009564365403351302,
       -0.1709295326212241,     0.094982488068272058,    -0.10596582821468548,    0.085274616215009424,
       0.021759430569045838,    -0.081178857903501295,   0.030997156927711465,    0.020957403849543504,
       -0.028375146271416275,   -0.13107047415670306,    0.020737610539771838,    -0.050165395358010102,
       0.1013440263969104,      0.044065468627466936,    0.011229166664414841,    -0.25208996003291712,
       -0.00027533209220461513, -0.031571811805069322,   0.10249107637951246,     -0.13732649238191336,
       0.077157135871418425,    0.21696810536289446,     -0.13469388585469094,    0.0088419077788377837,
       0.054909913924301668,    0.068524188630329635,    0.11474859779676944,     -0.0040266906946320007,
       0.065523808752263213,    -0.16418519930272873,    0.061235241627192308,    0.083783992815068459,
       -0.045762065078410331,   0.020501591989952425,    -0.0054910241732902942,  -0.073406600496200763,
       -0.18188042379482541,    0.008473863499617984,    -0.18628353016094762,    -0.11396992310013912,
       0.072086247345749407,    0.13074207712782332,     -0.0234868736462771,     0.11132606732747431,
       -0.075774233728304607,   0.023040982146480954,    -0.13556985912111563,    0.13465553239243896,
       0.085157905534503808,    0.057650950090789632,    0.17237983380390479,     -0.050071080307025506,
       0.10599315273970016,     0.16351878437340148,     0.040740450239569556,    -0.13543433466266258,
       0.037839811453131741,    -0.16572934872056372,    -0.11225534029944179,    -0.0173890153477314,
       -0.083137955227220617,   -0.1002498282444209,     0.077059011458726109,    0.1596489639911694,
       -0.04917170973352044,    0.15978452815244498,     0.23620244149882402,     0.029736933985235709,
       -0.044890271613133803,   0.054502779869211523,    0.088981938681148412,    -0.034268846179838483,
       -0.11855341459460038,    -0.12263875703564157,    -0.033583721039479583,   0.0072128290426316712,
       0.14961171650294841,     0.02123687406452162,     0.013189307571497211,    -0.24089926413909035,
       -0.086739994954317556,   0.16984556819049598,     0.0032597042704690447,   0.04888353767872336,
       0.063289342321669273,    0.0042131886365903912,   0.21302283229192684,     -0.057085111910365319,
       -0.11399180102677081,    0.12975208094909563,     -0.10763904022153263,    -0.043292196703081778,
       -0.040285145761922984,   0.19198564286015227,     0.12188526186088386,     0.089280044607260037,
       0.015074928891151348,    0.040756272085042157,    -0.092979309642493457,   0.18284781543996231,
       -0.028200535820210006,   0.033131783419625582,    -0.016884253708770485,   -0.0024888057515554309,
       -0.043838960012162739,   0.080477806195738591,    -0.015595890719473331,   0.16221429707720955,
       0.0019632831947409488,   0.1390799381186093,      -0.0050264341661740413,  -0.065149683701679145,
       -0.11131889240460556,    -0.023116005583648389,   -0.042498389827807355,   0.010390976605591937,
       0.24196195979586504,     0.050758517231110904,    0.048957141516791265,    -0.04724404872354545,
       -0.15850392536399369,    -0.048335426018940281,   0.08462300793072812,     -0.082634270654423719,
       9.2014775142484559e-05,  0.021967946375528607,    -0.13671189011386067,    0.025772286750264918,
       -0.13471126042973347,    -0.0103628031804733,     -0.080572189181376624,   0.093713479592935856,
       0.011603742275684784,    -0.064475429992571345,   0.076074528781178929,    -0.062563250814489199,
       -0.07983702938460302,    -0.099811786630541091,   0.0464085131958226,      -0.11116163384500369,
       0.18484068760437128,     0.11223607069193435,     -0.18011649999506932,    0.028989611453779159,
       0.12356753535049327,     0.11438369073355856,     -0.090553709741736377,   0.20147614388197671,
       0.03531353497871375,     0.053840997237923439,    -0.13009457378880143,    -0.10006713621306045,
       -0.10722951070067643,    -0.18200721730176372,    0.030998699443957691,    -0.012550256736443412,
       -0.11181227169769609,    -0.0016928352221563959,  -0.16528344767867725,    0.12515339689170177,
       0.12763483722604232,     -0.12864208003772357,    0.1290085273508309,      -0.0021636570227948925,
       0.031806624148627581,    0.03195587925242549,     -0.068804824407415588,   -0.076932873921734882,
       -0.13322260273435924,    0.059710755364830427,    0.073821997778816595,    -0.12099606184831592,
       0.13219925089304588,     -0.12797899017779496,    -0.0083014500695258297,  -0.14951552445230734,
       0.073171623992518836,    0.02820442659510582,     -0.11512214967011412,    -0.076131223292470004,
       0.029311360171802733,    -0.081670370341425255,   -0.085314473586677417,   -0.24474220195414123,
       0.053516477145301965,    0.027338908006891479,    -0.07048386891438202,    0.11012326458333824,
       0.12209534171571422,     0.034744755760238749,    -0.02103144270686215,    -0.09153847661986661,
       0.0086950834918224258,   0.058476794891159131,    -0.049431704723763299,   -0.085353775091099551,
       0.012775262217626595,    -0.13269869403578571,    0.056134235900685989,    -0.11278423866924783,
       -0.18148044361213367,    -0.024161280243964522,   -0.055945474525468893,   0.10969738430420357,
       -0.025331774017240682,   -0.001025809541081082,   -0.054306269234565073,   0.037874306492085889,
       0.088621827769420999,    0.052913490924620686,    -0.032962968402076451,   -0.0069253491099993542,
       -0.23348799214748783,    -0.16308586850490045,    -0.18901974407000238,    0.074334064736199815,
       -0.14361512801783655,    0.089899805045185313,    0.15875250174968694,     0.033493924856713091,
       0.055250802930548674,    0.0018509076814906744,   0.0044546593207841515,   0.015482005974677669,
       -0.16155769394935809,    -0.066510501565882313,   -0.0093404703121003907,  -0.078062556970842342,
       0.074615792607825138,    0.02485331462808375,     -0.11486329008280904,    -0.035694180267536312,
       -0.10768412595646801,    0.05412651950868478,     -0.097015276488584962,   -0.11383478624393734,
       -0.01592584028497103,    0.11178887810217798,     0.070753333476550287,    -0.0016074709955478015,
       0.075422714910282407,    -0.081081462985412217,   -0.039620503468351692,   -0.11089047815745988,
       0.021768412547670618,    0.071034972365118368,    0.0088814282980898118,   -0.046487204137932989,
       0.074322605779129386,    -0.10534198214081739,    0.10868740608894327,     -0.18379485340416662,
       0.068493065195778663,    -0.13542919214394078,    0.092837497736118629,    -0.0051031410082862869,
       -0.043301280220860397,   0.17577198272335684,     -0.085763294017554864,   0.00084418523749310928,
       0.040478864808857484,    0.020774126158279751,    -0.0077186181684654812,  0.12851654167406193,
       -0.0015419835373088747,  0.031041702538602115,    -0.18291587154565994,    -0.12502555830193743,
       0.038504177028576794,    0.034266755429241701,    -0.011084889622298236,   -0.0033674791142950314,
       -0.10462607552627122,    -0.082313658094486028,   0.0066667440827604041,   -0.002386320170450225,
       -0.27938753659248167,    0.075918039932810488,    0.056008464325716732,    0.054072987261134117,
       -0.25969797537050415,    -0.033032643343086816,   -0.1371914330152034,     0.078179984162001961,
       0.15653678603609905,     -0.13500470479757495,    0.092735194054978154,    0.050318347953852718,
       -0.060230593676281106,   0.020268898223972289,    -0.067068556224209305,   0.11967185174540451,
       0.038192054447580642,    -0.076836573737994171,   0.074666139947155499,    0.027121588526804449,
       -0.15708021656976459,    -0.092969008198852177,   -0.15510988141052781,    -0.013160448579089126,
       -0.035375609560100642,   -0.013748951985952209,   0.11765538864870224,     -0.10023287421791571,
       -0.12592439201489569,    -0.15206972559957979,    -0.045451069738872356,   -0.046481253944750237,
       0.0098883471965849346,   -0.16010686417663644,    -0.17596583889102607,    0.089103635897210404,
       -0.11992022208971462,    0.0023931554282702085,   0.078794483969638868,    0.0016782705895112583,
       0.064092770048476078,    -0.10014974149412326,    0.083270028463120774,    0.065904794807128853,
       -0.1506711786935776,     -0.1095390579203501,     0.045848928290711383,    0.14258729494990155,
       -0.23164084582986619,    -0.091097695783184357,   0.10407729719295504,     0.13352280615941106,
       -0.086388390953545696,   -0.014863367710150892,   0.16003079704701514,     0.087263057639379318,
       0.018905521637042219,    -0.14411175229906106,    0.011072679453253045,    -0.023468481263330586,
       -0.13114003690113152,    -0.023051451855286786,   0.047097686239665607,    -0.044079186544159273,
       -0.10483496684204519,    0.26431997251428002,     0.16461610215555703,     -0.063832096713865791,
       -0.14344325807837677,    -0.16374839915925146,    -0.005464030776320186,   0.1776710433343458,
       -0.11027192368444165,    -0.00081220444502650172, -0.091627717913760287,   -0.041329674454694036,
       0.025163066632950412,    0.1852904686566848,      0.039045518192909912,    0.0066396416531383107,
       -0.090497785244941148,   0.011890965161710473,    -0.075698544784612062,   0.00046989234276300328,
       -0.035608504245396959,   -0.0087060970763208848,  -0.0056936774302281754,  0.090531343502001552,
       0.064331171969620363,    -0.096973753888509706,   0.22070031965253312,     0.1658777159551981,
       -0.11468694910159907,    -0.11641056293220681,    -0.091916118703928129,   0.15206532625784877,
       0.093499792563631459,    -0.025000924935899574,   0.11857616905403484,     -0.063251163993362267,
       0.039095229773099038,    0.028122266209018313,    0.021272055749919926,    0.040923939616833827,
       0.081085727110223799,    0.13911689085114981,     0.096387509974669675,    0.031949741636770286,
       0.21687221716185476,     -0.078191417479271913,   0.0074319735994075892,   0.13120641309670983,
       -0.047674312044987732,   -0.050334565598466392,   0.049719563691277752,    0.053897863735454771,
       -0.16231806485770989,    -0.042432974419206029,   -0.084662214270174077,   -0.061307789883940124,
       0.0051423151224453323,   -0.069163541008611606,   0.10611781206903012,     0.12187173815140649,
       0.067051717966122928,    0.20113947831268889,     0.082496287566977522,    0.027191242660716371,
       -0.07562994542775596,    -0.11494215907616474,    0.00074914342291665587,  0.017691306011458019,
       0.023435212806837562,    0.10203896840532276,     0.04879425510639647,     -0.21202618605046983,
       -0.062167927990862099,   0.054193630756956532,    -0.099234986701477054,   0.045112434746649582,
       0.16293766696622655,     0.13072242348566304,     0.052716919237166447,    -0.039783097177614635,
       0.058001906193703233,    0.082910336898384424,    0.097312704545959236,    0.05873998412077315,
       0.047877548994818026,    -0.052517731161593847,   0.045813468701175114,    0.013332484853595668,
       0.106869820659652,       -0.070817478212303442,   -0.065667476851378512,   -0.058848659406184903,
       0.1700226285799816,      -0.062609936537007818,   0.09081563221478306,     -0.12626990778354796,
       -0.2239333543436148,     -0.027259099623112282,   0.016076611044784313,    -0.014420335368887009,
       -0.13632675746884521,    -0.079806972642044727,   0.067838021539566321,    -0.21009725907777466,
       -0.10466889473053348,    0.10983397680357496,     0.0034416570332567475,   0.050730673563931149,
       0.12546547933042951,     -0.087165445333273958,   -0.016189888294712733,   0.023383888733778748,
       0.18076606251041274,     0.042016429018361966,    -0.053641454203964767,   0.2561551694804558,
       0.11607186876487263,     0.02045342059134489,     0.0025599606017155047,   0.098305899886161979,
       -0.020984208798740859,   -0.09249040592761526,    -0.091170497078134127,   -0.12410919767324137,
       -0.015602339439249607,   0.00864279577241228,     -0.020910205592370532,   0.15502418845849608,
       -0.04187957812806669,    -0.11212045745350642,    0.0082698595941578107,   0.036745326725682807,
       0.0089253836104025777,   -0.070378127087398087,   -0.028193394196419475,   0.088420536041411146,
       0.02206450182014235,     -0.0018129368672883967,  0.0043068035102929803,   -0.051449584216715791,
       0.018160189536660123,    0.082850487872254588,    0.020126209755627726,    -0.048626373627967359,
       -0.00974174523301676,    0.15624443579984465,     -0.048846956529527738,   0.00089420570131747417,
       -0.064517554741426092,   -0.11687933636370554,    -0.084962786185510702,   -0.070140503141478225,
       0.17634218893867817,     -0.043495094615254484,   -0.034182200796004543,   0.060913632474412449,
       -0.21352529882582383,    0.019272324051348193,    0.21118994398446556,     -0.043355726794518192,
       0.13302866006865413,     -0.10593771903052744,    0.23882925286783802,     0.12733386045471895,
       -0.044637062096251512,   0.032052445616821475,    0.0024573923435223127,   0.13347013825738194,
       0.046453472589606061,    0.069954983394813888,    -0.068905930398063253,   0.12397752922647917,
       0.067966403939024769,    -0.011415707082957301,   -0.11149022440898115,    0.0083044024579011031,
       -0.074964648866845007,   0.035329905557343305,    -0.093049247520085671,   0.241556045202065,
       0.15874347932644309,     -0.066787980126094479,   -0.12088136554093273,    0.065394760413789707,
       -0.12694791985271831,    -0.084637700501518559,   -0.090963864467519154,   0.090628325469960358,
       -0.070994249999588116,   -0.062256364357544426,   0.14742585750335688,     0.03797040327395796,
       -0.038761171154674451,   -0.063889176215705626,   -0.028048435227349337,   -0.022382885607716164,
       -0.1222587664026185,     -0.11099510195818912,    -0.25887463845961495,    0.0029076408340314125,
       0.02986169726063384,     -0.11939200174172783,    0.11005115855331965,     -0.054880196730833185,
       0.037869303154039732,    0.018301373026520101,    0.10250304253321937,     0.12962860662430348,
       -0.10991389693997057,    -0.014874228932760056,   -0.13092204807937521,    -0.082930727986250827,
       0.13470048085615374,     0.09141727269795015,     0.096521694309186876,    -0.13697457871737259,
       0.07805730313540768,     -0.01961164496574027,    0.17583723303486254,     -0.068175676253702452,
       -0.090328645753498416,   -0.012195300893566399,   -0.031313422257856986,   0.12940001814889152,
       -0.15217999374281055,    -0.11178984942513595,    -0.012825587366600612,   -0.1305490747772326,
       -0.061381082372630416,   -0.034543771867903444,   0.0026761501337017137,   0.063720760743645397,
       -0.098451034649992261,   -0.090911904746858702,   0.0095328694438553945,   0.12648133397390623,
       -0.011200209247801528,   -0.052917592980221598,   -0.016057492926989676,   -0.03553491912164386,
       0.042827586785439596,    0.092672075845334489,    -0.090744850618200312,   -0.23569712447715735,
       -0.020537850390475197,   0.35880064234215336,     -0.095685308889764523,   -0.077199237191602169,
       -0.019508825683842275,   0.090328319931849324,    0.10536330674558364,     0.054625954144576702,
       0.20974012214269394,     -0.21085374826176462,    0.0045221457963293922,   0.11763142697538244,
       0.12142750731096985,     -0.040972919808539725,   0.015483024723098711,    -0.034005332041152296,
       0.025375882355972212,    0.12966932627842548,     -0.033357704133569137,   0.022064745806995394,
       -0.032065118151430913,   0.074410071004925513,    -0.20303485553147588,    0.047731869990364502,
       0.048908797435782546,    0.10347492534326667,     -0.013673851141890474,   -0.0053651097227167726,
       0.01355413366099857,     0.057038984722015892,    0.015271878256763854,    -0.15556582647323378,
       0.0058832175974194972,   0.014337946756116111,    0.050615602568149856,    -0.14556106846760536,
       -0.054716768573587551,   -0.18851301896711536,    -0.1195718357478027,     -0.1174475399974952,
       0.023055904181198485,    -0.00014105645277777184, 0.063597324785364728,    -0.058298194927477724,
       -0.044203044306505068,   -0.14368573327907078,    -0.11276586837695421,    -0.05395414514370557,
       0.059223626917555602,    -0.045657251890584241,   -0.050334604719852086,   0.072702279250830518,
       -0.11677638783517222,    0.10762275558150657,     0.18507632181181663,     0.006638697915138941,
       -0.023785038246229646,   0.11351100731270593,     -0.055590417360886615,   -0.0085860804479077138,
       0.033095816538810524,    0.15357746561679383,     -0.09252131515526639,    0.043080491187334244,
       0.12455077034450057,     -0.1070337234511122,     0.0018052190219406763,   -0.083674444401077783,
       0.095261372252993595,    0.075027731311665069,    -0.042400840252659562,   -0.058137575362146358,
       0.045054995759520051,    -0.082244138914995518,   0.0020852062895836739,   -0.039048729534008217,
       -0.070639544463356088,   0.26945175865461368,     0.054571460562910248,    0.015916913361131473,
       0.099368711997387615,    0.051004250975555769,    -0.032226666969770959,   -0.062959483176177999,
       0.08835758831752738,     -0.029664183093690195,   0.028055819561109415,    -0.2967756358816232,
       -0.018725580831173216,   0.023028270549506628,    -0.25694310286256838,    -0.044228499049619181,
       0.1025035164982597,      0.045360264982003268,    -0.17349785536037454,    0.17877996638903668,
       0.10799746167956284,     0.079761455514012175,    0.072171250441170912,    0.06259020273237742,
       0.026975157487111039,    0.094527018247887229,    0.042661762082819972,    -0.12151362811638294,
       -0.03934923153366477,    -0.00017367800437111743, 0.20931316759558211,     0.031114437047393431,
       -0.032721243858057678,   -0.026115096549130676,   0.18142777951482353,     -0.032092350168790321,
       -0.045927016675573994,   0.034717775475794549,    -0.039292915206065392,   -0.078072080045259937,
       0.021206987925640901,    0.05674571231112166,     -0.074438287280413754,   -0.13633850450738472,
       0.034291117654962025,    -0.076333416730129763,   -0.13325575987782631,    0.10675901435502443,
       0.14722813987727762,     0.067696614875775982,    0.069586090319187638,    0.011158420779666707,
       -0.12584418461950919,    -0.048718772819106984,   0.07325437401774508,     0.038418100212349447,
       0.16346145536042878,     -0.090136446579244786,   -0.12286298636107247,    -0.028636154562698014,
       0.036333652864698425,    0.12214971751575714,     -0.074042371555304798,   -0.060053476386262364,
       0.10432717617441778,     -0.05240916924288417,    -0.22889008963943383,    0.15563719954873723,
       0.046572467893826582,    -0.014644808176462317,   0.080649212598529654,    -0.13894647073515215,
       0.16435500843375542,     0.1152070822419147,      -0.043158241656282563,   0.0023751778788560548,
       -0.12841599760935699,    -0.046502179531085527,   -0.12077826713517459,    -0.090739805128610754,
       0.010733815846102562,    0.065241992681173158,    0.063274355703655916,    -0.00078340112608858963,
       0.1045981591158319,      0.11252125607818179,     -0.25238004095678096,    -0.12717920219357973,
       -0.074156246291142411,   -0.051857337494953935,   0.070079890570234338,    -0.04451393357685849,
       -0.044704353479831163,   -0.034113204212609827,   -0.17094380220678743,    -0.00036707807446279862,
       -0.0062590015365885186,  0.020708535923056513,    0.09194863047908676,     -0.0070482295269961338,
       0.046708402294911668,    -0.0033179646693263839,  -0.042805944662247221,   0.15192126832905092,
       -0.030348852133501043,   0.15147200435582392,     -0.098823345859980177,   -0.10194712143605998,
       -0.021481867064797166,   -0.080833358238247055,   -0.12249460123804659,    0.15537251533226035,
       -0.0078026642465968089,  -0.055852185320492714,   0.059441012094631526,    0.17229924755695009,
       0.20873574491309915,     0.085060618341912489,    0.23743965757035251,     0.0019558518161962492,
       0.21023513492994644,     -0.073468964622024027,   -0.031712526419305137,   0.11282077240390702,
       -0.03581449120099342,    -0.033282863785428496,   -0.15017022317718923,    0.064530049475996623,
       -0.028436794260588923,   0.045228167026481095,    0.19718317954018807,     -0.077983803315537573,
       -0.03660494054440358,    -0.081811910753556927,   -0.20961466347220523,    0.072086807785024992,
       -0.0096523598728411233,  -0.015179017031412001,   -0.005514919733258402,   0.11880323943221492,
       -0.052314281005513309,   -0.10183250335416483,    0.0060616550477375665,   -0.15532091294414926,
       0.08473132820939018,     0.11731748234415054,     0.077527181376412388,    0.11090119734239672,
       -0.22480914397570273,    -0.049280962744189832,   0.13851989730939107,     0.078006201006717485,
       0.14544165810396023,     -0.15139644492185578,    -0.028439709650521991,   -0.029714696290782334,
       0.034237603126464712,    -0.0051148222785300868,  -0.043805977216887913,   0.15485449348919939,
       0.04738305710691372,     0.00038502354353241348,  -0.084453807171959452,   -0.0047400725518131279,
       0.19054953060331614,     0.0047963822206179944,   0.010425676127375653,    -0.064146464540716625,
       0.025934495994860411,    -0.031927085594296939,   -0.13327841344794975,    -0.11079238059797197,
       0.07663933944154587,     0.07361349295457939,     -0.0737371889757443,     -0.087663698819224034,
       -0.12876596960324449,    0.063829606335852468,    -0.059763006177686671,   0.031875444582974553,
       -0.016698786629686411,   -0.076525159082090385,   -0.1758866375662835,     0.010349134187178755,
       -0.081702465834614518,   -0.1203509355790529,     0.11974984143793339,     0.048092918237590626,
       -0.18178830970208298,    0.0054894834084235865,   0.056798301070173203,    -0.087153785550857579,
       -0.070439122968420032,   -0.055262983614760001,   0.019523289712091715,    0.095987468694985187,
       0.12700853010570512,     -0.06245413736386906,    0.023839241111499675,    0.052957161446989656,
       -0.016208282535092575,   -0.0022928318409218707,  -0.057580669081454532,   0.01071795371257608,
       0.28567774994600592,     -0.030108865908372882,   -0.069192270433744457,   0.023869067633102561,
       -0.05203603325288652,    0.044555196677373531,    -0.067634255223264203,   -0.019302190846514671,
       -0.40193944049718228,    -0.075511254477344442,   -0.051581411741883888,   0.036029521122692976,
       0.092931012171867777,    -0.05563433347621826,    0.076389193058420554,    -0.0066649315698193504,
       -0.064386413411893301,   -0.057583950572956358,   -0.082389957856203191,   -0.019973093267944993,
       -0.012460963617567196,   0.10439059889708734,     0.12398375664077134,     0.19647385466764258,
       -0.0058034824689836648,  0.1420748250899872,      0.15612313453813437,     -0.07951752688747156,
       -0.0030128596396397237,  -0.20884505542590995,    0.017887506623042074,    -0.09673557396428184,
       0.027082744378502013,    0.009487184243459023,    -0.09742019075661415,    -0.0087912053466851457,
       -0.0013689677782020493,  0.0011756415926451906,   0.088789148249708835,    0.10694808905656047,
       0.13847142177387536,     0.02258861296693299,     0.045089886389089735,    -0.092611584401401117,
       0.077575379037717995,    -0.22885572679808763,    0.086903263049857529,    -0.0087381676599210777,
       0.11406583612077405,     -0.039654584137532999,   0.014671922812745859,    0.10421896796689906,
       0.011196341464228144,    0.091144177288023667,    0.090962648731699305,    0.039758876527627079,
       0.06377582244482885,     0.14271073585648719,     0.015793052245239209,    -0.092918245066723817,
       -0.13636649472565704,    -0.27455562491070901,    -0.0112328629348742,     0.10474462956267105,
       0.14169705956936357,     -0.023518936742776535,   0.078102700535565922,    -0.03619711191577505,
       0.09268799974757741,     -0.060738798618811901,   0.091051498128929501,    -0.047331762402618473,
       0.048594966851723244,    0.058147397506394687,    -0.0019122441220101065,  -0.034494905311008787,
       0.079227236881902377,    -0.12985992389980061,    -0.02814022565044251,    0.0012458940511343771,
       0.032345614521103405,    0.061332600012882661,    0.065802784856389379,    -0.081711602118763979,
       -0.14880208852658841,    -0.096729664520164543,   0.093753610835988072,    0.088549190233013067,
       0.17417018434694087,     -0.038320174547412274,   0.18048208918434394,     0.047346615788306567,
       0.15754461032212547,     0.11731074158401439,     -0.14641917639328417,    0.089543653915129626,
       -0.12294909541199645,    0.015228973901243175,    0.038893650347344731,    0.015475414632338586,
       0.028892534885754884,    -0.15638783563602085,    -0.1010169266341817,     -0.013689203387430337,
       0.0087920122623588587,   -0.11368689735908141,    0.039798521249426365,    0.11933175458195368,
       -0.04643453506218545,    0.039647247670124217,    -0.14165596312776904,    -0.15132180823384503,
       0.17301586043351777,     0.17205627605651577,     -0.069928586218945335,   -0.016691068188927845,
       0.089951142484367877,    -0.0091875866033880645,  0.024911529929864284,    -0.090459904460886253,
       -0.068443298864146435,   -0.14210032413994755,    0.023052293205746616,    0.056104235511943649,
       -0.014250921759650705,   -0.066887885869835961,   -0.020099710874315783,   -0.22646995245309559,
       -0.091485775072407169,   0.2329707222858439,      0.24651551546621217,     0.054493861353094954,
       -0.011452600275738661,   -0.1575986558395967,     0.057911957481426544,    0.16887505201939176,
       -0.0096825318220117897,  -0.079714471075654963,   0.0060764993424030096,   -0.012243354464813339,
       0.047372023625175036,    -0.0026944829442024968,  -0.081294538166837252,   -0.062653065362996446,
       0.10624435250403241,     0.071754432425338369,    -0.02492797703661849,    -0.076826949723052276,
       0.059268626550659259,    0.0013675499190037399,   -0.14918110800457754,    -0.099502614095872868,
       -0.023953042997846948,   0.0011765254986438431,   0.015458587386265451,    0.1247488097519084,
       -0.12010370899451371,    0.019383201512372043,    -0.11510347707181941,    -0.015383542205592047,
       0.17869936706364009,     -0.051206975297404096,   -0.03510016437018363,    -0.15631162404740895,
       0.15958115718869836,     0.0067930334185714262,   -0.025079258381210865,   -0.14012390893030896,
       -0.063695597659641931,   -0.13979414168574816,    0.017070303473553091,    0.031686861349512631,
       -0.060021707484407653,   -0.016378892602067409,   0.17149414726881121,     0.11152161802991629,
       -0.15612420463907015,    -0.11048908638388705,    0.19193147362468635,     0.072845620313907997,
       -0.037278053973285701,   0.044507209074963805,    0.022545152259099196,    0.15816995215065394,
       -0.11905150081541725,    -0.0004905419910696796,  -0.053125256989932909,   0.17619028121517549,
       -0.089421092506883737,   0.18240499678670738,     0.1258108369981692,      -0.063371896622842483,
       -0.15071657236861927,    -0.18772114142160759,    -0.042980668316989941,   0.11337010622920715,
       -0.075941358348481203,   0.060725060299435474,    0.08045498480858479,     0.15066108422127161,
       0.155385631594984,       0.17782588831599919,     0.039826452783848304,    -0.17776477790285233,
       -0.018476937858315307,   0.034434475770688942,    0.064068122360975768,    -0.0051696651560193436,
       -0.13132774056874919,    0.11564438878165519,     0.0098134842311175668,   -0.1256733747646448,
       -0.021942538864519676,   0.047707049818754392,    -0.11569331028096567,    -0.057908772584502659,
       0.053995666794902988,    0.11929139660257,        -0.20485926798074297,    -0.10239672088317878,
       0.097456997881285506,    -0.15024570919177013,    0.060808539004021771,    -0.0072392357762385076,
       -0.060602865141604477,   0.044067412551258789,    -0.17240261136007112,    -0.048607692617860396,
       0.11059622835557466,     -0.13895535197356873,    0.024381967644333011,    0.080413574072861316,
       0.04820053852270309,     0.086440815868950652,    0.049750934030384025,    -0.061286036135323387,
       0.0038302931161184389,   -0.16086522284316904,    0.091108168220684307,    -0.12431114401052359,
       -0.054586191795354962,   0.016599394492116167,    -0.11715102401950071,    -0.080438939851874405,
       -0.085598784654173934,   -0.078567407427368646,   -0.01716004899097643,    0.055837290119694828,
       0.095028028628047906,    -0.05289833063790518,    -0.096021043545936269,   -0.066955353332080247,
       -0.13505295337801859,    -0.13149565567114144,    -0.080524247027250917,   0.10075446513387212,
       -0.069985656747699604,   0.099809705898754431,    0.11498649287497721,     0.078988528925092547,
       0.09918694762965051,     -0.033152957913865702,   -0.0039242140514299953,  -0.02561623419472393,
       0.0061416699314387237,   -0.067004758027676248,   -0.052780268984863668,   0.12258128689893251,
       -0.03182117877152086,    0.20564722258956711,     0.016269421194494954,    -0.10569552203406053,
       -0.045203673199506834,   -0.076657445024670506,   -0.069135462820349408,   -0.10081905977037309,
       0.168698083851305,       0.031521968805767679,    -0.046423240133202051,   -0.0017973377336309108,
       -0.041160688422295748,   0.12714787261402061,     -0.089522957165491815,   0.12136735058889545,
       0.0053539479293583494,   0.021623371351418411,    0.025898680157002269,    0.07916484315392544,
       0.028116166448033237,    -0.11637274859781507,    0.12975782150823703,     0.0095355794834988024,
       -0.015293401546749888,   -0.075734905880445347,   0.036054448373176798,    -0.16405557548303931,
       0.023818716614081484,    0.013170375088446346,    0.084618392004938356,    -0.075473946694005312,
       -0.071076937083786873,   -0.046152512513149169,   0.036254039359211558,    -0.076531088214560131,
       -0.02050267078426295,    0.13380309994979878,     0.15763540041952773,     0.025815901446305661,
       0.010428045939426107,    0.11991509282346317,     -0.088184947599777311,   0.05534742473086781,
       -0.019413006761484962,   -0.11136592329823371,    0.22144474834274519,     0.012856936061476816,
       -0.071008627259164403,   -0.15544334400337881,    -0.11898702391452283,    -0.19732405191153293,
       -0.058074360854293045,   -0.11973199675514379,    0.088123316282908398,    -0.097282527141166683,
       -0.048855173350497105,   -0.066423852911243308,   -0.081682703345150973,   0.14149465441016773,
       -0.11950586644432999,    -0.13577101945370304,    -0.12804076049909069,    -0.022019681020943288,
       -0.16228007402171615,    -0.13160453814488887,    0.18941935773349539,     -0.12157453640260492,
       -0.01403385284814891,    -8.453596633991407e-05,  0.050136575694567122,    -0.20874007692147295,
       0.14592289667161149,     -0.14353782889912092,    -0.062675507665927527,   -0.10396094406290758,
       0.022554648070267955,    0.093619040044932086,    0.0059329367496466189,   -0.056900839418684679,
       -0.079038889149434272,   -0.033472212652671654,   0.13143671015101641,     0.026793917738300515,
       -0.022851964920640531,   0.21706897085104088,     0.072083956364241406,    0.080085955993111801,
       -0.10460103077733016,    -0.06860531355699416,    -0.12948134620594617,    0.20168072592526343,
       0.086297219175999695,    -0.23500131406850258,    -0.011537809601283304,   -0.0049727032944361692,
       0.023366239446778462,    -0.077985917964916995,   -0.044578233514143757,   -0.021748859399387692,
       0.15750786474222225,     -0.082888055342049405,   0.024754938169069797,    -0.069287879008835387,
       0.045055250197394724,    -0.0026354738316813012,  -0.11759989486108305,    0.055902485782387198,
       0.080952245506179965,    0.082200623994032482,    -0.019053950705265311,   -0.1062514034584103,
       0.011960316316292416,    -0.082330903226580127,   0.0045682398075574688,   -0.094367161185493237,
       -0.045802638994132845,   0.11896732031274811,     -0.15024854978931426,    0.026837166185612198,
       0.049467662603606674,    0.011215905984377297,    0.12495634220986213,     -0.053946129999291728,
       -0.034724307373550027,   0.099789749265495387,    -0.01506698754850128,    -0.12438165474634548,
       -0.0090330143065396815,  0.21377681131892357,     0.021879623099576355,    0.049577362303486312,
       0.0057498522023137176,   -0.059003123572364993,   0.10852091017283141,     0.019949923483235502,
       0.14198466779615876,     -0.020364124939560586,   0.041898766648719707,    0.061582116913755723,
       -0.070611514429922514,   -0.051907127305946696,   0.085455825158292448,    0.015230034847789811,
       0.027242309734757292,    -0.14944964922165047,    0.19609377765173583,     0.12885196485378489,
       0.097102235521661875,    0.015339328400403722,    0.099535960802917225,    -0.047487333461835632,
       0.13599195531071551,     0.038275184300658238,    0.093924187256339581,    -0.14830308835917325,
       0.14296540314701894,     -0.021572546602739811,   -0.076723293339770363,   -0.056516950724151055,
       -0.017442683397756734,   0.109242302168251,       -0.011712381862983151,   0.12609473651018513,
       -0.073222515940184821,   0.054070525501871719,    -0.083880519534565615,   -0.18785776997046624,
       0.0016612339950325236,   0.038209934075265788,    0.11536909056782611,     -0.18087404389256007,
       -0.14754498135919997,    0.080950606625685803,    0.12410934744769421,     0.03482789480506375,
       0.13689012993931088,     -0.10871649153870645,    -0.1472629587754673,     0.27591928579476072,
       0.066127059399691032,    -0.14198133541326813,    -0.14636041745678849,    -0.089224281261096258,
       -0.026149946008362589,   0.095185127277047935,    0.053608043290329421,    -0.00045551500310003074,
       -0.023643933962155281,   0.035094827045512735,    -0.018455306291281844,   -0.14516863766460761,
       -0.018817993371854559,   -0.007264482116160877,   0.018701596080051376,    0.09892027786153694,
       0.060439628412151281,    0.051006851715831199,    0.04868185307297241,     -0.16928675295548679,
       -0.17375639567032378,    -0.022908146845533096,   -0.042775075128693697,   -0.30376770405720599,
       0.060135994524906478,    -0.04635774905547093,    0.079533025067709054,    -0.10515885734714581,
       -0.15239964935249137,    0.0534745100091732,      0.13504409366655559,     0.060532121379726696,
       0.028892509227911263,    -0.06735617734223702,    0.032633793302259108,    -0.064075240726941748,
       -0.12482976636511975,    -0.11442360852635325,    0.068657462572193947,    -0.034357168297758631,
       0.041000172044832993,    -0.18245360870708593,    0.093885447041782519,    0.1247492916108852,
       -0.087866878098400492,   -0.008415224403575389,   0.052308034846901878,    -0.003399849393984159,
       -0.20897259308834465,    -0.016829938055520095,   0.07153624289433945,     0.11091920112526707,
       0.015990120758797938,    -0.060886016672436358,   0.13742091385085642,     0.025433072205581587,
       -0.070194495076851937,   -0.064408193837316358,   0.099483196509409413,    -0.085203106908975715,
       0.026584098710587502,    -0.18057733294603479,    -0.043972526229030341,   -0.14024571357694754,
       -0.19494049695989238,    -0.001905195258068229,   0.072323738385579373,    -0.02975343021565631,
       0.081952286057432017,    -0.15957864613748363,    0.10317108551391505,     0.046388817073680047,
       0.051831478198980596,    0.10335370792279255,     -0.016462979716995507,   -0.026360221700125003,
       0.050485431895211617,    0.10293485067032193,     -0.016583509077023034,   -0.086831345085247577,
       -0.069416972284223222,   0.020837117829192512,    0.038883196318705709,    0.017749053974568,
       -0.1407258250422492,     0.011681512044685398,    0.043408575966792318,    0.024037033698183306,
       0.014153618786032829,    -0.10958828919993228,    0.12396989135803246,     -0.045992551374491063,
       0.049907968570821193,    0.15045981204905268,     -0.13893114666000492,    -0.074967651205086749,
       -0.016465839290166651,   0.11195697319583629,     0.22313129994214487,     0.12762283554709253,
       -0.079105680928798952,   0.042399101389044638,    0.19783823659676722,     0.29349777728868071,
       -0.16196171703077264,    -0.018192022993123877,   0.12596624458399561,     -0.035502242983442574,
       0.0037558643279006353,   0.048162886731134898,    -0.0080698894843643492,  0.088036255091566665,
       0.016482006901439705,    0.16422818118437177,     0.033546011184422304,    0.050176361418704282,
       0.060683351874960698,    -0.017042639146793589,   0.050805689333173164,    0.056636512687287956,
       0.00037977806232936969,  -0.027909469639745933,   -0.2968552716103276,     -0.022921817526636148,
       -0.0090908322768258661,  0.1695886144636847,      0.054418837956608887,    -0.097177277469701534,
       0.039871084009064139,    0.18635952473449158,     0.079664098067116343,    0.1153225956922678,
       -0.066592852562633753,   0.07729303497632975,     -0.10178310799460485,    -0.10124214558835587,
       -0.13570168014578288,    0.034983209108632909,    0.1298097809673539,      0.12427748394284661,
       0.078171421474420189,    0.085014659848037799,    -0.20677882225935487,    -0.059786922602455231,
       0.076934173903857733,    -0.026569747612106821,   -0.012329306766189665,   0.12522919600250082,
       -0.010794283562456066,   -0.078757507485555517,   0.26386047129283108,     -0.26087262070034251,
       -0.043708294213298644,   0.14895523755840626,     0.025448924268080583,    0.057734654547499625,
       0.095781712430320423,    -0.090798074875809445,   -0.024375489960930998,   0.027449906840969963,
       -0.18688301291332746,    0.0042924806186877985,   0.1385445371402268,      0.20747056721734075,
       0.0094992915212770042,   0.17492879040153908,     0.043177176273598475,    0.017200586190247467,
       0.0051003906147025976,   0.082534414808851264,    0.022440009954171558,    -0.21437237184722799,
       0.18097965880545766,     -0.0038697493479993347,  -0.097817396788921707,   -0.038253944538677226,
       0.081842629644002823,    0.079188878431430229,    0.050160849799685603,    0.085521817710440276,
       -0.047786232016911435,   -0.064688404882106199,   0.20548206824772589,     -0.039168423096801186,
       0.034727670683599506,    -0.002795469478305215,   -0.0023257017863187145,  -0.14691107343740636,
       0.17975096779761812,     0.14781047495652044,     0.0062572124229959593,   -0.075469041729550115,
       0.030710477817187457,    0.016835797342508396,    -0.022113452819762212,   -0.0933895338156394,
       0.071882894837961286,    0.013646673082462292,    0.024800453749685293,    -0.11108125606555588,
       0.030726548457975435,    0.043430974578803197,    0.072220449375331244,    0.17894856835838505,
       -0.080618482744771763,   -0.1511138055047396,     -0.025829529629996007,   0.07195394067097037,
       -0.049099512863052891,   -0.091175479572358067,   0.0050620396603154247,   0.038532209860496283,
       -0.059100653670844841,   0.011361244785945565,    0.062768076389298405,    -0.039985811071214052,
       -0.054726751298830562,   0.055352361457718602,    0.12657263368174784,     -0.073587492255478032,
       -0.14072791632845852,    -0.012579039199833383,   -0.0098063254910809097,  -0.084036859637037289,
       0.042622572080562159,    0.050559837179814951,    0.046997371091525734,    0.1366638574561353,
       -0.045478706355411833,   0.0027642322448997447,   -0.0025192610547850932,  -0.10476896980451836,
       0.054690599074099386,    0.1744526647770977,      0.15077408696601921,     -0.2494013461587099,
       -0.1324958782022124,     0.016945303416876476,    -0.041740502967086562,   0.19714108571926731,
       -0.011963074295101401,   0.085031820279874798,    0.055020505474679189,    -0.05872316493260598,
       0.055224268073950096,    -0.06656777832168588,    -0.054767189037076107,   -0.14137504705116036,
       0.19780526106703372,     0.19826671538534713,     -0.11665370853715033,    0.004224943350429132,
       -0.12582299450989087,    0.18515469279002836,     0.081265992222894906,    0.12170163690353408,
       -0.026477194048553341,   0.043622076474581099,    -0.11132803043733447,    0.032700452350269096,
       -0.049421710423403008,   0.000841031395132248,    -0.065656177263347756,   -0.10374873159582862,
       0.12188943343767476,     0.062451612841212853,    -0.02001035466235692,    -0.076113618911215875,
       -0.11170100870945612,    -0.0085032255635856552,  -0.097858085444720411,   -0.12634389813488942,
       -0.066898674240185474,   -0.10621679865743126,    -0.070726733330157152,   -0.089909779730031433,
       0.029554551101612994,    -0.14111661037149389,    -0.057686894199419803,   -0.028593896399338785,
       -0.06700253339283227,    -0.017965846605643866,   -0.025832792553413721,   -0.13478259554091465,
       0.002091748978814408,    0.12903448025344649,     -0.018232768682086363,   0.026249569012318459,
       0.085740631298192843,    -0.018080412222976579,   0.20805684008245159,     0.025743145595692705,
       0.095412119874233203,    0.13482697363941606,     -0.11690621535829711,    -0.014017213690700612,
       -0.13092190496536366,    -0.025789660425398115,   0.01468530216582075,     -0.14814722853063747,
       -0.076818167570350718,   -0.05734044170656686,    -0.0016071688132606845,  0.059151939513623283,
       0.15511940519630044,     0.061609253038246714,    0.041085555843346194,    -0.177251117680266,
       -0.06584391542727569,    0.14600764977643371,     -0.1014120438014661,     -0.16021153439054198,
       -0.21264822235441033,    0.14556571215549466,     0.038817666927737193,    0.034174279189287421,
       -0.016837642690334265,   -0.11185335991010502,    -0.025382102899481999,   -0.024750720856226878,
       -0.0075649691418129827,  -0.10354634110323721,    -0.11940332247767836,    0.048301777387489191,
       -0.084252348935060728,   0.09652426927558376,     -0.12297203970857831,    -0.021411535958126011,
       -0.026948182307346531,   -0.0029238064469896408,  0.1286344593865725,      -0.16792550473102338,
       0.061203542478029727,    -0.089080596828906178,   0.22097199364653991,     -0.031253020590658279,
       0.2300096097744915,      -0.10852308586329207,    0.035360298441534842,    0.17226044130496349,
       -0.029915726032946489,   -0.085609787144646204,   -0.18014757442066415,    0.17548362109902779,
       0.093609748813744648,    -0.096260948575432756,   0.12302532430460628,     0.084832241633024302,
       -0.046051709679572742,   0.1309740189006654,      0.18897646654667227,     0.020213836220187083,
       -0.12562066256144933,    0.053239966148517025,    -0.054031448234348994,   -0.0001740100078571373,
       0.035540125424134518,    0.11354278140210951,     -0.037683843664077704,   0.10506251715756594,
       -0.087197613585573389,   0.2413625255774639,      -0.04783137480096071,    -0.20209451056966712,
       0.07788031411205594,     -0.20247576227299313,    0.044366264077683966,    -0.16320824487897687,
       0.057152698190627113,    0.082888828839802142,    0.0277890271919321,      -0.021898179703547623,
       -0.047174948782236305,   -0.025442870577866167,   -0.13334342608583602,    0.045089566574870288,
       0.043108671367101642,    -0.038658666922987882,   0.14466642219986406,     -0.010085473972867805,
       0.045583946337587042,    -0.059293394258968797,   -0.072056297631008764,   -0.15697779271511902,
       0.054251863436067985,    0.010988624538845956,    -0.020227269207036127,   -0.032009072193156268,
       0.067564276497982578,    0.097746858479788298,    -0.018368847476125737,   -0.051187332387211917,
       -0.13983034146916395,    -0.11244006491671336,    -0.003484824830805781,   0.027026439072519864,
       -0.0051302200822064443,  -0.013965029209091824,   0.19160921319200142,     -0.0028559756810659157,
       -0.013854136495681804,   -0.016978879259325771,   -0.023272155032417658,   -0.092870707324205756,
       -0.014454082206312169,   -0.014516355607670652,   0.065229634554794663,    0.066185595546206177,
       0.054097972437079825,    -0.012223147726550667,   0.01891709769015144,     0.080456016269015385,
       0.16155679775533138,     0.08898404459228447,     0.10287196270656249,     0.044781530253249185,
       0.05002948268499878,     0.019600499029751247,    0.13395532685071737,     -0.041702501499400371,
       0.060260847079106943,    -0.15856786610961784,    -0.0060561495449739794,  -0.029697691213861083,
       0.16606221882858102,     -0.051993523727711891,   0.16603355028437908,     -0.16348178075741765,
       -0.1534265444895421,     -0.15082424442109538,    -0.061238452921684526,   -0.18458729145977548,
       -0.076635105163438966,   0.0080553144166130471,   -0.024896339175250776,   0.018777697439223633,
       0.0069026255432657457,   -0.12751055969020539,    0.047235311487893408,    -0.13060646779948432,
       0.012467690894908592,    -0.067395798465822943,   -0.29673720009589188,    -0.085664635645168852,
       -0.0073718308346673728,  -0.16150159790087776,    0.025607545987274324,    -0.080733534549275288,
       -0.037839360058322641,   0.091064273965578021,    0.12582488398972588,     -0.11514616050827872,
       0.28492170021166519,     -0.076139733162665993,   -0.031140049317972571,   0.021284710891455932,
       0.035139283313432593,    -0.06399387242588056,    -0.048610938760055247,   -0.046030528118061055,
       0.01716763782479349,     0.09805202922727034,     0.19549443411637429,     0.056687256673851182,
       -0.14165320494834685,    -0.12006634479428098,    0.015712909323153244,    -0.018402233110633617,
       -0.043117622707071118,   -0.037726567157430835,   0.15100329912270249,     -0.0072867760828320745,
       -0.14166995816250014,    -0.10830464589799195,    0.10183223922885166,     -0.046149271605954854,
       0.082394229683539461,    -0.028087933859794866,   -0.10997145970130609,    0.0035242014735591028,
       -0.021638102186733666,   0.037539807295055766,    -0.019494656160495082,   -0.052463327149550425,
       0.10672112023800631,     0.016059990569059081,    0.09378643131027839,     -0.071013776821651206,
       -0.027256677974856293,   -0.090294109670201503,   0.13411616096351889,     0.059855768788019445,
       -0.16047123248411069,    0.1134450199754761,      -0.0096035333741374875,  -0.056342852327339328,
       -0.084965714008784832,   0.18334477343342645,     -0.055551098452520015,   -0.074357263505821614,
       0.18418631567248372,     0.060560995883415764,    0.087587013292431348,    0.03857790691482306,
       0.14239060859949537,     -0.039927131922415891,   -0.13777274648048074,    -0.07162457381933858,
       -0.13986713926905125,    0.075202069365843838,    -0.13340481707148091,    -0.11824932573411373,
       0.098984224287692005,    -0.13560120298155345,    -0.041655037879878974,   -0.10299144562950352,
       -0.063791818791772703,   -0.045951486302984727,   -0.18046098143302777,    -0.042138027417174359,
       0.0012556159435057215,   -0.069628633121385702,   -0.088064557986727215,   -0.08144264364456659,
       -0.049912316441566698,   0.034115392460334924,    0.14148521969852096,     -0.020896148458510726,
       0.055640438925936592,    -0.043739781169942239,   -0.023071578183532594,   -0.041057731909013927,
       -0.082755568735998167,   0.065219803429739084,    -0.04733148442601158,    0.028894092441463105,
       0.01281142959396041,     -0.18550083548927904,    0.11049426062634432,     -0.19535130196771283,
       -0.074033048541761889,   0.062751857036570283,    0.15024409393452845,     -0.031644588381962935,
       -0.10304493444680417,    -0.092498890334651931,   -0.02500449215649788,    0.023483475739393654,
       0.00080517360788980377,  0.038708196085884279,    -0.11751129300656801,    -0.026663190978466762,
       -0.031020415461664733,   -0.08109774965667628,    0.080859621956625688,    0.091082374163413596,
       0.22581200993019562,     -0.021791302185767771,   0.034401914381208112,    0.14947534410257726,
       -0.084116358034384331,   -0.026303094023878617,   0.020771961908443489,    0.14899435153147714,
       -0.068377425522810342,   -0.12090540212335775,    -0.11157357034660241,    -0.13339780329755452,
       -0.16866580168084241,    -0.021195282805332161,   -0.053085755092423553,   -0.079064753438706351,
       0.086233023693247618,    -0.14347870151178319,    -0.0819364305934982,     -0.1312700499928586,
       -0.088812558117002852,   0.06548363539129036,     0.026040334749334294,    -0.070169527128415066,
       0.020616228934013679,    -0.045725549854049745,   -0.048481686316783755,   0.032959731671788776,
       0.0048459839222082151,   0.14168112283399564,     0.05443515825732452,     0.16145075513732438,
       -0.2086485271690485,     0.071392842417126887,    0.087462145280224751,    -0.14341973781902065,
       0.10344726764092335,     -0.048947533581923927,   -0.053768934346798483,   0.15749698834063836,
       0.063572286127798819,    0.077661787319937739,    0.32268657916960114,     0.054473233087966616,
       0.029556636373792446,    0.0084265922835596047,   -0.078126281400326458,   0.10886149239369035,
       0.068513410180657319,    0.060973820704091707,    -0.11076791273108262,    0.011934674275101474,
       0.089559673746053364,    0.077745276856410583,    0.077697854116448861,    0.015459748448584254,
       -0.02241543762007343,    0.08411460126502833,     -0.11012548676692063,    0.018612681274041944,
       -0.10599135281222911,    -0.041896888254503398,   0.041723127617367586,    -0.14144050031245439,
       -0.20802261356137258,    0.0016903520081319786,   0.075252717899124411,    0.078359363302376236,
       0.14842874506557624,     -0.13456898261650094,    0.17316205852199665,     0.096580658626547952,
       -0.020374393537205673,   0.21288891444743741,     -0.11171450821932964,    -0.12644461751748526,
       -0.044847755442028757,   0.0019544015186662936,   0.058217219899802324,    -0.073963045869635036,
       -0.16067438244871587,    0.087920703535479081,    -0.070575599516467427,   0.11876818021574931,
       0.057649822911235084,    0.028998558618006706,    -0.063028606378834132,   0.0056392448530700199,
       -0.0057403638361983797,  0.048290242407996856,    -0.018746465873641406,   0.17000469188792283,
       0.03308575712178842,     -0.011184992885957994,   -0.024935793346944755,   0.013652615518974237,
       0.029699187214782277,    0.039092090186187332,    -0.030877608589597483,   -0.33762297431556354,
       0.075917478664582511,    -0.073938324528656521,   0.013022715506266044,    0.055687531472939943,
       0.035210838901726396,    0.0069687294382352718,   -0.024968120094255492,   -0.055786893471976455,
       -0.03155708478052939,    -0.20393750368812952,    -0.07906737903008422,    -0.0038338200089628035,
       -0.20028449938571521,    0.027743159941814258,    -0.046846789307236972,   -0.059999652605609334,
       0.0094306440313625985,   0.23770917022324115,     0.19562903579532084,     0.12772555659031234,
       0.091780540510414385,    -0.18567235310346908,    0.012227546477695139,    0.12691567204988102,
       -0.12605145889564551,    0.005907263928860625,    0.051897682141735763,    -0.05179308226475924,
       0.027251786311979449,    0.065873367140936931,    0.072045586902711581,    0.10378538266982325,
       -0.20616472186047646,    0.076945042798517757,    0.066727901690863484,    0.12947120294092462,
       0.19168612702722024,     0.030879055189112624,    -0.00932549403170135,    0.10859594249067807,
       -0.061323454890288093,   0.045062378935236361,    0.0056705909152415749,   0.13239050583430897,
       0.023867463117815315,    -0.12778137624558403,    -0.049456567442532365,   0.10456968692648309,
       0.095874314908437702,    -0.11276369589120201,    -0.016089768259356593,   -0.0081676949488332234,
       -0.034136037049064025,   -0.052360225488982746,   -0.038351033573456636,   0.22369302597682189,
       0.16413934365340974,     -0.038010609016091913,   0.10994808967275742,     0.042022366552923726,
       -0.072159369063958728,   0.19983143065893283,     -0.049104113699202326,   -0.0099540950766593955,
       -0.097284979929959964,   -0.012382638676723564,   -0.098573744213932904,   0.0458385832546599,
       -0.097244230737292339,   -0.060899641673516421,   0.0053479089432982834,   -0.019229467160842846,
       0.1631707475358887,      -0.05634420764134597,    -0.069280526801944811,   -0.10786964912125879,
       0.054135104711077457,    -0.08398094946085051,    0.15684811792601275,     0.041494060577534075,
       -0.1368016450174302,     -0.084199874354719248,   0.058283601393169682,    -0.21855127099670169,
       0.058859638823984858,    0.12672187254875686,     0.0041265537740931054,   -0.095261863398291222,
       -0.05761613275610674,    -0.0033388244226205009,  0.17298752972324194,     0.098802109908919425,
       0.069650501706227427,    -0.25155792566839191,    0.075046462543184339,    -0.015642796086734453,
       0.052829374518464728,    0.028856620690174438,    0.050816986046333751,    -0.05948293529626892,
       -0.037991066768275211,   0.051187644424343627,    0.062575103064145071,    0.047468928256241161,
       0.0058862072807108088,   0.045838321798077175,    -0.092618978146001701,   -0.12998255712383919,
       -0.068705956121516726,   -0.034377484886271389,   -0.057149810625616027,   0.18613664648627348,
       0.052456272662443099,    -0.04618037311836682,    -0.058525201270265004,   -0.10306429670963324,
       -0.022831935505524398,   0.052638786134042943,    -0.0086540409075143692,  -0.013543269602428134,
       0.037425201243826124,    0.047626151986625842,    0.10589091854866534,     0.017796233026487064,
       -0.14633442800085913,    0.043796304957543566,    -0.0058570471561591878,  -0.029456904867145549,
       -0.28755076176740918,    0.0035997818811605202,   -0.072738214637791412,   -0.17422886070931437,
       0.13522866833675681,     -0.090194143438931201,   0.049475076341552966,    -0.089089411152015865,
       -0.15538925931362499,    -0.074831630219649004,   0.061060878239923809,    0.071037798713941211,
       -0.12289856073230147,    -0.1353011829674966,     0.15366595793490317,     -0.16983668399324042,
       -0.043036597078596098,   0.030833971815215883,    -0.0095823712513763721,  -0.065080589604849762,
       0.01719335737962098,     0.12656431012371058,     -0.21809575453935565,    0.023470355796232335,
       0.068007700483080469,    0.070946439636431949,    -0.052013983673267795,   -0.060746207802205271,
       0.0074030361907920159,   0.096176556358816154,    0.074339832974582326,    -0.17900550752000005,
       -0.025181166412739486,   0.17714354519797476,     -0.069384075715342844,   0.00044765523816088753,
       -0.21411256567195946,    -0.040126540965478963,   -0.0098327062681883605,  0.067760069919614349,
       -0.10327482388150139,    0.0029352365117924963,   -0.13951738908679032,    -0.09162964924765149,
       -0.15110958753324802,    -0.011410758760731709,   0.13150369168063089,     0.11615673192401285,
       0.0050830164030453602,   -0.19518550426214717,    0.0038387710244592362,   0.13595314850337359,
       0.091791182765382742,    0.089241684608377544,    0.097766288856060132,    0.018001602026781551,
       0.15677237249733827,     0.015570375421395475,    0.023616068118687699,    0.11317792117756115,
       0.027739164439801282,    -0.013819796706085121,   -0.0037029518536975834,  -0.048228867234411527,
       0.10731083740661859,     -0.11407040553234166,    0.027251126869099928,    0.002479187281140785,
       0.02783690745122832,     0.10700834384851549,     -0.078122761542142746,   -0.03761245738133951,
       0.11340382376061599,     0.050428954127797965,    -0.19506303555443313,    -0.14258367617542425,
       0.04975249608767994,     -0.082662064260680776,   -0.005669582571918374,   0.18286543502139557,
       0.18133358349167855,     -0.11360649706311954,    -0.10821463176723922,    -0.15128528252675591,
       0.034683106430558566,    -0.14682470338875186,    -0.10100545542828174,    -0.066168195156154117,
       -0.0052784397876627998,  -0.05800178542354071,    0.052402763472441355,    -0.062766059015214606,
       -0.10085796079192086,    -0.1559496081721144,     -0.032443234858880454,   -0.12483391924259782,
       -0.18854215710735953,    -0.037223028410466506,   -0.12954781773200985,    0.12975795283518832,
       0.043258430376752165,    -0.061242046540169778,   0.054305453795509689,    -0.10993628336433273,
       0.093414982554730686,    -0.031324379406712156,   0.034851625118169575,    -0.011919077820755531,
       -0.061685615522342953,   0.027674845576217459,    0.05382422127066909,     -0.045236313767243935,
       0.22788809408161964,     0.018421652232543873,    0.10030838954711994,     0.10413248782529,
       -0.020124962033107027,   -0.20759897805608143,    0.079280365630869695,    -0.01789994397512026,
       0.019559117660870727,    0.071110337605390012,    -0.14963169520470801,    -0.12925092476822678,
       -0.20458901237589441,    0.020404471908795713,    0.12749699012044327,     -0.058240766657232566,
       0.0051101441137292852,   0.068262803283671597,    0.050854801881611587,    0.031283797122699131,
       0.079114811294445045,    0.19282804752049276,     0.0603096696827089,      0.023825982431205955,
       -0.0037803914615842137,  -0.057486725986027998,   0.0095337585320379691,   0.1609390745772607,
       -0.18716805641891859,    0.066358398543367586,    0.10950385967430619,     0.056461484499511445,
       0.15012066555403492,     0.001568655619237122,    0.13841592700007851,     -0.085712315884099194,
       0.16433262779673763,     0.10165964781648679,     0.027688283472484119,    -0.11002670816257834,
       -0.039589401008144093,   -0.089274584408842811,   0.054614946534979225,    -0.049247285273452762,
       -0.010212056013353059,   -0.0045782001041921264,  0.0044594871369849172,   0.13866072756270975,
       -0.10183681188953078,    0.15581778981225936,     0.12461943679611519,     -0.14928004502353343,
       0.010399400693488704,    0.053259372076980074,    -0.12438721490632214,    -0.0089614085178469239,
       0.12673210375520141,     0.073279052078628226,    0.12264333066968718,     -0.15718811910819652,
       -0.068244728100126384,   0.01333143893520225,     -0.13332243091972204,    -0.18061162913533327,
       -0.14287810611654606,    -0.036728350493533041,   -0.024994701842082963,   -0.011130493976357073,
       -0.034432638273998506,   0.10741675347107121,     -0.050939845628999912,   -0.087923812447859628,
       -0.079933645359691746,   -0.082888013726556214,   -0.067602917456350567,   0.029755639447284252,
       0.049482892387468932,    0.020082413826607873,    0.12786993612338121,     0.13612467192820524,
       0.021159471162358622,    0.026750708383707193,    -0.14604021698557618,    -0.10924788720839856,
       -0.054869078888289124,   -0.12516356275279009,    0.018001076624671618,    0.076571408309440689,
       -0.067302169954373062,   -0.018317623787052879,   0.020653749090453803,    0.10717144224844076,
       0.2807803069881461,      0.18404041839463739,     0.036574361497988928,    0.067569865330109502,
       -0.21819067936893458,    -0.10712686406089966,    0.16894976400400544,     -0.12325309809135397,
       -0.010789924488895489,   -0.041264839617245447,   -0.003229007905857513,   0.061564829638110073,
       -0.03396118498816237,    0.087677378236539413,    -0.063049106419166667,   0.070506549170789551,
       0.18831294371242932,     -0.011461216695308762,   0.0044831934088064721,   -0.0020344832735744341,
       -0.08409465151906402,    -0.22185950636282137,    0.013743284375405727,    0.078910002919311384,
       0.15144796782753711,     0.068145656582862188,    -0.15763141238287764,    0.0051124440948648146,
       -0.11885239762370106,    -0.091148987919454125,   -0.07423964996466996,    -0.099154837290031869,
       -0.0071762413687131207,  0.042874195491105146,    -0.038663289781312796,   0.015113999584955367,
       0.16042342691446432,     -0.11730798543757347,    0.010646007547067675,    0.066020185552638333,
       -0.0069849964755183368,  0.018335975249551946,    -0.036591783998402065,   -0.12171659209242831,
       -0.030451119722977614,   -0.066848344335264112,   -0.20603806423693363,    0.14995883224065507,
       -0.024639714516919205,   0.028697265447540123,    0.041723433553893456,    0.16101938581696207,
       0.015495993832141015,    -0.090521069895017861,   0.16423619177866475,     0.16014608299787558,
       -0.056099597333574926,   0.12593307616963559,     0.040580720919173606,    0.091508401296168898,
       0.11868414426741422,     0.057419723684679722,    0.11439492525125429,     0.036176330310918853,
       0.010523749350817615,    0.16041971364933216,     -0.05113247000891525,    -0.095685327412424942,
       0.074947697014839929,    -7.4223537580409872e-05, -0.10189461368546532,    -0.087962879464573387,
       0.14617015634832156,     0.12393938431396888,     -0.095747625220530111,   0.088563041766155384,
       0.019664189880115646,    0.019918574049329653,    -0.045797321894829206,   -0.052565139882013528,
       0.071838952172525145,    0.20857191586375051,     0.07204169072932487,     -0.12705076018885231,
       -0.1682250680077314,     0.16303484717338754,     -0.019231568481943129,   0.030503589714595911,
       0.26514021868527299,     0.25143807291344683,     -0.0050533811150556707,  -0.10586523229507604,
       -0.098549818536150205,   0.072208930099257398,    -0.098230002770493055,   0.0026616144121469724,
       -0.1054159254229767,     0.11405358295255241,     0.046409574856508366,    -0.024898574433316254,
       -0.1175248988519836,     0.063329783032803691,    -0.046601779009789041,   -0.029090190172398105,
       -0.014054363968098661,   0.017953833156143548,    0.088458729998474012,    -0.024905343417766953,
       -0.018901141561068265,   0.099802510840093214,    -0.0059031051601933938,  -0.026396517983761116,
       0.078610319545041482,    0.25684198259650481,     -0.10517385679739755,    0.12490429599235027,
       0.046373114233880249,    0.12550509962438161,     -0.0031190785862897042,  0.010068042457788879,
       -0.095849886259144645,   0.13004445367329925,     -0.021894444156367196,   -0.027263168433285231,
       -0.1194517741504591,     0.0055276660200196236,   0.059652941846969912,    -0.0009952109813901348,
       0.085465530174193435,    -0.22562774885659262,    -0.01764524505057026,    0.0029686642593773692,
       -0.061190324743892029,   0.11352076575902277,     0.11646054408412534,     0.11802970201576288,
       0.048023159313573566,    0.10069426230853153,     0.014310560084400693,    -0.029349263424221582,
       0.039524677282756646,    0.097012293558473031,    0.22148050232004801,     -0.054544120075907754,
       0.050978323398628067,    -0.081117576901764604,   -0.036388567876495859,   -0.020427392289512097,
       -0.094837503611488197,   0.025161957906988348,    -0.0081535590487229904,  -0.077114025493026345,
       -0.06930974707817833,    -0.031758431604940879,   -0.079232037726479035,   -0.057266618188591877,
       0.013741077813134137,    0.13546770703911287,     0.033298005898454872,    0.10319364636990472,
       -0.11582388802728547,    -0.05566176341958988,    -0.01669553668611766,    -0.081940807931654258,
       -0.045801332112329701,   0.098361750632486325,    -0.23971597512699699,    -0.086859181577613645,
       0.18730357749277404,     0.074545357311259386,    0.031624857500705192,    -0.013229917411138641,
       0.0066340636172552677,   -0.12207723777582404,    -0.063496954549761231,   -0.0080429433876646333,
       0.030610268320453916,    -0.057674526526973788,   -0.015606759951087339,   0.032180402667659369,
       -0.029213221502572773,   -0.13334797945753754,    -0.15285066310121914,    -0.076505479087983747,
       -0.045934308914499532,   0.070542053000962196,    0.012163150067369732,    0.01627359785526148,
       -0.11298830445984713,    -0.086709033295878479,   -0.03070764598911363,    0.090110229447445289,
       0.088623192515913163,    0.17873525562429071,     0.013813847828964984,    -0.088816371455768359,
       0.12262355736931384,     0.15316027394793613,     0.1886505134114326,      0.12120662893273161,
       0.19367042831662848,     -0.17699843249034056,    -0.022044372808753016,   -0.026646783555452712,
       -0.079976638522404733,   0.072405552071387949,    0.0080829876354608834,   0.00017649377492502151,
       -0.085484788654838426,   0.10512572378868708,     -0.049859634392624058,   0.0032568104589025433,
       -0.31738118551275463,    0.086461937205236053,    -0.090202533870293755,   0.038222019878776867,
       0.0044462715747247486,   0.1504226013805362,      0.041919051066608891,    -0.025047126392612785,
       0.094926348923060927,    0.19529865938679766,     0.087643958178098225,    -0.052591609809422651,
       -0.046793558776525052,   -0.17910101755843955,    -0.1104901321309671,     -0.081085832043145067,
       -0.080877359999997442,   -0.028350785864655691,   0.055114856834842213,    -0.074200438663243079,
       0.050130548322964728,    0.061127470836328704,    0.11859945532770182,     -0.20584519733402012,
       0.061031625931632111,    0.13114963974218288,     0.1310699609897959,      -0.06301762015093311,
       0.10885566218681234,     0.013694709978630197,    0.032481939728842793,    -0.070002915337974897,
       -0.26368482354007355,    -0.080436907530918506,   -0.15859254296586656,    0.16265681243070515,
       -0.0175977786202616,     -0.10950248424796734,    0.016879446751381068,    0.10668103198764343,
       -0.002813917212529193,   0.085972888998333871,    0.14744632509167266,     0.015095551003830698,
       0.11184518746201809,     0.079573740960505471,    0.020908801316907363,    -0.10128864379944807,
       -0.16515064161720638,    0.045480950266875902,    -0.17818425252474404,    -0.030874809294685553,
       -0.050645418800595213,   0.13458172652414915,     -0.0045524222370234664,  -0.15430958867296474,
       -0.021936686865854101,   -0.034307093842879673,   0.1119696478006291,      -0.081989605381370609,
       -0.14330241554943524,    0.25419404907080329,     0.11669447144972665,     0.097133669315094734,
       -0.054416141108310369,   -0.01733627426195616,    0.055056361850589097,    -0.2120929086440774,
       0.063001616003815056,    -0.13837275643249522,    0.091293717564101137,    0.25549488596202913,
       -0.0020942640842401203,  -0.00056382224752913636, -0.090984425915859382,   0.099550892078881334,
       -0.041322957805076353,   -0.14262695903327943,    0.038424127171598182,    0.056793732485269748,
       0.048528856120291376,    0.013960152851338944,    0.13095637769592514,     0.0096179467765446572,
       0.0095420093889028237,   0.11108823897765334,     0.049765939562485192,    -0.099173223699058163,
       -0.004348017941340869,   0.044925047757634291,    0.07709672033963004,     0.072285977647313079,
       0.069931556456153871,    0.09036731389705048,     0.0052777778905673048,   0.012679243359757682,
       0.0077127223921443257,   -0.08555374249852489,    -0.073366628799199571,   -0.12363923730540331,
       0.013858587554965725,    0.060153295482112595,    0.10243068805210884,     0.034540896721260747,
       -0.10094825393834,       0.10505541627620574,     0.049970881051682015,    -0.14125468365545069,
       0.041741292428625357,    0.033446729732011855,    -0.062536660857797924,   -0.11833025920975407,
       0.16542403858050489,     0.20611119349798504,     -0.069655339040617478,   -0.12329261334312774,
       0.033099614337579013,    0.14081382765152894,     0.022200994387772226,    -0.091986761352865973,
       -0.085632657197091053,   -0.02563685528411188,    0.10967905499925731,     0.015519177265338132,
       -0.016133328287043492,   0.048424664874068379,    -0.12119311271185443,    -0.081161049480811986,
       -0.021755907005341663,   -0.017930398818691511,   0.0061450508967536357,   0.041472656982152169,
       0.05276810941548736,     0.011217519108333698,    -0.020416976916419853,   0.093513269885345654,
       -0.015890623391750545,   0.12196031112639612,     0.16739622966600617,     0.089151590673779507,
       0.012990266801212107,    0.048188526547569041,    -0.25314692085675489,    -0.032683184296387051,
       -0.14585033146482179,    -0.14791763999402543,    0.033482190158908368,    0.062911020310112462,
       -0.15238719779643928,    -0.0049205658253410611,  -0.059604331636669269,   -0.098942519889756581,
       -0.038153155757702797,   -0.21130435379706236,    0.092792436868443864,    -0.21827805093198438,
       -0.067418729816354397,   -0.006608719723331602,   0.058511350790352919,    0.086125024736629086,
       0.018769730610645435,    -0.016622998908920522,   -0.0081796464053449439,  -0.071879769871519963,
       0.17448288413445506,     0.078267277001638935,    0.044092935623740351,    -0.0020168475678185166,
       0.13007373696105265,     -0.21272493319597965,    -0.12551335492754143,    0.032640533531533594,
       0.0086385690235625846,   0.091582293027154968,    -0.024859484712019375,   -0.08349170000912795,
       -0.038682693977450687,   -0.21914207838243657,    0.050491818075414772,    -0.017798551752893639,
       -0.079831318482824445,   0.1240616971767378,      -0.059892249303970094,   0.14438707311932414,
       -0.011729340834231779,   0.070063653841657011,    -0.065665715743311232,   0.052976725990682448,
       -0.11757706493208389,    0.18809864507722232,     0.096855151270609285,    -0.13293611562164087,
       -0.065760453876729519,   0.089071903010244521,    0.013262237384043814,    -0.10259275917868985,
       0.077763430002379119,    -0.13067349588072449,    -0.1209223604384122,     -0.052784680380882645,
       0.099896503114843549,    0.26268775046220083,     -0.033326127456801941,   0.005817892895455444,
       0.077066741543949949,    0.015400813721447647,    -0.047630695772104097,   -0.055767187207830367,
       0.093841373204409162,    0.12397395834989346,     0.0026590238803193746,   -0.024323585487357482,
       -0.01453752172846676,    -0.067319787937979422,   0.0097972960059374836,   0.14455549454810321,
       -0.066866108070792685,   -0.19980123316139078,    0.168597235658341,       0.11939071475706375,
       -0.068513921860790472,   -0.074749670525280934,   -0.059578659300115924,   0.16042429064848754,
       0.06455198543412527,     -0.018809788734746796,   -0.026810056138109124,   -0.00591643092562503,
       0.14309715344954477,     -0.082106756944493348,   -0.058320717659367471,   0.040423182997223507,
       -0.058807937150855014,   0.062015436217859571,    0.052033358671660465,    -0.02252575531137678,
       -0.015466097779064736,   0.0070191104476545812,   -0.018106782335638345,   0.043933465129442781,
       -0.059216256962833565,   -0.18786876702896671,    -0.13196606894883031,    0.14543239053858012,
       0.048853841468614309,    -0.049212439185459804,   0.028935647759981739,    0.011767646514462731,
       -0.073533109121870291,   -0.022335442939289719,   0.016991286601288333,    0.24353016552846762,
       0.16531958490598886,     -0.00083375977037056974, -0.016325662704075906,   -0.034845088989620757,
       0.11583951099802367,     0.023807062875783744,    -0.035560866610816651,   0.044453794500225144,
       0.067613197973259487,    0.047602706786094753,    -0.045989977205382601,   0.10238396152811778,
       0.089152292816370299,    0.06007496492772986,     -0.0036796492370823278,  -0.10387297778530516,
       0.0050195597559590834,   0.16878086485606469,     0.11119179700242067,     9.1217471985797008e-05,
       0.26612289623863894,     -0.042622482098339638,   -0.040911656727586364,   -0.20245207441314703,
       0.14271797522330515,     -0.06526081608697587,    -0.035933579041638616,   -0.039838336228577659,
       0.032100206354026897,    -0.067420684913634815,   -0.016774621622075429,   0.18012586397507335,
       -0.14286319140121856,    0.055086012223824421,    -0.13975308668450995,    0.065317796052114421,
       -0.011612327201637422,   0.15288711913711178,     -0.0017320854016251675,  0.071964036292962136,
       0.0025739091126736162,   0.023841766559733683,    -0.082052136238946749,   -0.13967036148002676,
       -0.13289537027247686,    0.10847781648913911,     0.045047449163764068,    0.020608585706251441,
       -0.21334322933196329,    -0.049064432296907101,   -0.099478627393803115,   0.020181469238320385,
       -0.070182987268620725,   0.083012634140024355,    0.059024544140338212,    -0.19852684344622329,
       0.075227184189167545,    0.049422768678088147,    0.019432134304426366,    -0.097091255687687769,
       0.021726507204595499,    -0.23539307242134205,    -0.051353490147760417,   -0.27054636065151622,
       -0.13851707706066066,    0.17858844006180644,     0.070702386198379458,    0.14700344214285685,
       0.034373717926252344,    -0.060746566016814045,   -0.015521629750152673,   0.024567860035924583,
       -0.041318336209904369,   -0.049458763472241152,   -0.10403995502899706,    0.025238494703591324,
       0.022063308463702726,    -0.13951028295793633,    0.0079877689967122086,   -0.0087349459227311181,
       -0.19331435235219316,    -0.13820534354235817,    0.002829798085870262,    -0.21723876857481927,
       0.058599074062057756,    0.18235408234692863,     -0.07706584947703414,    -0.11341498762591853,
       -0.032331523948190138,   0.028855203833427594,    0.016852466563800107,    0.088007174062145116,
       -0.11442920130265459,    0.10776403323112174,     0.024736988245899115,    -0.028074846184468032,
       0.069138058258406965,    0.085415133511754324,    0.075711990232322807,    0.10103608581729591,
       0.12497559784292936,     0.13016717674891348,     -0.075388744744011554,   0.040137294843686819,
       -0.092471214356636619,   -0.070475503923521574,   -0.048068436421753381,   0.18923583627731025,
       0.04778457447838471,     0.084534688956289988,    0.1671711366160043,      0.04543016270094527,
       0.071119945290519251,    0.013716235445222134,    -0.15528556611292324,    0.078372132717706725,
       0.029965725193324404,    -0.06676353357473705,    -0.049450526676494071,   -0.021365224796864049,
       -0.071118262149789613,   -0.012248544168101574,   0.030695882185771271,    -0.15638207222645206,
       -0.045050286480188335,   -0.05665796349400825,    0.19954267326035929,     0.21745927374053631,
       -0.085214541419601081,   0.040695108638557909,    0.2796316648038753,      -0.039831076033258098,
       -0.014540966301204026,   -0.029076091763475725,   0.20813510508478295,     -0.016125462214145445,
       0.10510664051765101,     -0.014068628112511403,   -0.039505596785303736,   -0.073841372491278326,
       -0.048815850261756437,   0.026080587735387677,    -0.048700891743364838,   0.097864521768265877,
       0.010394473550618529,    -0.14184890940602038,    0.100176277719109,       0.20818010602947651,
       0.055659742779766708,    0.062788153811638922,    0.0055747067378541099,   0.12324274180859007,
       -0.11811149156330317,    0.05239409153860633,     0.11747233595600996,     -0.088756375782732461,
       -0.03836754981576921,    -0.055663948838155924,   0.049265561339309191,    0.011751514772629052,
       0.043240230982397002,    -0.052867365782467465,   -0.06671563704579217,    -0.072631004238929833,
       0.039303759308261535,    -0.2282183164215375,     -0.05495158926341652,    0.084246598043494866,
       0.051848467295403704,    -0.084189148795539126,   -0.04276250898880566,    0.18166092453426147,
       0.053736611316759171,    -0.14734326833559597,    -0.060085170645041694,   -0.012051702177419094,
       0.027654197811406912,    0.10938268301966976,     -0.085913085318671159,   -0.07975749599202718,
       -0.0021910209461929418,  -0.23457872691374521,    -0.16727217373136141,    -0.086489821780705786,
       -0.026316078223507386,   -0.26457660058527532,    -0.15769865993818186,    -0.040721211618963096,
       0.025655764065231051,    -0.063411104020463752,   0.05422644393968469,     0.012769056173145568,
       0.077155249573336776,    -0.13441786860871741,    -0.16381791970284174,    -0.039023427056977089,
       0.13982212875978359,     -0.16902096514600803,    -0.10242820317725615,    -0.09200068003826492,
       0.12707153955908715,     0.044779121104414024,    -0.029023936840422097,   -0.19210207309293095,
       -0.16900838684698005,    -0.099675789346857904,   -0.020578481996972948,   0.10097603600838703,
       0.0094567891735890704,   0.16997143864398589,     -0.18746668462740027,    0.0034343876294014074,
       0.05704719026409915,     0.030794657019874529,    0.068112670342447321,    0.015107812109085681,
       0.0072490869166363207,   -0.040894288911623111,   0.001978119721219058,    0.035698671252911832,
       0.19504238523626913,     -0.056142882239659325,   -0.21375907302811487,    -0.10087390083535237,
       -0.05369904617654158,    0.089413218166024544,    -0.080601761650607021,   -0.016817044580276767,
       -0.017042219288360985,   -0.047968238080027308,   0.07548252410466684,     -0.030272028239987127,
       0.0071437867744484421,   -0.068369062128320779,   0.12507928120542519,     -0.0965264670768331,
       -0.023222277291402676,   -0.11267792397700752,    -0.047001796505871496,   0.02447741625458294,
       -0.040009422326585581,   0.012187624831090425,    -0.085055007082879552,   0.035165037730731402,
       0.055684072223613511,    -0.110815721300905,      -0.052183587766244557,   0.044689623877916272,
       -0.081260496668308618,   0.047734503190512922,    -0.18365921534514387,    0.0025255507342021987,
       0.12361641332890336,     0.0031444792741950316,   -0.088407722376961415,   -0.07337324185519209,
       -0.060544774480534934,   -0.048429958333338616,   -0.059877293435744827,   -0.031671189558429895,
       -0.051291635472160715,   -0.0017967625672891509,  0.12935024455622648,     0.13909862723414962,
       -0.16031284505351123,    0.010911252581565244,    0.096234921469441528,    0.13058512887114879,
       0.13752729428356142,     0.0540820736365775,      -0.16416213996721521,    -0.023556134377012997,
       0.13620412152588157,     0.051772136733773726,    0.18505309406201859,     -0.0002750700588609262,
       -0.024780279033252858,   0.16223584805687563,     -0.070235596444430975,   -0.044343696315772417,
       -0.1302817741691755,     -0.0051911707914754079,  -0.087061083816620352,   0.034069278336686187,
       0.1170843866806018,      0.10005844393836218,     0.12928556605991567,     0.02968725367399291,
       -0.061625501314960973,   -0.023916844668400931,   -0.1204242512120923,     -0.074154886782868565,
       0.088753376831645289,    0.043324222109561807,    -0.015350166932547267,   0.089207063646129056,
       0.10593140568317787,     0.027413540628950371,    -0.023040199391676536,   -0.098336523138407572,
       -0.02462230097689052,    -0.18881525124869153,    -0.13053966694642499,    -0.057197097834396644,
       -0.1598931960036494,     -0.049687783906441962,   -0.073945325744884452,   0.034365442941556829,
       0.02546341804456291,     -0.011995250228606345,   -0.11961117503994073,    0.0079813419260691704,
       -0.12339820282677574,    0.030197683100426656,    -0.030687948897752892,   -0.046137988620814446,
       -0.18632406861268563,    -0.094061201996240643,   0.059862222828311405,    -0.19666309028845222,
       0.13744681689314933,     -0.056189647161585574,   -0.068171115444809235,   -0.015545776761968663,
       -0.19859626460623003,    0.28724268638942224,     -0.066321459559949766,   0.010595619021530563,
       0.015749732823774721,    0.098088862497235696,    -0.10532554928274146,    0.043808511377631074,
       0.064189778825471527,    0.12002896576396102,     -0.11457301459916938,    0.038912895043562108,
       0.14479959615546956,     0.043106887192474068,    0.046615874181995677,    -0.014810058284387371,
       0.03032756144552606,     -0.013549422996990416,   -0.10600884151712758,    -0.13964315888730078,
       0.10045883000356783,     -0.040921683372336738,   0.037116171274229094,    0.20741251369719882,
       0.00048289379163025253,  0.023871836071507987,    -0.086170691934347149,   -0.067317263114944459,
       0.020507821670430915,    0.011497836711287566,    0.16349355011823247,     0.087236335008110871,
       -0.093387894844870312,   0.051802504251764241,    0.013518939359895574,    -0.1021539762625073,
       0.14127620742929023,     0.1078579679375181,      -0.059017917513252194,   -0.10097829691302346,
       0.038142060449031866,    -0.0018348135366722806,  -0.16067591191839764,    -0.029485881151051822,
       -0.02047420363259167,    -0.089276131481820606,   -0.022971962475384557,   0.066929977927144668,
       -0.11321638322891814,    -0.024699715869080725,   -0.18682108168291317,    -0.30969262696482547,
       -0.073814084506743247,   -0.0044889348767946438,  -0.031875982242698872,   -0.010832994822164257,
       0.044383233294593177,    -0.073489098108052917,   0.05521224879763665,     -0.097101841764148669,
       0.037470719445838227,    0.063874449587630611,    0.12182279968762459,     0.048881192105937693,
       -0.17573001454430551,    0.1203823682543483,      0.086997659569540975,    -0.12986659708730505,
       -0.041538586673534966,   -0.019305652994914779,   0.1077805610429191,      0.16670958916613116,
       0.1678179262459964,      -0.031884433657846829,   0.018683233459996708,    0.10890513767106472,
       -0.077307482804465644,   -0.14850398802260464,    -0.0054990630935865988,  -0.017863459043331066,
       -0.048004570316527648,   -0.18213812177920385,    -0.17051685147393592,    0.12102296513594039,
       -0.076985600780429778,   -0.12315875362915212,    -0.069511503257003296,   -0.0042201540267117225,
       0.14071530259887666,     -0.087977125005530968,   0.063109150017860272,    -0.11641098872671483,
       -0.12428209949219839,    0.17173834213033504,     0.021392454194889752,    0.36336434626151398,
       0.034054440674580223,    0.048953538155674145,    0.10829395021314529,     -0.023948404870895109,
       -0.037869223680146939,   0.018033018898745402,    -0.11226512938672806,    0.035341228652065668,
       -0.083517519980366245,   -0.066775470496738001,   0.14014030778823047,     -0.014725805547552238,
       -0.10556949036335282,    0.1241281366627659,      0.011293883742579353,    -0.15237584026661921,
       0.045662262646796889,    -0.011037333543965161,   0.00043670134908482382,  -0.080769452724411425,
       0.058590856053796117,    0.0629128247990762,      -0.025956627936312607,   -0.044848811511584673,
       0.034246158923773688,    0.17050254141202445,     -0.12681321981714974,    -0.029965852229868181,
       -0.047056438290841343,   0.043228067434551792,    0.21521156401928393,     -0.062495844152984051,
       -0.045240515171515235,   0.17726310912118096,     -0.17850924444106819,    0.16613679660111216,
       -0.10134791956177221,    -0.031746043706077705,   -0.056585923523095653,   0.010370357909086117,
       0.041371662684092925,    0.0058495663031796078,   -0.083778203538784859,   -0.16765856329332063,
       -0.060699468695638747,   -0.068986976581992446,   0.14681038415048314,     -0.05874923911312719,
       0.10085174226148759,     0.036614194443424571,    -0.021180944189131953,   0.017586956299318852,
       0.10117066470182615,     0.031895926150728608,    0.069764320434522797,    -0.053595068382015096,
       -0.015960581636959244,   0.1588595983241623,      0.015849150797167592,    0.098380375933174613,
       0.039317820716607943,    -0.058772536876825418,   -0.18074619694564778,    0.13203985820448075,
       0.17416182213842127,     -0.12619203536817797,    0.044956758021659084,    0.021661614690530288,
       -0.020332239849079437,   -0.043162051339840399,   0.038550056295567972,    -0.1069625309618559,
       -0.10735389453986426,    0.002210579483137777,    -0.065212709494372204,   0.11316756625411013,
       -0.07481118317047461,    -0.076688290467610443,   0.026764006136229659,    0.13307941544990051,
       -0.050380571844711994,   -0.040083184038594996,   -0.10332268630785787,    0.053813715638021856,
       -0.077647652465699782,   0.10284114926519697,     0.10809542283738341,     0.044226942887860943,
       -0.13946659396655658,    -0.0034966730312275948,  0.074045994971188772,    -0.045883096227967893,
       0.033079455904171558,    -0.13559397259832867,    -0.027410171234156646,   0.16343272668642128,
       -0.062916725460170728,   0.10502556470777427,     -0.092294473774158003,   -0.074582959218045378,
       0.049720343862321006,    0.088090081687341615,    -0.049797067611162198,   -0.1811329946968615,
       0.1021907974933358,      -0.11742580299146053,    0.057074005168249363,    -0.10206217770417904,
       -0.060606673576061247,   0.010371198381115809,    -0.058334020589748722,   -0.0046017559419601929,
       0.021031460684265701,    -0.075024029912751408,   0.083975376041117003,    0.12581763710711255,
       0.092202702835170805,    -0.038484151215872855,   0.030438850259379334,    0.26202602075480597,
       0.027409055378366669,    -0.19539385231796896,    0.10402206065336464,     -0.1195712949570998,
       -0.21317530669217746,    -0.12490784539436287,    -0.089831498247602254,   -0.00087103583322937356,
       0.15753564077115903,     -0.10740563973261937,    0.060726151671227323,    0.064566173996883469,
       -0.019992853199392029,   0.0050081248439175566,   0.038041787948837634,    -0.091738618521268217,
       -0.18220252696186168,    0.051142842349201682,    -0.14960914958301622,    -0.058837912774308103,
       -0.1079831220239702,     0.090584396195814182,    -0.1793523039920415,     -0.12572724401205837,
       -0.0056505702608393455,  -0.07846413064678924,    0.17269399075551625,     -0.19144606640006853,
       -7.2714000295802644e-05, 0.023625386108146275,    -0.1654194165091708,     0.047466474195506494,
       0.0054008926267138284,   -0.11879748335296825,    0.026121568094955909,    -0.045078102544100399,
       0.037077087787882358,    0.13252306988501733,     0.035916242206861938,    -0.086222095956665079,
       -0.16945675546810487,    0.03728410128665597,     -0.024790896200961206,   -0.017977546041363514,
       -0.025298395478405473,   -0.09806303209997777,    -0.097355954580572002,   -0.017597903917992236,
       0.15643447095426294,     -0.041959370253833526,   -0.070600135900760239,   -0.048106532107463691,
       -0.038656695353325554,   0.0047931593185925525,   -0.0031858433729480386,  0.0079718509471416767,
       0.057842717810923212,    -0.21734986795333749,    0.022775888851867463,    0.18169807883898789,
       -0.079045979781227071,   -0.042173376341546359,   -0.10864404655329241,    0.075292173219007719,
       0.18073672375486,        -0.1438107615382431,     0.027758189877232772,    -0.19484647370381283,
       0.10633772648042372,     0.081439867781231481,    0.043767572978445433,    -0.21543504102078137,
       0.20678004748223483,     0.042280824422889024,    -0.041174257265123353,   -0.10894361292998886,
       0.032194945932221906,    -0.081861273722424882,   -0.060799743261841697,   -0.020037645487407062,
       0.15647011967149024,     0.042870765056938369,    0.039201909813088104,    0.035174285196445193,
       0.0095934788151531541,   0.047548304832953942,    0.063586411815473698,    0.071557255765368477,
       0.072034345935938132,    -0.12300892659331754,    -0.053426319184549716,   -0.091368204369134384,
       0.13301294162395952,     0.1069627295471824,      -0.16643248541397859,    0.042914116776854729,
       -0.12196329545490892,    -0.15453088935990564,    0.13789220541842434,     -0.040089649367076444,
       -0.17639923447246122,    0.0093035208829934223,   0.0052020572275199139,   -0.072830898299037675,
       0.15153680665502764,     -0.007606805077324608,   -0.10276243989860503,    -0.070630973856755958,
       -0.034712898787857716,   -0.059520345408931939,   0.13852976379886958,     0.069573784701756139,
       -0.047830908231237167,   0.12163432118197967,     0.042488159115050154,    0.092137548010758408,
       -0.01927123618259859,    -0.049243511983429286,   -0.018266835239798187,   -0.056049111123017074,
       -0.053811502126769349,   -0.057333957628052407,   0.028825709779912317,    -0.010310499284633822,
       0.11016353668695861,     -0.062632275948808561,   -0.2122250597367622,     -0.061109609234279723,
       -0.057640219690719884,   0.027521973023249362,    -0.14010565430968386,    0.10012185515192432,
       0.23905304796003898,     -0.17695704212509092,    -0.090126790847042171,   0.13500564332903392,
       -0.10088394119410898,    0.012488848348550165,    0.0066959745059193884,   -0.017385383035772722,
       -0.059491993065526695,   0.030405152547712044,    -0.065874495489225263,   -0.19731657822703982,
       0.060648123094096985,    -0.052183805322056916,   -0.045746084983894014,   0.07548842642544934,
       0.075492186891904789,    0.28502314676995999,     -0.050746578232951652,   0.060133108307288963,
       -0.020267294028798025,   -0.05744490605403868,    -0.16724049305193309,    0.056776153993735839,
       -0.085609274150752118,   0.064816900319454196,    -0.11146207028194779,    0.043848134928900044,
       -0.056553450748235173,   0.087182520705854402,    0.044125916673264112,    -0.073868453181659355,
       0.043835948228915025,    0.03407410482053095,     0.10682112933105793,     -0.01144873334829897,
       0.1273354067954571,      -0.062819175415776349,   0.10752092767881406,     0.00052157158266040449,
       -0.062555538307516562,   0.096319873956630608,    0.16187675300236187,     0.11823204176379923,
       -0.12684885234349702,    -0.080376926467222151,   -0.02190687585726293,    -0.021094223981091575,
       -0.12949234020418426,    0.00040636164477275954,  0.12636882449321565,     0.050156728234392559,
       0.087269009818911183,    0.23651571702846577,     0.0043481535257727313,   -0.0519833563761097,
       0.01225484786379785,     0.019629814110863539,    -0.058478480954611688,   0.15893263853406656,
       -0.010333170250517641,   0.15786413913903263,     -0.06386567600164586,    -0.13798377552099658,
       0.033806448354950586,    -0.014561361031469008,   0.032234065933699936,    0.16892791515631311,
       0.005886137271731498,    -0.26256291738832954,    -0.022749568742592579,   -0.026710537372424268,
       -0.062401628851305312,   -0.084614199169032983,   0.068528687627356741,    0.013364085157675823,
       -0.17924668960358364,    -0.007849538024679352,   0.059730523849854139,    0.0056982079186364189,
       -0.15458922342872936,    0.098782259378243836,    -0.10279673163050078,    0.04529954513292081,
       0.038219568845595249,    0.053992576676303042,    -0.032119424022652061,   -0.19559800391376869,
       0.21842203181091377,     -0.094922165057830868,   0.1167446284628956,      0.034636594403062236,
       -0.0075457296719028503,  -0.061836108775314223,   0.095452196040042805,    -0.0012574002227591934,
       0.12797888815666728,     -0.15778110924692479,    0.038529791352606965,    0.13978739393903183,
       -0.043074872082953422,   -0.067593272471022176,   0.1962897781459291,      0.13639035926703946,
       0.22944953090151163,     -0.078710345275626578,   0.044125719097279886,    -0.10430615002462611,
       0.2172597604262648,      0.10921418402412879,     -0.082357817014404353,   -0.075507566014614988,
       0.075066935911572874,    0.18724202636478457,     -0.027422423990567279,   -0.010125823927451896,
       -0.050369847523164195,   0.038504459617799511,    -0.022965037796210543,   0.13841583807234759,
       -0.0650862485275501,     0.072490022315234243,    -0.13236401766044656,    0.015517769302479941,
       -0.11265142442153535,    -0.22958262908653382,    0.13895618983609137,     0.024150178906743577,
       -0.0034081831108350967,  0.057669712672095814,    0.081921886398471033,    0.083400340747062054,
       0.15742405413175878,     -0.11693397867237304,    0.064955700903636421,    0.18498683159635224,
       -0.029836837720036282,   0.079560788297573279,    -0.063440693436860027,   -0.056053226857100458,
       0.025073309529507964,    -0.10129419295108978,    -0.033496403973586768,   -0.075272564885962664,
       -0.01119732503779378,    -0.09544320811887784,    -0.067345828704063943,   0.029921106618257254,
       -0.019083606752163803,   0.015104739496941588,    0.035790573071589983,    0.037570419115509568,
       -0.037046139211278535,   -0.0094784311641672239,  0.013862761716406271,    0.041310183225107211,
       -0.099286472071276444,   -0.12328639811831478,    0.03895407835313585,     0.096038358648683125,
       -0.010593640121172235,   -0.0016495000532178502,  0.091887537178164516,    0.0071293218665225535,
       -0.10196000101951959,    0.050491686655184796,    0.046411260443953418,    0.16010860295747964,
       0.066103156768767629,    -0.19192484171233415,    -0.050693372767257813,   -0.055680789718686702,
       0.17106276983642324,     0.085922534482321983,    0.026980447703087197,    -0.0073546734690289172,
       0.10318802374322215,     0.07083469522935941,     0.067024579362645317,    0.047877549888368079,
       0.01725404385607902,     -0.13354493839947842,    -0.029240318231841339,   0.049879326365841074,
       -0.01564038730057795,    0.051290465280761185,    -0.0044060521610601857,  -0.38958723397764772,
       -0.05007481202148556,    0.11970953593560026,     -0.026813468204419766,   0.066661690910444077,
       -0.035531641597308372,   0.03395591090941965,     -0.14537438618305301,    0.11348605210864057,
       0.14042933431787868,     0.10687009266470569,     -0.0034768186068400513,  -0.17475954390480961,
       -0.029606513971187225,   0.090933506139465589,    -0.032706172420932864,   -0.18238590743644212,
       0.11924463219192706,     0.076591605015493475,    -0.057131667186275298,   0.08503401093895592,
       0.095358733322319048,    0.024244556087728186,    0.086258070842886808,    0.22700909449325835,
       0.03720475526773618,     -0.016742259495641853,   -0.11700751307868053,    0.097049644168762758,
       0.033068583023947523,    -0.012955555434886797,   -0.015929170839977722,   -0.076278261719143342,
       0.11207370665379236,     0.056469730940587132,    -0.15801105752354905,    0.15521832801662758,
       0.057605098635505572,    0.09828586195230278,     -0.061079027994981314,   -0.0044244306421034598,
       -0.0077372343790110716,  0.21767306204884282,     0.017209678582277191,    0.080583056780376819,
       0.054756154589908665,    -0.12357502264539683,    -0.12535548660688911,    -0.0092293366271151041,
       -0.004195610481671443,   -0.16126055134993889,    0.0069633954087443091,   0.027089322788822534,
       -0.17064498964097952,    -0.14240381120255868,    0.068296370048606836,    0.09278961360692263,
       0.22266323933076573,     -0.040988819782734429,   -0.037118177605555865,   0.087604131473834793,
       0.025844286032467287,    0.022937320715721396,    0.070918531880072966,    -0.069870960283769226,
       -0.19448966448449051,    0.057174476463585609,    0.047623379472250926,    -0.031573231862036401,
       -0.045283736555459891,   -0.043782647214910118,   0.028003277692567621,    -0.098656632889289816,
       0.084167391038556083,    -0.16467727232672758,    -0.0050960705144255051,  0.047092833139265239,
       0.0017539508317337565,   0.10708799380774728,     0.18358239466890799,     -0.041216116939153086,
       0.03132659397428509,     0.1176019522995337,      0.064945441238442689,    -0.081591453056917021,
       -0.19534196762677428,    0.084706979008187633,    0.086211855012653466,    -0.0053973630784028698,
       -0.10691931007066295,    0.15229211277611876,     -0.081564810948925898,   -0.034748441540806647,
       -0.13659658204316133,    0.0074518332940096072,   -0.11921549634102327,    0.017920255546068034,
       -0.13878638883659297,    -0.023528532848916688,   -0.17172682315110074,    -0.10234515562665411,
       0.0682328421751624,      -0.04548791451878588,    -0.099800652563840131,   0.11744550294317488,
       0.042694697962218364,    0.047325618007899507,    -0.093043291685804205,   0.21268369140367507,
       -0.076747837030242336,   -0.12855616326703173,    0.023994206243110074,    0.10058659891300328,
       0.1979885532142836,      -0.13652235025185527,    0.020651944933927458,    -0.044277187024493549,
       -0.058591062795401175,   -0.076329141008321,      -0.11516465257555168,    -0.15027057054146609,
       0.019216180499518773,    -0.0073540892684663389,  -0.039506149898778556,   0.055029921637655667,
       -0.22674370509180508,    0.14080728938177769,     0.029672230462167534,    -0.055028321053275847,
       -0.053035896671659893,   -0.075444868443327665,   0.017025193805652608,    -0.07316097233132754,
       -0.08538906500205648,    -0.18207280064466935,    -0.052652824180649101,   -0.1597268307256087,
       -0.066751948107534487,   -0.0059260252311594645,  -0.10630219847791259,    -0.032187774792768256,
       -0.15562103261758395,    0.089879339851768547,    -0.068516581720736838,   0.064681060512286004,
       0.065914108876289179,    0.158504039745547,       0.0022033649720387036,   0.048849669665439098,
       0.071803162021124231,    0.032293542662064391,    0.068358820473286425,    -0.062480120779728691,
       0.093740412866483644,    0.007929663777517075,    0.12274648054951305,     0.12863373516323259,
       -0.07771963967497969,    0.12275821934640563,     -0.036278934533605221,   0.089500775032170451,
       0.1246518440937788,      0.031257736922170314,    -0.035413745143755483,   0.01942345919428929,
       -0.036052195147655862,   -0.032537568207934436,   0.031669382700855724,    -0.0088834802709905764,
       0.1557734146666932,      0.043206085246997775,    -0.064262861417656095,   0.053222285220424291,
       -0.067279522069764855,   0.040614751260195696,    0.20840344980329989,     -0.10608425850630591,
       0.14937130203720517,     0.056737254821602044,    -0.017987793489205907,   0.10579359157775912,
       0.0022632913908645254,   0.10136361376043458,     0.03924577685553584,     -0.093787894479327408,
       0.10378578562039789,     0.049189633398183261,    0.14556368468236089,     0.056784757045462715,
       -0.068009020658042749,   0.13913784487204789,     -0.0048685283508915506,  0.045138282430146705,
       0.19483606665858733,     -0.20142978229904784,    0.03813534793580925,     0.16175887885018578,
       -0.04547377747748519,    -0.012447960982927364,   -0.058429508595279185,   -0.03301845433187893,
       0.056675101890792376,    -0.016668982122617089,   -0.031417493279294065,   -0.11601638211489024,
       0.37552887571599514,     0.17428076039378282,     0.041147614885785264,    0.059359624099367937,
       -0.0133273282854621,     0.12657916116820361,     -0.069018793793381716,   0.17474351251331383,
       0.078857025990366258,    -0.10370381581714594,    0.059721577080552625,    -0.00060103252958884634,
       0.067847885545679207,    -0.0046233956117106394,  -0.0023331807298828128,  -0.030251182029377696,
       0.099371051760009793,    0.062321550334055287,    -0.18331879565152051,    -0.18152998382479441,
       0.01888683661578508,     0.040719687926949112,    -0.19155757751397215,    -0.066040510460610796,
       0.18838681428589701,     -0.085060645361998991,   0.019609684341768581,    -0.078323289567867924,
       -0.040419939819583584,   -0.075613257726853872,   -0.028362457105498739,   0.15592769333912054,
       -0.035136538240782833,   0.075911579783888211,    0.12727784569354827,     0.0013489873916497461,
       0.16858745825434496,     0.070147197522727064,    -0.031209938250001866,   -0.011201463147627376,
       -0.15000459812218625,    0.14879982626215493,     -0.048725919824713061,   -0.031028557067925774,
       0.04217557776147144,     -0.095212218665949477,   0.080122174590209372,    -0.17745265557606957,
       -0.08662946720172475,    0.059843577415822732,    -0.088217700695136458,   -0.20909076993064965,
       -0.0028287028611425763,  0.057238593625986385,    -0.027806858982170932,   0.033304866471531469,
       0.075771805180687851,    -0.011431036899730468,   -0.056114459338679916,   0.20222330189028823,
       0.045267282607652497,    0.015660422430529439,    0.0044917136852182446,   0.21999463062446262,
       -0.011455301624710007,   0.052370278293678213,    -0.13839266564680994,    0.043853294557440463,
       0.13907211199838751,     -0.11180816958533404,    0.065322552627508065,    -0.10253751784551365,
       -0.061669479095974075,   -0.0092856976661205484,  0.078860708183339789,    -0.021526034393274864,
       0.17188494641567892,     0.04092740289269451,     0.052817689636998774,    -0.16439430156931109,
       0.12314970127187994,     0.0043766761322124575,   0.16765469991153334,     0.030347999895651658,
       0.0081719936738176482,   0.029807941281953833,    0.038118331171999496,    -0.22641488084922229,
       0.054539270327676699,    0.22869876235657891,     -0.050250432588136731,   -0.067459770917377981,
       0.12948613285120386,     -0.089990681290998631,   -0.093116316757447928,   -0.024056571356160766,
       -0.043113888887930094,   0.041874708653011496,    -0.1747178812869834,     -0.050993489443913353,
       0.023813372986191281,    -0.055721832371643396,   0.21538597068089191,     0.026388508349194296,
       -0.1801907749959839,     0.019726121236650952,    0.014849214864857727,    -0.027861834627108912,
       -0.085016412265420074,   -0.010854058780470147,   0.022760766193543516,    0.029143300721687755,
       -0.0093996447749573504,  -0.0034618650589340813,  -0.033528730624576432,   0.20763475414658147,
       -0.083390547410773369,   -0.068865287468732994,   0.055203163000438905,    -0.18001646704854801,
       0.032836355733133003,    0.0085552847730916357,   -0.052211888838074573,   0.027743681287515705,
       -0.0026098561620280358,  0.10565187381137651,     -0.035585725356791852,   0.0057251270965125167,
       -0.051943247289966646,   0.074700287774123159,    -0.072317078954756878,   -0.024122756664466456,
       -0.05273871010647728,    -0.074322812972302213,   0.11543981299108279,     0.086829194668427187,
       -0.047315707249369073,   0.10245634901479025,     -0.29449819823802964,    0.046373030143182087,
       -0.10733015998699343,    -0.03879919527476549,    -0.091424555704995844,   -0.019856322783407036,
       -0.098809755560241255,   -0.11402930556599424,    -0.15228929471969227,    0.057575458424185932,
       -0.083274371204669351,   -0.15588685590931164,    0.081834127108702651,    0.017049983497968119,
       -0.0011907804093979693,  -0.018672429037274309,   -0.082853928478513986,   -0.047315827701750746,
       0.098540110488590626,    -0.20622563005976222,    -0.012879241684706673,   0.11239766505092172,
       0.14139516894476373,     -0.042367113117569979,   -0.11237155500702942,    -0.090586927501450004,
       0.12890752817686493,     0.01960185442048084,     -0.11239776769763636,    -0.026227331903350769,
       -0.17346091359496699,    0.036289455986072333,    0.1121289108113238,      0.074867454162918873,
       -0.031260467176340262,   0.1983976235845008,      -0.10663983349951622,    -0.027063195835129925,
       -0.15309046703345044,    -0.00033218798565584542, -0.22614018142074513,    0.053821258322254061,
       0.055716936282969497,    -0.022237369681879109,   -0.09749184897726948,    0.0020689959214602281,
       0.11053735895230282,     0.17830327596017573,     0.17115486970345337,     -0.00038992259831902715,
       0.022822923277184253,    0.0539886600650374,      -0.067426047057703956,   -0.15418628635301315,
       0.19692776273331902,     0.0887687901162591,      -0.24386225808379949,    0.061327730685324718,
       0.060527443355506055,    -0.016078313844421457,   -0.019727400724356383,   0.15235885705366892,
       0.083146381726328281,    0.086404693333455504,    -0.13085733273162298,    -0.049026580858974753,
       -0.082029472051687827,   0.083462257428490783,    0.016325132133659298,    0.029234366538927622,
       -0.027865272666156297,   -0.07020785428433271,    0.014463929171091416,    0.0096353752606607671,
       0.13424216317994886,     0.17025501797209674,     0.081518183279168252,    0.033477306331170222,
       -0.011011469009382418,   -0.075137026769952639,   -0.02952712658736318,    -0.1158409299984092,
       -0.17801624823118914,    -0.20464318874611312,    0.057977116298064318,    0.042802469460666924,
       -0.095522180607196652,   -0.028268384233392535,   0.16478080975005818,     -0.14877610693143553,
       -0.010266884944272726,   -0.016910247423235936,   -0.082103566986630253,   0.031849801615468153,
       0.12955057470680581,     0.17974077541930356,     0.032630912325525188,    -0.14908794709349882,
       0.035759709139140651,    -0.028448714863443705,   -0.059731964364581204,   -0.031178880297584061,
       0.17928630055580963,     0.029275461290000127,    -0.022881510426000191,   0.22272255427871587,
       0.19834351834686476,     -0.0043329564769993955,  -0.092987462691418124,   -0.025079503743535941,
       0.03699414608763571,     -0.072337468021742041,   -0.051178755408508185,   -0.13886400742052543,
       0.16240984229597613,     0.0076398019152996086,   0.087364348823444876,    -0.0058620808303884754,
       -0.13723161360223488,    0.064367412093271653,    0.048677003323697288,    -0.025918969229359892,
       -0.15720582339313624,    -0.048328128111938554,   -0.03584057005997611,    0.034194098273721607,
       0.093727869531755575,    -0.14368734634412775,    -0.07101390549022786,    0.068890324709261472,
       -0.10172869138415899,    -0.12650706526029198,    -0.18691827188655696,    -0.08412496480178798,
       0.13216960847922671,     -0.10884272432164348,    0.039561343037082433,    0.11985595191831615,
       -0.10287664229070248,    -0.092917949916437564,   -0.0036224095771000063,  -0.12554510245988285,
       -0.036601409904764154,   0.016462456014607416,    -0.073853354089080975,   0.077105211508111893,
       0.19313972574549645,     0.046857110349336074,    0.18184150177693723,     0.12058063861939486,
       0.020366981701927862,    -0.13606319342848822,    0.055929982354635074,    -0.085771122598778782,
       0.25476100927955958,     -0.049143938834504998,   0.078114896929005889,    0.0056071182551552783,
       0.0012428359572966875,   -0.105578858111142,      -0.0712652067249505,     0.016944976082091022,
       0.026820492670215964,    -0.013993331364413962,   0.011489293508164583,    0.027280440603884799,
       -0.028948991029041388,   -0.024752496786515796,   0.072431668425151641,    0.11930367238697931,
       -0.12045884620427701,    -0.042845216331398234,   0.049030789913694514,    -0.036839927302789573,
       -0.059932098258172653,   -0.0073670564786973251,  -0.11649935402518669,    0.1033140840960748,
       -0.0097690648482556888,  0.0081124242043629641,   -0.050289835710917698,   0.088172269126499794,
       -0.032101573423327423,   -0.15161527640128861,    -0.16681372572058809,    -0.062111640884320231,
       -0.18404825351935503,    -0.06267805368098299,    0.072330659684712195,    0.065356811931083156,
       -0.095579454154426258,   0.050746989549088004,    -0.057708659800459021,   0.14354840044330586,
       -0.12950055973971397,    0.030529632729560156,    -0.022289517685858212,   -0.021174521907897554,
       0.1493403643152891,      -0.10291222461872249,    -0.10257764125202744,    -0.1867048002754586,
       0.073359734075982133,    0.12597670117559057,     -0.16252092715466762,    0.12593453284477396,
       -0.071620961575002251,   -0.11264274250191605,    -0.010319123946969346,   -0.06541038010564626,
       -0.029724932374726534,   0.073417588125245459,    0.10127824800639071,     0.011236464163433027,
       0.03537336273688034,     -0.081356657175686464,   0.0079988042909181784,   -0.024900806709969078,
       -0.13235333215230974,    -0.18030703632930256,    -0.085575639306586987,   -0.060866774145343534,
       0.087501041998162027,    -0.16027073586888244,    0.13542092500672465,     0.19000766599975574,
       0.14164239619286015,     0.023992896866652218,    0.027150719597589076,    -0.12942767281648337,
       -0.10261446080239015,    0.23701086456772261,     -0.079457629503926291,   0.0062555168223350967,
       0.10410885952019246,     0.13993911575955795,     0.047873628202908379,    0.0091820115806993587,
       -0.074301929781546192,   -0.053840487920471657,   0.1119502654327128,      -0.061629570426009486,
       0.14139063103427219,     0.22910108057377832,     -0.0020376589493655214,  -0.032078770296155273,
       -0.069079665174625493,   -0.14194304198150504,    -0.065165310112194147,   0.020257143256787433,
       -0.094015021548227218,   -0.020039826145242981,   -0.062404334311373211,   0.09713348448840857,
       -0.14656872227265183,    -0.19317683322174578,    -0.051360962869781236,   -0.085911731865653887,
       -0.094272162390723849,   0.14338504217673029,     0.15310501725494535,     0.10893859712998483,
       0.046478266612518332,    -0.083209988508573252,   -0.053297781688413697,   0.0045882795519107521,
       0.0027735076054518329,   0.025102020117414036,    -0.0042191294224818727,  0.043784241732248007,
       -0.11639354947162629,    0.013684553807162648,    -0.085140497434592344,   0.053111209206490623,
       -0.040501776866041277,   0.094319648599062167,    0.14191240366072297,     0.023673961502753586,
       -0.0012524181360601579,  0.1261104923523754,      -0.007632066180778347,   0.0051627228897833067,
       0.090947623534363475,    0.090979671546724761,    -0.0011685093441500083,  -0.25033456337070875,
       -0.14142402548712629,    0.096215433668667,       0.11762738538134655,     -0.064884337101056663,
       0.0087247852835054193,   0.083063773630223728,    0.037911087579453391,    -0.093071192256483318,
       -0.19911982824805169,    -0.0090532442077373085,  0.14799580231385748,     -0.054668831359889661,
       0.14494295775088903,     0.059181784206448311,    0.087956736701578761,    -0.054610932672389707,
       -0.10873080142232612,    -0.03828074134146104,    -0.027166980707209402,   0.063815364588098958,
       -0.024490097067928571,   0.085096876872187893,    -0.074461557151790869,   -0.029724979324963412,
       0.24427738160206952,     -0.016539622611629876,   0.076703577644689241,    0.034487806957317069,
       0.085284179582625158,    0.13446487674764351,     0.090924668045560333,    -0.05218246407903665,
       -0.21584303400617005,    0.0099675382383923143,   0.065515254906312256,    0.010446489930789565,
       -0.06913804321966617,    0.17367594811848969,     -0.15423606412520705,    0.068816819490375117,
       -0.053521704826029727,   0.045721401969294966,    -0.18186119320430011,    -0.062163506919784589,
       0.063095970854581407,    -0.019372955503292655,   0.071935451183402832,    0.038198760963466256,
       -0.010398379517478558,   0.033569668654211446,    0.10677163734655731,     0.044040864601188258,
       0.028392423371900209,    0.19875136152116066,     0.0080717181288218129,   -0.073941397015237567,
       0.13804586666509525,     -0.014290496624319905,   -0.0253662062463943,     -0.024468083388978629,
       -0.082861359640059695,   -0.096959927876818106,   -0.054249528199988746,   0.015426960606300229,
       -0.12726409533302929,    -0.110393746577003,      0.064675804446488003,    -0.034222086456139451,
       0.093597829702836227,    0.11715913941934705,     -0.18036364380239864,    0.023305505371959079,
       -0.069624577124835746,   0.047068087831995967,    0.10722677866850805,     -0.029965229506337628,
       -0.19913649861261726,    0.21125161538893178,     0.033570267182437406,    -0.096585083446304107,
       0.050227669421727968,    -0.030865280341891333,   0.0024025154568215225,   0.2352484009448583,
       0.13674845610957009,     -0.15169302060632864,    -0.010305299811925375,   0.04065715481746366,
       -0.046668103527087772,   -0.24090723880207066,    0.030133060834550057,    0.13992551820443391,
       -0.058988361749617427,   0.016201979595284487,    -0.03253085160789905,    -0.071712219768307522,
       -0.26840606636205677,    -0.0026281046692402952,  -0.010615357195199879,   -0.050480658102533181,
       -0.033784047275363771,   0.092217961271598994,    -0.01049593739218879,    -0.068167149213903863,
       0.04612704551617422,     0.10397515977320455,     0.039416138176300464,    0.17411535874555789,
       -0.051647191252587182,   -0.14142823985066322,    0.1983214658412395,      -0.13038578551551533,
       -0.11807503631934342,    0.0075433668997991121,   0.01035988962267236,     -0.012806023284489917,
       0.0010285409678714962,   0.086883783537040113,    0.10102813767999946,     -0.041956102181316443,
       0.15374726471998276,     0.13453960228475795,     -0.0023532041443828922,  0.077522483297831041,
       -0.056171374963514473,   -0.018058071570832619,   0.029142987469061146,    -0.16008588561212228,
       -0.056062521088112119,   0.041449346534585887,    0.16751383484248758,     0.099692531361141479,
       -0.031562839940645855,   -0.034126427989043577,   0.11562616592278095,     -0.041104829608193109,
       -0.079907047293222705,   0.065507355608715803,    -0.033626894502797641,   -0.11600417075750842,
       0.069716218855524439,    -0.042718706912836704,   0.022706866021010585,    -0.087364872939992039,
       0.085143331398924105,    -0.084148994649178965,   0.061013376994304862,    0.12034158222711705,
       -0.067795590925527102,   0.19397289398617421,     0.10486823884855345,     -0.16746806279127074,
       -0.10825429430732347,    -0.08266318203481475,    0.077974010418285014,    0.067496023181759554,
       -0.13852054602786687,    -0.10508188438816397,    -0.063138246861700331,   0.027721218087416594,
       -0.10580436050134517,    -0.22124637120471655,    -0.067297300707656368,   0.051831202390468005,
       0.15000748877579814,     0.13249977473768482,     0.070933030125910179,    0.013265204091030179,
       -0.04952158780933559,    -0.11250274999408608,    -0.052460244304763044,   -0.14881654974877545,
       -0.022321707702825641,   -0.05725831773364011,    -0.071673377273670943,   0.16109205099700857,
       0.089550111267069327,    -0.012293618723850461,   0.15688565593420978,     -0.007112462137196956,
       0.061630879043469027,    0.081570017703754216,    -0.16165543925364312,    0.12728973606722782,
       -0.06122242292058435,    0.012788239467826827,    -0.036744151004614034,   -0.16853146136502908,
       -0.17102598899562976,    -0.042724448153372972,   -0.096134925641396418,   0.11170724893247327,
       -0.12527428077761471,    0.099525986291215091,    0.09636972190675816,     -0.024097736619331879,
       0.036819556913589714,    0.11162462052492858,     -0.079524177444514538,   -0.035493269921142309,
       -0.035370090693644121,   -0.099758979888364283,   0.0133995228436685,      -0.098361048939516138,
       0.051649389503604232,    0.24538774202197444,     -0.026268762977961588,   0.050945729984319843,
       -0.16207791327426255,    0.091804316669587771,    -0.17129616086724375,    0.09293800850382572,
       -0.018077288557465637,   0.11492114146836509,     -0.011713604084267519,   -0.15883783738621818,
       -0.0025652268978980227,  0.023767801049559202,    0.085158087332882729,    0.16484686399544843,
       0.13947397880931703,     -0.0082726164265863912,  -0.10463069718513555,    0.068294816439490189,
       0.032435119312697977,    -0.1245375478256924,     -0.078045489669034379,   -0.055436517046421982,
       -0.097438992720097525,   0.02734890852144348,     0.069404074782572378,    -0.15087000969083517,
       0.084164982318770176,    -0.1262031985798886,     -0.069753802086219521,   0.075524054019641962,
       0.030445478913928414,    0.01642888210281299,     0.10031626276997159,     -0.12214946003305431,
       -0.070974480218212302,   -0.019525897395246922,   -0.13544002046819148,    -0.027831077025426448,
       0.017546166549501693,    -0.17813517924601291,    -0.066854750762058601,   -0.13419514410471561,
       0.019163672257880369,    -0.083404965620115387,   0.12361418222941001,     0.027348433821117814,
       -0.04949898164021152,    0.071134656356077658,    0.1194389408771179,      0.11766832341583573,
       0.11255649071883575,     -0.061382987329073081,   0.035265092239806839,    -0.19997458822643391,
       -0.036745512457990084,   0.27520660987542245,     0.12727421527190033,     0.021506075554422802,
       -0.019105507146149683,   -0.10476740399174983,    -0.13599401461445032,    0.031923122521756789,
       -0.071773759618985716,   -0.13037347121510598,    0.19675386914272605,     -0.052415204540304565,
       0.022962188319830237,    -0.075412346431861788,   -0.049738471597222285,   -0.030786566022407889,
       -0.075681929830379358,   -0.042373486706915972,   0.089393792535352179,    -0.14400534770999332,
       0.067381494632417022,    0.020350344025155637,    -0.18623184322234951,    -0.13019254378415082,
       0.059306595270040133,    0.0093144129884330969,   -0.088370765643880356,   -0.017176087057409764,
       0.031393821129761829,    -0.061090519979661223,   0.063132715351443158,    -0.14527222931154654,
       -0.093197705277429488,   -0.0097442968830690549,  -0.16680598568731839,    -0.045323009266148816,
       0.0047938187054589049,   -0.063555555851214848,   0.0303788091824699,      0.11281886189357894,
       -0.033355800239459221,   0.020326359896712828,    -0.083091365198443554,   0.020766663209232681,
       -0.019067679726853706,   0.035660150718497582,    0.18906314240794719,     0.031207963969871671,
       0.063754684213602753,    0.20350353969086354,     -0.032787512931372075,   -0.12996549638058291,
       -0.035376089091498558,   -0.03047640646928277,    -0.097037624700069935,   0.040310877865502248,
       -0.03167000767208001,    0.02044796745049279,     0.0067303623068570755,   0.049043390092996214,
       -0.037768764256136247,   -0.24350311693720159,    0.042725417014587284,    0.069960386856385545,
       -0.12855297847567249,    -0.10928884286152567,    -0.20623485598495819,    0.12853585081976032,
       0.082732592340953037,    -0.061199639230671586,   -0.083444159062541046,   0.043620592238414836,
       0.053521313542434834,    0.033791254699829305,    -0.013988865961734272,   0.070861927410326528,
       0.065700528269803493,    -0.037035818286336931,   -0.12380101839694628,    0.037597454401105658,
       -0.093684654003250489,   0.075779206189442172,    -0.02218427412827691,    0.0079998073488403015,
       -0.16550394180664904,    -0.15749109821597806,    -0.057140244530167229,   0.085246425937567941,
       -0.1659952867623985,     -0.031764572838310155,   0.16136027000247397,     -0.00083787120354524946,
       -0.10361890043476599,    0.020429335587683006,    -0.21215928334557618,    -0.071883024265721615,
       0.10612144206974641,     -0.082356256395488381,   0.074824801762556709,    -0.22265785007423625,
       -0.03674122218905513,    -0.17580024871229452,    -0.097065122532410106,   -0.0096802637308461368,
       -0.062574270034521318,   -0.05046601503465014,    0.058124309683899686,    -0.013154941323447923,
       -0.019712434392974168,   -0.13073896965402254,    0.0093808092531813565,   -0.13907898498271204,
       0.0074208752117484811,   -0.023897250912085548,   0.19595736070469952,     -0.11577065594498065,
       0.073687016098711339,    0.040739765895272555,    0.096236027066422813,    -0.013357462734856815,
       0.21094451271038553,     0.27675028886288561,     0.059579535203828714,    0.076937044674019156,
       0.1469306152515821,      -0.04945751549284564,    -0.0061467423639856257,  -0.027470718427566706,
       0.06024821475969775,     0.0087546816943785515,   -0.012421519082519757,   0.074321701636930498,
       -0.062098200594923707,   -0.12948740765951869,    0.046768758248378423,    -0.032976657663864775,
       0.17395646336735304,     -0.016447416179846266,   -0.013136592317653982,   0.12415310550448951,
       -0.072624853216805479,   0.11197597655057034,     -0.045668457355385966,   -0.16852470403838823,
       -0.10428531354886576,    0.0097444406335488419,   0.15147174182379552,     -0.15754290857058109,
       -0.012615657332776642,   -0.011183450692453899,   0.0029002282183449722,   -0.078876206971114596,
       0.042564353682702866,    -0.073555993938117403,   -0.084877033770853899,   0.092806869513789123,
       -0.044021869306320918,   0.056696295913649837,    0.084150338848306722,    0.068271901489994721,
       -0.042778343316124082,   0.19682266213871177,     0.049552330338507145,    0.088783201163385311,
       0.069469966006838316,    0.061862085221858674,    -0.14167322630640083,    -0.052734944745680273,
       0.15168455364151909,     0.0095767094034249628,   -0.082548717254657428,   0.092376781582033482,
       0.034670707906431161,    0.046015027722682011,    0.059513958990567495,    0.20185131473735238,
       -0.03595648928880793,    0.032309248401625107,    -0.040123401520849013,   -0.15387960196802741,
       -0.062345398650178671,   0.029204962627335841,    0.039906803929323012,    0.033532954357153991,
       -0.057377084409933075,   0.12121539983964376,     -0.023227399119004229,   0.072715886635719512,
       0.035237163378580835,    -0.1318024476995289,     0.044391550994781273,    -0.023627440303994773,
       0.19986942918387623,     -0.098851594112107588,   0.11060699148018958,     -0.051795120234842736,
       -0.057572129796499998,   0.22352468953807605,     0.16630519154502824,     0.1211801766215507,
       -0.18852264322840276,    0.15162580703031711,     -0.037570302498551165,   -0.066159172736750982,
       -0.041218013235893573,   -0.075286628057089203,   -0.0052899745313765411,  -0.11220376364156034,
       -0.044727640448471578,   -0.17367663321993984,    -0.11925154681997836,    -0.065643860046537036,
       -0.13090492677441973,    -0.21928542931992837,    0.19952477108305494,     0.16795828747879288,
       0.039557821800842115,    0.00015120220416555384,  -0.03537437688781387,    -0.13390989439695708,
       -0.14024596350093135,    0.033772833993059075,    -0.17552301388277941,    -0.048463880055081267,
       -0.10264332609276706,    -0.0501032899786008,     -0.027266865282627038,   -0.040184202981954527,
       -0.08092837898123359,    0.19516507928420052,     0.029404965577812532,    -0.16488739245099082,
       -0.0045696403928397814,  0.10298879192050021,     0.11611512397447941,     -0.058385217836441218,
       -0.0057350497743386764,  0.064073031281689591,    -0.057924242478115409,   -0.057742396210074737,
       -0.13226769404048985,    -0.069728295343120125,   0.021872120437285151,    -0.15000484527814573,
       0.085427609363852686,    -0.046244106198450909,   0.15005489318186047,     0.013941385371524831,
       0.015976479553717827,    0.053705520809890855,    -0.041076964850473061,   0.020699214656555689,
       -0.022162467860057485,   0.002223250128702752,    -0.074271702799672129,   -0.026572964005580065,
       -0.040845044106167169,   0.0039518799657967396,   0.039251777070177074,    -0.12952812688950802,
       0.018634534886985025,    -0.02030393412564523,    0.067469855835424503,    -0.14822953129652833,
       0.15076355413456141,     -0.016970534557366298,   0.028169972764706314,    -0.038628787271079927,
       0.13348714786739169,     -0.18420690709008999,    0.053914007634638168,    -0.022543503859398017,
       0.066248713154196767,    -0.055440676345740875,   -0.0024474269199368107,  -0.023951360260706982,
       0.0034751883122265269,   0.17868100179449597,     -0.1575148987417333,     0.046266851642717516,
       0.06778912809240803,     -0.059631624584459822,   0.0050503108688898218,   0.024947209844415886,
       -0.16497212272839668,    -0.0087366399571602773,  0.19813662272310129,     0.17142720830731123,
       0.00044727372216204933,  0.057056328378694954,    -0.24377491521777753,    0.046302506037858494,
       0.033753415932827546,    -0.06757053619714487,    0.016762996078513785,    0.18388392883438193,
       0.0031646365185613945,   0.050822635971482615,    0.037877964076509563,    -0.17758111802447393,
       0.23837525639150006,     -0.02575591071567325,    -0.011593247424001748,   0.090567807479671247,
       -0.12995735782161799,    0.058796506076677586,    0.0068525557120303997,   -0.019880766117219676,
       -0.23587694897793723,    -0.06638572917318708,    0.10883649023177683,     -0.21743087493964225,
       0.053201662604376809,    -0.12262580106999246,    -0.042763387764223948,   0.10415124799946045,
       -0.031703026311640591,   0.053697326223101666,    0.20693292344870051,     0.15817591962695945,
       -0.19525808516177701,    -0.041577903862377162,   0.053253604417964139,    0.0045587934886982141,
       -0.09189978107401825,    -0.019791200677043111,   -0.012904353491398707,   0.011223784871164766,
       -0.10312007602650694,    -0.1452455748946625,     -0.094382684552589052,   0.12029630365744466,
       0.037311693399249897,    -0.16958428928011723,    -0.0065377812761809821,  -0.16348694367100639,
       -0.048857448131285612,   0.026245023928181756,    0.17573302719547498,     0.12414138861413027,
       0.18255808738405391,     0.0087517749790859949,   -0.0094475407200664482,  -0.17171063456861879,
       0.043243568288176895,    0.1166218583483124,      0.11738153785422416,     -0.098684143839962393,
       0.055969366566642177,    0.070838529618325027,    -0.028443835565398722,   0.11001938998759463,
       0.097819085658905125,    -0.025853459003329516,   0.038002161704328172,    0.080029258598608127,
       -0.0033556050139754243,  -0.030799371552517933,   0.014479046916679873,    -0.037006486625237714,
       -0.12964545805298378,    0.027426046841433474,    0.052083796037826591,    -0.075199479580897621,
       0.00056461790745967674,  -0.010880861337780578,   0.075106596379484247,    -0.060532496013124965,
       0.035672105190057091,    -0.013843600013396042,   -0.088617880202054106,   0.028507955672393479,
       -0.14252608443688045,    0.01739308880496385,     -0.25447591699847932,    -0.044796858035456001,
       -0.044180337784078302,   0.01902039107594428,     0.031109992411692731,    0.25635856664771134,
       0.02996346181993163,     -0.073310452344144406,   -0.15632188254244286,    0.072253378055848819,
       -0.0021158227686635615,  -0.16897587749743789,    0.0061244655204684799,   -0.043611493507260853,
       -0.14703680148367959,    0.04951772870588704,     -0.022299603991004752,   0.14603454188372442,
       -0.060298968874678359,   -0.13782106682900613,    -0.027280495389017476,   -0.039103603663144824,
       0.037349540576989984,    0.11031121519598826,     -0.13101600348069165,    -0.023746441482483262,
       -0.22846890681921694,    0.02858654371320575,     -0.24955472135123688,    0.28308103871498003,
       -0.061153795420545144,   -0.004224080480848773,   -0.084853705771306354,   0.16455559404093245,
       -0.049576509183629811,   0.11128807498657083,     0.052690029065864577,    0.043421934012114742,
       0.041872402027755273,    0.00054839416755225572,  -0.10121724886570571,    0.057358404611701261,
       -0.054357317520858289,   0.064133899877416481,    -0.040956876929494249,   -0.066957207182209197,
       -0.12228567968935286,    0.060556563094760089,    -0.021051704820974189,   0.0074449295614222102,
       -0.066170034019496241,   -0.078155306759943949,   0.0092177413741872695,   -0.11570242253511219,
       -0.0715236383845404,     0.076013050103828139,    -0.17035961749243494,    0.021742518096624044,
       0.16747427500075512,     -0.084309581922705171,   -0.045783550613019988,   -0.022362404897248715,
       0.10893142552251045,     -0.0090479825352486887,  0.033114816733219164,    0.032427972696871948,
       0.035979234268620569,    0.17360081733154678,     0.070197164846593302,    0.079469402273313991,
       0.078400002611670155,    0.092016965094120801,    -0.11123898444481212,    -0.085122693219569806,
       -0.21853106767862093,    0.01169249630532692,     0.14157917098042469,     -0.173546198762975,
       0.011945587425321473,    -0.053120634558163612,   0.019772337025519508,    -0.013387644855603616,
       0.065010383235013416,    -0.14120148665821061,    -0.0016453978284290932,  -0.10913040082423767,
       0.044533866110063769,    -0.20474134890571491,    0.040150109911090665,    -0.19163491571470506,
       0.018964295073296583,    -0.14394493590445531,    0.13547348714947532,     -0.088747518500251962,
       -0.19517769246308972,    0.054704013327220358,    0.027094536281818394,    0.09491327102997707,
       -0.099839023252935422,   -0.029298588038897108,   -0.16427192971445728,    -0.0083115186243685607,
       0.020651499671346225,    0.0013270309090740204,   0.1452586305129259,      -0.04323684583475499,
       -0.056377217064777184,   -0.22454270877743102,    -0.0047089792027014757,  0.13240391791555353,
       0.034162343829371299,    0.088290149502256055,    0.079001926074381154,    0.034412506007278187,
       0.12130694508613982,     -0.16234423152615596,    0.0074655959135335372,   -0.21439966662848017,
       0.0094363552187104252,   -0.0012633269848022106,  -0.07172404614244561,    0.011863831360466003,
       -0.084029621748297298,   -0.036930690244269378,   -0.0042270888863580498,  -0.074238635016075624,
       0.071972033251760992,    0.03426794014963553,     -0.18054226894789091,    -0.0039891525703540688,
       0.057429256725921723,    -0.036630193300708019,   0.051638130629999883,    -0.23880195787346065,
       -0.024327547897399028,   -0.14774980020443568,    0.083097349860262029,    0.0026349090264848156,
       -0.020683742534303183,   -0.18058996354106011,    0.09815245302443365,     -0.1665067578348868,
       0.059315283467291022,    0.0013138140262925098,   -0.021962180678099373,   0.027271225454248288,
       -0.096899543348591022,   0.087737504928119797,    0.033964039103127251,    0.072065868345605619,
       0.054731739796210654,    -0.05201441855427779,    -0.14029551202965407,    -0.031226268231033527,
       0.20595377782040786,     -0.058029102500772006,   0.053641733447120074,    0.10838237819626488,
       -0.0412743201725378,     -0.013070401662155347,   0.050321077660151189,    -0.023248935074780326,
       0.014560192689716188,    0.03127992554285107,     -0.043101014579500031,   0.10911066216915442,
       0.19205594111749619,     0.086212509484267383,    0.082502088461118964,    0.14025251189331917,
       -0.1600464154556577,     -0.18215919265330918,    -0.024640071503487612,   -0.073665433972304711,
       -0.1003056989080589,     0.1610667256077194,      -0.01831105254675653,    -0.087866460754744122,
       -0.073840661370020627,   -0.14685621066969984,    -0.12925286794139215,    -0.1077603941874553,
       -0.067391026674059967,   0.051922411158922738,    -0.15388735628928607,    0.019813203753535732,
       0.060444359827452054,    0.050863400246152539,    -0.07792777000108167,    -0.0055135392440970625,
       -0.087631702406829978,   -0.0823081789174923,     0.06448691280213685,     -0.030220985517122784,
       -0.041006399543923072,   -0.0071726680950973858,  -0.055496611378103418,   0.10938025525546693,
       0.038527103561307854,    0.053433613644060643,    -0.085104351677490364,   0.078103208005945515,
       -0.0094332952411070991,  0.19231042356285685,     0.055868558950603046,    0.038621565531071309,
       0.04292525434067835,     0.053543186972409784,    0.066275207705488073,    -0.036575541018403539,
       0.099524946008039253,    -0.19679300064454108,    -0.054381548446541562,   0.12562941941693456,
       0.15573475486540697,     0.049026080614740238,    0.072408689444743185,    -0.022866455579969316,
       -0.043451890322893594,   0.033604798070932099,    0.15541005448127357,     0.23400354424252318,
       0.019547074026050083,    0.092391388088380766,    -0.0089641243343597903,  0.020735147501282393,
       0.054136363476079224,    -0.075102874619215568,   0.16529573699646558,     0.11741998389638417,
       0.044560960130024592,    0.01675502257392578,     0.003899960095710372,    0.10621970301214391,
       -0.12975376691539564,    0.29326535568756806,     0.0075148650067779609,   -0.090600722763067548,
       -0.11438614890922767,    -0.067698223023166415,   0.14486792748030186,     -0.1745530240276868,
       -0.16193575218120443,    0.044916637354258854,    0.025688095788350681,    0.094558393319960354,
       -0.031973864206287138,   0.10316301229699461,     -0.0700878788329789,     -0.074137557815455529,
       -0.058905711393334642,   -0.14966767077736981,    -0.061728317886419297,   0.10335051471319974,
       0.077056584639373205,    -0.070448780344908965,   -0.064119151379234962,   0.065505631897173483,
       -0.0249691957823285,     -0.16883231911612442,    -0.057192269101565017,   0.067010790124178196,
       -0.059792402239808508,   -0.12505700193504216,    -0.12087120946540016,    -0.012057011882678421,
       -0.12609964399130552,    0.056386515556105882,    -0.16718430888600197,    0.084360189195752611,
       -0.21002974571328759,    0.1280476980824285,      -0.014814069491297542,   -0.034748423719016833,
       -0.0030593384240693161,  0.17807380657733943,     -0.067205286367960484,   -0.08510452586757962,
       -0.17545087677218679,    0.0025626644481250879,   -0.033107099926905081,   0.13464919231590128,
       0.11019654847791484,     -0.12645502736031555,    -0.012609598200215264,   -0.057244589372441229,
       -0.12507020407230204,    0.052117474882924356,    -0.074952470829651036,   -0.15971462557459842,
       -0.018485442225115271,   0.073953621648689488,    0.0010050487711938901,   0.10185605854368993,
       0.028969930661718563,    0.063865688670105863,    -0.081157468243233458,   -0.15614217810416736,
       0.070787030087666458,    -0.052468146728991895,   0.11266198940892151,     0.12824947566455069,
       0.13721922614920526,     0.00057388514910590807,  -0.089803098847819465,   0.05091997991786959,
       0.080384415365257603,    -0.17107193976200297,    -0.030774756724721214,   0.10562042930332187,
       0.076761947360062435,    -0.081896392770675813,   0.094248695496210205,    0.061850965386906355,
       -0.13681340883473378,    -0.13944890073750923,    -0.13081425247806749,    -0.17644486397946701,
       0.044327701792618003,    0.12921505328152325,     0.16728744110184579,     -0.04121945679037399,
       0.064879848201636017,    0.0076279342516085511,   -0.042656035260435161,   0.032876863264918607,
       0.0082234509346353589,   0.03189789472735062,     0.0030496890290915568,   0.10132264475880309,
       0.026264486827609516,    0.017306926890037579,    -0.092293155399260654,   0.061669411713011477,
       0.02968897476133919,     -0.075296546681948018,   -0.0010937419925093218,  -0.052696314337279795,
       -0.010100062793410917,   0.087726785292677883,    -0.039173395189847443,   -0.13410023690552234,
       -0.13259369188142017,    0.093816275431204993,    0.12573479674611043,     0.011869296174592729,
       0.14299145329224303,     -0.29467662345978413,    -0.033687052280642241,   0.16021211708787114,
       -0.14947605610280112,    0.075857365735983798,    -0.029542967480662669,   -0.13776336715031745,
       0.021819350487121778,    -0.0020514304965166472,  0.020629353149456207,    0.018131205074722937,
       -0.053872729146587889,   0.046299295472047405,    -0.069861921188812279,   0.017343433550596806,
       -0.045063412391491857,   0.24271799133085037,     0.052305092490983709,    -0.21652832945331213,
       0.10958295835523688,     0.11993075853500239,     -0.14205488758925133,    0.089655946706498568,
       0.096683977887240036,    -0.062731486620654558,   0.032526776091073753,    0.056600711695161544,
       -0.013877654222092455,   0.018230885890460069,    -0.079822435784472276,   0.049119491209966566,
       -0.023816034009751418,   0.11171702835529185,     0.058315089920394282,    -0.044219053401145618,
       0.017397218392306138,    0.21162867660253962,     -0.19260026807538594,    0.090840371206885068,
       -0.0010257099798612543,  0.051115818649732067,    -0.33877871637682822,    -0.060897425781203378,
       -0.24944285117798115,    -0.052071964521528388,   0.04053387541350973,     0.057852677857221924,
       0.20432374579776547,     0.0076157127919506259,   0.024373345334541753,    0.14000487575536083,
       0.070536979880301748,    -0.05294341242355647,    -0.1274332975053217,     0.04316506876660324,
       -0.00019744907496017537, -0.0022107305914209376,  -0.11520102957307919,    0.059977457922668995,
       -0.062564446090287093,   -0.072971892849220454,   0.11198561558102171,     0.186871129702957,
       0.058396264001021637,    0.14693704712841441,     0.052928693015961287,    -0.03535042688250823,
       -0.10158676020870178,    -0.14695137189769639,    0.025909571751620453,    0.024092620374773773,
       -0.030655776581101319,   -0.10160485697805291,    -0.053486153035876081,   -0.0086191617266296646,
       -0.10780274135230847,    0.098095040593218982,    -0.1051671511459719,     -0.073919890216683021,
       0.090658450171698296,    -0.052200514359676098,   0.0099848872865745068,   0.017494928238685797,
       -0.01578669500212896,    -0.022064892933961303,   0.15128687420506537,     -0.006123416722687236,
       -0.089404279641755471,   -0.06754562995287075,    0.11282422452775343,     0.052108553345028577,
       -0.16776501016837225,    -0.05175514149337495,    -0.01653841756252231,    0.038002774966708314,
       0.081339293042126545,    -0.012198889025485252,   -0.0099983482246661769,  -0.24951950733777725,
       -0.051254237559427124,   -0.18266992114838113,    -0.039873887641590222,   0.08875093409238273,
       0.056490300481101617,    -0.054790429647483561,   0.064037390689609452,    0.024081519399565689,
       0.12779687550980512,     0.071849424180877336,    0.27652376440534887,     0.037961251775795006,
       0.10100431132602349,     -0.018760151066181379,   0.052753550168689371,    -0.01384825492855358,
       0.015400578393407414,    0.012471449123098484,    0.13709877814028634,     0.04982666047829399,
       -0.10073519960952254,    0.042083952205242255,    0.011752060193265811,    -0.073323072905103259,
       0.024385963713820912,    0.069983313207225131,    -0.019094555224578778,   -0.17860480627801817,
       0.04239958921238704,     -0.11575245168036655,    -0.20337203919785293,    -0.16662887694273018,
       0.15436893943671637,     0.040488357803306521,    -0.19317712473734824,    0.048322908379692206,
       -0.097137224520091062,   0.015028757509208266,    -0.011993390709206405,   0.067621096720710316,
       0.063957730113454805,    0.031732040056215521,    -0.00033597628959838085, -0.096822174376919784,
       0.011680624542409064,    -0.039012446761263996,   0.018181210177134807,    0.011342224222225829,
       -0.17657572482409783,    -0.024467366196115635,   0.080527037755628847,    -0.069805153984675933,
       0.07434183683847144,     0.032015663442342794,    0.044382096636107544,    0.069709345345687374,
       0.15509465577280679,     0.10994356879434269,     0.14393981199447309,     0.056319166309834308,
       0.11305228736862291,     0.018722087417381291,    0.097065783104225756,    0.1346103452491034,
       0.015059953656969813,    -0.0096097051024124931,  -0.0084852170456016281,  -0.12297967774941088,
       -0.19683838355604513,    0.10893462024385543,     0.14783293042712509,     -0.061948011560612283,
       -0.084304089591755185,   -0.021935711849915319,   0.07397379744854593,     0.061922641293565735,
       -0.030095610911723608,   0.20041901754932692,     0.016384569538067842,    -0.064850129323852382,
       0.081442216290535038,    -0.15547815358782086,    -0.13075551434796973,    -0.086332507479097181,
       -0.18144463668026453,    -0.071813202753060523,   -0.15532162656089507,    -0.13038038072232561,
       -0.0079156548462829598,  0.12667456168753438,     0.0072853400099281897,   0.13189388258583354,
       -0.0093141121404039101,  -0.0002237317957338767,  -0.17359679849275667,    0.0083173716782624536,
       0.21279132482418348,     -0.071455091964750986,   0.059078694764335936,    0.05327248572582749,
       0.10224211348248458,     -0.059850259942209195,   -0.13743201733430543,    0.050658495269462929,
       0.068696846549949092,    0.12878147302396431,     -0.074626333534782971,   0.028791886964627748,
       0.090970677856614668,    -0.031920341833767837,   -0.18970047771979665,    0.042734367458645409,
       -0.032488936964930319,   -0.045232888991658199,   -0.070194811325557563,   0.033914140525919526,
       -0.11714323485785938,    0.021321852757564871,    0.097348440404637457,    -0.12987094476406558,
       -0.012485879821596354,   -0.15925840428512192,    -0.0059911898419112448,  -0.052026706429041052,
       0.033691380944305876,    -0.16591462647648297,    -0.23069756785583467,    -0.045811033028002587,
       -0.057162634627479531,   0.13883506221403713,     0.02816933303942059,     0.1365500559474313,
       -0.18849998989431674,    0.011419689259106875,    -0.003396478925740771,   0.074773544939280387,
       -0.025486075615511104,   0.0062870424927713945,   -0.14067328612717617,    -0.040214957276872604,
       -0.01924819733891623,    0.014905335451846271,    0.064405711576992541,    0.10041044728302902,
       0.15635124519015334,     -0.041037010517301145,   -0.12570644129185407,    -0.12925697394025737,
       -0.084610186647728416,   -0.063586248215690547,   0.028264597929267984,    -0.1056361278047466,
       -0.061545868507564404,   0.047401074231421293,    0.11680858772866612,     0.079176937096053807,
       -0.021940818034381006,   0.13006810010364281,     0.050234133613630341,    0.1143441820185128,
       -0.15185499786234738,    0.039388737663978393,    0.10125708745189675,     0.30774028438480139,
       0.025334514731414161,    0.10311608528050403,     0.040689800583822336,    0.11998272138372408,
       0.082716468512997701,    -0.08259505196901723,    0.042553064410803254,    0.047605148929024878,
       -0.25149725621032282,    -0.01171809766316269,    0.025708452033806554,    0.039455309029761645,
       -0.079243444631628468,   0.026685392363719865,    -0.0028440125966036692,  -0.20543350280409647,
       -0.043258499791180127,   -0.028731675969649397,   -0.021646416737740173,   -0.069729153654559561,
       -0.14236857475940085,    0.0093441127091458374,   -0.035251101694897508,   -0.00091854664391087006,
       0.06793497629114148,     -0.071780779113341686,   -0.17382514321827991,    0.19752974968663184,
       -0.012806812941869642,   0.099180288702018476,    0.098686883237092821,    0.1659836663746049,
       -0.044606019929345694,   0.014775633717176044,    0.10725358184940184,     0.063403738901311374,
       0.029106828214534048,    0.058667454992949869,    -0.0085439690331668809,  -0.14617106329398055,
       -0.0077318289955706733,  -0.059209599006145648,   -0.029242022259312168,   -0.19182328384251485,
       0.03657564927044004,     -0.025188724889183892,   -0.10473637798404647,    0.079321147664752345,
       -0.016728511940190906,   0.026317133559986133,    0.15388128888597885,     0.11679257189373168,
       0.057440100896150183,    -0.12755729332405719,    0.082179610358790914,    0.045475758204258546,
       0.017316452750271185,    0.21112095020158408,     -0.050027727638693696,   -0.0061200391941764552,
       0.028622489369129107,    0.003828207975805483,    -0.030050425429550151,   -0.010964272379380675,
       -0.088667666128945499,   -0.049946743406755902,   -0.034951265325514395,   -0.0075485459303326445,
       -0.081775983257915921,   -0.023303649991108143,   -0.06703009557231597,    0.057568823335360834,
       -0.017023046574567192,   0.17063303775329774,     0.031402038871235084,    -0.011464111690946365,
       0.084245372968944188,    -0.10037755579067921,    -0.069828318764605768,   0.10100098465367208,
       0.23659215774518771,     -0.15388087241615633,    0.21275052070542641,     -0.057464818758969166,
       0.046518486407567054,    0.15610715283232371,     0.019979099476511553,    -0.031183377600527327,
       0.030883397745312496,    0.044998857160440588,    -0.025206297116506814,   0.08082700461185971,
       0.10642307552142495,     0.039461943499414523,    -0.20693657203736288,    0.27592193494912531,
       -0.060624662722367641,   0.13861504350480605,     0.22321669567866373,     -0.073161957972635749,
       -0.023620921108686365,   -0.023334448686369604,   -0.028704460276525567,   -0.04029707313526576,
       -0.10028820412316937,    -0.15040180900928937,    0.0062268105182608519,   0.045550202831693795,
       -0.10605974287995523,    0.07181894108534341,     0.037430154629599525,    -0.18710053604084079,
       -0.030980529982920495,   -0.080908061498409178,   0.27280789667613853,     0.065471450208479873,
       0.094273100011928818,    0.026609591899749048,    -0.10478478768285045,    0.074616064172357971,
       0.080537551511897912,    0.071640163992640352,    0.11973259956310085,     -0.015091169705388341,
       -0.025513304643409094,   -0.056534734570711051,   0.10786672154464014,     -0.076834989278782781,
       0.12063789046088406,     0.094301175668984702,    -0.17642819801593812,    0.13153797314951676,
       -0.12257353551528508,    -0.056829733197297186,   -0.11755902307291703,    0.043154921958822014,
       0.043286159460139986,    0.091644552563915432,    -0.04633719452079893,    -0.032911662474386968,
       -0.082629747463731751,   0.033391244467701225,    -0.039442495598102124,   0.13889245598620667,
       -0.13101334659021979,    0.073944822369721136,    0.031032057263359756,    -0.057933201666219306,
       0.13886601539789342,     0.14328096754952901,     -0.022782343159417122,   0.023363366084019888,
       -0.021021171343062573,   -0.16448166405677492,    -0.068824101649761549,   0.011826305639617403,
       0.058660361893405448,    0.0033788174558998432,   -0.064497620115654603,   -0.12592933611133916,
       -0.12163553308986881,    -0.19556740409735293,    -0.15892259718870211,    0.11887815626081191,
       0.12003475119266291,     -0.089184073190352736,   0.01148666374694008,     0.035206630901467015,
       -0.080203851226133716,   -0.089903186833880197,   -0.040829176023886235,   -0.0081175797581469738,
       -0.18306389310382418,    0.0086856663650316107,   -0.075913873508875698,   0.061262749906989426,
       -0.053406980234860582,   0.083563648431720039,    -0.069775583876894198,   0.07199020547811949,
       -0.028784709919342167,   0.13130426268526982,     0.10481531004329696,     -0.035827240423613696,
       -0.067130055275102546,   -0.025288618262022541,   -0.12111775102117774,    0.020688700586898784,
       -0.23835171071167222,    0.024737917910666828,    0.077782243062750042,    0.042421587907972881,
       0.11032844927137231,     -0.029250540543193759,   0.042744835260040262,    -0.1319561167518899,
       -0.060584892235428602,   -0.021517290958585983,   0.079567268017547405,    0.0264138209318804,
       -0.021966037842096151,   -0.14814195776002409,    0.089460928181521751,    -0.080893166235003811,
       -0.15546871992871059,    0.075927869920906707,    -0.04093320714242496,    0.004855343348194042,
       -0.18210047936054374,    0.15496748066549071,     0.014104252482040149,    0.081885612209654457,
       0.058724246955236481,    0.084418862420776841,    0.068553512818064835,    0.12938872690967856,
       -0.14251060874575225,    0.046936526633609067,    0.0044198804364999943,   0.11653451246627142,
       -0.14199699676512051,    -0.0084516023027743636,  0.12495553155216031,     -0.19616683582634808,
       0.007757527986144987,    -0.099957417833814663,   0.22408589347725821,     -0.12642658203554913,
       -0.045023408529400621,   -0.038182292073485585,   -0.053986090329751636,   -0.069073402981274831,
       0.07879574859026918,     0.12288410465838107,     -0.0059159831750433232,  -0.16828853833894111,
       -0.01638883701265282,    -0.051640441373189218,   0.17861872190958775,     -0.10464135565275469,
       0.069955536519200875,    -0.13434255694680591,    -0.17574186919114287,    -0.098938224660446647,
       0.057368569744813309,    0.0304044456869513,      0.14470013555019628,     0.016784958906172997,
       0.022347469150553211,    -0.03948095635813139,    -0.10427225836853427,    -0.10885113475603761,
       -0.19955170634489339,    -0.12284261229360477,    0.089418779352038263,    0.031517682203907021,
       -0.05187469916995302,    0.073012397435314361,    -0.084063163795472615,   0.15481356271625829,
       0.11036528123758348,     0.069733349387506235,    -0.039167479088141569,   0.17314648924339637,
       0.0080472461380869907,   0.094636419092178348,    -0.045156962683416152,   0.11403415487239789,
       -0.013523533415823368,   -0.26769873113651244,    0.22631667955519358,     -0.0053565344826896439,
       0.033834615096714447,    0.15323637268773646,     0.071143542178046346,    -0.034962339845304773,
       -0.07078425638599789,    0.12336592897355614,     0.098397249926435698,    0.076152849011505971,
       0.070862142542054279,    -0.12906139365222286,    -0.055578103472665896,   0.16341181556637802,
       0.003194321943611648,    0.09831218491834956,     -0.070292643370204841,   -0.041243071561364843,
       -0.033725118446312048,   -0.11446905690021127,    -0.049436670861588108,   0.21077887669453441,
       0.0059561403940578145,   -0.0011830944025872144,  0.048057830221038079,    0.015996999224985819,
       -0.075682619617630134,   0.10711211539915175,     -0.15526341287584866,    0.015917468872445644,
       0.092462273528021777,    0.02273943425912716,     -0.035954493371699224,   -0.12921660795592738,
       0.17710714806987282,     -0.060084909373478206,   -0.11155375843275148,    -0.0017332338967819053,
       0.051331829217695989,    0.066660767997201484,    -0.15747721748080012,    0.18868187075527579,
       0.027819982961133465,    0.16353977783118034,     -0.041080738749708058,   0.060295621022996529,
       0.087000330142799967,    0.043867234017188957,    -0.0066930750484383763,  -0.037698950517345037,
       -0.063791304268663848,   0.099433104543482295,    -0.023391463360547215,   -0.090639864573769949,
       -0.10989902017984156,    -0.062498502941458131,   -0.036587880885521208,   -0.048894164789401007,
       -0.086371194165167864,   -0.045091994664880418,   -0.19356886257012892,    0.11857599383305478,
       0.0093373460426347202,   0.14530367809140993,     -0.088389753608155194,   0.16976845385590347,
       0.026348206089289238,    0.052224755898679413,    -0.093480575208881714,   0.11523755868021544,
       0.15909079147866134,     0.0033550540271280122,   -0.11354659650478964,    0.026958702034887219,
       0.082888764130321035,    0.032827176219375642,    -0.30919632176083733,    -0.1530312794382564,
       -0.025117890710436869,   -0.0526332949111495,     -0.11244954479054406,    0.07834795268822034,
       -0.015987777155798376,   0.093523158634200299,    -0.01691404544546864,    0.032023721119033538,
       -0.12953866235460645,    0.13393829224581935,     -0.067354638762835872,   -0.059890107754338534,
       -0.12852044909010388,    0.057863211570349488,    -0.077564149651155212,   0.078101821424267664,
       -0.042274254625736682,   -0.014893628971004706,   0.10088572071708775,     0.0025864460547940847,
       -0.021549374602365702,   0.058969552983694273,    0.03651899212154542,     -0.0022171678484272823,
       0.12468788657960062,     0.064160822310197874,    0.030513317483041154,    -0.065028382456522565,
       -0.15479339004604731,    -0.089320785424482352,   0.012129833825918486,    -0.031815854450914088,
       0.11736510118114346,     0.050406881493023685,    -0.092491921906526275,   -0.01940652334656932,
       0.0032442753378203616,   -0.17125027643287397,    0.091404745360783315,    0.025479964981515113,
       -0.016144795213361061,   -0.0038273178794365468,  -0.14962928926835561,    0.14698534738174168,
       -0.092297092910238632,   -0.0048826750150711539,  -0.1664339064256056,     -0.14828715693187811,
       -0.024116474423492667,   -0.13469832074032509,    -0.027890643449741886,   -0.11447992552512341,
       -0.056327388167690673,   -0.18096709593551169,    -0.016626481035716512,   -0.17741491026400857,
       -0.04211942799545073,    0.0848181737756835,      0.0060616609916651189,   0.087265903843412554,
       -0.19324805192540406,    -0.005208444454213282,   -0.029394738613440392,   0.20936248296967186,
       -0.021592596319084875,   0.14623988056997594,     0.048587529035675807,    0.096476324883812609,
       -0.11385617881147857,    -0.081737631078530118,   -0.010180429408359299,   -0.1745450707671222,
       -0.10725592404548215,    -0.075742716638081478,   0.23093893105050556,     -0.042046276501939706,
       0.004844972023461654,    0.17145396627872603,     -0.016239489496045999,   0.12002065075867055,
       0.0083992172318593239,   0.0081738927461593221,   -0.078071507417597136,   -0.10107983687745792,
       -0.047327964788619489,   -0.19641205151761845,    0.022990656734953031,    0.041721595271794504,
       -0.042957578435708854,   -0.037314604811877164,   -0.15659131411216226,    0.056093142504809138,
       -0.056393492628525832,   0.094645404713521675,    0.027150441535278423,    0.14754472265972074,
       -0.19949477625607709,    0.054286046227017042,    -0.032689587419093183,   -0.055053664138103843,
       0.11417626197847643,     -0.093259641597219778,   0.13700776645251006,     0.042005456877288953,
       -0.23166024456656167,    0.033095567919832432,    0.126461701400366,       0.020714473976719935,
       -0.047927166108112595,   0.010882804486870715,    0.050901783030775749,    0.16581534496257058,
       0.016165454282411514,    0.037762277917652749,    -0.18650613881023367,    -0.093252736543901912,
       -0.047620655009051466,   0.0086300037290584497,   0.02444321099207012,     -0.18389662980545898,
       0.10779160335589975,     0.049183428066108856,    0.05269688694322576,     0.092457537869686857,
       -0.16597263163144033,    0.11324421354629206,     -0.033686313336648933,   0.01561935736553779,
       0.022470773823101454,    0.080456937324924066,    -0.0015245811666899467,  0.064939935536594925,
       0.014072150311347988,    -0.057900369118692327,   0.0052404908045980041,   -0.0097260451184367023,
       0.093670966299287242,    0.012843444377829772,    0.00029217724372296988,  -0.096978582058497145,
       0.20633408657102395,     0.095966251137125452,    -0.087849645706891841,   0.0048653278561455208,
       0.024658646472220141,    -0.050854000975886188,   0.030107419411677421,    0.097501071534845288,
       -0.076442431831724555,   0.00065082412576401068,  -0.072902519204536831,   -0.016564487736049845,
       -0.021088995447614174,   0.0068001340298064691,   -0.049669066705290831,   0.17724673630357515,
       -0.15312267006643082,    -0.11163292528776353,    -0.12207182990287714,    0.0024543655962137863,
       -0.030286135214222524,   -0.052217866656284882,   0.012162179239571609,    0.072973096451271549,
       -0.0027727261870794545,  0.042395919535929909,    -0.078948814030677231,   0.12437593010317838,
       -0.20557272588196585,    -0.13026196189996159,    0.28416696867979746,     -0.10864566848503059,
       -0.038185029597313624,   -0.098331814100850221,   -0.10541424337910184,    0.024197153482630074,
       -0.0016659822291268545,  -0.06768651755263351,    -0.11826128446908298,    -0.20291376919970516,
       0.16508227781387499,     -0.019383547624317536,   -0.02664566260745246,    -0.089531783642148935,
       -0.085647159917830729,   -0.23971912311455643,    0.017451952894216763,    -0.073501110757684271,
       -0.15490806919456834,    0.030381180434396624,    0.15648620278486342,     0.04507956716970983,
       0.13925405075391339,     0.00087822377463694684,  -0.097972995477929606,   -0.030407817332112869,
       0.12709099497265047,     -0.030727975495974731,   0.085806233366660378,    0.010702054677786364,
       -0.055761234070167608,   0.061189605519005687,    0.17181862916518426,     0.14310221394372641,
       0.0061473094582770926,   0.010034572883346851,    -0.033038712512392779,   -0.014767368959828093,
       0.11680281889286336,     0.14720593609860336,     0.048307594552097134,    -0.18698320098564061,
       -0.07058769670114827,    -0.036997608307225753,   -0.027682032485487309,   0.15966443060932378,
       0.097246548477987083,    -0.097520989096815933,   -0.095931232429038671,   -0.0065837761691244067,
       0.097277483187820035,    -0.090961092985991601,   0.0062166422750977854,   0.098753043112829897,
       0.16136741340471972,     0.076524733549407808,    -0.22811269545277962,    -0.031682341731159219,
       -0.062823412353112618,   -0.022750290911411605,   0.064734234854291056,    -0.068291351858506405,
       -0.068999845019897504,   0.054406294147442802,    -0.11173158563788467,    -0.15778089288072561,
       -0.0074106460419158474,  -0.069928685027325369,   0.16657486219595097,     -0.059192820296580434,
       -0.1135100895425085,     -0.0052596820569779726,  -0.29120687214777957,    -0.045529150341774044,
       0.24452823237928042,     -0.011748759823305388,   -0.072918090514587641,   0.054038728921444332,
       -0.13670937930894755,    0.042504835771552493,    -0.12138949834684838,    0.075315062414569381,
       -0.074958796116824877,   0.071455274283919665,    0.082677180994305863,    0.059271326717832744,
       0.070336839135379442,    -0.061515905951547038,   -0.032200614376018136,   -0.090676710013735534,
       0.15935519176624977,     0.0284383119879589,      0.11225845755676986,     0.11755166227069509,
       0.031241223673830719,    -0.1862522891184753,     -0.10638762617218836,    0.08696517426621031,
       -0.062801321046678002,   0.05597427065677512,     0.051199742099866538,    0.068362951734127209,
       -0.019766318050839653,   -0.15827352161057598,    0.10312109987620513,     -0.0038704393505054678,
       0.029590701446347525,    -0.028519157509463731,   -0.16672585313408175,    -0.027866497363646315,
       0.19762250334034417,     -0.10258309775411283,    -0.033225967607100747,   0.046646189641400229,
       0.071507013790546345,    0.048556133808634293,    0.048253129238030261,    0.050507269268295407,
       0.24269876481027775,     0.036751755764987862,    -0.059334555935649777,   -0.05187260304882494,
       0.090665181687961588,    0.027794376308746101,    0.0099215473149519024,   -0.0057023118089145446,
       0.10611901197739063,     -0.029851944411448693,   0.00373459754868408,     -0.17516983992561891,
       -0.04459326298968324,    0.24663293623853264,     -0.13907686439386174,    -0.090239636163636977,
       0.055879248865558485,    0.060438099854331288,    -0.0014567886741970347,  0.10591457639629995,
       0.017489229791155032,    0.12089651898991248,     0.061459825188847489,    -0.036340115373696455,
       0.049663143363725779,    0.018576767464731147,    0.066568085012057673,    0.0085298342773410737,
       -0.21950454126866578,    0.0188413184137175,      0.037553520695503509,    0.036437031492847133,
       0.097279636544873427,    -0.1614513985583467,     -0.10179120981525751,    0.12008490205678526,
       -0.093925885723838851,   -0.0082209440960708344,  -0.32608004060956702,    0.080955211123464821,
       -0.0075428643722116424,  0.1273268576119661,      0.043788930300118614,    -0.067565880259869385,
       -0.073960834485186713,   -0.068043786774284368,   0.077700166966731932,    0.16323787784767518,
       -0.063061904066993066,   0.043962548522166592,    0.05433314414761984,     -0.15993595116470125,
       0.094247918921984766,    0.040809348531308569,    0.013097594298696417,    -0.044683177705315671,
       -0.23099310050612959,    -0.16517629959121374,    -0.0074906161715106003,  -0.18825154727162552,
       0.0042795543949904176,   -0.100096400661049,      0.018523408716781237,    -0.008755551874144514,
       0.036659338535600973,    0.035102732493922637,    -0.099379468197653448,   -0.048967783390439418,
       -0.11795135206276561,    -0.14157539307766562,    -0.1526349505835686,     0.032197704524543326,
       -0.08184208150576322,    0.061969178898605565,    0.19945258147531322,     -0.0063206992680054797,
       -0.012334023489797546,   -0.088531092624633878,   0.040757742410585759,    -0.049784990793812205,
       -0.14493675425558414,    0.021479510804191613,    0.057764391676875193,    0.18309115373742602,
       -0.073356198199397149,   0.12673681060377295,     -0.03215691026399313,    -0.05595108880091719,
       -0.02895357118430178,    -0.046036777256389945,   0.0111195988640458,      0.11881158099960704,
       0.057154401658884565,    0.034290768280355662,    -0.0060469025662109131,  0.12172078833699877,
       0.023178878713376129,    0.016774301459843315,    0.018194744697630529,    0.11914761491681092,
       -0.061115960400747522,   0.15577737113824758,     0.054405110536060126,    0.094981497334085355,
       -0.056600452880291509,   0.16174082799365433,     0.086248869933170672,    -0.026136822904887759,
       -0.06802806213408423,    -0.13611607174088633,    0.12685937037816256,     0.13897289956776818,
       0.070425983670175871,    -0.013787953536718819,   0.049135828097707099,    0.081075198165322757,
       0.040614470529788747,    -0.12607063553223788,    0.091162923290085199,    -0.061125728949132284,
       0.20218222627003629,     -0.11395112669639987,    -0.18680787938546936,    -0.12281289122286704,
       -0.19484620521120033,    0.13621125361968311,     -0.11274371528148946,    -0.070895840787550998,
       -0.03342585649047828,    0.089557878379805347,    -0.045084498223351685,   0.10094067429048145,
       -0.013150128144009508,   0.061449112062093733,    -0.077026852696497033,   -0.021934014031554139,
       0.11651488094845178,     -0.13963734837355157,    -0.049591527069246855,   0.10588262479178923,
       -0.030380227726996559,   0.15744769788153712,     -0.064713067227446089,   -0.051857110327756292,
       0.055480547027536964,    0.044132500862451532,    0.13281741217395482,     0.12614749167259923,
       -0.1241212857432137,     -0.10807927744129137,    0.2969739750349728,      -0.087138301076781291,
       0.055355237841913867,    0.12624975336922861,     -0.031895259885704234,   0.24342407679930186,
       -0.077802078350712872,   -0.035636704118246501,   -0.095263044923708781,   0.018368556190918827,
       -0.053920117698078432,   -0.015107344111391573,   0.00087785124506965437,  -0.068685376773395215,
       -0.17547900579750117,    0.057991753256216375,    0.020384272464122534,    -0.11228109571824529,
       0.056802251184246338,    0.054135815667210457,    0.0407113474168148,      -0.014301489987527196,
       0.2066966821942002,      0.020053015776114642,    -0.12058248104967503,    0.029036864800828351,
       -0.061454878229747337,   -0.049929121721862334,   -0.0090269693051356955,  -0.039614830409502699,
       -0.0093066906446752414,  -0.15461682151319092,    0.041580239062232065,    -0.091842306040335178,
       0.029620084664944955,    0.046823319520022187,    0.061650491528231009,    -0.036647067214760708,
       -0.080195821184692775,   -0.066100772756814696,   0.086819466771673667,    -0.022799039280691047,
       -0.13631854685143741,    0.0057563725882123218,   -0.012297278691718561,   0.0068413672518341856,
       -0.030963525107865559,   -0.11555355123512652,    0.0018043308060061521,   0.13085681481412384,
       -0.090315783555863713,   0.14305526644979347,     0.18441965209352068,     0.052934183103911646,
       0.015049545173794122,    -0.15146452635138491,    0.11816603654886497,     -0.086962052114809035,
       -0.0091856500269196194,  0.088767623665831047,    -0.07231290956886402,    0.1108726692385546,
       0.0052302024902077474,   0.0097078718744098048,   -0.034397133435737963,   -0.013313909048885944,
       -0.033349242450557696,   0.19938634150447462,     0.16437142924917103,     -0.013809256245006831,
       -0.0010390714980343784,  0.0064416542314992675,   0.11095171631804408,     0.061605648309051006,
       -0.015548673695584998,   -0.1836214487486747,     0.2236444598778336,      0.13904241554085597,
       -0.086868447709320534,   -0.0083580947109376941,  -0.17150092203255424,    -0.058470985933665232,
       -0.24315162043776101,    0.029426404502446681,    -0.046690975207198573,   -0.11990343687477184,
       -0.10122940037816801,    -0.11211805789508335,    -0.038326137776443919,   0.06698247116615838,
       -0.053897392152579625,   0.019100794163497081,    0.12121403334516789,     -0.045973892086313362,
       -0.06030133402856775,    -0.031649440038764208,   -0.063052161778814494,   -0.095450628312012939,
       0.095245321452516879,    -0.046501327339460871,   0.24549796957571818,     -0.042157602358156632,
       0.025326679660318686,    -0.05141810488080293,    0.13795448891316248,     0.042244452953086896,
       0.19413882971609711,     -0.031015892968925353,   0.10144292759998032,     -0.12482408955825244,
       0.02505097100310703,     -0.042742180222737847,   -0.059994332035807979,   -0.1370875817519932,
       -0.0084456743853935923,  -0.074977133778023841,   0.051025413507470287,    -0.12138161766698753,
       0.033222369799827747,    -0.21888272406491485,    -0.13103582686589166,    -0.025169956475256983,
       -0.020836926630695678,   -0.064344441847161246,   -0.044224606395164685,   -0.11676110149365845,
       0.098190543114210257,    0.037635038462684622,    0.011064833007486367,    0.0031775087896963334,
       -0.13342038980724824,    -0.15939112247386206,    -0.17322775601682433,    0.084636798866971966,
       0.075920810146458489,    -0.068495537918617094,   -0.070510392944720335,   -0.11460632200503734,
       0.083280317658557396,    0.017051574292330729,    -0.12455859538621947,    -0.085005240710431626,
       -0.091377081560835849,   0.024669083700552437,    -0.15060005835503965,    0.021611738096596375,
       -0.069555460873099884,   -0.09993357520417058,    -0.16851861577547714,    0.13471343646121872,
       0.021276897567628503,    -0.070424802719109669,   0.056749804681004885,    -0.093513478223504504,
       0.008752873908402202,    -0.19940373565400202,    0.047766065666082672,    0.045811192716071765,
       -0.020716581868656193,   -0.023542410137210562,   0.083862079637771592,    0.015862995445488713,
       0.026433475843071819,    0.098068929099644042,    -0.024780035757370956,   -0.095210992563626418,
       0.057719964371049454,    -0.027882360278602514,   0.011106692598633372,    0.016098226150709053,
       -0.070106609273092604,   0.0058626001347782692,   0.072845917032509158,    -0.0098753321412295529,
       -0.02220145072404428,    -0.037238751650943723,   0.043323505017192468,    -0.022044434483997892,
       0.18631169655464383,     -0.059823976245667126,   -0.016749826130647103,   0.059535137313201349,
       0.021802299203038802,    -0.11296134915928877,    0.0040765595800071981,   -0.089978347734360212,
       0.11742505728044222,     -0.14496372490595535,    0.19387147579321651,     -0.067744454501654075,
       -0.15121774686720543,    -0.024900961556397497,   -0.16169871781728951,    0.13790249288674281,
       -0.11950617127748764,    -0.20154146158431185,    -0.021600235253201129,   0.086344869017702691,
       0.063908485911617352,    0.12263249900261346,     0.2145467081124813,      -0.11170823193775596,
       -0.096570426546476795,   -0.084309719350872225,   -0.11676004947674574,    0.18847080307287264,
       -0.1563277626430194,     -0.054481257192219482,   0.022130107421552477,    0.10553190676860297,
       -0.088935636493398987,   -0.045186735998418326,   0.039313072822140839,    0.11962705570173315,
       0.10270012289771524,     0.057114871308426143,    0.14277657163932184,     0.076228043921218902,
       -0.023973393452135415,   0.053800532760982712,    -0.1524801092132807,     0.085331723565400461,
       -0.12500345749280634,    0.14111937174842976,     0.11957845134858913,     -0.17731285360553567,
       -0.038275920525090962,   -0.068095934809584674,   0.010390489193862307,    -0.0034235164388011722,
       -0.13026739027094855,    -0.044560410264728949,   0.05469578330795543,     -0.024625852750459247,
       0.063985756144985584,    -0.0035687788163773076,  -0.054040990742640349,   -0.0038901194642929652,
       0.052197803724991408,    0.084396801396637605,    0.026465001646942016,    -0.087895186780056062,
       0.052313150197457844,    0.020954393872212818,    0.18181692369079741,     -0.041166208851334096,
       0.22794036205658461,     -0.17152479910837407,    0.1381035063131508,      0.1415452214650377,
       -0.094418751291619793,   -0.10282491790286129,    -0.13249231672397949,    -0.098941018355658397,
       -0.020013242948254791,   -0.11672071568396464,    -0.14105339123971511,    0.1553416383236535,
       -0.097135598069374718,   -0.059758897034867538,   -0.0038366001077906765,  -0.027511768353867573,
       0.015520070139334268,    -0.083488194186177367,   -0.12609265268072772,    -0.058170183405441098,
       -0.0066863978675692649,  0.077166055233876166,    0.0365937855175908,      -0.014736916397678011,
       -0.15645816867378989,    -0.020441931785860561,   -0.13963456438522609,    0.084984708948975668,
       -0.10799550666894649,    -0.12590724675747653,    -0.064134618890149708,   0.055770588364524115,
       0.04594651722943411,     -0.05862462152139733,    -0.13914834695785061,    0.1188917444875299,
       -0.013421981726261736,   0.040568948818993963,    0.060833736919618624,    0.063702908187025578,
       -0.0064405014906915711,  -0.22002678422470323,    0.17394001124392514,     0.062364873262901431,
       0.10884846974753459,     0.046804342347299674,    -0.028929620314022849,   -0.19957287550870323,
       -0.13590520714320364,    -0.18576831784394815,    0.033836319948899261,    -0.15791436063999209,
       0.08836679715926038,     -0.015285961972772554,   -0.028234895777255981,   -0.1440018756533247,
       -0.071877254035593002,   0.070793235102455734,    -0.12207293444262703,    -0.044687162470084967,
       0.03033885602128699,     -0.0062644958593609315,  -0.16932436595577513,    0.016608839538030114,
       0.064338897241842705,    0.0048422785959526728,   0.19390579350007867,     0.076027537999465045,
       0.039590334544202736,    -0.12873796011647601,    -0.18870378161416745,    0.0048033967326034906,
       0.24337307393800553,     0.10683107501474234,     -0.055354407906505441,   -0.017582276838412014,
       0.083821821505241603,    0.10611590250963816,     0.15935187545171134,     0.03267211452086289,
       0.084092626239407761,    -0.051805118489017282,   0.12654052782546554,     -0.06621842873942578,
       -0.053840566147215961,   -0.095467845770959972,   -0.019971245950867189,   -0.029311348336941816,
       -0.016643698441949167,   0.01938136420644198,     -0.030198816785770789,   -0.070055758533360171,
       -0.094193066715567236,   0.040624958925266227,    -0.17449604214058531,    0.068871511417863421,
       0.012892716637550752,    -0.1453924507258898,     -0.049518093290441094,   0.13306884833279128,
       0.016403889403222655,    0.029798517009491082,    -0.052424208784827273,   -0.24485487991501409,
       0.0016819689380475956,   0.14639270359298145,     0.18272964627171823,     0.087786511280594837,
       -0.0053270889965820285,  0.12129756499918067,     -0.08062660984635614,    0.097339961294720612,
       -0.064502360269635711,   -0.05848543177349412,    -0.10170139708910612,    0.1500987595923593,
       0.022928879885785413,    0.16800566126321104,     -0.026851859292033011,   -0.047214672028808323,
       -0.012611445834481977,   -0.10646192053579043,    -0.15861893965427715,    0.1554932672617233,
       0.069011149986785564,    -0.0562423975028426,     0.011859239664084637,    0.14372687917384136,
       -0.125070469795382,      0.2907402837826738,      0.042606788407138801,    -0.070452456020705545,
       0.1368500496477788,      -0.16937822813815448,    -0.11881755344419108,    0.0093523931578880434,
       -0.1099314273406867,     -0.098469170796374281,   0.12502617870275248,     0.0070376698791901216,
       -0.017818507041545525,   0.1468684652215686,      -0.024296384155508242,   0.11627434073693449,
       -0.10401937618331834,    -0.013306272240029159,   -0.0044021247665426734,  -0.069090737830091939,
       -0.017682603372073082,   0.068608029015717345,    -0.069591335497956319,   -0.037840973703322428,
       0.019140067978856579,    -0.081882637779441686,   0.092800704559711344,    0.083045344496722295,
       0.11390248280779791,     0.13126553831153029,     0.045514584045022122,    -0.12458839904085639,
       -0.11053236407747551,    0.088334919166546663,    -0.017988276401421453,   0.081125818931117269,
       -0.090095314474365293,   0.034357725044922752,    -0.071719841408562177,   -0.10769188068959998,
       0.20250165079634466,     0.16075596074726978,     0.091976575514407896,    -0.15227120927407475,
       0.0084797188809934108,   -0.059664515558697014,   -0.078441699594292383,   -0.038211929394147817,
       -0.21082468263613285,    0.037606895615410162,    -0.029749871732342711,   -0.051719113857993888,
       -0.0059096747041366702,  0.061718982736135068,    0.17483556696156871,     -0.088839345446616785,
       0.17723095676264422,     -0.035793558523928008,   -0.0074436173646867361,  0.031038625065865889,
       -0.0246759123891283,     -0.16452401377220663,    -0.018882063758298456,   -0.089015098961108818,
       -0.019936784338987271,   0.13926962126205891,     -0.17559760902987928,    0.036948138157806211,
       0.086017604806860756,    -0.22250391853484294,    0.015430485189223903,    -1.3899897294513373e-05,
       -0.010453863701078045,   0.050685641187222588,    0.13204552693571986,     -0.067925663116072024,
       -0.013064811558753983,   0.030051315558504814,    0.16475880480578237,     0.0099644751520487941,
       -0.071265546311104849,   -0.039189262272857871,   0.0048458414737125059,   -0.076626748304669298,
       0.011251252295256234,    0.027972393114763225,    -0.22460503400849618,    0.16255885348561938,
       0.028385833998863044,    0.0083337693281808223,   -0.047623705861147343,   -0.22263243240625116,
       0.13106567378941117,     -0.048213955505178693,   -0.10480965023124539,    -0.10500684250626577,
       0.044729551541226563,    -0.072250407161768851,   0.048468083575029727,    -0.015402995442525238,
       0.10344829891907058,     -0.013194459260120379,   0.14310897363051989,     0.1778223289567028,
       -0.052175464073011137,   -0.087124271563166766,   -0.19802981609504886,    -0.14811804509529125,
       0.079811469543606475,    -0.0030007074678848216,  0.12213802764866309,     -0.06329464252682844,
       0.16332162384510854,     0.065026113792087573,    -0.084660653672832042,   -0.10903628971384602,
       -0.0023202703815884186,  0.11581763023088718,     0.22262446697524776,     -0.006629817405403019,
       0.058723890344947911,    0.018617080472109918,    0.16708416530431766,     -0.038237034927366416,
       0.061124324113563187,    0.19520542637532326,     -0.15216348780459552,    -0.12924136038385717,
       0.071121412034428649,    0.15825289181034824,     -0.052140950028827376,   0.076787923401933425,
       -0.086632924188130678,   -0.043960564240741927,   -0.2042686992410323,     -0.050632267183893159,
       0.021354876278444634,    0.09958386848733651,     0.070342320214070608,    0.060758341835225951,
       -0.11396481841112864,    -0.094001447978900241,   0.082431905626692295,    0.095845843499885466,
       0.029804596773965339,    0.041375692023918664,    0.046158239450417367,    -0.098450089207255426,
       -0.0011007392295871426,  -0.0080808303035666152,  -0.02121432881456619,    0.025107413835149195,
       -0.011162633613002636,   0.067579666053536297,    0.0038213290454984046,   -0.063287199825291601,
       0.012254066511053638,    -0.074604475159608288,   0.15686484769921635,     -0.033638557751299258,
       -0.044782236818387063,   -0.059767423705024574,   -0.076313387493171014,   -0.10546947493454925,
       0.022252808400849186,    0.17075606478655964,     0.14261586008663746,     0.025715189655483736,
       0.016962573320078361,    0.082297773152661374,    0.077246491721058769,    -0.012730029075744638,
       0.14966866200581438,     -0.14199186038893716,    -0.12783627215777732,    -0.0094138063941020898,
       0.13877961235834507,     -0.068656687325042653,   0.030085992762330878,    0.022023904234969093,
       0.053572061000689043,    -0.074224778027295865,   -0.0011974413903916741,  -0.2155937520876231,
       0.0084335236642829429,   0.0096999558943042432,   -0.080354138390392793,   -0.096984158712460036,
       0.25598416766822085,     -0.12934080295368164,    -0.10622675443473635,    0.022924684299032709,
       0.12712981247897792,     -0.011111945797102877,   0.18061041584651744,     -0.04703162289991538,
       0.032345292690380806,    0.037288109098119887,    0.14944662252180799,     -0.015687744103392784,
       -0.2563713822739751,     0.011882471147978958,    0.078040856273037959,    0.036182998590544316,
       -0.0095775230897873348,  -0.045160586422095916,   -0.08396154585627405,    0.048683969856641987,
       0.0084491174933992233,   0.015116193222550155,    0.042623717960659675,    0.15527041135786696,
       0.058152900132125415,    0.17916157151505951,     -0.11451676860196555,    -0.059375646217091113,
       0.20144343902600206,     -0.05509044068501371,    -0.051780226524567569,   0.078327483275413154,
       -0.046057889715650613,   0.086277688129773725,    -0.018782023767324837,   -0.094518144415532551,
       0.073276720623972086,    0.042245763263488632,    0.010055731703465404,    -0.1819480853856314,
       0.071088920847386411,    -0.14067147061514357,    0.097766724845744668,    0.14344822616869285,
       -0.067414191610098567,   -0.071407455768625672,   0.16640610648971751,     -0.025962185626445443,
       0.15479748477406077,     0.004285522443509408,    0.14839457490337232,     -0.10164885405223897,
       0.059849510999794756,    -0.0039533872585454126,  0.041454279852095571,    -0.12834429246109144,
       0.018036646217492163,    0.10111841107778409,     -0.0098418866271213715,  0.11168887502808654,
       0.1081469456164979,      0.17393697961408267,     -0.16044450202484117,    -0.013278631443570735,
       -0.039954192631277363,   -0.047160061208952976,   -0.14356058825600068,    -0.095499912700012873,
       0.098542790166367036,    -0.088239263974771165,   -0.05453810445677431,    0.076401855903566976,
       -0.048436087738821937,   0.072287007712282261,    0.047466450851952828,    0.042255142813308076,
       0.018471157850827955,    0.0090539197276601965,   -0.011436393446621172,   -0.072761332462767475,
       0.23553399806093306,     -0.16013654357084256,    0.17200926536236494,     0.07009230573595801,
       -0.15688287483504382,    0.029520749955577852,    0.041181410577332427,    -0.071796759122768034,
       -0.060169817277288568,   -0.039733624269491091,   -0.1459799379685866,     -0.022961478143610575,
       0.10183901503412841,     -3.9076009481988494e-05, -0.058443299788258574,   -0.10378116279700064,
       -0.0081785992174649401,  -0.07835303388111596,    -0.035773289606492037,   -0.028210640190637636,
       0.13217459840970061,     0.048566320765654931,    0.13160229768188589,     0.026252297613905608,
       -0.076255965698034611,   -0.15434228978575518,    0.061819484927868859,    -0.0415566684057741,
       -0.28086509140084637,    0.18844938798115463,     0.04696161988578567,     0.078695074187566882,
       0.19753884056394463,     -0.056017154498847643,   0.12630937572144063,     -0.033566594727034903,
       -0.051252910479719631,   0.021102156949014177,    0.14127477640917627,     0.08077339675101293,
       -0.077402130253923035,   0.047554186408111543,    -0.075714924279962084,   -0.035362341785053583,
       0.20975713162868015,     -0.073038242692267552,   -0.01775310446647594,    0.036256781137909894,
       0.20712485551324827,     0.027555618664113518,    -0.0094343064527529566,  0.053227005373506414,
       -0.0725309183458034,     0.19569576170660719,     -0.086819401601171325,   0.17904202011485182,
       -0.13075840694213628,    -0.14021200099393344,    -0.088898176680185417,   0.13282298106545826,
       0.15775619678487263,     0.064008016492708986,    -0.24803065248390094,    0.017244302716412304,
       0.10148716293527145,     0.039493414572944509,    -0.026868292026895363,   -0.0068617375156076266,
       -0.069573374278740302,   0.065592893534734395,    -0.069166916247051444,   -0.0048378135681532361,
       0.11868826083588072,     -0.13902582048813891,    0.076713216976654203,    -0.068628734894613269,
       -0.011451747966368449,   0.012199967003303844,    0.033324996926272006,    0.13110815948049803,
       0.06503596299637629,     0.10126399955965354,     0.11495668908488918,     -0.13142271890634838,
       0.15687950432236072,     -0.013106193304377834,   -0.041540843497147484,   0.024342246454687057,
       0.072208538109884993,    -0.067300100668153923,   0.041214302141543854,    0.040727515661818883,
       -0.074944261803419301,   0.11883929281369232,     -0.031972112082222406,   -0.12770439025112582,
       -0.049359518232348271,   0.0084093410700406268,   -0.066660690601994754,   0.15502646795376326,
       0.01038688983100506,     -0.052903255693306346,   0.041762417442515611,    0.11038766331369773,
       0.0086990485669491534,   -0.11808246093088998,    -0.024463522947048962,   -0.029756493435223665,
       -0.022891895911544762,   -0.04929818658830639,    0.068414941851122679,    -0.088907040905886317,
       -0.066553587570584521,   -0.19687719288458475,    -0.035012689934292261,   -0.15290527946214111,
       0.069826390232931121,    0.048886407642500761,    0.030576044745802576,    0.05131098748614818,
       -0.068377110193851454,   0.078248320151402775,    -0.11221137528522937,    -0.059337244001470474,
       0.008551966623105766,    -0.038312029528817619,   0.0074295638286329749,   -0.24525427015043108,
       -0.13453037940785315,    0.15163231633384,        -0.10187584634783582,    0.068371075702221618,
       0.042373914500742751,    0.016773956266203385,    -0.041195890686622293,   -0.079032177938767656,
       0.067526247473422785,    0.1423790869251558,      -0.10746125765456682,    0.060429804203266012,
       -0.19190726811968006,    -0.037137420667209854,   0.02922680714163714,     0.023485088392340123,
       -0.094812864540530714,   0.10748525483998327,     0.055963198701227589,    -0.10087080764403245,
       -0.074432670657056374,   -0.023405425880866724,   0.003727458759532498,    -0.17569112594372496,
       0.027249194075885573,    0.013480807801468705,    -0.061326953051539138,   -0.18894004562450301,
       -0.012385503618802645,   0.098484381074004743,    0.1064426731654176,      -0.094347930858171239,
       -0.0086941716446878436,  0.062993704849048537,    -0.16180607668276284,    -0.026825967441816444,
       -0.0001352436687053417,  -0.016627618282818748,   0.20322847931448007,     -0.09241446403670503,
       -0.093054098506548236,   0.053161072389214407,    0.070704008216607703,    -0.16426623179845129,
       -0.1346562891150283,     -0.060538898053821434,   0.18674095495139117,     0.030235497286183358,
       -0.11328990515568423,    0.083738027214859317,    0.18945618806452458,     0.010684273325495224,
       -0.070557460142911241,   -0.027212745589531216,   0.0074068496156862833,   -0.23383661638466122,
       -0.04670904727872071,    -0.047286019411956794,   -0.14130385990497574,    0.22546182906859308,
       -0.011453957124297268,   0.032259207236125069,    0.11150399287866812,     -0.081472440439370103,
       -0.10009764674222908,    -0.0098936446742265115,  -0.15769611112639362,    0.073251861196929419,
       -0.1070304404916039,     0.012265782173871993,    0.11760913396404862,     0.026896185862257158,
       -0.029350666270700029,   -0.19486581676031492,    0.09828833599392213,     0.011802468805673136,
       -0.038132786056918375,   0.13008130633370441,     -0.11395348104815038,    0.1081710097099166,
       -0.077700907634047287,   0.085457311578781323,    0.10112852579452829,     -0.0079448955948407205,
       -0.05663736388088466,    0.1536942680699418,      0.1038634045031735,      0.0087407438395342152,
       0.15019444144797628,     0.017223482518662972,    -0.099956903458806673,   0.014562419968768739,
       0.044322431667971576,    -0.07031707696005482,    0.084909687041928111,    0.043489910020903098,
       0.055802256664477246,    0.15025727328719357,     -0.027236542750921092,   -0.10043106246332581,
       0.22726964130180627,     0.010369403407869706,    0.086094272555317514,    0.162389335869217,
       0.1028753315914248,      -0.08682732089554894,    -0.12569439070968103,    -0.025903168179844591,
       0.21157297921854262,     0.055667234213671812,    0.20693549686725876,     -0.014270951332749842,
       -0.091587685004866387,   -0.13191813519923284,    -0.096973721140157829,   -0.059956988937470888,
       0.01839265624449201,     -0.10477497127806379,    0.16635029487757444,     0.16146265539395124,
       -0.072376066664252628,   0.025967101241158114,    0.12553376125107868,     -0.040872900874440773,
       -0.075302157281916582,   0.1162410766305145,      -0.029685109154179851,   0.054274481353248694,
       0.10222022968510994,     0.064426758421406133,    -0.063010753612049053,   0.044495060569618161,
       0.0036054131945514999,   -0.064732207970107689,   0.0072122033764146186,   0.13103127076444285,
       -0.048639615180025374,   0.062828914986800766,    0.018006436738912099,    -0.019589763419852822,
       0.16659245082616375,     0.036798259495098601,    -0.17697079508885624,    -0.046185343778227222,
       -0.17391363176572366,    0.20746246919065975,     0.065733659160012337,    0.024327384314348215,
       0.0003119348080737115,   0.02512184619143782,     0.078467086992640461,    0.052071670113080018,
       -0.031138603713883314,   0.20362686372713529,     0.11219773538786314,     -0.076671962227283036,
       -0.043193446684072573,   -0.022900999904868359,   0.015272129485850723,    -0.13502775408342893,
       -0.069962622636763339,   -0.13073409534093838,    0.044279614208499178,    0.056433267710775892,
       -0.029053607229511461,   -0.10631053044989611,    -0.05598780579637911,    -0.16854780000505507,
       -0.11229478616804536,    -0.0074197724459962935,  0.18301267516319009,     0.030947100185601591,
       0.15648274750115054,     -0.046475601566187311,   -0.19440979466253269,    0.10731659514134309,
       -0.13732584643764428,    -0.066726631529341163,   0.036796731238930916,    -0.12108198878737396,
       0.066953881635890139,    0.097955715820722336,    -0.068752182472574738,   0.088821329049128372,
       0.011133657607570836,    0.10883111731311626,     0.0050394307263712194,   -0.016477114196797069,
       0.025413725953932126,    -0.098744496832491993,   0.057454448852704648,    -0.092914123493462855,
       -0.11018887575118223,    -0.15109087955031633,    0.0024499949812198251,   -0.082182781349178252,
       0.12626162617219844,     0.1243606090480476,      0.15524859076392636,     0.066660098952163238,
       0.11486735827565783,     0.05251974738498999,     0.1296763166287892,      -0.19839294147763906,
       -0.11197902614762252,    0.0053913661672230564,   -0.041670382092221923,   0.12069930677135603,
       0.02932725996050755,     0.14155854579878424,     -0.028750523926658635,   0.024769741182451201,
       0.11455975166959421,     0.030916653626584783,    0.11370266234189254,     -0.13851545125533327,
       0.019083377591106048,    -0.10575677828284002,    0.14153460094594453,     -0.10853776086570313,
       -0.037166778167781557,   -0.051001219017737985,   -0.17426803127136065,    0.041127090615174583,
       0.052518097083722008,    0.11659731064652142,     0.12373832106949675,     0.037486211210950533,
       -0.11166533257983047,    0.038234726255891402,    -0.062678922739521664,   0.021252098849081347,
       0.14275071318783983,     -0.0043588934702626916,  -0.1278922622811314,     -0.08849318142292939,
       0.066653479372816335,    -0.047122767035467084,   0.063054360313792024,    -0.1037207913511777,
       0.010667389807898836,    0.1416378562294989,      -0.051416954553772216,   -0.044993504048800551,
       0.11488331216075832,     0.0036676901051663005,   0.1457950914804422,      0.050279203894101301,
       -0.011673229220532143,   -0.0085804842089503199,  -0.022879082302891589,   0.048649091372895456,
       -0.1823203064643473,     -0.0071121219201987626,  0.1619155150701346,      -0.037839673068301653,
       -0.047165602712478036,   0.13588294144885979,     0.19518217892430623,     -0.11008495876289701,
       0.10064663575000234,     -0.1851307712083311,     0.14934734222453205,     -0.0039618414348916997,
       -0.0073214648492644103,  -0.056651714571063577,   0.10494400117082786,     0.067542909371767268,
       0.15828537849832747,     -0.20924164712102319,    -0.10299279511289321,    -0.041303807502375993,
       -0.11014420191794282,    -0.10913047102692261,    -0.01926011993673234,    0.078794609146276021,
       -0.056527820122479658,   0.07007041134283902,     -0.14938256367531258,    0.12449995502511826,
       0.027194986595203644,    -0.097415134478870152,   0.13406457498469748,     0.049242984346753262,
       0.066320067057914517,    0.15067414789849737,     -0.034113740010309437,   -0.10371473298710181,
       0.074700107780525521,    0.07832869929900739,     0.033699233389394269,    -0.096771138007893026,
       0.059584943947886188,    -0.077819519915461682,   0.037023899033994508,    -0.062919094260800695,
       0.16260165096543905,     0.055624538603918895,    -0.11772361751471544,    -0.19096091104395721,
       -0.12879360028025197,    0.078023726881952096,    0.15204909445298739,     0.11231883692982401,
       -0.049383633930377181,   -0.026370076199049144,   0.044322543448797304,    0.053175806422942694,
       0.037685879299771338,    0.026604952140067823,    0.077083271109599727,    0.12465408680708834,
       -0.024542735486750327,   -0.070156530905549755,   -0.10071702360800741,    0.042677447942521485,
       -0.056121602736977458,   0.0087642356126066412,   0.11777560618347814,     -0.11500569323354363,
       0.018381704751589886,    0.078598608293050168,    -0.066835759356906679,   0.21421478176573908,
       -0.040912052056202665,   0.15087524782267253,     0.24452079491211048,     -0.12751922699598167,
       -0.038112335255348843,   -0.073239614721667359,   0.0010301221102607284,   -0.066128077392264839,
       0.040549560480229362,    0.053193568663772679,    0.0041087157410464826,   0.12119436364104724,
       0.042260016983581838,    -0.19175871213528956,    -0.07725461337330361,    0.091719368181921904,
       -0.11546268583454385,    0.028910777093749732,    -0.050129756024808819,   -0.02232107439842269,
       0.12422561729791028,     -0.0071206102935824191,  -0.25425591260330083,    0.023820540852464912,
       -0.001132721044351309,   -0.050827657155152382,   0.15320933815277407,     -0.076918342540998011,
       -0.068933530129240153,   0.010214228666478323,    -0.18286325018288341,    0.11452701935011433,
       -0.071122379876407252,   -0.076444695872767074,   -0.0020967106347271215,  -0.067472750039701615,
       -0.047568917536385605,   0.07813089918151192,     -0.086492416846978601,   0.15280308490141856,
       0.014098319063835855,    -0.27047977828463848,    -0.11169512860095214,    0.092623172299411263,
       -0.15070563612860086,    -0.045596062133207195,   -0.10699799859133328,    0.026786908696162379,
       -0.075596456132382653,   -0.065721417704360158,   -0.15482546154426391,    -0.084499649111712843,
       0.16028555189411176,     -0.025725389419695176,   0.12156836757933959,     0.10311059855800958,
       -0.053659737235376918,   -0.03240923079941313,    0.094673498675662077,    0.034333751397068339,
       -0.11243649346525625,    -0.016699080736398697,   0.12049040632566618,     -0.053466189959931194,
       -0.17645292118360548,    0.096549734579872828,    -0.14398045995633696,    0.095009373160550775,
       -0.099459716182789398,   0.095822162693962154,    0.00025450036463163603,  0.018180269171339289,
       -0.005470195498885954,   0.066979076956193789,    -0.046035682103954971,   -0.021534749626060865,
       0.16008750477514661,     0.17699417287226543,     -0.069552087558276715,   0.00055534072119110475,
       -0.073004540437062199,   -0.058061449620080079,   0.19543929702504509,     -0.17656663624726104,
       0.0058108362990087724,   -0.07106559892636008,    0.037954210387522697,    -0.088373839886534647,
       -0.034561281859276011,   0.023806785246468402,    0.15918946008154389,     -0.065214225547023552,
       0.14089759900278462,     -0.073679577216321013,   0.023202935382845385,    0.012734317289414637,
       0.012950802457122705,    0.09491923748841595,     -0.19908917695905881,    -0.013377115000000262,
       -0.031733095355563852,   0.06754028563152574,     -0.0054278544378357106,  -0.058646758087774087,
       -0.060064107753761212,   0.0031563052818299984,   -0.077120138635362864,   -0.078073679940720536,
       0.019304023102371566,    -0.1772440936738755,     0.066250121774921428,    0.03565208843230009,
       -0.058580933904496299,   -0.0042561593954913279,  0.14880777999397699,     0.12739789438664778,
       -0.025819228335561412,   0.00010368493067818181,  -0.014628934489943006,   -0.063035181052624817,
       -0.16251880378803274,    -0.10211368822462116,    -0.17714553785470924,    0.19109891568954893,
       0.077300000495204996,    -0.066056750682828402,   0.0037026565756915018,   0.20194501108850002,
       -0.026759111451085549,   0.13113699385816679,     0.087234945705260844,    0.036253286583505559,
       -0.078770737005795691,   0.13640805387452601,     -0.028846372757022024,   0.17673058990940285,
       0.15608974102658033,     0.012512900902410607,    -0.12374042271825879,    -0.03126593622498676,
       -0.15488235231717526,    0.13642269709865315,     -0.021739157041600971,   -0.099262531371602375,
       0.034473154574695158,    -0.057600510600664095,   -0.13277875148407273,    -0.039511544680223422,
       0.01483173774021573,     0.067425946901900735,    -0.085739387736318701,   -0.082386122590247038,
       0.15655003920921812,     -0.021550922527337729,   0.1552894602976839,      0.077613713989350172,
       0.10619505864942801,     0.12310116843962993,     0.078680758043292776,    -0.058787770031054815,
       0.13945410927199428,     0.09427428349745938,     0.17759809985329947,     -0.083282754959495497,
       -0.048963551501183589,   -0.015371009060396915,   0.018976850562166372,    0.014108131020336454,
       0.22131534391858187,     -0.10261567815300515,    -0.054843786498637477,   0.035288109963228197,
       -0.07254935386630898,    0.16109957219776413,     -0.0089984403832362465,  0.13923454071281163,
       -0.090207160995809152,   -0.025214727532470373,   0.0048356519436270808,   -0.18315768388932727,
       0.15598381458698191,     0.13307374146719084,     0.025029319294824513,    0.09177947601903233,
       -0.037375620596598547,   0.075283425404778198,    0.037040800741481701,    -0.065464536921079369,
       -0.041994223762140126,   -0.18210636969278599,    -0.074560119367227451,   0.070145256539745293,
       0.069725601469609558,    0.007459583508195422,    0.035487636205772208,    -0.11094661110505022,
       -0.082456618806163548,   0.097148529749667201,    -0.070027350867514826,   -0.072496344352830672,
       -0.10260507234905661,    0.19367219793662183,     0.10856226541003092,     -0.09974982252779499,
       0.18230076304371434,     -0.027100628392670648,   0.13352545032168306,     -0.064251078326283073,
       0.07858065125931879,     -0.081471116833872356,   0.096756560123177585,    -0.079348587481765515,
       0.0096912085760938391,   -0.035432143935685979,   0.039121742584254812,    0.08952741564327199,
       0.025282715757211166,    -0.033092255617456372,   0.015268035684260745,    0.10899852860237481,
       -0.023310546897764912,   0.078800235646278499,    0.096097800189725385,    -0.0005361524864189479,
       -0.038519256637178874,   -0.021948738007416611,   0.16445979713560138,     0.26638432929208672,
       -0.069435489756120045,   0.0058835543987148936,   -0.034720651798055426,   0.2061671524369828,
       -0.010654181223708679,   -0.15231480260718344,    0.25967158898457571,     0.15494437079756909,
       0.044811420323628719,    0.068285819126742461,    0.085994548799067622,    -0.034366363073389875,
       0.093808890333530376,    0.12929529901497802,     -0.16978594177232481,    -0.070822268526085183,
       -0.067438703156737903,   0.025777029386188366,    6.3540887242892821e-05,  0.12808240251322045,
       -0.098723897501596325,   0.012622897536708907,    0.119805631786309,       -0.07682875631627227,
       -0.085461691492002417,   0.012494498019570019,    -0.081976648231733909,   -0.045089547157699153,
       0.2018067123712465,      0.066877114329939716,    0.061508762714729562,    0.020425752420854495,
       0.062805876865296859,    -0.11909749759367194,    -0.052438765315444211,   0.12186091850534918,
       -0.19188599820583344,    0.047994358373396481,    0.020212565824978705,    0.0078104542263365898,
       0.10989185624242298,     -0.071374289933551285,   0.035473993264749017,    -0.117746305372398,
       0.074553387484720318,    -0.056792936820460084,   -0.1010242179430976,     -0.093422396149489176,
       0.079743708117310783,    0.21170568248544894,     -0.10911090923128919,    0.0055814458694065684,
       0.12973565278843419,     -0.04888370037234506,    -0.10523011529357806,    -0.14151537740425432,
       0.09107039538173016,     0.009534345340046449,    -0.10032187370996697,    0.061355086995173481,
       0.017479673818909729,    -0.12941666509415109,    -0.19109485580304333,    -0.16562049362917655,
       0.1394464824546397,      0.18362046821159939,     0.10123730101522882,     0.13576237252529891,
       -0.013201557019048796,   -0.077843709240874609,   0.053158108459999721,    0.11188672892249761,
       -0.049241642803141118,   0.11451464173552717,     -0.057729695697959743,   -0.022675804483625453,
       0.14296554939326628,     0.078645481157950101,    0.1587372624662601,      -0.0088807268442529577,
       0.020979492644657437,    -0.013905396328140328,   0.19368061365462749,     -0.061660660917657067,
       0.097305809274945115,    -0.088139725596500448,   -0.028525225701942158,   -0.058347880734250193,
       -0.053651892208974442,   -0.19973167153983085,    0.025806684936509412,    0.048773315398078568,
       0.059075450535550321,    -0.10701433783305803,    0.075138965194671364,    0.048145288395168975,
       0.044033888766035319,    0.0017219053351643257,   0.010096834386909996,    -0.052890742743728514,
       0.067493927557326805,    -0.10308578141119774,    0.1051339423286652,      0.0024654951197952374,
       0.1251846394611926,      0.0035257775957663997,   0.065041856993012098,    -0.14827572214211268,
       -0.02607118756162799,    0.05155152408465153,     -0.0051987657576296146,  0.026022456956898865,
       -0.041881641874805337,   0.073197685399454607,    0.20626896309792064,     0.13963981609760667,
       -0.0021755855334286527,  0.1432225258042549,      -0.13494861995198659,    0.095181102691669572,
       -0.015988448512016411,   0.10239669560549938,     -0.018369100944019771,   -0.064315323867343871,
       -0.050470135012408227,   -0.009178919167770333,   -0.076750146602724265,   0.12573408187555987,
       -0.1527710026877632,     0.097705535252833195,    0.016264028090223169,    0.067219974952985095,
       0.18343450721652121,     0.17550155398218409,     -0.10195024998365286,    -0.1757475821433456,
       -0.0049186861967081292,  -0.033758256026594789,   0.10639691785310873,     -0.0020181749379921936,
       -0.19141910279812027,    0.12415598128664926,     0.067969243374710886,    -0.093076229126487872,
       -0.11530316035810004,    0.077954480069174784,    -0.047562294799216177,   0.13123476382636057,
       -0.092913101061701919,   -0.048383047263738377,   0.0032785759934207993,   0.10670234989595503,
       -0.21767722394551806,    -0.12304420797647392,    -0.098500313266995668,   -0.11603391210460483,
       -0.11333459607941448,    -0.068248180853906507,   0.018310494612120563,    0.062096721386770012,
       0.0018965797957231738,   -0.22579628581783653,    -0.08479660780851267,    -0.076760932350001296,
       0.12075493634509923,     -0.13387035465379041,    -0.11968132027802314,    -0.16382197397876114,
       0.082280485204171486,    -0.21232261941640146,    0.030294060726335278,    0.13347389376515817,
       0.04086570566585504,     0.042061354346124381,    0.044590027014414203,    -0.022016468382833051,
       0.21284684117787414,     0.049972491215666708,    -0.036322931250022603,   -0.061390997282415274,
       -0.066596158011456588,   -0.025825316466286302,   -0.11568181116226647,    0.068328553720898216,
       -0.11463087304940468,    0.1091311556964395,      0.0075082496561595553,   0.059939275123995134,
       0.0098004994680729249,   0.040172807305004291,    0.053018158382585778,    -0.16775903123923108,
       -0.067912990680476876,   -0.045869854403665831,   0.084306955588028309,    -0.16363701665684346,
       -0.093087643471988127,   -0.050773028775102938,   0.033358886714351166,    0.10865079170976018,
       0.088747703556036533,    -0.24156635055888953,    0.045749940778999888,    0.030925102459289203,
       -0.08124982809394489,    -0.10273446327938431,    0.015236157628363283,    -0.01560624520929205,
       -0.0066199182959511965,  -0.026390554170827751,   -0.085785703793129969,   -0.11359839802168679,
       0.12743414430724403,     -0.064655892284478822,   -0.12067380511219773,    -0.14304180266381239,
       -0.056902621406608921,   -0.047846105578290964,   -0.018474655521079356,   0.086043837288751229,
       -0.054775767593591304,   0.030261509203147727,    -0.075795844115126812,   -0.055056427918327905,
       -0.013802821240781063,   0.06287902866773469,     0.04173023113248199,     -0.11068069442000179,
       -0.04365954881380129,    -0.14313164116807045,    0.020440700446491707,    0.020047919619666101,
       0.18582615828628049,     0.085338285528572103,    -0.037258863159797949,   -0.25157862641806633,
       -0.028484937239125645,   0.065597230837877316,    0.073664799319905799,    0.12993353519602885,
       -0.023731075887820283,   0.030733659525150739,    -0.088506640473573289,   0.063904125239567802,
       -0.087587665190496364,   -0.11048222755968583,    -0.0081193477941594976,  -0.10959558537740974,
       0.07840186974089472,     -0.010982968101917838,   0.078760187108737709,    0.19211356585638867,
       -0.1356194738374045,     0.020131032858375624,    0.23792898545722488,     -0.011277342863459957,
       0.16583939519477114,     0.13135183417974708,     0.24244552028230965,     -0.12191689492762223,
       -0.07033657261625495,    0.078786737531900422,    -0.0041040509887763869,  -0.016251664251281876,
       -0.11026310775208831,    0.0089681267824301136,   0.031426280409243453,    0.061386546251011649,
       -0.098626666918453912,   -0.17387120994441391,    0.047788406155155977,    -0.055635537199704793,
       0.10540966873924644,     0.005456310635168049,    0.13764369886578318,     -0.048154175810860782,
       -0.071311578408004977,   -0.068135654840677615,   0.074546691270041529,    -0.097951416934859245,
       0.0099812492495882747,   -0.051528291718257312,   -0.08089798491168404,    -0.14317540350274602,
       0.039155986337141555,    -0.089621731950659159,   -0.12627386235709329,    -0.06581176569161129,
       -0.012232665647103777,   0.0011564231356028104,   0.19462384151756335,     0.098432728607380754,
       0.12553783499519625,     0.084204228709878121,    -0.088440270901647827,   -0.041824693297354026,
       -0.11349733627233989,    -0.036807507032502178,   -0.021015116974330519,   0.27339353990136611,
       0.12782278461177471,     -0.0091464309059367498,  0.17175806366371738,     0.18381501975432576,
       0.024201518505441281,    0.02614349832029339,     0.014217157194081724,    -0.13025928611339399,
       -0.1005483229230307,     0.12418352904415764,     0.028658194898544792,    -0.21190398685193854,
       0.010940361380515132,    0.024783586506953455,    -0.0020584064735766996,  0.033328820539640425,
       0.069970259835094875,    0.056731825111272345,    0.079538550161256938,    -0.025225510072037112,
       0.057658832196769552,    -0.12510027133627485,    -0.05513850133360447,    0.061454075455748519,
       0.074869354064141636,    0.064727126452481673,    -0.16100662808445296,    0.078942070840466755,
       0.015665752190474898,    0.025167864909680638,    -0.12944563221154212,    0.058911246174729821,
       0.043188380631761066,    -0.1304179819598964,     -0.007602610460238815,   -0.17180924003142628,
       -0.20052966552839285,    0.15104665369726908,     -0.046017541852474378,   0.053012510860090775,
       0.053235083845507174,    -0.048538060246848286,   -0.076074456582337052,   -0.010050069878364621,
       -0.048918134643833391,   0.14469126967446183,     -0.16701643476071637,    0.094149290469332458,
       -0.00094432073358493912, 0.067609601414154452,    0.052682674837429055,    0.084649317893922257,
       -0.011221463874479004,   0.032938363662159,       0.15011199924783211,     -0.091248764965109877,
       0.053549787517549338,    -0.00064012720957255798, 0.028839374817317576,    0.05299116879635949,
       0.18830512515077591,     -0.23183325003993471,    -0.095237040215381055,   0.066807903059490414,
       0.17085019959724981,     0.098715411141099024,    0.0021848494371533847,   0.038210948904962114,
       0.062313827683241507,    0.14155821553448808,     0.037736489308743959,    -0.012079575137481079,
       0.027351026948526036,    -0.13782663098682252,    -0.028961441251791138,   -0.003502856704556385,
       -0.027604047811105176,   -0.22370108855432611,    -0.091709028292968786,   -0.070639447332695268,
       -0.01770093082208804,    0.024467584612279301,    -0.1403483217703361,     0.011886990978760278,
       0.074860149909770607,    0.18497460381554079,     0.08684682918002945,     -0.19035487406943435,
       -0.013294366707850091,   -0.0010369157128370097,  0.20604541556543779,     0.04139276429162727,
       -0.023617362234654261,   -0.02382612747567571,    0.094184866853557078,    -0.050130458194564818,
       -0.032386451546054372,   0.048744930484557247,    0.091644047207710522,    -0.05398262512737783,
       -0.0179475935210083,     0.15029716046702937,     -0.062590767216072637,   -0.13944483778571026,
       -0.23721636912914351,    0.012948507599664191,    -0.051792145035529841,   -0.11288825204933306,
       -0.08198085496342869,    0.0038589507939481033,   0.085475124837607358,    -0.10476078750194055,
       0.1127766739745332,      -0.058439854790845881,   0.049738545794494542,    0.17554886040618153,
       0.13354370895026912,     -0.11092425499581608,    -0.01621908088788214,    -0.022825642564169576,
       -0.041183028473454029,   0.17642321885409823,     -0.17350664133281438,    0.069030030165750142,
       -0.11423802161239735,    0.10737493672492371,     0.0425571672586115,      0.047528261219317677,
       0.077979943170858143,    -0.028456564900684943,   0.13823358572205219,     0.014794949001846452,
       -0.058944325047194837,   -0.13804735112761407,    0.0065783704424048003,   0.09889697829820504,
       -0.069261524845466674,   -0.08016626017234274,    0.15916476617613901,     0.12247121096378037,
       -0.0037800260892748641,  -0.07562508082073699,    -0.16359920016636648,    -0.0040053068189927436,
       5.2775234389775298e-06,  0.093930091181411157,    0.028237412391156645,    -0.036155152458990043,
       -0.057003930205204625,   -0.028722579676892436,   0.037879548191079207,    0.19273750186798486,
       -0.050261787726473911,   -0.16389197692928442,    0.049970825520181061,    0.054969366804504649,
       -0.027644055243640227,   0.018491823232766068,    -0.14663630825575535,    -0.16919900756642392,
       0.092560409702192606,    0.0095197820841634705,   -0.21402204798739591,    0.075989317792643701,
       0.21707903847455892,     0.015947260818002518,    0.078596635098002063,    0.046613495037845606,
       -0.10703692582924107,    -0.039629496950635786,   -0.069552619258416867,   -0.18038619165079586,
       0.068323795502465368,    0.16400877947021703,     -0.038226210165718776,   -0.014039415787311228,
       -0.17542870011817083,    0.23946004650508437,     -0.0030821755635432099,  0.085809232775979377,
       0.0093737880324227217,   0.11398319061137024,     0.080026297270407387,    -0.11025779405136772,
       -0.17719217886452293,    0.063081941325776769,    0.003154384234011833,    0.088078856815374182,
       -0.1495954400926183,     0.018875874643493822,    -0.16685329740637472,    -0.027456927234346815,
       -0.11378506804734088,    -0.091745307368819182,   -0.067475473327552576,   -0.063617442778765881,
       -0.089799295376877308,   0.023112807083639206,    -0.018718773537153177,   0.0039118471186750147,
       -0.089540851947406117,   0.075278302919311868,    -0.059435368738961859,   0.15277086217284849,
       -0.10359863638802498,    -0.086523562533260309,   -0.02770886262511256,    -0.090663502409218194,
       -0.035109727380911115,   0.11486641260120965,     0.030814804898046361,    -0.010258215584249743,
       -0.021475423601833001,   0.041206474885458415,    0.15269777028593207,     -0.091696096073037567,
       -0.14646133599894096,    -0.14238729919693344,    -0.12278463353085431,    -0.058404444661298682,
       0.13960584922125649,     0.07485292533302651,     0.023753460701935701,    0.13948977995326742,
       -0.012536591842636818,   0.037442557351493995,    -0.10559755747363186,    -0.014678564846010739,
       -0.11925897943925871,    -0.13802613707555575,    -0.015666301762289336,   -0.1875582475996394,
       -0.050605155784185014,   -0.019353992280841191,   -0.014847292441089968,   0.094034007105508952,
       -0.083391366972256756,   0.036376667088378861,    -0.081251075611413121,   0.013139554387936724,
       0.058158397410029594,    0.03011865024593232,     0.0012710693810849909,   -0.10677102422545694,
       -0.11276664095983772,    -0.14099577285962137,    0.050787153734321473,    -0.023385369724367611,
       0.019087824469942862,    0.099231838271419057,    0.032754124718001806,    -0.12358507767784255,
       -0.14529330373311453,    0.046288238610768327,    -0.0075229892435538636,  -0.14166336315060826,
       0.00057249866220162107,  0.0056951466888107566,   0.18571194067717631,     -0.030660913766554221,
       0.030420137375631658,    0.1297157228064782,      -0.04565413049754094,    -0.089040482932369922,
       -0.018586606298784964,   -0.014598344085700984,   -0.018412123334874676,   -0.0055216711684285529,
       0.091475649690497984,    -0.0041499627283130792,  0.11147774157383164,     0.018906083965162551,
       -0.17882536199218535,    -0.086932579465502827,   -0.057466878129547753,   -0.15132416285623015,
       0.017679807695149909,    0.10860561130027463,     0.0021477725633637984,   0.017776556844838566,
       0.058579425700414745,    0.16725388532779245,     -0.076030553445406546,   0.10699444194836473,
       -0.1736285581177294,     -0.15436451169207666,    0.10766988296419357,     -0.10170437017946492,
       0.066575412147552068,    0.11934796836571421,     -0.05430537090199114,    0.093487611371114263,
       -0.15392505298647155,    0.15387753747060903,     -0.082541183855847036,   0.055036438002289891,
       -0.079823727543933187,   -0.010317387945799833,   -0.13949370726812879,    -0.030496036682063233,
       -0.059774734662307649,   -0.017227619500072334,   -0.022116591033802604,   -0.035449256669687186,
       0.11647145590700583,     -0.1137851627396833,     0.090403631827432496,    -0.052993659784399127,
       0.045352679804024493,    0.046396766675242042,    -0.057323600774751973,   -0.070017501824297543,
       -0.086653680323376142,   0.01840647967717288,     0.12405045712314086,     0.13363512959828505,
       -0.29463115902347092,    0.10100204398626587,     -0.070845299100649933,   0.021245029066675525,
       -0.17331983212469446,    -0.023452683418132222,   -0.13213537922303661,    0.03504594554105564,
       -0.099722369294272833,   0.11347422100303589,     -0.015547995130142057,   0.057396127332061439,
       0.25969937482411437,     -0.28539248728846944,    0.042110014726303817,    -0.10952521927580998,
       0.06128594620724561,     -0.038975742920352392,   -0.071296306825324882,   0.11568602185246774,
       -0.066130559634185071,   -0.17462869597089059,    0.089476336346239221,    0.072999095046996892,
       -0.096506841019372486,   0.00057933667441461688,  -0.15561822768523914,    -0.15022761742130164,
       0.21904302127684289,     -0.016512480649622224,   0.11434224792277951,     0.1386190125912812,
       -0.064087982344366301,   0.059495943238309673,    0.18147088109117876,     -0.041963713649906649,
       0.02456454265699658,     -0.13211645126856117,    -0.14754288293953219,    0.084504877043146895,
       0.01607539130145446,     -0.050574630654794894,   0.083853509953811328,    0.027555512781677404,
       -0.014495403177653547,   0.081547270299963545,    0.1516728088186593,      0.0042485713275592406,
       0.074947700085700911,    0.21264576919982278,     -0.033522618780004412,   0.079402688675853636,
       -0.013281492042817257,   0.010311803324049814,    0.050875652221678856,    0.0016741330450374772,
       -0.0042052291616180432,  0.0070653329734856477,   0.048258544889785315,    0.15177292958118374,
       0.045737631260053112,    -0.25878061771773508,    0.14223471869597409,     -0.037467995500748384,
       0.058904836431764328,    0.22798430264163541,     0.048702967597523718,    0.023998372214989419,
       0.096631021613332244,    0.093562200547699717,    0.030552698977195123,    0.10773638419350903,
       0.03167690410100666,     -0.20352327955305277,    0.032430796531324364,    -0.15242687176300126,
       -0.13114941010243081,    0.01519684405498466,     -0.055399586078186409,   0.30358691554750739,
       0.010647253107924472,    -0.062275830273978185,   -0.00083568465455628965, 0.044373655932584105,
       -0.065727103691155489,   0.18644853785924467,     -0.010128289281977483,   -0.00097744966161489246,
       0.12410261408203239,     0.038982003506777767,    -0.073705955454449815,   -0.01716668764175883,
       -0.018788362879048146,   0.098679581022560678,    -0.084087746612826683,   -0.17904616958912412,
       0.17857232645565591,     0.027595731142554477,    -0.10698516727675092,    -0.027299214257535582,
       -0.056393064745109793,   -0.02138417178950219,    0.088786076372168551,    0.084277977231712875,
       0.014131929204106802,    -0.054618424474421959,   -0.087654360841861567,   -0.056832573295209139,
       0.029354778889692817,    0.14373519509176785,     -0.031850123910419727,   -0.042322002218210419,
       -0.014751449130582277,   -0.11589267920278849,    -0.052037980447498057,   -0.020511183407466462,
       -0.0012618668045992461,  0.042305888037642625,    -0.039029654081823184,   -0.026414106192796549,
       0.003203912684724709,    0.031737286411379018,    -0.0073313351858454896,  -0.13604160609904781,
       0.032095252373039194,    -0.14186645342673834,    -0.024971586031079872,   0.03576905439734468,
       0.080554230404724328,    -0.048163855986395887,   0.15654000049344183,     0.064486363699800778,
       0.012661094554916775,    0.117309121256475,       -0.088679724513980304,   0.13520827769860577,
       0.068218785143713837,    0.061806653976529777,    -0.030847863133651725,   -0.050212838030549267,
       0.082279113063229797,    -0.049775541488572245,   0.14132095113264961,     0.19982565978739988,
       -0.024312163638055169,   -0.042155718004259796,   0.14680911646481298,     -0.26748917466357036,
       0.012320961352708722,    0.16149836171061885,     -0.14250392175226304,    -0.0067322545049100513,
       -0.061287000512992525,   -0.1049917809031358,     0.049826947021861634,    -0.089340254368746291,
       0.098517485754604284,    0.018557991935531138,    -0.086137214647156415,   -0.012525704026289185,
       -0.11919022222051082,    -0.035472814944754717,   0.16953474687712744,     -0.067581436334329489,
       0.057900795392638676,    -0.079047990876855656,   0.10461237679112878,     -0.057698948843512975,
       -0.18479168787108857,    0.050530024206340132,    -0.079711145364812996,   0.11413112854794097,
       0.33539568828746613,     0.14796546285393591,     0.027811197247917828,    0.068094438866301357,
       -0.067438070024103958,   -0.21323694610046143,    0.044794936412809516,    0.0096281754984882187,
       -0.11350909373708565,    -0.021742537179516231,   0.032011509412333022,    -0.12501336022631299,
       0.12479999151683489,     0.028921207235852297,    0.093733962498626144,    0.043368008272283126,
       -0.13159127202453089,    -0.086124143987571386,   0.026499221454990778,    -0.037873915777066745,
       -0.076420009354138799,   0.10052631900498255,     0.086127552852265907,    0.13566298506004004,
       -0.040584776731746416,   -0.12681632512510702,    -0.091344587025015023,   -0.078010935991419894,
       0.04108577925062127,     -0.072602502018982093,   -0.12063197090854531,    -0.10538366246932801,
       -0.19100007588840237,    0.021557889251666074,    0.026250998538388422,    0.00019810858938263537,
       0.14933388678743204,     -0.016346808942737566,   -0.050174633719864761,   -0.10474674350270367,
       0.045889991438148738,    -0.031499254325157898,   0.061397043319562861,    -0.11317883565040389,
       -0.026193377862421326,   -0.067382318384808695,   0.00457371817923574,     0.063552943419758687,
       -0.0568573553383349,     -0.0092244374246553129,  0.1292441861152242,      -0.25183278349162491,
       0.024965596290255229,    -0.17097943654341161,    -0.11649381913580643,    -0.013737357733661431,
       -0.080213198565730254,   0.14320244760371381,     -0.077581571400388807,   -0.03448201344573331,
       0.0047199160750183156,   -0.052188441109366122,   -0.12380276726842204,    -0.087324923762409051,
       0.033029030705395521,    0.14200049779031709,     -0.064878772979801366,   -0.081299388266447073,
       -0.052761896516407225,   -0.07221027329336635,    -0.030716169193379703,   0.039709393435066909,
       -0.059228322076659207,   0.0012684642752164217,   0.12168910076248551,     0.037634567271561226,
       0.054824010214814076,    0.037178109214198285,    -0.020334728986187555,   0.070063077217514022,
       -0.17776000272493439,    -0.068784379259375347,   -0.13259146520325754,    0.17088050804165689,
       -0.10429809559832751,    0.11700519574077367,     0.08899414913790793,     -0.11372033645296635,
       -0.067136329438854725,   0.11193686560217983,     -0.081331446589522904,   -0.02440986066086202,
       -0.14704815157523543,    0.021148446762319268,    -0.058996148010895401,   -0.068571572453536733,
       0.049783427459724763,    0.05732000845546411,     0.051578537967564293,    -0.064466472815478543,
       0.11087872499001944,     0.065426749344698151,    0.10090219585746843,     -0.17998246253711356,
       -0.11019473001365841,    -0.032626193531663482,   -0.15335525320471421,    0.089421656825051932,
       -0.041442914133197284,   -0.20009468297047994,    -0.0001954134309506034,  -0.12668215333797092,
       0.048844138279402038,    -0.10307901232078635,    0.10629608099972124,     -0.11674715395318168,
       0.10921137346940478,     0.076441147400260784,    -0.017695325953793722,   -0.11343355823562684,
       0.048713152729053862,    -0.018718167878867615,   0.10776491988854203,     -0.079623024590155217,
       0.033231409889864311,    0.016267307870482379,    0.0096915951390533703,   -0.19283502465240474,
       -0.081250333918361964,   0.11462657168648029,     0.022683743380081983,    0.095682617384574314,
       0.18496139566253894,     0.0047463229807031644,   -0.032621941034217672,   0.10232968199207358,
       -0.023765884659356196,   0.032209166632149566,    0.089624776467647202,    0.20383345084043811,
       -0.00035767340548607991, 0.025159012631662633,    -0.078707596057933552,   0.015003554611165386,
       -0.093590507337421455,   -0.33517040954582278,    -0.032169269929536878,   0.0024921463613130201,
       0.14732157674358945,     0.028699995436116201,    -0.051345362400714162,   0.020841427228986679,
       -0.13126580789671874,    -0.10313474997461845,    -0.063550989883600195,   -0.057854538308757759,
       -0.15215792179735038,    -0.055578975287109922,   0.013169083595054884,    -0.014657260221233972,
       0.16720948918802089,     0.15035425760179486,     -0.018499112096298113,   0.013473216112418392,
       0.087084507974872952,    -0.18898740245131201,    0.16727670974495937,     -0.022576283110048577,
       0.020916635433583304,    -0.023417414508192767,   -0.063577937802729273,   0.080511825163247328,
       0.16440248033730681,     0.1133168011920123,      0.042284952406507592,    0.21784408234013092,
       0.13369614840512689,     0.0091137449304465219,   0.04239465651586944,     0.10384869968031367,
       0.020231852536570217,    -0.11384569792104285,    -0.15382756760451619,    -0.086125847451714782,
       0.098234713552923306,    -0.084961871037488423,   0.16444821806095697,     -0.0094304781520994849,
       0.036698444831830566,    -0.12761730697368237,    0.12990048955999819,     -0.024760788391175757,
       -0.09657640835826091,    0.036795681561913381,    0.15013258863588091,     -0.00094355112078332642,
       0.011003777337531728,    -0.023084534859045804,   -0.0061106284877543602,  -0.16233140209174093,
       0.11683640876951296,     0.17941036534935428,     -0.11312586503426399,    -0.089981340819764541,
       0.22071880684963921,     0.051974168140120978,    0.063946211377054168,    0.04961961022567974,
       -0.033164653988609329,   0.12587345744466055,     -0.1063480319465797,     -0.0020096613339532468,
       0.0086697565322619193,   -0.087432167408771577,   -0.064036910617757445,   -0.055902891681435134,
       0.038172736224586723,    -0.018036490662936559,   0.036821266134428439,    0.076434880651078452,
       -0.014239357125336116,   0.11710734647537417,     0.038809157667995829,    -0.0662578522607397,
       -0.074432456869222299,   -0.12167939516511403,    -0.096457554121674713,   -0.074011894057657887,
       -0.21114658704750741,    -0.13713108548783101,    0.041959414465230958,    0.13269232526633015,
       -0.017992764480288751,   0.10433710863362571,     0.053426026317760569,    -0.15152134248693017,
       -0.12319918398729479,    -0.11163624508633502,    0.13401243674810567,     0.012121921525432554,
       0.051995458959405973,    0.0990195075688622,      0.04882151451395543,     -0.058239930914185466,
       -0.0023843610285590798,  -0.026113931926541423,   -0.22773645423177252,    -0.080324160742911502,
       0.040757317419520815,    -0.0036375358127629935,  -0.04787722845122383,    0.04265966379412281,
       0.13716192575314373,     -0.089489723075488067,   -0.051839290477647793,   0.014283940166405688,
       -0.056372214444966262,   0.075088563845485262,    -0.076951717541099737,   -0.01955899415653891,
       0.12045670835546525,     0.064342479499232025,    0.015554072060161225,    -0.003987844749599137,
       -0.076410997439653114,   0.019216191000159453,    0.10267138503998341,     0.05553887744130407,
       -0.061506683990512942,   -0.063873817442393441,   -0.070204373389340088,   0.053438775001137327,
       -0.05650628726195784,    0.10968003662961369,     -0.12199328411605703,    -0.021347288540609629,
       -0.17325208393077979,    0.02599157667780053,     0.097434484618498879,    0.0082557915058199399,
       0.019642534657382724,    -0.00038913455411076418, 0.12934411260329601,     0.0049874431503977735,
       0.17699585958837732,     -0.006614317316782894,   -0.18888077495607009,    0.2549173278898203,
       -0.017385739761767563,   0.05868406742936539,     0.1550111300388432,      -0.021599156442327756,
       -0.1785626363519861,     -0.12477833960425953,    -0.21759013351067163,    -0.015459891800133256,
       -0.076881364596438323,   0.039264383102785252,    -0.15559280614268664,    -0.035273493366231527,
       0.091142261705016367,    -0.096067882998512669,   0.071421992412932456,    0.037816083651377425,
       0.021830883288390238,    0.08662313203094