#
# PySNMP MIB module COFFEE-POT-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/COFFEE-POT-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:07:06 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueRangeConstraint, ValueSizeConstraint, ConstraintsUnion, SingleValueConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueRangeConstraint", "ValueSizeConstraint", "ConstraintsUnion", "SingleValueConstraint", "ConstraintsIntersection")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( Counter64, MibIdentifier, TimeTicks, ObjectIdentity, Unsigned32, NotificationType, Bits, Gauge32, Integer32, transmission, IpAddress, MibScalar, MibTable, MibTableRow, MibTableColumn, Counter32, iso, ModuleIdentity, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter64", "MibIdentifier", "TimeTicks", "ObjectIdentity", "Unsigned32", "NotificationType", "Bits", "Gauge32", "Integer32", "transmission", "IpAddress", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Counter32", "iso", "ModuleIdentity")
( TextualConvention, TimeInterval, DisplayString, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "TimeInterval", "DisplayString", "TimeStamp")
coffee = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 132))
if mibBuilder.loadTexts: coffee.setLastUpdated('9803231700Z')
if mibBuilder.loadTexts: coffee.setOrganization('Networked Appliance Management Working Group')
if mibBuilder.loadTexts: coffee.setContactInfo('        Michael Slavitch\n                        Loran Technologies,\n                        955 Green Valley Crescent\n                        Ottawa, Ontario Canada K2A 0B6\n\n                   Tel: 613-723-7505\n                   Fax: 613-723-7209\n                E-mail: slavitch@loran.com')
if mibBuilder.loadTexts: coffee.setDescription('The MIB Module for coffee vending devices.')
potName = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: potName.setDescription('The vendor description of the pot under management')
potCapacity = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: potCapacity.setDescription('The number of units of beverage supported by this device\n            (regardless of its current state) .')
potType = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("automatic-drip", 1), ("percolator", 2), ("french-press", 3), ("espresso", 4),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: potType.setDescription('The brew type of the coffee pot.')
potLocation = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: potLocation.setDescription('The physical location of the pot in question')
potMonitor = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 132, 6))
potOperStatus = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 6, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("off", 1), ("brewing", 2), ("holding", 3), ("other", 4), ("waiting", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: potOperStatus.setDescription('The operating status of the pot in question. Note\n                 that this is a read-only feature. Current hardware\n                 prevents us from changing the port state via SNMP.')
potLevel = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 6, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: potLevel.setDescription('The number of units of coffee under management. The\n                 units of level are defined in potMetric below.')
potMetric = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 6, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("espresso", 1), ("demi-tasse", 2), ("cup", 3), ("mug", 4), ("bucket", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: potMetric.setDescription('The vendor description of the pot under management')
potStartTime = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 6, 4), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: potStartTime.setDescription('The time in seconds since Jan 1 1970 to start the pot\n                if and only if potOperStatus is waiting(5)')
lastStartTime = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 6, 5), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: lastStartTime.setDescription('The amount of time, in TimeTicks, since the coffee\n               making process was initiated.')
potTemperature = MibScalar((1, 3, 6, 1, 2, 1, 10, 132, 6, 6), Integer32()).setUnits('degrees Centigrade').setMaxAccess("readonly")
if mibBuilder.loadTexts: potTemperature.setDescription('The ambient temperature of the coffee within the pot')
mibBuilder.exportSymbols("COFFEE-POT-MIB", potLocation=potLocation, potLevel=potLevel, potType=potType, PYSNMP_MODULE_ID=coffee, potMonitor=potMonitor, coffee=coffee, potStartTime=potStartTime, potTemperature=potTemperature, potMetric=potMetric, potName=potName, potOperStatus=potOperStatus, potCapacity=potCapacity, lastStartTime=lastStartTime)
