/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : etc.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __ETC_H__
#define __ETC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
	struct ColorDat {
		long rgb;
		int red;
		int green;
		int blue;
	};

#define CHARSET_UTF8    5
#define CHARSET_LOCALE  0


/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _ETC_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL FILE *stream_log;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _ETC_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* 文字列 str の中の n番目にある split_word の位置を返す */
int split_word_point(char *str, char spilt_word, int n);
/* 文字列 str の中に split_word が何個あるかを返す */
int split_word_num(char *str, char spilt_word);
/* 文字列 str の左から num 文字を取り出して文字列 ret に入れて返す */
int strLeft(char *str, int num, char *ret);
/* 文字列 str の左から mid番目から num文字を取り出して文字列 ret に入れて返す */
int strMid(char *str, int mid, int num, char *ret);
/* 文字列 str の右から num 文字を取り出して文字列 ret に入れて返す */
int strRight(char *str, int num, char *ret);
/* スプリット文字 (split_word) で区切られて、データが並んでいる文字列 (str) の
 * num 番目のデータ文字列を取り出して文字列 (ret) に入れて返す */
int LineDataSplit(char *str, char split_word, int num, char *ret);


/* String UTL */
void replace(char *text, char *key, char *rep);
char *search(char *text, char *key);
int ltrim(char *str, char *ret);


/* path string UTL */
/* フルパス名からファイル名を取得する */
char *getFileName(char *lpszPath);
/* ファイル名から拡張子を取り除く */
void cutExtName(char *lpszFileName);
/* パス名からファイル名を取り除く */
void cutFileName(char *lpszPath);
int GetAppPath(char *App_Path);


/* File UTL */
int write_locale_from_utf8(char *str, FILE *stream, int code);
int read_utf8_from_locale(FILE *stream, char *str, int code);
int LineRead(FILE *stream, char *ret);


/* color UTL */
int color_split(struct ColorDat *a);
long color_rgb(struct ColorDat *a);
long color_rb_change(long rgbcol);
int atoi16(char *str);
int hextoint(char *str);
int HexString(long data, char *hex);

int LogFileOpen(char *str);
int LogFileWrite(char *str);
int LogFileClose(void);

int OneShotLog(char *str);
int DeleteOneShotLog(void);

int GetConfigPath(char *path);
void home_of_user(char *home);
void name_of_user(char *user);

/* 文字列のコード変換 */
char *p_sag_iconv(char *from_str, char *from_code, char *to_code);
int sag_iconv(char *from_str, char *to_str, char *from_code, char *to_code);
char *conv_iconv(const char *from_str, const char *from_code, const char *to_code);
/* UTF-8 の１文字の１バイト目から１文字のバイト数を返す */
int utf8_bite_num(char c);




#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __ETC_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : etc.h
 * ====================================================================
 */
