---
title: 0.240.0 Breaking Changes
slug: breaking-changes/0.240.0
---

# v0.240.0 updates `Schema.subscribe`'s signature

In order to support schema extensions in subscriptions and errors that can be
raised before the execution of the subscription, we had to update the signature
of `Schema.subscribe`.

Previously it was:

```python
async def subscribe(
    self,
    query: str,
    variable_values: Optional[Dict[str, Any]] = None,
    context_value: Optional[Any] = None,
    root_value: Optional[Any] = None,
    operation_name: Optional[str] = None,
) -> Union[AsyncIterator[GraphQLExecutionResult], GraphQLExecutionResult]:
```

Now it is:

```python
async def subscribe(
    self,
    query: Optional[str],
    variable_values: Optional[Dict[str, Any]] = None,
    context_value: Optional[Any] = None,
    root_value: Optional[Any] = None,
    operation_name: Optional[str] = None,
) -> Union[AsyncGenerator[ExecutionResult, None], PreExecutionError]:
```
