/*******************************************************************************
 * Copyright (C) 2004-2008 Intel Corp. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       ZTCLocalAgent.h
//
//----------------------------------------------------------------------------

#ifndef _LOCAL_AGENT_H
#define _LOCAL_AGENT_H

#include "resource.h"
#include "StatusCodeDefinitions.h"
#include "WD_if.h"
#include "Utils.h"
#include "PTHICommand.h"
#include "Types.h"

/*
 * Constants
 */
#define AMT_TRUE                        1
#define AMT_FALSE                       0
#define STATE_INDEPNDENCE_CMD           0x5
#define STATE_INDEPNDENCE_BYTE_COUNT    0x2
#define STATE_INDEPNDENCE_ENABLED       0x51
#define STATE_INDEPNDENCE_VERSION       0x10
#define STATE_INDEPNDENCE_CHANGE_TO_AMT 0x52

typedef struct _ztcLocalState {
	bool newCode;
	bool mayBeStarted;
} ZtcLocalState;


/*
* Function prototypes
*/
UINT32 DiscoveryTest(PTHICommand &command, LOCAL_AGENT_PARAMS param, ZtcLocalState &lState);
VOID DisplayLocalAgentVersion();
bool ChangeToAMT();
UINT32 Activate(PTHICommand &command, LOCAL_AGENT_PARAMS param, ZtcLocalState &lState);
bool ReInitPTHI(PTHICommand &command);
bool IsNewCode(CODE_VERSIONS &versions);

#endif

